  C***	TITLE	spl$pertests     C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.      C++
  C FACILITY:	   C		lngspl - DECspell   C  C ABSTRACT:  C)  C		Performance suite tests for DECspell    C	   C ENVIRONMENT: 9  C	VAX/VMS V3.5  FORTRAN module file.  Non-transportable.   C1  C AUTHOR: Cathy Baker		CREATION DATE:  24-FEB-84   C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C$  C X01.01	Cathy		24-FEB-84 	Original  C  C--     @  	INTEGER*4 FUNCTION lngspl$per_masini (it_count, user_mem_size)     C++  C    FUNCTIONAL DESCRIPTION:   C.  C	Tests performance of initializing verifier.I  C       Calls shareable library routines lngspl$initialize_verifier and  @  C	lngspl$terminate_verifier 'it_count' times, initializing the ;  C	American English dictionary. Initializes a default user  !  C	dictionary of 'user_mem_size'.   CB  C	Sets the stop clock going before the test loop, and stops and    C	prints the times after it.   C  C    CALLING SEQUENCE:   C5  C	status.wlc.v = lngspl$per_masini (it_count.rlu.r,    C					  user_mem_size.rlu.r )  C  C    FORMAL PARAMETERS:  C:  C	it_count	Integer specifying how many times to call the   C			routines being tested. C  C	user_mem_size	Integer specifying size of default user memory in    C			longwords.   C  C    IMPLICIT INPUTS:  C  C	None.  C  C    IMPLICIT OUTPUTS:   C  C	None   C  C    ROUTINE VALUE:  C  C	LNGSPL$_COMPLETED  /  C	LNGSPL$_FAIL		- if a test parameter invalid. ?  C	OR: failure status from the appropriate routine that failed.   C  C    SIDE EFFECTS:   C  C	None   C--     C***	Declarations     C	IMPLICIT	INTEGER*4	(a-z)    #  	INTEGER*4	it_count, user_mem_size 5  	INTEGER*4	lngper$prc_info			! Timer/printer routine 2  	INTEGER*4	lngspl$per_itct_error		! Check routine,  	INTEGER*4	lngspl$per_size_error		!       "5  	INTEGER*4	lngspl$initialize_verifier	! Test routine /  	INTEGER*4	lngspl$terminate_verifier	!       "   			$  	COMMON 		/ user_mem / user_memory   	INTEGER*4	user_memory(32768)     	EXTERNAL	lngspl$_completed     C+ $  C Check validity of test parameters  C- 6  	lngspl$per_masini = lngspl$per_itct_error (it_count)$  	IF (.NOT.lngspl$per_masini) RETURN   <  	lngspl$per_masini = lngspl$per_size_error (user_mem_size)	$  	IF (.NOT.lngspl$per_masini) RETURN     C+   C Start Clock  C- 0  	lngspl$per_masini = lngper$prc_info (.false.)	$  	IF (.NOT.lngspl$per_masini) RETURN     C+ *  C LOOP : calling routines to be tested...  C-   	DO 100 i=1,it_count    1  	lngspl$per_masini = lngspl$initialize_verifier  '       &	    ('LNGSPLAED', 'LNGSPLAEM',  0       &			corr_flag, user_mem_size, user_memory)$  	IF (.NOT.lngspl$per_masini) RETURN  	3  	lngspl$per_masini = lngspl$terminate_verifier ()	 )  	    					! If initialization succeeds,    						! this succeeds.   C+   C END OF LOOP  C-    100	CONTINUE     C+   C Stop clock, print results.   C- .  	lngspl$per_masini = lngper$prc_info (.true.)           IF (lngspl$per_masini) 4       &		lngspl$per_masini = %loc(lngspl$_completed)     	RETURN  	END 	! of lngspl$per_masini         @  	INTEGER*4 FUNCTION lngspl$per_usrini (it_count, user_mem_size)     C++  C    FUNCTIONAL DESCRIPTION:   C2  C	Tests performance for initializing user memory.L  C       Calls shareable library routines lngspl$initialize_user 'it_count' =  C	times, initializing the user memory to the size specified.   C  C    CALLING SEQUENCE:   C5  C	status.wlc.v = lngspl$per_usrini (it_count.rlu.r,    C					  user_mem_size.rlu.r)   C  C    FORMAL PARAMETERS:  C:  C	it_count	Integer specifying how many times to call the   C			routines.C  C	user_mem_size	Size in longwords of the user memory to initialize   C  C    IMPLICIT INPUTS:  C  C	None.  C  C    IMPLICIT OUTPUTS:   C  C	None   C  C    ROUTINE VALUE:  C	LNGSPL$_COMPLETED  0  C	LNGSPL$_FAIL - if a test parameter is invalid1  C	Failure status from called routine that fails. ;  C	NB: If the TESTED routine fails, the program falls over.   C  C    SIDE EFFECTS:   C  C	None   C--     C***	Declarations     C	IMPLICIT	INTEGER*4	(a-z)    #  	INTEGER*4	it_count, user_mem_size 5  	INTEGER*4	lngper$prc_info			! Timer/printer routine 2  	INTEGER*4	lngspl$per_itct_error		! Check routine,  	INTEGER*4	lngspl$per_size_error		!       "5  	INTEGER*4	lngspl$initialize_user		! Tested routine.   			$  	COMMON 		/ user_mem / user_memory   	INTEGER*4	user_memory(32768)     	EXTERNAL	lngspl$_completed         C+ $  C Check validity of test parameters  C- 6  	lngspl$per_usrini = lngspl$per_itct_error (it_count)$  	IF (.NOT.lngspl$per_usrini) RETURN   <  	lngspl$per_usrini = lngspl$per_size_error (user_mem_size)	$  	IF (.NOT.lngspl$per_usrini) RETURN     C+   C Start Clock  C- 0  	lngspl$per_usrini = lngper$prc_info (.false.)	$  	IF (.NOT.lngspl$per_usrini) RETURN     C+ )  C LOOP : calling routine to be tested...   C-   	DO 100 i=1,it_count    ?  	lngspl$per_usrini = lngspl$initialize_user 	     ! Can't fail '       &				(user_mem_size, user_memory)      C+   C END OF LOOP  C-    100	CONTINUE     C+    C Stop clock and print results.  C- .  	lngspl$per_usrini = lngper$prc_info (.true.)           IF (lngspl$per_usrini) 4       &		lngspl$per_usrini = %loc(lngspl$_completed)     	RETURN  	END 	! of lngspl$per_usrini         '  	INTEGER*4 FUNCTION lngspl$per_usrloa  3       &				(it_count, user_mem_size, user_dict_nam)      C++  C    FUNCTIONAL DESCRIPTION:   C-  C	Tests performance for loading user memory. E  C       Calls shareable library routines lngspl$initialize_user and  D  C	lngspl$load_user_disk 'it_count' times, initializing and loading D  C	the user memory to the size specified, with the contents of file    C	specified by 'user_dict_nam'.  C:  C	The actual load time must be calculated by running the F  C	initalization only test (usrini) and subtracting the time for that #  C	test from the time for this one.   C  C    CALLING SEQUENCE:   C5  C	status.wlc.v = lngspl$per_usrloa (it_count.rlu.r,    C					  user_mem_size.rlu.r,   C					  user_dict_nam.rt.dx)   C  C    FORMAL PARAMETERS:  C:  C	it_count	Integer specifying how many times to call the   C			routines.C  C	user_mem_size	Size in longwords of the user memory to initialize   CE  C	user_dict_nam	Descriptor for the name of the user dictionary file.   C  C    IMPLICIT INPUTS:  C  C	None.  C  C    IMPLICIT OUTPUTS:   C  C	None   C  C    ROUTINE VALUE:  C	LNGSPL$_COMPLETED  0  C	LNGSPL$_FAIL - if a test parameter is invalid2  C	Failure status from one of the tested routines.  C  C    SIDE EFFECTS:   C  C	None   C--     C***	Declarations     C	IMPLICIT	INTEGER*4	(a-z)    #  	INTEGER*4	it_count, user_mem_size   	CHARACTER*(*)	user_dict_nam 5  	INTEGER*4	lngper$prc_info			! Timer/printer routine 2  	INTEGER*4	lngspl$per_itct_error		! Check routine,  	INTEGER*4	lngspl$per_size_error		!       "8  	INTEGER*4	lngspl$load_user_disk		! Routine for testing9  	INTEGER*4	lngspl$initialize_user		! Routine for testing   			$  	COMMON 		/ user_mem / user_memory   	INTEGER*4	user_memory(32768)  	INTEGER*4	word_count     	EXTERNAL	lngspl$_completed         C+ $  C Check validity of test parameters  C- 6  	lngspl$per_usrloa = lngspl$per_itct_error (it_count)$  	IF (.NOT.lngspl$per_usrloa) RETURN   <  	lngspl$per_usrloa = lngspl$per_size_error (user_mem_size)	$  	IF (.NOT.lngspl$per_usrloa) RETURN     C+   C Start Clock  C- 0  	lngspl$per_usrloa = lngper$prc_info (.false.)	$  	IF (.NOT.lngspl$per_usrloa) RETURN        C+ )  C LOOP : calling routine to be tested...   C-   	DO 100 i=1,it_count    @  	lngspl$per_usrloa = lngspl$initialize_user 	     ! Can't fail.'       &				(user_mem_size, user_memory)    ,  	lngspl$per_usrloa = lngspl$load_user_disk 3       &				(user_dict_nam, user_memory, word_count) "  	IF (.NOT.lngspl$per_usrloa) THEN  	    WRITE(6,1) word_count 9   1	FORMAT(/' Number of words loaded before failure: ',I)   	    RETURN  	ENDIF      C+   C END OF LOOP  C-    100	CONTINUE     C   C Stop clock and print results.  C.  	lngspl$per_usrloa = lngper$prc_info (.true.)           IF (lngspl$per_usrloa) 4       &		lngspl$per_usrloa = %loc(lngspl$_completed)     	RETURN  	END 	! of lngspl$per_usrloa         '  	INTEGER*4 FUNCTION lngspl$per_masver  %       &				(it_count, words_file_nam)      C++  C    FUNCTIONAL DESCRIPTION:   CD  C	Tests performance for verifying against master memory. Loads the B  C	words from 'words_file_nam' into an in-memory test table, then B  C	loops round verifying these words 'it_count' times against the   C	master dictionary only.  C  C    CALLING SEQUENCE:   C5  C	status.wlc.v = lngspl$per_masver (it_count.rlu.r,    C					  words_file_nam.rt.dx)  C  C    FORMAL PARAMETERS:  C:  C	it_count	Integer specifying how many times to call the   C			routines.A  C	words_file_nam	Descriptor for the name of the file containing    C			the words to be verified.  C  C    IMPLICIT INPUTS:  C  C	None.  C  C    IMPLICIT OUTPUTS:   C  C	None   C  C    ROUTINE VALUE:  C	LNGSPL$_COMPLETED  0  C	LNGSPL$_FAIL - if a test parameter is invalid2  C	Failure status from one of the tested routines.  C  C    SIDE EFFECTS:   C  C	None   C--     C***	Declarations     C	IMPLICIT	INTEGER*4	(a-z)      	INTEGER*4	it_count    	CHARACTER*(*)	words_file_nam5  	INTEGER*4	lngper$prc_info			! Timer/printer routine	2  	INTEGER*4	lngspl$per_itct_error		! Check routine;  	INTEGER*4	lngspl$per_testfile_ini		! Initialize table of e  							! test words routine:  	INTEGER*4	lngspl$initialize_verifier	! Initalize routine6  	INTEGER*4	lngspl$verify_word_master	! Tested routine9  	INTEGER*4	lngspl$terminate_verifier	! Terminate routinep   $  	COMMON 		/ user_mem / user_memory   	INTEGER*4	user_memory(32768)6  	PARAMETER	user_mem_size = 4096		! User mem not used   	 						! in this test.  	PARAMETER	max_words = 50$  	CHARACTER*32	test_table(max_words)  	INTEGER*4	words_addeda   #  	LOGICAL*1	corr_flag, user_flag			m  	INTEGER*4	hyphen_map  	  	EXTERNAL	lngspl$_completed      U  C+T)  C Check validity of parameter 'it_count't  C-e6  	lngspl$per_masver = lngspl$per_itct_error (it_count)$  	IF (.NOT.lngspl$per_masver) RETURN  U  C+T   C Initialization for this test.  C-   	corr_flag = .false. 1  	lngspl$per_masver = lngspl$initialize_verifier  -       &	    		   ( 'LNGSPLAED', 'LNGSPLAEM', V6       &			      corr_flag, user_mem_size, user_memory)$  	IF (.NOT.lngspl$per_masver) RETURN  4.  	lngspl$per_masver = lngspl$per_testfile_ini 7       &			   ( words_file_nam, test_table, words_added)n$  	IF (.NOT.lngspl$per_masver) RETURN  N2  	user_flag = .false.		! Don't use the user memory  					! during verification	  C+   C Start Clock  C-n0  	lngspl$per_masver = lngper$prc_info (.false.)	$  	IF (.NOT.lngspl$per_masver) RETURN  e  C+r)  C LOOP : calling routine to be tested...u  C-i  	DO 100 i=1,it_count   A  	    DO 150 j=1,words_added  a8   150	    lngspl$per_masver = lngspl$verify_word_master        &				( test_table(j),g       &				  user_memory,a       &				  user_flag,        &				  hyphen_map )C     C+N  C END OF LOOP  C-s   100	CONTINUE  l  C   C Stop clock and print results.  C.  	lngspl$per_masver = lngper$prc_info (.true.)        C+_  C Terminate the test   C-m3  	lngspl$per_masver = lngspl$terminate_verifier ()	   u  	RETURN  	END 	! of lngspl$per_masvere  l  s  m  &  	INTEGER*4 FUNCTION lngspl$per_usrverB       &	  (it_count, user_mem_size, user_dict_nam, words_file_nam)     C++  C    FUNCTIONAL DESCRIPTION:P  CB  C	Tests performance for verifying against user memory. Loads the G  C	user dictionary with words from 'user_dict_nam', and the test table EF  C 	with words from 'words_file_nam'. Loops round verifying the words >  C	in the test table 'it_count' times against the user memory.  C  C    CALLING SEQUENCE:i  C5  C	status.wlc.v = lngspl$per_usrver (it_count.rlu.r, C  C					  user_mem_size.rlu.r,l  C					  user_dict_nam.rt.dx,N  C					  words_file_nam.rt.dx)  C  C    FORMAL PARAMETERS:  C:  C	it_count	Integer specifying how many times to call the   C			routines.C  C	user_mem_size	Size in longwords of the user memory to initialize   CE  C	user_dict_nam	Descriptor for the name of the user dictionary file.   CF  C	words_file_nam	Descriptor for the name of the test file containing   C			the words to be verified.  C    IMPLICIT INPUTS:  C  C	None.  C  C    IMPLICIT OUTPUTS:   C  C	NoneS  C  C    ROUTINE VALUE:  C	LNGSPL$_COMPLETED  0  C	LNGSPL$_FAIL - if a test parameter is invalid2  C	Failure status from one of the tested routines.  C  C    SIDE EFFECTS:1  C  C	None   C--  l  C***	Declarations  i  C	IMPLICIT	INTEGER*4	(a-z)   '#  	INTEGER*4	it_count, user_mem_size	-  	CHARACTER*(*)	user_dict_nam, words_file_namN5  	INTEGER*4	lngper$prc_info			! Timer/printer routine 2  	INTEGER*4	lngspl$per_itct_error		! Check routine,  	INTEGER*4	lngspl$per_size_error		!       ";  	INTEGER*4	lngspl$per_testfile_ini		! Initialize table of S  							! test words routine8  	INTEGER*4	lngspl$load_user_disk		! Initialize routine 9  	INTEGER*4	lngspl$initialize_user		! Initialize routine o5  	INTEGER*4	lngspl$verify_word_user		! Tested routinep  			$  	COMMON 		/ user_mem / user_memory   	INTEGER*4	user_memory(32768)*  	INTEGER*4	word_count			! Of words loaded  							! into user memory#  C For the table of words to verify.  C  	PARAMETER	max_words = 50$  	CHARACTER*32	test_table(max_words))  	INTEGER*4	words_added			! To test tablee  	INTEGER*4	hyphen_map     	EXTERNAL	lngspl$_completed      C  a  C+l$  C Check validity of test parameters  C- 6  	lngspl$per_usrver = lngspl$per_itct_error (it_count)$  	IF (.NOT.lngspl$per_usrver) RETURN  h<  	lngspl$per_usrver = lngspl$per_size_error (user_mem_size)	$  	IF (.NOT.lngspl$per_usrver) RETURN  i  C+zA  C Initialization for this test: loading the user memory with theTF  C contents of the user dictionary file, and loading the file of test !  C words into an in-memory table.e  C-i@  	lngspl$per_usrver = lngspl$initialize_user 	     ! Can't fail.'       &				(user_mem_size, user_memory)   l,  	lngspl$per_usrver = lngspl$load_user_disk 2       &			(user_dict_nam, user_memory, word_count)"  	IF (.NOT.lngspl$per_usrver) THEN  	    WRITE(6,1) word_countE9   1	FORMAT(/' Number of words loaded before failure: ',I)	  	    RETURN  	ENDIF!  e.  	lngspl$per_usrver = lngspl$per_testfile_ini 7       &			   ( words_file_nam, test_table, words_added)u$  	IF (.NOT.lngspl$per_usrver) RETURN  r  C+r  C Start Clock  C-m0  	lngspl$per_usrver = lngper$prc_info (.false.)	$  	IF (.NOT.lngspl$per_usrver) RETURN  a  C+s)  C LOOP : calling routine to be tested...c  C-o  	DO 100 i=1,it_count   g  	    DO 150 j=1,words_added  s6   150	    lngspl$per_usrver = lngspl$verify_word_user        &				( test_table(j),        &				  user_memory,C       &				  hyphen_map )r     C+p  C END OF LOOP  C-	   100	CONTINUE  $  _  C+i   C Stop clock and print results.  C-o.  	lngspl$per_usrver = lngper$prc_info (.true.)           IF (lngspl$per_usrver) 4       &		lngspl$per_usrver = %loc(lngspl$_completed)  r  	RETURN  	END 	! of lngspl$per_usrverD     P  C  B  	INTEGER*4 FUNCTION lngspl$per_cortst  (it_count, user_mem_size, 3       &			user_dict_nam, try_limit, words_file_nam)      C++  C    FUNCTIONAL DESCRIPTION:$  CB  C	Tests performance for the corrector. Loads the test words from :  C	'words_file_nam' into an in-memory table, and the user E  C	dictionary of size 'user_mem_size' with words from 'user_dict_nam'CC  C	Loops round correcting each of the test words 'it_count' times, eI  C	taking the level of correction up to 'try_limit' or to limit_exceeded r!  C	(whichever is exceeded first).t  C  C  C    CALLING SEQUENCE:o  C5  C	status.wlc.v = lngspl$per_cortst (it_count.rlu.r, c  C					  user_mem_size.rlu.r,b  C					  user_dict_nam.rt.dx,a  C					  try_limit.rlu.r,c  C					  words_file_nam.rt.dx)  C  C    FORMAL PARAMETERS:  C:  C	it_count	Integer specifying how many times to call the   C			routines.C  C	user_mem_size	Size in longwords of the user memory to initializen  CE  C	user_dict_nam	Descriptor for the name of the user dictionary file.   C;  C	try_limit	Integer specifying maximum value of corrector h8  C			'try_number' that should be attained for each word.  C	zA  C	words_file_nam	Descriptor for the name of the file containing n  C			the words to be corrected.   C    IMPLICIT INPUTS:  C  C	None.  C  C    IMPLICIT OUTPUTS:C  C  C	NoneC  C  C    ROUTINE VALUE:  C	LNGSPL$_COMPLETED  0  C	LNGSPL$_FAIL - if a test parameter is invalid2  C	Failure status from one of the tested routines.  C  C    SIDE EFFECTS:.  C  C	NoneI  C--  S  C***	Declarations     C	IMPLICIT	INTEGER*4	(a-z)C  P.  	INTEGER*4	it_count, user_mem_size, try_limit-  	CHARACTER*(*)	user_dict_nam, words_file_nam   	5  	INTEGER*4	lngper$prc_info			! Timer/printer routine	2  	INTEGER*4	lngspl$per_itct_error		! Check routine,  	INTEGER*4	lngspl$per_size_error		!       "7  	INTEGER*4	lngspl$load_user_disk		! Initialize routine	<  	INTEGER*4	lngspl$initialize_verifier	! Initialize routine ;  	INTEGER*4	lngspl$per_testfile_ini		! Initialize table of r  							! test words routine1  	INTEGER*4	lngspl$get_correction		! Test routine 9  	INTEGER*4	lngspl$terminate_verifier	! Terminate routiner      			$  	COMMON 		/ user_mem / user_memory   	INTEGER*4	user_memory(32768).  	INTEGER*4	word_count			! Of words loaded in   							! user memory.  	LOGICAL*1	corr_flag	  N#  C For the table of words to verifyn  l  	PARAMETER	max_words = 50$  	CHARACTER*32	test_table(max_words))  	INTEGER*4	words_added			! To test tablen  o  C For the corrector routine  O,  	LOGICAL*1	user_flag,convert_flag,case_flag   	CHARACTER*150	corrections_list&  	INTEGER*4	hyphen_maps(30),try_number  e  	EXTERNAL	lngspl$_completed  	EXTERNAL	lngspl$_fail    +   1	FORMAT(/' Try limit ',I,' is invalid.')u9   2	FORMAT(/' Number of words loaded before failure: ',I)w      n  C+ $  C Check validity of test parameters  C-a6  	lngspl$per_cortst = lngspl$per_itct_error (it_count)$  	IF (.NOT.lngspl$per_cortst) RETURN  S<  	lngspl$per_cortst = lngspl$per_size_error (user_mem_size)	$  	IF (.NOT.lngspl$per_cortst) RETURN  e0  	IF ((try_limit.LT.0).OR.(try_limit.GT.8)) THEN  	    WRITE (6,1) try_limit ,  	    lngspl$per_cortst = %loc(lngspl$_fail)  	    RETURN
     	ENDIF  _  C+r  C Initialization for this testi  C-m  	corr_flag = .true.1  	lngspl$per_cortst = lngspl$initialize_verifier r,       &	    		   ('LNGSPLAED', 'LNGSPLAEM', 5       &			     corr_flag, user_mem_size, user_memory)a$  	IF (.NOT.lngspl$per_cortst) RETURN  e,  	lngspl$per_cortst = lngspl$load_user_disk 5       &			   (user_dict_nam, user_memory, word_count)C"  	IF (.NOT.lngspl$per_cortst) THEN  	    WRITE(6,2) word_countr  	    RETURN  	ENDIF    .  	lngspl$per_cortst = lngspl$per_testfile_ini 7       &			   ( words_file_nam, test_table, words_added)w$  	IF (.NOT.lngspl$per_cortst) RETURN  t  	case_flag    = .false.  	convert_flag = .false.  	user_flag    = .true.T     C+C  C Start Clock  C-L0  	lngspl$per_cortst = lngper$prc_info (.false.)	$  	IF (.NOT.lngspl$per_cortst) RETURN  F  C+ )  C LOOP : calling routine to be tested...s  C-   m  	DO 100 i=1,it_count   .  	DO 180 j=1,words_added  C  	    try_number = 0  *4   150	    lngspl$per_cortst = lngspl$get_correction        &				( test_table(j),R       &				  case_flag,        &				  convert_flag,       &				  user_flag,	       &				  user_memory,c       &			  	  try_number,       &				  corrections_list,       &				  hyphen_maps )  	(  	    IF (.NOT.lngspl$per_cortst) RETURN  i>  	    IF ( (lngspl$per_cortst.NE.%loc(lngspl$_limit_exceeded))2       &		.AND.(try_number.LT.try_limit) ) GOTO 1502  	    			! Continue with corrections for this word  /   180	CONTINUE  m  C+   C END OF LOOP  C-r   100	CONTINUE  E  C+r   C Stop clock and print results.  C- .  	lngspl$per_cortst = lngper$prc_info (.true.)  0  C+H  C Terminate the test.  C-d2  	lngspl$per_cortst = lngspl$terminate_verifier ()  ,  	RETURN  	END 	! of lngspl$per_cortst	  	  E  5  	INTEGER*4 FUNCTION lngspl$per_itct_error (it_count)p  C++  C    FUNCTIONAL DESCRIPTION:p  CA  C	Checks the validity of the iteration count for a test routine.vB  C	Reports an invalid iteration count i.e. one that is <=0 and in "  C	this case returns LNGSPL$_FAIL.  C  C    CALLING SEQUENCE:r*  C	lngspl$per_itct_error (it_count.rlu.r)   C  C    FORMAL PARAMETERS:  C(  C	it_count	Integer for iteration count.  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:f"  C	Writes error message to screen.  C  C    ROUTINE VALUE:<  C	LNGSPL$_COMPLETED or LNGSPL$_FAIL (if error mess written)  C  C    SIDE EFFECTS:u  C	Noney  C--  	IMPLICIT	INTEGER*4	(a-z)     	INTEGER*4	it_count  n  	EXTERNAL	lngspl$_completed  	EXTERNAL	lngspl$_failT  g1  	lngspl$per_itct_error = %loc(lngspl$_completed)   t  	IF (it_count.LE.0) THEN   	    WRITE(6,1)?   1	    FORMAT(/' Iteration count must be a positive integer.')m0  	    lngspl$per_itct_error = %loc(lngspl$_fail)  	ENDIF(  g	  	RETURN 	!  	END 	! of lngspl$per_itct_error_  g  :  	INTEGER*4 FUNCTION lngspl$per_size_error (user_mem_size)  C++  C    FUNCTIONAL DESCRIPTION:   CB  C	Checks the validity of the user_memory_size for a test routine.@  C	Reports an invalid one and in this case returns LNGSPL$_FAIL.  C  C    CALLING SEQUENCE: /  C	lngspl$per_size_error (user_mem_size.rlu.r) l  C  C    FORMAL PARAMETERS:  C@  C	user_mem_size 		Integer for size of user memory in longwords.  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS: "  C	Writes error message to screen.  C  C    ROUTINE VALUE:  C	LNGSPL$_COMPLETED y*  C	LNGSPL$_FAIL (if error message written)  C  C    SIDE EFFECTS:s  C	Noner  C--  	IMPLICIT	INTEGER*4	(a-z)  h  	INTEGER*4	user_mem_sizeb  '  	EXTERNAL	lngspl$_completed  	EXTERNAL	lngspl$_failL   1  	lngspl$per_size_error = %loc(lngspl$_completed)   _  	DO 50 i=12,15 (   50	IF (user_mem_size.EQ.2**i) GOTO 100  i  C3  C Loop completed, and no match made, so an error..   C  	WRITE(6,1)   1      FORMAT	I       &	(/' User Memory Size must be 2**n where n is 12, 13, 14, or 15.')_,  	lngspl$per_size_error = %loc(lngspl$_fail)  i   100	CONTINUE	  	RETURN m!  	END 	! of lngspl$per_size_errorr  c  -  	INTEGER*4 FUNCTION lngspl$per_testfile_ini r2       &			(words_file_nam, test_table, word_count)  C++  C    FUNCTIONAL DESCRIPTION:P  C?  C	Opens a test file of words that the caller test is going to C=  C	verify or correct. Loads the words from the test file intofB  C	an in-memory table 'test_table' that has a maximum of 50 words.>  C	If the test file contains more than this number, an warningF  C	message is given by this routine, but it returns OK and the caller F  C	test continues. However, if the test file contains no words at all,F  C	or cannot be opened, this routine returns LNGSPL$_FAIL so that the   C	caller test is abandoned.  CD  C	Closes the test file after loading the words from it and returns .  C	the number of words loaded in 'word_count'.  C  C    CALLING SEQUENCE:ED  C	ret_status.wlc.v = lngspl$per_testfile_ini (words_file_nam.rt.dx,  C						    test_table.rlu.ra, i  C						    word_count.wlu.r)_  C  C    FORMAL PARAMETERS:  C:  C	words_file_nam		Descriptor of name of user's test file.9  C	test_table		Array of character*32 entries for holding 	(  C				the words in the user's test file.5  C	word_count		Count of the number of words added to H  C				the array 'test_table'.)  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:p*  C	Might write an error message to screen.  C  C    ROUTINE VALUE:  C	LNGSPL$_COMPLETED CG  C	LNGSPL$_FAIL (if no words in the test file and an error message has g  C		      been written)h  C  C    SIDE EFFECTS:n  C	Nones  C--  	IMPLICIT	INTEGER*4	(a-z)  T  	INTEGER*4	user_mem_size      	CHARACTER*(*)	words_file_nam0  	PARAMETER	test_file = 3		! Unit channel number  	CHARACTER*80	test_record  	INTEGER*4	test_rec_lgthf  s  	PARAMETER	max_words = 50%  	CHARACTER*32	test_table(max_words)	   	INTEGER*4	word_count     	INTEGER*4	lngspl$extract_wordm  	CHARACTER*32	extr_word           LOGICAL*1	strip_hyphens,  	INTEGER*4	start_pos,word_length,hyphen_map  	  	EXTERNAL	lngspl$_completed  	EXTERNAL	lngspl$_end_of_line  	EXTERNAL	lngspl$_truncated  	EXTERNAL	lngspl$_faild  f   1	FORMAT(Q,A)	
   2	FORMAT>       &(/' Test file contains more than ',I2,' words. First ',       &  I2,' loaded.')l,   3	FORMAT(/' Test file contains no words.'),   4 	FORMAT(/' Test file cannot be opened.')  k  C+m1  C Open the test file and do some initializations   C-(-  	OPEN (unit=test_file, file=words_file_nam, O-       &	      status='old', readonly, err=20)O          GOTO 30  g  C Error opening..  s   20	WRITE(6,4)	2      	lngspl$per_testfile_ini = %loc(lngspl$_fail)  	RETURN  s   30	DO 50 i=1,max_words;   50	    test_table(i) = '                                'O  O  	strip_hyphens = .false.$  	word_count    = 0l     C+rF  C Loop round until the test_table is full, or until the test_file is   C finished.  C-_  v   100	CONTINUE8  	READ(test_file, 1, end=200) test_rec_lgth, test_record  	start_pos = 1l  r   150	CONTINUE0  	lngspl$per_testfile_ini = lngspl$extract_word ,       &				  ( test_record(1:test_rec_lgth),       &				    strip_hyphens,m       &				    start_pos,N       &				    extr_word,s       &	    			    word_length,        &	    			    hyphen_map )o  _:  	IF (lngspl$per_testfile_ini.EQ.%loc(lngspl$_truncated)) 3       &    GOTO 150			! Effectively ignore the wordt  mC          IF (lngspl$per_testfile_ini.EQ.%loc(lngspl$_end_of_line)) ,8       &    GOTO 100			! Fetch next record from test file  C+iM  C A word was extracted successfully, and the end of the current test record N  C has not yet been reached...  C-r#  	IF (word_count.LT.max_words) THENu!  	    word_count = word_count + 1_(  	    test_table(word_count) = extr_word  	ELSE 	7  	    WRITE(6,2)	max_words, max_words	! Warning messageC-  	    GOTO 200				! Test table limit exceeded   	ENDIFh         	GOTO 150  u  C+e  C End of test file locatedh  C-r   200	CONTINUE			    				    u  	IF (word_count.EQ.0) THEN $  	    WRITE(6,3) 				! Error message3  	    lngspl$per_testfile_ini = %loc(lngspl$_fail) c  	ELSE7  	    lngspl$per_testfile_ini = %loc(lngspl$_completed)r  	ENDIF   w  	CLOSE (test_file)t  f	  	RETURN  #  	END 	! of lngspl$per_testfile_inir  t