5  C***	TITLE	Read Master Dictionary Word List Routines      C			  COPYRIGHT (c) 1984 BY6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.      C++
  C FACILITY:	 &  C		DECspell Dictionary Build and Test  C  C ABSTRACT:  C  C		Subroutines to :    C)  C    		Open word list file on channel 9. 6  C		Read a record from wordlist returning values read.9  C		Read a record from wordlist returning values decoded    C		from that record.   C		Close word list file.   C	   C ENVIRONMENT: 8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.  C0  C AUTHOR: Nick Tatham		CREATION DATE: 16-APR-84  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C(  C X01.01	Nick Tatham	16-APR-84	Original4  C X01.02	Cathy		30-APR-84	Re-wrote into 4 separate   C						routines. 5  C X01.03	Cathy		20-AUG-84	Fixed bug whereby if word  %  C						is exactly 21 chars (maximum  &  C						buffer length) no space found "  C						by INDEX function, so was   C						returning -1.   C--     #  	SUBROUTINE open_wordlist (string)      C++  c    FUNCTIONAL DESCRIPTION:   C<  C       Opens word list filename 'string' and sets boolean A  C	in common block list_status to indicate that the file is open.   C  C    CALLING SEQUENCE:   C	CALL rwordlist(string.mt.ds)   C  C    FORMAL PARAMETERS:!  C	string			Filename of wordlist.   C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:   C	File left open on channel 9  C  C    ROUTINE VALUE:  C	None. Signal_stops errors.   C  C    SIDE EFFECTS:   C	None   C--     C***	Declarations     	IMPLICIT	INTEGER*4 (a-z)     	CHARACTER*(*)	string      	LOGICAL*1	wordlist_open	)      	COMMON		/list_status/ wordlist_open       4  	OPEN	(UNIT=9, FILE=string, STATUS='OLD', READONLY)          wordlist_open = 1     	RETURN  	END 	! of Open_wordlist         >  	INTEGER*4 FUNCTION read_wordlist (vanword, hypword, capcode)     C++  C    FUNCTIONAL DESCRIPTION:   CA  C       Reads a record from the word list file returning exactly   C	what was read.	  C  C    CALLING SEQUENCE:   C/  C	status.wlc.v = read_wordlist( vanword.wt.ds,   C				      hypword.wt.ds,  C				      capcode.wlu.r)  C  C    FORMAL PARAMETERS:'  C	vanword			lowercase version of word. 6  C	hypword			lowercase version of word with '=' signs    C				for hyphenation positions.*  C	capcode			Integer of value 1-5, giving   C				capitalization code.  C  C    IMPLICIT INPUTS:  C	None.  C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:E  C	1 if file record is read OK, or 0 if EOF. Signal_stops any errors.   C  C    SIDE EFFECTS:   C	None   C--     C***	Declarations     	IMPLICIT	INTEGER*4 (a-z)     	INTEGER*4	capcode   	CHARACTER*32	vanword,hypword  	LOGICAL*1	list_open !  	COMMON		/list_status/ list_open      C****  C	Wordlist format  C!  C	1-32	Vanilla word in lowercase -  C	33-64	Hyphenated word using "=" characters 
  C	65-79	Fill   C	80	Capitalization code   C  1	FORMAT(A32,A32,15X,I1)   C  C****   <  	IF (list_open) READ(9,1,END=100) vanword, hypword, capcode     	read_wordlist = 1   	RETURN      100	read_wordlist = 0           RETURN      	END 	! of Read_Wordlist           	SUBROUTINE close_wordlist ()     C++  c    FUNCTIONAL DESCRIPTION:   C$  C       Closes the word list file.	  C  C    CALLING SEQUENCE:   C	CALL close_wordlist()  C  C    FORMAL PARAMETERS:  C	None.  C  C    IMPLICIT INPUTS:  C	File left open on channel 9  C  C    IMPLICIT OUTPUTS:   C	None.  C  C    ROUTINE VALUE:  C	None.  C  C    SIDE EFFECTS:   C	None   C--     C***	Declarations     	IMPLICIT	INTEGER*4 (a-z)     	LOGICAL*1	list_open "  	COMMON 		/list_status/ list_open     	IF (list_open) CLOSE (UNIT=9)      	RETURN  	END 	! of Close_wordlist        =  	INTEGER*4 FUNCTION decode_wordlist  (word, length, hyp_map)   C++  C    FUNCTIONAL DESCRIPTION:   C;  C       Reads a record from the word list file, to obtain:    C	a) lowercase version of word.G  C	b)    "        "     "   "   expanded with '=' for hyphen positions.   C	c) capitalization code.  CE  C 	Applies the capitalization code to the word, returning result in  C  C	'word'. Returns the length of the word in 'length', and extracts 5  C	the '=' signs to obtain a hyphen map in 'hyp_map'.   C8  C	If the end of file is reached, returns a length of 0.  C  C    CALLING SEQUENCE: /  C	status.wlc.v = decode_wordlist( word.wt.ds,    C				  	length.wlu.r,  C				  	hyp_map.wlu.r)   C  C    FORMAL PARAMETERS:2  C	word			Text of word with capcode applied to it,  C				padded with spaces. $  C	length			Length of word in chars.   C	hyp_map			Hyphen map of word.  C  C    IMPLICIT INPUTS:  C	File left open on channel 9  C  C    IMPLICIT OUTPUTS:   C	File left open on channel 9  C  C    ROUTINE VALUE:H  C	1 if record decoded OK, otherwise 0 if EOF. Signals_stops any errors.  C  C    SIDE EFFECTS:   C	None   C--     C***	Declarations     	IMPLICIT	INTEGER*4 (a-z)     	CHARACTER*(*)	word&  	INTEGER*4	length, outlength, hyp_map(  	CHARACTER*32	vanword, hypword, outword"      	INTEGER*4	capcode, start_pos  	LOGICAL*1	strip_hyphens   	LOGICAL*1	list_open !  	COMMON		/list_status/ list_open    #          EXTERNAL	lngspl$_completed    1  	status = read_wordlist (word, hypword, capcode)   	IF (status.EQ.0) GOTO 500      C+   C Apply capitalization code.   C-   	  	length = INDEX(word,' ')-1	 #      	IF (length.eq.-1) length = 21 )  	CALL check_case (word, capcode, length)      C+   C Obtain hyphen map.   C-   	strip_hyphens = 1   	start_pos     = 1 C  	status = lngspl$extract_word (hypword, strip_hyphens, start_pos,  '       &				outword, outlength, hyp_map) -  	IF (status.NE.%loc(lngspl$_completed)) THEN   	    WRITE (6,1) hypword >   1	FORMAT (' Word :',A,' Hyphen map could not be extracted.')  	    CALL lib$stop (status)  	ENDIF       
  400	CONTINUE   	decode_wordlist = 1   	RETURN   
  500	CONTINUE   	length 		= 0  	decode_wordlist = 0   	RETURN     	END 	! of Decode_wordlist         5        SUBROUTINE Check_case (word, cap_code, length)   CH  C 'word' comes in in lowercase. If the capcode is not 0, convert 'word'  C to reflect the capcode:  C  C	1 - initial-capital  C	2 - all capitals A  C       3 - initial-capital and capital-after-the-hard-hyphen(s) /  C       4 - capital-after-the-last-hard-hyphen C  C       5 - mixed case (there shouldn't be any in the dictionary).   C-            IMPLICIT INTEGER*4 (a-z)            CHARACTER*80	word   
                        IF (cap_code .EQ. 1) THEN  C+ $  C Convert first letter to uppercase  C- )            IF ((word(1:1) .GE. 'a') .AND. (       &	      (word(1:1) .LE. 'z')) THEN   1                lower_char_code = ICHAR(word(1:1)) 5                upper_char_code = lower_char_code - 32 0                word(1:1) = CHAR(upper_char_code)            END IF    
               %        ELSE IF (cap_code .EQ. 2) THEN   C+ $  C Convert every letter to uppercase  C- %            DO 100 counter = 1, length    9                IF ((word(counter:counter) .GE. 'a') .AND. 8       & 	         (word(counter:counter) .LE. 'z')) THEN   A                    lower_char_code = ICHAR(word(counter:counter)) 9                    upper_char_code = lower_char_code - 32 @                    word(counter:counter) = CHAR(upper_char_code)                END IF        100     CONTINUE    %        ELSE IF (cap_code .EQ. 3) THEN   C+ N  C Convert the first letter to uppercase, and also the first letter after the   C hard hyphen(s).  C- )            IF ((word(1:1) .GE. 'a') .AND. (       &	      (word(1:1) .LE. 'z')) THEN   1                lower_char_code = ICHAR(word(1:1)) 5                upper_char_code = lower_char_code - 32 0                word(1:1) = CHAR(upper_char_code)            END IF       %            DO 300 counter = 2, length    ;                IF (word(counter:counter) .NE. '-') GOTO 300      	      next_pos = counter + 1   4  	      IF ((word(next_pos:next_pos) .GE. 'a') .AND.4       &   	 (word(next_pos:next_pos) .LE. 'z')) THEN   3  		lower_char_code = ICHAR(word(next_pos:next_pos)) )  		upper_char_code = lower_char_code - 32 2  		word(next_pos:next_pos) = CHAR(upper_char_code)  	    END IF       300 CONTINUE       %        ELSE IF (cap_code .EQ. 4) THEN   C+ D  C Convert the first letter after the last hard hyphen to uppercase.  C- )            DO 400 counter = length, 1, -1    ;                IF (word(counter:counter) .NE. '-') GOTO 400      	      next_pos = counter + 1   4  	      IF ((word(next_pos:next_pos) .GE. 'a') .AND.9       &	        	(word(next_pos:next_pos) .LE. 'z')) THEN    3  		lower_char_code = ICHAR(word(next_pos:next_pos)) )  		upper_char_code = lower_char_code - 32 2  		word(next_pos:next_pos) = CHAR(upper_char_code)  	      END IF  	      RETURN		       400     CONTINUE    
        END IF            RETURN         END	! of check_case