>  C***	TITLE	TapeLoad - Houghton Mifflin Dictionary Tape Loader *2D      C			  COPYRIGHT (c) 1984 BY *2E  *2I   C"  C			  COPYRIGHT (c) 1984, 1985 BY *2E 6  C	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.  CI  C This software is furnished under a license and may be used and  copied I  C only  in  accordance  with  the  terms  of  such  license and with the I  C inclusion of the above copyright notice.  This software or  any  other I  C copies  thereof may not be provided or otherwise made available to any I  C other person.  No title to and ownership of  the  software  is  hereby   C transferred.   CI  C The information in this software is subject to change  without  notice I  C and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT   C CORPORATION.   CK  C DIGITAL EQUIPMENT CORPORATION assumes no responsibility for the use or   J  C reliability of its software on  equipment  which is  not  supplied  by !  C DIGITAL EQUIPMENT CORPORATION.      C++
  C FACILITY:	 %  C		DECspell Dictionary Build Process   C  C ABSTRACT:  C9  C		Take a standard Houghton Mifflin dictionary tape and  9  C		strips it into a MASTER dictionary and a RAMFIL file.   C	   C ENVIRONMENT: 8  C	VAX/VMS V3.5 FORTRAN module file.  Non-transportable.  C4  C AUTHOR: Houghton Mifflin		CREATION DATE: 6-Feb-84  C  C MODIFIED BY:   C  C Edit		Modifier	Date		Reason  C>  C X01.01	Nick Tatham	16-APR-84	Type in from Houghton Listings  C?  C X01.02	Catherine B.	26-APR-84	Modify to create a block data  '  C						source for in-memory dictionary %  C						as output (as in CRBLKDATA),  '  C						instead of a binary output for    C						the same.   CA  C X01.03	Catherine B.	22-MAY-84	Modify dimensions to unpack the    C						DECspell V1.1 435Kb   C						dictionaries.   C=  C X01.04	Ian Kirkham	11-Dec-84	Alter output file so that the %  C						file refers to MASTERCOM/LIST   C						and not MASTERCOM.FOR  *2I   C>  C X01.05	Ian Kirkham	 4-Feb-85	Alter to take the 1985 lexicon  C<  C X01.06	Ian Kirkham	15-Mar-85	Read in all sizes of lexicon  C						determined by sizes in  C						MASTERCOM.FOR  *2E  *3I  *4D   C3  C X01.07	Chan		 9-Oct-85	Fix british bs build bug.  *4E  *3E   C--       	PROGRAM	TapeLoad     C++  C    FUNCTIONAL DESCRIPTION:   CD  C       Main Program. Takes an input 'TAPE' file that contains the ;  C	a raw binary form of both the in-memory and disk master  A  C	dictionaries. Creates two output files: 'MASTER' and 'RAMFIL'. <  C	'RAMFIL' is the source code for the in-memory dictionary 
  C	.EXE file.   C  C    CALLING SEQUENCE:   C1  C	Main Program. Fixed file names (logical names)   C  C    FORMAL PARAMETERS:  C  C	None   C  C    IMPLICIT INPUTS:  C  C	Fixed file names   C  C    IMPLICIT OUTPUTS:   C  C	Fixed file names   C  C    ROUTINE VALUE:  C
  C	Success  C  C    SIDE EFFECTS:   C  C	None   C--     C***	Declarations     	IMPLICIT	INTEGER*2 (a-z)    *2D 1  	INTEGER*4	vertab(8192),table(1792),pointer(896)  *2E  *2I   	CHARACTER*14	log_filename   	CHARACTER*128	rslbuf  	INTEGER*4	rsllen1  	INTEGER*4	vertab_size, pointer_size, table_size  *2E          	INTEGER*2	sector(256) *2D +  	INTEGER*2	table_size,block_number,line_no  *2E  *2I    	INTEGER*2	block_number,line_no *2E "  	INTEGER*2	line_no_minus,quotient    *2I   	INCLUDE		'mastercom/list'  *2E   C+   C	Open input raw tape file   C-  *2D 4  	OPEN	(UNIT=1, FILE='LNGSPL$RAMLOAD', STATUS='OLD', *2E  *2I !  	log_filename = 'LNGSPL$RAMLOAD'    0  	OPEN	(UNIT=1, FILE=log_filename, STATUS='OLD', *2E 1       &	 	 ACCESS='SEQUENTIAL', FORM='FORMATTED',        &	 	 SHARED, READONLY)    *2I 7  	status = SYS$TRNLOG (log_filename, rsllen, rslbuf,,,)   C"  C check for SS$_NORMAL ret status  C  	IF(status.ne.1) 3  	1    STOP 'Failure translating logical file name'    2  	IF(INDEX(rslbuf(1:rsllen), 'LNGSPLAE').ne.0)THEN"  	    vertab_size =	ae_vertab_size$  	    pointer_size =	ae_pointer_size   	    table_size =	ae_table_size *3I  *4D 7  	ELSE IF(INDEX(rslbuf(1:rsllen), 'LNGSPLAL').ne.0)THEN "  	    vertab_size =	ae_vertab_size$  	    pointer_size =	ae_pointer_size   	    table_size =	ae_table_size *4E  *3E 7  	ELSE IF(INDEX(rslbuf(1:rsllen), 'LNGSPLBS').ne.0)THEN  *3D "  	    vertab_size =	bs_vertab_size$  	    pointer_size =	bs_pointer_size   	    table_size =	bs_table_size *3E  *3I  *4D "  	    vertab_size =	be_vertab_size$  	    pointer_size =	be_pointer_size   	    table_size =	be_table_size *4E  *4I "  	    vertab_size =	bs_vertab_size$  	    pointer_size =	bs_pointer_size   	    table_size =	bs_table_size *4E  *3E 7  	ELSE IF(INDEX(rslbuf(1:rsllen), 'LNGSPLBZ').ne.0)THEN  *3D "  	    vertab_size =	bz_vertab_size$  	    pointer_size =	bz_pointer_size   	    table_size =	bz_table_size *3E  *3I  *4D "  	    vertab_size =	be_vertab_size$  	    pointer_size =	be_pointer_size   	    table_size =	be_table_size *4E  *4I "  	    vertab_size =	bz_vertab_size$  	    pointer_size =	bz_pointer_size   	    table_size =	bz_table_size *4E  *3E   	ELSE+  	    STOP 'Unrecognised lexicon file name'   	END IF *2E   C+ ?  C 	Read the in-memory master dictionary and associated tables    C    	into memory.   C-  *2D      	DO 20 i=1,1792,64  *2E  *2I   	DO i=1,max_vertab_size  	    vertab(i) = 0   	END DO     	DO i=1,max_pointer_size   	    pointer(i) = 0  	END DO     	DO i=1,max_table_size   	    table(i) = 0  	END DO     	DO 20 i=1,table_size,64  *2E $  	    READ(1,10) (table(j),j=i,i+63)  10	    FORMAT(64Z8)  20	CONTINUE    *2D   	DO 30 i=1,896,64 *2E  *2I   	DO 30 i=1,pointer_size,64  *2E &  	    READ(1,10) (pointer(j),j=i,i+63)  30	CONTINUE    *2D   	DO 40 i=1,8192,64  *2E  *2I   	DO 40 i=1,vertab_size,64 *2E %  	    READ(1,10) (vertab(k),k=i,i+63)   40	CONTINUE        C+ <  C	Read the master disk dictionary and write immediately to   C	output 'MASTER' file.  C- /  	OPEN	(UNIT=2, FILE='MASTER', ACCESS='DIRECT', <       &	         STATUS='NEW', FORM='UNFORMATTED', RECL=128)  C5  C	RECL = 512 in bytes; RECL = 128 in four byte words   C *2D   	DO 60 i=1,900  *2E  *2I  *4D   	DO 60 i=1,1000 *4E  *4I   	DO 60 i=1,2000 *4E  *2E +  	    READ(1,50,END=70) (sector(k),k=1,128) -  	    READ(1,50,END=70) (sector(k),k=129,256)   50	    FORMAT(128Z4)   	    WRITE(2,REC=i) sector   60	CONTINUE  70	CONTINUE    *2I   	CLOSE(UNIT=2,STATUS='KEEP')   	CLOSE(UNIT=1,STATUS='KEEP')     *2E      C+ 5  C	Open the in-memory dictionary output 'RAMFIL' file   C-  *2D 2  	OPEN	(UNIT=3, FILE='RAMFIL', DEFAULTFILE='.FOR', *2E  *2I 2  	OPEN	(UNIT=2, FILE='RAMFIL', DEFAULTFILE='.FOR', *2E F       &	         ACCESS='SEQUENTIAL', RECL=80, CARRIAGECONTROL='LIST',0       &	         STATUS='NEW', FORM='FORMATTED')     C+ >  C Write out FORTRAN statements for initializing in-ram tables  C-  *2D   	WRITE (3,110)  *2E  *2I   	WRITE (2,110)  *2E >  110	FORMAT(6x,'block data',/,6x,'include ''mastercom/list''')     C  C Verification table first   C *2D   	table_size    = 6144 *2E   	block_number  = 24  	line_no       = 4   	line_no_minus = 3 &  	quotient      = block_number/line_no    *2D '  	DO 160 i= 1, table_size, block_number  *2E  *2I ,  	DO 160 i= 1, max_vertab_size, block_number *2E     *2D $  	WRITE(3,120) i, i+(block_number-1) *2E  *2I $  	WRITE(2,120) i, i+(block_number-1) *2E 3  120	FORMAT(6x,'data (vertab(i),i=',i5,',',i5,')/')      	DO 140 j=1, quotient#  	    ifrst = ((j-1) * line_no) + i #  	    ilast = ifrst + line_no_minus  *2D @  	    IF (j.lt.quotient) WRITE (3,130) (vertab(k),k=ifrst,ilast) *2E  *2I @  	    IF (j.lt.quotient) WRITE (2,130) (vertab(k),k=ifrst,ilast) *2E /  130	FORMAT(5x,'+',<line_no>('''',z8.8,'''x,'))     *2D @  	    IF (j.eq.quotient) WRITE (3,135) (vertab(k),k=ifrst,ilast) *2E  *2I @  	    IF (j.eq.quotient) WRITE (2,135) (vertab(k),k=ifrst,ilast) *2E F  135	FORMAT(5x,'+',<line_no_minus>('''',z8.8,'''x,'),'''',z8.8,'''x/')
  140	CONTINUE    
  160	CONTINUE      C  C Compression table next   C  	 *2D   	table_size    = 1780 *2E   	block_number  = 20&  	quotient      = block_number/line_no    *2D &  	DO 190 i=1, table_size, block_number *2E  *2I *  	DO 190 i=1, max_table_size, block_number *2E     *2D $  	WRITE(3,170) i, i+(block_number-1) *2E  *2I $  	WRITE(2,170) i, i+(block_number-1) *2E 2  170	FORMAT(6x,'data (table(i),i=',i5,',',i5,')/')     	DO 180 j=1,quotient #  	    ifrst = ((j-1) * line_no) + i #  	    ilast = ifrst + line_no_minus  *2D ?  	    IF (j.lt.quotient) WRITE (3,130) (table(k),k=ifrst,ilast) ?  	    IF (j.eq.quotient) WRITE (3,135) (table(k),k=ifrst,ilast)  *2E  *2I ?  	    IF (j.lt.quotient) WRITE (2,130) (table(k),k=ifrst,ilast) ?  	    IF (j.eq.quotient) WRITE (2,135) (table(k),k=ifrst,ilast)  *2E 
  180	CONTINUE    
  190	CONTINUE      C  C Pointer table next   C    *2D   	table_size    = 896  *2E   	block_number  = 32&  	quotient      = block_number/line_no    *2D &  	DO 230 i=1, table_size, block_number *2E  *2I ,  	DO 230 i=1, max_pointer_size, block_number *2E     *2D $  	WRITE(3,210) i, i+(block_number-1) *2E  *2I $  	WRITE(2,210) i, i+(block_number-1) *2E 4  210	FORMAT(6x,'data (pointer(i),i=',i5,',',i5,')/')     	DO 220 j=1,quotient #  	    ifrst = ((j-1) * line_no) + i #  	    ilast = ifrst + line_no_minus  *2D A  	    IF (j.lt.quotient) WRITE (3,130) (pointer(k),k=ifrst,ilast) A  	    IF (j.eq.quotient) WRITE (3,135) (pointer(k),k=ifrst,ilast)  *2E  *2I A  	    IF (j.lt.quotient) WRITE (2,130) (pointer(k),k=ifrst,ilast) A  	    IF (j.eq.quotient) WRITE (2,135) (pointer(k),k=ifrst,ilast)  *2E 
  220	CONTINUE    
  230	CONTINUE     *2D       	WRITE (3,240)  *2E  *2I       	WRITE (2,240)  *2E   240	FORMAT (6x,'end') *2D             	CLOSE	(UNIT=1,STATUS='KEEP') *2E   	CLOSE	(UNIT=2,STATUS='KEEP') *2D   	CLOSE	(UNIT=3,STATUS='KEEP') *2E              STOP       	END 	! of TapeLoad