# SQL abstraction for MySQL
# Copyright (C) 1999 Henrik Edlund <henrik@edlund.org>
#
# Uses the DBI module and the DBD:mysql driver module found at CPAN.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA 02111-1307 USA.



# connect(name) -> (connection)
# query(connection, query) -> (result)
# fetchrow(result) -> (tuple)
# ntuples(result) -> (ntuples)



package MySQL;

use DBI;
use strict;
use vars qw(%config);

my $product_name = 'SQL abstraction for MySQL';
my $product_version = '0.1.1';



%config = (
	   
	   'features' =>
           {'transactions' => 0,
	    'subselects'   => 0},
	   
	   );



sub connect ($$$$$) {
    (my $host, my $port, my $name, my $user, my $password) = @_;
    return (DBI->connect("DBI:mysql:host=$host:port=$port:database=$name",
			 $user, $password,
			 {RaiseError => 1, AutoCommit => 1}));
}

sub query ($$) {
    (my $conn, my $query) = @_;
    my $result;
    $result = $conn->prepare($query);
    $result->execute();
    return ($result);
}

sub fetchrow ($) {
    (my $result) = @_;
    return ($result->fetchrow);
}

sub ntuples ($) {
    (my $result) = @_;
    return ($result->rows);
}

1;
