# SQL abstraction for PostgreSQL
# Copyright (C) 1998-1999 Henrik Edlund <henrik@edlund.org>
#
# Uses the Pg module included with PostgreSQL.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA 02111-1307 USA.



# connect(name) -> (connection)
# query(connection, query) -> (result)
# fetchrow(result) -> (tuple)
# ntuples(result) -> (ntuples)



package PostgreSQL;

use Pg;
use strict;
use vars qw(%config);

my $product_name = 'SQL abstraction for PostgreSQL';
my $product_version = '0.3.1';



%config = (
	   
	   'features' =>
           {'transactions' => 1,
	    'subselects'   => 1},
	   
	   );



sub connect ($$$$$) {
    (my $host, my $port, my $name, my $user, my $password) = @_;
    my $conn = Pg::setdbLogin($host, $port, '', '', $name, $user, $password);
    die "Can't connect to database, stopped"
	unless ($conn->status == PGRES_CONNECTION_OK);
    return($conn)
}

sub query ($$) {
    (my $conn, my $query) = @_;
    my $result = $conn->exec($query);
    my $status = $result->resultStatus;
    die "Can't execute query, stopped" unless
	(($status == PGRES_COMMAND_OK) ||
	 ($status == PGRES_TUPLES_OK) ||
	 ($status == PGRES_COPY_OUT) ||
	 ($status == PGRES_COPY_IN));
    return($result);
}

sub fetchrow ($) {
    (my $result) = @_;
    return ($result->fetchrow);
}

sub ntuples ($) {
    (my $result) = @_;
    return ($result->ntuples);
}

1;
