$!  Make_GCG_Hlp.com
$!  ================
$!    David Mathog, Biology Division, Caltech, mathog@seqaxp.bio.caltech.edu
$!    10-MAR-1995
$!
$!  GCG 8.0 does not come with, nor provide any way, to produce .hlp files.
$!  This makes it impossible to use the existing .hlp/.hlb tools available
$!  in the various information servers (WWW,gopher, etc.).
$!
$!  This routine is a DCL equivalent of buildhelplib, but it outputs
$!  .hlp files instead of .gcg files.
$!
$!  P1  the name of the .fil to build with, either
$!         gendocbinder:genhelp.fil
$!         gendocbinder:genmanual.fil
$!  P2  the name for the output file
$!  P3  DEBUG If it exists, then the append isn't done, instead
$!      files are listed.
$!  (Watch out for the "genhelp" logical along the way!) 
$!
$!
$!  create the file, but don't put anything into it.
$!
$ if("''P2'" .eqs. "")
$then
$ type sys$input

 The syntax for using this procedure is:
 
    $  @make_hlp @gendocbinder:genhelp.fil       outfile.hlp

             or

    $  @make_hlp @gendocbinder:genmanual.fil       outfile.hlp

 You left off the "outfile.hlp" part.

 Next time provide an output filename!

$exit
$endif
$!
$!
$!  now set up the loop before entering it with the first file name
$!
$ level = 0
$ string = P1
$ if(f$extract(0,1,string) .nes. "@")then string = "@" + P1
$!
$!  main loop
$!
$uptop:
$ level = level + 1
$ string = string - "@"
$ open/error=oops tfil'level': 'string'
$top:
$ read/end=hop/error=hop tfil'level': string
$ if(f$extract(0,1,string) .eqs. "@")then goto uptop
$ if(f$extract(0,1,string) .eqs. "!")then goto top
$ string = f$edit(string,"UPCASE,COLLAPSE")
$ if(f$locate("!UNIXONLY",string) .ne. f$length(string))then goto top
$ size  = f$length(string)
$ csize = f$locate("!",string)
$ if( csize .ne. size)then size = csize
$ string = f$extract(0,'size',string)
$ write sys$output "$ Append /new ''string' ''P2'"
$ if("''P3'" .eqs. "")
$then
$ append /new  'string' 'P2'
$ if( .not. $STATUS)then goto badp2
$endif
$ goto top
$!
$!  Get here whenever we hit the end of a file at any level
$!
$hop:
$ close tfil'level':
$ level = level - 1
$ if level .gt. 0 then goto top
$ type sys$input

  Processing completed

  Use a command like the following to create the .hlb library:

$write sys$output "$ libr/help/create=keysize:80  mylib.hlb ''P2'"
$ type sys$input 

normal exit
$ exit
$!
$! If it fails to open one of the files, throw an error, then
$! close all of the open ones.
$!
$oops:
$ write sys$output "Fatal error  - could not open: ''string'"
$unroll:
$ level = level -1
$ if level .le. 0 then exit
$ close tfil'level':
$ goto unroll
$!
$!  Come here if couldn't create the output file
$!
$badp2:
$  type sys$input

   Fatal error creating or appending to the output file.

   Check that the filename is valid.
   Check that you have write access to the location specified.
   Check that you have sufficient diskspace and diskquota.

$  write sys$output "Output file name = ''P2'"
$exit
