$! v = 'f$verify(0)'
$!
$!			HTTP_INDEXUSERDOC.COM for the CERN and OSU servers.
$!
$!	30-APR-1995	F.Macrides (macrides@sci.wfeb.edu)
$!			Example command procedure for indexing
$!				VMSGopherServer.doc
$!			as a /~username/ sectional database.
$!			Assumes that the document has been placed
$!			in the:
$!				device:[...username.WWWDoc]
$!			subdirectory, parallel to the:
$!				device:[...username.username]
$!			subdirectory.  Also assumes that the program
$!			BUILD_INDEX.EXE, and the files SEQIDX.FDL,
$!			SEQSEL.FDL and NOISE_WORDS.DAT are in your
$!			server's dev:[dir.VMSIndex] directory, with
$!			read access (edit dev and dir appropriately,
$!			below), and that the subdirectory:
$!				device:[...username.WWWIndex]
$!			for holding the .IDX and .SEL files has been
$!			created in username's account, also parallel
$!			to the:
$!				device:[...username.userdir]
$!			public dirctory.  This script should reside
$!			in the user's WWWIndex subdirectory and be
$!			executed there.
$ v = f$verify(1)
$!
$! Create the Sequential files
$!
$ index := $dev:[dir.VMSIndex]build_index.exe
$ index /sequential/character=%x01 -
	/noise=dir:[dir.VMSIndex]noise_words.dat -
	/output=VMSGopherServer -
	[-.WWWDoc]VMSGopherServer.doc;0
$!
$! Sort and Convert the SEQIDX to an IDX file
$!
$ sort VMSGopherServer.seqidx VMSGopherServer.seqidx
$ convert/fdl=dev:[dir.VMSIndex]seqidx -
	VMSGopherServer.seqidx VMSGopherServer.idx
$!
$! Sort and Convert the SEQSEL to an SEL file
$!
$ sort VMSGopherServer.seqsel VMSGopherServer.seqsel
$ convert/fdl=dev:[dir.VMSIndex]seqsel -
	VMSGopherServer.seqsel VMSGopherServer.sel
$!
$! Clean up
$!
$ purge /nolog/noconfirm  VMSGopherServer.idx
$ rename/nolog/noconfirm  VMSGopherServer.idx ;1
$ delete/nolog/noconfirm  VMSGopherServer.seqidx;*
$ purge /nolog/noconfirm  VMSGopherServer.sel
$ rename/nolog/noconfirm  VMSGopherServer.sel ;1
$ delete/nolog/noconfirm  VMSGopherServer.seqsel;*
$ set file/prot=w:re VMSGopherServer.idx
$ set file/prot=w:re VMSGopherServer.sel
$ v = 'f$verify(0)'
$ WRITE SYS$OUTPUT ""
$exit
