$! 'f$verify(0)'
$!			UserSearch.COM
$!
$!	25-APR-1995	F.Macrides (macrides@sci.wfeb.edu)
$!			ISINDEX search script interface to the
$!			VMSIndex search engine (WWWquery) for
$!			/~username/* URLs.
$!			For use with CERN and OSU http servers.
$!
$!			Should be placed where your ISINDEX search script
$!			has been mapped in the server's configuration
$!			file, e.g.,
$!			  for CERN:	Search	/HTTPD_Dir/WWWsearch.COM
$!			  for OSU:	Search	WWW_Root:[bin]WWWsearch.com
$!
$!			UserSearch.COM is invoked automatically by
$!			WWWsearch.COM for /~username/path?query URLs.
$!			You also can invoke UserSearch.COM directly,
$!			as an Exec (htbin) script, via a link, e.g.:
$!
$!			 <A HREF="/htbin/usersearch/~username/myindex.html"
$!			 >Search MYINDEX file set</A>.
$!
$!			rather than <ISINDEX> tag in the html file, and
$!			you can use it as a starting point for scripts
$!			which search /~username/ databases as the ACTION
$!			for forms.
$!
$!			This script assumes that the user has his/her
$!			indexes (.IDX and .SEL files)
$!			in
$!			    device:[...username.WWWIndex]
$!			analogously to the user's
$!			    device:[...username.userdir]
$!			public WWW subdirectory.
$!
$!			See HTTP_IndexUser.com for an example indexing
$!			procedure.
$!
$!	26-APR-1995	F.Macrides (macrides@sci.wfeb.edu)
$!			Mods to make it work via WWWsearch.com for
$!			OSU server.
$!
$!	28-APR-1995	F.Macrides (macrides@sci.wfeb.edu)
$!			Use WWW_PATH_INFO for checking whether
$!			we were called from WWWsearch.com and
$!			don't need to set the CGI environment
$!			for the OSU server.
$!
$!----------------------------------------------------------------------------
$!
$!	WWWquery.c is my modification of Bruce Tanner's query.c for accessing
$!	foo.doc;*, foo.IDX;*, foo.SEL;* filesets.  The doc file(s) is(are)
$!	indexed with BUILD_INDEX.EXE, yielding the IDX and SEL filesets.
$!	This search engine was develeped by Bruce and colleagues associated
$!	with the VMSGopher-L@trln.lib.unc.edu list for use with the
$!	VMSGopherServer.  It is similar to WAIS, but uses native indexing
$!	facilities of the VMS Record Management System (RMS).
$!
$!	Build BUILD_INDEX.EXE, WWWquery.EXE (and QUERY.EXE, for the Gopher
$!	Server), by executing MAKE.COM.  It will check out your system and
$!	then use MMS or command files, and the appropriate foo.OPT files.
$!
$!	Read BUILD_INDEX.DOC for information about the indexer.  The IDX and
$!	SEL files built by the indexer are the same whether they're intended
$!	for use by the Gopher or HTTP Server, or from the DCL command line.
$!
$!	The example myindex.html ISINDEX document is for use with this
$!	script and an index of all HTML documents (i.e., which have extension
$!	.html) in a /~username/* tree.  The index should have been created
$!	with the example HTTP_INDEXUSERDIR.COM in this distribution, and
$!	reside in the WWWIndex subdirectory or the user's account, e.g.,
$!	device:[username.WWWIndex], parallel to the Userdir subdirectory,
$!	e.g., device:[username.WWW].
$!
$!	The symbol WWW_SEND_RAW_FILE must be made non-NULL (we set it equal
$!	to "YES", below, but any string will do, e.g., "TRUE"), so that
$!	WWWquery will not add html "packaging", as the .html file should
$!	already have a <HEAD> section with <TITLE>.
$!
$!	Note that the symbol WWW_OMIT_PRE_TAG, if defined, would cause
$!	the <PRE> tag to be omitted by WWWquery, but not the other html
$!	"packaging".  You want it all omitted, since you presumably
$!	indexed sets of complete, normally independent foo.html files.
$!
$!	The symbol WWW_SHOW_FILETYPE can be made non-NULL (e.g., "YES") to
$!	have icons (or ALT text) indicating the file types to be inserted
$!	into the hit lists returned from searches.
$!
$!	If the symbol WWW_MAXIMUM_HITS is made non-NULL (i.e., set equal to
$!	a number), then the hit lists returned by searches will be abridged,
$!	if necessary, so as not to exceed that number.
$!
$!	The symbol WWW_SHOW_SIZE can be made non-NULL (e.g., "YES") to have
$!	the size of each file or database section indicated in the hit lists.
$!
$!	The symbol WWW_SHOW_DATE can be made non-NULL to have the date of the
$!	database indicated in the hit lists (DD-MMM-YY).  If WWW_SHOW_TIME
$!	also is made non-NULL, for the current year the hour and minute will
$!	be indicated instead of the year (DD-MMM HH:MM).  If WWW_USE_MDATE is
$!	made non-NULL, the date of the last modification (e.g., from an
$!	APPEND) will be used.  The default is the file creation date (i.e.,
$!	of the highest version).
$!
$!	The symbol WWW_VMSINDEX_TITLE is set to a string for the TITLE tag
$!	in hit lists.
$!
$!	See the header of WWWquery.c for additional regulatory symbols.
$!
$!	Set up the foreign command definition for WWWquery, below (or define
$!	it in the CERN server's SpawnInit.COM).  This script must be in the
$!	server's htbin directory, but WWWquery.EXE can be anywhere that is
$!	accessible to the server (e.g., where you broke out and built the
$!	VMSIndex distribution).
$!
$!	For the OSU server, you also must have Set_DCL_Env.EXE in its htbin
$!      directory (read the header of Make_Set_DCL_Env.COM).
$!
$!----------------------------------------------------------------------------
$! WWWquery := "$device:[directory]WWWquery"
$!------------------------------------------
$ INDEX_SUBDIR = "WWWIndex"	! Homolog of Userdir configuration variable.
$!----------------------------------------------------------------------------
$ crlf = f$fao("!/") 
$!
$ If f$trnlnm("WWW_OUT") .nes. ""
$ Then	! CERN server
$    say = "write WWW_OUT"
$    put = "create WWW_OUT"
$    define_output   = "!"
$    deassign_output = "!"
$ Else	! OSU server
$    say = "write net_link"
$    put = "create net_link"
$    define_output   = "define/nolog sys$output net_link"
$    deassign_output = "deassign sys$output"
$    If f$type(WWW_PATH_INFO) .nes. "STRING" ! Not called from WWWsearch.com
$    Then
$        say "<DNETRECMODE>"	! Set implied carriage control
$        mcr 'f$parse("SET_DCL_ENV.EXE;",f$environment("PROCEDURE")) "WWW_"
$    EndIf
$ EndIf
$!
$ If WWW_REQUEST_METHOD .eqs. "HEAD"	! Request for header only.
$ Then
$   say "Content-type: text/html", crlf	! CGI header.
$   goto done
$ Endif
$!
$!----------------------------------------------------------------------------
$!
$! WWW_PATH_INFO has the ISINDEX URL in /~username format
$! and WWW_PATH_TRANSLATED has it fully translated.
$! We'll uppercase them and extract the database name
$! (foo from the .../foo.html tail) and the translations
$! we need.
$!
$ RAW_URL = f$edit(WWW_PATH_INFO,"COLLAPSE,UPCASE")
$ INDEX_DIR = f$edit(WWW_PATH_TRANSLATED,"COLLAPSE")
$ gosub EXTRACT_DATABASE_AND_TRANSLATIONS
$!
$!----------------------------------------------------------------------------
$!
$!  If no query, return a cover page.
$!
$ If WWW_KEY_COUNT .eq. 0	! No query is present.
$ Then
$   access = "http://" + f$edit(WWW_SERVER_NAME, "COLLAPSE,LOWERCASE")
$   if WWW_SERVER_PORT .ne. 80 then access = access + ":" + WWW_SERVER_PORT
$   script = WWW_SCRIPT_NAME + WWW_PATH_INFO
$!
$   say "Content-type: text/html", crlf	! CGI header.
$   say "<HTML>"
$   say "<HEAD>"
$   say "<TITLE>Search ''database' file set.</TITLE>"
$   say "<ISINDEX>"
$   say "</HEAD>"
$   say "<BODY>"
$   say "<H1>Search ''database' file set.</H1>"
$   say "The search matches your words against full document text. Access"
$   say "to this index is provided by the WWW to VMSIndex gateway. Please
$   say "specify <A HREF=""''access'/www/doc/searchwords.html"""
$   say ">search words</A> to find documents."
$   say "<p>"
$   say "Click <A HREF=""''access'''script'?title"">here</A> or use"
$   say "<em>title</em> as the search word to fetch a menu for all"
$   say "documents in this database."
$   say "</BODY>"
$   say "</HTML>"
$   goto done
$ Endif
$!
$!----------------------------------------------------------------------------
$!
$! Set the title based on the database name
$!
$ WWW_VMSINDEX_TITLE = "Search result for ''database' file set."
$!
$!----------------------------------------------------------------------------
$!
$! Add the location of the user's indexes.
$!
$ database = INDEX_DIR + database
$!
$! Hit list options:
$! =================
$  WWW_SEND_RAW_FILE = "YES"	! Send direct URL's without a Range
$  WWW_SHOW_FILETYPE = "YES"	! Show filetype icons or ALT strings
$  WWW_MAXIMUM_HITS = 250	! Limit number of hits to return
$  WWW_SHOW_SIZE = "YES"	! Bytes or KB
$! WWW_SHOW_DATE = "YES"	! DD-MMM-YY
$! WWW_SHOW_TIME = "YES"	! Replace -YY with HH:MM for current year
$! WWW_USE_MDATE = "YES"	! Use last modified date (default is creation)
$! WWW_VIA_FORM = "YES"		! Not relevant here.  See header of WWWquery.c
$! WWW_OMIT_IPATH_CONVERSION = "YES"	! See header of WWWquery.c
$!
$! Document options:
$! =================
$! WWW_OMIT_PRE_TAG = "YES"	! See header of WWWquery.c
$! WWW_DATADIRECTORY = "foo"	! See header of WWWquery.c
$! WWW_FORBIDDEN = "blah"	! See header of WWWquery.c
$! WWW_VMSINDEX_TITLE = "Wow"	! Was set above.
$!
$! Script options:
$! ===============
$! WWW_OMIT_CONTENT_TYPE = "YES"	! See header of WWWquery.c
$! WWW_OMIT_HEAD = "YES"		! See header of WWWquery.c
$! WWW_OMIT_FOOT = "YES"		! See header of WWWquery.c
$!
$!----------------------------------------------------------------------------
$!
$! Reconstruct the query (unescaped).
$!
$ query = WWW_KEY_1
$ num = 2
$ Loop:
$ If (WWW_KEY_COUNT - num) .ge. 0 
$ Then
$   query = query + " " + WWW_KEY_'num'
$   num = num + 1
$   goto Loop
$ EndIf
$!----------------------------------------------------------------------------
$!
$! Do the file set search.
$!
$ define_output
$ WWWquery "''database'" "''query'"
$ deassign_output
$!
$done:
$ exit
$!
$!************** EXTRACT_DATABASE_AND_TRANSLATIONS SUBROUTINE ****************
$! Extract database symbol from the initial INDEX_DIR symbol,
$! construct final INDEX_DIR from RAW_URL and USER_SUBDIR symbols,
$! and appropriately modify WWW_PATH_INFO and WWW_PATH_TRANSLATED
$! for substitutions by WWWquery.EXE in hit lists.
$!
$ EXTRACT_DATABASE_AND_TRANSLATIONS:
$ database = INDEX_DIR
$ trimming_loop:
$ offset = f$locate("/",database) + 1
$ If offset .le. f$length(database)
$ Then
$   database = f$extract(offset,f$length(database)-offset,database)
$   goto trimming_loop
$ Else
$   database = f$extract(0,f$locate(".",database),database)
$ Endif
$!
$ offset = f$locate("~",RAW_URL) + 1
$ If offset .le. f$length(RAW_URL)
$ Then
$   username = f$extract(offset,f$length(RAW_URL)-offset,RAW_URL)
$   offset = f$locate("/", username)
$   username = f$extract(0,offset,username)
$ Else
$   say "Content-Type: text/html", crlf		! Send the Header.
$   say "<TITLE>Error</TITLE>"
$   say "Could not translate ~username!"
$   exit
$ EndIf
$!
$ offset = f$locate(username,RAW_URL) + f$length(username) + 1
$ WWW_IPATH_INFO = f$extract(0,offset,WWW_PATH_INFO)
$!
$ offset = f$locate(username,INDEX_DIR) + f$length(username) + 1
$ If offset .le. f$length(INDEX_DIR)
$ Then
$   userdir = f$extract(offset,f$length(INDEX_DIR)-offset,-
					INDEX_DIR)
$   userdir = f$element(0,"/",userdir)
$   offset = offset + f$length(userdir) + 1
$   WWW_IPATH_TRANSLATED = f$extract(0,offset,WWW_PATH_TRANSLATED)
$!
$   offset = f$locate(username,INDEX_DIR) - 1
$   INDEX_DIR = f$extract(1,offset,INDEX_DIR)
$   num = 0
$   indexdir = f$element(num,"/",INDEX_DIR) + ":["
$ subdir_loop:
$   num = num + 1
$   subdir = f$element(num,"/",INDEX_DIR)
$   If subdir .nes. "/" .and. subdir .nes. ""
$   Then
$      indexdir = indexdir + subdir + "."
$      goto subdir_loop
$   EndIf
$   INDEX_DIR = indexdir + username + ".''INDEX_SUBDIR']"
$ Else
$   say "Content-Type: text/html", crlf		! Send the Header.
$   say "<TITLE>Error</TITLE>"
$   say "Could not translate user's index directory!"
$   exit
$ Endif
$ RETURN   
$!***************** END EXTRACT_DATABASE_AND_TRANSLATIONS ********************
