I {************************************************************************  *									*  *  J U M P								*  *									* F *  JUMP is a program which allows selected users (Operators, Systems	*C *  Programmers and other specifically authorised users) to either	* E *  change elements of their process to those of another user, or to	* E *  actually become a given user in a separate process attached to a	*  *  pseudo-terminal.							*  *									* C *  When not becoming exactly the target user, the items which are	* 0 *  changed to those of the target user are:				* *									* @ *    Username (Systems Programmers only, using the SETUSER or		* *	       ALL qualifier)						* *									* 9 *    UIC, Default Directory, Default Disk, LNM$GROUP.			*  *									* 7 *    Privileges and process rights are NOT changed.			*  *									* 3 *  The syntax of the JUMP command generally is				*  *									* + *      $ JUMP [username] [qualifiers]					*  *									* I *  If no username is supplied, JUMP returns the UIC, Default Directory, * B *  Default Disk and LNM$GROUP to those of the current username. 	* *									* I *  For full documentation, see the HELP file (JUMP.HLP) and the example * ' *  access file (JUMP_ACCESS.DAT).					* I *.......................................................................* = *  ****  CAUTION: KERNEL-mode code fiddles things !!! ****		*  *									* . *  INSTALL with the following privileges:				*< *	CMEXEC, CMKRNL, DETACH (or IMPERSONATE), SYSNAM, SYSPRV 	* *									* H *  NOTE: The definition of privilege sets has been adopted for ease of	*H *  coding.  The source for the information is SYS$LIBRARY:STARLET.PAS.	*E *  The definition will need reviewing with each release of OpenVMS!	* I *.......................................................................* D *  Note: Some ideas in this code have been drawn from Eric Wentz's	*> *	 program BECOME.  The code for pseudo-terminal creation is	*> *	 derived from Anthony McCracken's GLOGIN program.  Special	*? *	 thanks to Jeremy Begg for code to do session recording and	* = *	 some minor code fixes.  Thanks also to Bob Beckerhof for	*  *	 testing.							* I *.......................................................................* # *  Author:  Jonathan Ridler,						* + *	    Information Technology Services,				* ' *	    The University of Melbourne,				*   *	    Parkville, Victoria,					* *	    AUSTRALIA, 3052.						*  *									* , *	    Internet: jonathan@unimelb.edu.au				*I *.......................................................................*  *  History:								*, * v1.0	02-Mar-1993	JER	Original version.			*/ *	09-Mar-1993	JER	Audit security violations.		* 4 *	04-Mar-1994	JER	Add change username capability. 	*; *	14-Jul-1994	JER	Allow change of UIC, etc. AND username; * " *				Allow username NOT in UAF.		*3 *	21-Nov-1995	JER	Allow Sysprogs to avoid audit.		* ? * v1.4	11-Jan-1996	JER	Increase size of audit message buffer.	* : * v2.0	11-Jul-1996	JER	Add EXACT (pseudo-terminal) form.	*< * v2.1	26-Jul-1996	JER	Add general user restricted access.	*? * v2.2	07-Aug-1996	JER	Only Sysprogs and authorised users can	* - *				jump to privileged users. Also, modify	* * *				method of restoring terminal chars.	*? * v2.3	12-Sep-1996	JER	Audit physical terminal device.  Also,	* - *				validate Operators against access file	* . *				to see if access is specifically denied.*. *				Also, allow minor privs to be specified * *				by logical name.			* ? * v2.4	16-Sep-1996	JER	Audit pseudo-terminal device name too.	* 1 * v2.5	17-Sep-1996	JER	Add JUMP_SELF logical.			* = * v2.6	01-Nov-1996	JER	Fix username glitch on EXACT return.	* . *				Caused by VAX (only) compiler behaviour.*; * v2.7	15-Nov-1996	JER	Validate current privs at startup.	* ; * v2.8	09-Jan-1997	JER	Fix short string in audit routine.	* < * v2.9	18-Sep-1997	JER	Improve kernel and exec mode code -	*. *				simplify and generalize. Also, put port *, *				name into pseudo-terminal ACCPORNAM -	*, *				this introduces architecture-specific	* *				code modules.				* = * v3.0	26-Jun-1998	JER	Fix audit to log correct return UIC.	* = * v3.1	15-Oct-1999	JB/JER	Changes based on code supplied by	* ' *				Jeremy Begg (JB) - with thanks: 	* ' *				- For EXACT jumps, added session	* * *				  logging and notification by MAIL.	* *				- Minor code fixups.			*  *				Other changes:				*, *				- For EXACT jumps, added notification	* *				  by OPCOM.				* , *				- Added support for notifications and	*, *				  session logging to the access file.	*- *				- Added support for continuation lines	*  *				  in the access file.			*> * v3.1a 19-Oct-1999	JER	Tidy up and add '+' and '=' options.	*? * v3.2	26-Oct-1999	JER	Implement access via UIC or Rights ID.	* 4 * v3.3	03-Nov-1999	JER	Correct some minor issues.		*@ * v3.4	10-Nov-1999	JER	Avoid typeahead issues at EXACT rundown;*) *				Add JUMP_MATCH_BOTH functionality.	* I ************************************************************************}     [INHERIT ('SYS$LIBRARY:STARLET',% 	  'SYS$LIBRARY:PASCAL$LIB_ROUTINES', & 	  'SYS$LIBRARY:PASCAL$MAIL_ROUTINES',& 	  'SYS$LIBRARY:PASCAL$STR_ROUTINES')]    PROGRAM Jump (OUTPUT, Logfile) ;   CONST    Bell = CHR (07) ;		{ BEL } Xon  = CHR (17) ;		{ XON } Xoff = CHR (19) ;		{ XOFF }  Lf   = CHR (10) ;		{ Linefeed } & Cr   = CHR (13) ;		{ Carriage Return }  B Io_Buflen = 1 * 512 ;		{ *WORDS* = 1 pair of 512 byte R/W blocks }< Rsts = 1 ;			{ Index to read status in pseudo-terminal buf }; Rcnt = 2 ;			{ Count of chars read in pseudo-terminal buf } - Rbuf = 3 ;			{ Actual read data area begins } L Wsts = Io_Buflen DIV 2 + 1 ;	{ Start of write buffer area and write status }A Wcnt = Wsts + 1 ;		{ Count of chars writ in pseudo-terminal buf } 3 Wbuf = Wsts + 2 ;		{ Actual read data area begins } E Ft_Buflen = Io_Buflen - 4 ;	{ *BYTES* Size of buffer for FTA device } B Py_Buflen = Io_Buflen ; 	{ *BYTES* Size of buffer for PYA device }  > Rightsize = 80 ;		{ Number of rightslist entries to retrieve }   Bad_Access_Data = N    '%JUMP-F-BADDATA, Format of Access List data record seems to be invalid.' ;  ! Alphanum  = ['0'..'9','A'..'Z'] ;  Wildcard  = ['*','%'] ; ! Symbol	  = Alphanum + ['$','_'] ;  Uic_Left  = ['[','<'] ;  Uic_Right = [']','>'] ;    TYPE  " $BOOL  = [BIT(1),UNSAFE] BOOLEAN ; $UBYTE = [BYTE] 0..255 ; $UWORD = [WORD] 0..65535 ;: $UQUAD = [QUAD,UNSAFE] RECORD  L0 , L1 : UNSIGNED ;  END ;   Word_Ptr     = ^$UWORD ; Unsigned_Ptr = ^UNSIGNED ;  6 Privilege = (Cmkrnl,	{  0: May change Mode to Kernel }A 	     Cmexec,	{  1: May change Mode to Exec; MUST follow Cmkrnl } = 	     Sysnam,	{  2: May insert in system logical name table } E 	     Grpnam,	{  3: May insert in group l.n.tab; MUST follow Sysnam } 3 	     Allspool,	{  4: May allocate spooled device } E 	     Detach,	{  5: May create detached processes (aka Impersonate) } , 	     Diagnose,	{  6: May diagnose devices }( 	     Log_Io,	{  7: May do logical I/O }A 	     Group,	{  8: May affect other processes in same UIC group } + 	     Acnt,	{  9: May suppress accounting } @ 	     Prmceb,	{ 10: May create permanent common event clusters }3 	     Prmmbx,	{ 11: May create permanent mail box } - 	     Pswapm,	{ 12: May change process mode } 0 	     Altpri,	{ 13: May set any priority value }0 	     Setprv,	{ 14: May set any privilege bits }2 	     Tmpmbx,	{ 15: May create temporary mailbox }< 	     World,	{ 16: May affect other processes in the world }4 	     Mount,	{ 17: May execute mount ACP functions }& 	     Oper,	{ 18: Operator privilege }- 	     Exquota,	{ 19: May exceed disk quotas } / 	     Netmbx,	{ 20: May create network device } 4 	     Volpro,	{ 21: May override volume protection }) 	     Phy_Io,	{ 22: May do physical I/O } : 	     Bugchk,	{ 23: May make bug check error log entries }: 	     Prmgbl,	{ 24: May create permanent global sections }< 	     Sysgbl,	{ 25: May create system-wide global sections }/ 	     Pfnmap,	{ 26: May map to section by PFN } = 	     Shmem,	{ 27: May allocate structures in shared memory } : 	     Sysprv,	{ 28: Eligible for system protection field }5 	     Bypass,	{ 29: May bypass UIC-based protection } 2 	     Syslck,	{ 30: May create system-wide locks }< 	     Share,	{ 31: May assign channel to non-shared device }3 	     Upgrade,	{ 32: May upgrade object integrity } 5 	     Downgrade, { 33: May downgrade object secrecy } > 	     Grpprv,	{ 34: Group access via system protection field }* 	     Readall,	{ 35: May read any object }A 	     Import,	{ 36: May set classification for unlabeled object } B 	     Audit,	{ 37: May direct audit to system security audit log }6 	     Security,	{ 38: May perform security functions }= 	     Pbit39, Pbit40, Pbit41, Pbit42, Pbit43, Pbit44, Pbit45, = 	     Pbit46, Pbit47, Pbit48, Pbit49, Pbit50, Pbit51, Pbit52, = 	     Pbit53, Pbit54, Pbit55, Pbit56, Pbit57, Pbit58, Pbit59, F 	     Pbit60, Pbit61, Pbit62, Pbit63) ;	{ 39-63: dummy bits: 2 LONGs }  C Privset = PACKED SET OF Privilege ;		{ Allow easy bit union, etc. }   J Access_Status = (Granted,Denied,Unspecified) ;	{ Status from access file }  < Status_Block_Type = [UNSAFE] PACKED ARRAY [1..4] OF $UWORD ;   Item_List_Cell = RECORD  		   CASE INTEGER OF 		     1: (			{ Normal Cell }  			 Buffer_Length : $UWORD ; 			 Item_Code     : $UWORD ; 			 Buffer_Addr   : UNSIGNED ; 			 Return_Addr   : UNSIGNED 			) ; 		     2: (			{ Terminator } 			 Terminator    : UNSIGNED 			) ; 		 END ;  I Item_List_Template (Count:INTEGER) = ARRAY [1..Count] OF Item_List_Cell ;   . Username_Type = PACKED ARRAY [1..12] OF CHAR ;  / Rights_Array = ARRAY [1..Rightsize] OF $UQUAD ;   < Io_Buffer = [ALIGNED(9),STATIC,UNSAFE]			{ Pagelet aligned }- 		ARRAY [1..Io_Buflen] OF $UWORD	VALUE ZERO ;    Terminal_Chars = PACKED RECORD% 		   Tt_Class    : [POS(0)]  $UBYTE ; % 		   Tt_Type     : [POS(8)]  $UBYTE ; % 		   Tt_Width    : [POS(16)] $UWORD ; & 		   Tt_Devchar  : [POS(32)] TT$TYPE ;' 		   Tt_Devchar2 : [POS(64)] TT2$TYPE ;  		 END ;   Prtctl_Type = PACKED RECORD + 		TTY$V_PC_NOTIME       : [POS(0)]  $BOOL ; + 		TTY$V_PC_DMAENA       : [POS(1)]  $BOOL ; + 		TTY$V_PC_DMAAVL       : [POS(2)]  $BOOL ; + 		TTY$V_PC_PRMMAP       : [POS(3)]  $BOOL ; + 		TTY$V_PC_MAPAVL       : [POS(4)]  $BOOL ; + 		TTY$V_PC_XOFAVL       : [POS(5)]  $BOOL ; + 		TTY$V_PC_XOFENA       : [POS(6)]  $BOOL ; + 		TTY$V_PC_NOCRLF       : [POS(7)]  $BOOL ; * 		TTY$V_PC_BREAK	      : [POS(8)]  $BOOL ;+ 		TTY$V_PC_PORTFDT      : [POS(9)]  $BOOL ; + 		TTY$V_PC_NOMODEM      : [POS(10)] $BOOL ; + 		TTY$V_PC_NODISCONNECT : [POS(11)] $BOOL ; + 		TTY$V_PC_SMART_READ   : [POS(12)] $BOOL ; + 		TTY$V_PC_ACCPORNAM    : [POS(13)] $BOOL ; + 		TTY$V_PC_MULTISESSION : [POS(15)] $BOOL ;  	      END ;   Notify_Mask = RECORD 		CASE INTEGER OF 7 		1: (All_Bits	: UNSIGNED ;) ; 	{ 32 bits - roomy! :) } < 		2: (After	: [BIT, POS(0)] BOOLEAN ;    { EXACT completed }= 		    Before	: [BIT, POS(1)] BOOLEAN ;    { EXACT initiated } > 		    Include_Log : [BIT, POS(2)] BOOLEAN ;    { Log in MAIL }8 		    By_Mail	: [BIT, POS(3)] BOOLEAN ;    { Send MAIL }= 		    By_Opcom	: [BIT, POS(4)] BOOLEAN ;) ; { OPCOM message }  	      END ;   CONST   N Required_Privs = [Cmexec,Cmkrnl,Detach,Sysnam,Sysprv] ; { Needed to run JUMP }   VAR   " Log ,				{ Log success messages? }" Alter_Ego ,			{ Change Username? }# Transmute ,			{ Change UIC, etc.? } ( Auditing ,			{ Audit successful jumps? }= Real_Mccoy ,			{ Use a pseudo-terminal and *really* do it!? } 8 Double_Check ,			{ Double check general user's access? }4 Narcissus ,			{ Allow users to jump to themselves? }* Figment ,			{ Allow username NOT in UAF? }? Match_Both ,			{ Match both source and target to allow access } . Suspect ,			{ Trying to subvert Secure Mode? }. Houdini ,			{ Allow override of Secure Mode? }* Secure_Mode ,			{ Secure mode requested? }- System_Secure_Mode		{ Secure mode mandated? }   : BOOLEAN := FALSE ;   7 Record_Session			{ Make a recording of an EXACT jump? }    : [VOLATILE] BOOLEAN := FALSE ;  K Max_Sys_Group : INTEGER := 0 ;	{ Maximum UIC group with system privileges }   K Orig_User : VARYING [12] OF CHAR := PAD ('',' ',12) ;	{ Caller's username }   O New_User : [VOLATILE] VARYING [12] OF CHAR := PAD ('',' ',12) ; { Target user }   + Sanity_Ctl_User ,					{ For CMKRNL checks } H Sanity_Jib_User : [VOLATILE] Username_Type := '' ;	{ For CMKRNL checks }  ? Command : VARYING [80] OF CHAR := '' ;			{ Input command line }    Uic ,							{ UIC of caller } @ New_Uic : [VOLATILE] UIC$TYPE := ZERO ; 		{ UIC of target user }   Terminal ,						{ Audit this } Port ,							{ Audit this } $ Physical_Device ,					{ Audit this }D Def_Dev : [VOLATILE] VARYING [64] OF CHAR := '' ;	{ Default device }  3 Secure_Directory ,				{ Directory for secure logs } 3 User_Directory ,				{ Directory for insecure logs } - Session_Log ,					{ Filespec of session log }  Access_List ,					{ Filespec }8 Audit_Trail : VARYING [255] OF CHAR := '' ;	{ Filespec }  H Def_Dir : [VOLATILE] VARYING [255] OF CHAR := '' ;	{ Default directory }  D Notify_Maillist : VARYING [1022] OF CHAR := '' ;	{ Where to notify }  9 Uic_Str : VARYING [15] OF CHAR := ZERO ;		{ String form }   ( Eq_Id_Str ,						{ UIC string handling }@ Id_Str	: VARYING [32] OF CHAR := ZERO ;		{ UIC string handling }  * Minor_Privs ,						{ Not major privs! :) }' Def_Priv ,						{ Target's def  privs } H Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ;	{ Target's auth privs }  @ Flags : [VOLATILE]  FLAGS$TYPE := ZERO ;		{ Target's UAF flags }  7 Notify : Notify_Mask := ZERO ;			{ Notification flags }   < Jib_User_Ptr : [VOLATILE] ^[VOLATILE] Username_Type := NIL ;  	 Jib_Ptr , * Uic_Ptr : [VOLATILE] Unsigned_Ptr := NIL ;  / Pchan_Created , 				{ Has Pchan been created? } G Pseudo_Ft : [VOLATILE] BOOLEAN := FALSE ;	{ Is pseudo-terminal FTA0:? }   ( Pchan , 					{ Pseudo-terminal channel }& Rchan , 					{ Real terminal channel }5 Mchan : [VOLATILE] $UWORD := 0 ;		{ Mailbox channel }   D Pdev : VARYING [12] OF CHAR := '' ;		{ Pseudo-terminal device name }  O Pbuf_Range : ARRAY [1..2] OF UNSIGNED := ZERO ; { Quasi descriptor of I/O buf }   L Mbbuf : ARRAY [1..ACC$K_TERMLEN] OF $UBYTE := ZERO ;	{ Termination MBX buf }  O Piosb : [VOLATILE] Status_Block_Type := ZERO ;	{ IOSB for pseudo-terminal IOs }   G Buffer : [VOLATILE] Io_Buffer := ZERO ; 	{ Pseudo-terminal I/O buffer }   @ Rchars : Terminal_Chars := ZERO ;		{ Device chars of real term }  & Exit_Rst ,					{ Exit Handler status }" Pid ,						{ Current process PID }/ Master_Pid ,					{ Current process master PID } E Proc_Cnt : [VOLATILE] UNSIGNED := 0 ;		{ Current proc subproc count }   4 Proc_Cur_Priv ,					      { Caller's current privs }4 Proc_Def_Priv ,					      { Caller's default privs }P Proc_Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ; { Caller's auth'd  privs }  2 Caller_Rights ,					      { Caller's proc rights }2 Target_Rights ,					      { Target's proc rights }? System_Rights : Rights_Array := ZERO ;		      { System rights }   = Login_Time : $UQUAD := ZERO ;			      { Caller's login time }   K Login_Time_Str : VARYING [23] OF CHAR := '' ;	      { Caller's login time }   K Process_Name : VARYING [16] OF CHAR := '' ;	      { Caller's process name }   E Null_List : Item_List_Template(1) := ZERO ;	      { Empty item list }   ; Logfile : [VOLATILE] TEXT ;			{ Logfile for EXACT session }    PCB$L_JIB ,  PCB$L_UIC ,  UCB$W_TT_PRTCTL ,  UCB$L_TT_ACCPORNAM , JIB$T_USERNAME , PAS$K_SUCCESS , - PAS$K_FILNOTFOU : [EXTERNAL,VALUE] UNSIGNED ;    CTL$GL_PCB ,( CTL$GA_CCB_TABLE : [EXTERNAL] UNSIGNED ;  4 CTL$T_USERNAME : [EXTERNAL,VOLATILE] Username_Type ;    O { The following formal function declarations are present to allow compatability I   with OpenVMS v5.5-2 and lower where these declarations do not appear in N   environment files.  For OpenVMS v6.0 (I think) and onwards, $SETDDIR appearsC   in STARLET, and the CLI routines appear in PASCAL$CLI_ROUTINES. }   % [ASYNCHRONOUS] FUNCTION SYS$SETDDIR (  	New_Dir_Addr : A 		[CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR := %IMMED 0 ; 2 	VAR Length_Addr : [VOLATILE] $UWORD := %IMMED 0 ; 	%STDESCR Cur_Dir_Addr :7 		PACKED ARRAY [$L3..$U3:INTEGER] OF CHAR := %IMMED 0 )  		: UNSIGNED ; EXTERNAL ;   ' [ASYNCHRONOUS] FUNCTION CLI$DCL_PARSE (  	Command_String : A 		[CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR := %IMMED 0 ; 0 	%IMMED [ASYNCHRONOUS,UNBOUND] PROCEDURE Table ; 	%IMMED [ASYNCHRONOUS,UNBOUND]0 		FUNCTION Param_Routine	: INTEGER := %IMMED 0 ; 	%IMMED [ASYNCHRONOUS,UNBOUND]1 		FUNCTION Prompt_Routine : INTEGER := %IMMED 0 ;u 	Prompt_String :A 		[CLASS_S] PACKED ARRAY [$L5..$U5:INTEGER] OF CHAR := %IMMED 0 )o 		: UNSIGNED ; EXTERNAL ;n  ' [ASYNCHRONOUS] FUNCTION CLI$GET_VALUE (rB 	Entity_Desc : [CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR ;) 	%DESCR Retdesc : VARYING [$L2] OF CHAR ; 0 	VAR Retlength : [VOLATILE] $UWORD := %IMMED 0 ) 		: UNSIGNED ; EXTERNAL ;   % [ASYNCHRONOUS] FUNCTION CLI$PRESENT ( B 	Entity_Desc : [CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR ) 		: UNSIGNED ; EXTERNAL ;     . PROCEDURE Exit (Msg : VARYING [Len] OF CHAR) ;  # { Just a dinky shorthand routine. }M     BEGIN 	{ Exit }	   WRITELN (Msg) ;e	   $EXIT ;s   END ; 	{ of Exit }     FUNCTION Get_Logical_Name (n< 		Lognam	: [CLASS_S] PACKED ARRAY [L1..U1:INTEGER] OF CHAR ;# 		Default : VARYING [Sz1] OF CHAR ;	& 		VAR Actual : VARYING [Sz2] OF CHAR ;< 		Table	: [CLASS_S] PACKED ARRAY [L2..U2:INTEGER] OF CHAR := 				'LNM$FILE_DEV' ; 		Mode	: $UBYTE := PSL$C_USER ;  		Lnm_Index  : UNSIGNED := 0 		) : UNSIGNED ;  K { Get the translation of the logical name specified.  If it does not exist,	M   use the default value if the index is zero, or flag a non-existant index. }.     VAR Rst : UNSIGNED := 0 ;d%       Attributes : LNM$TYPE := ZERO ;	3       Item_List  : Item_List_Template (4) := ZERO ;	  "   BEGIN       { Get_Logical_Name }#   Item_List[1].Buffer_Length := 4 ;	,   Item_List[1].Item_Code     := LNM$_INDEX ;6   Item_List[1].Buffer_Addr   := IADDRESS (Lnm_Index) ;#   Item_List[1].Return_Addr   := 0 ;R  3   Item_List[2].Buffer_Length := SIZE (Attributes) ;e1   Item_List[2].Item_Code     := LNM$_ATTRIBUTES ;.7   Item_List[2].Buffer_Addr   := IADDRESS (Attributes) ;t#   Item_List[2].Return_Addr   := 0 ;d  4   Item_List[3].Buffer_Length := SIZE (Actual.BODY) ;-   Item_List[3].Item_Code     := LNM$_STRING ;o8   Item_List[3].Buffer_Addr   := IADDRESS (Actual.BODY) ;:   Item_List[3].Return_Addr   := IADDRESS (Actual.LENGTH) ;  A   Item_List[4].Terminator    := 0 ;   { Terminate the item list }i  1   Rst := $TRNLNM (Attr	 := %REF LNM$M_CASE_BLIND,. 		  Tabnam := Table, 		  Lognam := Lognam,: 		  Acmode := %REF Mode, 		  Itmlst := Item_List) ;   Get_Logical_Name := Rst ;      IF Rst = SS$_NOLOGNAM  THEN	      Actual := Default    ELSE	C   IF (Rst = SS$_NORMAL) AND_THEN (NOT Attributes.LNM$V_EXISTS)	THENuP      Get_Logical_Name := SS$_VALNOTVALID       { Index not found - tell caller }    ELSE.H   IF Rst = SS$_BUFFEROVF  THEN		     { Do nothing - caller must handle }    ELSE9   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;	%   END ;       { of Get_Logical_Name }     2 FUNCTION Oprmsg (Message : VARYING [Len] OF CHAR ;( 		 Reply : BOOLEAN := FALSE) : BOOLEAN ;  I { Send an operator message (REQUEST).  Limit size to maximum (128 chars).ID   If required, wait for a REPLY and flag if an ABORT was received. }     VAR	Rst : UNSIGNED := 0 ;  	Mbx_Chan : $UWORD := 0 ;g+ 	Msg_Text : VARYING [128] OF CHAR := ZERO ;u 	Opr_Reply : OPC$TYPE := ZERO ;o# 	Iosb : Status_Block_Type := ZERO ;i 	Msg_Dsc : DSC1$TYPE := ZERO ; 	Msg : PACKED RECORD 		Msg_Type : $UBYTE ;2# 		Msg_Targ : [BYTE(3)] 0..2**24-1 ;m 		Msg_Rqst : UNSIGNED ;	( 		Mess : PACKED ARRAY [1..128] OF CHAR ; 	      END := ZERO ;     BEGIN 	{ Oprmsg }i!   Oprmsg := TRUE ;				{ Default }t     IF Message.LENGTH > 128  THENa=      Msg_Text := SUBSTR (Message.BODY,1,128)	{ Max msg size }a    ELSE       Msg_Text := Message ;    Msg.Msg_Type := OPC$_RQ_RQST ;4   Msg.Msg_Targ := OPC$M_NM_CENTRL + OPC$M_NM_TAPES ;   Msg.Msg_Rqst := 0 ;n!   Msg.Mess     := Msg_Text.BODY ;-2   Msg_Dsc.DSC$W_MAXSTRLEN := 8 + Msg_Text.LENGTH ;J   Msg_Dsc.DSC$B_DTYPE	  := DSC$K_DTYPE_T ;	{ Not essential ... but neat! }-   Msg_Dsc.DSC$A_POINTER   := IADDRESS (Msg) ; *   Msg_Dsc.DSC$B_CLASS	  := DSC$K_CLASS_S ;     IF Reply  THEN
      BEGIN<      Rst := $CREMBX (Chan := Mbx_Chan) ;		{ Create mailbox }      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;F
      END ;  F   Rst := $SNDOPR (%REF Msg_Dsc,%IMMED Mbx_Chan) ;	{ Send to Operator }   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;k     IF Reply  THEN
      BEGIN<      Rst := $QIOW (Chan := Mbx_Chan,			{ Read from mailbox } 		   Func := IO$_READVBLK, 		   P1	:= Opr_Reply,	 		   P2	:= SIZE (Opr_Reply), 		   Iosb := Iosb) ;      IF NOT ODD (Rst)  THEN- 	LIB$SIGNAL (Rst)n
       ELSE      IF NOT ODD (Iosb[1])  THEN  	LIB$SIGNAL (Iosb[1]) ;-  A      Rst := Opr_Reply.OPC$W_MS_STATUS + 65536 * OPCOM$_FACILITY ;	"      IF Rst = OPC$_RQSTABORT  THEN 	Oprmsg := FALSE
       ELSE      IF NOT ODD (Rst)  THENe 	LIB$SIGNAL (Rst) ;r  5      Rst := $DASSGN (Mbx_Chan) ;			{ Delete mailbox }       IF NOT ODD (Rst)  THEN9 	LIB$SIGNAL (Rst) ;i
      END ;   END ; 	{ of Oprmsg }    P FUNCTION  Str_Compress (Source : [CLASS_S] PACKED ARRAY [L..U:INTEGER] OF CHAR ;$ 			VAR  Dest : VARYING [D] OF CHAR ;, 			Collapse : BOOLEAN := FALSE) : UNSIGNED ;  L { Compress a string by removing leading and trailing white space (blanks andL   tabs), and replacing multiple consecutive white space with a single blank./   If collapse is set, remove ALL white space. }C  %   CONST  Blanks = [' ',''(9),''(0)] ;{ 	 Maxsize = 1024 ;F 	 Warn_Inpstrtru = UAND (LIB$_INPSTRTRU,%Xfffffff8) ;	{ Warning only }  !   VAR  S , J , K : INTEGER := 0 ;=         Done : BOOLEAN := FALSE ;,        Spacer : VARYING [1] OF CHAR := ' ' ;5        Dstr, Sstr : VARYING [Maxsize] OF CHAR := '' ;t     BEGIN 	{ Str_Compress } .   Str_Compress := SS$_NORMAL ;		{ Presume so }   S := LENGTH (Source) ;  %   IF S = 0  THEN			{ Nothing passed }r      Dest := ''i    ELSE 
      BEGIN      IF S > Maxsize  THEN  	BEGIN$ 	Sstr := SUBSTR (Source,1,Maxsize) ;& 	Str_Compress := INT(Warn_Inpstrtru) ; 	END
       ELSE 	Sstr := Source ;S  %      IF Collapse  THEN	Spacer := '' ;z  D      IF FIND_MEMBER (Source,Blanks) = 0  THEN		{ Nothing to change }
 	Dstr := Sstr-
       ELSE 	WHILE NOT Done	DO 	  BEGIN& 	  J := FIND_NONMEMBER (Sstr,Blanks) ; 	  IF J = 0  THEN' 	     Done := TRUE 	   ELSE 	     BEGINA/ 	     Sstr := SUBSTR (Sstr,J,Sstr.LENGTH-J+1) ; & 	     K := FIND_MEMBER (Sstr,Blanks) ; 	     IF K = 0  THEN 		BEGIN  		Dstr := Dstr + Sstr ;  		Done := TRUE ; 		END; 	      ELSEU 		BEGIN]/ 		Dstr := Dstr + SUBSTR (Sstr,1,K-1) + Spacer ; + 		Sstr := SUBSTR (Sstr,K,Sstr.LENGTH-K+1) ;  		END ;  	     END ;  	  END ; 	{ of While }        IF Dstr <> ''  THEN! 	IF Dstr[Dstr.LENGTH] = ' '  THENw* 	   Dstr:= SUBSTR (Dstr,1,Dstr.LENGTH-1) ;        IF Dstr.LENGTH <= D  THEN
 	Dest := Dstr3
       ELSE 	BEGIN 	Dest := SUBSTR (Dstr,1,D) ;! 	Str_Compress := LIB$_OUTSTRTRU ;a 	END ;
      END ;   END ; 	{ of Str_Compress }     PROCEDURE Get_System_Info ;o  : { Get relevant information about the system environment. }     VAR	Rst : INTEGER := 0 ;# 	Iosb : Status_Block_Type := ZERO ;t- 	Item_List : Item_List_Template (3) := ZERO ;	     BEGIN 	{ Get_System_Info }#   Item_List[1].Buffer_Length := 4 ;a2   Item_List[1].Item_Code     := SYI$_MAXSYSGROUP ;:   Item_List[1].Buffer_Addr   := IADDRESS (Max_Sys_Group) ;#   Item_List[1].Return_Addr   := 0 ;3  6   Item_List[2].Buffer_Length := SIZE (System_Rights) ;4   Item_List[2].Item_Code     := SYI$_SYSTEM_RIGHTS ;:   Item_List[2].Buffer_Addr   := IADDRESS (System_Rights) ;#   Item_List[2].Return_Addr   := 0 ;{  A   Item_List[3].Terminator    := 0 ;   { Terminate the item list }i  '   Rst := $GETSYIW (Itmlst := Item_List,i 		   Iosb   := Iosb) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)p    ELSE    IF NOT ODD (Iosb[1])	THENn      LIB$SIGNAL (Iosb[1]) ;o   END ; 	{ of Get_System_Info }      PROCEDURE Get_Caller_Info ;e  > { Get relevant information about the invoker of the program. }     VAR	Rst : INTEGER := 0 ;# 	Iosb : Status_Block_Type := ZERO ; . 	Item_List : Item_List_Template (15) := ZERO ;     BEGIN 	{ Get_Caller_Info }#   Item_List[1].Buffer_Length := 8 ; /   Item_List[1].Item_Code     := JPI$_PROCPRIV ;d:   Item_List[1].Buffer_Addr   := IADDRESS (Proc_Def_Priv) ;#   Item_List[1].Return_Addr   := 0 ;-  #   Item_List[2].Buffer_Length := 8 ;s/   Item_List[2].Item_Code     := JPI$_AUTHPRIV ;,;   Item_List[2].Buffer_Addr   := IADDRESS (Proc_Auth_Priv) ;:#   Item_List[2].Return_Addr   := 0 ;   #   Item_List[3].Buffer_Length := 8 ; .   Item_List[3].Item_Code     := JPI$_CURPRIV ;:   Item_List[3].Buffer_Addr   := IADDRESS (Proc_Cur_Priv) ;#   Item_List[3].Return_Addr   := 0 ;{  #   Item_List[4].Buffer_Length := 4 ;y*   Item_List[4].Item_Code     := JPI$_UIC ;:   Item_List[4].Buffer_Addr   := IADDRESS (Uic.UIC$L_UIC) ;#   Item_List[4].Return_Addr   := 0 ;b  2   Item_List[5].Buffer_Length := SIZE (Orig_User) ;/   Item_List[5].Item_Code     := JPI$_USERNAME ;b;   Item_List[5].Buffer_Addr   := IADDRESS (Orig_User.BODY) ;6=   Item_List[5].Return_Addr   := IADDRESS (Orig_User.LENGTH) ;	  #   Item_List[6].Buffer_Length := 4 ;e*   Item_List[6].Item_Code     := JPI$_PID ;0   Item_List[6].Buffer_Addr   := IADDRESS (Pid) ;#   Item_List[6].Return_Addr   := 0 ;D  #   Item_List[7].Buffer_Length := 4 ;S1   Item_List[7].Item_Code     := JPI$_MASTER_PID ;u7   Item_List[7].Buffer_Addr   := IADDRESS (Master_Pid) ; #   Item_List[7].Return_Addr   := 0 ;n  #   Item_List[8].Buffer_Length := 4 ;	-   Item_List[8].Item_Code     := JPI$_PRCCNT ; 5   Item_List[8].Buffer_Addr   := IADDRESS (Proc_Cnt) ;=#   Item_List[8].Return_Addr   := 0 ;   2   Item_List[9].Buffer_Length := SIZE (Port.BODY) ;3   Item_List[9].Item_Code     := JPI$_TT_ACCPORNAM ;o6   Item_List[9].Buffer_Addr   := IADDRESS (Port.BODY) ;8   Item_List[9].Return_Addr   := IADDRESS (Port.LENGTH) ;  7   Item_List[10].Buffer_Length := SIZE (Terminal.BODY) ;B0   Item_List[10].Item_Code     := JPI$_TERMINAL ;;   Item_List[10].Buffer_Addr   := IADDRESS (Terminal.BODY) ;(=   Item_List[10].Return_Addr   := IADDRESS (Terminal.LENGTH) ;D  >   Item_List[11].Buffer_Length := SIZE (Physical_Device.BODY) ;4   Item_List[11].Item_Code     := JPI$_TT_PHYDEVNAM ;B   Item_List[11].Buffer_Addr   := IADDRESS (Physical_Device.BODY) ;D   Item_List[11].Return_Addr   := IADDRESS (Physical_Device.LENGTH) ;  7   Item_List[12].Buffer_Length := SIZE (Caller_Rights) ;$K   Item_List[12].Item_Code     := JPI$_RIGHTSLIST ;	    { Process + System }B;   Item_List[12].Buffer_Addr   := IADDRESS (Caller_Rights) ;C$   Item_List[12].Return_Addr   := 0 ;  $   Item_List[13].Buffer_Length := 8 ;0   Item_List[13].Item_Code     := JPI$_LOGINTIM ;8   Item_List[13].Buffer_Addr   := IADDRESS (Login_Time) ;$   Item_List[13].Return_Addr   := 0 ;  %   Item_List[14].Buffer_Length := 16 ; .   Item_List[14].Item_Code     := JPI$_PRCNAM ;?   Item_List[14].Buffer_Addr   := IADDRESS (Process_Name.BODY) ; A   Item_List[14].Return_Addr   := IADDRESS (Process_Name.LENGTH) ;   @   Item_List[15].Terminator    := 0 ;	{ Terminate the item list }  '   Rst := $GETJPIW (Itmlst := Item_List,g 		   Iosb   := Iosb) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE:   IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1]) ;;  7   Rst := STR$TRIM (%DESCR Orig_User,%DESCR Orig_User) ;,   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;	  %   IF (Physical_Device <> '') AND_THEN	%      (Physical_Device[1] = '_')  THENhN       Physical_Device := SUBSTR (Physical_Device,2,Physical_Device.LENGTH-1) ;  F   IF NOT (Required_Privs <= Proc_Cur_Priv)  THEN	{ Got needed privs? }      $EXIT (SS$_NOPRIV) ;}  I   Rst := $ASCTIM (Login_Time_Str.LENGTH,Login_Time_Str.BODY,Login_Time) ;s   IF NOT ODD (Rst) THENc      LIB$SIGNAL (Rst) ;o"   IF Login_Time_Str[1]	= ' '  THEN      Login_Time_Str[1] := '0' ;e   END ; 	{ of Get_Caller_Info }     * FUNCTION Get_And_Parse_Command : BOOLEAN ;  G { Get and parse the DCL command line.  Do some basic username checks. }B  "   VAR	Rst , Spot : UNSIGNED := 0 ; 	Prv : Privilege := Tmpmbx ;$ 	Str : VARYING [254] OF CHAR := '' ;  ?   [ASYNCHRONOUS] PROCEDURE Jump_Cld ; EXTERNAL ;	{ CLD module }y  "   BEGIN 	{ Get_And_Parse_Command }!   Get_And_Parse_Command := TRUE ;   E   Rst := LIB$GET_FOREIGN (%DESCR Command) ;		{ Get the command line }    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;e      Command := 'JUMP ' + Command ;>   Rst := CLI$DCL_PARSE (Command,Jump_Cld,%IMMED LIB$GET_INPUT,# 			%IMMED LIB$GET_INPUT,'JUMP> ') ;RM   IF (Rst = RMS$_EOF) OR (Rst = CLI$_NOCOMD) OR (NOT ODD (Rst)) THEN  $EXIT ;       Rst := CLI$PRESENT ('EXACT') ;@   Real_Mccoy := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;     IF Real_Mccoy THEN
      BEGIN  5      Get_Logical_Name (Lognam  := 'JUMP_SECURE_MODE',C6 		       Default := 'FALSE',		       { SITE-specific } 		       Actual  := Str,! 		       Table   := 'LNM$SYSTEM',r! 		       Mode    := PSL$C_EXEC) ;       Str_Compress (Str,Str) ; )      Rst := STR$UPCASE (%DESCR Str,Str) ;r      IF NOT ODD (Rst)  THEN= 	LIB$SIGNAL (Rst) ; C      System_Secure_Mode := Str = 'TRUE' ;	{ Mandatory Secure_Mode }y  C      Rst := CLI$PRESENT ('SECURE_MODE') ;	{ Requested Secure_Mode }yD      Secure_Mode := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;$      Suspect := Rst = CLI$_NEGATED ;  4      Get_Logical_Name (Lognam  := 'JUMP_SECURE_DIR',< 		       Default := 'SYS_MANAGER:',	       { SITE-specific }% 		       Actual  := Secure_Directory,u! 		       Table   := 'LNM$SYSTEM',t! 		       Mode    := PSL$C_EXEC) ;   2      Get_Logical_Name (Lognam  := 'JUMP_USER_DIR',; 		       Default := 'SYS$LOGIN:', 	       { SITE-specific }o# 		       Actual  := User_Directory,E! 		       Table   := 'LNM$SYSTEM',;! 		       Mode    := PSL$C_EXEC) ;]  $      Rst := CLI$PRESENT ('RECORD') ;G      Record_Session := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;S1      Suspect := Suspect OR (Rst = CLI$_NEGATED) ;{  8      IF Secure_Mode  THEN			{ Requested - set defaults } 	BEGIN7 	Notify.All_Bits := 16#FFFFFFFF ;	{ Full notification } 2 	Record_Session	:= TRUE ;		{ Required, obviously } 	END ;  E      { System_Secure_Mode is handled in Validate_Access.  For now, ifiE        Secure_Mode is requested, allow other qualifiers to modify theO        notification profile. }  $      Rst := CLI$PRESENT ('NOTIFY') ;F      IF Rst = CLI$_PRESENT THEN 	{ Present if not explicitly negated } 	BEGIN' 	Rst := CLI$PRESENT ('NOTIFY.BEFORE') ;a, 	Notify.Before := NOT (Rst = CLI$_NEGATED) ;  & 	Rst := CLI$PRESENT ('NOTIFY.AFTER') ;+ 	Notify.After := NOT (Rst = CLI$_NEGATED) ;P  % 	Rst := CLI$PRESENT ('NOTIFY.MAIL') ;m- 	Notify.By_Mail := NOT (Rst = CLI$_NEGATED) ;   ( 	Rst := CLI$PRESENT ('NOTIFY.INCLUDE') ;< 	Notify.Include_Log := Record_Session AND Notify.By_Mail AND  				  NOT (Rst = CLI$_NEGATED) ;  & 	Rst := CLI$PRESENT ('NOTIFY.OPCOM') ;. 	Notify.By_Opcom := NOT (Rst = CLI$_NEGATED) ; 	END
       ELSE"      IF Rst = CLI$_DEFAULTED  THEN 	BEGINC 	Notify.All_Bits    := 16#FFFFFFFF ;	{ Full notification, almost? }r' 	Notify.Include_Log := Record_Session ;  	END ;
      END ;  6   Get_Logical_Name (Lognam  := 'JUMP_NOTIFY_MAILLIST',4 		    Default := 'SYSTEM',		       { SITE-specific }! 		    Actual  := Notify_Maillist,G 		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;7   Str_Compress (Notify_Maillist,Notify_Maillist,TRUE) ;l  1   Get_Logical_Name (Lognam  := 'JUMP_MATCH_BOTH', 4 		    Default := 'FALSE', 		       { SITE-specific } 		    Actual  := Str,A 		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;V   Match_Both := Str = 'TRUE' ;  "   Rst := CLI$PRESENT ('SETUSER') ;?   Alter_Ego := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;n.   Transmute := NOT (Alter_Ego OR Real_Mccoy) ;     Rst := CLI$PRESENT ('ALL') ;L   Alter_Ego := Alter_Ego OR (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;  '   Rst := CLI$PRESENT ('OVERRIDE_UAF') ; =   Figment := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;A     Rst := CLI$PRESENT ('LOG') ;9   Log := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;U      Rst := CLI$PRESENT ('AUDIT') ;>   Auditing := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;2   Get_Logical_Name (Lognam  := 'JUMP_AUDIT_TRAIL',B 		    Default := 'SYS_MANAGER:JUMP_AUDIT.DAT',   { SITE-specific } 		    Actual  := Audit_Trail,% 		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;  2   Get_Logical_Name (Lognam  := 'JUMP_ACCESS_LIST',B 		    Default := 'SYS_MANAGER:JUMP_ACCESS.DAT',  { SITE-specific } 		    Actual  := Access_List,M 		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;  3   Get_Logical_Name (Lognam  := 'JUMP_DOUBLE_CHECK', 3 		    Default := 'TRUE',			       { SITE-specific }t 		    Actual  := Str,E 		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;O    Double_Check := Str = 'TRUE' ;  +   Get_Logical_Name (Lognam  := 'JUMP_SELF',R3 		    Default := 'TRUE',			       { SITE-specific }s 		    Actual  := Str,A 		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;   Str_Compress (Str,Str) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    Narcissus := Str = 'TRUE' ;;  2   Get_Logical_Name (Lognam  := 'JUMP_MINOR_PRIVS',; 		    Default := 'NETMBX TMPMBX', 	       { SITE-specific }2 		    Actual  := Str,= 		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;   Str_Compress (Str,Str) ;   REPEAT%     READV (Str,Prv,Error:=CONTINUE) ;c     IF STATUSV <> 0  THENoP        Exit('%JUMP-F-BADPRIVSET, Minor privilege set specification is invalid.')	      ELSE.        BEGIN+        Minor_Privs := Minor_Privs + [Prv] ;P         Spot := INDEX (Str,' ') ;        IF Spot = 0  THEN 	  Str := '' 	ELSE / 	  Str := SUBSTR (Str,Spot+1,Str.LENGTH-Spot) ;g        END ;   UNTIL Str = '' ;  G   Rst := CLI$GET_VALUE ('USERNAME',New_User) ;	{ Assume will be there })   IF Rst = CLI$_ABSENT	THENr<      New_User := Orig_User			{ Default to current username }    ELSEt   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE[
      BEGIN8      Rst := STR$TRIM (%DESCR New_User,%DESCR New_User) ;      IF NOT ODD (Rst)  THEN] 	LIB$SIGNAL (Rst) ;E
      END ;  /   IF FIND_NONMEMBER (New_User,Symbol) <> 0 THENo
      BEGINI      WRITELN ('%JUMP-F-BADUSER, Username contains invalid characters.') ; %      Get_And_Parse_Command := FALSE ;m
      END ;$   END ; { of Get_And_Parse_Command }    $ FUNCTION Get_Target_Info : BOOLEAN ;  J { Get the required information for the particular new user from the UAF. }     VAR	I , J : INTEGER := 0 ; 	Rst , Ctx : UNSIGNED := 0 ; 	Holder : $UQUAD := ZERO ;- 	Item_List : Item_List_Template (7) := ZERO ;E     BEGIN 	{ Get_Target_Info }#   Item_List[1].Buffer_Length := 8 ;T/   Item_List[1].Item_Code     := UAI$_DEF_PRIV ; 5   Item_List[1].Buffer_Addr   := IADDRESS (Def_Priv) ;t#   Item_List[1].Return_Addr   := 0 ;h  #   Item_List[2].Buffer_Length := 8 ; +   Item_List[2].Item_Code     := UAI$_PRIV ; 6   Item_List[2].Buffer_Addr   := IADDRESS (Auth_Priv) ;#   Item_List[2].Return_Addr   := 0 ;H  #   Item_List[3].Buffer_Length := 4 ;O*   Item_List[3].Item_Code     := UAI$_UIC ;>   Item_List[3].Buffer_Addr   := IADDRESS (New_Uic.UIC$L_UIC) ;#   Item_List[3].Return_Addr   := 0 ;c  #   Item_List[4].Buffer_Length := 4 ; ,   Item_List[4].Item_Code     := UAI$_FLAGS ;2   Item_List[4].Buffer_Addr   := IADDRESS (Flags) ;#   Item_List[4].Return_Addr   := 0 ;   0   Item_List[5].Buffer_Length := SIZE (Def_Dir) ;-   Item_List[5].Item_Code     := UAI$_DEFDIR ;g9   Item_List[5].Buffer_Addr   := IADDRESS (Def_Dir.BODY) ;s#   Item_List[5].Return_Addr   := 0 ;   0   Item_List[6].Buffer_Length := SIZE (Def_Dev) ;-   Item_List[6].Item_Code     := UAI$_DEFDEV ;T9   Item_List[6].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ;)#   Item_List[6].Return_Addr   := 0 ;g  ?   Item_List[7].Terminator    := 0 ;	{ Terminate the item list }g  I   Rst := $GETUAI (Usrnam := %STDESCR SUBSTR (New_User,1,New_User.LENGTH),  		  Itmlst := Item_List) ;      Get_Target_Info := ODD (Rst) ;     IF NOT ODD (Rst)  THEN
      BEGIN      IF Rst <> RMS$_RNF  THEN. 	LIB$SIGNAL (Rst) ;s      END    ELSE=
      BEGIN.      Def_Dir.LENGTH := INT (Def_Dir.BODY[1]) ;.      Def_Dev.LENGTH := INT (Def_Dev.BODY[1]) ;=      Def_Dir.BODY := SUBSTR (Def_Dir.BODY,2,Def_Dir.LENGTH) ;D=      Def_Dev.BODY := SUBSTR (Def_Dev.BODY,2,Def_Dev.LENGTH) ;N  3      { Get the Rights IDs held by the target user }r  %      Holder.L0 := New_Uic.UIC$L_UIC ;G      REPEAT         I := I + 1 ; +        Rst := $FIND_HELD (Holder := Holder,,  			  Id	 := Target_Rights[I].L0, 			  Contxt := Ctx) ; 7        IF (Rst <> SS$_NOSUCHID) AND NOT ODD (Rst)  THENs 	  LIB$SIGNAL (Rst) ;O4      UNTIL (Rst = SS$_NOSUCHID) OR (I = Rightsize) ;        I := I - 1 ;]
      J := 1 ;S&      WHILE System_Rights[J].L0 > 0  DO        BEGIN5        Target_Rights[I+J].L0 := System_Rights[J].L0 ;R        J := J + 1 ;s        END ;
      END ;   END ; 	{ of Get_Target_Info }S    ( PROCEDURE Format_User (Uic : UIC$TYPE) ;  I { Create a string with the UIC in numeric and rights identifier formats }i     VAR  Rst : INTEGER := 0 ;m     BEGIN 	{ Format_User }G   Rst := $FAO ('!%U',Uic_Str.LENGTH,%STDESCR Uic_Str.BODY,%IMMED Uic) ;e   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;=E   Rst := $FAO ('!%I',Id_Str.LENGTH,%STDESCR Id_Str.BODY,%IMMED Uic) ;i   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;g   IF Uic_Str = Id_Str  THENp      Eq_Id_Str := ''    ELSEc"      Eq_Id_Str := ' = ' + Id_Str ;   END ; 	{ of Format_User }'    % PROCEDURE Audit_Jump (Ok : BOOLEAN) ;a  < { Record who, when, where, how, etc. for auditing purposes }     VAR	Rst : UNSIGNED := 0 ;R7 	Imprint : VARYING [240] OF CHAR := '' ; 	{ 3 lines!! }  	Audit : TEXT ;C- 	Stamp : PACKED ARRAY [1..23] OF CHAR := '' ;i     BEGIN 	{ Audit_Jump }EL   OPEN	 (Audit,FILE_NAME:=Audit_Trail,HISTORY:=Unknown,SHARING:=READWRITE) ;   EXTEND (Audit) ;  -   Rst := $ASCTIM (Timbuf := %STDESCR Stamp) ;s   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ; ,   IF Stamp[1] = ' '  THEN  Stamp[1] := '0' ;4   Imprint := SUBSTR (Stamp,1,20) + ' ' + Orig_User ;
   IF Ok  THENt
      BEGIN"      IF New_User = Orig_User  THEN 	BEGIN  	Imprint := Imprint + ' from ' ; 	Format_User (Uic) ; 	END
       ELSE 	BEGIN  	Imprint := Imprint + '  to  ' ; 	Format_User (New_Uic) ; 	END ;/      Imprint := Imprint + Uic_Str + Eq_Id_Str ;o"      IF New_User = Orig_User  THEN8 	Format_User (New_Uic) ; 	{ Provide format for display }      END    ELSEr9      Imprint := Imprint + ' PRIV violation: ' + Command ;+     IF Real_Mccoy  THEN;
      BEGIN      IF Secure_Mode  THENr 	BEGIN# 	Imprint := Imprint + ' *SECURE*' ;	8 	IF Suspect  THEN  Imprint := Imprint + ' ??SUSPECT??' ; 	END
       ELSE# 	Imprint := Imprint + ' *EXACT* ' ; ;      IF Pdev <> ''  THEN  Imprint := Imprint + ' ' + Pdev ;D
      END ;8   IF Port <> ''  THEN  Imprint := Imprint + ' ' + Port ;@   IF Terminal <> ''  THEN  Imprint := Imprint + ' ' + Terminal ;N   IF Physical_Device <> ''  THEN  Imprint := Imprint + ' ' + Physical_Device ;     WRITELN (Audit,Imprint) ;    CLOSE (Audit) ;a   END ; 	{ of Audit_Jump }        9 FUNCTION Parse_Ident (Ident_Str : VARYING [Len] OF CHAR ;=" 		      VAR Ident_Val : UIC$TYPE ;% 		      VAR Parse_Result : UNSIGNED ;S- 		      Req_Type : UNSIGNED := 0) : BOOLEAN ;   J   { Use LIB$TABLE_PARSE to parse an identifier string.	This neatly handles>     all parsing issues associated with UICs and identifiers. }     CONST   E   No_Req  = 0 ; 	{ No specific requirements - any valid value is OK }I(   Req_Rid = 1 ; 	{ Must be a Rights ID }"   Req_Uic = 2 ; 	{ Must be a UIC }7   Req_Uic_Nowild = 3 ;	{ Must be a non-wildcarded UIC } 2   Req_Uic_Wild	 = 4 ;	{ Must be a wildcarded UIC }     VARl     Rst : UNSIGNED := 0 ;   9   State_Tbl ,				      { TABLE_PARSE table - see source }(P   Key_Tbl   : [EXTERNAL,VALUE] UNSIGNED ;     { TABLE_PARSE table - see source }L   Arg_Block : [VOLATILE] TPA$TYPE := ZERO ;   { TABLE_PARSE argument block }     BEGIN 	{ Parse_Ident }   Parse_Ident := FALSE ;  7   Ident_Val.UIC$L_UIC := 0 ;			{ Return null if error }s:   Ident_Val.UIC$V_FORMAT := 1 ; 		{ Invalid format value }  -   Arg_Block.TPA$L_COUNT     := TPA$K_COUNT0 ;o$   Arg_Block.TPA$L_STRINGCNT := Len ;:   Arg_Block.TPA$L_STRINGPTR := IADDRESS (Ident_Str.BODY) ;  )   Rst := LIB$TABLE_PARSE (%REF Arg_Block,P+ 			  %IMMED State_Tbl,	{ See MACRO source } + 			  %IMMED Key_Tbl) ;	{ See MACRO source }m     Parse_Result := Rst ;P      IF Rst <> LIB$_SYNTAXERR  THEN      IF NOT ODD (Rst)  THENt 	LIB$SIGNAL (Rst)L
       ELSE 	BEGIN0 	Ident_Val.UIC$L_UIC := Arg_Block.TPA$L_NUMBER ; 	IF Req_Type = No_Req  THEN: 	   Parse_Ident := TRUEL 	 ELSE2 	IF (Ident_Val.UIC$V_FORMAT = UIC$K_ID_FORMAT) AND 	   (Req_Type = Req_Rid)  THEN 	   Parse_Ident := TRUEg 	 ELSE3 	IF Ident_Val.UIC$V_FORMAT = UIC$K_UIC_FORMAT  THENm 	   IF (Req_Type  = Req_Uic) ORS' 	      ((Req_Type = Req_Uic_Nowild) AND_8 	       (Ident_Val.UIC$V_GROUP  <> UIC$K_WILD_GROUP) AND9 	       (Ident_Val.UIC$V_MEMBER <> UIC$K_WILD_MEMBER)) ORb% 	      ((Req_Type = Req_Uic_Wild) ANDE1 		((Ident_Val.UIC$V_GROUP  = UIC$K_WILD_GROUP) OR 7 		 (Ident_Val.UIC$V_MEMBER = UIC$K_WILD_MEMBER)))  THENe 	      Parse_Ident := TRUE ; 	END ;   END ; 	{ of Parse_Ident }m    , FUNCTION Match_Ident (Id1 , Id2 : UIC$TYPE ;$ 		      Exact   : BOOLEAN := FALSE ;/ 		      Ordered : BOOLEAN := FALSE) : BOOLEAN ;I  G { Determine if a pair of identifiers match, either uniquely if "EXACT",SH   or as wildcarded UICs.  If "ORDERED", Id1 must be a "subset" of Id2. }     BEGIN 	{ Match_Ident }   Match_Ident := FALSE ;  9   IF Id1.UIC$L_UIC = Id2.UIC$L_UIC  THEN		{ Exact match }c      Match_Ident := TRUE    ELSEr,   IF NOT Exact	THEN					{ Wildcarded forms }      IF Ordered  THENt: 	Match_Ident := ((Id2.UIC$V_MEMBER = UIC$K_WILD_MEMBER) OR- 			(Id1.UIC$V_MEMBER = Id2.UIC$V_MEMBER)) AND 2 		       ((Id2.UIC$V_GROUP  = UIC$K_WILD_GROUP) OR( 			(Id1.UIC$V_GROUP  = Id2.UIC$V_GROUP))
       ELSE: 	Match_Ident := ((Id1.UIC$V_MEMBER = UIC$K_WILD_MEMBER) OR, 			(Id2.UIC$V_MEMBER = UIC$K_WILD_MEMBER) OR- 			(Id1.UIC$V_MEMBER = Id2.UIC$V_MEMBER)) AND=2 		       ((Id1.UIC$V_GROUP  = UIC$K_WILD_GROUP) OR+ 			(Id2.UIC$V_GROUP  = UIC$K_WILD_GROUP) OR * 			(Id1.UIC$V_GROUP  = Id2.UIC$V_GROUP)) ;   END ; 	{ of Match_Ident }f    7 FUNCTION Match_List (Candidate	: VARYING [L1] OF CHAR ;1' 		     Targets : VARYING [L2] OF CHAR ;i! 		     Candidate_Uic : UIC$TYPE ;f4 		     Candidate_Rights : Rights_Array) : UNSIGNED ;  M   { Determine if a given candidate string, which may be either a (wildcarded)fJ     username, a (wildcarded) UIC, or a rights identifier, is included in a>     list of targets which may be of any of these same types. }  ;   TYPE	Style_Type = (Unknown,Wild_S,User_S,Uic_S,Ident_S) ;I  "   VAR	Rst , Spot : UNSIGNED := 0 ; 	Negated : BOOLEAN := FALSE ;m# 	Id_Style : Style_Type := Unknown ;t' 	Dancer : VARYING [100] OF CHAR := '' ;; 	Dancer_Id : UIC$TYPE := ZERO ;=     BEGIN 	{ Match_List }Y   Match_List := CLI$_ABSENT ;d     WHILE Targets <> ''  DO.	     BEGIN +     IF Targets[1] = '!'  THEN			{ Negated }i        BEGIN9        IF Targets.LENGTH = 1  THEN		{ Last character??? }s 	  Exit (Bad_Access_Data)O 	ELSE)3 	  Targets := SUBSTR (Targets,2,Targets.LENGTH-1) ;D        Negated := TRUE ;
        END	      ELSE         Negated := FALSE ;r  *     IF Targets[1] IN Symbol+Wildcard  THEN        BEGIN9        Spot := FIND_NONMEMBER (Targets,Symbol+Wildcard) ;E        IF Spot = 0  THEN 	  BEGIN 	  Dancer  := Targets ;v 	  Targets := '' ; 	  END 	ELSEy#        IF Targets[Spot] = ','  THEN( 	  BEGIN 	  Spot := Spot - 1 ; & 	  Dancer := SUBSTR (Targets,1,Spot) ; 	  END 	ELSE  	  Exit (Bad_Access_Data) ;e1        IF FIND_MEMBER (Dancer,Wildcard) > 0  THENF 	  Id_Style := Wild_S  	ELSES 	  Id_Style := User_S ;n
        END	      ELSEN#     IF Targets[1] IN Uic_Left  THEN         BEGIN0        Spot := FIND_MEMBER (Targets,Uic_Right) ;        IF Spot = 0  THEN 	  Exit (Bad_Access_Data) ; *        Dancer := SUBSTR (Targets,1,Spot) ;C        IF ((Dancer[1] = '[') AND (Dancer[Dancer.LENGTH] <> ']')) ORR? 	  ((Dancer[1] = '<') AND (Dancer[Dancer.LENGTH] <> '>'))  THEN  	  Exit (Bad_Access_Data) ;         Id_Style := Uic_S ;
        END	      ELSEs        Exit (Bad_Access_Data) ;L  "     IF Spot < Targets.LENGTH  THEN=        Targets := SUBSTR (Targets,Spot+1,Targets.LENGTH-Spot)A	      ELSE         Targets := '' ;=     IF (Targets.LENGTH > 1) AND_THEN (Targets[1] = ',')  THEN$1 	Targets := SUBSTR (Targets,2,Targets.LENGTH-1) ;   :     IF Id_Style = Wild_S  THEN				   { Wildcard username }        BEGIN1        Rst := STR$MATCH_WILD (Candidate,Dancer) ;:         IF Rst = STR$_MATCH  THEN 	  IF Negated  THEN   	     Match_List := CLI$_NEGATED 	   ELSE  	     Match_List := CLI$_PRESENT 	ELSE';        IF NOT ODD (Rst) AND_THEN (Rst <> STR$_NOMATCH)	THEN	 	  LIB$SIGNAL (Rst) ; 
        END	      ELSEM        BEGIN9        IF NOT Parse_Ident (Dancer,Dancer_Id,Rst) AND_THENr 	  (Rst = LIB$_SYNTAXERR)  THENS9 	  IF (Id_Style = Uic_S)  THEN			      { Bad UIC syntax }R 	     Exit (Bad_Access_Data)- 	   ELSE 				{ Non-existant ID - do nothing }  	ELSERB 	  BEGIN 	 { Parsed OK and exists or Parse_Ident signalled error }4 	  IF Dancer_Id.UIC$V_FORMAT = UIC$K_ID_FORMAT  THEN 	     Id_Style := Ident_S ;s  . 	  IF ((Id_Style = User_S) AND				{ Username } 	      (Candidate = Dancer)) OR ) 	     ((Id_Style = Uic_S)  AND				{ UIC }p3 	      Match_Ident (Candidate_Uic,Dancer_Id))  THEN  	     IF Negated  THEN 		Match_List := CLI$_NEGATED 	      ELSE  		Match_List := CLI$_PRESENT 	   ELSE/ 	  IF Id_Style = Ident_S  THEN				{ Rights ID }  	     BEGINs$ 	     FOR Spot := 1 TO Rightsize  DO; 		 IF Dancer_Id.UIC$L_UIC = Candidate_Rights[Spot].L0  THEN  		    IF Negated	THEN # 		       Match_List := CLI$_NEGATED  		     ELSEe% 		       Match_List := CLI$_PRESENT ; 	 	     ENDT 	   ELSE@ 	  IF Id_Style = Unknown  THEN		  { Huh??? Should never happen } 	     Exit (Bad_Access_Data) ; 	  END ;        END ;	     END ;s   END ; 	{ of Match_List }     PROCEDURE Validate_Access ;T  F { For the type of user running the program, validate the user's access"   to the target user's UAF record.  D   Non-SysProgs can only jump (/NOEXACT) to users who do not have anyN   privileges other than those that are "OK".  (SITE-specific privilege list) }     VAR	I   : INTEGER  := 0 ;P 	Rst : UNSIGNED := 0 ;* 	Chekov ,			{ User has JUMP's rights ID? }1 	Sysprog ,			{ SETPRV or group <= MAXSYSGROUP ? }_ 	Operator ,			{ OPER ? }- 	Priv_Target ,			{ Target is "privileged" ? }TE 	Id_Check_Ok : BOOLEAN := FALSE ;{ JUMP_ACCESS rights ID check ok ? }tI 	Access : Access_Status := Unspecified ; { Result of access list checks }I 	Jump_Id : UIC$TYPE := ZERO ;   5   FUNCTION Check_Access_And_Options : Access_Status ;=  K   { Determine if the caller is specifically authorised to access the target (     user in the access list data file. }  !     VAR I , Spot : INTEGER := 0 ;N& 	Rst , Target_Status : UNSIGNED := 0 ; 	Found : BOOLEAN := FALSE ;l& 	Option , Scanning : BOOLEAN := TRUE ;7 	Src , Dst , Opt , Line : VARYING [120] OF CHAR := '' ;n% 	Buf : VARYING [1024] OF CHAR := '' ;e( 	Result : Access_Status := Unspecified ; 	Access : TEXT ;  &     BEGIN	{ Check_Access_And_Options };     Check_Access_And_Options := Unspecified ;			{ Default }o  G     OPEN (Access,FILE_NAME:=Access_List,HISTORY:=Old,SHARING:=READONLY,U 		 Error:=CONTINUE) ;      Rst := STATUS (Access) ;      IF Rst = PAS$K_SUCCESS  THEN        BEGIN        RESET (Access) ; ,        WHILE NOT (EOF (Access) OR Found)  DO 	 BEGIN) 	 READLN (Access,Line) ;3 	 Str_Compress (Line,Line,TRUE) ;		{ Squeeeeeeze! }S( 	 Rst := STR$UPCASE (%DESCR Line,Line) ; 	 IF NOT ODD (Rst)  THEN 	    LIB$SIGNAL (Rst) ;_I 	 IF (Line.LENGTH > 0) AND_THEN (Line[1] <> '#')  THEN  { Not a comment }T
 	    BEGIN7 	    Spot := INDEX (Line,'#') ;			{ Trailing comment? }e 	    IF Spot > 0  THEN( 	       Line := SUBSTR (Line,1,Spot-1) ; 	    Spot := INDEX (Line,'\') ;E- 	    IF Spot > 0  THEN				{ Continued ... ? }T+ 	       Buf := Buf + SUBSTR (Line,1,Spot-1)I
 	     ELSE+ 	    IF (Buf = '') AND (Line = '!!!')  THEN 1 	       Found := TRUE				{ Terminate processing }T
 	     ELSE
 	       BEGINC 	       Buf  := Buf + Line ;! 	       Spot := INDEX (Buf,':') ;n3 	       IF Spot = 0  THEN  Exit (Bad_Access_Data) ;A' 	       Src  := SUBSTR (Buf,1,Spot-1) ; 5 	       Dst  := SUBSTR (Buf,Spot+1,Buf.LENGTH-Spot) ;Y! 	       Spot := INDEX (Dst,':') ;) 	       IF Spot > 0  THENo	 		  BEGINU0 		  Opt := SUBSTR (Dst,Spot+1,Dst.LENGTH-Spot) ;" 		  Dst := SUBSTR (Dst,1,Spot-1) ;	 		  END ;l) 	       IF (Src = '') OR (Dst = '')  THENY 		  Exit (Bad_Access_Data) ;  8 	       { Check if target user is in valid target list }  I 	       Target_Status := Match_List (New_User,Dst,New_Uic,Target_Rights);S  D 	       { If caller is in valid caller list, then determine status }   	       IF Match_List 9 			(Orig_User,Src,Uic,Caller_Rights) = CLI$_PRESENT  THEN 	 		  BEGINLB 		  IF Target_Status = CLI$_PRESENT  THEN  { Newuser in target...}/ 		     Result := Granted			 { ... NOT negated }=	 		   ELSE ; 		  IF Target_Status = CLI$_NEGATED  THEN  { ... negated! }  		     Result := Denied 	 		   ELSEP. 		     Result := Unspecified ;		 { Not there }  8 		  Found := (Match_Both AND (Result <> Unspecified)) OR 			   NOT Match_Both ;8 		  IF Found  THEN  Check_Access_And_Options := Result ;	 		  END ;U  , 	       { Check and action any options ... }  / 	       IF Houdini OR				{ No action required }r 		  (NOT Found) OR3 		  (Found AND (Target_Status = CLI$_ABSENT))  THEN_ 		ELSE 	       IF Opt <> ''  THEN  		  FOR I := 1 TO Opt.LENGTH  DO 		    IF Scanning  THENE
 		      BEGIN( 		      CASE Opt[I]  OFr& 			'!': Option := FALSE ;			{ Negate }! 			'A': Notify.After  := Option ; ! 			'B': Notify.Before := Option ; 
 			'E': BEGIN ) 			     IF (Option AND NOT Real_Mccoy) ORH% 				(Real_Mccoy AND NOT Option)  THENS* 				  Check_Access_And_Options := Denied ;7 			     IF (NOT Option) AND (Opt <> '!E')	THEN	{ ONLY }N 				Exit (Bad_Access_Data) ;
 			     END ; ( 			'I': Notify.Include_Log := Option AND 						   Record_Session ANDu 						   Notify.By_Mail  ;" 			'M': Notify.By_Mail := Option ;
 			'N': BEGIN ; 			     Notify.All_Bits := Option::Unsigned8 * 16#FFFFFFFF;S9 			     Notify.Include_Log := Record_Session AND Option ;R
 			     END ;D# 			'O': Notify.By_Opcom := Option ;y 			'R': IF Opt[1] = 'S'  THEN  				Exit (Bad_Access_Data)
 			      ELSEa+ 			     IF Secure_Mode AND NOT Option  THENr2 				Exit ('JUMP-F-CONFLICT, Conflicting option ' +* 				      '- must RECORD in Secure Mode.')
 			      ELSEN 				Record_Session := Option ;
 			'S': BEGINr 			     IF I <> 1	THEN 				Exit (Bad_Access_Data) ; 			     Secure_Mode := TRUE ;E( 			     Notify.All_Bits := 16#FFFFFFFF ;! 			     Record_Session  := TRUE ;Z
 			     END ;I
 			'X': BEGIN_0 			     IF Opt <> 'X'  THEN	{ Must be just 'X' } 				Exit (Bad_Access_Data) ; 			     Houdini := TRUE ;[
 			     END ;  			'+',E( 			'=': BEGIN			{ Buf no longer in use } 			     IF NOT Option  THEN] 				Exit (Bad_Access_Data) ;. 			     Buf := SUBSTR (Opt,I+1,Opt.LENGTH-I) ; 			     IF Opt[I] = '+'  THENS, 				Notify_Maillist := Notify_Maillist + Buf
 			      ELSEm 				Notify_Maillist := Buf ;* 			     Scanning := FALSE ;		{ Stop here }
 			     END ;] 			OTHERWISE  			     Exit (Bad_Access_Data) ; 			END ;	{ of Case } 		      IF Opt[I] <> '!'	THEN[ 			 Option := TRUE ; 		      END ;	{ of FOR }  3 	       IF System_Secure_Mode AND NOT Houdini  THEN 	 		  BEGINl$ 		  Notify.All_Bits := 16#FFFFFFFF ; 		  Record_Session  := TRUE ;_ 		  Secure_Mode := TRUE ; 	 		  END ;[  . 	       IF (Notify.Before OR Notify.After) AND1 		  NOT (Notify.By_Mail OR Notify.By_Opcom)  THENmA 		    Exit ('%JUMP-F-BADNOTIFY, Must notify by MAIL or OPCOM.') ;I  ! 	       IF Notify.Include_Log ANDo1 		  NOT (Record_Session AND Notify.By_Mail)  THENr$ 		    Exit ('%JUMP-F-BADINCLUDE, ' +9 			  'Include log requires RECORD and NOTIFY by MAIL.') ;o  2 	       IF (Notify.By_Mail OR Notify.By_Opcom) AND- 		  NOT (Notify.Before OR Notify.After)  THENe	 		  BEGINT 		  Notify.After	:= TRUE ; 		  Notify.Before := TRUE ;O# 		  WRITELN ('%JUMP-W-FIXNOTIFY, ',N9 			   'No After or Before for Notify - both presumed.') ;R	 		  END ;   , 	       Suspect := Suspect AND Secure_Mode ;, 	       Buf := '' ;		{ Logical end of line }
 	       END ;e
 	    END ; 	 END ;f2        IF Buf <> ''  THEN		{ Continuation?  Huh? } 	  Exit (Bad_Access_Data) ;T        CLOSE (Access) ;.
        END	      ELSEt#     IF Rst <> PAS$K_FILNOTFOU  THENe        BEGINM        WRITELN ('%JUMP-F-BADACCFIL, Failed to open access list file; error ',t
 		Rst:1) ;        $EXIT ;        END ;)     END ;	{ of Check_Access_And_Options }C     BEGIN 	{ Validate_Access }  G   { Check that the invoker has the required access to run this program. H     This is independant of any installed privileges.  Identify SysProgs.C     If need be, check to see if process has JUMP_ACCESS rights ID }i     IF Double_Check  THENt
      BEGINI      IF NOT Parse_Ident ('JUMP_ACCESS',Jump_Id,Rst,1)  THEN	{ Rights ID }f? 	Exit ('%JUMP-F-IVIDENT, JUMP_ACCESS not found or not valid') ;s
      I := 1 ;U      REPEAT :        Chekov := Jump_Id.UIC$L_UIC = Caller_Rights[I].L0 ;        I := I + 1 ;r&      UNTIL Chekov OR (I > Rightsize) ;
      END ;  B   Id_Check_Ok := (Double_Check AND Chekov) OR (NOT Double_Check) ;     IF Proc_Cnt > 0  THENA
      BEGINN      WRITELN ('%JUMP-F-NOSUB, Cannot JUMP while process has sub-processes.') ;      $EXIT ;      END    ELSE=   IF Pid <> Master_Pid	THENr
      BEGINC      WRITELN ('%JUMP-F-NOINSUB, Cannot JUMP from a sub-process.') ;'      $EXIT ;      END    ELSEB
      BEGIN6      Sysprog  := (Uic.UIC$V_GROUP <= Max_Sys_Group) OR  		 (Setprv IN Proc_Auth_Priv) OR 		 (Setprv IN Proc_Def_Priv) ;  ,      Operator := (Oper IN Proc_Auth_Priv) OR 		 (Oper IN Proc_Def_Priv) ;
      END ;     IF NOT Get_Target_Info  THEN      IF Figment  THENAE 	WRITELN ('%JUMP-W-INVUSER, Invalid username - user does not exist.'))
       ELSE 	BEGING 	WRITELN ('%JUMP-F-INVUSER, Invalid username - user does not exist.') ;A 	$EXIT (RMS$_RNF) ;p 	END ;  &   Access := Check_Access_And_Options ;  5   Priv_Target := ((Auth_Priv - Minor_Privs) <> []) OR ' 		 ((Def_Priv  - Minor_Privs) <> []) ORH+ 		 (New_Uic.UIC$V_GROUP <= Max_Sys_Group) ;      IF (NOT (Sysprog ORD+ 	   ((Access = Granted) AND Id_Check_Ok) OR < 	   (Operator AND NOT Priv_Target AND (Access <> Denied)) OR/ 	   ((New_User = Orig_User) AND Narcissus))) OR=&      (Alter_Ego AND NOT Sysprog)  THEN
      BEGIN      Audit_Jump (FALSE) ;       $EXIT (SS$_NOPRIV) ;t
      END ;  '   IF NOT Auditing AND NOT Sysprog  THENR
      BEGIN$      WRITELN ('%JUMP-F-MUSTAUDIT, ',: 	      'Only Systems Programmers may disable auditing.') ;      $EXIT (SS$_NOPRIV) ;r
      END ;  /   IF Alter_Ego AND (New_User = Orig_User)  THEN 
      BEGING      WRITELN ('%JUMP-I-SAMEUSER, Same username as current (',Orig_User,D  	      ') - no action taken.') ;      $EXIT ;
      END ;  (   IF Sysprog AND (Access = Denied)  THENE      WRITELN ('%JUMP-W-DENIED, Access denied in Access File.',Bell) ;p  -   IF Real_Mccoy AND Flags.UAI$V_DISACNT  THENt7      Exit ('%JUMP-F-DISABLED, Username is disabled.') ;p     IF Transmute	THENr/      IF New_Uic.UIC$L_UIC = Uic.UIC$L_UIC  THEN	 	BEGIN 	Format_User (Uic) ;; 	WRITELN ('%JUMP-I-SAMEUIC, Same UIC as current (',Uic_Str,: 		 ') - no action taken.') ; 	$EXIT ; 	END
       ELSE=      IF (Flags.UAI$V_RESTRICTED OR Flags.UAI$V_CAPTIVE)  THENn 	IF Sysprog  THEN D 	   WRITELN ('%JUMP-W-RESTRICT, Username is Restricted or Captive.') 	 ELSE	 	   BEGIN F 	   WRITELN ('%JUMP-F-RESTRICT, Username is Restricted or Captive.') ; 	   $EXIT (SS$_NOPRIV) ; 	   ENDe
       ELSE!      IF Flags.UAI$V_DISACNT  THENI 	IF Sysprog  THENd7 	   WRITELN ('%JUMP-W-DISABLED, Username is disabled.')  	 ELSE	 	   BEGIN 9 	   WRITELN ('%JUMP-F-DISABLED, Username is disabled.') ;  	   $EXIT (SS$_NOPRIV) ;	 	   END ;E   END ; 	{ of Validate_Access }     P FUNCTION Send_Mail_Message (To_Address : PACKED ARRAY [L0..H0:INTEGER] OF CHAR ;; 			    Subj_Line  : PACKED ARRAY [L1..H1:INTEGER] OF CHAR ;d9 			    Msg_Text   : PACKED ARRAY [L2..H2:INTEGER] OF CHARn 		) : INTEGER ;T  K { Send a mail message using Callable MAIL.  The Msg_Text is treated firstlyTE   as the file specification of a message file to be used in a call to L   MAIL$SEND_ADD_BODYPART.  If it is not a valid specification of an existingG   file, the Msg_Text will be inserted into the mail message verbatim. }e  !   VAR  I , Rst	 : INTEGER  := 0 ; "        Mail_Ctx  : UNSIGNED := 0 ;,        Context	 : [VOLATILE] UNSIGNED := 0 ;2        Mail_List : Item_List_Template(2) := ZERO ;        Addr_List,_?        Dest_Addr : STRING (MAX(510,SIZE(To_Address))) := ZERO ;         Msg_Buff,4        Msg_Line  : STRING (SIZE(Msg_Text)) := ZERO ;0        Msg_File  : VARYING [255] OF CHAR := '' ;        Dis_File  : TEXT ;M  (   FUNCTION Distribution_List : INTEGER ;  $     VAR  Rst , Spot : INTEGER := 0 ; 	 Done : BOOLEAN := FALSE ;        BEGIN	{ Distribution_List }L;     Dest_Addr := SUBSTR (Dest_Addr,2,LENGTH(Dest_Addr)-1) ;EL     OPEN (Dis_File,FILE_NAME:=Dest_Addr,HISTORY:=READONLY,Error:=CONTINUE) ;     Rst := STATUS (Dis_File) ;!     IF Rst <> PAS$K_SUCCESS  THENEC        Rst := 16#218644 + Rst * 8	{ Map to a condition code value }a	      ELSEm        BEGIN        RESET (Dis_File) ;I-        WHILE NOT (Done OR EOF (Dis_File))  DO  	 BEGINr 	 READLN (Dis_File,Dest_Addr) ;A+ 	 Str_Compress (Dest_Addr,Dest_Addr,TRUE) ;m! 	 Spot := INDEX (Dest_Addr,'!') ;  	 IF Spot > 1  THENC/ 	    Dest_Addr := SUBSTR (Dest_Addr,1,Spot-1) ;} 	 IF Spot <> 1  THEN
 	    BEGIN7 	    Mail_List[1].Buffer_Length := LENGTH (Dest_Addr) ;CB 	    Rst := MAIL$SEND_ADD_ADDRESS (Mail_Ctx,Mail_List,Null_List) ; 	    Done := NOT ODD (Rst) ;
 	    END ; 	 END ;e        CLOSE (Dis_File) ;         END ;     Distribution_List := Rst ;"     END ;	{ of Distribution_List }     BEGIN 	{ Send_Mail_Message }  #   { Prepare the Mail SEND context }$  9   Rst := MAIL$SEND_BEGIN (Mail_Ctx,Null_List,Null_List) ;d   IF NOT ODD (Rst)  THEN      IF Secure_Mode  THEN_ 	$EXIT (Rst)
       ELSE 	LIB$SIGNAL (Rst) ;E      { Set up the To: address(es) }  7   Mail_List[1].Buffer_Length := 0 ;			{ Initially ... }$5   Mail_List[1].Item_Code     := MAIL$_SEND_USERNAME ;=;   Mail_List[1].Buffer_Addr   := IADDRESS (Dest_Addr.BODY) ;I#   Mail_List[1].Return_Addr   := 0 ;1  ?   Mail_List[2].Terminator    := 0 ;	{ Terminate the item list }i     Addr_List := To_Address ;C  !   WHILE LENGTH (Addr_List) > 0	DOI	     BEGIN       I := INDEX (Addr_List,',') ;     IF I > 0  THEN        BEGIN.        Dest_Addr := SUBSTR (Addr_List,1,I-1) ;@        Addr_List := SUBSTR (Addr_List,I+1,LENGTH(Addr_List)-I) ;
        END	      ELSEm        BEGIN        Dest_Addr := Addr_List ;_        Addr_List := '' ;        END ;#     IF LENGTH (Dest_Addr) > 0  THENB        BEGIN"        IF Dest_Addr[1] = '@'  THEN 	  Rst := Distribution_List0 	ELSEA 	  BEGIN5 	  Mail_List[1].Buffer_Length := LENGTH (Dest_Addr) ;L@ 	  Rst := MAIL$SEND_ADD_ADDRESS (Mail_Ctx,Mail_List,Null_List) ; 	  END ;        IF NOT ODD (Rst)  THENT 	  IF Secure_Mode  THEN  	     $EXIT (Rst)a 	   ELSE 	     LIB$SIGNAL (Rst) ;        END ;	     END ;A     { Set up the Subject line }:  4   Mail_List[1].Buffer_Length := LENGTH (Subj_Line) ;4   Mail_List[1].Item_Code     := MAIL$_SEND_SUBJECT ;6   Mail_List[1].Buffer_Addr   := IADDRESS (Subj_Line) ;#   Mail_List[1].Return_Addr   := 0 ;M  #   Mail_List[2].Terminator    := 0 ;   A   Rst := MAIL$SEND_ADD_ATTRIBUTE (Mail_Ctx,Mail_List,Null_List) ;:   IF NOT ODD (Rst)  THEN      IF Secure_Mode  THEN  	$EXIT (Rst)
       ELSE 	LIB$SIGNAL (Rst) ;n  I   { Determine if Msg_Text is a valid specification of an existing file. }e  -   Rst := LIB$FIND_FILE (Filespec := Msg_Text,E) 			Resultant_Filespec := %DESCR Msg_File,t 			Context  := Context,E# 			Flags	 := 1) ;		{ No wildcards }U  0   IF ODD (Rst)	THEN	{ File exists - attach it. }
      BEGIN6      Mail_List[1].Buffer_Length := LENGTH (Msg_Text) ;4      Mail_List[1].Item_Code	:= MAIL$_SEND_FILENAME ;6      Mail_List[1].Buffer_Addr	:= IADDRESS (Msg_Text) ;$      Mail_List[1].Return_Addr	:= 0 ;  #      Mail_List[2].Terminator	:= 0 ;   C      Rst := MAIL$SEND_ADD_BODYPART (Mail_Ctx,Mail_List,Null_List) ;       IF NOT ODD (Rst)  THEN  	IF Secure_Mode	THEN 	   $EXIT (Rst)a 	 ELSE 	   LIB$SIGNAL (Rst) ;      ENDF    ELSE 	{ Split Msg_Text at LF characters and send record by record }
      BEGIN4      Mail_List[1].Item_Code   := MAIL$_SEND_RECORD ;;      Mail_List[1].Buffer_Addr := IADDRESS (Msg_Line.BODY) ;       Msg_Buff := Msg_Text ;	$      WHILE LENGTH (Msg_Buff) > 0  DO        BEGIN!        I := INDEX (Msg_Buff,Lf) ;         IF I > 0 THEN 	  BEGIN( 	  Msg_Line := SUBSTR (Msg_Buff,1,I-1) ;9 	  Msg_Buff := SUBSTR (Msg_Buff,I+1,LENGTH(Msg_Buff)-I) ;E 	  END 	ELSE  	  BEGIN 	  Msg_Line := Msg_Buff ;S 	  Msg_Buff := '' ;  	  END ;8        Mail_List[1].Buffer_Length := LENGTH (Msg_Line) ;E        Rst := MAIL$SEND_ADD_BODYPART (Mail_Ctx,Mail_List,Null_List) ;A        IF NOT ODD (Rst)  THEN  	  IF Secure_Mode  THENd 	     $EXIT (Rst)  	   ELSE 	     LIB$SIGNAL (Rst) ;        END ;
      END ;  .   { The message is complete.  Let's send it. }  ;   Rst := MAIL$SEND_MESSAGE (Mail_Ctx,Null_List,Null_List) ;M   IF NOT ODD (Rst)  THEN      IF Secure_Mode  THEN  	$EXIT (Rst)
       ELSE 	LIB$SIGNAL (Rst) ;a   Send_Mail_Message := Rst ;  7   Rst := MAIL$SEND_END (Mail_Ctx,Null_List,Null_List) ;    IF NOT ODD (Rst)  THEN      IF Secure_Mode  THEN  	$EXIT (Rst)
       ELSE 	LIB$SIGNAL (Rst) ; !   END ; 	{ of Send_Mail_Message }P    . [ASYNCHRONOUS,Check(None)] PROCEDURE Getuser ;  L { In EXEC MODE, peek at the Username in the Control Region and in the PCB. }     BEGINI%   Sanity_Ctl_User := CTL$T_USERNAME ;	$   Sanity_Jib_User := Jib_User_Ptr^ ;   END ;I    . [ASYNCHRONOUS,Check(None)] PROCEDURE Setuser ;  P { In KERNEL MODE, poke a new Username into the Control Region and into the PCB.}     BEGINp#   CTL$T_USERNAME := New_User.BODY ; #   Jib_User_Ptr^  := New_User.BODY ;    END ;o    2 [ASYNCHRONOUS,Check(None)] PROCEDURE Read_Longword 				(VAR Location ,n1 				 Pointer  : [VOLATILE,UNSAFE] Unsigned_Ptr) ;t  % { In EXEC MODE, peek at a location. }P     BEGINl"   Location::UNSIGNED := Pointer^ ;   END ;y    3 [ASYNCHRONOUS,Check(None)] PROCEDURE Write_Longwordc 				(VAR Location ,}1 				 Pointer  : [VOLATILE,UNSAFE] Unsigned_Ptr) ;=  1 { In KERNEL MODE, poke a value into a location. }s     BEGINS"   Pointer^ := Location::UNSIGNED ;   END ;     ) [GLOBAL] PROCEDURE Getmem (VAR Location ,r2 			   Pointer  : [VOLATILE,UNSAFE] Unsigned_Ptr) ;  6 { Jacket routine to peek at a location in EXEC MODE. }  P   VAR Arglst : [UNSAFE] ARRAY [1..3] OF UNSIGNED := (2,0,0) ;  { Argument list }     BEGINI$   Arglst[2] := IADDRESS (Location) ;#   Arglst[3] := IADDRESS (Pointer) ;e.   $CMEXEC (%IMMED Read_Longword,%REF Arglst) ;   END ;s      PROCEDURE Putmem (VAR Location ,0 		  Pointer  : [VOLATILE,UNSAFE] Unsigned_Ptr) ;  B { Jacket routine to poke a value into a location in KERNEL MODE. }  P   VAR Arglst : [UNSAFE] ARRAY [1..3] OF UNSIGNED := (2,0,0) ;  { Argument list }     BEGINI$   Arglst[2] := IADDRESS (Location) ;#   Arglst[3] := IADDRESS (Pointer) ;s/   $CMKRNL (%IMMED Write_Longword,%REF Arglst) ;s   END ;h    . PROCEDURE Poteroo (Faking : BOOLEAN := TRUE) ;  > { Change the UIC.  Do sanity checks except when reverting from   pseudo-terminal. }  0   VAR Sanity_Uic : [VOLATILE] UIC$TYPE := ZERO ;     BEGIN 	{ Poteroo }  J   { Check that the UIC as returned by GETJPI and as peeked at in EXEC MODE)     agree -- do this as a sanity check. })  /   Uic_Ptr::UNSIGNED := CTL$GL_PCB + PCB$L_UIC ;e)   Getmem (Sanity_Uic.UIC$L_UIC,Uic_Ptr) ;)  =   IF Faking AND (Sanity_Uic.UIC$L_UIC <> Uic.UIC$L_UIC)  THENe
      BEGINB      WRITELN ('%JUMP-F-INSANEUIC, Sanity Check FAILED for UIC!') ;L      WRITELN ('%JUMP-F-UICVALUES, GetUAI =',HEX (Uic.UIC$L_UIC),' Kernel =',$ 	      HEX (Sanity_Uic.UIC$L_UIC)) ;      $EXIT (SS$_ABORT) ;      END    ELSEIJ      Putmem (New_Uic.UIC$L_UIC,Uic_Ptr) ;	{ Change UIC to be target UIC. }   END ; 	{ of Poteroo }     . PROCEDURE Wallaby (Faking : BOOLEAN := TRUE) ;  B { Change the username.	Do sanity checks except when reverting from   pseudo-terminal }      BEGIN 	{ Wallaby }  O   { Check that the username as returned by GETJPI and as peeked at in EXEC MODE )     agree -- do this as a sanity check. }s  /   Jib_Ptr::UNSIGNED := CTL$GL_PCB + PCB$L_JIB ;    Getmem (Jib_Ptr,Jib_Ptr) ;  @   Jib_User_Ptr::UNSIGNED := Jib_Ptr::UNSIGNED + JIB$T_USERNAME ;   $CMEXEC (Getuser,%IMMED 0) ;  8   IF Faking AND ((Sanity_Ctl_User <> Orig_User.BODY)  OR/      (Sanity_Jib_User <> Orig_User.BODY))  THEN;
      BEGINH      WRITELN ('%JUMP-F-INSANEUSER, Sanity Check FAILED for Username!') ;F      WRITELN ('%JUMP-F-USERVALUES, GetJPI = ',Orig_User,' Control = ',3 	      Sanity_Ctl_User,' JIB = ',Sanity_Jib_User) ;       $EXIT (SS$_ABORT) ;      END    ELSEi!      $CMKRNL (Setuser,%IMMED 0) ;E   END ; 	{ of Wallaby }r     PROCEDURE Kangaroo ;  H { Do all that is required to JUMP /NOEXACT to the new user, or to return9   to the original user.  This is the "poor man's" jump. }   (   VAR	Rst , Attributes : UNSIGNED := 0 ;& 	Aclstr : VARYING [64] OF CHAR := '' ;. 	Aclent : PACKED ARRAY [1..32] OF CHAR := '' ;. 	Grptbl : PACKED ARRAY [1..16] OF CHAR := '' ;- 	Item_List : Item_List_Template (3) := ZERO ;O     BEGIN 	{ Kangaroo }N     { Set new UIC. }     Poteroo ;y      { Set new default directory. }  ?   Rst := SYS$SETDDIR (SUBSTR (Def_Dir.BODY,1,Def_Dir.LENGTH)) ;(   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;      { Set new default disk. }   0   Item_List[1].Buffer_Length := Def_Dev.LENGTH ;-   Item_List[1].Item_Code     := LNM$_STRING ; 9   Item_List[1].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ;t#   Item_List[1].Return_Addr   := 0 ;o  #   Item_List[2].Terminator    := 0 ;n  3   Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS',n" 		  Lognam := %STDESCR 'SYS$DISK', 		  Acmode := PSL$C_SUPER, 		  Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;	  9   { Point LNM$GROUP logical to group table for new UIC. }	      Attributes := LNM$M_TERMINAL ;:   Grptbl := 'LNM$GROUP_' + OCT (New_Uic.UIC$V_GROUP,6,6) ;  #   Item_List[1].Buffer_Length := 4 ;o1   Item_List[1].Item_Code     := LNM$_ATTRIBUTES ;e7   Item_List[1].Buffer_Addr   := IADDRESS (Attributes) ;'#   Item_List[1].Return_Addr   := 0 ;'  /   Item_List[2].Buffer_Length := SIZE (Grptbl) ;t-   Item_List[2].Item_Code     := LNM$_STRING ;N3   Item_List[2].Buffer_Addr   := IADDRESS (Grptbl) ;t#   Item_List[2].Return_Addr   := 0 ;O  #   Item_List[3].Terminator    := 0 ;	  =   Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS_DIRECTORY',H# 		  Lognam := %STDESCR 'LNM$GROUP',  		  Acmode := PSL$C_KERNEL,	 		  Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;   M   { If going to a different UIC, allow the current LNM$JOB logical name table	M     to be accessed by the new UIC.  If returning to original user, remove the $     ACL access previously applied. }      Item_List[2].Terminator := 0 ;  =   IF New_User = Orig_User  THEN 	{ Return to original user. }N
      BEGIN&      Item_List[1].Buffer_Length := 0 ;0      Item_List[1].Item_Code	:= ACL$C_DELETEACL ;$      Item_List[1].Buffer_Addr	:= 0 ;$      Item_List[1].Return_Addr	:= 0 ;      END    ELSEO
      BEGINB      Aclstr := '(IDENTIFIER=' + New_User + ',ACCESS=READ+WRITE)' ;G      Rst := $PARSE_ACL (Aclstr := SUBSTR (Aclstr.BODY,1,Aclstr.LENGTH),  			Aclent := %STDESCR Aclent) ;o      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;#  4      Item_List[1].Buffer_Length := INT (Aclent[1]) ;0      Item_List[1].Item_Code	:= ACL$C_ADDACLENT ;4      Item_List[1].Buffer_Addr	:= IADDRESS (Aclent) ;$      Item_List[1].Return_Addr	:= 0 ;
      END ;  9   Rst := $CHANGE_ACL (Objtyp := ACL$C_LOGICAL_NAME_TABLE,f 		      Objnam := 'LNM$JOB', 		      Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    END ; 	{ of Kangaroo }     PROCEDURE Display_Jump ;  * { Display data about the requested jump. }     BEGIN 	{ Display_Jump }e   IF Transmute	THENE
      BEGIN9      WRITELN ('%JUMP-S-JUMPED, ',Orig_User,' jumped to ',O- 	      New_User,' (',Uic_Str,Eq_Id_Str,')') ;N?      WRITELN ('%JUMP-I-DEFAULT, Default is ',Def_Dev,Def_Dir) ; 
      END ;     IF Alter_Ego	THENrI      WRITELN ('%JUMP-S-SETUSER, Changed username from ',Orig_User,' to ',  	      New_User) ;   END ; 	{ of Display_Jump }    6 PROCEDURE Get_Channel (Device : VARYING [L1] OF CHAR ;+ 		       VAR Channel : [VOLATILE] $UWORD) ;F  ! { Assign a channel to a device. }      VAR Rst : UNSIGNED := 0 ;F     BEGIN 	{ Get_Channel }#   Rst := $ASSIGN (Devnam := Device,; 		  Chan	 := Channel) ;E   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    END ; 	{ of Get_Channel }     / PROCEDURE Exit_Handler (Condition : UNSIGNED) ;t  * { Clean up on exit from pseudo-terminal. }     VAR Rst  : UNSIGNED := 0 ;(       Iosb : Status_Block_Type := ZERO ;     BEGIN 	{ Exit_Handler }S  #   $SETAST (0) ; 			{ Disable ASTs }E  +   { Restore username and UIC if required. }A     IF New_User <> Orig_User THENs
      BEGIN'      New_User.BODY := PAD ('',' ',12) ;d      New_User := Orig_User ;8      Wallaby (FALSE) ;			{ Change to original username }
      END ;  ,   IF New_Uic.UIC$L_UIC <> Uic.UIC$L_UIC THEN
      BEGIN      New_Uic := Uic ; 3      Poteroo (FALSE) ;			{ Change to original UIC }D
      END ;     IF Pchan_Created  THEN      IF Pseudo_Ft  THENE 	BEGIN> 	Rst := PTD$CANCEL (Pchan) ;	{ Cancel I/O to pseudo-terminal } 	IF NOT ODD (Rst)  THENE 	   LIB$SIGNAL (Rst) ;  7 	Rst := PTD$DELETE (Pchan) ;	{ Delete pseudo-terminal }n 	IF NOT ODD (Rst)  THENs 	   LIB$SIGNAL (Rst) ; 	END
       ELSE8 	$DASSGN (Pchan) ;		{ Deassign pseudo-terminal channel }  6   $CANCEL (Rchan) ;			{ Cancel I/Os on real terminal }  D   Rst := $QIOW (Chan := Rchan,		{ Restore original characteristics } 		Func := IO$_SETMODE, 		Iosb := Iosb,F 		P1   := Rchars,o 		P2   := 12) ;i   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE-   IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1]) ;U  '   $DASSGN (Rchan) ;			{ Shut up shop. }n     END ; 	{ of Exit_Handler }    $ [ASYNCHRONOUS] PROCEDURE Rchan_Ast ;  J { Called when a keystroke occurs on the real keyboard - the keystrokes are:   passed to the pseudo-terminal and another read queued. }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Rchan_Ast}e   IF Pseudo_Ft	THENC
      BEGIN'      Rst := PTD$WRITE (Chan	  := Pchan,A" 		       Wrtbuf	  := Buffer[Wsts], 		       Wrtbuf_Len := 1) ;)      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;B  !      Rst := $QIO (Chan	 := Rchan,  		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer[Wbuf], 		  P2	 := 1) ;W      IF NOT ODD (Rst)  THEN, 	LIB$SIGNAL (Rst) ;s      END    ELSEs
      BEGIN       Rst := $QIO (Chan := Pchan, 		  Func := IO$_WRITEVBLK, 		  P1   := Buffer[Wsts],r 		  P2   := 1) ;      IF NOT ODD (Rst)  THENM 	LIB$SIGNAL (Rst) ;a  !      Rst := $QIO (Chan	 := Rchan,  		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer[Wsts], 		  P2	 := 1) ;W      IF NOT ODD (Rst)  THENs 	LIB$SIGNAL (Rst) ;l
      END ;   END ; 	{ of Rchan_Ast }g    $ [ASYNCHRONOUS] PROCEDURE Pchan_Ast ;  M { Called when characters are received from the pseudo-terminal - the data areI6   passed to the real screen and another read queued. }     VAR  Rst : UNSIGNED := 0 ;=        Log_Buffer : VARYING [SIZE(Io_Buffer)] OF CHAR := '' ;;     BEGIN 	{ Pchan_Ast }  7   { If recording, write the new text to the log file. }      IF Record_Session  THEN 
      BEGIN      IF Buffer[Rcnt] > 0  THEN> 	STR$COPY_R (%DESCR Log_Buffer,Buffer[Rcnt],%REF Buffer[Rbuf])
       ELSE 	Log_Buffer := '' ;dE      WRITELN (Logfile,Log_Buffer,Error:=CONTINUE) ;	{ Ignore errors }I
      END ;     IF Pseudo_Ft	THENy
      BEGIN!      Rst := $QIOW (Chan := Rchan,s 		   Func := IO$_WRITEVBLK,E 		   P1	:= Buffer[Rbuf], 		   P2	:= Buffer[Rcnt]) ;      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;N  &      Rst := PTD$READ (Chan	  := Pchan, 		      Astadr	  := Pchan_Ast," 		      Readbuf	  := Buffer[Rsts],# 		      Readbuf_Len := Ft_Buflen) ;A      IF NOT ODD (Rst)  THENF 	LIB$SIGNAL (Rst) ;T      END    ELSEY
      BEGIN!      Rst := $QIOW (Chan := Rchan,  		   Func := IO$_WRITEVBLK,a 		   P1	:= Buffer[Rsts], 		   P2	:= Piosb[2]) ;      IF NOT ODD (Rst)  THENa 	LIB$SIGNAL (Rst) ;s  !      Rst := $QIO (Chan	 := Pchan,Y 		  Func	 := IO$_READVBLK, 		  Iosb	 := Piosb,x 		  Astadr := Pchan_Ast, 		  P1	 := Buffer[Rsts], 		  P2	 := Py_Buflen) ;       IF NOT ODD (Rst)  THENE 	LIB$SIGNAL (Rst) ;i
      END ;   END ; 	{ of Pchan_Ast }t      [ASYNCHRONOUS] PROCEDURE Mbast ;  F { Invoked by the detached process termination mailbox AST - WAKE UP! }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ MBast }  F   { Try to avoid any issues with typeahead buffer and EXACT log file }     IF Record_Session  THEN[
      BEGIN       Rst := PTD$CANCEL (Pchan) ;      IF NOT ODD (Rst)  THEN_ 	LIB$SIGNAL (Rst) ; 
      END ;     Rst := $WAKE ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;t   END ; 	{ of MBast }e    ( [ASYNCHRONOUS] PROCEDURE Send_Bell_Ast ;    { Bell event notification AST. }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Send_Bell_AST }   Rst := $QIO (Chan := Rchan,t 	       Func := IO$_WRITEVBLK, 	       P1   := Bell,  	       P2   := 1) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;R   END ; 	{ of Send_Bell_AST }E    ' [ASYNCHRONOUS] PROCEDURE Send_Xon_Ast ;    { Xon event notification AST. }      VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Send_Bell_AST }   Rst := $QIO (Chan := Rchan,  	       Func := IO$_WRITEVBLK, 	       P1   := Xon, 	       P2   := 1) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;L   END ; 	{ of Send_Bell_AST }:    ( [ASYNCHRONOUS] PROCEDURE Send_Xoff_Ast ;    { Xoff event notification AST. }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Send_Bell_AST }   Rst := $QIO (Chan := Rchan,= 	       Func := IO$_WRITEVBLK, 	       P1   := Xoff,{ 	       P2   := 1) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;M   END ; 	{ of Send_Bell_AST }i     PROCEDURE Transmography ;(  L { Create a pseudo-terminal connected to a detached process and actually *be*#   the user!  This is JUMP /EXACT. }e     CONSTa  I   Subversion_Msg = '**** WARNING!! Attempt to subvert Secure Mode ****' ;e     TYPE  8   Desc_Blk = PACKED RECORD			{ Exit handler descriptor } 	       Fwd_Link : UNSIGNED ;L& 	       Exit_Handler_Addr : UNSIGNED ; 	       Argcnt : $UBYTE ;	5 	       Fill_Zero : [UNSAFE] ARRAY [1..3] OF $UBYTE ;s 	       Condition ,H0 	       P2 , P3 , P4 , P5 , P6 , P7 : UNSIGNED ; 	     END VALUE ZERO ;     VARH      Rst , Mbunit : UNSIGNED := 0 ;.   Pctl : [VOLATILE,LONG] Prtctl_Type := ZERO ;)   Pctl_Ptr : [VOLATILE] Word_Ptr := NIL ;)   Rucb , Pucb , .   Rapn, Papn: [VOLATILE] Unsigned_Ptr := NIL ;%   Newchars : Terminal_Chars := ZERO ; )   Exit_Desc : [STATIC] Desc_Blk := ZERO ;E$   Iosb : Status_Block_Type := ZERO ;.   Item_List : Item_List_Template (2) := ZERO ;/   Specified_User : VARYING [12] OF CHAR := '' ;L   Time_Now : TIMESTAMP ;.   Time_Str     : VARYING  [23] OF CHAR := '' ;.   Notify_Msg   : VARYING  [80] OF CHAR := '' ;.   Logfile_Spec : VARYING [254] OF CHAR := '' ;  7   FUNCTION Find_Device (Device : VARYING [L1] OF CHAR ; $ 			Chan   : $UWORD := 0) : BOOLEAN ;  7   { Determine if a device exists and return its name. }        VAR Rst : UNSIGNED := 0 ;A# 	Iosb : Status_Block_Type := ZERO ;f- 	Item_List : Item_List_Template (2) := ZERO ;s       BEGIN	{ Find_Device }      Find_Device := TRUE ;   4     Item_List[1].Buffer_Length := SIZE (Pdev.BODY) ;/     Item_List[1].Item_Code     := DVI$_DEVNAM ; 8     Item_List[1].Buffer_Addr   := IADDRESS (Pdev.BODY) ;:     Item_List[1].Return_Addr   := IADDRESS (Pdev.LENGTH) ;  B     Item_List[2].Terminator    := 0 ;		{ Terminate the item list }  C     IF (Chan = 0) AND (Device <> '')  THEN	{ Device name supplied } ,        Rst := $GETDVIW (Itmlst := Item_List, 			Devnam := Device, 			Iosb   := Iosb))      ELSE					{ Channel number supplied }1,        Rst := $GETDVIW (Itmlst := Item_List, 			Chan   := Chan, 			Iosb   := Iosb) ;        IF Rst = SS$_NOSUCHDEV  THEN        Find_Device := FALSE 	      ELSE1     IF NOT ODD (Rst)  THEN        LIB$SIGNAL (Rst):	      ELSE      IF NOT ODD (Iosb[1])  THEN        LIB$SIGNAL (Iosb[1]) ;      END ;	{ of Find_Device }  -   FUNCTION Logfile_Open (VAR Fab : FAB$TYPE ;E 			 VAR Rab : RAB$TYPE ; 			 VAR L	 : TEXT) : INTEGER ;  K   { This function is invoked by Pascal's OPEN when the log file is created..O     We hijack the NAM block to determine the actual filespec of the log file. }g       VAR Rst : INTEGER := 0 ; 	Nam : ^NAM$TYPE := ZERO ;       BEGIN	{ Logfile_Open }#     Nam := Fab.FAB$L_NAM::Pointer ;f     Rst := $CREATE (Fab) ;     IF ODD (Rst)  THEN        BEGINN        STR$COPY_R (%DESCR Logfile_Spec,Nam^.NAM$B_RSL,%IMMED Nam^.NAM$L_RSA) ;        Rst := $CONNECT (Rab)        END ;     Logfile_Open := Rst ;      END ;	{ of Logfile_Open }f  *   PROCEDURE Get_Ucb (Chan_Num : UNSIGNED ;6 		     VAR Ucb : [VOLATILE] Unsigned_Ptr) ; EXTERNAL ;     BEGIN 	{ Transmography }  7   IF Suspect  THEN			{ Secure Mode subversion attempt }E
      BEGIN      Oprmsg (Subversion_Msg) ;?      Send_Mail_Message (Notify_Maillist,Subversion_Msg,'NL:') ;s
      END ;  9   IF Record_Session  THEN		{ Construct the log filename }s
      BEGIN      GETTIMESTAMP (Time_Now) ;:      Time_Str := DATE (Time_Now) + ' ' + TIME (Time_Now) ;       IF Time_Str[1]  = ' '  THEN 	Time_Str[1] := '0' ;N        IF NOT Secure_Mode  THEN % 	Secure_Directory := User_Directory ;T*      WRITEV (Session_Log,Secure_Directory, 			 'JUMP_', 			 Orig_User, 			 '-',
 			 New_User,c 			 '.', 			 DEC (Time_Now.Year,4,4), 			 DEC (Time_Now.Month,2,2),  			 DEC (Time_Now.Day,2,2),  			 '_', 			 DEC (Time_Now.Hour,2,2), 			 DEC (Time_Now.Minute,2,2),! 			 DEC (Time_Now.Second,2,2) ) ; 
      END ;     Specified_User := New_User ;  I   { Determine which pseudo-terminal type (if any) exists on the system. }o  &   Pseudo_Ft := Find_Device ('FTA0:') ;   IF NOT Pseudo_Ft  THEN'      IF NOT Find_Device ('PYA0:')  THEN B 	Exit ('%JUMP-F-NOPSEUDO, No pseudo-terminal driver on system.') ;     Get_Channel ('TT:',Rchan) ;L  I   { Get current (real) terminal process-specific device characteristics }I     Rst := $QIOW (Chan := Rchan, 		Func := IO$_SENSEMODE, 		Iosb := Iosb,e 		P1   := Rchars,L 		P2   := 12) ;R     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)i    ELSE    IF NOT ODD (Iosb[1])	THENa      LIB$SIGNAL (Iosb[1]) ;   )   { Set up and declare the exit handler }   :   Exit_Desc.Exit_Handler_Addr := IADDRESS (Exit_Handler) ;   Exit_Desc.Argcnt := 1 ;F.   Exit_Desc.Condition := IADDRESS (Exit_Rst) ;  (   Rst := $DCLEXH (Desblk := Exit_Desc) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;{  ;   { Send a mail message to the notification mailing list. })     IF Notify.Before  THEN
      BEGIN:      Notify_Msg := 'Initiated JUMP/EXACT to ' + New_User ;      IF Notify.By_Mail	THENa7 	Send_Mail_Message (Notify_Maillist,Notify_Msg,'NL:') ;       IF Notify.By_Opcom  THENl 	Oprmsg (Notify_Msg) ;
      END ;  &   { Set new terminal characteristics }     Newchars := Rchars ;.   Newchars.Tt_Devchar.TT$V_NOECHO    := TRUE ;/   Newchars.Tt_Devchar.TT$V_WRAP      := FALSE ;t.   Newchars.Tt_Devchar2.TT2$V_PASTHRU := TRUE ;     Rst := $QIOW (Chan := Rchan, 		Func := IO$_SETMODE, 		Iosb := Iosb,  		P1   := Newchars,a 		P2   := 12) ;t     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSEc   IF NOT ODD (Iosb[1])	THENO      LIB$SIGNAL (Iosb[1]) ;   &   Wallaby ;	{ Change to new username }!   Poteroo ;	{ Change to new UIC }       { Create the pseudo-terminal }  &   Pbuf_Range[1] := IADDRESS (Buffer) ;6   Pbuf_Range[2] := Pbuf_Range[1] + Io_Buflen * 2 - 1 ;     IF Pseudo_Ft	THENS
      BEGIN'      Rst := PTD$CREATE (Chan	 := Pchan,G 			Charbuff := Rchars, 			Buflen	 := SIZE (Rchars), 			Inadr	 := Pbuf_Range) ;      IF NOT ODD (Rst)  THENI 	LIB$SIGNAL (Rst) ;C         { Set event notifications }  8      Rst := PTD$SET_EVENT_NOTIFICATION (Chan   := Pchan, 					Astadr := Send_Bell_Ast,U! 					Type_  := PTD$C_SEND_BELL) ;r      IF NOT ODD (Rst)  THENe 	LIB$SIGNAL (Rst) ;   8      Rst := PTD$SET_EVENT_NOTIFICATION (Chan   := Pchan, 					Astadr := Send_Xon_Ast,  					Type_  := PTD$C_SEND_XON) ;      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;u  8      Rst := PTD$SET_EVENT_NOTIFICATION (Chan   := Pchan, 					Astadr := Send_Xoff_Ast,i! 					Type_  := PTD$C_SEND_XOFF) ;       IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;_      END    ELSEr
      BEGIN"      Get_Channel ('PYA0:',Pchan) ;
      END ;  8   Find_Device ('',Pchan) ;		{ Sets Pdev to device name }   Pchan_Created := TRUE ;   K   { If the "real" process has a valid value for ACCPORNAM, set the "pseudo"U     process to point to it. }A     Get_Ucb (Pchan,Pucb) ;:   Pctl_Ptr::UNSIGNED := Pucb::UNSIGNED + UCB$W_TT_PRTCTL ;   Getmem (Pctl,Pctl_Ptr) ;9   Papn::UNSIGNED := Pucb::UNSIGNED + UCB$L_TT_ACCPORNAM ;      IF Port = ''	THEN 
      BEGIN  M      { Welcome to a futureware section of code!  When ACCPORNAM is not valid,lI        the port name will be empty.  In this case, use the terminal name.oF        Allocate an appropriate buffer, copy the terminal name into it,J        put the address of the buffer into ACCPORNAM of the pseudo-terminalK        and set the validity bit in the port control mask.  When the pseudo-'O        terminal is terminated, deallocate the buffer.  This exercise remains to P        be attempted ... or supplied by an eager code jockey somewhere else! :) }        END    ELSEe
      BEGIN      Get_Ucb (Rchan,Rucb) ;T<      Rapn::UNSIGNED := Rucb::UNSIGNED + UCB$L_TT_ACCPORNAM ;      Getmem (Rapn,Rapn) ;[      Putmem (Rapn,Papn) ;.3      Pctl::Prtctl_Type.TTY$V_PC_ACCPORNAM := TRUE ;       Putmem (Pctl,Pctl_Ptr) ; 
      END ;  E   { Create a termination mailbox for the soon-to-be detached process,]     and get its unit number }   !   Rst := $CREMBX (Chan	 := Mchan,R 		  Maxmsg := ACC$K_TERMLEN) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;t  #   Item_List[1].Buffer_Length := 4 ;H+   Item_List[1].Item_Code     := DVI$_UNIT ;$3   Item_List[1].Buffer_Addr   := IADDRESS (Mbunit) ;r#   Item_List[1].Return_Addr   := 0 ;:  ?   Item_List[2].Terminator    := 0 ;	{ Terminate the item list }B  '   Rst := $GETDVIW (Itmlst := Item_List,o 		   Chan   := Mchan,E 		   Iosb   := Iosb) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)s    ELSEr   IF NOT ODD (Iosb[1])	THENs      LIB$SIGNAL (Iosb[1]) ;r  /   { Queue an asynchronous read to the mailbox }N     Rst := $QIO (Chan   := Mchan,: 	       Func   := IO$_READVBLK,s 	       Astadr := Mbast, 	       P1     := Mbbuf," 	       P2     := ACC$K_TERMLEN) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;n     IF Auditing  THENU      Audit_Jump (TRUE) ;  J   WRITELN ('%JUMP-S-TRANSFER, Control transferred to user ',New_User,Lf) ;  !   { Create the detached process }r  6   Rst := $CREPRC (Image  := 'SYS$SYSTEM:LOGINOUT.EXE', 		  INPUT  := Pdev,h 		  OUTPUT := Pdev,i 		  Error  := Pdev,r 		  Baspri := 4, 		  Mbxunt := Mbunit,l> 		  Stsflg := PRC$M_DETACH + PRC$M_INTER + PRC$M_NOPASSWORD) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;G     { Restore username and UIC }  J   New_User.BODY := PAD ('',' ',12) ;	{ Completely blat any previous name }   New_User := Orig_User ;e   New_Uic  := Uic ;	  3   Wallaby (FALSE) ;	{ Change to original username }'.   Poteroo (FALSE) ;	{ Change to original UIC }  K   { Open the session log file, and put some audit information at the start.	K     Note that we have to put the carriage control in explicitly because thet?     log file is created without any implied carriage control. }      IF Record_Session THEN
      BEGIN7      OPEN (Logfile,FILE_NAME:=Session_Log,HISTORY:=NEW,;; 		   Record_Length:=SIZE(Io_Buffer),Carriage_Control:=None,=! 		   USER_ACTION:=Logfile_Open) ;A      REWRITE (Logfile) ;"      Session_Log := Logfile_Spec ;,      WRITELN (Logfile,PAD ('-','-',78),Cr) ;9      WRITELN (Logfile,Lf,'JUMP /EXACT Session Log.',Cr) ;R*      WRITELN (Logfile,Lf,Session_Log,Cr) ;8      WRITELN (Logfile,Lf,'User:        ',Orig_User,Cr) ;?      WRITELN (Logfile,Lf,'Login time:  ', Login_Time_Str, Cr) ;sC      WRITELN (Logfile,Lf,'PID:         ',HEX (Master_Pid,8,8),Cr) ; ;      WRITELN (Logfile,Lf,'Process:     ',Process_Name,Cr) ; #      IF Physical_Device <> ''  THEN : 	WRITELN (Logfile,Lf,'Phys Dev:    ',Physical_Device,Cr) ;      IF Terminal <> ''	THENe3 	WRITELN (Logfile,Lf,'Terminal:    ',Terminal,Cr) ;_      IF Port <> ''  THEN/ 	WRITELN (Logfile,Lf,'Port:        ',Port,Cr) ; 7      WRITELN (Logfile,Lf,'JUMP time:   ',Time_Str,Cr) ; =      WRITELN (Logfile,Lf,'Target user: ',Specified_User,Cr) ;S      IF Suspect  THEN;) 	WRITELN (Logfile,Lf,Subversion_Msg,Cr) ;s+      WRITELN (Logfile,PAD (Lf,'-',78),Cr) ;{
      END ;  O   { Queue the appropriate reads to both the real terminal and pseudo-terminal }f     IF Pseudo_Ft	THEN 
      BEGIN!      Rst := $QIO (Chan	 := Rchan,a 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer[Wbuf], 		  P2	 := 1) ;       IF NOT ODD (Rst)  THENi 	LIB$SIGNAL (Rst) ;F  &      Rst := PTD$READ (Chan	  := Pchan, 		      Astadr	  := Pchan_Ast," 		      Readbuf	  := Buffer[Rsts],# 		      Readbuf_Len := Ft_Buflen) ;       IF NOT ODD (Rst)  THENE 	LIB$SIGNAL (Rst) ;U      END    ELSE$
      BEGIN!      Rst := $QIO (Chan	 := Rchan,  		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer[Wsts], 		  P2	 := 1) ;       IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;c  !      Rst := $QIO (Chan	 := Pchan,l 		  Func	 := IO$_READVBLK, 		  Iosb	 := Piosb,) 		  Astadr := Pchan_Ast, 		  P1	 := Buffer[Rsts], 		  P2	 := Py_Buflen) ;R      IF NOT ODD (Rst)  THENs 	LIB$SIGNAL (Rst) ;E
      END ;  >   { Hibernate until termination mailbox message wakes us up. }  
   $HIBER ;     { Close the session log }s     IF Record_Session  THEN       CLOSE (Logfile) ;  +   { If required, notify the mailing list. }o     IF Notify.After  THEN	
      BEGIN@      Notify_Msg := 'Completed JUMP/EXACT to ' + Specified_User ;      IF Notify.By_Mail	THEN  	BEGIN 	IF Notify.Include_Log  THEN> 	   Send_Mail_Message (Notify_Maillist,Notify_Msg,Session_Log) 	 ELSE 	IF Record_Session  THEN2 	   Send_Mail_Message (Notify_Maillist,Notify_Msg,- 			      'The session log is ' + Session_Log)  	 ELSE2 	   Send_Mail_Message (Notify_Maillist,Notify_Msg,' 			      'There was no session log.') ;t 	END ;      IF Notify.By_Opcom  THEN  	BEGIN 	Oprmsg (Notify_Msg) ; 	IF Record_Session  THEN, 	   Oprmsg ('Session log: ' + Session_Log) ; 	END ;
      END ;  I   WRITELN ('%JUMP-S-RETURN, Control returned to user ',Orig_User,Lf,Lf) ;u   END ; 	{ of Transmography }r    E { * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * C   * * * * * * * * * *	M A I N   P R O G R A M   * * * * * * * * * * G   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }u     BEGIN	{ Jump }   Get_System_Info ;O Get_Caller_Info ;    IF Get_And_Parse_Command  THEN    BEGIN)    Validate_Access ;			{ Stop intruders }       IF Real_Mccoy  THEN        Transmography			{ Clone! }     ELSE       BEGIND-       IF Alter_Ego  THEN		{ Change username }; 	 Wallaby ;o(       IF Transmute  THEN		{ Long jump! } 	 BEGINA4 	 Kangaroo ;			{ Boing! Change miscellany of items } 	 IF Auditing  THENe 	    Audit_Jump (TRUE) 	  ELSEs 	    Format_User (New_Uic) ; 	 END ;A"       IF Log  THEN  Display_Jump ;       END ;Y    END ;   END.	{ of it all }