$!
$! DECnet object for running SSL_ENGINE, define required logical names.
$! Place this file in sys$login directory of server process and update
$! base_dir and/or engine symbols for local configuration.
$!
$! Modified By:  Robert Alan Byer
$!               Vice-President
$!               A-Com Computing, Inc.
$!		 ByreRA@aol.com
$!
$! I modified this for use with the older SSL_TASK.EXE program as well as
$! the newer SSL_ENGINE.EXE program.
$!
$ set output=00:00:05
$ set verify
$!
$! Define Where We Have Our Certificate File.
$!
$!
$! Define SSL_SERVER_CERTIFICATE To Point To Our PEM Server Certificate And
$! Private RSA key.
$!
$ DEFINE SSL_SERVER_CERTIFICATE "SSLCERTS:SERVER.PEM"
$!
$! Define Where We Have the SSL_ENGINE Program (if we have it).
$!
$ SSL_ENGINE = "SSLEXE:SSL_ENGINE.EXE"
$!
$! Define Where We Have The SSL_TASK Program (if we have it).
$!
$ SSL_TASK = "SSLEXE:SSL_TASK.EXE"
$!
$! Define Where We Want To Keep The WWWSSL.LOG File.
$!
$ SSL_LOG = "WWW_ROOT:[000000]WWWSSL.LOG"
$!
$! Check To See If We Have A SSL Certificate.
$!
$ IF (F$SEARCH("SSL_SERVER_CERTIFICATE").EQS."")
$ THEN
$!
$!  No SSL Certificate, Tell The User.
$!
$   WRITE SYS$OUTPUT "SSL Certificate Was Not Found."
$!
$!  No Certificate, Nothing To Do Then So Just Exit.
$!
$   EXIT
$!
$! End The Certificate File Check.
$!
$ ENDIF
$!
$! Check To See If We Have Either The SSL_ENGINE Or The SSL_TASK Program.
$!
$ IF ((F$SEARCH(SSL_ENGINE).EQS."").AND.(F$SEARCH(SSL_TASK).EQS.""))
$ THEN
$   WRITE SYS$OUTPUT "SSL_ENGINE nor SSL_TASK was found."
$   EXIT
$ ENDIF
$!
$! Check To See If We Have The SSL_ENGINE Program.
$!
$ IF (F$SEARCH(SSL_ENGINE).NES."")
$ THEN
$!
$!  Check To See If We Have Installed The SSL_ENGINE With SYSNAM.
$!  Privs.
$!
$   IF .NOT. F$FILE_ATTRIBUTE(SSL_ENGINE,"KNOWN") .AND. -
       F$PRIVILEGE("SYSNAM").EQS."NOSYSNAM"
$   THEN
$!
$!    Guess It Wasn't Installed With SYSNAM Privs, Tell The User.
$!
$     WRITE SYS$OUTPUT "SSL_ENGINE Must Be Installed With SYSNAM Privilege."
$!
$!    Time To Exit, Can't Run Without SYSNAM Privs.
$!
$     EXIT
$!
$!  End the SSL_ENGINE SYSNAM Priv Check.
$!
$   ENDIF
$!
$!  Define SSL_SERVER_ACCESS As A List Of "Legal" 'Clients' For The SSL_ENGINE.
$!
$   DEFINE SSL_SERVER_ACCESS 'F$TRNLNM("SYS$NODE")''F$GETJPI("0","USERNAME")'
$!
$!  Define SSL_SERVER_LOG_LEVEL Trace Level For Debugging (Default Is 0).
$!
$   DEFINE SSL_SERVER_LOG_LEVEL 0
$!
$!  Define SSL_SERVER_THREAD_LIMIT For The Max Number Of Connections.
$!  (Default Is 32)
$
$   DEFINE SSL_SERVER_THREAD_LIMIT 32
$!
$!  Define SSL_SERVER_VERSION For SSL protocol Version Support.
$!  2 For SSLv2, 3 For SSLv3 or 23 For SSLv2 & SSLv3.
$!  (Default is 2 for SSLv2)
$!
$   DEFINE SSL_SERVER_VERSION 23
$!
$!  Assume Object Name Is Same As Filename.
$!
$   OBJNAME = F$PARSE(F$ENVIRONMENT("PROCEDURE"),,,"NAME")
$   ON ERROR THEN GOTO CLEANUP
$!
$!  Run The SSL_ENGINE.
$!
$   MCR 'SSL_ENGINE' 'OBJNAME' 'OBJNAME'.LOG
$!
$!  Done, Go Cleanup.
$!
$   GOTO CLEANUP
$!
$! Else We Are Going To Assume We Are Going To Use The SSL_TASK.
$!
$ ELSE
$!
$!  Define The List Of Available Ciphers.
$!
$   SSL_CIPHER = "RC4-MD5:EXP-RC4-MD5:IDEA-CBC-MD5:EXP-RC2-CBC-MD5:" + -
                  "DES-CBC-MD5:DES-CBC-SHA:DES-CBC3-MD5"
$!
$!  Define The SSL Log File.
$!
$   DEFINE SYS$OUTPUT 'SSL_LOG'
$   ON ERROR THEN GOTO CLEANUP
$!
$!  Run The SSL_TASK
$!
$   RUN 'SSL_TASK'
$!
$!  Done, Go Cleanup.
$!
$   DEASSIGN SYS$OUTPUT
$   GOTO CLEANUP
$!
$ ENDIF
$!
$! Cleanup Routine.
$!
$ CLEANUP:
$  PURGE/KEEP=8 WWWSSL.LOG
$ EXIT
