@ /* Copyright (C) 1988, 1989, 1990 Free Software Foundation, Inc. This file is part of GNU Make.  @ GNU Make is free software; you can redistribute it and/or modifyD it under the terms of the GNU General Public License as published byC the Free Software Foundation; either version 1, or (at your option)  any later version.  ; GNU Make is distributed in the hope that it will be useful, > but WITHOUT ANY WARRANTY; without even the implied warranty of= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the , GNU General Public License for more details.  A You should have received a copy of the GNU General Public License < along with GNU Make; see the file COPYING.  If not, write toI the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */    #include "make.h"  #include "commands.h"  #include "dep.h" #include "file.h"  #include "variable.h"    #ifndef VMS  #include <pwd.h> struct passwd *getpwnam ();  #endif     static void read_makefile (); . static unsigned int readline (), do_define (); static int conditional_line ();  static void record_files (); static char *find_semicolon ();     C /* A `struct linebuffer' is a structure which holds a line of text. :    `readline' reads a line from a stream into a linebuffer6    and works regardless of the length of the line.  */   struct linebuffer    { @     /* Note:  This is the number of bytes malloc'ed for `buffer'2        It does not indicate `buffer's real length.8        Instead, a null char indicates end-of-string.  */     unsigned int size;     char *buffer;    };  I #define initbuffer(lb) (lb)->buffer = (char *) xmalloc ((lb)->size = 200) * #define freebuffer(lb) free ((lb)->buffer)    > /* A `struct conditionals' contains the information describing-    all the active conditionals in a makefile.   ?    The global variable `conditionals' contains the conditionals @    information for the current makefile.  It is initialized fromD    the static structure `toplevel_conditionals' and is later changed0    to new structures for included makefiles.  */   struct conditionals    {      unsigned int if_cmds;      unsigned int max_ignoring;     char *ignoring;    };  1 static struct conditionals toplevel_conditionals; B static struct conditionals *conditionals = &toplevel_conditionals;     9 /* Default directories to search for include files in  */   
 #ifdef VMS, static char *default_include_directories[] =   {      "sys$sysroot:[syslib]",      0    }; #else , static char *default_include_directories[] =   {      "/usr/gnu/include",      "/usr/local/include",      "/usr/include",      0    }; #endif /* VMS */  9 /* List of directories to search for include files in  */   " static char **include_directories;  1 /* Maximum length of an element of the above.  */   ! static unsigned int max_incl_len;   1 /* The filename and pointer to line number of the (    makefile currently being read in.  */   char *reading_filename; ! unsigned int *reading_lineno_ptr;   4 /* The chain of makefiles read by read_makefile.  */  & static struct dep *read_makefiles = 0;                                                              E /* Read in all the makefiles and return the chain of their names.  */    struct dep * read_all_makefiles (makefiles)      char **makefiles; { !   unsigned int num_makefiles = 0;      if (debug_flag) "     puts ("Reading makefiles...");  E   /* If there's a non-null variable MAKEFILES, its value is a list of E      files to read first thing.  But don't let it prevent reading the J      default makefiles and don't let the default goal come from there.  */     { A     char *makefiles = allocated_variable_expand ("$(MAKEFILES)");      char *name;      unsigned int length;  D     /* Set NAME to the start of next token and LENGTH to its length.=        MAKEFILES is updated for finding remaining tokens.  */ ?     while ((name = find_next_token (&makefiles, &length)) != 0)        read_makefile (name, 1);       free (makefiles);    }   3   /* Read makefiles specified with -f switches.  */      if (makefiles != 0)      while (*makefiles != 0)        { # 	struct dep *tail = read_makefiles;  	register struct dep *d;   	read_makefile (*makefiles, 0);   1 	/* Find the right element of read_makefiles.  */  	d = read_makefiles; 	while (d->next != tail) 	  d = d->next;   0 	/* Use the storage read_filename allocates.  */ 	free (*makefiles);  	*makefiles = dep_name (d);  	++num_makefiles; 
 	++makefiles;        }   =   /* If there were no -f switches, try the default names.  */      if (num_makefiles == 0)      { (       static char *default_makefiles[] =
 #ifdef VMS? 	{ "gnumakefile", "makefile", "makefile.", "gnumakefile.", 0 };  #else . 	{ "GNUmakefile", "makefile", "Makefile", 0 }; #endif,       register char **p = default_makefiles;,       while (*p != 0 && !file_exists_p (*p)) 	++p;          if (*p != 0) 	read_makefile (*p, 0); 
       else 	{F 	  /* No default makefile was found.  Add the default makefiles to theE 	     `read_makefiles' chain so they will be updated if possible.  */ % 	  struct dep *tail = read_makefiles; , 	  for (p = default_makefiles; *p != 0; ++p) 	    {D 	      struct dep *d = (struct dep *) xmalloc (sizeof (struct dep)); 	      d->name = 0; ! 	      d->file = enter_file (*p);  	      d->file->dontcare = 1; @ 	      /* Setting the `changed' member to 1 will make failure to: 		 update or find this makefile as if it had come from the: 		 MAKEFILES variable: we don't care, so we won't die.  */ 	      d->changed = 1; 	      if (tail == 0)  		read_makefiles = d;  	      else  		tail->next = d;  	      tail = d; 	    } 	  if (tail != 0)  	    tail->next = 0; 	}     }      return read_makefiles; }                                                     J /* Read file FILENAME as a makefile and add its contents to the data base.  G    TYPE indicates what flavor of makefile this is: 0 => a default or -f I    makefile (the basis for comparison); 1 => from the MAKEFILES variable: I    cannot determine the default goal, is searched for in the search path, H    and it's not an error if it doesn't exist; 2 => an included makefile:&    is searched for in the search path.  7    FILENAME is added to the `read_makefiles' chain.  */    static void  read_makefile (filename, type)      char *filename;      int type; {    static char *collapsed = 0; +   static unsigned int collapsed_length = 0;    register FILE *infile;   struct linebuffer lb; "   unsigned int commands_len = 200;*   char *commands = (char *) xmalloc (200);    unsigned int commands_idx = 0;    unsigned int commands_started;   register char *p;    char *p2;    int ignoring = 0;       struct nameseq *filenames = 0;   struct dep *deps;    unsigned int lineno = 1;   unsigned int nlines = 0;   int two_colon;&   char *pattern = 0, *pattern_percent;  + #define record_waiting_files()						      \    do									      \     { 									      \G       record_files (filenames, pattern, pattern_percent, deps,		      \ 8 		    commands_started, commands, commands_idx,		      \7 		    two_colon, filename, lineno, type != 1);		      \ "       filenames = 0;							      \%       commands_idx = 0;							      \         pattern = 0;							      \     } while (0)   7 #ifdef	lint	/* Suppress `used before set' messages.  */    two_colon = 0; #endif  %   /* First, get a stream to read.  */   !   infile = fopen (filename, "r");   A   /* If the makefile wasn't found and it's either a makefile from H      the `MAKEFILES' variable (type 1) or an included makefile (type 2),D      search the included makefile search path for this makefile.  */  
 #ifdef VMSB   if (infile == 0 && (type == 1 || type == 2) && *filename != ']') #else B   if (infile == 0 && (type == 1 || type == 2) && *filename != '/') #endif     {        register unsigned int i;3       for (i = 0; include_directories[i] != 0; ++i)  	{
 #ifdef VMS> 	  char *name = concat (include_directories[i], "", filename); #else ? 	  char *name = concat (include_directories[i], "/", filename);  #endif 	  infile = fopen (name, "r"); 	  if (infile != 0)  	    { 	      filename = name; 
 	      break;( 	    } 	  else9 	    free (name);n 	}     }.  5   /* Add FILENAME to the chain of read makefiles.  */w6   deps = (struct dep *) xmalloc (sizeof (struct dep));   deps->next = read_makefiles;   read_makefiles = deps;   deps->name = 0;o&   deps->file = lookup_file (filename);   if (deps->file == 0)     { I       deps->file = enter_file (savestring (filename, strlen (filename)));N       if (type == 1) 	deps->file->dontcare = 1;     }T   filename = deps->file->name;   deps->file->precious = 1;e   deps->changed = type;m   deps = 0;   +   /* If the makefile can't be found at all,n.      either ignore it or give up entirely.  */     if (infile == 0)     {t       if (type != 1)( 	perror_with_name ("fopen: ", filename);
       return;      }c     reading_filename = filename;   reading_lineno_ptr = &lineno;"  !   /* Loop over lines in the file.i=      The strategy is to accumulate target names in FILENAMES,d3      dependencies in DEPS and commands in COMMANDS.e$      These are used to define a ruleA      when the start of the next rule (or eof) is encountered.  */c     initbuffer (&lb);      while (!feof (infile))     {        lineno += nlines;i0       nlines = readline (&lb, infile, filename);  )       /* Collapse continuation lines.  */s)       collapse_continuations (lb.buffer);l  %       if (collapsed_length < lb.size)h 	{ 	  collapsed_length = lb.size; 	  if (collapsed != 0) 	    free (collapsed);3 	  collapsed = (char *) xmalloc (collapsed_length);f 	}$       strcpy (collapsed, lb.buffer);"       remove_comments (collapsed);  !       p = next_token (collapsed);a-       if (*p == '\0' && lb.buffer[0] != '\t'))
 	continue;  J #define	word1eq(s, l) 	((p[l] == '\0' || p[l] == ' ' || p[l] == '\t') && \ 			 !strncmp (s, p, l))o7       if (word1eq ("ifdef", 5) || word1eq ("ifndef", 6)a1 	  || word1eq ("ifeq", 4) || word1eq ("ifneq", 5)t2 	  || word1eq ("else", 4) || word1eq ("endif", 5)) 	{2 	  int i = conditional_line (p, filename, lineno); 	  if (i >= 0) 	    { 	      ignoring = i; 	      continue; 	    } 	  else F 	    fatal ("%s:%u: invalid syntax in conditional", filename, lineno); 	}       if (ignoring)t
 	continue;$       else if (lb.buffer[0] == '\t') 	{' 	  /* This line is a shell command.  */o 	  unsigned int len;   	  if (filenames == 0); 	    fatal ("%s:%u: commands commence before first target",c 	           filename, lineno);  E 	  /* Add this command line to end of the line being accumulated.  */a 	  p = lb.buffer;d 	  if (commands_idx == 0)/ 	    commands_started = lineno;a 	  len = strlen (p);- 	  if (len + 1 + commands_idx > commands_len)  	    {3 	      commands_len = (len + 1 + commands_idx) * 2; = 	      commands = (char *) xrealloc (commands, commands_len);l 	    }+ 	  bcopy (p, &commands[commands_idx], len);n 	  commands_idx += len;m# 	  commands[commands_idx++] = '\n';  	}%       else if (word1eq ("define", 6))  	{ 	  p2 = next_token (p + 6);d 	  p = end_of_token (p2); E 	  lineno = do_define (p2, p - p2, o_file, lineno, infile, filename);  	  continue; 	}$       else if (word1eq ("endef", 5))7 	fatal ("%s:%u: extraneous `endef'", filename, lineno);l'       else if (word1eq ("override", 8))* 	{ 	  p2 = next_token (p + 8);f 	  if (p2 == 0) C 	    error ("%s:%u: empty `override' directive", filename, lineno);f" 	  if (!strncmp (p2, "define", 6)) 	    { 	      unsigned int len; 	      p2 = end_of_token (p2);' 	      p = find_next_token (&p2, &len);d. 	      lineno = do_define (p, len, o_override,  				  lineno, infile, filename); 	    }6 	  else if (!try_variable_definition (p2, o_override))C 	    error ("%s:%u: Empty `override' directive", filename, lineno);* 	  continue; 	}&       else if (word1eq ("include", 7)) 	{9 	  /* We have found an `include' line specifying a nestedS, 	     makefile to be read at this point.  */, 	  struct conditionals *save = conditionals;( 	  struct conditionals new_conditionals;6 	  p = allocated_variable_expand (next_token (p + 8)); 	  if (*p == '\0') 	    {D 	      error ("%s:%u: no filename for `include'", filename, lineno); 	      continue; 	    } 	  p2 = end_of_token (p);g 	  if (*p2 != '\0')  	    { 	      *p2++ = '\0';$ 	      if (*next_token (p2) != '\0')2 		error ("%s:%u: extraneous text after `include'", 		       filename, lineno);e 	    }? 	  bzero ((char *) &new_conditionals, sizeof new_conditionals);e$ 	  conditionals = &new_conditionals;> 	  /* Record the rules that are waiting so they will determineA 	     the default goal before those in the included makefile.  */  	  record_waiting_files ();c 	  read_makefile (p, 2); 	  free (p); 	  conditionals = save;l 	  reading_filename = filename;0  	  reading_lineno_ptr = &lineno; 	  continue; 	}$       else if (word1eq ("vpath", 5)) 	{ 	  char *pattern;; 	  unsigned int len;  	  p2 = variable_expand (p + 5);# 	  p = find_next_token (&p2, &len);( 	  if (p != 0) 	    {% 	      pattern = savestring (p, len); ' 	      p = find_next_token (&p2, &len);r 	      if (p != 0) 		{h 		  p = savestring (p, len);7 		  if (find_next_token (&p2, (unsigned int *) 0) != 0) > 		    error ("%s:%u: extraneous text after `vpath' directive", 			   filename, lineno); 		}o1 	      /* No searchpath means remove all previousi/ 		 selective VPATH's with the same pattern.  */= 	    } 	  elseeC 	    /* No pattern means remove all previous selective VPATH's.  */n 	    pattern = 0;i% 	  construct_vpath_list (pattern, p);r 	  if (pattern != 0) 	    free (pattern); 	  if (p != 0) 	    free (p); 	  continue; 	} #undef	word1eq3       else if (try_variable_definition (p, o_file)) 
 	continue;
       else 	{0 	  /* This line describes some target files.  */   	  char *cmdleft;   # 	  /* Record the previous rule.  */    	  record_waiting_files ();   6 	  /* Look for a semicolon in the unexpanded line.  */( 	  cmdleft = find_semicolon (lb.buffer); 	  if (cmdleft != 0)E 	    /* Found one.  Cut the line short there before expanding it.  */  	    *cmdleft = '\0';e  C 	  /* Expand variable and function references before doing anythingiB 	     else so that special characters can be inside variables.  */# 	  p = variable_expand (lb.buffer);    	  if (cmdleft == 0)6 	    /* Look for a semicolon in the expanded line.  */" 	    cmdleft = find_semicolon (p);   	  if (cmdleft != 0)0 	    /* Cut the line short at the semicolon.  */ 	    *cmdleft = '\0';_  ( 	  /* Remove comments from the line.  */ 	  remove_comments (p);n   	  p2 = next_token (p);0 	  if (*p2 == '\0')=5 	    /* This line contained a variable reference that / 	       expanded to nothing but whitespace.  */c 	    continue; 	  else if (*p2 == ':')0< 	    fatal ("%s:%u: missing target name", filename, lineno);  4 	  filenames = multi_glob (parse_file_seq (&p2, ':',! 						  sizeof (struct nameseq)),  				  sizeof (struct nameseq));e 	  if (*p2++ == '\0')	: 	    fatal ("%s:%u: missing separator", filename, lineno);1 	  /* Is this a one-colon or two-colon entry?  */n 	  two_colon = *p2 == ':'; 	  if (two_colon)m
 	    p2++;  D 	  /* Is this a static pattern rule: `target: %targ: %dep; ...'?  */ 	  p = index (p2, ':');	" 	  while (p != 0 && p[-1] == '\\') 	    {! 	      register char *q = &p[-1]; " 	      register int backslash = 0; 	      while (*q-- == '\\')s 		backslash = !backslash;o 	      if (backslash)* 		p = index (p + 1, ':');d 	      elsen 		break; 	    } 	  if (p != 0) 	    { 	      struct nameseq *target;C 	      target = parse_file_seq (&p2, ':', sizeof (struct nameseq));  	      ++p2; 	      if (target == 0)a< 		fatal ("%s:%u: missing target pattern", filename, lineno);" 	      else if (target->next != 0)> 		fatal ("%s:%u: multiple target patterns", filename, lineno); 	      pattern = target->name;0 	      pattern_percent = find_percent (pattern);  	      if (pattern_percent == 0)2 		fatal ("%s:%u: target pattern contains no `%%'", 		       filename, lineno);t 	    } 	  elser 	    pattern = 0;e  ! 	  /* Parse the dependencies.  */n 	  deps = (struct dep *)A 	    multi_glob (parse_file_seq (&p2, '\0', sizeof (struct dep)),  			sizeof (struct dep));   	  commands_idx = 0; 	  if (cmdleft != 0) 	    {6 	      /* Semicolon means rest of line is a command *// 	      unsigned int len = strlen (cmdleft + 1);p  ! 	      commands_started = lineno;   2 	      /* Add this command line to the buffer.  */" 	      if (len + 2 > commands_len) 		{u! 		  commands_len = (len + 2) * 2;e: 		  commands = (char *) xrealloc (commands, commands_len); 		}m* 	      bcopy (cmdleft + 1, commands, len); 	      commands_idx += len;;' 	      commands[commands_idx++] = '\n';  	    } 	}     }o     if (ignoring)h7     fatal ("%s:%u: missing `endif'", filename, lineno);t  &   /* At eof, record the last rule.  */   record_waiting_files ();     freebuffer (&lb);    free ((char *) commands);r   fclose (infile);     reading_filename = 0;u   reading_lineno_ptr = 0;i }a                          /* Execute a `define' directive.@    The first line has already been read, and NAME is the name ofF    the variable to be defined.  The following lines remain to be read.@    LINENO, INFILE and FILENAME refer to the makefile being read.A    The value returned is LINENO, updated for lines read here.  */l   static unsigned int(; do_define (name, namelen, origin, lineno, infile, filename)a      char *name;      unsigned int namelen;!      enum variable_origin origin;       unsigned int lineno;b      FILE *infile;      char *filename; {.   struct linebuffer lb;l   unsigned int nlines = 0;   unsigned int length = 100;,   char *definition = (char *) xmalloc (100);    register unsigned int idx = 0;   register char *p;;     initbuffer (&lb);    while (!feof (infile))     {k       lineno += nlines;f0       nlines = readline (&lb, infile, filename);!       p = next_token (lb.buffer);=  7       if ((p[5] == '\0' || p[5] == ' ' || p[5] == '\t'), 	  && !strncmp (p, "endef", 5))e 	{
 	  p += 5; 	  collapse_continuations (p); 	  remove_comments (p);i 	  if (*next_token (p) != '\0'),= 	    error ("%s:%u: Extraneous text after `endef' directive",p 		   filename, lineno);i 	  /* Define the variable.  */ 	  if (idx == 0) 	    definition[0] = '\0'; 	  elsel  	    definition[idx - 1] = '\0';A 	  (void) define_variable (name, namelen, definition, origin, 1);  	  free (definition);0 	  return lineno;/ 	}
       else 	{! 	  unsigned int len = strlen (p);e  0 	  /* Increase the buffer size if necessary.  */ 	  if (idx + len + 1 > length) 	    {  	      length = (idx + len) * 2;? 	      definition = (char *) xrealloc (definition, length + 1);  	    }  $ 	  bcopy (p, &definition[idx], len); 	  idx += len;( 	  /* Separate lines with a newline.  */ 	  definition[idx++] = '\n'; 	}     }n     /* No `endef'!!  */cL   fatal ("%s:%u: missing `endef', unterminated `define'", filename, lineno);   return 0;, }m                                          < /* Interpret conditional commands "ifdef", "ifndef", "ifeq",    "ifneq", "else" and "endif". >    LINE is the input line, with the command as its first word.  >    FILENAME and LINENO are the filename and line number in the7    current makefile.  They are used for error messages.}  &    Value is -1 if the line is invalid,-    0 if following text should be interpreted,n-    1 if following text should be ignored.  */*  
 static int) conditional_line (line, filename, lineno)       char *line;      char *filename;      unsigned int lineno;  { 
   int notdef;"   char *cmdname;   register unsigned int i;     if (*line == 'i')k     {;%       /* It's an "if..." command.  */)       notdef = line[2] == 'n';       if (notdef)  	{1 	  cmdname = line[3] == 'd' ? "ifndef" : "ifneq";t% 	  line += cmdname[3] == 'd' ? 7 : 6;) 	}
       else 	{/ 	  cmdname = line[2] == 'd' ? "ifdef" : "ifeq";*% 	  line += cmdname[2] == 'd' ? 6 : 5;1 	}     }e   else     {//       /* It's an "else" or "endif" command.  */s       notdef = line[1] == 'n';*       cmdname = notdef ? "endif" : "else";       line += notdef ? 5 : 4;      }o     line = next_token (line);a     if (*cmdname == 'e')     {k       if (*line != '\0')6 	error ("%s:%u: Extraneous text after `%s' directive",# 	       filename, lineno, cmdname);c       /* "Else" or "endif".  */t%       if (conditionals->if_cmds == 0){? 	fatal ("%s:%u: extraneous `%s'\n", filename, lineno, cmdname);r1       /* NOTDEF indicates an `endif' command.  */        if (notdef)n 	--conditionals->if_cmds;a
       else2 	conditionals->ignoring[conditionals->if_cmds - 1]8 	  = !conditionals->ignoring[conditionals->if_cmds - 1];1       for (i = 0; i < conditionals->if_cmds; ++i)o 	if (conditionals->ignoring[i])a 	  return 1;       return 0;_     })  &   if (conditionals->max_ignoring == 0)     {n%       conditionals->max_ignoring = 5; M       conditionals->ignoring = (char *) xmalloc (conditionals->max_ignoring);      }q     ++conditionals->if_cmds;9   if (conditionals->if_cmds > conditionals->max_ignoring)+     { &       conditionals->max_ignoring += 5;'       conditionals->ignoring = (char *)s? 	xrealloc (conditionals->ignoring, conditionals->max_ignoring);      }!  "   if (conditionals->if_cmds > 1 &&8       conditionals->ignoring[conditionals->if_cmds - 2])4     /* We are already ignoring, so just push a levelB        to match the next "else" or "endif", and keep ignoring.  */:     conditionals->ignoring[conditionals->if_cmds - 1] = 1;*   else if (cmdname[notdef ? 3 : 2] == 'd')     {t!       /* "Ifdef" or "ifndef".  */c       struct variable *v;t-       register char *p = end_of_token (line);)       i = p - line;        p = next_token (p);        if (*p != '\0')  	return -1;i$       v = lookup_variable (line, i);7       conditionals->ignoring[conditionals->if_cmds - 1] + 	= (v != 0 && *v->value != '\0') == notdef;r     }e   else     {a       /* "Ifeq" or "ifneq".  */p       char *s1, *s2;       unsigned int len;)/       char termin = *line == '(' ? ',' : *line;d  ;       if (termin != ',' && termin != '"' && termin != '\'')d 	return -1;          s1 = ++line;.       /* Find the end of the first string.  */       if (termin == ',') 	{ 	  register int count = 0;  	  for (; *line != '\0'; ++line) 	    if (*line == '(') 	      ++count;  	    else if (*line == ')')  	      --count;x) 	    else if (*line == ',' && count <= 0) 
 	      break;r 	}
       else) 	while (*line != '\0' && *line != termin)_
 	  ++line;         if (*line == '\0') 	return -1;h         *line++ = '\0';o          s2 = variable_expand (s1);C       /* We must allocate a new copy of the expanded string because . 	 variable_expand re-uses the same buffer.  */       len = strlen (s2);%       s1 = (char *) alloca (len + 1);x       bcopy (s2, s1, len + 1);         if (termin != ','), 	/* Find the start of the second string.  */ 	line = next_token (line);  +       termin = termin == ',' ? ')' : *line;l;       if (termin != ')' && termin != '"' && termin != '\'')i 	return -1;n  /       /* Find the end of the second string.  */:       if (termin == ')') 	{ 	  register int count = 0; 	  s2 = next_token (line);) 	  for (line = s2; *line != '\0'; ++line)  	    { 	      if (*line == '(')
 		++count; 	      else if (*line == ')')r 		if (count <= 0) 
 		  break; 		else 		  --count; 	    } 	}
       else 	{
 	  ++line;
 	  s2 = line;r+ 	  while (*line != '\0' && *line != termin)  	    ++line; 	}         if (*line == '\0') 	return -1;h         *line = '\0';h!       line = next_token (++line);        if (*line != '\0')6 	error ("%s:%u: Extraneous text after `%s' directive",# 	       filename, lineno, cmdname);,          s2 = variable_expand (s2);7       conditionals->ignoring[conditionals->if_cmds - 1]s 	= streq (s1, s2) == notdef;     }o  ;   /* Search through the stack to see if we're ignoring.  */l-   for (i = 0; i < conditionals->if_cmds; ++i)p"     if (conditionals->ignoring[i])       return 1;_   return 0;e };                                          . /* Remove duplicate dependencies in CHAIN.  */   void uniquize_deps (chain)       struct dep *chain;n {0   register struct dep *d;d  @   /* Make sure that no dependencies are repeated.  This does not>      really matter for the purpose of updating targets, but it=      might make some names be listed twice for $^ and $?.  *//  &   for (d = chain; d != 0; d = d->next)     {        struct dep *last, *next;         last = d;        next = d->next;        while (next != 0) + 	if (streq (dep_name (d), dep_name (next)))i 	  {  	    struct dep *n = next->next; 	    last->next = n;2 	    if (next->name != 0 && next->name != d->name) 	      free (next->name);  	    if (next != d)c 	      free ((char *) next); 	    next = n; 	  } 	elsed 	  { 	    last = next;  	    next = next->next;  	  }     }h }                                                 1 /* Record a description line for files FILENAMES, 8    with dependencies DEPS, commands to execute describedG    by COMMANDS and COMMANDS_IDX, coming from FILENAME:COMMANDS_STARTED.e3    TWO_COLON is nonzero if a double colon was used.*6    If not nil, PATTERN is the `%' pattern to make this:    a static pattern rule, and PATTERN_PERCENT is a pointer    to the `%' within it.  ?    The links of FILENAMES are freed, and so are any names in it <    that are not incorporated into other data structures.  */   static voidrJ record_files (filenames, pattern, pattern_percent, deps, commands_started,H 	      commands, commands_idx, two_colon, filename, lineno, set_default)      struct nameseq *filenames; %      char *pattern, *pattern_percent;i      struct dep *deps;#      unsigned int commands_started;       char *commands;      unsigned int commands_idx;       int two_colon;(      char *filename;      unsigned int lineno;d      int set_default;  {;   struct nameseq *nextf;   int implicit = 0;e'   unsigned int max_targets, target_idx; ,   char **targets = 0, **target_percents = 0;   struct commands *cmds;     if (commands_idx > 0)      { D       cmds = (struct commands *) xmalloc (sizeof (struct commands));        cmds->filename = filename;&       cmds->lineno = commands_started;;       cmds->commands = savestring (commands, commands_idx);s       cmds->command_lines = 0;     }f   else
     cmds = 0;/    +   for (; filenames != 0; filenames = nextf)      {t,       register char *name = filenames->name;       register struct file *f;       register struct dep *d;i       struct dep *this;        char *implicit_percent;o         nextf = filenames->next;        free ((char *) filenames);  -       implicit_percent = find_percent (name); (       implicit |= implicit_percent != 0;  #       if (implicit && pattern != 0)t9 	fatal ("%s:%u: mixed implicit and static pattern rules",  	       filename, lineno);  ,       if (implicit && implicit_percent == 0)D 	fatal ("%s:%u: mixed implicit and normal rules", filename, lineno);         if (implicit)a 	{ 	  if (targets == 0) 	    { 	      max_targets = 5;a9 	      targets = (char **) xmalloc (5 * sizeof (char *)); A 	      target_percents = (char **) xmalloc (5 * sizeof (char *));" 	      target_idx = 0; 	    }* 	  else if (target_idx == max_targets - 1) 	    { 	      max_targets += 5;6 	      targets = (char **) xrealloc ((char *) targets,( 					    max_targets * sizeof (char *)); 	      target_percents1 		= (char **) xrealloc ((char *) target_percents,l) 				      max_targets * sizeof (char *));  	    } 	  targets[target_idx] = name;2 	  target_percents[target_idx] = implicit_percent; 	  ++target_idx; 	  continue; 	}  =       /* If there are multiple filenames, copy the chain DEPS*= 	 for all but the last one.  It is not safe for the same deps 4 	 to go in more than one place in the data base.  */7       this = nextf != 0 ? copy_dep_chain (deps) : deps;e         if (pattern != 0)"' 	/* If this is an extended static rule:'1 	   `targets: target%pattern: dep%pattern; cmds',]; 	   translate each dependency pattern into a plain filename68 	   using the target pattern and this target's name.  */7 	if (!pattern_matches (pattern, pattern_percent, name)); 	  {6 	    /* Give a warning if the rule is meaningless.  */B 	    error ("%s:%u: target `%s' doesn't match the target pattern", 		   filename, lineno, name);( 	    this = 0; 	  } 	elseu 	  {< 	    /* We use patsubst_expand to do the work of translatingC 	       the target pattern, the target's name and the dependencies'>1 	       patterns into plain dependency names.  */ ) 	    char *buffer = variable_expand ("");E  ( 	    for (d = this; d != 0; d = d->next) 	      {
 		char *o;) 		char *percent = find_percent (d->name);l 		if (percent == 0)a
 		  continue;]6 		o = patsubst_expand (buffer, name, pattern, d->name,# 				     pattern_percent, percent);s 		free (d->name);i, 		d->name = savestring (buffer, o - buffer); 	      } 	  }              if (!two_colon)> 	{/ 	  /* Single-colon.  Combine these dependenciesg< 	     with any others in file's existing record, if any.  */ 	  f = enter_file (name);) 	  if (f->double_colon)oC 	    fatal ("target file `%s' has both : and :: entries", f->name);i= 	  /* If CMDS == F->CMDS, this target was listed in this ruledF 	     more than once.  Just give a warning since this is harmless.  */$ 	  if (cmds != 0 && cmds == f->cmds)H 	    error ("%s:%u: target `%s' given more than once in the same rule.",  		   filename, lineno, f->name);< 	  /* Check for two single-colon entries both with commands.A 	     Check is_target so that we don't lose on files such as .c.oi- 	     whose commands were preinitialized.  */c6 	  else if (cmds != 0 && f->cmds != 0 && f->is_target)3 	    fatal ("%s:%u: commands for target `%s' were \  already specified at %s:%u"," 		   cmds->filename, cmds->lineno,2 		   f->name, f->cmds->filename, f->cmds->lineno); 	  f->is_target = 1;; 	  /* Defining .DEFAULT with no deps or cmds clears it.  */i3 	  if (f == default_file && this == 0 && cmds == 0)0 	    f->cmds = 0;  	  if (cmds != 0)  	    f->cmds = cmds;- 	  /* Defining .SUFFIXES with no dependenciesd* 	     clears out the list of suffixes.  */% 	  if (f == suffix_file && this == 0)  	    f->deps = 0;' 	  else if (f->deps != 0)r 	    { 	      d = f->deps;  	      while (d->next != 0)f 		d = d->next; 	      d->next = this; 	    } 	  elsee 	    f->deps = this;   	  uniquize_deps (f->deps);   > 	  /* If this is a static pattern rule, set the file's stem to? 	     the part of its name that matched the `%' in the pattern, , 	     so you can use $* in the commands.  */ 	  if (pattern != 0) 	    {" 	      static char *percent = "%";+ 	      char *buffer = variable_expand (""); A 	      char *o = patsubst_expand (buffer, name, pattern, percent,o  					 pattern_percent, percent);1 	      f->stem = savestring (buffer, o - buffer);  	    } 	}
       else 	{& 	  /* Double-colon.  Make a new record+ 	     even if the file already has one.  */n 	  f = lookup_file (name);8 	  /* Check for both : and :: rules.  Check is_target so= 	     we don't lose on default suffix rules or makefiles.  */!2 	  if (f != 0 && f->is_target && !f->double_colon)C 	    fatal ("target file `%s' has both : and :: entries", f->name);e 	  f = enter_file (name);e1 	  /* If there was an existing entry and it was ar9 	     double-colon entry, enter_file will have returned ai= 	     new one, making it the prev pointer of the old one.  */o 	  f->is_target = 1; 	  f->double_colon = 1;  	  f->deps = this; 	  f->cmds = cmds; 	}  -       /* Free name if not needed further.  */m#       if (f != 0 && name != f->namel
 #ifdef VMSA 	  && !(f->name == name + 2 && name[0] == '[' && name[1] == ']'))l #else A 	  && !(f->name == name + 2 && name[0] == '.' && name[1] == '/'))' #endif 	{ 	  free (name);e 	  name = f->name; 	}  9       /* See if this is first target seen whose name doesg7 	 not start with a `.', unless it contains a slash.  */;/       if (default_goal_file == 0 && set_defaulti
 #ifdef VMS 	  ) #else / 	  && (*name != '.' || index (name, '/') != 0))  #endif 	{ 	  int reject = 0;  % 	  /* If this file is a suffix, don't * 	     let it be the default goal file.  */  3 	  for (d = suffix_file->deps; d != 0; d = d->next)e 	    { 	      register struct dep *d2; > 	      if (*dep_name (d) != '.' && streq (name, dep_name (d))) 		{  		  reject = 1;i
 		  break; 		}r; 	      for (d2 = suffix_file->deps; d2 != 0; d2 = d2->next)  		{t7 		  register unsigned int len = strlen (dep_name (d2)); + 		  if (strncmp (name, dep_name (d2), len))  		    continue;*) 		  if (streq (name + len, dep_name (d)))t 		    {t 		      reject = 1;  		      break; 		    }a 		}) 	      if (reject) 		break; 	    }   	  if (!reject)x 	    default_goal_file = f;  	}     }n     if (implicit)a     {-       targets[target_idx] = 0;&       target_percents[target_idx] = 0;O       create_pattern_rule (targets, target_percents, two_colon, deps, cmds, 1); &       free ((char *) target_percents);     }  }                     G /* Search STRING for an unquoted ; that is not after an unquoted #.  */e  
 static char *m find_semicolon (string)d      char *string; {M   char *found, *p;     found = index (string, ';');)   while (found != 0 && found[-1] == '\\')      { $       register char *q = &found[-1];!       register int backslash = 0;r       while (*q-- == '\\') 	backslash = !backslash;       if (backslash)  	found = index (found + 1, ';');
       else 	break;i     }t   if (found == 0)r
     return 0;   @   /* Look for a comment character (#) before the ; we found.  */"   p = lindex (string, found, '#');!   while (p != 0 && p[-1] == '\\')_     {o        register char *q = &p[-1];!       register int backslash = 0;s       while (*q-- == '\\') 	backslash = !backslash;       if (backslash)  	p = lindex (p + 1, found, '#');
       else 	break;      }e
   if (p == 0)i     return found;c   return 0;c }                                         H /* Search PATTERN for an unquoted %.  Backslashes quote % and backslash.E    Quoting backslashes are removed from PATTERN by compacting it intogF    itself.  Returns a pointer to the first unquoted % if there is one,     or nil if there are none.  */   char * find_percent (pattern)      char *pattern;> {e.   unsigned int pattern_len = strlen (pattern);   register char *p = pattern;=  #   while ((p = index (p, '%')) != 0) %     if (p > pattern && p[-1] == '\\')        { $ 	/* Search for more backslashes.  */ 	register int i = -2; ) 	while (&p[i] >= pattern && p[i] == '\\')a 	  --i;; 	++i; ( 	/* The number of backslashes is now -I.3 	   Copy P over itself to swallow half of them.  */*G 	bcopy (&p[i / 2], &p[i], (pattern_len - (p - pattern)) - (i / 2) + 1);) 	p += i / 2; 	if (i % 2 == 0)D 	  /* All the backslashes quoted each other; the % was unquoted.  */ 	  return p; 	elsec= 	  /* The % was quoted by a backslash.  Look for another.  */  	  ++p;u       }      else#       /* No backslash in sight.  */&       return p;t     /* Never hit a %.  */e   return 0;d }r                                            ? /* Parse a string into a sequence of filenames represented as a=D    chain of struct nameseq's in reverse order and return that chain.  D    The string is passed as STRINGP, the address of a string pointer.@    The string pointer is updated to point at the first character>    not parsed, which either is a null char or equals STOPCHAR.  /    SIZE is how big to construct chain elements.sA    This is useful if we want them actually to be other structuresc*    that have room for additional info.  */   struct nameseq *( parse_file_seq (stringp, stopchar, size)      char **stringp;      char stopchar;i      unsigned int size;d { #   register struct nameseq *new = 0;     register struct nameseq *new1;   register char *p = *stringp;
   char *q;
   char *name;    register int c;o     while (1)n     {a=       /* Skip whitespace; see if any more names are left.  */a       p = next_token (p);        if (*p == '\0')  	break;s       if (*p == stopchar)  	break;e(       /* Yes, find end of next name.  */       q = p;       while (1)a 	{ 	  c = *p++; 	  if (c == '\0')n 	    break;p 	  else if (c == '\\' &&F 	           (*p == '\\' || *p == ' ' || *p == '\t' || *p == stopchar))	 	    ++p;i3 	  else if (c == ' ' || c == '\t' || c == stopchar)r 	    break;a 	}
       p--;  +       /* Remove leading `./' sequences.  */n
 #ifdef VMS5       while (p - q > 2 && q[0] == '[' && q[1] == ']')t #elsex5       while (p - q > 2 && q[0] == '.' && q[1] == '/')p #endif 	q += 2;  
 #ifdef VMSM /* VMS filenames can have a ':' in them but they have to be '\'ed but we need 6  *  to remove this '\' before we can use the filename.  */0       {n" 	  char *q1 = q, *q2 = q, *p1 = p; 	  while (q1 != p) {+ 	      if (*q1 == '\\' && *(q1+1) == ':') {n	 		  q1++; 	 		  p1--;p 	      } 	      *q2++ = *q1++;m 	  }  7 	  /* Extract the filename just found, and skip it.  */-! 	  name = savestring (q, p1 - q);f       }  #else   :       /* Extract the filename just found, and skip it.  */#       name = savestring (q, p - q);h #endif  .       /* Add it to the front of the chain.  *//       new1 = (struct nameseq *) xmalloc (size);        new1->name = name;       new1->next = new;e       new = new1;/     }D     *stringp = p;t
   return new;d }     3 /* Read a line of text from STREAM into LINEBUFFER.n,    Combine continuation lines into one line.M    Return the number of actual lines read (> 1 if hacked continuation lines).a  */l   static unsigned intn' readline (linebuffer, stream, filename)e#      struct linebuffer *linebuffer;       FILE *stream;      char *filename; {f$   char *buffer = linebuffer->buffer;(   register char *p = linebuffer->buffer;,   register char *end = p + linebuffer->size;    register int len, lastlen = 0;   register char *p2;#   register unsigned int nlines = 0;f   register int backslash;      *p = '\0';     while (1)>     {i*       if (fgets (p, end - p, stream) == 0) 	if (feof (stream))s 	  return nlines;  	else  	  pfatal_with_name (filename);          len = strlen (p);m-       if (len == 0 || (p += len)[-1] != '\n')d 	{+ 	  /* Probably ran out of buffer space.  */d, 	  register unsigned int p_off = p - buffer; 	  linebuffer->size *= 2;t9 	  buffer = (char *) xrealloc (buffer, linebuffer->size);  	  p = buffer + p_off;# 	  end = buffer + linebuffer->size;	 	  linebuffer->buffer = buffer;i
 	  *p = '\0';e 	  lastlen = len;= 	  continue; 	}         ++nlines;   !       if (len == 1 && p > buffer) 8 	/* P is pointing at a newline and it's the beginning of9 	   the buffer returned by the last fgets call.  However,$9 	   it is not necessarily the beginning of a line if P is 6 	   pointing past the beginning of the holding buffer.? 	   If the buffer was just enlarged (right before the newline),e> 	   we must account for that, so we pretend that the two lines 	   were one line.  */ 	len += lastlen;       lastlen = len;       backslash = 0;'       for (p2 = p - 2; --len > 0; --p2)h 	{ 	  if (*p2 == '\\')* 	    backslash = !backslash; 	  elseh 	    break;: 	}              if (!backslash)  	{ 	  p[-1] = '\0'; 	  return nlines;e 	}         if (end - p <= 1)! 	{ 	  /* Enlarge the buffer.  */o, 	  register unsigned int p_off = p - buffer; 	  linebuffer->size *= 2;e9 	  buffer = (char *) xrealloc (buffer, linebuffer->size);g 	  p = buffer + p_off;# 	  end = buffer + linebuffer->size;l 	  linebuffer->buffer = buffer;, 	}     }t }p              , /* Construct the list of include directories/    from the arguments and the default list.  */m   void! construct_include_path (arg_dirs)       char **arg_dirs;  {    register unsigned int i;   struct stat stbuf;      /* Table to hold the dirs.  */  G   register unsigned int defsize = (sizeof (default_include_directories) 2 				   / sizeof (default_include_directories[0]));    register unsigned int max = 5;M   register char **dirs = (char **) xmalloc ((5 + defsize) * sizeof (char *));     register unsigned int idx = 0;  8   /* First consider any dirs specified with -I switches.&      Ignore dirs that don't exist.  */     if (arg_dirs != 0)     while (*arg_dirs != 0)       {  	char *dir = *arg_dirs++;x8 	if (stat (dir, &stbuf) == 0 && S_ISDIR (stbuf.st_mode)) 	  { 	    if (idx == max - 1) 	      { 		max += 5;  		dirs = (char **)@ 		  xrealloc ((char *) dirs, (max + defsize) * sizeof (char *)); 	      } 	    dirs[idx++] = dir;1 	  }       }   6   /* Now add at the end the standard default dirs.  */  7   for (i = 0; default_include_directories[i] != 0; ++i)_:     if (stat (default_include_directories[i], &stbuf) == 0 	&& S_ISDIR (stbuf.st_mode))3       dirs[idx++] = default_include_directories[i];e     dirs[idx] = 0;  :   /* Now compute the maximum length of any name in it.  */     max_incl_len = 0;d   for (i = 0; i < idx; ++i)      { *       unsigned int len = strlen (dirs[i]);F       /* If dir name is written with a trailing slash, discard it.  */"       if (dirs[i][len - 1] == '/')A 	/* We can't just clobber a null in because it may have come from A 	   a literal string and literal strings may not be writable.  */t) 	dirs[i] = savestring (dirs[i], len - 1);t       if (len > max_incl_len)i 	max_incl_len = len;     }      include_directories = dirs;n }                                                       H /* Given a chain of struct nameseq's describing a sequence of filenames,F    in reverse of the intended order, return a new chain describing theH    result of globbing the filenames.  The new chain is in forward order.A    The links of the old chain are freed or used in the new chain.n+    Likewise for the names in the old chain.   /    SIZE is how big to construct chain elements.&A    This is useful if we want them actually to be other structurese*    that have room for additional info.  */   struct nameseq * multi_glob (chain, size)      struct nameseq *chain;+      unsigned int size;l { #   register struct nameseq *new = 0;    register struct nameseq *tem;    register struct nameseq *old;    register char **vec;   register unsigned int i;   unsigned int length;   struct nameseq *nexto;  *   for (old = chain; old != 0; old = nexto)     {i       nexto = old->next;  @ #ifndef VMS /* for now, VMS won't handle wildcarded filespecs */       if (*old->name == '~') 	{3 	  if (old->name[1] == '/' || old->name[1] == '\0')e 	    { 	      extern char *getenv ();> 	      char *home_dir = allocated_variable_expand ("$(HOME)");, 	      char is_variable = *home_dir != '\0'; 	      if (!is_variable) 		{. 		  free (home_dir); 		  home_dir = getenv ("HOME");& 		}] 	      if (home_dir == 0)  		{ . 		  unsigned int len = strlen (old->name + 1);* 		  bcopy (old->name + 1, old->name, len); 		  old->name[len] = '\0'; 		}n 	      elsea 		{)5 		  char *new = concat (home_dir, "", old->name + 1);/ 		  if (is_variable) 		    free (home_dir); 		  free (old->name);r 		  old->name = new; 		}  	    } 	  else  	    { 	      struct passwd *pwent;2 	      char *userend = index (old->name + 1, '/'); 	      if (userend != 0) 		*userend = '\0';( 	      pwent = getpwnam (old->name + 1); 	      if (pwent != 0) 		{  		  if (userend == 0)n 		    {e 		      free (old->name);d. 		      old->name = savestring (pwent->pw_dir,# 					      strlen (pwent->pw_dir));e 		    }s 		  else 		    { = 		      char *new = concat (pwent->pw_dir, "/", userend + 1);t 		      free (old->name);a 		      old->name = new; 		    }  		}n 	    } 	}  %       if (glob_pattern_p (old->name))  	{# 	  vec = glob_filename (old->name);e 	  if (vec == 0)( 	    fatal ("virtual memory exhausted"); 	    r 	  free (old->name);   	  /* NOSTRICT */s 	  if (vec != (char **) -1), 	    {
 	      i = 0;c 	      while (vec[i] != 0) 		++i; 	      length = i;D 	      qsort ((char *) vec, length, sizeof (char *), alpha_compare);# 	      for (i = length; i > 0; --i)t 		{;, 		  tem = (struct nameseq *) xmalloc (size); 		  tem->name = vec[i - 1];  		  tem->next = new; 		  new = tem; 		}e 	      free ((char *) vec);e 	    }   	  free ((char *) old);' 	}
       else #endif /* not VMS */ 	{ 	  old->next = new;s
 	  new = old;e 	}     }/  
   return new;  } 