/* DCDECL.C */
/* Y.L. Noyelle, Supelec, France 1994 */

#include <ctype.h>
#include <setjmp.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>	/* memcmp, strchr used */
#include "dcdecl.h"
#include "dcdecl.ph"
#include "dcblk.h"
#include "dcdir.h"
#include "dcexp.h"
#include "dcext.h"
#include "dcinst.h"
#include "dcmain.h"
#include "dcprag.h"
#include "dcrec.h"
#include "dctxttok.h"

#ifdef VMS
#pragma noinline (errMsngStati, fctInfo, getINDEXTYPEtype)
#pragma noinline (cleverSkipTok)
#endif

/* Miscelleanous */
#define BoolHCode	0x181C		/* to be changed if hCodFct changes */
#define BoolTName	(Tname)"\4\0bool"
#define InfoDcl(wName, xmemberFl, ydeclFl, znoNewTypeFl)		       \
  static TinfoDecl wName = {{  /* 'static' to avoid local compiler	       \
							 gross inefficiency. */\
    0-0		   /*~ zif (! __member(_fldSize))			       \
			    "misplaced initialization for field '_fldSize'" */,\
    NoAttrib+0-0   /*~ zif (! __member(_attriba))			       \
			    "misplaced initialization for field '_attriba'" */,\
    NoParQal+0-0   /*~ zif (! __member(_parQal))			       \
			     "misplaced initialization for field '_parQal'" */,\
    (bool)(0-0)	   /*~ zif (! __member(_fldFl))				       \
			      "misplaced initialization for field '_fldFl'" */,\
    xmemberFl	   /*~ zif (! __member(_memberFl))			       \
			   "misplaced initialization for field '_memberFl'" */,\
    ydeclFl	   /*~ zif (! __member(_declFl))			       \
			     "misplaced initialization for field '_declFl'" */,\
    znoNewTypeFl   /*~ zif (! __member(_noNewTypeFl))			       \
			"misplaced initialization for field '_noNewTypeFl'" */,\
    (bool)(0-0)	   /*~ zif (! __member(_signedInt))			       \
			  "misplaced initialization for field '_signedInt'" */,\
    (bool)(0-0)	   /*~ zif (! __member(_variousD))			       \
			   "misplaced initialization for field '_variousD'" */,\
    (bool)(0-0)||False /*~ zif (! __member(_variousD1))			       \
			  "misplaced initialization for field '_variousD1'" */,\
    /*~ zif ! __member()						       \
		"Structure '" ConvToString(wName) "' not fully initialized" */ \
  }}
#define MainHCode	0x1C01		/* to be changed if hCodFct changes */
#define OutsideStrunInit QuasiNULLval(TdeclList)
#define Sgnd		(Tqualif)1
#define StartTagCh	'#'
#define VerySpclRule	QuasiNULLval(TdeclList)

DefRepresType  /* define represType function */
DefIsSameName  /* define isSameName function */

/* Type definitions */
typedef struct {
  Tname idName;
  ThCode hCode;
  TpcTypeElt headType, tailType;
} TcreatType;

struct _TtagVisi;
typedef struct _TtagVisi TtagVisi;
struct _TtagVisi {
  int brLvl;
  TsemanElt *pTagId;
  TtagVisi *preced;
};

/* Function profiles */
static TpTypeElt allocTypeElt(void);
static void accumulateQal(TpcTypeElt, TpcTypeElt), checkEndAccumQal(TpcTypeElt,
  TpcTypeElt), checkWrngHdrFile(const TsemanElt *), cleverSkipTok(void), 
  computeSize(TpTypeElt), declObj(TdeclList), defFunc(TdeclList), defStrun(
  TsemanElt *, TtypeSort, Tname), errMsngStati(Tname), freeDeclList(TdeclList),
  init(TpTypeElt, bool, bool, TmacExpNb), initCreateTagName(void),
  initOrSizFld(TdeclList, TsemanElt *), manageFctDPrags(const TdeclElt *),
  nbBits(TdeclList);
static Tattrib attrib(void);
static TdeclElt *allocDeclElt(void);
static TdeclList createDLElt(TcreatType /*~MayModify*/, TinfoDecl, TpcTypeElt,
  Tqualif), decl1(TinfoDecl), decl3(TdeclList, TpcTypeElt, Tqualif),
  freeDeclElt(TdeclList);
static Tqualif arrQal(TpcTypeElt, Tqualif), typeQualif(void);
static TcreatType declId(void);
static TsemanElt *enterEnumTagName(Tname, TinfoSeman), *errAlrdDefId(Tname,
  TpcTypeElt, Tkind);
static TtagVisi *allocTagListElt(void), *freeTagListElt(TtagVisi *);
static Tname createTagName(Tname);
static TpcTypeElt nativeType(void);
static bool compatTypeR(TpcTypeElt, TpcTypeElt, TkTypeEquiv), rowUp(TpcTypeElt,
  TpcTypeElt), sameQal(TpcTypeElt, TpcTypeElt);

/* Objects declarations */
static int braceLvl;		/* +/- 1 at each strun opening/closing brace
								inside strun. */
static TdeclList curInitMember = OutsideStrunInit;
static size_t curInitArrayIndex = ArrLimErr;
static TpcTypeElt curInitArrayBndType = NULL;
static Tstring fileAtBegDecl;
static TlineNb lineAtBegDecl;
static bool msngAttribFl;
InfoDcl(noNewTypeInfo, False /*memberFl*/, False /*declFl*/, True
							       /*noNewTypeFl*/);
static TtagVisi *pTagList;  /* head of list of strun to be rendered invisible */
static bool signSpecSeen;
static const TtypeElt valInitTypeElt;  /* static => initialized to 0 =>
					 all fields either False, NULL, or 0. */
static const Ttok rBraSCol[] = {RBRA, SCOL, EndSTok};
static const Ttok sColLBra[] = {SCOL, LBRA, EndSTok};
static const Ttok sColRBra[] = {SCOL, RBRA, EndSTok};
static const Ttok zRbraSCol[] = {NoSwallowTok, RBRA, SCOL, EndSTok};
static const Ttok zCommaRBraSCol[] = {NoSwallowTok, COMMA, RBRA, SCOL, EndSTok};
static const Ttok zCommaRParSCol[] = {NoSwallowTok, COMMA, RPAR, SCOL, EndSTok};
static const Ttok zCoScEdpRPRB[] = {NoSwallowTok, COMMA, SCOL, ENDDPRAG, RPAR,
								 RBRA, EndSTok};
/* External objects */
bool heedRootType = True;
bool alrdAnalzdExp = False;
TsemanElt *pIdInit;  /* identifier being initialized */

void prog(void)
{
  jmp_buf mainErrRet;

  curErrRet = &mainErrRet /*~ LocalAdr */;
  if (setjmp(*curErrRet) != 0) {	/* return point in 'panic' mode */
    skipTok(sColLBra);
    if (curTok.tok == ENDPROG) return;}
  else {GetNxtTok(); if (FoundDP(DOLLSIGN)) dollAlwdInId = True;}
  pTagList = NULL;
  braceLvl = 0;
  do {
    decl();
  } while (curTok.tok != ENDPROG);
  spaceCount = nestLvl*indentIncr; checkIndent();  /* for possible 'scndMsg' */
}

void decl(void)
{
  TdeclList declList;
  Tattrib curAttrib;
  InfoDcl(attribAndFalseFl, False /*memberFl*/, True /*declFl*/,
							 False /*noNewTypeFl*/);

  checkIndent();
  fileAtBegDecl = curFileName; lineAtBegDecl = lineNb;
  attribAndFalseFl.s11._attriba = curAttrib = attrib();
  declList = decl1(attribAndFalseFl);
  if (declList != NULL) {	/* not function definition */
    if (declList != VerySpclRule) {
      while ((declList = freeDeclElt(declList)) != NULL) {}
      if (insideHdrFile) { if (curAttrib == Stati /* else error detected in
								    declObj() */
#ifdef VMS
				        && !vmsNoStd
#endif
						    ) err0(ExtrnExptd | Warn2);}
      else if (curAttrib == Extrn) err0(ExtDeclBeInHdrFile|Warn1|Rdbl);}
    if (ignoreErr = False, !Found(SCOL)) {
      errWFName(SColExptd1, lineAtBegDecl, fileAtBegDecl, NULL, errTxt[
	       CmplSColE1], (fileAtBegDecl == curFileName)? errTxt[At0] : NULL);
      errPanic(NoErrMsg, NULL);}}
}

static Tattrib attrib(void)
{
  Tattrib w;

  w = (Tattrib) (curTok.tok - BAttrib);
  if ((uint)w <= (uint)(EAttrib - 1 - BAttrib)) {  /* if found legal attribute,
		 absorb token, and absorb any other (useless) 'attrib' token. */
    while (InsideInterval(NxtTok(), BAttrib, EAttrib - 1)) err0(
							     MoreThanOneAttrib);
    w += StatiL;
    if (w==Stati && nestLvl!=0) w = StatiL;}
  else w = NoAttrib;
  return w;
}

static Tqualif typeQualif(void)
{
  Tqualif curQual, res = NoQualif;

  for (;;) {
    switch (curTok.tok) {
    case CONST: curQual = ConstQal; break;
    case VOLAT: curQual = VolatQal; break;
    default: return res;}
    if (res & curQual) err0(AlrdQual);
    res |= curQual;
    GetNxtTok();}
}

static TdeclList decl1(TinfoDecl infoDcl)
/* May return VerySpecialRule or NULL (declaration of tag alone, or definition
   of function). */
{
  Tname tagName = NULL;
  TpcTypeElt type;
  Tqualif qual;
  TtypeSort typS;
  const TsemanElt *sPtrTagId = NULL;

  qual = typeQualif();
  if ((qual & VolatQal)!=NoQualif && infoDcl.s11._attriba==Reg) err0(
						 RegVolatIncptbl|Warn2|PossErr);
  if (InsideInterval(curTok.tok, BNatTyp, SGND)) {
    type = nativeType();
    if (type->typeSort == Int) infoDcl.s11._signedInt = signSpecSeen;}
  else
    switch (curTok.tok) {
    case COLON:		/* in case of bit-field padding */
      if (! sysHdrFile) err0((qual == NoQualif)? BadIntgrlType :
						      BadIntgrlType|Warn1|Rdbl);
      type = &natTyp[UIntDpl];
      break;
    case ENUM: {
        TsemanElt *ptrTagId;

        if (NxtTok() == IDENT) {
          tagName = storeName(curTok.IdName, TagSpace);
          GetNxtTok();}
        if (curTok.tok == LBRA) {
          volatile TcalcS enumCtr = -1;  /* value of last enum constant;
					      'volatile' because of setjmp(). */
          TsemanElt *volatile pLastEnumCst = NULL, *volatile pIdEnumCst =
						      QuasiNULLval(TsemanElt *);
          volatile bool firstTurn;
          jmp_buf localJmpBuf, *savErrRet = curErrRet;
          TpTypeElt enumCstType;
          DefSem(defndEnumTag, EnumTag, True /*defnd*/);

          /* It is a new enum, so declare it, that is declare its enum tag */
          if (infoDcl.s11._noNewTypeFl) err0(StrunEnumDeclNotAlwd|Warn3|
								       PossErr);
          ptrTagId = enterEnumTagName(tagName, defndEnumTag);
          /* Create a type element for associated enum constants */
          enumCstType = allocTypeEltIC(ptrTagId->type, NoQualif);
          enumCstType->Shared = True;  /* owned by EnumTag */
          enumCstType->Generiq = True;  /* for enum constants to be usable by
							       derived types. */
          GetNxtTok();	/* here for good error position */
          /* Process enum constants list */
          curErrRet = &localJmpBuf /*~ LocalAdr */;
          if (setjmp(*curErrRet) == 0) firstTurn = True;
          else skipTok(zCommaRBraSCol);
          while (firstTurn || Found(COMMA)) {
            Tname enumCName;
            ThCode enumCHCode;
            bool initByPrevECst = False;

            ignoreErr = firstTurn = False;
            if (curTok.tok != IDENT) errPanic(IdExptd, NULL);
            enumCName = storeName(curTok.IdName, ObjectSpace);
            enumCHCode = curTok.Hcod;
            if (NxtTok() == ASGNOP) {	/* if initialized constant */
              TkAsgn oper;

              if ((oper = (TkAsgn)curTok.Val) != SimplAsgn) err0(
								SimplAsgnExptd);
              GetNxtTok();
              pIdInit = NULL;  /* for managePointers()/modifPtdVal() */
              if (correctExprN(enumCstType, Int, True, txtAsgnTok[oper],
								       False)) {
                enumCtr = cExp.Sval;
                if (cExp.ptrId == pIdEnumCst) initByPrevECst = True;
                goto initlzEnumCstL;}}
            if (! computeSigAdd(enumCtr, 1, (TcalcS */*~OddCast*/)&enumCtr)
#if defined(LONGLONG) || ULONG_MAXC>UINT_MAXC
				   || enumCtr>INT_MAXC
#endif
						      ) err0(Overflow1 | Warn2);
initlzEnumCstL:
            if ((pIdEnumCst = enterSymTabHC(enumCName, enumCHCode))==NULL &&
		   (pIdEnumCst = errAlrdDefId(enumCName, NULL, EnumCst))==NULL
					       ) pIdEnumCst = enterSymTab(NULL);
            {
              /* Chain enum constants */
              register TsemanElt *w = pLastEnumCst, *prevW = NULL;
              TenumCst iEnumCtr = (TenumCst)enumCtr;

              while (w!=NULL && iEnumCtr<w->EnumVal) {prevW = w; w = w->
								    NxtEnumCst;}
              if (initByPrevECst) (void)FoundDP(SAMEVAL);
              else if ((w!=NULL && iEnumCtr==w->EnumVal) != FoundDP(SAMEVAL)) {
                const Tchar *pBuf;

                if (w!=NULL && iEnumCtr==w->EnumVal) {
                  /* Search name of (last) same-valued enum constant */
                  const TsemanElt *pId;
                  TnameBuf buf;

                  (void)initGetNxtIdInCurBlk();
                  while (pId = nxtId(), pId->Kind!=EnumCst || pId->EnumVal!=
								    iEnumCtr) {}
                  bufNameToS(curIdName(), buf);
                  pBuf = &buf[0];}
                else pBuf = NULL;
                errWNSS((pBuf == NULL)? WrngSameVal|Warn1 : SameEnumCst|Warn2|
		    PossErr, enumCName, longToS((TgreatestInt)iEnumCtr), pBuf);}
              pIdEnumCst->NxtEnumCst = w;
              if (prevW == NULL) pLastEnumCst = pIdEnumCst; else prevW->
							NxtEnumCst = pIdEnumCst;
              pIdEnumCst->EnumVal = iEnumCtr;}
            {
              DefSem(defndEnumCst, EnumCst, True /*defnd*/);
              DefSem1(notUsedEnumCst, EnumCst, False /*defnd*/, True /*used*/,
							      False /*initlz*/);

#ifdef _AIX
              if (FoundDP(NOTUSED)) pIdEnumCst->infoS = notUsedEnumCst;
              else pIdEnumCst->infoS = defndEnumCst;
#else
              pIdEnumCst->infoS = (FoundDP(NOTUSED))? notUsedEnumCst :
								   defndEnumCst;
#endif
            }
            if (insideHdrFile) pIdEnumCst->Attribb = Extrn;
            pIdEnumCst->type = enumCstType;
            pIdEnumCst->defLineNb = lineNb;         /* record              */
            pIdEnumCst->defFileName = curFileName;} /*        birth place. */
          curErrRet = savErrRet;
          ((ModifType)ptrTagId->type)->FrstEnumCst = pLastEnumCst;
          if (pLastEnumCst == NULL) {  /* no enum constant found */
            enumCstType->Shared = False;
            (void)freeTypeElt(enumCstType);}
          else ((ModifType)enumCstType)->FrstEnumCst = pLastEnumCst;
          if (sysAdjHdrFile && tagName==NULL && infoDcl.s11._attriba!=Typdf) ((
		ModifType)ptrTagId->type)->IntPoss = True;  /* 'enum' cst
							     usable as 'int'. */
          ptrTagId->ListAlwdFiles = headListPrivTo;
          if (! Found(RBRA)) {errWS(CommaOrXExptd, "}"); cleverSkipTok();}}
        else {	/* no left brace seen ; is tag already defined ? */
          DefSem(notDefndEnumTag, EnumTag, False /*defnd*/);

          if (tagName == NULL) err0(UndefEnum);
          else if ((ptrTagId = searchSymTab(tagName)) != NULL) {
            if (ptrTagId->Kind == EnumTag) goto foundEnumTagL;}
          else errWN(NotDefTag, tagName);
          ptrTagId = enterEnumTagName(tagName, notDefndEnumTag);  /* if
					       unknown enumTag, declare it... */
foundEnumTagL:
          ptrTagId->Used = True;
          tagName = NULL;}	/* enforce that variables has to be declared
				 (NULLing tagName can be done because name sto-
				  rage freeing occurs anyway at block exit). */
        type = ptrTagId->type;
        sPtrTagId = ptrTagId;
        break;}
    case IDENT:
      if (adjustFile && isSameName(curTok.Hcod, curTok.IdName, BoolHCode,
			   BoolTName)) type = &boolCstTypeElt;  /* => generic */
      else {
        TsemanElt *ptrId = curTok.PtrSem;

        if (ptrId==NULL || ptrId->Kind!=Type) {
          Ttok peep;
          char frstCharOfIdent = (char)*(curTok.IdName + LgtHdrId);

          if (infoDcl.s11._prioToCast
              || (peep = peepNxtTok(), chkTypName
               && (isupper(frstCharOfIdent) ||frstCharOfIdent=='_')
               && peep!=LPAR
              || peep==IDENT || peep==STAR || infoDcl.s11._prioToCast && peep==
				       RPAR)) {  /* should be type identifier */
            if (ptrId == NULL) {
              if ((ptrId = searchSymTab(storeName(curTok.IdName, TagSpace) /* do
			not modify curTok.IdName, which may be in macro storage,
			and so, remanent */)) != NULL) {errWN(TagQM, curTok.
				IdName); if (dpragNst == 0) ptrId->Used = True;}
              else {
                DefSem1(artifDef, Type, True /*defnd*/, True /*used*/,
							      False /*initlz*/);

                errWN(UndefId, curTok.IdName);
                if (!chkTypName || isupper(frstCharOfIdent) || frstCharOfIdent
					      =='_') (void)defineId(artifDef);}}
            else if (ptrId->type != NULL) errWN(NotTypeId, curTok.IdName);
            type = NULL;}
          else goto forceIntTypeL;}
        else {
          type = ptrId->NamedType;
          if (dpragNst == 0) ptrId->Used = True;}}
      GetNxtTok();
      break;
    case LBRA:
      if (qual==NoQualif && infoDcl.s11._declFl && infoDcl.s11._attriba==
								     NoAttrib) {
        type = &natTyp[IntDpl];  /* to handle 'cleanly'	blocks		    */
        break;}			 /*	  declared (wrongly) at level zero. */
      err0(MsngStrunEnum);
      typS = Struct;  /* could be Union (or Enum); just to have dcc behave the
						    less stupidly possible... */
      goto strunTrmt;
    case STRUCT: GetNxtTok(); typS = Struct; goto strunTrmt;
    case UNION: GetNxtTok(); typS = Union;
strunTrmt: {
        TsemanElt *ptrTagId;
        volatile TdeclList membList = NULL, lastEltMembList;
        jmp_buf localJmpBuf, *savErrRet = curErrRet;

        if (curTok.tok == IDENT) {
          tagName = storeName(curTok.IdName, TagSpace);
          GetNxtTok();}
        if (curTok.tok == LBRA) {/* if left brace seen, definitely a new type */
          if (infoDcl.s11._noNewTypeFl) err0(StrunEnumDeclNotAlwd|Warn3|
								       PossErr);
          braceLvl++;
          if ((ptrTagId = enterSymTab(tagName)) == NULL) {  /* already
					       defined tag; is it compatible? */
            ptrTagId = searchSymTab(tagName);
            if (ptrTagId->type->typeSort == typS) {
              if (! ptrTagId->Defnd) {
                /* Declared but not defined ('Very Special Rule') */
                ptrTagId->defLineNb = lineNb;         /* record              */
                ptrTagId->defFileName = curFileName;  /*        birth place. */
                goto commonStrun;}
              if (adjustFile) {
                freeTypes(ptrTagId);
                tagName = ptrTagId->Nameb;
                goto commonStrun1;}}
            if (errAlrdDefId(tagName, NULL, StrunTag) == NULL) ptrTagId =
						  enterSymTab(NULL);} /* stub */
          /* Yet undefined tag, or stub */
commonStrun1:
          defStrun(ptrTagId, typS, tagName);  /* uncomplete strun as yet */
commonStrun:
          type = ptrTagId->type;
          GetNxtTok();	/* here for good error position */
          /* Explore member list */
          curErrRet = &localJmpBuf /*~ LocalAdr */;
          if (setjmp(*curErrRet) != 0) skipTok(sColRBra);
          while (curTok.tok!=RBRA && curTok.tok!=ENDPROG) {
            TdeclList newMembList, w;
            const TdeclElt *w1;
            InfoDcl(memberInfo, True /*memberFl*/, False /*declFl*/,
							 False /*noNewTypeFl*/);

            memberInfo.s11._attriba = attrib();
            newMembList = decl1(memberInfo);
            if (ignoreErr = False, curTok.tok != SCOL) errMsngSCol();
            if (memberInfo.s11._attriba != NoAttrib) err0(NoAttribAlwd);  /*
				checked here for deceitless error position... */
            if (newMembList == NULL) err0(FctDeclDefNotAlwd);
            else if (newMembList != VerySpclRule) {
              /* Accumulate const/volatile qualifiers */
              if (newMembList->type != NULL) {
                ((ModifType)ptrTagId->type)->SynthQualif |= newMembList->
								   type->Qualif;
                if (IsStrun(newMembList->type)) ((ModifType)ptrTagId->type)->
			     SynthQualif |= BaseStrunType(newMembList->type)->
								   SynthQualif;}
              /* Check that there are no double definition of member names, and
                 that members are allowed and of complete type; compute
                 qualifiers. */
              for (w = newMembList; w != NULL; ) {
                if (w->type!=NULL && IsFct(w->type)) err0(FctDeclDefNotAlwd);
                if (w->idName != NULL) {  /* not unnamed field (for non-fields,
				       naming is checked in 'initOrSizeFld'). */
                  for (w1 = membList; w1 != NULL; w1 = w1->cdr) {
                    if (w1->idName!=NULL && isSameName(w1->hCode, w1->idName,
							  w->hCode, w->idName)){
                      errWN(DblDefMember, w->idName);
                      break;}}}
                /* Insert new member into member list */
                if (membList == NULL) membList = w;
                else lastEltMembList->cdr = w;
                lastEltMembList = w;
                w = w->cdr;  /* to be left there (because of next statement) */
                lastEltMembList->cdr = NULL;}}
            if (ignoreErr = False, !Found(SCOL)) errPanic(NoErrMsg, NULL);}
          curErrRet = savErrRet;
          /* Define corresponding baseType (no more incomplete) */
          if (ptrTagId->Defnd) errId1(DblDefStrun, ptrTagId, NULL);  /* cannot
				       be checked before, because the tag may
				       be defined by a member of the strun... */
          ((ModifType)type)->MemberList = membList;
          if (membList == NULL) err0(EmptyStrun); 
          else {
            /* Compute size of strun (may be a minorand, because of alignment) */
            size_t size = 0;
            bool fldBefore = False;

            do {
              size_t membSize;

              if (membList->FldFl) {  /* field */
                if ((membSize = (size_t)membList->FldSize) == 0) size = ((size
			+ (CHAR_BITC - 1))/CHAR_BITC)*CHAR_BITC;  /* round to
								   next byte. */
                else fldBefore = True;}
              else {
                if (fldBefore) {
                  size = ((size + (CHAR_BITC - 1))/CHAR_BITC)*CHAR_BITC;  /*
							  round to next byte. */
                  fldBefore = False;}
                membSize = sizeOfTypeD(membList->type, IncplType,
						 membList->idName) * CHAR_BITC;}
              if (typS == Struct) size += membSize;
              else if (membSize > size) size = membSize;
              membList = membList->cdr;
            } while (membList != NULL);
            ((ModifType)type)->size = (size + (CHAR_BITC - 1)) / CHAR_BITC;}
          ((ModifType)type)->ErrSiz = True;  /* in case size = 0 (no correct
							      field type...). */
          ptrTagId->Defnd = True;
          /* Search if there are tags to be marked 'invisible' (from outside
             this declaration). */
          while ((pTagList != NULL) && (pTagList->brLvl == braceLvl)) {
            pTagList->pTagId->NotVisible = True;
            pTagList = freeTagListElt(pTagList);}
          if (--braceLvl > 0) {
            TtagVisi *w = allocTagListElt();

            w->brLvl = braceLvl;
            w->pTagId = ptrTagId;
            w->preced = pTagList;
            pTagList = w;}
          ptrTagId->ListAlwdFiles = headListPrivTo;
          GetNxtTok();}  /* here for good error position */
        else {	/* no left brace seen */
          if (tagName == NULL) errPanic(UndefStrun, NULL);
          type = NULL;}  /* to be able to cope with the 'Very Special Rule' */
        break;}
    default:
      if (nestLvl==0 && curTok.tok==RBRA) {curTok.tok = SCOL; errPanic(
							      ExtraRBra, NULL);}
      if (qual==NoQualif && infoDcl.s11._attriba==NoAttrib && infoDcl.s11.
		_declFl) errPanic((cUnitFName==NULL && curTok.tok==ENDPROG)?
						    NoErrMsg : DeclExptd, NULL);
forceIntTypeL:
      err0((qual!=NoQualif || infoDcl.s11._attriba!=NoAttrib || infoDcl.s11.
	    _declFl /* because function definition may have an empty baseType
		       and no qualif/attrib. */)
		? TypeExptd|Warn1|Rdbl
		: TypeExptd);
      type = &natTyp[IntDpl];}
  {
    Tqualif postQal = typeQualif();

    if (qual & postQal) err0(AlrdQual);
    else if (qual!=NoQualif && postQal!=NoQualif) err0(GroupQual|Warn1|Rdbl);
    qual |= postQal;
  }
  if (qual!=NoQualif && type!=NULL && IsFct(type)) errWT(UslFctQual|UWarn1|Rdbl,
									  type);
  {
    TcreatType firstId = declId();

    if (tagName != NULL) {  /* tag exists => Union/Struct/Enum */
      if (type == NULL) {
        /* structure or union ('strun') tag alone (no 'strun-decl-list') */
        TsemanElt *ptrTagId;

        if (firstId.idName==NULL && firstId.headType==NULL && !infoDcl.s11.
	    _noNewTypeFl) {  /* no declaration 	of object => 'very special ru-
	      le' (K&R p213) : declaration of incompletely specified 'strun'. */
          TpcTypeElt w;

          if (infoDcl.s11._attriba != NoAttrib) err0(NoAttribAlwd);
          if (qual != NoQualif) err0(NoQualifAlwd);
          if (   (ptrTagId = enterSymTab(tagName))!=NULL
              || (ptrTagId = errAlrdDefId(tagName, ((w = searchSymTab(tagName)
								->type) != NULL)
		 ? (w->typeSort == typS)
		   ? QuasiNULLval(TpcTypeElt)
		   : NULL
		 : NULL, StrunTag))!=NULL) defStrun(ptrTagId, typS, tagName);
          return VerySpclRule;}
        /* Utilization of strun (at least one object is declared,
							 or noNewType True). */
        if ((ptrTagId = searchSymTab(tagName)) != NULL) {
          if (ptrTagId->type->typeSort == typS) {sPtrTagId = ptrTagId; goto
								 foundStrunTag;}
          if (errAlrdDefId(tagName, NULL, StrunTag) != NULL) goto defStrunTag;
          tagName = NULL;}	/* stub */
        else if (infoDcl.s11._noNewTypeFl) {err0(StrunEnumDeclNotAlwd|Warn3|
						      PossErr); goto ignoreTag;}
        ptrTagId = enterSymTab(tagName);
defStrunTag:
        defStrun(ptrTagId, typS, tagName);  /* if unknown strunTag, declare
									it... */
foundStrunTag:
        type = ptrTagId->type;
        ptrTagId->Used = True;
        if (ptrTagId->NotVisible) errWN(TagNotVisi|Warn1|Rdbl, tagName);
ignoreTag:;}
      else {	/* there exist a strun-decl-list */
        if (firstId.idName==NULL  /* no identifier declared */
            && infoDcl.s11._attriba!=Typdf  /* not a  typedef */
            && firstId.headType==NULL	/* no type modifier seen */
            && !infoDcl.s11._memberFl	/* not a strun member */
            && !infoDcl.s11._noNewTypeFl) {
          /* Then declaration of a strun/enum tag alone */
          if (infoDcl.s11._attriba != NoAttrib) err0(UslAttrib|UWarn1|Rdbl);
          if (ignoreErr = False, !Found(SCOL)) errWFName(IdOrSColExptd,
		    lineAtBegDecl, fileAtBegDecl, NULL, errTxt[CmplSColE1],
			    (fileAtBegDecl == curFileName)? errTxt[At0] : NULL);
          return NULL;}}}
    if (sPtrTagId!=NULL && sPtrTagId->Undf) errWN(UndfndId|Warn1|Rdbl,
							      sPtrTagId->Nameb);
    {
      TdeclList dList = createDLElt(firstId, infoDcl, type, qual);

      return (infoDcl.s11._noNewTypeFl)? dList : decl3(dList, type, qual);}}
}

static TpcTypeElt nativeType(void)
{
  int codNatTyp = -1;
  bool longSeen = False, shortSeen = False;
#ifdef LONGLONG
  bool longlongSeen;
#endif

  signSpecSeen = False;
  do {
    if (curTok.tok >= USGND) {  /* 'unsigned'/'signed' */
      if (signSpecSeen) goto uslTypSpeL;
      if (shortSeen || longSeen || codNatTyp>=0) err0(AdjectvFrst|Warn1|Rdbl);
      signSpecSeen = True;
      if (curTok.tok == SGND) signSpecSeen |= (bool) SIGN_BIT;
      goto correctL;}
    else if (curTok.tok==SHORT || curTok.tok==LONG) {
      if (shortSeen || longSeen) goto uslTypSpeL;
      if (codNatTyp >= 0) err0(AdjectvFrst|Warn1|Rdbl);
      if (curTok.tok == SHORT) {shortSeen = True; goto correctL;}
      longSeen = True;
      GetNxtTok();
#ifdef LONGLONG
      if (longlongSeen = (curTok.tok == LONG)) GetNxtTok();
#endif
      continue;}
    if (codNatTyp < 0) {codNatTyp = curTok.tok - BNatTyp; goto correctL;}
uslTypSpeL:
    err0(UslTypSpe);
correctL:
    GetNxtTok();
  } while (InsideInterval(curTok.tok, BNatTyp, SGND));
  if (shortSeen) {
    if (codNatTyp<0 || codNatTyp==IntDpl) codNatTyp = ShortDpl;
    else err0(UslTypSpe);}
  else if (longSeen) {
    if (codNatTyp<0 || codNatTyp==IntDpl) codNatTyp =
#ifdef LONGLONG
		(longlongSeen)? LLongDpl :
#endif
					   LongDpl;
    else if (codNatTyp == DoubleDpl) codNatTyp = LongDblDpl;
    else err0(UslTypSpe);}
  if (signSpecSeen) {
    if (codNatTyp < 0) {err0(BadIntgrlType|Warn2|PossErr); codNatTyp = IntDpl;}
    if (InsideInterval(codNatTyp, SByteDpl, LLongDpl)) {
      if ((int)signSpecSeen >= 0) codNatTyp += DeltaTyp;}
    else err0(UslTypSpe);}
  else if (codNatTyp == SByteDpl) codNatTyp = CharDpl;
  return &natTyp[codNatTyp];
}

static void defStrun(TsemanElt *ptrTagId, TtypeSort typS, Tname tagName)
{
  TpTypeElt newElt;
  DefSem(notDefndStrunTag, StrunTag, False /*defnd*/);

  ptrTagId->type = newElt = allocTypeEltID(typS,NoQualif);
  newElt->Shared = True;   /* the tag is the only owner of this type element */
  newElt->TagId = ptrTagId;  /* remember tag */
  newElt->Algn = Alig3;  /* *doIt* compute alignment from members */
  /* newElt->MemberList = NULL; done by initialization */ /* incomplete type */
  ptrTagId->infoS = notDefndStrunTag;
  if (insideHdrFile) ptrTagId->Attribb = Extrn;
  ptrTagId->ListAlwdFiles = NULL;  /* a priori, not private */
  ptrTagId->Nameb = createTagName(tagName);  /* remember nameString of strun */
  ptrTagId->defLineNb = lineNb;	   	/* record              */
  ptrTagId->defFileName = curFileName;  /*        birth place. */
}

static TsemanElt *enterEnumTagName(Tname tagName, TinfoSeman sem)
{
  TsemanElt *ptrTagId;
  TpTypeElt newElt;

  ptrTagId = enterSymTab(tagName);  /* named enum or anonymous stub (for
						    later automatic freeing). */
  if (ptrTagId == NULL) {  /* name already seen in this block */
    ptrTagId = searchSymTab(tagName);
    if (ptrTagId->Kind==EnumTag && !ptrTagId->Defnd) {ptrTagId->infoS = sem
							     ; return ptrTagId;}
    if (errAlrdDefId(tagName, NULL, EnumTag) == NULL) ptrTagId = enterSymTab(
						   tagName = NULL);}  /* stub */
  ptrTagId->infoS = sem;
  if (insideHdrFile) ptrTagId->Attribb = Extrn;
  ptrTagId->ListAlwdFiles  = NULL;  /* a priori, not private */
  ptrTagId->defLineNb = lineNb;		/* record              */
  ptrTagId->defFileName = curFileName;	/*        birth place. */
  ptrTagId->Nameb = createTagName(tagName);  /* remember nameString of enum */
  ptrTagId->type = newElt = allocTypeEltID(Enum, NoQualif);
  newElt->TagId = ptrTagId;  /* unique value for each enum */
  newElt->Shared = True;  /* the tag is the only owner of this type element */ 
  newElt->size = IntSiz;
  newElt->Algn = Alig0;  /* because standard says enum representation can be
								 char<->long. */
  return ptrTagId;
}

static TcreatType declId(void)
/* if no identifier declared, 'idName' field == NULL */
{
  TpcTypeElt pBefType = NULL, pEndBefType;
  TpTypeElt newElt;
  TcreatType curCreat;
  bool leftParenSeen;

  while (Found(STAR)) {		/* create 'before' part of type */
    newElt = allocTypeEltID(Ptr, typeQualif());
    newElt->size = PtrSiz;
    newElt->BndType = (IsDP(INDEXTYPE))? getINDEXTYPEtype() :
				(moreIndexTypeChk)? &defaultIndexTypeElt : NULL;
    if (pBefType == NULL) pEndBefType = newElt;
    newElt->NextTE = pBefType;
    pBefType = newElt;}
  leftParenSeen = False;
  if (Found(LPAR)) {
    if ((curTok.tok == IDENT)
        ? curTok.PtrSem!=NULL && curTok.PtrSem->Kind==Type
        : curTok.tok!=STAR && curTok.tok!=LPAR) {
      curCreat.idName = NULL;
      curCreat.headType = NULL;
      leftParenSeen = True;}
    else {curCreat = declId(); if (! Found(RPAR)) errMsngRPar();}}
  else {
    if (curTok.tok == IDENT) {
      curCreat.idName = storeName(curTok.IdName, ObjectSpace);
      curCreat.hCode = curTok.Hcod;
      GetNxtTok();}
    else curCreat.idName = NULL;
    curCreat.headType = NULL;}
  for (;;) {
    if (leftParenSeen || Found(LPAR)) {	/* function declarator */
#ifdef __dcc
      volatile
#endif
	       TtypeSort sortFct = Fct;
      volatile TdeclList parList = NULL;

      mainFl = curCreat.idName!=NULL && isSameName(curCreat.hCode, curCreat.
					  idName, MainHCode, (Tname)"\4\0main");
      {
        volatile TdeclList endList;
        jmp_buf localJmpBuf, *savErrRet = curErrRet;
        volatile bool firstTurn, resulPtrSeen, sizeofBlSeen;

        if (curTok.tok!=RPAR && curTok.tok!=LBRA) {  /* not empty parameter list (LBRA
		   checked just to forgive the sinner that forgets the RPAR). */
          curErrRet = &localJmpBuf /*~ LocalAdr */;
          firstTurn = True;
          resulPtrSeen = sizeofBlSeen = False;
          if (setjmp(*curErrRet) != 0) skipTok(zCommaRParSCol);
          while (firstTurn || Found(COMMA)) {
            TdeclList newPar;
            Tattrib attrb;

            ignoreErr = False;
            if (Found(ELLIP)) {
              if (parList == NULL) err0(AtLeastOnePar);
              else {
                bool typeIsOK = False;

                if (   chkPortbl
                    && !endList->NotUsedFl
                    && (   endList->type!=NULL
                        && (   IsTypeSort(endList->type, Byte|UByte|Short|
								   UShort|Float)
                            || IsChar(endList->type)
                            || IsArrFct(endList->type))
                        || (typeIsOK = True, endList->Attriba==Reg))) errWT(
			BadLastPar | UWarn3, (typeIsOK)? NULL : endList->type);}
              sortFct = VFct;
              break;}
            firstTurn = False;
            if ((attrb = attrib())!=NoAttrib && attrb!=Reg) {
              err0(OnlyRegAttrib);			
              attrb = NoAttrib;}
            noNewTypeInfo.s11._attriba = attrb;
            noNewTypeInfo.s11._prioToCast = False;
            newPar = decl1(noNewTypeInfo);
            if (attrb == NoAttrib) newPar->Attriba = Auto;
            if (newPar->type!=NULL && IsFct(newPar->type)) errWNTT(
			     PtrOnFctExptd, newPar->idName, newPar->type, NULL);
            if (parList == NULL) {  /* first parameter */
              if (newPar->type!=NULL && newPar->type->typeSort==Void) {
                if (newPar->idName!=NULL || attrb!=NoAttrib || curTok.tok!=
						       RPAR) err0(VoidNotAlone);
                (void)freeDeclElt(newPar);}
              else parList = newPar;}
            else {
              if (newPar->type!=NULL && newPar->type->typeSort==Void) errWN(
						   VoidNotAlwd, newPar->idName);
              endList->cdr = newPar;}
            endList = newPar;
            {
              TpcTypeElt parType = newPar->type;
              bool sizeOKSeen = False;

              newPar->SizeofBlFl = False;  /* other flags already off */
              for (; curTok.tok == DPTOK; GetNxtTok()) {
                Tdprag curDP = (Tdprag)curTok.Val;

                switch (curDP) {
                  TparQal paramQal;

                  case GENERIC:  paramQal = GenericV; goto commonParQalL;
                  case MAYMODIFY: {
                      TresulTstPtd w;

                      if ((w = tstPtd(parType, False)) & NOTALLCONST &&
			  !hereOrAloneInMac()) continue;  /* ignore d-pragma
			   in this case if function declaration inside macro. */
                      if (w & (NOTPTR | NOTALLCONST)) break;
                      newPar->MayModifFl = True;
                      continue;}
                  case NOTUSED:
                    if (newPar->ResulPtrFl) break;
                    newPar->NotUsedFl = True;
                    continue;
                  case RESULPTR: 
                    if (parType!=NULL && !IsPtrArr(parType) || resulPtrSeen ||
						       newPar->NotUsedFl) break;
                    newPar->ResulPtrFl = True;
                    /*~NoBreak*/
                  case RESULTYP: paramQal = ResulTypV; goto commonParQalL;
                  case SIZEOFBL:
                    if (parType!=NULL && !(parType->typeSort & Who) ||
				     sizeofBlSeen && !newPar->SizeofBlFl) break;
                    sizeofBlSeen = True;
                    newPar->SizeofBlFl = True;
                    continue;
                  case SIZEOK:
                    sizeOKSeen = True;
                    if (parType!=NULL && (!IsStrun(parType) || BaseStrunType(
			   parType)->size<=CoefMaxParStrunSize*sizeof(void *))
							      ) errUslDP(curDP);
                    continue;
                  case UTILITY:
                    if (parType!=NULL && !isRepreType(parType)) break;
                    paramQal = UtilityV;
commonParQalL:
                    if (newPar->ParQal == NoParQal) newPar->ParQal = paramQal;
                    if (newPar->ParQal != paramQal) break;
                    continue;
                  default: goto exitLoopL;}
                errIlgDP(curDP);}
exitLoopL:
              if (chkNmdTypParFl && !sysAdjHdrFile && newPar->ParQal==NoParQal
		  && isRepreType(parType) && !mainFl) errWNT(ParRepreType |
							  Warn1, NULL, parType);
              if (newPar->ResulPtrFl) resulPtrSeen = True;
              if (!sizeOKSeen && parType!=NULL && IsStrun(parType) &&
			  BaseStrunType(parType)->size>CoefMaxParStrunSize*
					     sizeof(void *) && !sysAdjHdrFile) {
                Tverbo savVerbo = verbose;

                verbose = FullVerbo;
                errWT(BigStrun | Warn1, parType);
                verbose = savVerbo;}}}}
        else if (chkEmptParList && !mainFl) err0(MsngVoid | Warn1);
        curErrRet = savErrRet;
      }
      newElt = allocTypeEltID(sortFct, NoQualif); /* Fct or VFct if variadic */
      newElt->ParamList = parList;
      if (! Found(RPAR)) errWS((parList == NULL)? Msng :CommaOrXExptd, ")");
      leftParenSeen = False;}
    else if (Found(LSBR)) {	/* array declarator */
      size_t limArr;

      limArr = (curTok.tok!=RSBR && !IsDP(INDEXTYPE))
                ? (correctExprN(NoFreeExpType, WhoEnumBool, True, "[]", False))
                  ? (cExp.Sval==0 || cExp.Sval<0 && cExp.type->typeSort &
									 SigWho)
                    ? (errWS((cExp.ErrEvl || sysAdjHdrFile && cExp.Sval==0)?
			NoErrMsg : IlgArraySize, longToS(cExp.Sval)), ArrLimErr)
                    : (size_t)cExp.Uval
                  : ArrLimErr
                : (cExp.type = &defaultIndexTypeElt,
						 0);  /* if no size specified */
      newElt = allocTypeEltID(Array, NoQualif);
      newElt->Lim = limArr;
      if (limArr != 0) {
        newElt->size = 1U;  /* forbids computation of bound by
						    potential initialization. */
        if (chkArrBnd && cExp.LitCst) {
          Tname nameToShow = curCreat.idName;
          TpcTypeElt w1 = curCreat.headType;

          while (w1 != NULL) {
            if (w1->typeSort != Array) {nameToShow = NULL; break;}
            w1 = w1->NextTE;}
          errWN((cExp.LitCstOutsMac)? BndShdBeNamed | Warn1 :
				   NumCstShdBeNamed1|Warn1|Rdbl , nameToShow);}}
      if (IsDP(INDEXTYPE)) {
        TpcTypeElt w = getINDEXTYPEtype();

        if (compatType(w ,cExp.type, VerifCastF)) errUslDP(INDEXTYPE);
        FreeExpType(cExp);
        newElt->BndType = w;}
      else newElt->BndType = (cExp.CstImpsd)
                               ? (FreeExpType(cExp), &defaultIndexTypeElt)
                               : cExp.type;
      if (newElt->BndType!=NULL && newElt->BndType->NoOwner) ((ModifType)
					      newElt->BndType)->NoOwner = False;
      if (! Found(RSBR)) errWS(Msng, "]");}
    else break;  /* exit "for(;;)" */
    if (curCreat.headType == NULL) curCreat.headType = newElt;
    else ((ModifType)curCreat.tailType)->NextTE = newElt;
    curCreat.tailType = newElt;}
  /* splice eventual front end of type ('pointer' part) */
  if (pBefType != NULL) {
    if (curCreat.headType == NULL) curCreat.headType = pBefType;
    else ((ModifType)curCreat.tailType)->NextTE = pBefType;
    curCreat.tailType = pEndBefType;}
  return curCreat;
}

static TdeclList decl3(TdeclList x, TpcTypeElt baseType, Tqualif qual)
{
  TdeclList endDL;
  InfoDcl(localIDL, (bool)(0-0) /*memberFl*/, False /*declFl*/, False
							       /*noNewTypeFl*/);

  manageFctDPrags(x);
  if (curTok.tok == LBRA) {defFunc(x); return NULL;}  /* function definition */
  msngAttribFl = False;  /* this flag to prevent several instances of same
								       error. */
  endDL = x;  /* end of declaration list = beginning as of now */
  localIDL.s11._attriba = x->Attriba;
  localIDL.s11._memberFl = x->MemberFl;
  for (;;) {
    if (nestLvl!=0 && endDL->Attriba==NoAttrib && (endDL->type==NULL ||
				    !IsFct(endDL->type))) endDL->Attriba = Auto;
    if (x->DeclFl) declObj(endDL);  /* if object to be declared (to be done
	       immediatly, because of case "struct _s a ={..., &a, ...}..."). */
    else {
      initOrSizFld(endDL, NULL);
      if (x->InitFl) err0(MemberCantBeInit);}
    if (! Found(COMMA)) break;
    endDL->cdr = createDLElt(declId(), localIDL, baseType, qual);  /* chain   */
    endDL = endDL->cdr;				     /*  current declaration. */
    manageFctDPrags(endDL);}
  return x;
}

static void defFunc(TdeclList x)
{
  TpcTypeElt defFctTyp, curFctRetTyp;
  Tname fctName;

  checkIndent();
  /* Search if type = (V)Fct; if not, try to find one in type chain */
  if ((defFctTyp = x->type) != NULL)
    do {
      if (IsFct(defFctTyp)) break;
    } while ((defFctTyp = freeTypeElt(defFctTyp)) != NULL);
  if (defFctTyp != x->type) err0(NotAFct);
  if (defFctTyp != NULL) {	/* function type found */
    TsemanElt *ptrIdFct;
    TdeclList defParList;
    Tattrib fctAttrib;
    bool keepDecl = False;  /* try hard not to keep declaration coordinates, to
			get function definition coordinates (otherwise, problem
			to either spot declaration coordinates (eg. if bad type)
			or definition coordinates (eg. in case of double
			definition). */

    if (defFctTyp->Shared) errWN(FctDefViaTpdf, x->idName);
    if ((fctAttrib = x->Attriba) == Extrn) fctAttrib = NoAttrib;
    else if (fctAttrib==NoAttrib || sysHdrFile && fctAttrib==Stati) fctAttrib
									= Extrn;
    if (insideHdrFile) errWS(NoDefInHdrFile|Warn1|Rdbl, NULL);
    if (nestLvl != 0) err0(EmbdFctNotAlwd);
    if ((fctName = x->idName) == NULL) err0(MsngFctName);
    if ((curFctRetTyp = NxtTypElt(defFctTyp))!=NULL && curFctRetTyp->
	     typeSort!=Void && !IsArrFct(curFctRetTyp)) (void)sizeOfTypeD(
					   curFctRetTyp, IncplRetType, fctName);
    if (fctName!=NULL && (ptrIdFct = searchSymTabHC(fctName, x->hCode))!=
		      NULL) {  /* already existing identifier; is it correct? */
      if (ptrIdFct->type != NULL) {
        if (IsFct(ptrIdFct->type) && !ptrIdFct->Defnd) {
          /* Correct: now, check concordance */
          const TpcTypeElt declFctTyp = ptrIdFct->type, declRetType =
							  NxtTypElt(declFctTyp);
          TdeclList declParList;

          if (ptrIdFct->Attribb != fctAttrib) errId1(IncptblAttrib|Warn2|
			    PossErr, ptrIdFct, (ptrIdFct->Attribb == Extrn)?
						    errTxt[Empty] : "'static'");
          if (declFctTyp->typeSort != defFctTyp->typeSort) {errId1(VariNotVari,
					      ptrIdFct, NULL); keepDecl = True;}
          if (! CompatType(declRetType, curFctRetTyp, StrictChk)) {
            errId2((compatType(curFctRetTyp, declRetType, CStrictChk))?
		 NotSameType|Warn2|PossErr : NotSameType, ptrIdFct, typeToS1(
					  curFctRetTyp), typeToS2(declRetType));
            keepDecl = True;}
          for (declParList = declFctTyp->ParamList,
					      defParList = defFctTyp->ParamList;
               declParList!=NULL && defParList!=NULL; 
                 declParList = declParList->cdr, defParList = defParList->cdr) {
            if (defParList->idName!=NULL && declParList->idName!=NULL &&
		memcmp(declParList->idName, defParList->idName, FullLgt(
						      defParList->idName))!=0) {
              TnameBuf buf;

              bufNameToS(defParList->idName, buf);
              errId1(ParNamesNotEq|Warn1|Rdbl, ptrIdFct, buf);}
            if (! CompatType(declParList->type, defParList->type, StrictChk)) {
              TpcTypeElt declParType = declParList->type;

              errId((compatType(declParType, defParList->type, CStrictChk))?
		ParTypesNotEq|Warn2|PossErr : ParTypesNotEq, ptrIdFct,
		    defParList->idName, typeToS1(declParType), typeToS2(
							     defParList->type));
              declParList->type = defParList->type;/* permute types, so that  */
              defParList->type = declParType;}	   /* declaration type stays. */
            if (declParList->ParQal!=defParList->ParQal || declParList->
		MayModifFl!=defParList->MayModifFl || declParList->ResulPtrFl
						     !=defParList->ResulPtrFl) {
              errId1(NonCoheDPInFct | Warn2, ptrIdFct, NULL);
              defParList->ParQal = declParList->ParQal;
              defParList->MayModifFl = declParList->MayModifFl;
              defParList->ResulPtrFl = declParList->ResulPtrFl;}}
          if ((defParList!=NULL || declParList!=NULL) && (!sysHdrFile ||
		declFctTyp->ParamList!=NULL && defFctTyp->ParamList!=NULL) /*
		in system header files, empty parameter list => no check ? */) {
            errId1(NotSameNbOfPar, ptrIdFct, NULL);
            keepDecl = True;}
          if (defFctTyp->PvNr!=declFctTyp->PvNr || defFctTyp->Generiq!=
							  declFctTyp->Generiq) {
            errId1(NonCoheDPInFct | Warn2, ptrIdFct, NULL);
            ((ModifType)defFctTyp)->PvNr = declFctTyp->PvNr;
            ((ModifType)defFctTyp)->Generiq = declFctTyp->Generiq;}
          if (fctAttrib == Extrn) checkWrngHdrFile(ptrIdFct);
          ptrIdFct->Defnd = True;
          if (! keepDecl) {
            freeTypeChain(declFctTyp);
            goto commonL;}}
        else (void)errAlrdDefId(fctName, defFctTyp, Obj);
        ptrIdFct = enterSymTab(NULL);}  /* stub (to manage correctly following
							      function body). */
      if (! mainFl) fctAttrib = Stati;}
    else {  /* yet undeclared identifier: declare it as a function */
      if (x->Attriba > Stati) {errWN(IlgAttribForFct, fctName); fctAttrib =
									 Stati;}
      ptrIdFct = enterSymTabHC(fctName, x->hCode);}
    {
      DefSem1(defndObj, Obj, True /*defnd*/, False /*used*/, True /*initlz*/);

      ptrIdFct->infoS = defndObj;}
    ptrIdFct->Nameb = fctName;
    if (sysAdjHdrFile) ptrIdFct->SysFct = True;
    if ((ptrIdFct->Attribb = fctAttrib)==Extrn && !mainFl && !insideHdrFile &&
					      nestLvl==0) errMsngStati(fctName);
commonL:
    ptrIdFct->defLineNb = lineNb;		/* record              */
    ptrIdFct->defFileName = curFileName;	/*        birth place. */
    ptrIdFct->type = defFctTyp;
    /* Check for 'main' special treatment */
    if (mainFl) {  /* verify that legal form */
      register const TdeclElt *declParList = ptrIdFct->type->ParamList;

      if (fctAttrib != Extrn) err0(BadAttribForMain);
      if (curFctRetTyp!=NULL && curFctRetTyp->typeSort!=Int) err0(
							     BadRetTypeForMain);
      if (declParList != NULL) {
        if (declParList->type!=NULL && !(declParList->type->typeSort & WhoEnum)
		) errWNT(BadParForMain, declParList->idName, declParList->type);
        if ((declParList = declParList->cdr)!=NULL && declParList->type!=NULL) {
          scndMainParTypeElt.BndType = declParList->type->BndType;  /* for
					 no false error due to type of bound. */
          if (! compatType(declParList->type, &scndMainParTypeElt, FctCall)
		) errWNT(BadParForMain, declParList->idName, declParList->type);
          if (declParList->cdr!=NULL && declParList->cdr->cdr!=NULL) err0(
							  TooManyParForMain);}}}
    /* Enter parameters into symbol table */
    enterBlock();	/* so parameters are defined at function body level */
    for (defParList = defFctTyp->ParamList; defParList != NULL; defParList =
							     defParList->cdr) {
      TsemanElt *ptrId;
      TpcTypeElt curType = defParList->type;

      if (defParList->idName == NULL) err0(ParMustBeNamed);
      if (curType!=NULL && !IsArrFct(curType)) (void)sizeOfTypeD(curType,
						 IncplType, defParList->idName);
      if ((ptrId = enterSymTabHC(defParList->idName, defParList->hCode)) ==
				   NULL) errWN(SameParName, defParList->idName);
      else {
        DefSem1(defndPar, Param, True /*defnd*/, False /*used*/,
							       True /*initlz*/);
        DefSem1(notUsedPar, Param, False  /*defnd*/, True /*used*/, True
	       /*initlz*/);  /* defnd = False for 'NotUsdPar' error detection */

#ifdef _AIX
        if (defParList->NotUsedFl) ptrId->infoS = notUsedPar;
        else ptrId->infoS = defndPar;
#else
        ptrId->infoS = (defParList->NotUsedFl)? notUsedPar : defndPar;
#endif
        if (defParList->MayModifFl) ptrId->MayModif = True;
        ptrId->type = curType;
        ptrId->Attribb = (curType!=NULL && IsArr(curType))? NoAttrib
			/* so that no LocalAdr d-pragma needed for &par[...] */
				     : defParList->Attriba;  /* auto/register */
/*        if (curType != NULL)
          if (curType->typeSort==Bool) ptrId->NotPureBoo = True;
	  * if so done, warning in 'constPtd()', on 'resultIfNULL' parameter *
          else */
        ptrId->defLineNb = lineNb;		/* record              */
        ptrId->defFileName = curFileName;	/*        birth place. */
        ptrId->Nameb = defParList->idName;}}}
  else {fctName = NULL; enterBlock();}
  (void)freeDeclElt(x);
  {
    Tname oldCurFctName = curFctName;  /* necessary because of possible
					    (erroneously) embedded functions. */

    curFctName = fctName;
    enterFctBody(defFctTyp);
    curFctName = oldCurFctName;}
}

static void initOrSizFld(TdeclList x, TsemanElt *ptrId)
{
  if (Found(COLON)) nbBits(x);
  else {
    TpcTypeElt objType = x->type;

    if (x->idName == NULL) err0((x->MemberFl)
				? MsngMembName
				: (x->DeclFl && curTok.tok==SCOL)
				  ? MsngObjTypName|Warn2|PossErr
				  : MsngObjTypName);
    if (curTok.tok == ASGNOP) {
      TmacExpNb locMacExpndNb = curMacExpNb;

      if ((TkAsgn)curTok.Val != SimplAsgn) err0(SimplAsgnExptd);
      paramTxt = txtAsgnTok[(TkAsgn)curTok.Val];
      if (x->Attriba == Typdf) err0(CantInitTpdf);
      else if (objType!=NULL && IsFct(objType)) {err0(FctCantBeInit); objType =
									  NULL;}
      else {
        if (objType!=NULL && IsStrun(objType)) (void)sizeOfTypeD(objType,
							  IncplType, x->idName);
        x->InitFl = True;}
      GetNxtTok();  /* here for good error position */
      {
        bool cmplxInit = (curTok.tok==LBRA || curTok.tok==CSTST);

        limErroTypes = NULL;  /* forget previous erroneous types */
        pIdInit = ptrId;  /* for managePointers()/modifPtdVal() */
        init((ModifType)objType, x->Attriba < Extrn, chkNumCst, locMacExpndNb);
        if (x->Attriba>=Auto && objType!=NULL && IsCmpsd(objType) && cmplxInit
		  && !FoundDP(DYNINIT)) err0(SlowingInit|Warn1|Rdbl|PossErr);}}}
}

static void init(TpTypeElt objType, bool cstExp, bool chkIntCst,TmacExpNb macNb)
{
  bool msngBra, simulLBra = False;

  for (;;) {  /* to avoid a back branch (see 'continue') */
    msngBra = alrdAnalzdExp;
    if (curTok.tok==LBRA || simulLBra) {
      TtypeSort ts = (objType == NULL)? Void : objType->typeSort;

      if (ts == Array) {
        size_t oldCurIArrayIndex = curInitArrayIndex;
        TpcTypeElt oldCurIArrayBndType = curInitArrayBndType;
        TpTypeElt eltType = (ModifType)NxtTypElt(objType);

        if (! msngBra) GetNxtTok();
        curInitArrayIndex = 0;
        curInitArrayBndType = objType->BndType;
        do {
          init(eltType, True, False, 0);
          curInitArrayIndex++;
        } while (!(msngBra && curInitArrayIndex==objType->Lim) &&
					   curTok.tok==COMMA && NxtTok()!=RBRA);
        if (objType->size == 0) {    /* if size not specified... */
          if (curInitArrayIndex > objType->Lim) objType->Lim =
	       curInitArrayIndex;}  /* then size of array defined by length
			    of longest initializer list (dimensionality > 1). */
        else if (curInitArrayIndex > objType->Lim) err0(TooManyIniz);
        curInitArrayIndex = oldCurIArrayIndex;
        curInitArrayBndType = oldCurIArrayBndType;}
      else if (IsStrunSort(ts)) {
        TdeclList oldCurIMember = curInitMember;
        TmacExpNb locMacExpNb = curMacExpNb;
        bool locLitCst = False;

        if (! msngBra) GetNxtTok();
        if (objType->TagId->ListAlwdFiles  != NULL) checkPrivVisible(objType);
        curInitMember = BaseStrunType(objType)->MemberList;
        while (curInitMember!=NULL && curInitMember->FldFl && curInitMember->
	   idName==NULL) curInitMember = curInitMember->cdr;  /* skip possible
							     initial padding. */
        while (curInitMember != NULL) {
          bool curTokNotLBra = (curTok.tok != LBRA);

          init((ModifType)curInitMember->type, True, chkIntCst &&
						   !curTokNotLBra, locMacExpNb);
          if (curTokNotLBra && cExp.LitCst) locLitCst = chkIntCst;
          do {curInitMember = curInitMember->cdr;} while (curInitMember!=NULL
		&& curInitMember->FldFl && curInitMember->idName==NULL);  /*
								skip padding. */
          if (ts == Union) curInitMember = NULL;
          if (msngBra && curInitMember==NULL || curTok.tok!=COMMA ||
					       NxtTok()==RBRA) goto checkRBraL;}
        err0(TooManyIniz);
        skipTok(zRbraSCol);
checkRBraL:
        curInitMember = oldCurIMember;
        if (locLitCst && (curMacExpNb==macNb || curMacExpNb!=locMacExpNb)) err0(
						     NotNamedStrunCst | Warn1);}
      else {
        err0(TooManyBraLvl|Warn1|Rdbl);
        GetNxtTok();
        init(objType, cstExp, chkIntCst, macNb);}
      if (!msngBra && !Found(RBRA)) {
        errWS((IsCmpsdSort(ts))? CommaOrXExptd : Exptd, "}");
        cleverSkipTok();}}
    else {
      if (correctExprN(objType, Void, cstExp, paramTxt, chkIntCst)) {
        if (objType!=NULL && IsArr(objType)) {
          if (! cExp.Revlbl) err0(CstExpExptd);
          else {  /* Initialization of character array by string literal */
            size_t lgtStr = cExp.type->size;

            if (objType->size == 0) {  /* limit not specified */
              if (objType->Lim < lgtStr) objType->Lim = lgtStr;}
            else if (lgtStr - 1 > objType->Lim) /* trick! (if erroneous, objTyp
		 ->Lim = -1U => greater than any size) */  err0(TooManyIniz);}}}
      else if (alrdAnalzdExp) {  /* elided '{' ? */
        err0((pIdInit==NULL || objType == pIdInit->type)? MsngLBra :
							   MsngLBra|Warn1|Rdbl);
        simulLBra = True;
        continue;}}
    break;}
}

static void nbBits(TdeclList x)
{
  TpcTypeElt fldType;

  if (! x->MemberFl) err0(FldNotAlwd);
  if (! correctExprN(NULL, WhoEnum, True, ":", chkNumCst)) cExp.Uval = 0;
  /* *doIt* Portability (field wdth < 16 = min sizeof(int) ) */
  else if (cExp.Uval>IntSiz*CHAR_BITC || (x->idName!=NULL &&
			      cExp.Uval==0)) {err0(FldSizIncor); cExp.Uval = 0;}
  x->FldSize = (uint)cExp.Uval;
  x->FldFl = True;
  if ((fldType = x->type) != NULL) {
    if (chkPortbl) 
      if (! (fldType->typeSort & (UInt | Int | Bool))) errWT((fldType->typeSort
		        ==Enum && fldType->TagId!=NULL)? UnsuitFldType | Warn1 :
							UnsuitFldType, fldType);
      else if (x->idName!=NULL && cExp.Uval!=0 && fldType->typeSort==Int &&
	       fldType->SynthQualif!=Sgnd) errWT(IntBitField | UWarn2, fldType);
    if (fldType->Shared) x->type = allocTypeEltIC(fldType, NoQualif);  /* to be
						    able to set 'size' field. */
    ((ModifType)x->type)->size = 1;}  /* *doIt* size in bits */
}

static void declObj(TdeclList pDeclElt)
{
  TsemanElt *ptrId = NULL;
  TpcTypeElt objType = pDeclElt->type;
  Tattrib objAttrib = pDeclElt->Attriba;
  Tname objName;
  bool reDecl = False;
  Tstring declFile = curHdrFName;  /* even for 'extern's (wrongly) declared
				   in body file (=> no ExtObjNotDef warning). */

  /* Insert new declaration into symbol table */
  if ((objName = pDeclElt->idName) != NULL) { /* correct declar. of an object */
    if ((ptrId = enterSymTabHC(objName, pDeclElt->hCode)) == NULL) {  /* alrea-
						      dy declared identifier. */
      if (objAttrib != NoAttrib) {
        ptrId = searchSymTabHC(objName, pDeclElt->hCode);
        if (adjustFile) {
          if (objType==NULL || ((!IsFct(objType) || objAttrib!=Extrn) &&
	    objAttrib!=Typdf && errAlrdDefId(objName, objType, ptrId->Kind /*
		because of CantChgMnng */)==NULL)) goto freeObjTypeL;  /* not
				  typedef nor function profile to be amended. */
          if (objAttrib==Typdf && ptrId->Kind!=Type || objAttrib!=Typdf &&
		ptrId->type!=NULL && objType->typeSort!=ptrId->type->typeSort) {
            errWNTT(CantChgMnng, objName, ptrId->type, objType);
            goto freeObjTypeL;}
          if (ptrId->Kind==Type && ptrId->NamedType!=NULL) {
            reDecl = True;
            freeTypeChain(NxtTypElt(ptrId->NamedType));}} /* keep first typeElt,
						       to redirect NamedType. */
        else {
          bool sameFile = !insideHdrFile || ptrId->Kind!=Obj || StrEq(skipPath(
				  ptrId->DeclaringFile), skipPath(curHdrFName));

          if (objAttrib==Extrn && ptrId->Attribb==Extrn && !sameFile &&
		ptrId->DeclaringFile!=nonFileName) {  /* 'extern' declarations
			may be duplicated only once, in different header files,
			the last of which being the header file corresponding
			to the current compilation unit. */
            if (! isBodyHdrFile(curHdrFName)) {
              if (! isBodyHdrFile(ptrId->DeclaringFile)) goto redeclL;
              errWNSS(IncldAfter|Warn1|Rdbl, objName, ptrId->DeclaringFile,
								  curHdrFName);}
            errQalTyp1 = NULL;
            if (!CompatType(ptrId->type, objType, ExtDcl) || errQalTyp1!= NULL){
              Tverbo savVerbo = verbose;

              if (verbose < HalfVerbo) verbose = HalfVerbo;
              errId2((compatType(ptrId->type, objType, CStrChkExtDcl))?
			MoreStrngType|Warn2|PossErr : MoreStrngType, ptrId,
				       typeToS1(ptrId->type),typeToS2(objType));
              verbose = savVerbo;
              goto freeL;}
            if (CompatType(ptrId->type, objType, StrictChk)) goto freeL;}
				     /* keep previous declaration coordinates */
          else
redeclL:
            if ((ptrId->Attribb!=Extrn || objAttrib<Auto) && (errAlrdDefId(
		objName, objType, (objAttrib == Typdf)? Type : Obj)==NULL ||
								objType==NULL))
freeL:      {
              if (! sameFile) ptrId->DeclaringFile = nonFileName;  /* see below
									 why. */
              goto freeObjTypeL;}
          declFile = (! sameFile)? nonFileName : ptrId->DeclaringFile;}  /* if
			several declaring files, which one to jot ? =>
			impossible file name (-> no 'ExtObjNotDef' message). */
        freeTypeChain(ptrId->type);}}
    else {  /* new identifier, initialize it */
      DefSem(notDefndObj, Obj, False /*defnd*/);

      ptrId->infoS = notDefndObj;}
    if (objAttrib == Typdf) {
      if (isSameName(pDeclElt->hCode, objName, BoolHCode, BoolTName)) {
        if (chkBool) {
          if (objType!=NULL && objType->typeSort!=UInt) err0(IlgBoolDef|Warn1|
								       PossErr);
          pDeclElt->ParalTypeFl = False;
          objType = ptrId->NamedType = allocTypeEltIC(&boolTypeElt, (objType ==
					     NULL)? NoQualif : objType->Qualif);
          reDecl = True;}}
      else if (chkTypName && !sysAdjHdrFile) {
        char leadingChar = (char)*(objName + LgtHdrId);

        if (! (isupper(leadingChar) || leadingChar=='_')) errWN(UpCaseTypName|
							  Warn1|Rdbl, objName);}
      /* Create type chain that will be shared by all users of defined type */
      if (objType == NULL) ptrId->NamedType = NULL;
      else {
        TpTypeElt newElt;  /* typeElt for users of this typedef */

        newElt = (reDecl)
                  ? (ModifType)ptrId->NamedType /* reuse old typeElt, because
					      it may already be pointed upon. */
                  : allocTypeElt();
        *newElt = *objType;
        newElt->Shared = True; newElt->NoFreeDpdt = True; newElt->StopFreeing
									 = True;
        if (sysAdjHdrFile) newElt->SysTpdf = True;
        else {
          if (! pDeclElt->ParalTypeFl) goto exitLoopL;
          newElt->ParalTyp = True;}
        newElt->NxtIsTypId = True;
        newElt->TypeId = ptrId;
        newElt->RootTyp = False;
        for (; curTok.tok == DPTOK; GetNxtTok()) {
          Tdprag curDP = (Tdprag)curTok.Val;

          switch (curDP) {
            case LITCST:
              newElt->LitCsta = True;
              break;
            case ROOTTYP:
              newElt->RootTyp = True;
              break;
            default: goto exitLoopL;}}
exitLoopL:
        /* else description bits stay the same (qualified variant) */
        ptrId->NamedType = newElt;}
      {
        DefSem(defndType, Type, True /*defnd*/);
        DefSem1(defndUsedType, Type, True /*defnd*/, True /*used*/, False
								    /*initlz*/);

#ifdef _AIX
        if (insideHdrFile) ptrId->infoS = defndUsedType; /* for no
						      'UnusedTypeId' message. */
        else ptrId->infoS = defndType;}
#else
        ptrId->infoS = (insideHdrFile)? defndUsedType /* for no 'UnusedTypeId'
							message */ : defndType;}
#endif
      if (insideHdrInHdr) ptrId->DeclInInHdr = True;}
    else {		/* not type definition */
      if (objAttrib==NoAttrib && insideHdrFile && !msngAttribFl) {
        errWS(NoDefInHdrFile|Warn2|Rdbl, errTxt[MsngExtTpdf]);
        msngAttribFl = True;}
      /* Verify constraints on declaration/definition, taking specified
         attribute and current block level into account. */
      if (objType!=NULL && IsFct(objType)) {  /* function */
        if (objAttrib == NoAttrib) {
          if (ptrId==NULL && (ptrId = errAlrdDefId(objName, objType, Obj)) ==
							NULL) goto freeObjTypeL;
          if (!insideHdrFile && !msngAttribFl) {
            errWN((nestLvl == 0)? MsngFctAttrib|Warn1|Rdbl :
					    ShdBeInHdrFile|Warn1|Rdbl, objName);
            msngAttribFl = True;}
          objAttrib = (nestLvl==0 && !insideHdrFile)? Stati : Extrn;}
        if (objAttrib == StatiL) errWN(OnlyExtrn, objName);
        else if (objAttrib > Extrn) errWN(IlgAttrib, objName);
        ptrId->Initlz = True;
        if (sysAdjHdrFile) ptrId->SysFct = True;
        if (objType->NextTE == &boolCstTypeElt) ptrId->NotPureBoo = True;}
				/* for pseudo-boolean functions ('feof' etc.);
						   'generic' bit already set. */
      else {		/* object not function */
        if (objAttrib == Extrn) {
/*          if (objType!=NULL && objType->typeSort==Bool) ptrId->NotPureBoo =
			  True;*/}  /* just in case True in other modules ... */
        else {
          if (objAttrib == NoAttrib) {	/* external definition
						    (necessarily at level 0). */
            if (ptrId == NULL) {/* identifier already seen (e.g, declaration) */
              ptrId = searchSymTabHC(objName, pDeclElt->hCode);
              if ((ptrId->Kind!=Obj || ptrId->Defnd) && errAlrdDefId(objName,
				       objType, Obj) == NULL) goto freeObjTypeL;
              checkWrngHdrFile(ptrId);
              if (! CompatType(ptrId->type, objType, StrictChkLsBnd)) {
                errId2((compatType(ptrId->type, objType, CStrChkExtDcl))?
			NotSameType|Warn2|PossErr : NotSameType, ptrId,
				      typeToS1(objType), typeToS2(ptrId->type));
                ptrId->Defnd = True; goto freeObjTypeL;}
              freeTypeChain(ptrId->type);}  /* to be able to replace int[] by
							 int[5], for example. */
            else if (!insideHdrFile && !msngAttribFl) {errMsngStati(objName)
							 ; msngAttribFl = True;}
            objAttrib = Extrn;}
          else if (objAttrib!=Stati && nestLvl==0 || objAttrib==Reg && objType
			    !=NULL && IsFct(objType)) errWN(IlgAttrib, objName);
          ptrId->Defnd = True;}}  /* defined */
      ptrId->DeclaringFile = declFile;
      if ((ptrId->Attribb = objAttrib)==Extrn && insideHdrInHdr) ptrId->
							     DeclInInHdr = True;
      if (insideHdrFile && objAttrib==Stati) ptrId->Used = True;}  /* to prevent
								     warning. */
    ptrId->type = pDeclElt->type;
    ptrId->defLineNb = lineNb;		/* record              */
    ptrId->defFileName = curFileName;	/*        birth place. */
    ptrId->Nameb = objName;
    initOrSizFld(pDeclElt, ptrId);
    ptrId->type = objType = pDeclElt->type;}  /* but ptrId->type must also be
	     set before calling 'initOrSizeFld', because of case "int i = i". */
  else
freeObjTypeL:
  {
    initOrSizFld(pDeclElt, NULL);  /* before pDeclElt->type freeing, to get
	      more interesting messages (for example, no 'NotStrunInit' msg). */
    freeTypeChain(pDeclElt->type);
    objType = NULL;}
  if (pDeclElt->InitFl) {
    computeSize((ModifType)objType);
    if (ptrId != NULL) {
      if (cExp.LclAdr) ptrId->LclAd = True;  /* does also NotPureBool */
      ptrId->Initlz = True;}
    if (pDeclElt->Attriba /* 'objAttrib' may have been modified */ == Extrn
					  ) errWN(IlgInit|Warn1|Rdbl, objName);}
  if (objType==NULL || !IsFct(objType)) {
    if (FoundDP(NOTUSED) && ptrId!=NULL) {ptrId->Defnd = False; ptrId->Used =
									  True;}
    if (objType!=NULL && pDeclElt->Attriba!=Typdf && !(pDeclElt->Attriba==Extrn
	&& IsArr(objType))) (void)sizeOfTypeD(objType, (pDeclElt->Attriba ==
			 Extrn)? IncplType|Warn2|PossErr : IncplType, objName);}
}

/******************************************************************************/
/*			           UTILITIES				      */
/******************************************************************************/

static AllocXElt(allocDeclElt, TdeclElt, ctrDE, resul->cdr = NULL;)  /* setting
	       'cdr' field to NULL makes element a list (of one element... ). */

static AllocXElt(allocTagListElt, TtagVisi, ctrTLE, resul->preced = NULL;)

static AllocXElt(allocTypeElt, TtypeElt, ctrTE, ;)

TpTypeElt allocTypeEltIC(TpcTypeElt x, Tqualif y)
/* New type element initialized by (amended) copy of x */
{
  TpTypeElt resul;

  resul = allocTypeElt();
  *resul = *x;
  resul->Qualif |= y;
  resul->Shared = False;
  resul->NoFreeDpdt = True;  /* because of shallow copy */
  resul->StopFreeing = True;  /* a priori, only the new element is freeable
					     (because of usual shallow copy). */
  return resul;
}

TpTypeElt allocTypeEltID(TtypeSort x, Tqualif y)
/* New type element initialized by default values */
{
  TpTypeElt resul;

  resul = allocTypeElt();
  *resul = valInitTypeElt;
  resul->typeSort = x;
  resul->Qualif = y;
  return resul;
}

bool checkFrstMember(TpcTypeElt x, TpcTypeElt y)
{
  const TdeclElt *member;

  for (member = BaseStrunType(x)->MemberList; member != NULL; member = member->
									  cdr) {
    TpcTypeElt memberType;

    for (memberType = member->type;; memberType = Parent(memberType)) {
      if (memberType==NULL || memberType==y) return True;
      if (!memberType->NxtIsTypId || memberType->RootTyp && heedRootType)break;}
    if (IsStrun(memberType) && checkFrstMember(memberType, y)) return True;
    if (x->typeSort == Struct) break;}  /* for unions, keep on */
  return False;
}

void checkPrivVisible(TpcTypeElt type)
{
  const TsemanElt *pTag = type->TagId;

  if (   !isFNameVisible(strpdCUnitFName, pTag)
      && !(InsideMacro && visibleFromMac(pTag))) {
    Tverbo savVerbo = verbose;
    Tstring terseTypeRepre = typeToS1((verbose = Terse /* so that inside of
						      strun not seen */, type));

    verbose = savVerbo;
    errId(PrivNotVisi | Warn1, pTag, NULL, terseTypeRepre, typeToS2(type));}
}

static void checkWrngHdrFile(const TsemanElt *pId)
{
  if (chkInclPos && *pId->DeclaringFile!='\0' /* not NonHdrFName */ &&
					     !isBodyHdrFile(pId->DeclaringFile))
    if (pId->DeclaringFile == nonFileName) errId1(WrngCUnit|Warn1|Rdbl, pId,
								    cUnitFName);
    else if (! isBodyHdrFile(pId->defFileName)) errId1(WrngHdrFile|Warn1|Rdbl,
							       pId, cUnitFName);
}

static void cleverSkipTok(void)
{
  if (curTok.tok==SCOL && peepNxtTok()==RBRA) GetNxtTok();  /* for
							   ExtraSColAtEndMac. */
  skipTok(rBraSCol);
}

/* "Local" global variables for managing array qualifiers (that in fact qualify
   arrays elements => propagation (managed this way because of the handling of
   parallel types). */

static bool arrayIsCurrent = False;
static Tqualif accumXQal, accumYQal;

bool compatType(TpcTypeElt x, TpcTypeElt y, TkTypeEquiv kindEqv)
/* 'x' = left/formal/declaration type; 'y' = right/actual/definition type.
   To be kept coherent with commonType() ("dcexp.c").
   Answers True (False for VerifCastF) if either (sub-)type is NULL */
{
  bool notFrstTurn = False, notAllConst;

  arrayIsCurrent = False;
  for (;;) {
    TtypeSort tsx, tsy;

    if (x==NULL || y==NULL) return (kindEqv!=VerifCastF);
    tsx = x->typeSort;
    tsy = y->typeSort;
    if (x->SysTpdf!=y->SysTpdf && tsx&Who && kindEqv<CCheck1) return False;
    if (!(y->Generiq && InsideInterval(kindEqv, PrevCast, FctCall) && x->
						   NxtIsTypId && rowUp(x, y))) {
      if (y->NxtIsTypId) {
        if (kindEqv < NoCheck) {  /* VerifCastx/StrictChkx */
          if (x->TypeId != y->TypeId) return False;}
        else if (   !(kindEqv==FctCall && InsideInterval(tsy, Array, VFct) &&
	 			!notFrstTurn) /* because Array => &Array[0]
					     and operator '&' yields generic. */
                 && !rowUp(y, x)
                 && kindEqv<CCheck1 /* !(CCheck1/CCheck/CStrictChk/
					       CStrChkExtDcl) */) return False;}
      else if (x->ParalTyp && (
                      InsideInterval(kindEqv, StrictChkLsBnd, IlgIcp)
                   && !(y->Generiq && rowUp(x, y))
                   && tsy!=Array
                 || InsideInterval(kindEqv, VerifCast, VerifCastF))
								) return False;}
    if (tsx != tsy) {  /* not same type sort */
      if (kindEqv < NoCheck /* VerifCastx/StrictChkx */) return False;
      if (   kindEqv<LitString  /* NoCheck/Cmpar */
          || !(   tsx==Ptr
               && tsy==Array
               && (y->Generiq || kindEqv==FctCall && !notFrstTurn)
          || kindEqv==FctCall
           && tsx==Array
           && tsy==Ptr) /* not (Ptr <- String or, if FctCall, Array <->
								     Ptr). */) {
        /* Accept, for CCheck1 type of equivalence, pointer on numeric type
           to be equivalent to pointer on corresponding unsigned type (gua-
           ranteed by standard to be of same size and alignment). */
        if (! (kindEqv==CCheck || kindEqv==CCheck1 && ((tsx | tsy)==(Byte |
		UByte) || (tsx | tsy)==(Short | UShort) || (tsx | tsy)==(Int |
			   UInt) || (tsx | tsy)==(Long | ULong)))) return False;
        /* Manage C equivalence between all integral types, Ptr <=> &Array[],
							    Fct <=> Ptr/Fct. */
        if (! (tsx & NumEnumBool && tsy & NumEnumBool)) {
          if (IsPtrArrSort(tsx)) {
            if (IsPtrArrSort(tsy)) goto skipTstL;
            if (! IsFctSort(tsy)) return False;
            if ((x = NxtTypElt(x)) == NULL) return True;
            tsx = x->typeSort;}
          else {
            if (!IsFctSort(tsx) || tsy!=Ptr) return False;
            if ((y = NxtTypElt(y)) == NULL) return True;
            tsy = y->typeSort;}
          if (tsx != tsy) return False;
skipTstL:;}}
      if (tsx==Ptr && tsy==Array && y->Qualif!=NoQualif) accumulateQal(x,y);}
    if (tsx >= Enum)
      switch (tsx >> PosDelT) {
      case Enum>>PosDelT:
        if (x->TagId!=y->TagId && kindEqv!=CCheck) return False;
        break;
      case Array>>PosDelT:
        if (!y->Generiq /* not string literal */
            && (!((kindEqv < NoCheck)
		   ? compatTypeR(x->BndType, y->BndType, VerifCastF)
		   : (x->BndType==&defaultIndexTypeElt || compatTypeR(x->
						 BndType, y->BndType, NoCheck)))
                  && kindEqv<CCheck
                || (x->Lim!=0 && tsy!=Ptr || kindEqv==StrictChk)
                  && x->Lim!=ArrLimErr
                  && y->Lim!=ArrLimErr
                  && x->Lim!=y->Lim
                  && (kindEqv!=CStrChkExtDcl || y->Lim!=0))) return False;
        if (x->Qualif!=NoQualif || y->Qualif!=NoQualif) accumulateQal(x, y);
        if (! InsideInterval(kindEqv, FctCall, CCheck1)) goto endPtrL;  /*
					    !(FctCall/ExtDcl/IlgIcp/CCheck1). */
        /*~NoBreak*/
      case Ptr>>PosDelT: {
          TpcTypeElt nxtX, nxtY;

          if ((nxtX = NxtTypElt(x))==NULL || (nxtY = NxtTypElt(y))==NULL) break;
          if (x->Generiq && nxtX->typeSort==Void && (kindEqv==LitString ||
		  kindEqv==FctCall) && !(y->Generiq && nxtY->typeSort==Void)
								 ) return False;
          if (InsideInterval(kindEqv, PrevCast, CCheck1)) {/* PrevCast/Asgn/
					       FctCall/ExtDcl/IlgIcp/CCheck1. */
            if (tsx==Array && nxtY->typeSort==Array && nxtX->typeSort!=Array
								 ) return False;
            /* Check pointed element qualifiers, according to C++ Standard */
            {
              Tqualif qualNxtX = (arrayIsCurrent)? arrQal(nxtX, accumXQal) :
								   nxtX->Qualif,
                      qualNxtY = (arrayIsCurrent)? arrQal(nxtY, accumYQal) :
								   nxtY->Qualif;

              if (! notFrstTurn) notAllConst = False;
              if ((((kindEqv == ExtDcl)? qualNxtX & ~qualNxtY : qualNxtY &
				~qualNxtX)!=NoQualif /* compatible qualifiers */
                    || notAllConst && qualNxtX!=qualNxtY)
                  && errQalTyp1==NULL) {  /* keep only first warning */
                static TtypeElt wx, wy;

                errQalTyp1 = (arrayIsCurrent && accumXQal!=NoQualif)? (wx = *x,
					       wx.Qualif |= accumXQal, &wx) : x;
                errQalTyp2 = (arrayIsCurrent && accumYQal!=NoQualif)? (wy = *y,
					    wy.Qualif |= accumYQal, &wy) : y;}
              if (! (qualNxtX & ConstQal) && nxtX->typeSort!=Array /* array
			     always const by itself... */) notAllConst = True;}}
          /* Allow equivalences 'anyType *' => 'void *' and generic 'void *' =>
								 'anyType *'. */
          if (   !InsideInterval(kindEqv, StrictChkLsBnd, NoCheck) && kindEqv!=
			CStrChkExtDcl /* !(NoCheck/StrictChkx/CStrChkExtDcl). */
              && !notFrstTurn
              && (   nxtX->typeSort==Void && (!IsFct(nxtY) || kindEqv==CCheck)
                  || nxtY->typeSort==Void && (y->Generiq || kindEqv==CCheck ||
					       kindEqv==Cmpar && !IsFct(nxtX))))
            return (kindEqv>=NoCheck || ((arrayIsCurrent)
                    ? sameQal(x, y) && sameQal(nxtX, nxtY)
                    : x->Qualif==y->Qualif && nxtX->Qualif==nxtY->Qualif));
          /* Pointer on strun can always be stored in pointer on first member */
          if (InsideInterval(kindEqv, Asgn, FctCall) && IsStrun(nxtY) &&
				      checkFrstMember(nxtY, nxtX)) return True;}
        if (   kindEqv<CCheck
            && !((kindEqv < NoCheck)
		? compatTypeR(x->BndType, y->BndType, VerifCastF)
		: (x->BndType==&defaultIndexTypeElt || compatTypeR(x->
				  BndType, y->BndType, NoCheck)))) return False;
endPtrL:
        notFrstTurn = True;
        break;
      case Fct>>PosDelT: case VFct>>PosDelT: {
          /*TdeclList*/const TdeclElt *wx = x->ParamList, *wy = y->ParamList;

          if (InsideInterval(kindEqv, PrevCast, IlgIcp) && (x->PvNr && !y->PvNr
						   || x->Generiq && !y->Generiq)
	      || kindEqv<NoCheck /* VerifCastx/StrictChkx */ && (x->PvNr!=y->
				  PvNr || x->Generiq!=y->Generiq)) return False;
          while (wx!=NULL && wy!=NULL) {
            if (!(InsideInterval(kindEqv, PrevCast, FctCall) && wx->ParQal==
			    GenericV && CompatType(wx->type, wy->type, kindEqv))
                && (   !CompatType(wy->type, wx->type, kindEqv)
		    || wx->ParQal!=wy->ParQal
		     && (    InsideInterval(kindEqv, LitString, IlgIcp)
			  && (   kindEqv==IlgIcp
			      || wx->ParQal!=GenericV)
			 || kindEqv<NoCheck /* VerifCastx/StrictChkx */))
								 ) return False;
            wx = wx->cdr; wy = wy->cdr;}
          if (wx!=NULL && tsy!=VFct || wy!=NULL && tsx!=VFct) return False; 
					     /* not same number of parameters */
          notFrstTurn = False;  /* function result has nothing to do with
							       function call. */
          break;}
      case Struct>>PosDelT: case Union>>PosDelT:
        if (x->TagId != y->TagId) return False;
        break;
      /*~ NoDefault */}
    if (kindEqv<NoCheck /* VerifCastx/StrictChkx */ && ((arrayIsCurrent)?
			   !sameQal(x, y) : x->Qualif!=y->Qualif)) return False;
    if (arrayIsCurrent) checkEndAccumQal(x, y);
    if ((x = NxtTypElt(x))==(y = NxtTypElt(y)) && !arrayIsCurrent) return True;
    /* Stricter check for pointers, arrays ... */
    if (kindEqv == CCheck) kindEqv = CCheck1;}
}

static void accumulateQal(TpcTypeElt x, TpcTypeElt y)
{
  if (! arrayIsCurrent) {
    accumXQal = accumYQal = NoQualif;
    arrayIsCurrent = True;}
  if (IsArr(x)) accumXQal |= x->Qualif;
  if (IsArr(y)) accumYQal |= y->Qualif;
}

static Tqualif arrQal(TpcTypeElt t, Tqualif q)
{
  return (IsArr(t))? NoQualif : t->Qualif | q;
}

static void checkEndAccumQal(TpcTypeElt x, TpcTypeElt y)
{
  if (! IsArr(x)) accumXQal = NoQualif;
  if (! IsArr(y)) accumYQal = NoQualif;
  if (accumXQal==NoQualif && accumYQal==NoQualif) arrayIsCurrent = False;
}

static bool compatTypeR(TpcTypeElt x, TpcTypeElt y, TkTypeEquiv kindEqv)
{
  if (x == y) return True;
  {
    bool saveAIC = arrayIsCurrent, resul;
    Tqualif saveAXQ = accumXQal, saveAYQ = accumYQal;

    resul = CompatType(x, y, kindEqv);
    arrayIsCurrent = saveAIC;
    accumXQal = saveAXQ; accumYQal = saveAYQ;
    return resul;}
}

static bool sameQal(TpcTypeElt x, TpcTypeElt y)
{
  return arrQal(x, accumXQal) == arrQal(y, accumYQal);
}

/*~ Undef arrayIsCurrent, accumXQal, accumYQal */

static void computeSize(TpTypeElt x)
/* Computes size of all arrays in type chain 'x' */
{
  TpcTypeElt nxtType;

  if (x==NULL || x->Shared || (nxtType = NxtTypElt(x))==NULL) return;
  computeSize((ModifType)nxtType);
  if (IsArr(x)) x->size = sizeOfTypeD(nxtType, ArrOfIncplOrFctElt, NULL) *	
									 x->Lim;
  else if (IsFct(x) && IsArrFct(nxtType)) errWT(ArrOrFctCantBeRet, nxtType);
}

static TdeclList createDLElt(TcreatType dId /*~MayModify*/, TinfoDecl infoDcl,
						  TpcTypeElt type, Tqualif qual)
{
  TdeclList dList;

  if (type != NULL) {
    if (type->Qualif & qual) err0(AlrdQual);
    /* If array (case "typedef int Tarr[]; Tarr a={1,2}, b={3};"), or added
       qualifiers, create copy of type element; copy owned by the declared
       object, so has to be freed when the object disappears. */
    if (qual & ~type->Qualif || type->size==0 && IsArr(type) || infoDcl.s11.
								   _signedInt) {
      TpTypeElt w = allocTypeEltIC(type, qual);

      type = w;
      if (infoDcl.s11._signedInt) w->SynthQualif = Sgnd;}}
  /* Connect baseType and type modifier */
  if (dId.headType != NULL) ((ModifType)dId.tailType)->NextTE = type;
  else {  /* no modifier */
    dId.headType = type;
    /* Parallel Type ? (no qualifier, no type modifier and type defined by
       typeId). */
    if (qual==NoQualif && !infoDcl.s11._noNewTypeFl) infoDcl.s11._paralTypeFl
									= True;}
  /* Allocate and fill new declList element */
  dList = (TdeclList)allocDeclElt();
  dList->idName = dId.idName;
  dList->hCode = dId.hCode;
  dList->type = dId.headType;	/* beginning of type chain */
  computeSize((ModifType)dList->type);
  dList->infoD = infoDcl;
  return dList;
}

static long stubCtr = 0;

static void initCreateTagName(void)
{
  stubCtr = 0;
}

static Tname createTagName(Tname x)
{
  if (x == NULL) {  /* create name only if stub */
    Tchar buf[sizeof(TnbBuf) + LgtHdrId + 1], *ptrBuf = &buf[LgtHdrId + 1];

    bufLongToS(++stubCtr, ptrBuf);
    while (*ptrBuf++ != '\0') {;}
    buf[0]= (Tchar)(ptrBuf - &buf[LgtHdrId + 1]);
    buf[LgtHdrId] = StartTagCh;
    x = storeName(ConvTname(&buf[0]), TagSpace);}
  return x;
}

/*~Undef stubCtr */

TpcTypeElt declType(void)
{
  TpcTypeElt type;
  jmp_buf localJmpBuf, *savErrRet = curErrRet;

  curErrRet = &localJmpBuf /*~ LocalAdr */;
  if (setjmp(*curErrRet) == 0) {
    TdeclList typeName;

    noNewTypeInfo.s11._prioToCast = True;
    typeName = decl1(noNewTypeInfo);
    if (typeName->idName != NULL) errWN(NoIdAlwdInType, typeName->idName);
    type = typeName->type;
    (void) freeDeclElt(typeName);
    if (type!=NULL && !type->Shared) ((ModifType)type)->NoOwner = True;}
  else {skipTok(zCoScEdpRPRB); type = NULL;}
  curErrRet = savErrRet;
  return type;
}

TsemanElt *defineId(TinfoSeman infoS)
/* Create a fake typeId to prevent further 'UndefId' errors. */
{
  TsemanElt *ptrId;
  Tname w;

  if (allErrFl) return NULL;
  ptrId = enterSymTabHC((w = storeName(curTok.IdName, ObjectSpace)), curTok.
									  Hcod);
  ptrId->type = NULL;
  if (infoS.s11._kind == Obj) ptrId->DeclaringFile = curHdrFName;
  else ptrId->NamedType = NULL;
  ptrId->defLineNb = lineNb;		/* record              */
  ptrId->defFileName = curFileName;	/*        birth place. */
  ptrId->Nameb = w;
  ptrId->infoS = infoS;
  return ptrId;
}

static TsemanElt *errAlrdDefId(Tname x, TpcTypeElt y, Tkind z)
{
  TsemanElt *ptrId = searchSymTab(x);

  if (ptrId->type==NULL && (ptrId->Kind==z || ptrId->Kind==Obj && z==EnumCst)
					 ) return ptrId;  /* "forced defined" */
  {
    Tverbo savVerbo = verbose;

    verbose = FullVerbo;
    errId((   y==QuasiNULLval(TpcTypeElt)
           || !ptrId->Defnd
            && y!=NULL
            && (CompatType(ptrId->type, y, CStrChkExtDcl) || fctInfo(ptrId)<
			        NOINFO))? AlrdDefId|Warn2|PossErr : AlrdDefId,
				    ptrId, x, typeToS1(ptrId->type), typeToS2(
			     (y == QuasiNULLval(TpcTypeElt))? ptrId->type : y));
    verbose = savVerbo;}
  return NULL;
}

static void errMsngStati(Tname x)
{
  if (! goodPrgmg) return;
  {
    register TstringNC w;
    register Tstring w1 = cUnitFName;
    Tstring w2, w3 = SearchDot(w1);

    w2 = w = allocPermSto((size_t)(w3 - w1 + 1));
    while (w1 != w3) {*w++ = *w1++;}
    *w = '\0';
    errWNSS(MsngStati|Warn1|Rdbl, x, w2, NULL);
    freeLastPermSto();}
}

TfctInfo fctInfo(const TsemanElt *ptrId)
/* Returns <0 (SYSFCT) if function declared by 'system' header file, else see
   definition of enumType TfctInfo in dcdecl.h */
{
  register TpcTypeElt curType;

  if (ptrId == NULL) return NOTFCT;
  curType = ptrId->type;
  for (;;) {
    if (curType == NULL) return NOTFCT;
    if (IsFct(curType)) break;
    curType = NxtTypElt(curType);}
  {
    register const TdeclElt *param = curType->ParamList;
    TfctInfo result = (curType==ptrId->type && ptrId->SysFct)? SYSFCT : NOINFO;
    bool voidStarFct = compatType(NxtTypElt(curType), &voidPtrTypeElt,
								    VerifCastF);

    while (param != NULL) {
      if (param->ParQal == ResulTypV) result |= RESTYPFCT;
      if (voidStarFct && param->type!=NULL && IsTypeSort(param->type, UInt|
					 ULong|ULLong)) result |= MALLOCLIKEFCT;
      param = param->cdr;}
    return result;}
}

static FreeXElt(freeDeclElt, TdeclList, ctrDE, ;, cdr)

static void freeDeclList(TdeclList x)
{
  while (x != NULL) {freeTypeChain(x->type); x = freeDeclElt(x);}
}

static FreeXElt(freeTagListElt, TtagVisi *, ctrTLE, ;, preced)

void freeTypeChain(TpcTypeElt x /*~MayModify*/)
{
  while (x != NULL) {x = freeTypeElt(x);}  /* x may be NULL at the outset
			     (case of undefined Id, or empty BndType, or...). */
}

FreeXElt(freeTypeElt, TpcTypeElt, ctrTE, {
	  if (x->Shared) return NULL;  /* stop freeing immediately */
          ((ModifType)x)->Shared = True;  /* to prevent several freeing of the
			same typeElt (by remaining types pointing on it, because
			otherwise no more protected by 'Shared' bit). */
          if (x->StopFreeing) resul = NULL;  /* stop freeing after this one */
          if (! x->NoFreeDpdt)
            switch (x->typeSort  >> PosDelT) {
            case Array>>PosDelT: {
              freeTypeChain(x->BndType);  /* BndType may be NULL, so don't
						  use freeTypeElt() directly. */
              break;}
            case Fct>>PosDelT: case VFct>>PosDelT: freeDeclList(x->ParamList);
									  break;
            case Struct>>PosDelT: case Union>>PosDelT: freeDeclList(x->
							     MemberList); break;
            /*~ NoDefault */}
                                        }, NextTE)

void freeTypes(TsemanElt *x)
/* Beware of case "typedef unknId bool;" (type==NULL, NamedType!=NULL) */
{
  if (! InsideInterval(x->Kind, Obj, StrunTag)) return;  /* Param, EnumCst,
								       Label. */
  if (x->Kind != Obj) {  /* Type, Tags */
    if (x->Kind == Type) {
      if (x->NamedType != NULL) {
#if Debug
/*        if (! x->NamedType->Shared) sysErr(ExCod5);*/
#endif
        ((ModifType)x->NamedType)->Shared = False;  /* to allow freeing */
        freeTypeChain(x->NamedType);}}
    else {  /* Tags */
      if (x->type != NULL) {
#if Debug
/*        if (! x->type->Shared) sysErr(ExCod8);*/
#endif
        ((ModifType)x->type)->Shared = False;  /* to allow freeing */
        if (x->Kind==EnumTag && x->type->FrstEnumCst!=NULL) {  /* free type
					 element associated to enum constant. */
          ((ModifType)x->type->FrstEnumCst->type)->Shared = False;
          (void)freeTypeElt(x->type->FrstEnumCst->type);}}}}
  freeTypeChain(x->type);
}

TpcTypeElt getINDEXTYPEtype(void)
{
  TpcTypeElt resul;

  resul = (curTok.DpType == NULL)
            ? NULL
            : (curTok.DpType->typeSort & WhoEnumBool)
              ? curTok.DpType
              : (err0(IntgrlTypeExptd | Warn2), FreeExpType1(curTok.DpType),
									  NULL);
  GetNxtTok();
  return resul;
}

void initDecl(void)
{
  initCreateTagName();
}

bool isRepreType(TpcTypeElt x)
{
  return (x!=NULL && IsTypeSort(x, Num) && !x->NxtIsTypId);
}

void makeGeneric(TpTypeElt x)
/* Mark 'generic' non-void function of base type (or type derived from base
   type via qualifier/modifier; in such a case, each level of (pointer) modifier
   is also marked 'generic'). */
{
  TpTypeElt nxtX;
  bool sharedSeen;

  if (x->Shared) return;  /* typedef has already undergone makeGeneric */
  sharedSeen = False;
  while (!x->NxtIsTypId && (nxtX = (ModifType)x->NextTE)!=NULL && nxtX->
							       typeSort!=Void) {
    if (nxtX->Shared || sharedSeen) {  /* duplicate type chain */
      x->NextTE = nxtX = allocTypeEltIC(nxtX, NoQualif);
      x->StopFreeing = False;
      sharedSeen = True;}
    if (! IsArrFct(nxtX)) nxtX->Generiq = True;
    x = nxtX;}
}

static void manageFctDPrags(const TdeclElt *dl)
{
  TpcTypeElt x = dl->type, retType;
  bool resultTypeSeen = False, resultTypePoss = False;

  if (   !insideHdrFile
      && (   !(dl->Attriba==NoAttrib && nestLvl==0) && !InsideInterval(dl->
							  Attriba, Extrn, Typdf)
          || dl->MemberFl)
      && chk1stCharVF
      && !InsideMacro) {
    char c;

    if (dl->idName!=NULL && (c = (char)*(dl->idName + LgtHdrId), isupper(c) ||
	 c=='_' && !dl->MemberFl)) errWN(LoCaseObjName|Warn1|Rdbl, dl->idName);}
  while (x != NULL) { /* search whether there is a function in the type chain */
    if (IsFct(x)) {  /* search whether possible ResultType or SizeOfMemBlk
			      parameter compatible with function return type. */
      TdeclElt *parElt;
      int parCtr;

      retType = NxtTypElt(x);
      for (parElt = x->ParamList, parCtr = 0; parCtr++, parElt != NULL;
							 parElt = parElt->cdr) {
        if (parElt->ParQal == ResulTypV) {
          resultTypeSeen = True;
          if (! CompatType(retType, parElt->type, NoCheck)) {
            errWSTTS(IncohResultType | Warn2, longToS(parCtr), parElt->type,
		    retType, dpName((parElt->ResulPtrFl)? RESULPTR : RESULTYP));
            parElt->ParQal = NoParQal;}}
        else if (parElt->ParQal==GenericV && x==dl->type) {errIlgDP(GENERIC)
						   ; parElt->ParQal = NoParQal;}
        else if (!sysAdjHdrFile && parElt->ParQal==NoParQal && !parElt->
		    NotUsedFl && CompatType(retType, parElt->type, NoCheck)
							) resultTypePoss = True;
        if (parElt->SizeofBlFl && retType!=NULL && !IsPtr(retType)) {errIlgDP(
					SIZEOFBL); parElt->SizeofBlFl = False;}}
      goto foundFctL;}
    x = NxtTypElt(x);}
  return;  /* no function found */
foundFctL:
  if (resultTypePoss && !resultTypeSeen) ((ModifType)x)->ResTypPoss = True;
  {
    bool pvNrSeen = False, genUtilSeen = False;

    for (; curTok.tok == DPTOK; GetNxtTok()) {
      Tdprag curDP = (Tdprag)curTok.Val;

      switch (curDP) {
        case PSEUDOVOID: case NEVRET:
          if (pvNrSeen) break;
          pvNrSeen = True;
          if (retType!=NULL && (retType->typeSort == Void)==(curDP==
							     PSEUDOVOID)) break;
          ((ModifType)x)->PvNr = True;
          continue;
        case UTILITY:
          if (retType!=NULL && !isRepreType(retType)) break;
          /*~NoBreak*/
        case GENERIC:
          if (genUtilSeen) break;
          genUtilSeen = True;
          if (retType!=NULL && retType->typeSort==Void) break;
          if (resultTypeSeen) errWS(CantBeGeneUtil | Warn2, dpName(curDP));
          else if (curDP == GENERIC) ((ModifType)x)->Generiq = True;
          continue;
        /*~NoDefault*/}
      errIlgDP(curDP);}
    if (x->Generiq) makeGeneric((ModifType)x);
    else if (chkFctRetTyp && !genUtilSeen && !resultTypeSeen && !x->Generiq /*
	  because of possible typedef used to define function */ && !mainFl 
		&& isRepreType(retType)) errWT(ResRepreType | UWarn2, retType);}
}

void procExtent(void)
{
  TsemanElt *pSem = curTok.PtrSem;

  cExp.Sval = 0;
  if ((pSem != NULL)
       ? pSem->Kind!=Type
       : (*((TnameNC /*~OddCast*/)curTok.IdName + DispNSId) = (TnameAtom)
		TagSpace, (pSem = searchSymTab(curTok.IdName)) == NULL) ||
		pSem->Kind!=EnumTag) errWN(NotEnumTypeOrTag, curTok.IdName);
  else {
    TpcTypeElt idType;

    if ((idType = pSem->type) != NULL) {
      register const TsemanElt *w;

      if ((w = idType->FrstEnumCst) == NULL) {
        if (idType->TagId == NULL) cExp.Sval = UCHAR_MAXC;}
      else {
        cExp.Sval = (TcalcS)w->EnumVal;
        while (w->NxtEnumCst != NULL) {w = w->NxtEnumCst;}
        cExp.Sval -= (TcalcS)w->EnumVal;}}
    pSem->Used = True;}
  cExp.type = &intCstTypeElt;
}

void procIndex(void)
{
  if (curInitArrayIndex == ArrLimErr) {err0(NotArrInit); cExp.ErrEvl = True;}
  cExp.Uval = (TcalcU)curInitArrayIndex;
  cExp.type = curInitArrayBndType;
}

static void procMember(void)
{
  if (curInitMember == OutsideStrunInit) {err0(NotStrunInit); cExp.ErrEvl =
									  True;}
  cExp.type = &boolCstTypeElt;
}

void procMember1(void)
{
  cExp.Uval = (TcalcU)(curInitMember>OutsideStrunInit && curInitMember->idName
			       !=NULL && isSameName(curTok.Hcod, curTok.IdName,
				  curInitMember->hCode, curInitMember->idName));
  procMember();
}

void procMember2(void)
{
  cExp.Uval = (TcalcU)(curInitMember==NULL);
  procMember();
}

static bool rowUp(TpcTypeElt x, TpcTypeElt y)
/* Returns True if 'y' is a (reachable if heedRootType True) ancestor of 'x' */
{
  do {
    if (x->TypeId == y->TypeId) return True;  /* ancestor reached */
    if (x->RootTyp && heedRootType) return y->typeSort==Ptr && !y->NxtIsTypId &&
	  ((y = y->NextTE)==NULL || y->typeSort==Void);  /* "RootType" (non
			 representation type) found (void* always reachable). */
    x = Parent(x);  /* climb hierarchy */
  } while (x->NxtIsTypId);
  /* Representation type reached; OK if 'y' non-parallel type */
  return ! y->ParalTyp;
}

size_t sizeOfTypeD(TpcTypeElt type /*~MayModify*/, Terr err, Tname name)
{
  TpcTypeElt type1 = type;

  if (type == NULL) return 0;
  if (IsStrun(type)) type = BaseStrunType(type);
  if (((IsArr(type))? type->Lim : type->size)==0 && !type->ErrSiz) {
    errWNT(err, name, type1);
    if (!(err & WarnMsk) && type!=&natTyp[VoidDpl] && !allErrFl)
      ((ModifType)type)->ErrSiz = True;}
  return type->size;
}

TresulTstPtd tstPtd(register TpcTypeElt w, bool onlyFrstLvl)
{
/*  TresulTstPtd addInfo;
  TpcTypeElt w1;*/

  if (w == NULL) return ERRTYPE;
  if (IsStrun(w)) return STRUN;
/*    addInfo = STRUN;
  else {
  */  if (! IsPtrArr(w)) return NOTPTR;
/*    addInfo = (TresulTstPtd)0;}*/
  {
    bool constArray = False, firstTurn = True;
    TtypeSort ts;

    do {
/*      w1 = w;*/
      if ((ts = w->typeSort) == Array) {if (w->Qualif & ConstQal) constArray =
									  True;}
      else {
        if (IsFctSort(ts)) break;
        if (! firstTurn) {
          if (! (w->Qualif & ConstQal || constArray)) return /*addInfo |*/
								    NOTALLCONST;
          if (onlyFrstLvl) return /*addInfo |*/ ALLCONST;
          constArray = False;}}
      firstTurn = False;
    } while ((w = NxtTypElt(w)) != NULL);
#if False
    if (!onlyFrstLvl && IsStrunSort(ts)) {
      /* Search whether there exist non 'const' pointer fields */
      const TdeclElt *member = BaseStrunType(w1)->MemberList;

      while (member != NULL) {
        if (tstPtd(member->type, False) & NOTALLCONST) return NOTALLCONST |
									addInfo;
        member = member->cdr;}}
#endif
    return ((IsPtrArrSort(ts))? ERRTYPE : ALLCONST) /*| addInfo*/;}
}

/* End DCDECL.C */
