/* DCDECL.H */
/* Y.L. Noyelle, Supelec, France 1996 */

#ifndef DCDECL_H
#define DCDECL_H

#include "dc.th"

#define CompatType(x, y, z) ((x == y)? True : compatType(x, y, z))

typedef enum {NOINFO, NOTFCT=1, RESTYPFCT=NOTFCT<<1, MALLOCLIKEFCT=RESTYPFCT<<1,
						      SYSFCT=SIGN_BIT} TfctInfo;
typedef enum {VerifCast = -4, VerifCastF, StrictChkLsBnd, StrictChk, NoCheck,
	Cmpar, LitString, PrevCast, Asgn, FctCall, ExtDcl, IlgIcp, CCheck1,
	CCheck, CStrictChk, CStrChkExtDcl} TkTypeEquiv;
/*~ zif NoCheck != (TkTypeEquiv)0 "NoCheck must be zero (cf 'compatType')" */

typedef enum {ERRTYPE=1, NOTPTR=ERRTYPE<<1, STRUN=NOTPTR<<1, ALLCONST=STRUN<<1,
					  NOTALLCONST=ALLCONST<<1} TresulTstPtd;

/* Function profiles */
extern TpTypeElt allocTypeEltIC(TpcTypeElt, Tqualif), allocTypeEltID(TtypeSort,
  Tqualif);
extern bool checkFrstMember(TpcTypeElt, TpcTypeElt);
extern void checkPrivVisible(TpcTypeElt type);
extern bool compatType(TpcTypeElt, TpcTypeElt, TkTypeEquiv);
extern void decl(void);
extern TpcTypeElt declType(void);
extern TsemanElt *defineId(TinfoSeman);
extern TfctInfo fctInfo(const TsemanElt *);
extern void freeTypeChain(TpcTypeElt /*~MayModify*/);
extern TpcTypeElt freeTypeElt(TpcTypeElt /*~MayModify*/);
extern void freeTypes(TsemanElt *);
extern TpcTypeElt getINDEXTYPEtype(void);
extern bool isRepreType(TpcTypeElt);
extern void makeGeneric(TpTypeElt);
extern void procExtent(void), procIndex(void), procMember1(void), procMember2(
  void);
extern void prog(void);
extern size_t sizeOfTypeD(TpcTypeElt /*~MayModify*/, Terr, Tname);
extern TresulTstPtd tstPtd(TpcTypeElt, bool);

/* External variables */
extern bool heedRootType;
extern bool alrdAnalzdExp;
extern TsemanElt *pIdInit;

#endif /* ifndef DCDECL_H */
/* End DCDECL.H */
