/* Program Name            : DELTREE2.C                                 */
/*   Original Author       : JLAURET                                    */
/*   Date                  : 1994					*/
/*   Program Description   : Started from a skeleton idea I got		*/
/*                         : from another package, I developped DELTREE	*/
/*                         : a directory tree deletion program ...	*/
/* Revision History at bottom						*/


#include "common.h"
#include "deltree_msg.h"
#include "deltree.h"

/* Variable used only here */
static clock_t 		init_time;
struct returned_info	info={'\0',0,0};
char 			*privs;



int main(int argc, char *argv[])
{
int	status,gstatus=SS$_NORMAL;
int	i;
char	*ptr;
char	*top;
char	*dpos;
char	*safilin;
char	*sfilin,*filin,*sdev,*dev;

  prgm_nam  = argv[0];
  ptr	    = strrchr(prgm_nam,';');
  *ptr	    = '\0';

  hack$establish(lib$sig_to_ret);
  get_args();
  hack$revert();

  /* Let's check those 							*/
  if( svrs ){
	hack$signal(DELTREE__VERSION_msg_hack,2,VERSION,COPYR);
	exit(SS$_NORMAL);
  }
  if( info.pid != 0){
	hack$signal(DELTREE__DPRCS_msg_hack,3,info.prcsnam,info.pid,info.prio);
	exit(SS$_NORMAL);
  }


  /* Init timer								*/
  cpu_time(0,"","");

  /*  save the current default    					*/
  original = (char *) getcwd('\0',BUFSIZ);
  if(dodebug)hack$signal(DELTREE__DEBUG_msg_hack,2,"root is",original);


  /* Loop over all dir specified on command line			*/
  safilin= afilin;
  dpos	= strchr(afilin,',');
  do{
    if(dpos) *dpos++  = '\0';

    /* Initialize next pass 						*/
    /* Directory expected without "."					*/
    status	= SS$_NORMAL;
    depth	= 0;
    rdepth	= 0;

    sfilin = filin = (char *) malloc(strlen(afilin)*(sizeof(char)+1+0));
    sdev   = dev   = (char *) malloc(strlen(afilin)*(sizeof(char)+1+6));
    if( filin == NULL || dev == NULL){
	chdir(original);
    	hack$exit(DELTREE__INSFMEM_msg_hack);
    }
    strcpy(dev,afilin);
    strcpy(filin,afilin);

    dev		= strrchr(dev,']');
    filin	= strrchr(filin,']');
    if( dev ){
    	/* We had a device specified 					*/
	dev++; 	*dev    = '\0';
	dev	= sdev;
	filin++;
    } else {
	filin	= sfilin;
	strcpy(sdev,"[]");
	dev	= sdev;
    }
#ifdef DEBUG
    printf("deltree :: preproc %s %s\n",dev,filin);
#endif

    if( *filin == '\0' ){
	if(dodebug)
	 hack$signal(DELTREE__DEBUG_msg_hack,2,
	 	"no directory-file specified. Extract from",
		sfilin);

	filin	= strrchr(sfilin,'.');
	if( filin == NULL){
		/* Dammit !! One of those !! 				*/
		filin	= strrchr(sfilin,'[');
		/* printf("%s\n",filin); */
		if( filin == NULL){
			chdir(original);
			hack$exit(DELTREE__MISSING_msg_hack);
		}
		filin++;
		strcpy(sfilin,filin);

		filin	= strrchr(sfilin,']');
		if( filin == NULL){
			chdir(original);
			hack$exit(DELTREE__MISSING_msg_hack);
		}
		*filin	= '\0';
		filin	= sfilin;

		dev	= strrchr(dev,'[');
		if( dev == NULL){
			chdir(original);
			hack$exit(DELTREE__MISSING_msg_hack);
		}
		*dev = '\0'; dev = sdev;
		strcat(dev,"[000000]");
	} else {
		/* There is a do somewhere in the path		       	*/
		filin++;  strcpy(sfilin,filin);
	        filin	= strrchr(sfilin,']');
		if( filin == NULL){
			chdir(original);
			hack$exit(DELTREE__MISSING_msg_hack);
		}
		*filin	= '\0';
		filin	= sfilin;

		dev	= strrchr(sdev,'.');
		if( dev == NULL){
			chdir(original);
			hack$exit(DELTREE__MISSING_msg_hack);
		}
		*dev++	= ']';
		*dev	= '\0';
		dev	= sdev;
	}
    }

#ifdef DEBUG
    printf("deltree :: final dev=%s dir=%s\n",dev,filin);
#endif

    /* Path sanity check						*/
    if(     strchr(filin,']') != NULL ||
	    strchr(filin,'[') != NULL ||
	    strchr(filin,':') != NULL ){
		chdir(original);
	    	hack$exit(DELTREE__MISSING_msg_hack);
    }

    if(	*filin == '-'){
	chdir(original);
    	hack$signal(DELTREE__UGLIX_msg_hack);
    }


    if ( chdir(dev) == 0){
#ifdef DEBUG
    	if(dodebug)
	 hack$signal(DELTREE__DEBUG_msg_hack,2,
	 	"Now in",
		(char *) getcwd('\0',BUFSIZ));
#endif

	/* Preceding version of DELTREE allowed path simplication	*/
    	top	= strchr(filin,'.');
    	if(top)	*top = '\0';

	/* Save this for later processing				*/
	tsave_tree = save_tree	= (char *) malloc(strlen(filin)*sizeof(char));
	if(save_tree == NULL){
		chdir(original);
		hack$exit(DELTREE__INSFMEM_msg_hack);
	}
	strcpy(save_tree,filin);

	/*  if a valid root             				*/
	if (chdir(filin) == 0) {
		/*  save the root spec          			*/
		if(dodebug)
		 hack$signal(DELTREE__DEBUG_msg_hack,2,
		 	"successful chdir() in",
			filin);

		top = (char *) getcwd('\0',BUFSIZ+5,0);

#ifdef DEBUG
		if(dodebug)hack$signal(DELTREE__DEBUG_msg_hack,2,
	 		"working in",top);
#endif

		/* Save top for later file-shortening display		*/
		save_top = (char *) malloc(strlen(top)*sizeof(char));
		if(save_top == NULL) return(SS$_INSFMEM);
		strcpy(save_top,top);

		/* Calculate initial depth				*/
		for(ptr = save_top ; ptr ;){
		  if((ptr = strchr(ptr,'/')) != NULL)
			depth++, ptr++;
		}


		/* Fix top with .dir   					*/
		strncat(top,".dir.",BUFSIZ);

		/* Go to root-device					*/
		/*  and let the fun begin       			*/
		chdir("[-]");
#ifdef DEBUG
		if(dodebug)
		 hack$signal(DELTREE__DEBUG_msg_hack,2,
	 		"back in",
			(char *) getcwd('\0',BUFSIZ));
#endif

		if(dodebug)hack$signal(DELTREE__BEGIN_msg_hack,2,dev,filin);

		status = SS$_NORMAL;
		if(status = rm_tree(filin)){
		  /*  finally, remove the root    			*/
#ifdef DEBUG
		  if(dodebug)
		 	hack$signal(DELTREE__DEBUG_msg_hack,2,
	 			"almost done",
				(char *) getcwd('\0',BUFSIZ));
#endif
		  if(topdir){
			status = flush_file(top);
		  } else {
		  	hack$signal(DELTREE__PRSRVD_msg_hack,2,dev,strip(filin));
		  }
		}
		if(gstatus == SS$_NORMAL || gstatus == DELTREE__NOTEXISTS)
			gstatus = status;
		if(status == DELTREE__PRV) gstatus = status;
		if(count != 0)status = SS$_NORMAL;

		if(dolog)cpu_time(1,dev,tsave_tree);
		free(top);
		free(save_top);
		free(save_tree);
		free(tsave_tree);

	} else {
		hack$signal(DELTREE__NOTFND_msg_hack,2,filin,dev);
		if(gstatus == SS$_NORMAL) gstatus = DELTREE__NOTEXISTS;
    	}

    } else {
	hack$signal(DELTREE__CHDFAIL_msg_hack,1,dev,filin);
	if(gstatus == SS$_NORMAL) gstatus = DELTREE__NOTATREE;
    }




    /* <===================== */

    free(sfilin);
    free(sdev);

    if( chdir(original)	!= 0){
	    hack$exit(DELTREE__NOROOT_msg_hack);
    }

    afilin = dpos;
    if(afilin) dpos = strchr(afilin,',');
  } while(afilin);


  /*  go back home                					*/
  chdir(original);
  free(original);
  free(safilin);

  if(dodebug)hack$signal(DELTREE__DEBUG_msg_hack,2,"leaving deltree","");
  return gstatus;
}

/* -------------------------------------------------------------------- */
/*  remove tree - call shell$from_vms to remove files  			*/
/* -------------------------------------------------------------------- */
int rm_tree(char *s)
{

    if(doconf && (rdepth==1 || alldir)){
	char	ans;

	printf("deltree :: Delete %s%s ? ",
		(strcmp(tsave_tree,s)==0?"./":tsave_tree),strip(s));
	scanf("%s",&ans);
	ans = tolower(ans);
	if (ans != 'y'){
		count++;
		return FALSE;
	}
    }

    /*  move to target dir      					*/
    if( dochdir(1,s) == 0){

     /* blow everything (?) away.					*/
     /* Actually the .*;* remains so we have to treat them separatly	*/
     if(dodebug)hack$signal(DELTREE__DEBUG_msg_hack,2,"flushing in",s);

     shell$from_vms(".*;*",action,1);
     shell$from_vms("*.*;*",action,1);

     if(dodebug){
        char	temp[DIM];
	sprintf(temp,"%s (conf=%d debug=%d)",s,doconf,dodebug);
     	hack$signal(DELTREE__DEBUG_msg_hack,2,"endFlush in",temp);
     }

     /*  move back one							*/
     dochdir(-1,"[-]");
     return TRUE;
    } else {
     return FALSE;
    }
}


/* -------------------------------------------------------------------- */
/*  this routine is reponsible for file deletion			*/
/* -------------------------------------------------------------------- */
int action(char *name)
{
char	*ps;
int	sts;


    /*  is this a directory?  						*/
    if ((ps=strstr(name,".DIR.")) != '\0'){
        *ps = '\0';
	sts = rm_tree(name);

        *ps = '.';
	if(sts==1) sts = flush_file(name);
    } else {
	/*  it's a file, so						*/
	sts = flush_file(name);
    }
    return 1;
}


int	flush_file(char *name)
{
int	stat,sts;

	stat	= SS$_NORMAL;

	sts 	= chmod(name,0777);
	if(sts != 0){
		if(dolog)hack$signal(DELTREE__NOPROT_msg_hack,2,tsave_tree,strip(name));
		stat = DELTREE__PRV;
	}

#ifdef DEBUG
	if(dodebug)hack$signal(DELTREE__DEBUG_msg_hack,2,"deleting",name);
#endif
	sts	= delete(name);
	if(sts != 0 ){
		if(dolog)hack$signal(DELTREE__NODELE_msg_hack,2,tsave_tree,strip(name));
		if(stat == SS$_NORMAL)stat = DELTREE__NOTATREE;
	} else {
		/* If the file belong to another user, stat =		*/
		/* DELTREE__PRV will be set. But we may still be able	*/
		/* to delete the file if the protection or ACL are	*/
		/* set properly. i.e. we need to reset status ...	*/
		stat	= SS$_NORMAL;
		total++;
	}
	return stat;
}



/* --------------------------------------------------------------------	*/
/* String manipulation routines						*/
/* --------------------------------------------------------------------	*/
char	*strip(char *st)
{
char	*base,*name;

	base = save_top; name = st;
	for(; *name && *name == *base; name++,base++);
	return name;
}




/* --------------------------------------------------------------------	*/
/* Other routines							*/
/* --------------------------------------------------------------------	*/

int dochdir(int i,char *st)
{
 rdepth += i;
 depth  += i;

 /* 10 = 8 + 2 ; 2 comes from "/" at beginning of disk name, "/" between
    disk name and first directory from 000000				*/
#ifdef DEBUG
 if(dodebug)printf("chdir() if %d%%%d && %d (%d)\n",depth,MAXDEPTH,i,doconf);
#endif

 if( (depth%MAXDEPTH) == 0 && i > 0 ){
	/* Solve it with a recursive loop				*/
#ifdef DEBUG
        if(dodebug)printf("level=%d depth encountered. %d (%d)\n",level,dodebug,doconf);
#endif
	if(level == 0){
		$DESCRIPTOR(logical,"DELTREE_NEWTOP");
		$DESCRIPTOR(parent,"LNM$PROCESS_TABLE");
		$DESCRIPTOR(value,"");

		char	*expectedcd;
		char	*ptr,*disk;
		char	*tmp1,*tmp2;
		char	*env;
		char	direct[512];
		int	len;
		unsigned long trans;

		direct[0] = '\0';

		if(dolog)hack$signal(DELTREE__DEEPDIR_msg_hack,1,strip(st));
#ifdef DEBUG
	        if(dodebug)printf("Directory String %s\n",st);
#endif

		/* Copy directory, skip first slash, chage to dots	*/
		ptr	 = (char *) malloc(sizeof(char *)*(strlen(st)));
		strcpy(ptr,st+1);

		for(disk = ptr ; (disk = strchr(disk,'/')) != NULL ; disk++)
				*disk = '.';


		/* Get disk and directory name				*/
		disk	= (char *) malloc(sizeof(char *)*(strlen(ptr)));
		strcpy(disk,ptr);
#ifdef DEBUG
		if(dodebug)printf("Copying %s\n",disk);
#endif
		tmp1	= strchr(disk,'.');
		tmp2	= strrchr(disk,'.');
		if(tmp1 == NULL || tmp2 == NULL){
			chdir(original);
			hack$signal(DELTREE__BUGCHK_msg_hack,1,__LINE__);
			abort();
		}
		*tmp1	= '\0';
		*tmp2	= '\0';
		tmp2++;

		if( (env = getenv(disk)) == NULL_C){
			/* was not a logical				*/
			if(dodebug)hack$signal(DELTREE__GETENV_msg_hack,1,"(null)");
			len	= strlen(disk);
			strcpy(direct,disk);
			direct[len++] = ':';
			direct[len++] = '[';
			direct[len]   = '\0';
			tmp1++;
			strncat(direct,tmp1,BUFSIZ);
#ifdef DEBUG
			if(dodebug)printf("deltree :: Now have %s\n",direct);
#endif
		} else {
			/* Was a logical				*/
			strcpy(direct,env);
			if(dodebug)hack$signal(DELTREE__GETENV_msg_hack,1,direct);
			direct[strlen(direct)-1] = '\0';

			/* Strip out an eventual .000000. if any	*/
			if( 	*(tmp1+1)	== '0' &&
				*(tmp1+2)	== '0' &&
				*(tmp1+3)	== '0' &&
				*(tmp1+4)	== '0' &&
				*(tmp1+5)	== '0' &&
				*(tmp1+6)	== '0' ){
				tmp1	= tmp1+7;
			}
			/* Skip first dot				*/
			tmp1++;
			strncat(direct,tmp1,BUFSIZ);
		}
		/* strcat() did not work here				*/
		len		= strlen(direct);
		direct[len++]	= '.';
		direct[len++]	= ']';
		direct[len]	= '\0';


#ifdef DEBUG
		if(dodebug){
			printf("Ptr  is %s\n",ptr);
			printf("Disk is %s\n",disk);
			printf("Dir  is %s\n",tmp2);
			printf("Dirf is %s\n",direct);
			printf("Len  is %d\n",len);
		}
#endif


		/* Define the logical					*/
		/* Sets logical, change directory, recursively delete
		   files and come back					*/
		value.dsc$a_pointer	= (void *) direct;
		value.dsc$w_length	= len+1;

		trans	= LNM$M_CONCEALED | LNM$M_TERMINAL;
#ifdef DEBUG
		if(dodebug)printf("Setting logical to %s\n",direct);
#endif
		lib$set_logical(&logical, &value, &parent, &trans);


		/* Just in case ...					*/
		expectedcd = (char *) malloc(sizeof(char *)*(strlen(st)+1));
		strcpy(expectedcd,st);
#ifdef DEBUG
		if(dodebug)printf("expectedcd is %s\n",expectedcd);
#endif

		tsave_tree = (char *) malloc(sizeof(char *)*strlen("deltree_newtop/"));
		strcpy(tsave_tree,"deltree_newtop/");
		chdir("DELTREE_NEWTOP:[000000]");
		level++;
		if(! rm_tree(tmp2) && dolog){
			if(dolog)hack$signal(DELTREE__DEEPFAIL_msg_hack);
		} else {
			if(dodebug)hack$signal(DELTREE__DEEPOK_msg_hack);
		}
		level--;
		free(tsave_tree);
		tsave_tree	= save_tree;

		/* Note that we need to pretend that we changed directory */
		/* so old-root is the directory we received		*/
		if(chdir(expectedcd) != 0){
			chdir(original);
			hack$signal(DELTREE__CHDIR_msg_hack,1,__LINE__);
			abort();
		}
		free(expectedcd);
		free(ptr);
		free(disk);
		return 0;
	} else {
		if(dolog)hack$signal(DELTREE__TOODEEP_msg_hack,1,st);
		return -1;
	}
 } else {
	/* Try to do that but it might fail				*/
#ifdef DEBUG
 	if(dodebug)
	 hack$signal(DELTREE__DEBUG_msg_hack,2,"dochdir()",st);
#endif

	return chdir(st);
 }
}




/* --------------------------------------------------------------------	*/
/* Routines to get the arguments from the command line			*/
/* --------------------------------------------------------------------	*/

void get_args(void)
{
unsigned int	status;
char		what[DIM];

#if defined(__DECC) || defined(__GNUC__)
extern char	*DELTREE;
#else
globalref	DELTREE;
#endif

struct dsc$descriptor line_str_d={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0};
$DESCRIPTOR(command,"DELTREE ");
$DESCRIPTOR(filin_d,"INFILE");

	lib$get_foreign(&line_str_d);
	str$concat(&line_str_d,&command,&line_str_d);
	status = cli$dcl_parse(&line_str_d,&DELTREE);
	if (! OK(status) ) exit(status);

	if( CLI_PRESENT("HELP") == CLI$_PRESENT)	exit_lhelp(SS$_NORMAL);
	if( CLI_PRESENT("VERSION") == CLI$_PRESENT){
		svrs = TRUE;
		return;
	}

	if( OK(CLI_GET_VALUE("PRIORITY",what)) )	prio = atoi(what);

	/* I would also like to have those qualifier enabled before /DETACH */
	status = CLI_PRESENT("DEBUG");
	if( status == CLI$_PRESENT)	dodebug	= TRUE;
	if( status == CLI$_NEGATED)	dodebug	= FALSE;

	if( OK( CLI_GET_VALUE("PRIVILEGES",what) ) ){
	 privs	= (char *) malloc(sizeof(what));
	 if( privs == NULL ) hack$exit(DELTREE__INSFMEM_msg_hack);
	 strcpy(privs,what);
	 while( OK(CLI_GET_VALUE("PRIVILEGES",what)) ){
         	privs = (char *) realloc( (void *) privs,sizeof(what)+1);
 		if( privs == NULL) hack$exit(DELTREE__INSFMEM_msg_hack);
 		strcat(privs,",");
		strcat(privs,what);
         }
	} else {
	 privs = NULL;
	}


	status = CLI_PRESENT("DETACH");
	if( status == CLI$_PRESENT){
		/* No need to go further */
		detach_command(line_str_d,prgm_nam,prio);
		return;
	}


	/* if( CLI_PRESENT("TREE") == CLI$_PRESENT) */


	status = CLI_PRESENT("LOG");
	if( status == CLI$_PRESENT)	dolog	= TRUE;
	if( status == CLI$_NEGATED)	dolog	= FALSE;

	/* This keyword is the new supported one. DELETE command has	*/
	/* it and therefore /ALL will be possible without major CLD	*/
	/* Modifications.						*/
	status = CLI_PRESENT("ALL");
	if( status == CLI$_PRESENT)	alldir	= TRUE;
	if( status == CLI$_NEGATED)	alldir	= FALSE;

	status = CLI_PRESENT("TOP");
	if( status == CLI$_PRESENT)	topdir	= TRUE;
	if( status == CLI$_NEGATED)	topdir	= FALSE;

	status = CLI_PRESENT("CONFIRM");
	if( status == CLI$_PRESENT)	doconf	= TRUE;
	if( status == CLI$_NEGATED)	doconf	= FALSE;

	if( ! OK( CLI_GET_VALUE("INFILE",what) ) ){
	 exit_lhelp(-1);
         hack$exit(DELTREE__NODIR_msg_hack);
	} else {
	 afilin	= (char *) malloc(sizeof(what));
	 if( afilin == NULL ) hack$exit(DELTREE__INSFMEM_msg_hack);
	 strcpy(afilin,what);
	 while( OK(CLI_GET_VALUE("INFILE",what)) ){
         	afilin	= (char *) realloc( (void *) afilin,sizeof(what)+1);
 		if( afilin == NULL) hack$exit(DELTREE__INSFMEM_msg_hack);
 		strcat(afilin,",");
		strcat(afilin,what);
         }
	}
}

unsigned int CLI_PRESENT(char *item)
{
DDESCR(item_d);

	IDESCR(item_d,item);
	return cli$present(&item_d);
}

unsigned int CLI_GET_VALUE (char *item, char *retv) {
DDESCR(item_d);
DDESCR(retv_d);
unsigned int status;

	IDESCR(item_d,item);

	status = cli$present(&item_d);
	if ( OK(status) ) {
		status = cli$get_value(&item_d, &retv_d);
		if (OK(status)){
			strncpy(retv,retv_d.dsc$a_pointer,retv_d.dsc$w_length);
			*(retv+retv_d.dsc$w_length) = '\0';
		}
	}
	return status;
}



/* -------------------------------------------------------------------	*/
/*   Original Author       : JLAURET					*/
/*   Date                  : 20-OCT-1995 				*/
/* ----------------------- :                                            */
/*   Purpose of Revision   : Got rid of pointer on int and void now	*/
/* -------------------------------------------------------------------	*/
#ifdef VMS
# define CLK_SCALE CLK_TCK
#else
# define CLK_SCALE CLOCKS_PER_SEC
#endif


/* Pointer on integer so we can use it in FORtran 			*/
void cpu_time(int what,char *dev,char *dir)
{
clock_t	lc;

	lc = clock();
	if (what == 0) {
		if(lc < 0)hack$exit(DELTREE__CLKINIT_msg_hack);
		init_time = lc;
	} else {
		char	st[DIM];
		lc = lc - init_time;
		sprintf(st,"%.1f",(float) lc/CLK_SCALE);
		hack$signal(DELTREE__STAT_msg_hack,3,total,dev,dir,st);
	}
}




/* -------------------------------------------------------------------	*/
/* Don't panic. Formated with TEXT2C					*/
/* -------------------------------------------------------------------	*/
void	exit_lhelp(int sts)
{
#include "deltree_help.c"
if(sts != -1) exit(sts);
}



/* ----------------------- : 						*/
/*   Date of Revision      : 1998 					*/
/*   Change Author         : JLAURET					*/
/*   Purpose of Revision   : Added the .*;* files 			*/
/*                         : Remains the deep tree problem		*/
/* ----------------------- : 						*/
/*   Date of Revision      : 20-JAN-1999 				*/
/*   Change Author         : JLAURET					*/
/*   Purpose of Revision   : Made it GCC compatible			*/
/*                         : Now tested with DECC & GCC (Alpha), VAXC	*/
/* ----------------------- : 						*/
/*   Date of Revision      : 29-JAN-1999 				*/
/*   Change Author         : JLAURET					*/
/*   Purpose of Revision   : Added Cli interface and options		*/
/*                         : 						*/
/* ----------------------- :                                            */
/*   Date of Revision      :  9-APR-1999                                */
/*   Change Author         : JLAURET                                    */
/*   Purpose of Revision   : Added deep tree mechanism.                 */
/*                         :                                            */
/* ----------------------- :                                            */
/*   Date of Revision      : 28-JUN-1999                                */
/*   Change Author         : JLAURET                                    */
/*   Purpose of Revision   : GCC small cleanup.				*/
/*                         :                                            */
/* ----------------------- :                                            */
/*   Date of Revision      : 19-JUL-1999                                */
/*   Change Author         : JLAURET                                    */
/*   Purpose of Revision   : Oups ! I found a bug (a strcpy() to an	*/
/*                         : unallocated pointer)			*/
/* ----------------------- :                                            */
/*   Date of Revision      :  5-AUG-1999                                */
/*   Change Author         : JLAURET                                    */
/*   Purpose of Revision   : Some message changed from -W- to -I-	*/
/* 						  from -I- to -S-       */
/*                         :                                            */
/* ----------------------- :                                            */
/*   Date of Revision      : 13-AUG-1999                                */
/*   Change Author         : JLAURET                                    */
/*   Purpose of Revision   : Added extended path syntax + multiple	*/
/*                         : argument list.				*/
/* ----------------------- :                                            */
/*   Date of Revision      : 20-AUG-1999                                */
/*   Change Author         : JLAURET                                    */
/*   Purpose of Revision   : Added /VERSION and /DETACH			*/
/*                         :                                            */
/* ----------------------- :                                            */
/*   Date of Revision      : 27-AUG-1999                                */
/*   Change Author         : JLAURET                                    */
/*   Purpose of Revision   : Added /PRIV                                */
/*                         :                                            */
/* ----------------------- :                                            */
/*   Date of Revision      : 11-SEP-1999                                */
/*   Change Author         : JLAURET                                    */
/*   Purpose of Revision   : Changed .OUT in .LOG + fix problem	with	*/
/*                         : large pid					*/
