.ifdef __AXP__
ARCH    = AXP
.else
ARCH    = VAX
.endif

.ifdef GNUC
CC      = GCC
CFLAGS	=
POST    = _GNU
OPT	= GNUC_$(ARCH).OPT
LINKFLAGS= ,[]$(OPT)/OPT
.else
CC      = CC
CFLAGS	= 
POST    =
OPT	=
LINKFLAGS=
.endif

OBJDIR  = [.OBJ]
CFLAGS	= $(CFLAGS)/OPTIMIZE
EXE     = EXE_$(ARCH)$(POST)
OBJ     = OBJ_$(ARCH)$(POST)

.ifdef DEBUG
.ifdef __AXP__
CFLAGS  = $(CFLAGS)/DEFINE=DEBUG/CHECK=(BOUNDS,POINTER_SIZE,UNINITIALIZED_VARIABLES)
.else
.endif
CFLAGS  = $(CFLAGS)/DEFINE=DEBUG
.else
LINKFLAGS= $(LINKFLAGS)/NOTRACE
.endif




OBJECTS = $(OBJDIR)DELTREE2.$(OBJ), $(OBJDIR)DELTREE_CLI.$(OBJ),\
$(OBJDIR)DELTREE_MSG.$(OBJ), $(OBJDIR)DELTREE_U.$(OBJ)

DELTREE.$(EXE) : $(OBJECTS) $(OPT)
	LINK/EXEC=$(MMS$TARGET) $(OBJECTS) $(LINKFLAGS)
	@ purge/nolog $(OBJECTS)

$(OBJDIR)DELTREE2.$(OBJ) : DELTREE2.C DELTREE_HELP.C COMMON.H DELTREE_MSG.H DELTREE.H 
	$(CC) $(CFLAGS) /OBJECT=$(MMS$TARGET)  DELTREE2.C 

$(OBJDIR)DELTREE_U.$(OBJ) : DELTREE_U.C COMMON.H DELTREE_MSG.H 
	$(CC) $(CFLAGS) /OBJECT=$(MMS$TARGET)  DELTREE_U.C 

$(OBJDIR)DELTREE_CLI.$(OBJ) : DELTREE_CLI.CLD
	SET COMMAND/OBJECT=$(MMS$TARGET) $(MMS$SOURCE)

$(OBJDIR)DELTREE_MSG.$(OBJ) : DELTREE_MSG.MSG
	MESSAGE/OBJECT=$(MMS$TARGET) $(MMS$SOURCE)

DELTREE_MSG.H : DELTREE_MSG.MSG GEN_MSGH.COM
	@GEN_MSGH.COM $(MMS$SOURCE) $(MMS$TARGET) "DELTREE__"


DELTREE_HELP.C : DELTREE_HELP.TXT
	TEXT2C DELTREE_HELP.TXT DELTREE_HELP.C

CLEAN :
	@ if f$search("*.$(OBJ)").nes."" then delete/nolog/noconfirm *.$(OBJ);*


$(OPT) :
	@ WRITE SYS$OUTPUT "Creating $(MMS$TARGET)"
	@ OPEN/WRITE FILOUT $(MMS$TARGET)
.ifdef __AXP__
	@ WRITE FILOUT "GNU_CC_LIBRARY:libgcc.olb/lib"
	@ WRITE FILOUT "sys$library:vaxcrtl.olb/lib"
	@ WRITE FILOUT "GNU_CC_LIBRARY:crt1.obj"
.else
	@ WRITE FILOUT "GNU_CC:[000000]GCCLIB/LIB"
	@ WRITE FILOUT "SYS$SHARE:VAXCRTL.EXE/SHARE"
.endif
	@ CLOSE FILOUT


TEST : DELTREE.$(EXE) 
	@TEST_DELTREE.COM $(EXE)



