#include "b00ger-rpc.h"

pid_t wait (int *status);

int
main (int argc, char **argv)
{
  char ipS[20];
  struct in_addr ip;
  int childs = 0, n, localip;

  infoz ();

  if ((n = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    {
      fprintf (stderr, "Can't open a socket.\n");
      exit (-1);
    }

  ip = walk_interface_list (n);
  localip = ip.s_addr;

#ifdef DEBUG
  fprintf (stderr, "localip: %s\n", inet_ntoa (ip));
#endif
  close (n);

  while (fgets (ipS, sizeof (ipS), stdin) != NULL)
    if (inet_aton (ipS, &ip) != 0 && ip.s_addr != 0)
      {
	if (childs >= MAXCHILD)
	  wait (NULL);
	switch (fork ())
	  {
	  case 0:
	    n = scan (&ip, localip);
	    if (n > 0)
	      if (evalhost (n, inet_ntoa (ip)))
		rpcscan (ip, n);
	    exit (0);
	  case -1:
	    perror ("fork");
	    exit (-1);
	  default:
	    childs++;
	    break;
	  }
      }

  while (childs--)
    wait (NULL);

  return (0);
}

int
progscan (char *host, int hostid, int program)
{
  switch (program)
    {
    case AMD:
      printf ("  -- rpc.amd: ");
      printf ("vulnerable. (%s)\n", host);
    case RSTATD:
      printf ("  -- rpc.statd: ");
      /* EXPLOIT: SunOS remote exploitability in rstatd daemon */
      switch (hostid)
	{
	case SOLARIS:
	case SOLARIS2:
	case SOLARIS3:
	case SUNOS:
	  printf ("vulnerable. (%s)\n", host);
	  break;
	default:
	  printf ("probably not vulnerable. (%s)\n", host);
	}
      break;
    case CMSD:
      printf ("  -- rpc.cmsd: ");
      switch (hostid)
	{
	case SOLARIS:
	case SOLARIS2:
	case SOLARIS3:
	case SUNOS:
	  printf ("vulnerable. (%s)\n", host);
	  break;
	default:
	  printf ("running, but i dont know what OS. (%s)\n", host);
	}
      break;
    case TTDBSERVER:
      printf ("  -- rpc.ttdbserver: ");
      /* EXPLOIT: Solaris 2.x, SunOS, Irix remote exploitability in ttdbserver daemon */
      switch (hostid)
	{
	case SOLARIS:
	case SOLARIS2:
	case SOLARIS3:
	case SUNOS:
	case IRIX5:
	case IRIX6:
	case HPUX:
	  printf ("vulnerable. (%s)\n", host);
	  break;
	default:
	  printf ("probably vuln, but dunno if theres an exploit. (%s)\n", host);
	}
      break;
    case YPSERV:
      printf ("  -- ypserv: ");
      /* EXPLOIT: SunOS spoofing of ypserv */
      switch (hostid)
	{
	case SUNOS:
	  printf ("vulnerable. (SunOS) (%s)\n", host);
	  break;
	case SOLARIS:
	case SOLARIS2:
	case SOLARIS3:
	  printf ("possibly vulnerable. (Solaris) (%s)\n", host);
	  break;
	default:
	  printf ("running, but dunno if its vuln or not (%s)\n", host);
	  break;
	}
    case YPUPDATED:
      printf ("  -- ypupdated located. (%s)\n", host);
      /* EXPLOIT: exploit ypupdated */
      break;
    case NFSD:
      printf ("  -- nfsd located. (%s)\n", host);
      /* SECURITY: Check public remote nfs mount points */
      break;
    case REXD:
      printf ("  -- rexd located. (%s)\n", host);
    case MOUNTD:
      if ((hostid == LINUXOS) || (hostid == LINUX21))
	printf ("  -- mountd located, possible overflow. (%s)\n", host);
      else
	printf (" --mountd dunno if you can overflow it tho (%s)\n", host);
      break;
    case AUTOFSD:
      printf ("  -- autofsd: ");
      if (hostid == IRIX6)
	printf ("vulnerable. (IRIX6) (%s)\n", host);
      else if (hostid == IRIX5)
	printf ("possibly vulnerable. (IRIX5) (%s)\n", host);
      else
	printf ("dunno if its vulnerable.. (%s)\n", host);
      break;
    case PCNFSD:
      printf ("  -- pcnfsd: ");
      switch (hostid)
	{
	case SOLARIS:
	case SOLARIS2:
	case SOLARIS3:
	case SUNOS:
	case IRIX5:
	case IRIX6:
	case LINUXOS:
	case LINUX21:
	case HPUX:
	  printf ("vulnerable. (%s)\n", host);
	  break;
	default:
	  printf ("possibly vulnerable. (%s)\n", host);
	}
      break;
    default:
    }
  return (0);
}

int
evalhost (int os, char *host)
{
  printf ("%s ", host);
  switch (os)
    {
    case SOLARIS:
      printf ("RemoteOS: Sol7(Intel),2.6,2.5,2.4(Sparc)\n");
      break;
    case SUNOS:
      printf ("RemoteOS: SunOS 4.x\n");
      break;
    case IRIX5:
      printf ("RemoteOS: IRIX 5.x\n");
      break;
    case IRIX6:
      printf ("RemoteOS: IRIX 6.2\n");
      break;
    case LINUXOS:
      printf ("RemoteOS: Linux\n");
      break;
    case FBSD:
      printf ("RemoteOS: FreeBSD / OpenBSD\n");
      break;
    case DIGITAL:
      printf ("RemoteOS: Digital 4.0 or HP-UX 10\n");
      break;
    case WINDOWS:
      printf ("RemoteOS: Windows 95/98/NT4\n");
      break;
    case AIX3:
      printf ("RemoteOS: AIX 3\n");
      break;
    case AIX4:
      printf ("RemoteOS: AIX 4.1\n");
      break;
    case BSDOS:
      printf ("RemoteOS: BSDI BSD/OS\n");
      break;
    case HPUX:
      printf ("RemoteOS: HP-UX 9\n");
      break;
    case LINUX21:
      printf ("RemoteOS: Linux 2.1.122 - 2.1.130, 2.2.x\n");
      break;
    case NETWARE:
      printf ("RemoteOS: Netware 3.12 - 5.00\n");
      break;
    case OPENBSD:
      printf ("RemoteOS: OpenBSD 2.1-2.3 or WinNT5 Beta\n");
      break;
    case SOLARIS2:
      printf ("RemoteOS: Solaris2.6-2.7\n");
      break;
    case SOLARIS3:
      printf ("RemoteOS: Solaris2.3-2.5\n");
      break;
    default:
      printf ("RemoteOS: OS Unknown\n");
    }
  return (os);
}

int
infoz (void)
{
  fprintf (stderr, "\E[32m" "                   _  _  _\n");
  fprintf (stderr, "|_  _  _  _  _ ._ |_)|_)/\n");
  fprintf (stderr, "|_)(_)(_)(_|(/_|  | \\|  \\_\n");
  fprintf (stderr, "          _|\n\nReading ip's from stdin\n\n");
  fprintf (stderr, "\E[0m");

  return (0);

}

struct in_addr
walk_interface_list (int s)
{
  struct ifconf ifconf;
  struct ifreq ifs[32];
  struct in_addr want_in_addr;
  int i, count;

  want_in_addr.s_addr = INADDR_ANY;

  ifconf.ifc_len = sizeof (ifs);
  ifconf.ifc_buf = (void *) ifs;

  if (ioctl (s, SIOCGIFCONF, &ifconf, sizeof (struct ifconf)) < 0)
    {
      perror ("ioctl");
      exit (1);
    }

  /* walk the list of configured interfaces to find one which meets
   * our requirements.
   */
  count = ifconf.ifc_len / sizeof (struct ifreq);
  for (i = 0; i < count; i++)
    {
      want_in_addr = check_interface (s, &ifs[i]);
      if (want_in_addr.s_addr != INADDR_ANY)
	break;
    }

  return (want_in_addr);
}

struct in_addr
check_interface (int sock, struct ifreq *oifr)
{
  struct ifreq ifr;
  struct in_addr want_in_addr;

  want_in_addr.s_addr = INADDR_ANY;

  /* We want to return INADDR_ANY (0x00000000)
   * if we don't find an interface matching the following:
   * family AF_INET, sin_addr NOT loopback.
   *
   */

  ifr = *oifr;
  if (oifr->ifr_addr.sa_family == AF_INET)
    {
      ifr = *oifr;
      if (ioctl (sock, SIOCGIFADDR, &ifr, sizeof (ifr)) < 0)
	{
	  fprintf (stderr, "couldn't get interface's address\n");
	  perror ("ioctl");
	  return (want_in_addr);
	}
      else
	{
	  unsigned long want_ip = ((struct sockaddr_in *) (&ifr.ifr_addr))->sin_addr.s_addr;

#ifdef DEBUG
	  fprintf (stderr, "check_interface: want_ip == %08lx\n", want_ip);
#endif
	  if (ntohl (want_ip) != INADDR_LOOPBACK)
	    {
	      want_in_addr.s_addr = want_ip;
	      return (want_in_addr);
	    }
	}
    }

  /* didn't find any such interface. */
  return (want_in_addr);
}

unsigned short
inet_checksum (void *addr, int len)
{
  register int nleft = len;
  register u_short *w = addr;
  register int sum = 0;
  u_short answer = 0;

  /*
   *  Our algorithm is simple, using a 32 bit accumulator (sum),
   *  we add sequential 16 bit words to it, and at the end, fold
   *  back all the carry bits from the top 16 bits into the lower
   *  16 bits.
   */
  while (nleft > 1)
    {
      sum += *w++;
      nleft -= 2;
    }

  /* mop up an odd byte, if necessary */
  if (nleft == 1)
    {
      *(u_char *) (&answer) = *(u_char *) w;
      sum += answer;
    }

  /*
   * add back carry outs from top 16 bits to low 16 bits
   */
  sum = (sum >> 16) + (sum & 0xffff);	/* add hi 16 to low 16 */
  sum += (sum >> 16);		/* add carry */
  answer = ~sum;		/* truncate to 16 bits */
  return (answer);
}
