#include "b00ger-rpc.h"

void
sighandler (int signo)
{
  exit (-1);
}

int
rpcscan (struct in_addr ip, int hostid)
{
  int sockett = RPC_ANYSOCK;
  struct sockaddr_in server_addr;
  struct pmaplist *head = NULL;
  struct timeval minutetimeout;
  register CLIENT *client;

  server_addr.sin_addr = ip;
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons (PMAPPORT);
  minutetimeout.tv_sec = TIMEOUT;
  minutetimeout.tv_usec = 0;

  /* turn alarm on */
  signal (SIGALRM, sighandler);
  alarm (TIMEOUT);

  /* make a client */
  if ((client = clnttcp_create (&server_addr, PMAPPROG, PMAPVERS, &sockett, 50, 500)) == NULL)
    {
      alarm (0);
      signal (SIGALRM, SIG_DFL);
      exit (-1);
    }

  /* turn alarm off */
  alarm (0);
  signal (SIGALRM, SIG_DFL);

  /* get the portmapper list into the linked list head ptr "head" */
  if (clnt_call (client, PMAPPROC_DUMP, (xdrproc_t) xdr_void, NULL,
  (xdrproc_t) xdr_pmaplist, (caddr_t) & head, minutetimeout) != RPC_SUCCESS)
    exit (-1);

  /* traverse the RPC linked list, calling external scan function */
  if (head != NULL)
    {
      for (; head != NULL; head = head->pml_next)
	{
	  switch (head->pml_map.pm_prog)
	    {
	    case YPSERV:
	    case YPUPDATED:
	    case CMSD:
	    case REXD:
	    case NFSD:
	    case PCNFSD:
	    case RSTATD:
	    case MOUNTD:
	    case AUTOFSD:
	    case TTDBSERVER:
	    case AMD:
	      progscan (inet_ntoa (ip), hostid, head->pml_map.pm_prog);
	      break;
	    default:
	    }
	  while ((head->pml_next != NULL) && (head->pml_map.pm_prog == head->pml_next->pml_map.pm_prog))
	    head = head->pml_next;
	}
    }

  /* destroy portmap client */
  clnt_destroy (client);

  return (1);
}
