/* 
 *  the portscanning stuff in here is mostly from
 *  UNYUN's portscanner.
 */

#include "b00ger-rpc.h"

void
recvfrom_timeout() {
	alarm(0);
	signal (SIGALRM, SIG_DFL);
	exit(-1);
}

int
send_packet(int socket,
               struct sockaddr_in *target_addr,
               struct sockaddr_in *your_addr,
               unsigned char session_flags,unsigned long sequence)
{
    struct iphdr        *ip_header;
    struct tcphdr       *tcp_header;    
    struct pseudohdr    *pseudo_header;
    char                send_buf[40];
    int                 send_length;
    int                 sent_length;

    memset(send_buf,0,40);
    ip_header     = (struct iphdr *)send_buf;
    tcp_header    = (struct tcphdr *)(send_buf+sizeof(struct iphdr));
    pseudo_header = (struct pseudohdr *)((char*)tcp_header-sizeof(struct pseudohdr));

    pseudo_header->saddr     = your_addr->sin_addr.s_addr;
    pseudo_header->daddr     = target_addr->sin_addr.s_addr;
    pseudo_header->protocol  = IPPROTO_TCP;   
    pseudo_header->tcplength = htons(sizeof(struct tcphdr));  
        
    tcp_header->th_sport = your_addr->sin_port;
    tcp_header->th_dport = target_addr->sin_port;
    tcp_header->th_off   = 5;
    tcp_header->th_flags = session_flags;
    tcp_header->th_seq   = htonl(sequence);
    tcp_header->th_ack   = htonl(0);
    tcp_header->th_win   = htons(512);
    tcp_header->th_sum   = inet_checksum((u_short *)pseudo_header,sizeof(struct pseudohdr)+sizeof(struct tcphdr));

    memset(send_buf,0,sizeof(struct iphdr));
    ip_header->saddr    = your_addr->sin_addr.s_addr;
    ip_header->daddr    = target_addr->sin_addr.s_addr;
    ip_header->version  = 4;
    ip_header->ihl      = 5;
    ip_header->ttl      = 255;
    ip_header->id       = rand()%0xffff;
    ip_header->protocol = IPPROTO_TCP; 
    ip_header->tot_len  = htons(sizeof(struct iphdr)+sizeof(struct tcphdr));
    ip_header->check    = inet_checksum((u_short *)ip_header,sizeof(struct iphdr));
        
    send_length=sizeof(struct iphdr)+sizeof(struct tcphdr);
    sent_length=sendto(socket,send_buf,send_length,0,
                       (struct sockaddr *)target_addr,sizeof(struct sockaddr));
    if (send_length != sent_length) exit(-1);
    else return(0);
}

int
scan(struct in_addr *host, unsigned long localip)
{
    struct iphdr       *ip_header;
    struct tcphdr      *tcp_header;
    struct sockaddr_in target_info;
    int                target_info_len;
    fd_set             read_fd;
    unsigned char      scan_flag;
    char               recvbuf[2500];
    struct sockaddr_in target_addr;
    struct sockaddr_in your_addr;
    struct timeval tv;
    int                raw_socket;
    int                tcp_socket;
    int                result = 0;	
    int                i = 0,n = 0;
    static struct{
        unsigned int    WindowSize;
        int       OSname;
    }OSfeatures[]={
		                           /** THIS NEEDS UPDATED!@# **/

                   {0x9823,SOLARIS},	/* Sol7(Intel),2.6,2.5,2.4(Sparc) */
                   {0x0010,SUNOS},      /* SunOS4.1 (Sparc)               */
                   {0x00f0,IRIX5},      /* IRIX 5.3(Indy),6.3(O2)         */ 
                   {0x00c0,IRIX6},      /* IRIX 6.2(IMPACT)               */
                   {0xe07f,LINUXOS},    /* TurboLinux3.0 (Intel)          */
                   {0x0040,FBSD},       /* FreeBSD 2.2.7 or NetBSD 1.3    */
                   {0x0080,DIGITAL},    /* Digital 4.0 or HP-UX B1.10.20  */
                   {0x8021,WINDOWS},    /* Windows 95/98/NT4              */
                   {0x253f,AIX3},       /* AIX 3                          */
                   {0x433e,AIX4},       /* AIX 4.1                        */
                   {0xafff,AIX4},       /* AIX 4.1                        */
                   {0x253f,AIX4},       /* AIX 4.1                        */
                   {0x1720,BSDOS},      /* BSDI BSD/OS 2.1, 3.0           */
                   {0x0020,HPUX},       /* HP-UX 9                        */
                   {0x2e40,FBSD},       /* FreeBSD 2.2.1 - 3.0            */
                   {0x3d40,FBSD},       /* FreeBSD 2.2.1 - 3.0            */
                   {0x5c80,DIGITAL},    /* D UNIX OSF1 V 4.0,4.0B,4.0D    */
                   {0x2aef,IRIX5},      /* IRIX 5.3                       */
                   {0x00c0,IRIX6},      /* IRIX6.4 or 6.5                 */  
                   {0x003c,LINUXOS},    /* Linux 2.0.28                   */
                   {0x007c,LINUXOS},    /* Linux 2.0.30                   */  
                   {0xe07f,LINUXOS},    /* Linux 2.0.33-36                */
                   {0x537f,LINUX21},    /* Linux 2.1.122 - 2.1.130        */
		   {0xb87f,LINUX21},    /* Linux 2.2                      */
                   {0xff1f,NETWARE},    /* Novell Netware 3.12 - 5.00     */
                   {0x2e40,OPENBSD},    /* OpenBSD 2.1-2.3 or WinNT5 Beta */
                   {0x2332,SOLARIS3},   /* Solaris2.3-2.5                 */
                   {0x9722,SOLARIS2},   /* Solaris2.6-2.7                 */
                   {0x1720,WINDOWS},    /* Windows 95/98/NT4              */
                   {0x0000,0}};

    if ((tcp_socket=socket(AF_INET,SOCK_RAW,IPPROTO_TCP))==-1){
        fprintf(stderr,"Can't open a socket.\n");
        exit(-1);
    }
    if ((raw_socket=socket(AF_INET,SOCK_RAW,IPPROTO_RAW))==-1){
        fprintf(stderr,"Can't open a raw socket.\n");
        exit(-1);
    }

    scan_flag = TH_SYN;

    ip_header    = (struct iphdr *)recvbuf;
    tcp_header    = (struct tcphdr *)(recvbuf+sizeof(struct iphdr));
    target_addr.sin_family         = AF_INET;
    target_addr.sin_addr           = *host;
    target_addr.sin_port           = htons(PORTMAP_PORT);

    your_addr.sin_addr.s_addr      = localip;
    your_addr.sin_port             = htons(SRC_PORT);

    send_packet(raw_socket,&target_addr,&your_addr,scan_flag,100);
    FD_ZERO(&read_fd);
    FD_SET(tcp_socket,&read_fd);
    tv.tv_sec = TIMEOUT;
    tv.tv_usec = 0;

    if((n = select(FD_SETSIZE,&read_fd,NULL,NULL,&tv)) <= 0)
     {
      close(tcp_socket);
      close(raw_socket);
      exit (-1);
     }

    for (;;){
        if (FD_ISSET(tcp_socket,&read_fd)){

            target_info_len = sizeof(target_info);

signal (SIGALRM, recvfrom_timeout);
alarm(TIMEOUT);

           if(recvfrom(tcp_socket,recvbuf,2500,0,
              (struct sockaddr *)&target_info,&target_info_len)<=0)
		{
		 alarm(0);
		 signal (SIGALRM, SIG_DFL);
		 close(tcp_socket);
		 close(raw_socket);
                 exit(0);
		}

            if (target_info.sin_addr.s_addr == target_addr.sin_addr.s_addr)
                if (ntohs(tcp_header->th_dport) == SRC_PORT
                 && ntohs(tcp_header->th_sport) == PORTMAP_PORT){

#ifdef DEBUG
                    if (tcp_header->th_flags & TH_RST) printf("RST\n");
                    if (tcp_header->th_flags & TH_ACK) printf("ACK\n");
#endif
                    if (tcp_header->th_flags & TH_SYN){
                     if (scan_flag & TH_SYN)
                        {
                          for (i = 0;; i++)
                            {
                              result = 1;
                              if (OSfeatures[i].OSname == 0)
                              break;
                              if (OSfeatures[i].WindowSize == tcp_header->th_win)
			      break;
                            }
                        }                         
                    }
#ifdef DEBUG
                    printf("\nTTL = %d\nTCP window size = %xH id = %d\n\n",
 ip_header->ttl,tcp_header->th_win,i);
#endif
                    if (ip_header->ttl < 65
                     && tcp_header->th_win > 0
                     && scan_flag & TH_ACK) result=1;

                    if (!(tcp_header->th_flags & TH_RST))
                        send_packet(raw_socket,&target_addr,&your_addr,
                                    TH_RST, 101);
                    break;
               }
        }
    }

 close(tcp_socket);
 close(raw_socket);
 alarm(0);
 signal (SIGALRM, SIG_DFL);

 if (result==1) return(OSfeatures[i].OSname);
  
 exit(-1);

}
