unit NLTools;

interface

uses
  Windows;

  function      FindWCaption (const pCaption: ShortString): HWND;
  function      FindSubWCaption (pParent: HWND; const pCaption: ShortString): HWND;

  function      ChangeSubWCaption (const pWindowCaption, pOldCaption,
                    pNewCaption: ShortString): Boolean;
                // change pOldCaption into pNewCaption for a window identified
                // by pWindowCaption

implementation

uses
  SysUtils, Messages;

var
  GCaption      : ShortString;
  GWindow       : HWND;

  function      FWC_WProc (pHandle: HWND; pRecursive: LPARAM): BOOL; stdcall;
  var
    wText       : array [0 .. 255] of Char;

  begin
    // if a window has already been found, exit immediately
    if GWindow = 0 then
      Result := True
    else
      begin
        Result := False;
        Exit;
      end;

    if pHandle <> 0 then
      begin
        if GetWindowText (pHandle, @wText, Pred (SizeOf (wText))) <> 0 then
          if UpperCase (wText) <> UpperCase (GCaption) then
            Result := True        // continue with the next window
          else
            begin
              GWindow := pHandle; // this is the desired window
              Result := False;    // stop the enumeration
            end;

        if pRecursive <> 0 then
          EnumChildWindows (pHandle, @FWC_WProc, pRecursive + 1);
      end;
  end;

  function      FindWCaption;
  begin
    GWindow := 0;

    GCaption := pCaption;
    EnumWindows (@FWC_WProc, 0);

    Result := GWindow;
  end;

  function      FindSubWCaption;
  begin
    GWindow := 0;

    GCaption := pCaption;
    EnumChildWindows (pParent, @FWC_WProc, 1);

    Result := GWindow;
  end;

  function      ChangeSubWCaption;
  var
    main,
    subw        : HWND;
    temp        : array [0 .. 255] of Char;

  begin
    Result := False;

    main := FindWCaption (pWindowCaption);
    if main = 0 then
      Exit;

    subw := FindSubWCaption (main, pOldCaption);
    if subw = 0 then
      Exit;

    StrPLCopy (@temp, pNewCaption, Pred (SizeOf (temp)));
    SetWindowText (subw, @temp);

    Result := True;
  end;

end.

