/*
 * Define structures for tracking usage and prototypes for counter routines.
 */
struct client_counter {
    int ndx;				/* Thread index tag */
    int port;
    unsigned char *address;
    char *method;			/* Request method */
    char *ident;
};
struct host_counter {
    struct host_counter *next;
    char *class_name;
    int count;
    char mask[4096];
};
struct counter_block {
    int active_size;			/* storage allocated for active list */
    int active_sp;			/* Number active */
    int *active_hist;			/* histogram of concurrent clients */
    struct client_counter *active_stack;

    struct host_counter *host;
    char zero_time[40];			/* Time counters zeroed, formatted */
    /*
     * Keep-alive histogram keep statistics for "connection: keep-alive" headers.
     *    ka_hist[0]	Total number of times server kept alive a connection
     *			(i.e. sent a connection: keep-alive header).
     *    ka_hist[i]    Number of times a valid request was received by the
     *			i'th connection in a keep-alive sequence.
     */
    int ka_histogram_size;		/* Size of keepalive histogram */
    int *ka_hist;			/* histogram */
    int ka_offered;			/* requests with cnx keep-alive headers */
    long cputim;			/* cpu ticks. */
} *http_counters;

int http_enable_active_counters();
int http_open_active_counter ( int ndx, int port, unsigned char *address, 
	int *lock_state );
int http_set_active_counter ( int ndx, char *method, char *request, int *lk_state );
int http_close_active_counter ( int ndx );
int http_define_host_counter ( char *class_name, char *host_mask );
int http_increment_host_counters ( unsigned char *address, int *lk_state );
#define http_increment_keepalive_counter http_increment_ka_counter
int http_increment_keepalive_counter ( int transaction_number, int *lk_state );
int http_lock_counters();
int http_unlock_counters();
int http_zero_counters(int have_lock);
