#include <stdio.h>
#include <stdlib.h>
#include <unixlib.h>
#include <descrip.h>
#include "fast_utc.h"
#include <string.h>

int LIB$INIT_TIMER(), LIB$SHOW_TIMER();

int main ( int argc, char **argv )
{
    $DESCRIPTOR(source_time,"");
    int status, SYS$BINTIM(), vms_time[2], i;
    struct tm *gmt;
    time_t unix_time, gmt_time;

    status = futc_initialize(1);
    printf("status of futc_init: %d\n", status );
    if ( argc < 2 ) { printf("Usage: testutc timestr\n"); exit(1); }
    source_time.dsc$w_length = strlen ( argv[1] );
    source_time.dsc$a_pointer = argv[1];

    status = SYS$BINTIM ( &source_time, vms_time );
    printf("Status of bintim: %d\n", status );
    printf("100,000 iterations for all tests\n");
    LIB$INIT_TIMER();
    for ( i=0; i < 100000; i++ ) unix_time = decc$fix_time ( vms_time );
    LIB$SHOW_TIMER();
    printf("Unix time (decc$fix_time): %d\n", unix_time );

    LIB$INIT_TIMER();
    for ( i=0; i < 100000; i++ ) gmt_time = futc_local_to_gmt ( unix_time );
    LIB$SHOW_TIMER();
    printf("GMT time (futc_local_to_gmt): %d\n", gmt_time );

    LIB$INIT_TIMER();
    for ( i=0; i < 100000; i++ ) if ( !(gmt = gmtime ( &unix_time )) ) break;
    LIB$SHOW_TIMER();
    if ( gmt ) printf("gmt: %d/%d/%d %02d:%02d:%02d\n", gmt->tm_mday, 
	gmt->tm_mon,
	gmt->tm_year+1900, gmt->tm_hour, gmt->tm_min, gmt->tm_sec );
    else printf("error after %d calls to gmtime: %s", i, ctime(&gmt_time) );
    LIB$INIT_TIMER();
    for ( i=0; i < 100000; i++ ) if ( !(gmt = localtime ( &unix_time )) ) break;
    LIB$SHOW_TIMER();
    if ( gmt ) printf("lcl (localtime(unix_time)): %d/%d/%d %02d:%02d:%02d\n", gmt->tm_mday, 
	gmt->tm_mon,
	gmt->tm_year+1900, gmt->tm_hour, gmt->tm_min, gmt->tm_sec );
    else printf("error after %d calls to localtime\n", i );
    return 1;
}
