#include <stdio.h>
#include "pthread_1c_np.h"
#include "tutil.h"
#include "tserver_tcp.h"

int tlog_init(char *), tlog_initlog(int,char*);
int tlog_putlog ( int, char *, ... );

#include "mini_server.h"

static int my_log ( int level, char *fmt, ... )
{
    return 1;
}

static int new_request ( struct mini_request *req )
{
    printf("New request, remote port: %d\n", req->remote_port );
    ts_tcp_write ( req->tcp_ctx, "200 OK\r\nContent-type: text/plain\r\n\r\n",
		36 );
    printf("Method: '%s' path: '%s' protocol: '%s'\n",
	req->method, req->path, req->protocol );
    ts_tcp_write ( req->tcp_ctx, "Mini-server test case\r\n", 23 );
    return 1;
}

int main ( int argc, char **argv )
{
    int status, exit_status;
    pthread_t server;
    struct mini_server_parameters param;

    status = tlog_init ( "sys$output" );
    printf("Logfile init status: %d\n", status);
    status = tlog_initlog ( 1, "sys$output" );
    tlog_putlog ( 1, "Mini server test mode!/" );

    param.port_number = 8000;
    param.client_limit = 8;
    param.client_thread_stacksize = 200000;
    param.request_time_limit = 60;
    param.response_time_limit = 1200;
    param.log_level = 5;
    param.logger = tlog_putlog;
    status = mini_server_start ( &param, new_request, &server );

    printf ( "status of server start: %d\n", status );

    pthread_join ( server, (void *) &exit_status );

    return 1;
}
