/*
 * User routines for catalogue-based data storage.
 */
typedef void *volptr;
typedef void *objptr;
/*
 * Following routines are defined in cds_volume.c.  They should be called
 * at a global one-time basis rather than a concurrent multi-threaded based.
 */
int cds_initialize ( char *volume_path, int object_limit,
	int data_limit, char errmsg[256] );

volptr cds_mount ( char *volume_path,
	int attr_count, char **attr, char errmsg[256] );

int cds_dismount ( volptr vol, int force );
/*
 * Following routines are used to access the individual data objects that
 * are catalogued on a cds volume.  Routines are defined in cds_catalogue.c.
 * Each catalogue entry includes the header structure defined below.
 */
struct cds_header {
    long number;		/* internal object number */
    long state;
    long access_window[2];
    long ref_count;		/* Number of current opens on entry */
    long size;
    long mod_time;
    long reserved;
};

objptr cds_open_entry ( volptr vol, 	/* catalog handle */
	char *name,			/* key to entry */
	int create_if,			/* If true, create if not found */
	struct cds_header *,		/* Header for entry (returned) */
	char errmsg[256] );		/* Error explanation */

int cds_close_entry ( objptr object, 
	int dispose_code,		/* 0-keep, 1-delete, 2-delete_if */
	struct cds_header *header,	/* new header for entry if not null */
	char errmsg[256] );

int cds_rename ( objptr, char *new_name, int truncate );

objptr cds_catalogue_scan ( volptr vol, 
	int *context, 			/* Initialize to zero */
	struct cds_header * );		/* Open for read */

int cds_read ( objptr object, char *buffer, int bufsize, int *bytes );
int cds_write ( objptr object, char *buffer, int bufsize );

