/*
 * Support functions for managing object number allocations.  Caller is
 * assumed to have acquired the volume lock prior to calling these routines.
 */
int cds_allocate ( struct cds_volume *vol, int *number );
int cds_deallocate ( struct cds_volume *vol, int number );
int cds_flush_bitmap ( struct cds_volume *vol, int delete_flag );
/*
 * Return value for lock/unlock is previous lock count or -1 for error.
 */
int cds_lock_number ( struct cds_volume *vol, int number );
int cds_unlock_number ( struct cds_volume *vol, int number );
/*
 * Following function maps allocated entry numbers to the corresponding
 * data file name.
 */
int cds_number_to_fname ( struct cds_volume *vol, int number, char *fname);
