/*
 * This program is intended to be run by a HTTP server script in order to
 * convert the CGILIB environment to the Process Software CGI environment.
 *
 * The HTTP request information is obtained by getting the values of P1, P2, 
 * and P3 (method, path, protocol).  The script running this program should 
 * not modify these symbols.
 *
 * After running this program, the script should define sys$output as net_link:
 * and invoke the script.
 *
 * Usage:
 *    purveyor_env
 *
 * The filename_symbol is the name of a DCL symbol to receive the filename
 * of file containing the request content or "_NL:" if no content.
 *
 * Example:
 *	$ run sys$disk:[]purveyor_env
 *      $ set noon
 *      $ define sys$output/user net_link:
 *      $ run myscript
 *      $ tfile = f$trnlnm("WWW_IN")
 *	$ if "''tfile'" .nes. "_NL:" then delete "''tfile';"
 *      
 *
 * Author: David Jones
 * Date:   28-APR-1999
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <descrip.h>
#include <libclidef.h>

#include "scriptlib.h"
#include "cgilib.h"
static $DESCRIPTOR(logname,"WWW_IN");
int LIB$SET_LOGICAL(), LIB$GET_SYMBOL();

int main ( int argc, char **argv )
{
    int i, status, table, length, virtual_argc;
    char *virtual_argv[4], *base_prefix, *form_prefix;
    char param_name[4], param_value[256], fname[256];
    $DESCRIPTOR(pname,"");
    $DESCRIPTOR(pvalue,"");
    $DESCRIPTOR(fname_dx,"");
    /*
     * Build dummy argument list from P1 through P3 to get the values WWWEXEC 
     * passed to the script.
     */
    virtual_argc = 4;
    virtual_argv[0] = argv[0];		/* for lack of anything better! */
    pname.dsc$w_length = 2;
    pname.dsc$a_pointer = param_name;
    pvalue.dsc$w_length = sizeof(param_value)-1;
    pvalue.dsc$a_pointer = param_value;

    for ( i = 1; i < virtual_argc; i++ ) {
	sprintf ( param_name, "P%d", i );
	length = 0;
	status = LIB$GET_SYMBOL ( &pname, &pvalue, &length );
	if ( (status&1) == 1 ) {
	    /*
	     * Allocate new buffer to hold value.
	     */
	    virtual_argv[i] = malloc ( length+1 );
	    param_value[length] = '\0';
	    strcpy ( virtual_argv[i], param_value );
	}
	else virtual_argv[i] = "";
    }
    /*
     * Load CGI environment, use low level cgi_init and set record mode
     * prior to entering output phase.
     */
    status = cgi_init_env ( virtual_argc, virtual_argv );
    if ( status&1 ) status = net_link_write ( "<DNETRECMODE>", 13 );
    if ( status&1 ) status = cgi_begin_output(1);
    /*
     * Export environment.
     */
    base_prefix = "WWW_";
    if ( (status&1) == 1 ) {
	FILE *pdata;
	char *var, buffer[4096];
	int seg, length, content_length;
	/*
	 * Convert CGI environment variables to DCL symbols.
	 */
        cgi_set_dcl_env ( base_prefix );
        /*
	 * Decode content-length and set WWW_IN logical.
	 */
	var = cgi_info ( "CONTENT_LENGTH" );
    	content_length = var ? atoi(var) : 0;
	/*
	 * Create temporary filename.
	 */
	if ( content_length > 0 ) {
	    strcpy ( fname, "PURVEYOR_ENV_XXXXXXXX.TMP" );
	    length = mkstemp ( fname );
	} else {
	    strcpy ( fname, "_NL:" );
	}
	printf("fname: '%s'\n", fname );
	fname_dx.dsc$a_pointer = fname;
	fname_dx.dsc$w_length = strlen(fname);
	status = LIB$SET_LOGICAL ( &logname, &fname_dx, 0, 0, 0 );
	/*
	 * Copy request content to file.
	 */
	if ( content_length > 0 ) {
	    pdata = fopen ( fname, "w", "mbc=64" );
	    if ( !pdata ) {
	        perror ( "Error creating content file\n" );
	        return 0;
	    }

	    for ( ; content_length > 0; content_length -= seg ) {
	        seg = (content_length > sizeof(buffer) ) ? sizeof(buffer) :
			content_length;
	        length = cgi_read ( buffer, seg );
	        fwrite ( buffer, length, 1, pdata );
	        if ( length <= 0 ) break;
	    }
	    fclose ( pdata );
	}
    }
    return status;
}
