$!
$! This command procedure handles the netserver side of the WWWPVEXEC decnet
$! object.  Emulate Purveyor script environment.
$ if f$environment("DEPTH") .lt. 2 then set nover
$!
$! Define www_root as procedure's directory if not defined otherwise.
$ if f$trnlnm("WWW_ROOT") .eqs. ""
$ then
$    root_dir = f$parse("1.;",f$environment("PROCEDURE"),,, -
	"NO_CONCEAL,SYNTAX_ONLY") - "][" - "]1.;" + ".]"
$    define www_root 'root_dir'/translation=(terminal,concealed)
$ endif
$ if f$trnlnm("WWW_SYSTEM") .eqs. "" then define www_system www_root:[system]
$ read_net = "read/end=done net_link"
$ write_net = "write net_link"
$!
$ max_reuse = f$integer("0"+f$trnlnm("WWW_SCRIPT_MAX_REUSE"))
$ reuse_count = 0
$ wwwexec_rundown_string == ""
$!
$! Connect to partner (HTTP server) and read input parameters.
$!
$ open/read/write net_link sys$net
$ request_begin:
$ read_net subfunc		! Sub-function (SEARCH, HTBIN)
$ if subfunc .eqs. "<DNETREUSE>" then goto request_begin
$ read_net method		! HTTP request method field
$ read_net protocol		! Protocol field in HTTP request
$ read_net url			! 'file' part of URL in HTTP request.
$ if f$locate("""",url) .lt. f$length(url) then gosub dquote_url
$ if reuse_count .lt. max_reuse then write_net "<DNETREUSE>"
$!
$! Dispatch on subfunc value.  We expect HTBIN to be most common case, so
$! check for it first.
$!
$ offset = f$locate(subfunc+",","HTBIN,")
$ on warning then goto done		! Make DCL symbol errors abort us.
$ if  offset .LT. 26 then goto do_'subfunc'
$ do_error:
$! Generate error response for unknown sub function.
$ call send_sts "500 server error" "Internal error in server, unsupported function."
$ goto  done_1
$!------------------------------------------------------------------------
$! Script execution.  Parse script name out of URL and search for it in
$! htbin directory, constructing execution symbol in process.
$!
$ do_htbin:
$ write_net "<DNETPATH>"
$ read_net script_path
$ script_name = f$element(0,"/",url-script_path)
$ write_net "<DNETBINDIR>"
$ read_net http_bindir
$!
$! Construct symbol to execute script, either as foreign command or DCL proc.
$!
$ script_exec = "$" + f$element(0,";",f$search(f$parse(http_bindir+script_name,".com")))
$ if script_exec .eqs. "$" then script_exec = "$" + -
	f$element(0,";",f$search(f$parse(http_bindir+script_name,".exe")))
$ stype = f$edit(f$parse(script_exec-"$",,,"TYPE"),"UPCASE")
$ if stype .eqs. ".COM" then script_exec[0,1] := "@"
$ if stype .eqs. ".PL" then goto Perl_script
$ if ( script_exec .nes. "$" )
$ then
$   set symbol/all/scope=local		! make all symbol visible
$   mcr www_system:purveyor_env
$   tfile = f$trnlnm("WWW_IN")
$   on warning then goto purv_done
$   xver = f$verify(0)
$   define sys$output net_link:
$   script_exec "''method'" "''url'" "''protocol'"
$    deass sys$output
$    xver = f$verify(xver)
$ else
$    call send_sts "404 script not found" -
	"''f$fao("Requested script (!AS) not found in htbin directory (!AS)",-
	script_name,http_bindir)'"
$ endif
$ purv_done:
$ set noon
$ if "''tfile" .nes. "_NL:" then delete 'tfile';*
$ goto done_1
$!
$ perl_script:
$   tfile = "sys$scratch:perlcgi_" + f$string(f$getjpi("0","PID")) + ".tmp"
$   write_net "<DNETRECMODE>"
$   on warning then goto perl_done
$   create/name_table cgi_env		! holds environment logicals.
$   p1 = method 
$   p2 = url
$   p3 = protocol
$   http_bindir = http_bindir-"..."
$   mcr 'http_bindir'cgi_symbols.exe cgi_env "''tfile'"
$   if f$integer("0"+f$trnlnm("CONTENT_LENGTH","CGI_ENV")) .le. 0 then tfile = "_NL:"
$   if f$type(perl) .eqs. "" .and. -
	f$search("dcl$path:perl.exe") .eqs. "" then perl = "$www_system:miniperl"
$   define/user/table=lnm$process_directory lnm$file_dev cgi_env, -
	lnm$process, lnm$job, lnm$group, lnm$system, decw$logical_names
$   perl 'f$extract(1,255,script_exec)' "''method'" "''protocol'" >net_link: <'tfile'
$   perl_done:
$   set noon
$   deassign/table=lnm$process_directory CGI_ENV
$   if tfile .nes. "_NL:" then delete 'tfile';*
$   goto done_1
$!
$!------------------------------------------------------------------------
$! Common exit point.  Clean up connection.
$!
$ done_1:
$ if wwwexec_rundown_string .nes. "" then write_net wwwexec_rundown_string
$ read_net /time_out=10/err=done line	! let server break connection first.
$ deass sys$output
$ reuse_count = reuse_count + 1
$ wwwexec_rundown_string == ""
$ if line .eqs. "<DNETREUSE>" .and. reuse_count .le. max_reuse then goto request_begin
$ done:
$ deass sys$output
$ close net_link
$ exit $status
$!--------------------------------------------------------------------------
$! Common procedure to send messages to.
$! Parameters are: P1: status, P2: text.
$!
$ send_sts: SUBROUTINE
$ set noon
$ write_net "<DNETTEXT>"
$ write_net P1
$ write_net P2
$ write_net "</DNETTEXT>"
$ endsubroutine
$!-----------------------------------------------------------------------------
$! reconstruct url symbols with quotes doubled.
$!
$ dquote_url:
$ i = 0
$ orig_url = url
$ url = f$element(0,"""",orig_url)
$ next_dquote:
$   i = i + 1
$   part = f$element(i,"""",orig_url)
$   if ( part .eqs. """" ) then return
$   url = url + """""" + part
$   goto next_dquote
