 /* **++ **
 **  FACILITY:  ** **      DIRECT.C **
 **  ABSTRACT:  ** **       tbs ** **  AUTHORS: ** **      C. K. Hung  **	Planning Research Corporation **	1150 Gemini Avenue  **	Houston, TX 77058 **	Phone: (713)282-6227  ** ** **  CREATION DATE:     7-12-89 ** **  MODIFICATION HISTORY:  ** **-- **/    /* ** **  INCLUDE FILES  ** **/    #include "global.h"  #include "direct.h"  #include "directque.h" #include "directkpd.h" #include "dx.h"  #include "filer.h" #include "inquire.h" #include signal    /* ** **  GLOBAL DECLARATION ** **/   : struct node_tag		*root,	     /**  Root directory		     **/7 			*cwdnode;    /**  Current working directory	     **/   ) enum directions dirtree_search_direction; + char dirtree_search_pattern[MAXFILESPEC+1];    /* ** **  VIRTUAL DISPLAY IDs  ** **/   ) struct display_tag 	dirtree_cmds_display; $ struct display_tag 	dirtree_display;     /* **! **  INTERNAL FUNCTION PROTOTYPING  ** **/   F     static int		traverse_tree$1(struct node_tag *, struct node_tag *,  				int, int, enum directions);   )     static int		direct_alarm_working$1();        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	    filer_direct() { G     char initial_root[MAXFILESPEC+1];		/**  Initial root directory  **/ 
     int n;     unsigned long status_flags;      int status;      char errmsg[MAXFILESPEC+1];      int (*cstat)();        /*;     **	Output 'working...' message if total processing time D     **	is longer than 3 seconds.  Needs to disable broadcast message#     **	first to avoid interference.      **/ 
 #ifndef DEBUG -     check_OK(smg$disable_broadcast_trapping ( 2                  &cntrl_info_block.pasteboard_id))  2     cstat = signal(SIGALRM, filter_alarm_working);
     alarm(1);  #endif     /*)     **	Start building the directory tree.      **	Find the root directory.      **/   :     find_root(DX_CURRENT_DIRECTORY.cur_dir, initial_root);       /*6     **	Assign new value related to the directory tree.<     **	Do not free up the memory used by the tree.  it might     **	be used the cache queue.      **/   6     if ((n = search_direct_cache(initial_root)) == -1)/     {	    /**  This is a new directory tree **/ $ 	dirtree_search_direction = advance;& 	strcpy(dirtree_search_pattern, "[]"); 	root = (struct node *)NULL;- 	status = build_dirtree(&root, initial_root);    	if (status == DX__ERROR)  	{5 	    signal_err("Insufficient virtual memory", bell); 2 	    free_dirtree(&root, (struct node_tag *)NULL); 	    return DX__ERROR; 	}     }      elseD     {	    /**  This directory tree was saved in the cache queue  **/ 	restore_from_direct_cache( B 	    n, &dirtree_search_direction, dirtree_search_pattern, &root);     }   >     traverse_tree(root, (struct node_tag *)NULL, 1, 1, dummy);       /*,     **	Set the signal back to system default     **/ 
 #ifndef DEBUG 
     alarm(0);      signal(SIGALRM, cstat);      check_OK(smg$erase_chars (.     		 &cntrl_info_block.commands_display.id,      		 &10,      		 &2,       		 &1)) )     check_OK(smg$set_broadcast_trapping ( 2                  &cntrl_info_block.pasteboard_id, $                  broadcast_routine,                   0)) #endif     /**     **	Create a directory commands display     **/   A     dirtree_cmds_display.rows = cntrl_info_block.pasteboard_rows; C     dirtree_cmds_display.width = cntrl_info_block.pasteboard_width; 6     dirtree_cmds_display.beg_y = DIRTREE_CMDS_PBD_ROW;9     dirtree_cmds_display.beg_x = DIRTREE_CMDS_PBD_COLUMN;   )     check_OK(smg$create_virtual_display ( $ 		&cntrl_info_block.pasteboard_rows,& 		&cntrl_info_block.pasteboard_width,  		&dirtree_cmds_display.id,  		&SMG$M_TRUNC_ICON, 		0,   		0)) (     check_OK(smg$paste_virtual_display (+                  &dirtree_cmds_display.id,  2                  &cntrl_info_block.pasteboard_id, (                  &DIRTREE_CMDS_PBD_ROW, +                  &DIRTREE_CMDS_PBD_COLUMN,                    0))       /*;     **	Locate current directory in the tree.  If not found, 6     **	change initial directory to the root directory.     **/        if ((cwdnode = search_node( = 	root, strchr(DX_CURRENT_DIRECTORY.cur_dir, '[')+1)) == NULL)      {  	cwdnode = root;     }   &     /**  Change default directory  **/-     setddir(cwdnode->full_path_name, errmsg);         dirtree_display.view_rows = 9 	cntrl_info_block.pasteboard_rows - DIRTREE_CMDS_RSV_LNS; C     dirtree_display.view_width = cntrl_info_block.pasteboard_width;   3     /**  Resize dirtree virtual display's size  **/   8     dirtree_display.rows += dirtree_display.view_rows-1;C     dirtree_display.width += dirtree_display.view_width-MAXDIRSPEC; ,     dirtree_display.beg_y = DIRTREE_PBD_ROW;/     dirtree_display.beg_x = DIRTREE_PBD_COLUMN;   S     signal_err("Press RETURN to change directory, or keypad-0 to return", silence);      put_dirtree_title(cwdnode); 1     if (cntrl_info_block.user_pref.display_clock) ,         write_time(dirtree_cmds_display.id);8     put_filer_pfs(DIRTREE_PFS, dirtree_cmds_display.id);  )     check_OK(smg$create_virtual_display (  		&dirtree_display.rows,   		&dirtree_display.width,  		&dirtree_display.id,   		&SMG$M_TRUNC_ICON,   		0,   		0))         paint_dirtree_display(root);  @     dirtree_display.view_beg_y = dirtree_display.view_beg_x = 1;"     check_OK(smg$create_viewport ( 		&dirtree_display.id,   		&dirtree_display.view_beg_y,   		&dirtree_display.view_beg_x,   		&dirtree_display.view_rows,  		&dirtree_display.view_width))   ?     /**  Position viewport using current working directory  **/      change_dirtree_viewport( 	    cwdnode->row, 	    cwdnode->column, ! 	    &dirtree_display.view_beg_y, " 	    &dirtree_display.view_beg_x);  (     check_OK(smg$paste_virtual_display ( 	    &dirtree_display.id, & 	    &cntrl_info_block.pasteboard_id,  	    &dirtree_display.beg_y,   	    &dirtree_display.beg_x,   	    0))  '     dirtree_search_direction = advance; )     strcpy(dirtree_search_pattern, "[]");        direct_process_loop();  %     /**  Clear error line if any  **/ #     check_OK(smg$get_pasting_info ( , 	      &cntrl_info_block.status_display.id, ( 	      &cntrl_info_block.pasteboard_id,  	      &status_flags, 
 	      0, 
 	      0))-     if (status_flags == SMG$M_DISPLAY_PASTED)      { ' 	check_OK(smg$unpaste_virtual_display ( ) 		  &cntrl_info_block.status_display.id,  % 		  &cntrl_info_block.pasteboard_id))      }   *     check_OK(smg$begin_pasteboard_update (* 	     	  &cntrl_info_block.pasteboard_id))      check_OK(smg$erase_display (# 	     	  &dirtree_cmds_display.id,   	     	  0,  	     	  0,  	     	  0,  	     	  0))      check_OK(smg$erase_display ( 	     	  &dirtree_display.id,  	     	  0,  	     	  0,  	     	  0,  	     	  0))(     check_OK(smg$end_pasteboard_update (* 	     	  &cntrl_info_block.pasteboard_id))  )     check_OK(smg$delete_virtual_display ( ! 	      &dirtree_cmds_display.id)) )     check_OK(smg$delete_virtual_display (  	      &dirtree_display.id))       /*     **  Reset display ids.  9     **	Will be checked by read_string_and_clear_errmsg().      **/   5     dirtree_cmds_display.id = dirtree_display.id = 0;        /*?     **	Save to the directory cache queue.  If it was previously 5     **	saved in the queue, just replace the slot with <     **	root.  Otherwise, find an empty slot to place root.       **/   6     if ((n = search_direct_cache(initial_root)) == -1)     {  	/* , 	**  Current directory info not found in the6 	**  directory cache.  Find the LRU slot in the cache. 	**/    	n = find_LRU_in_direct_cache();     }        /*B     **  Save this directory information to the direct cache queue.     **/        save_to_direct_cache(  	n,  	initial_root,   	dirtree_search_direction,   	dirtree_search_pattern,   	root);        return DX__NORMAL; }      /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	    direct_process_loop()  { 7     char errmsg[256];				/**  Error msg buffer	     **/ 
     char *cp;      unsigned long int status;      char keyname[16]; +     $DESCRIPTOR (keyname_descrip, keyname); (     char short_path_name[MAXFILESPEC+1];;     $DESCRIPTOR (short_path_name_descrip, short_path_name); H     unsigned long status_flags;		/**  SMG$READ_KEYSTROKE status	     **/     unsigned short keystroke;      int find_down_flag;      struct node_tag *lastnode, 		    *leftnode;F     int timeout = cntrl_info_block.user_pref.update_in_second? 1 : 60;     int (*cstat)();        /*,     **	Keep processing until exits by user. 4     **	Exit is done by pressing kp0 or exit command.     **/        do       { 0 	/**  Update changes made from last command  **/* 	setddir(cwdnode->full_path_name, errmsg); 	change_dirtree_viewport(  	    cwdnode->row, 	    cwdnode->column, ! 	    &dirtree_display.view_beg_y, " 	    &dirtree_display.view_beg_x); 	put_dirtree_title(cwdnode);  < 	sprintf(short_path_name, "%.8s", cwdnode->short_path_name);; 	LENGTH(short_path_name_descrip) = strlen(short_path_name);  	check_OK(smg$put_chars (  		    &dirtree_display.id,    		    &short_path_name_descrip,  		    &cwdnode->row,   		    &cwdnode->column, 	 		    0,   		    &SMG$M_REVERSE, 	 		    0,  	 		    0))    	/*    	**  Read next command. $ 	**  Clear error message line if any 	**/   	do { ( 	    status_flags = smg$read_keystroke (# 				&cntrl_info_block.keyboard_id,   				&keystroke,  				0,   				&timeout,  				0,   				0,   				0); 3 	    if (cntrl_info_block.user_pref.display_clock)  & 		write_time(dirtree_cmds_display.id);( 	} while (status_flags == SS$_TIMEOUT ||% 		 keystroke == SMG$K_TRM_CANCELLED);     	check_OK(smg$get_pasting_info (- 		      &cntrl_info_block.status_display.id,  ) 		      &cntrl_info_block.pasteboard_id,   		      &status_flags,   		      0,   		      0)) * 	if (status_flags == SMG$M_DISPLAY_PASTED) 	{+ 	    check_OK(smg$unpaste_virtual_display ( - 		      &cntrl_info_block.status_display.id,  ) 		      &cntrl_info_block.pasteboard_id)) 	         }  	      	/* $ 	**  Do job according to key pressed 	**/   	switch (keystroke)  	{  A 	case SMG$K_TRM_KP0:	    /**  Exit without chaning directory  **/   3 	    setddir(DX_CURRENT_DIRECTORY.cur_dir, errmsg);  	    break; / 	case SMG$K_TRM_KP1:	    /**  Help command  **/    	    direct_helpdir(); 	    break; : 	case SMG$K_TRM_KP2:	    /**  Forward/backward switch  **/  . 	    if (dirtree_search_direction == advance)  	    {$ 		dirtree_search_direction = backup; 	    }	 	    else  	    {% 		dirtree_search_direction = advance;  	    }    	    put_dirtree_title(cwdnode); 	    break; 5 	case SMG$K_TRM_KP3:	    /**  Find first command  **/    	    dirtree_find_first(); 	    break; 4 	case SMG$K_TRM_KP4:	    /**  Find next command  **/  * 	    if (dirtree_find_next() == DX__ERROR)* 		signal_err("Directory not found", bell); 	    break; + 	case SMG$K_TRM_KP5:	    /**  Goto top  **/    	    check_OK(smg$put_chars (  		    &dirtree_display.id,    		    &short_path_name_descrip,  		    &cwdnode->row,   		    &cwdnode->column, 	 		    0,   		    &SMG$M_NORMAL,  	 		    0,  	 		    0))  	    cwdnode = root; 	    break; < 	case SMG$K_TRM_KP6:	    /**  Goto dirtree_display.rows  **/   	    check_OK(smg$put_chars (  		    &dirtree_display.id,    		    &short_path_name_descrip,  		    &cwdnode->row,   		    &cwdnode->column, 	 		    0,   		    &SMG$M_NORMAL,  	 		    0,  	 		    0))  	    find_down_flag = 0;I 	    find_down(root, (struct node_tag *)NULL, &cwdnode, &find_down_flag);  	    break; / 	case SMG$K_TRM_KP7:	    /**  Goto initial  **/    	    direct_initial(); 	    break; / 	case SMG$K_TRM_KP8:	    /**  Page up/down  **/   . 	    if (dirtree_search_direction == advance)  	    { 		find_down_flag = 0; G 		find_down(root, (struct node_tag *)NULL, &lastnode, &find_down_flag);  		if (cwdnode == lastnode)> 		    signal_err("Already at bottom of directory tree", bell); 		else5 		    cwdnode = dirtree_page_down(cwdnode, lastnode);  	    }   	    else if (cwdnode == root) 	    {7 		signal_err("Already at top of directory tree", bell);  	    }	 	    else  	    {% 		cwdnode = dirtree_page_up(cwdnode);  	    } 	    break; 5 	case SMG$K_TRM_UP:	    /**  Go up one directory  **/    	    if (cwdnode == root)  	    {7 		signal_err("Already at top of directory tree", bell);  	    }
 	    else  	    { 		check_OK(smg$put_chars ( 			&dirtree_display.id,  			&short_path_name_descrip,   			&cwdnode->row,  			&cwdnode->column,   			0,  			&SMG$M_NORMAL,  			0,  			0))? 		cwdnode = (cwdnode->up != NULL)? cwdnode->up : cwdnode->left;  	    } 	    break; 5 	case SMG$K_TRM_DOWN:	/**  Go down one directory  **/   : 	    if (cwdnode->down != NULL || cwdnode->right != NULL)  	    { 		check_OK(smg$put_chars ( 			&dirtree_display.id,  			&short_path_name_descrip,   			&cwdnode->row,  			&cwdnode->column,   			0,  			&SMG$M_NORMAL,  			0,  			0))D 		cwdnode = (cwdnode->down != NULL)? cwdnode->down : cwdnode->right; 	    }  
 	    else  	    {` 		for (leftnode = cwdnode->left; leftnode != (struct node_tag *)NULL; leftnode = leftnode->left)5 		    if (leftnode->down != (struct node_tag *)NULL)  . 			if (leftnode->left == leftnode->down->left)
 			    break; * 		if (leftnode == (struct node_tag *)NULL)> 		    signal_err("Already at bottom of directory tree", bell); 		else { 		    check_OK(smg$put_chars ( 			    &dirtree_display.id, ! 			    &short_path_name_descrip,   			    &cwdnode->row,  			    &cwdnode->column,  
 			    0,  			    &SMG$M_NORMAL, 
 			    0, 
 			    0)) 		    cwdnode = leftnode->down;  		}  	    } 	    break; 7 	case SMG$K_TRM_RIGHT:	/**  Go right one directory  **/   ! 	    if (cwdnode->right != NULL)   	    { 		check_OK(smg$put_chars ( 			&dirtree_display.id,  			&short_path_name_descrip,   			&cwdnode->row,  			&cwdnode->column,   			0,  			&SMG$M_NORMAL,  			0,  			0)) 		cwdnode = cwdnode->right;  	    }  
 	    else  	    {Z 		for (leftnode = cwdnode; leftnode != (struct node_tag *)NULL; leftnode = leftnode->left)5 		    if (leftnode->down != (struct node_tag *)NULL)  / 			if (leftnode->left == leftnode->down->left)  
 			    break; * 		if (leftnode == (struct node_tag *)NULL) 		{ > 		    signal_err("Already at bottom of directory tree", bell); 		}  		else   		{  		    check_OK(smg$put_chars ( 			    &dirtree_display.id, ! 			    &short_path_name_descrip,   			    &cwdnode->row,  			    &cwdnode->column,  
 			    0,  			    &SMG$M_NORMAL, 
 			    0, 
 			    0)) 		    cwdnode = leftnode->down;  		}  	    } 	    break; 5 	case SMG$K_TRM_LEFT:	/**  Go left one directory  **/    	    if (cwdnode == root)  	    {7 		signal_err("Already at top of directory tree", bell);  	    }
 	    else  	    { 		check_OK(smg$put_chars ( 			&dirtree_display.id,  			&short_path_name_descrip,   			&cwdnode->row,  			&cwdnode->column,   			0,  			&SMG$M_NORMAL,  			0,  			0))A 		cwdnode = (cwdnode->left != NULL)? cwdnode->left : cwdnode->up;  	    } 	    break; . 	case SMG$K_TRM_CR:	/**  Change directory  **/ 	      	    /* < 	    **	Output 'working...' message if total processing timeD 	    **	is longer than 1 second.  Needs to disable broadcast message& 	    **	first because of interference. 	    **/  . 	    check_OK(smg$disable_broadcast_trapping (% 			 &cntrl_info_block.pasteboard_id))   3 	    cstat = signal(SIGALRM, direct_alarm_working);  	    alarm(1);   	    status = filer_filter$1( / 		    cwdnode->full_path_name, "Name", errmsg);    	    /* - 	    **	Set the signal back to system default  	    **/   	    alarm(0); 	    signal(SIGALRM, cstat); 	    check_OK(smg$erase_chars (  			 &dirtree_cmds_display.id, 	 			 &10,   			 &2,  			 &1))* 	    check_OK(smg$set_broadcast_trapping (% 			 &cntrl_info_block.pasteboard_id,   			 broadcast_routine,   			 0))    	    if (status == DX__ERROR)  	    { 		signal_err(errmsg, bell);  	    }	 	    else  	    { 		return status; 	    } 	    break;   2 	case SMG$K_TRM_CTRLW:    /**  Refresh screen  **/  " 	    check_OK(smg$repaint_screen (% 			 &cntrl_info_block.pasteboard_id))  	    break; " 	default:		/**  NO DEFINITION  **/   	    memset (keyname, ' ', 15);  	    smg$keycode_to_name ( 	       &keystroke,  	       &keyname_descrip);  + 	    keyname[strcspn (keyname, " ")] = EOS;*G 	    sprintf (errmsg, "Key '%s' currently has no definition", keyname);  	    signal_err(errmsg, bell); 	}	/**  switch (keystroke)  **/6*     } while (keystroke != SMG$K_TRM_KP0);        return DX__NORMAL; }Y       /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbsc ** **-- **/  int	find_root(initdir, rootdir)" char *initdir; char *rootdir; {"     int len;
     char *cp;"  !     len = strcspn(initdir, ".]");u#     strncpy(rootdir, initdir, len);A     rootdir[len] = ']';t     rootdir[len+1] = EOS;        cp = strchr(rootdir, '[');:     if (!strcmp(cp, "[0,0]") || !strcmp(cp, "[000,000]")) +     {	    /**  Master system directory  **/r 	*cp = EOS;t 	strcat(rootdir, "[000000]");      }T }        /* **++ **  FUNCTIONAL DESCRIPTION:i **9 **      CREATE_NODE() allocates virtual memory to a node.  ** **-- **/E0 struct node_tag *create_node(filespec, row, col) char *filespec;e int row; int col; {s     struct node_tag *newnode;t     char *start, *end;
     int i;     int len;1     int allocate_size = sizeof (struct node_tag);D     unsigned long int status;           /*,     **	    ALLOCATE STOREAGE FOR A NEW NODE      **/F       check_OK(lib$get_vm (t 		 &allocate_size,  
 		 &newnode, i 		 0))       /*(     **	Initialize the newly-created node     **/E  .     strcpy(newnode->full_path_name, filespec);1     if ((start = strrchr(filespec, '.')) == NULL)  	start = strchr(filespec, '[');      start++;,     strcpy(newnode->short_path_name, start);0     end = strchr(newnode->short_path_name, ']');     *end = EOS;o6     newnode->row = row;			    /**  DIR COORDINATES **/     newnode->column = col;3     newnode->left = newnode->up = newnode->right = )) 	newnode->down = (struct node_tag *)NULL;h       /*-     **	Adjust the size of the dirtree display      **/   L     dirtree_display.width = max(dirtree_display.width, col+MAXDIRSPEC-1);   :     dirtree_display.rows = max(dirtree_display.rows, row);       return newnode;y }e       /* **++ **  FUNCTIONAL DESCRIPTION:e **E **      BUILD_DIRTREE() expands "DEV:[USERNAME]*.DIR;1" wildcard and  D **	build a tree to be used for painting the DIRTREE virtual display. ** **-- **/s' int	build_dirtree(parentnode, pathname)o struct node_tag **parentnode;u char *pathname;( {o-     static _align (QUADWORD) int logicalQ[2]; !     static unsigned long context;   &     struct logical_queue_entry_tag *E;     unsigned long condcode;U     char *indx;      int number_of_bytes;  !     char filespec[MAXFILESPEC+1]; -     $DESCRIPTOR (filespec_descrip, filespec);e  +     char resultant_filespec[MAXFILESPEC+1];iA     $DESCRIPTOR (resultant_filespec_descrip, resultant_filespec);e  "     logicalQ[0] = logicalQ[1] = 0;     trnlnm(pathname, logicalQ);e #pragma builtins(     while (_REMQHI (logicalQ, &E) != 3)  #pragma nobuiltins     {GG 	if (add_node(parentnode, E->equivalent_name, (struct node_tag *)NULL) c 	    == DX__ERROR) 	{ 	    return DX__ERROR; 	}! 	/**  Get wildcard file spec  **/oE 	strncpy(filespec, E->equivalent_name, strlen(E->equivalent_name)-1); 0 	filespec[ strlen(E->equivalent_name)-1 ] = EOS;0 	number_of_bytes = strlen(E->equivalent_name)+1;         check_OK(lib$free_vm ('                      &number_of_bytes, o*                      &E->equivalent_name,                       0))! 	strcat(filespec, "...]*.DIR;1");e- 	LENGTH(filespec_descrip) = strlen(filespec);   5 	/**  Call system services to expand the wildcard  */ # 	while ((condcode = lib$find_file (p 				&filespec_descrip, c! 				&resultant_filespec_descrip, l 				&context,  				0, 	 				0, c 				0, a 				0)) != RMS$_NMF) I 	{# 	    if (condcode == RMS$_NORMAL &&s% 		!strchr(resultant_filespec, '*') &&&# 		strchr(resultant_filespec, ' '))  A 	    {	/** Convert "DEV:[*.*...]*.DIR;1" into "DEV:[*.*...]"  **/_/ 		for (indx = resultant_filespec; indx; indx++)D 		    if (*indx == ']')  		    {  			*indx = '.';c	 			break;  		    }  		for (indx++; indx; indx++) 		    if (*indx == '.')  		    {t 			*indx = ']';.	 			break;  		    }(	 		indx++;s 		*indx = EOS;  $ 		if (strstr (filespec, "[000000.")) 		{)3 		    if (!strstr (resultant_filespec, "[000000."))  		    {a 			char s[MAXFILESPEC+1];   , 			indx = strchr(resultant_filespec, '[')+1; 			strcpy(s, indx);. 			*indx = EOS;t) 			strcat(resultant_filespec, "000000.");S! 			strcat(resultant_filespec, s);w 		    }c 		}i   		if (add_node(d 			parentnode, * 			resultant_filespec,  ) 			(struct node_tag *)NULL) == DX__ERROR). 		{+" 		    lib$find_file_end(&context); 		    return DX__ERROR;d 		}e 	    } 	} 	lib$find_file_end(&context);e     }a       return DX__NORMAL; }      e /* **++ **  FUNCTIONAL DESCRIPTION:  **2 **      add_node() inserts a node into the tree.   ** **-- **/r) struct node_tag *add_node(p, filespec, q)d struct node_tag **p; char *filespec;f struct node_tag *q;	/*% 			**  Parent node if moved right or  ! 			**  sibling node if moved downr 			**/ {p     struct node_tag *newnode;e>     struct node_tag *upnode, *leftnode, *downnode, *rightnode;     char *indx;	     int cmp;
     char *cp;G     int len;  '     if (*p == (struct node_tag *)NULL) p     {t' 	newnode = create_node(filespec, 0, 0);r   	/**  Do double linking  **/ 	if (q != (struct node *)NULL) 	{9 	    if (filespec[ strlen(q->full_path_name)-1 ] == '.') 	+ 	    {	/**  New node is the oldest son  **/sC 		if ((newnode->up = find_prev_node(q)) != (struct node_tag *)NULL)o" 		    newnode->up->down = newnode; 		newnode->left = q; 	    } e
 	    else & 	    {	/**  New node is a sibling  **/ 		newnode->up = q; 		newnode->left = q->left; 	    } 	} 	*p = newnode; 	return *p;K     } A     else if (filespec[ strlen((*p)->full_path_name)-1 ] == '.' &&b 	     !strncmp(d 		filespec,  		(*p)->full_path_name, " 		strlen((*p)->full_path_name)-1))      {	    /**  Search right  **// 	return add_node(&((*p)->right), filespec, *p);]     }      else if (strncmp(( 		filespec,  		(*p)->full_path_name, & 		strlen((*p)->full_path_name)-1) > 0)     {	    /**  Search down  **/u. 	return add_node(&((*p)->down), filespec, *p);     } 	     else t     {a7 	if ((cp = strrchr((*p)->full_path_name, '.')) == NULL)$ 	{- 	    cp = strrchr((*p)->full_path_name, ']');i 	} 	len = cp-(*p)->full_path_name;c) 	if (strchr(filespec+len+1, '.') != NULL)c 	{	/*b5 		**  The parent directory did not exist prior to the_  		**  creation of this directory 		**/e$ 	    return (struct node_tag *)NULL; 	} 	else  	{+ 	    newnode = create_node(filespec, 0, 0);     	    /**  Do double linking  **/" 	    if (q != (struct node *)NULL) 	    {6 		if (filespec[ strlen(q->full_path_name)-1 ] == '.') ( 		{	/**  New node is the oldest son  **/> 		    if ((newnode->up = (*p)->up) != (struct node_tag *)NULL) 			newnode->up->down = newnode;i 		    newnode->left = q; 		    newnode->down = *p;  		    (*p)->up = newnode;t 		}  		else  , 		{	/**  New node is not the oldest son  **/ 		    newnode->up = q;! 		    newnode->left = (*p)->left;n 		    newnode->down = *p;  		    (*p)->up = newnode;s 		}i 	    } 	    *p = newnode; 	    return *p;* 	}     }e }r     c /* **++ **  FUNCTIONAL DESCRIPTION:  **M **      FIND_PREV_NODE() finds previous node with different parent directory.n ** **-- **/p" struct node_tag *find_prev_node(q) struct node_tag *q;e {i     struct node_tag *s;   <     for (q = q->up; q != (struct node_tag *)NULL; q = q->up)     {c* 	if (q->right != (struct node_tag *)NULL)  	{H 	    for (s = q->right; s->down != (struct node_tag *)NULL; s = s->down) 		if (s->down->left != q)c 		    return s;  	    return s; 	}       }c#     return (struct node_tag *)NULL;r }s     i /* **++ **  FUNCTIONAL DESCRIPTION:  **I **      FIND_NEXT_NODE() finds next node with different parent directory.I ** **-- **/ " struct node_tag *find_next_node(q) struct node_tag *q;  {      struct node_tag *s;*  @     for (q = q->down; q != (struct node_tag *)NULL; q = q->down)     { * 	if (q->right != (struct node_tag *)NULL)  	{D 	    for (s = q->right; s->up != (struct node_tag *)NULL; s = s->up) 		if (s->up->left != q)a 		    return s;_ 	    return s; 	}     }l#     return (struct node_tag *)NULL;T }E     	 /* **++ **  FUNCTIONAL DESCRIPTION:  **A **      TRAVERSE_TREE() calculates the row and column value when n> **	visiting each node.  The dimensions for DIRTREE are derived **	when the function finished. ** **-- **/ = int	traverse_tree(childnode, parentnode, row, col, direction) ( struct node_tag *childnode, *parentnode;
 int row, col;  enum directions direction; { 7     /**  Reset DIRTREE virtual display's dimension  **/ 5     dirtree_display.rows = dirtree_display.width = 0;,  @     traverse_tree$1(childnode, parentnode, row, col, direction);  3     /**  Resize DIRTREE virtual display's size  **/e8     dirtree_display.rows += dirtree_display.view_rows-1;C     dirtree_display.width += dirtree_display.view_width-MAXDIRSPEC;  }c  F static int	traverse_tree$1(childnode, parentnode, row, col, direction)( struct node_tag *childnode, *parentnode;
 int row, col;o enum directions direction; {M     int lineno = 0;   -     if (childnode == (struct node_tag *)NULL)      {e, 	return (direction == right)? LINESPACE : 0;     }a,     else if (childnode->left == parentnode)      {c. 	if (dirtree_display.width < col+MAXDIRSPEC-1). 	    dirtree_display.width = col+MAXDIRSPEC-1;  	if (dirtree_display.rows < row)  	    dirtree_display.rows = row; 	childnode->row = row; 	childnode->column = col;_X 	lineno += traverse_tree$1(childnode->right, childnode, row, col+DISTANCE_COUNT, right);O 	lineno += traverse_tree$1(childnode->down, parentnode, row+lineno, col, down);d     }      return lineno; }        /* **++ **  FUNCTIONAL DESCRIPTION:  **F **      SEARCH_NODE() searchs a node starting from the root directory." **      Return error if not found. ** **-- **/ ) struct node_tag *search_node(p, filespec)  struct node_tag *p;  char *filespec;d { %     if (p == (struct node_tag *)NULL)o     {{  	return (struct node_tag *)NULL;     }t*     else if (!strncmp(p->short_path_name,  		      filespec, & 		      strlen(p->short_path_name)) &&# 	     !strncmp(p->short_path_name, d 		      filespec, ! 		      strcspn(filespec, ".]")))M' 	/**  A MATCHED DIRECTORY IS FOUND  **/i     {/8 	if (*(filespec+strlen(p->short_path_name)) == ']')	     	    return p; 	elsec; 	    return search_node(p->right, strchr(filespec, '.')+1);d     }n0     else if (p->down != (struct node_tag *)NULL)     { %         if (p->down->left == p->left)/+ 	    return search_node(p->down, filespec);f     }s  #     return (struct node_tag *)NULL;: }      i /* **++ **  FUNCTIONAL DESCRIPTION:e **A **      PAINT_DIRTREE_DISPLAY() takes the tree head as input and  6 **	writes the directory tree structure to the display. ** **-- **/k void	paint_dirtree_display(p)r struct node_tag *p;	 { '     char short_path_name[MAXDIRSPEC+1];e:     $DESCRIPTOR(short_path_name_descrip, short_path_name);  >     unsigned int start_row, end_row, start_column, end_column;B     unsigned long char_up = SMG$M_LEFT + SMG$M_RIGHT + SMG$M_DOWN;B     unsigned long char_left = SMG$M_UP + SMG$M_DOWN + SMG$M_RIGHT;7     unsigned long left_corner = SMG$M_UP + SMG$M_RIGHT;      unsigned long draw_char;  &     if (p != (struct node_tag *)NULL)      { 6 	sprintf(short_path_name, "%.8s", p->short_path_name);; 	LENGTH(short_path_name_descrip) = strlen(short_path_name);  	check_OK(smg$put_chars (* 		    &dirtree_display.id, d  		    &short_path_name_descrip,  		    &(p->row),   		    &(p->column), 	 		    0,  	 		    0, e	 		    0, e	 		    0))v  ( 	if (p->left != (struct node_tag *)NULL) 	{ 	    if (p->up == NULL)  	    { 		start_column = o 		    p->left->column+min(1 			strlen(p->left->short_path_name), MAXDIRSPEC);d 		end_column = p->column-1;e 		check_OK(smg$draw_line ( 		    &dirtree_display.id,   		    &(p->row),   		    &start_column,   		    &(p->row), " 		    &end_column, e	 		    0, ,	 		    0))  	    }  & 	    else if (p->left != p->up->left)  	    { 		start_column =   		    p->left->column+min(1 			strlen(p->left->short_path_name), MAXDIRSPEC);d 		end_column = p->column-1;n 		check_OK(smg$draw_line ( 		    &dirtree_display.id, } 		    &(p->row), { 		    &start_column, a 		    &(p->row), i 		    &end_column, _	 		    0, e	 		    0))	 	    } -
 	    else  	    {+ 		if (p->up->up == (struct node_tag *)NULL)  		    draw_char = char_up;* 		else if (p->up->up->left != p->up->left) 		    draw_char = char_up; 		else 		    draw_char = char_left;2 		start_column = p->up->column-LINE_NODE_DISTANCE; 		check_OK(smg$draw_char ( 			&dirtree_display.id,  			&draw_char, e 			&(p->up->row),  			&start_column,c 			0,  			0)) 		start_row = p->up->row+1;m 		end_row = p->row;$. 		start_column = p->column-LINE_NODE_DISTANCE; 		check_OK(smg$draw_line ( 		    &dirtree_display.id,   		    &start_row,{ 		    &start_column, n 		    &end_row,d 		    &start_column, )	 		    0, o	 		    0))d 		check_OK(smg$draw_char ( 			&dirtree_display.id,  			&left_corner, 			&(p->row),  			&start_column,l 			0,  			0)). 		start_column = p->column-LINE_NODE_DISTANCE; 		end_column = p->column-1;t 		check_OK(smg$draw_line ( 		    &dirtree_display.id, _ 		    &(p->row), 		    &start_column, a 		    &(p->row), 		    &end_column, ,	 		    0, &	 		    0))w 	    } 	}! 	paint_dirtree_display(p->right); ( 	if (p->down != (struct node_tag *)NULL)" 	    if (p->left == p->down->left)! 		paint_dirtree_display(p->down);M     }_ }H       /* **++ **  FUNCTIONAL DESCRIPTION:  **G **      FREE_DIRTREE() makes the virtual memory previously allocated toi **	DIRTREE available again.m ** **-- **/	 int	free_dirtree(p, q) struct node_tag **p; struct node_tag *q;  {	3     int node_entry_size = sizeof (struct node_tag);   &     if (*p != (struct node_tag *)NULL)     {f         if ((*p)->left == q)	         {e+             free_dirtree(&((*p)->down), q);!,             free_dirtree(&((*p)->down), *p);  "             check_OK(lib$free_vm (+                          &node_entry_size, g                          p,                           0))" 	    *p = (struct node_tag *)NULL;	         }      }K }g     a /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbsm ** **-- **/	 int	put_dirtree_title(n) struct node_tag *n;  {	     char dir[10];M     int rows_in_page,  	current_page;     char str[81];o"     $DESCRIPTOR(str_descrip, str);     char cwd_line[81];,     $DESCRIPTOR(cwd_line_descrip, cwd_line);     char page_str[81];,     $DESCRIPTOR(page_str_descrip, page_str);     struct fil_dx_tag *p;      int line_row;h     int len;  ,     if (dirtree_search_direction == advance)     {_         strcpy(dir, "Forward");	     }d     else     {0          strcpy(dir, "Backward");     }	'     if (strlen(n->full_path_name) > 67)e     {:J         sprintf(cwd_line, " %-66.66s~ | %-8.8s ", n->full_path_name, dir);     }/     else     { I         sprintf(cwd_line, " %-67.67s | %-8.8s ", n->full_path_name, dir);l     }h0     LENGTH(cwd_line_descrip) = strlen(cwd_line);     check_OK(smg$put_chars (! 	      &dirtree_cmds_display.id, ( 	      &cwd_line_descrip,  	      &DIRTREE_DIRECT_ROW,  	      &1,   	      &SMG$M_ERASE_LINE,  	      &SMG$M_REVERSE, )
 	      0, 
 	      0))  <     current_page = 1 + (n->row-1)/dirtree_display.view_rows;*     sprintf(page_str, "%d", current_page);0     LENGTH(page_str_descrip) = strlen(page_str);     len = strlen(page_str)+2;c2     line_row = cntrl_info_block.pasteboard_rows-1;     check_OK(smg$draw_line (  		    &dirtree_cmds_display.id,  		    &line_row, s
 		    &1,  		    &line_row, l
 		    &1, 	 		    0, 		 		    0))_     check_OK(smg$put_chars (  		    &dirtree_cmds_display.id,  		    &page_str_descrip,   		    &line_row,  
 		    &2, 	 		    0, u 		    &SMG$M_BOLD, k	 		    0,  	 		    0))T     check_OK(smg$draw_line (  		    &dirtree_cmds_display.id,  		    &line_row, i 		    &len,  		    &line_row, b# 		    &dirtree_cmds_display.width,  	 		    0,  	 		    0))y }e     1 /* **++ **  FUNCTIONAL DESCRIPTION:  **@ **      DIRECT_HELPDIR() calls HELPDIR() to output help message  **	by using VMS HELP utilities.f ** **-- **/' int	direct_helpdir() {n7     filer_help("DX OPTION_MENU MOVING_AROUND_DIRTREE");* }w     e /* **++ **  FUNCTIONAL DESCRIPTION:! ** **      to be specifiedu ** **-- **/  int	    direct_alarm_working() {L      static int remain_alarm = 2;  3     if (cntrl_info_block.user_pref.display_clock &&*- 	cntrl_info_block.user_pref.update_in_second)      {p% 	write_time(dirtree_cmds_display.id);u     }t       remain_alarm--;      if (remain_alarm > 0)'     { ' 	signal(SIGALRM, direct_alarm_working);h     }i     else     {( 	remain_alarm = 2;) 	signal(SIGALRM, direct_alarm_working$1);*     }e  
     alarm(1);y }*     p /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified+ ** **-- **/L' static int	    direct_alarm_working$1()  {o     static int switch_on = 0; #     static int remain_timeout = 60;e       if (!switch_on)      {h         switch_on++;          check_OK(smg$put_chars (/                      &dirtree_cmds_display.id, ;,                      $DESCR ("Working..."),                       &2, n                      &1,                        0,                       0,                       0,                       0))     }s     else     {d         switch_on = 0;"         check_OK(smg$erase_chars (/                      &dirtree_cmds_display.id, a                      &10,                       &2, )                      &1))(     }c  1     if (cntrl_info_block.user_pref.display_clock)h     {s1 	if (cntrl_info_block.user_pref.update_in_second)' 	{) 	    write_time(dirtree_cmds_display.id);	 	} 	elseD 	{ 	    remain_timeout--; 	    if (remain_timeout == 0)- 	    {+ 	    	 write_time(dirtree_cmds_display.id);o 		 remain_timeout = 60;U 	    } 	}     }   ,     signal(SIGALRM, direct_alarm_working$1);
     alarm(1);t }_