 /* **++
 **  FACILITY:  ** **      FILER.C  **
 **  ABSTRACT:  **J **       This is the main driver of the file-management portion of the DX C **	 utility.  It accepts user command to perform functions such as  ; **	 delete, edit, or rename files in the current directory.  ** **  AUTHORS: ** **      C. K. Hung  **	Planning Research Corporation **	1150 Gemini Avenue  **	Houston, TX 77058 **	Phone: (713)282-6227  ** **  CREATION DATE:     7-12-89 ** **  MODIFICATION HISTORY:  ** **-- **/    /* ** **  INCLUDE FILES  ** **/    #include "global.h"  #include "direct.h"  #include "diff.h"  #include "dx.h"  #include "endecode.h"  #include "filer.h" #include "filerapp.h"  #include "filercpy.h"  #include "filerdec.h"  #include "filerdel.h"  #include "filerdif.h"  #include "fileredt.h"  #include "filerenc.h"  #include "filerfnd.h"  #include "filerkpd.h"  #include "filerlau.h"  #include "filerpro.h"  #include "filerprt.h"  #include "filerpur.h"  #include "filerren.h"  #include "filersta.h"  #include "filertyp.h"  #include "filercus.h"  #include "filerexe.h"  #include "filerflt.h"  #include "fileropt.h"  #include "filersrt.h"  #include "filerwin.h"  #include "findfile.h"  #include "inquire.h" #include "menunavi.h"  #include libdef  #include signal  #include strdef 
 #include time    /* **	GLOBAL DECLARATIONS **/     struct menutype filer_menu[] = {     {  	" Window ", GEN_CMDS_ROW, 1,  	{C 	    "Split window", "Delete window", "One window", MENU_SEPARATOR, 7 	    "Next window", "Previous window", MENU_SEPARATOR,   	    "eXit", NULL  	},  	{< 	    filer_split_win, filer_delete_win, filer_one_win, NULL,+ 	    filer_next_win, filer_prev_win, NULL,   	    filer_exitset 	},      },     {  	" Action ", GEN_CMDS_ROW, 9,  	{( 	    "Type", "Edit", "Delete", "Purge", ? 	    "Rename...", "Copy...", "Append...", "Set protection...",  . 	    "Print...", "Show", "Find...", "Run...", / 	    "Compare...", "pacK...", "Unpack...", NULL  	},  	{7 	    filer_type, filer_edt, filer_delete, filer_purge,  ? 	    filer_rename, filer_copy, filer_append, filer_protection,  : 	    filer_print, filer_status, filer_find, filer_launch, + 	    filer_diff, filer_encode, filer_decode  	},      },     {   	" Execute ", GEN_CMDS_ROW, 17,  	{# 	    "Command", "VMS Gateway", NULL  	},  	{) 	    filer_vms_command, filer_vms_gateway  	},      },     {  	" Sort ", GEN_CMDS_ROW, 26,   	{/ 	    "by Name...", "by Type...", "by Date...",  ' 	    "by Size...", "by Marked...", NULL  	},  	{7 	    filer_sort_name, filer_sort_type, filer_sort_date, % 	    filer_sort_size, filer_sort_mark  	}     },       {  	" Filter ", GEN_CMDS_ROW, 32, 	{ 	    "Name...", "Exclude...",  	    "Since...", "Before...", % 	    "maXimum...", "Minimum...", NULL  	},  	{. 	    filer_filter_name, filer_filter_exclude, . 	    filer_filter_since, filer_filter_before, / 	    filer_filter_maximum, filer_filter_minimum  	},      },     {  	" Option ", GEN_CMDS_ROW, 40,   	{* 	    "Direct tree", "Update", "Mkdir...", ; 	    "show Buffer", "Write...", "Goto...", MENU_SEPARATOR,  0 	    "Short form", "Long form", MENU_SEPARATOR, E 	    "Include all", "Exclude all", "Re-include all", MENU_SEPARATOR,   	    "About DX", NULL  	},  	{. 	    filer_direct, filer_update, filer_mkdir, 6 	    filer_show_buffer, filer_write, filer_goto, NULL,- 	    filer_short_form, filer_long_form, NULL, > 	    filer_mark_all, filer_unmark_all, filer_remark_all, NULL, 	    filer_about 	},      },     { ! 	" Customize ", GEN_CMDS_ROW, 48,  	{: 	    "Editor...", "Display with date...", "Type file...", @ 	    "Auto update...", "Delete confirm...", "Purge confirm...", = 	    "Show clock...", "Flash clock colon...", MENU_SEPARATOR, D 	    "Save settings...", "Restore settings...", "Use defaults", NULL 	},  	{5 	    custom_editor, custom_display_date, custom_type, 6 	    custom_auto_update, custom_delete, custom_purge, 9 	    custom_display_clock, custom_update_in_second, NULL, D 	    custom_save_setting, custom_restore_setting, custom_use_default 	},      },     NULL };   /* **  **	INTERNAL FUNCTION PROTOTYPING ** **/   *     static int			filter_alarm_working$1();       /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	DX_process_loop()  {      int number_of_items;     char *c1, *c2;     struct menutype *mp;,     char valid_cmdstr[MAXCOMMANDSITEMNUM+1];       long int row, col;     unsigned short keystroke;      unsigned long status;      int choice_no;     char keyname[15]; +     $DESCRIPTOR (keyname_descrip, keyname); @     char errmsg[MAXFILESPEC+1];	/**  Error message buf       **/     div_t div_p;     int all_dirs;      int pages;     char pages_str[10];        /*      **	Get valid commands string     **/        number_of_items = 0;     c1 = valid_cmdstr;+     for (mp = filer_menu; mp->itmstr; mp++) ! 	for (c2 = mp->itmstr; *c2; c2++)  	    if (isupper (*c2)) {  		*c1++ = *c2; 		number_of_items++; 		break; 	    }     *c1 = EOS;       /*%     **	Write status and command lines      **/   !     put_general_cmds(filer_menu); 1     if (cntrl_info_block.user_pref.display_clock) 2 	write_time(cntrl_info_block.commands_display.id);C     put_filer_pfs(FILER_PFS, cntrl_info_block.commands_display.id);        /*(     **	Compute the position of each file     **/   /     DX_CURRENT_DIRECTORY.dir_filelist->beg_y =  . 	DX_CURRENT_DIRECTORY.dir_filelist->beg_x = 1;     row = col = 1;     compute_filer_begin_xy (J 	DX_CURRENT_DIRECTORY.dir_filelist, &row, &col, cntrl_info_block.cur_win);3     DX_CURRENT_DIRECTORY.non_dir_filelist->beg_y =  5 	DX_CURRENT_DIRECTORY.dir_filelist->backward->beg_y;  3     DX_CURRENT_DIRECTORY.non_dir_filelist->beg_x =  5 	DX_CURRENT_DIRECTORY.dir_filelist->backward->beg_x;       compute_filer_begin_xy (N 	DX_CURRENT_DIRECTORY.non_dir_filelist, &row, &col, cntrl_info_block.cur_win);       /*#     **	Create FILER virtual display      **/   2     DX_CURRENT_DIRECTORY.filer_display.view_rows =@ 	 cntrl_info_block.pasteboard_rows-CMDS_RSV_LNS-DIRINFO_RSV_LNS;3     DX_CURRENT_DIRECTORY.filer_display.view_width = # 	cntrl_info_block.pasteboard_width; 6     DX_CURRENT_DIRECTORY.filer_display.view_beg_y = 1;6     DX_CURRENT_DIRECTORY.filer_display.view_beg_x = 1;-     DX_CURRENT_DIRECTORY.filer_display.rows = = 	max (DX_CURRENT_DIRECTORY.non_dir_filelist->backward->beg_y, 4 	     DX_CURRENT_DIRECTORY.filer_display.view_rows);.     DX_CURRENT_DIRECTORY.filer_display.width =# 	cntrl_info_block.pasteboard_width; =     DX_CURRENT_DIRECTORY.filer_display.beg_y = FILER_PBD_ROW; @     DX_CURRENT_DIRECTORY.filer_display.beg_x = FILER_PBD_COLUMN;)     check_OK(smg$create_virtual_display ( , 		&DX_CURRENT_DIRECTORY.filer_display.rows, - 		&DX_CURRENT_DIRECTORY.filer_display.width,  * 		&DX_CURRENT_DIRECTORY.filer_display.id,  		0,   		0,   		0)) "     check_OK(smg$create_viewport (* 		&DX_CURRENT_DIRECTORY.filer_display.id, 1 		&DX_CURRENT_DIRECTORY.filer_display.view_beg_y, 1 		&DX_CURRENT_DIRECTORY.filer_display.view_beg_x, 0 		&DX_CURRENT_DIRECTORY.filer_display.view_rows,2 		&DX_CURRENT_DIRECTORY.filer_display.view_width))       /*D     **	Set current file pointer.  Make sure at least one file exists!     **	in the directory file list      **/   #     DX_CURRENT_DIRECTORY.cur_file = 0 	(DX_CURRENT_DIRECTORY.dir_filelist->forward != ( 	    DX_CURRENT_DIRECTORY.dir_filelist? . 		DX_CURRENT_DIRECTORY.dir_filelist->forward :2 		DX_CURRENT_DIRECTORY.non_dir_filelist->forward);       /*+     **	Write directory title and statistics      **/   .     put_filer_title(cntrl_info_block.cur_win);-     put_filer_stat(cntrl_info_block.cur_win);        /*$     **	Write directory and page info     **/        /*O     div_p = div (cntrl_info_block.dir_dx[0].non_dir_filelist->backward->beg_y,  : 		    cntrl_info_block.dir_dx[0].filer_display.view_rows);8     pages = (div_p.rem == 0? div_p.quot : div_p.quot+1);U     all_dirs = (strcmp(cntrl_info_block.dir_dx[0].dir_filelist->forward->fn, "[-]")?  J 	cntrl_info_block.dir_dx[0].subdir : cntrl_info_block.dir_dx[0].subdir+1);4     sprintf(pages_str, "Total of %d %s, %d %s read",7 	all_dirs, (all_dirs > 1? "directories" : "directory"), ' 	pages, (pages > 1? "pages" : "page")); #     signal_err(pages_str, silence);      */       /*'     **  Write all the files to screen        **/        write_to_filer( A 	cntrl_info_block.dir_dx[cntrl_info_block.cur_win].dir_filelist);      write_to_filer( E 	cntrl_info_block.dir_dx[cntrl_info_block.cur_win].non_dir_filelist); #     highlight_filer_current_file();   (     check_OK(smg$paste_virtual_display (* 		&DX_CURRENT_DIRECTORY.filer_display.id, # 		&cntrl_info_block.pasteboard_id,  - 		&DX_CURRENT_DIRECTORY.filer_display.beg_y,  - 		&DX_CURRENT_DIRECTORY.filer_display.beg_x,   		0))        /*      **	Loop until exited by user     **/   
     while (1)      {  	/* 9 	**  Read next command.  Clear error message line if any.  	**/  C 	int timeout = cntrl_info_block.user_pref.update_in_second? 1 : 60;    	do { " 	    status = smg$read_keystroke (# 				&cntrl_info_block.keyboard_id,   				&keystroke,  				0,   				&timeout,  				0,   				0,   				0); 3 	    if (cntrl_info_block.user_pref.display_clock)  3 		write_time(cntrl_info_block.commands_display.id); # 	} while (status == SS$_TIMEOUT ||  % 		 keystroke == SMG$K_TRM_CANCELLED);     	check_OK(smg$get_pasting_info () 		  &cntrl_info_block.status_display.id,  % 		  &cntrl_info_block.pasteboard_id,  
 		  &status,   		  0,   		  0))   $ 	if (status == SMG$M_DISPLAY_PASTED)+ 	    check_OK(smg$unpaste_virtual_display ( - 		      &cntrl_info_block.status_display.id,  ) 		      &cntrl_info_block.pasteboard_id))  	      	/* $ 	**  Do job according to key pressed 	**/   	if (isalnum(keystroke) &&F 	    (c1 = strchr(valid_cmdstr, (char) _toupper(keystroke))) != NULL)  	{) 	    choice_no = (int) (c1-valid_cmdstr);  	    keystroke = navigator(  			    filer_menu,   			    &choice_no,   			    number_of_items); 	}   	else  	{ 	    switch (keystroke)  	    {F 	    case SMG$K_TRM_KP0:	    /**  Exit without changing directory  **/  1 		setddir(cntrl_info_block.original_cwd, errmsg);   # 		/**  Scroll screen up 1 line  **/ $ 		check_OK(smg$set_physical_cursor (& 			  &cntrl_info_block.pasteboard_id, ( 			  &cntrl_info_block.pasteboard_rows, 	 			  &1))    		fprintf(stderr, "\033E");    		/* 		**  NEVER RETURN!!!  		**/ 
 		exit(0);6 	    case SMG$K_TRM_CTRLW:    /**  Refresh screen  **/  -                 check_OK(smg$repaint_screen ( ) 			     &cntrl_info_block.pasteboard_id))  		break;1 	    case SMG$K_TRM_HT:	    /**  Next window  **/    		filer_next_win();  		break;3 	    case SMG$K_TRM_KP1:	    /**  Help command  **/    		filer_help("DX");  		break;> 	    case SMG$K_TRM_KP2:	    /**  Forward/backward switch  **/  1 		if (DX_CURRENT_DIRECTORY.direction == advance)   		{ . 		    DX_CURRENT_DIRECTORY.direction = backup; 		}  		else   		{ / 		    DX_CURRENT_DIRECTORY.direction = advance;  		} , 		put_filer_title(cntrl_info_block.cur_win); 		break;9 	    case SMG$K_TRM_KP3:	    /**  Find first command  **/    		filer_find_first();  		break;8 	    case SMG$K_TRM_KP4:	    /**  Find next command  **/   		filer_find_next(); 		break;2 	    case SMG$K_TRM_KP5:	    /**  Move to top  **/  # 		unhighlight_filer_current_file();  		filer_top(); 		break;5 	    case SMG$K_TRM_KP6:	    /**  Move to bottom  **/   # 		unhighlight_filer_current_file();  		filer_bottom();  		break;= 	    case SMG$K_TRM_KP7:	    /**  Include/exclude switch  **/   & 		if (DX_CURRENT_FILE->state != ready)% 		    filer_mark(DX_CURRENT_FILE, 0);  		else' 		    filer_unmark(DX_CURRENT_FILE, 0);  		break;3 	    case SMG$K_TRM_KP8:	    /**  Page up/down  **/   # 		unhighlight_filer_current_file(); N 		if (cntrl_info_block.dir_dx[cntrl_info_block.cur_win].direction == advance)  		    filer_page_down(); 		else 		    filer_page_up(); 		break;= 	    case SMG$K_TRM_KP9:	    /**  Single/multiple switch  **/   / 		if (DX_CURRENT_DIRECTORY.filemode == single)  ! 		{	/**  Enter MULTIPLE mode  **/ / 		    DX_CURRENT_DIRECTORY.filemode = multiple;  		}  		else   		{	/**  Single mode  **/ - 		    DX_CURRENT_DIRECTORY.filemode = single;  		} , 		put_filer_title(cntrl_info_block.cur_win); 		break;* 	    case SMG$K_TRM_UP:		/**  Move up  **/  # 		unhighlight_filer_current_file(); 
 		filer_up();  		break;- 	    case SMG$K_TRM_DOWN:	/**  Move down  **/   # 		unhighlight_filer_current_file();  		filer_down();  		break;- 	    case SMG$K_TRM_LEFT:	/**  Move left  **/   # 		unhighlight_filer_current_file();  		filer_left();  		break;/ 	    case SMG$K_TRM_RIGHT:	/**  Move right  **/   # 		unhighlight_filer_current_file();  		filer_right(); 		break;3 	    case SMG$K_TRM_CR:		/**  Change directory  **/   N                 if (DX_CURRENT_FILE->fn[strlen(DX_CURRENT_FILE->fn)-1] != ']') 		{ ,                     check_OK(smg$ring_bell (I                                  &DX_CURRENT_DIRECTORY.filer_display.id,  $                                  0)) 		}  		else                 {  		    char buf[MAXFILESPEC+1]; 		    char *cp;  		    int (*cstat)();    		    /*= 		    **	Output 'working...' message if total processing time ? 		    **	is longer than 3 seconds.  Needs to disable broadcast  - 		    **	message first to avoid interference. 	 		    **/ 
 #ifndef DEBUG / 		    check_OK(smg$disable_broadcast_trapping ( & 				 &cntrl_info_block.pasteboard_id))  4 		    cstat = signal(SIGALRM, filter_alarm_working); 		    alarm(1);  #endif 		    find_full_path_name(7 			DX_CURRENT_FILE->fn, buf, cntrl_info_block.cur_win); * 		    if ((cp = strchr(buf, ']')) != NULL) 		    { 
 			*cp = '.';  		    }  		    cp = strrchr(buf, '.');  		    *cp++ = ']'; 		    *cp = EOS;I                     if (filer_filter$1(buf, "Name", errmsg) == DX__ERROR)                      { 1                         signal_err(errmsg, bell);                      } 
 		    else 		    {  			check_OK(smg$erase_chars ( 0 				     &cntrl_info_block.commands_display.id,  				     &10, 
 				     &2,  
 				     &1))  		    }    		    /*. 		    **	Set the signal back to system default	 		    **/ 
 #ifndef DEBUG  		    alarm(0);  		    signal(SIGALRM, cstat);   + 		    check_OK(smg$set_broadcast_trapping ( & 				 &cntrl_info_block.pasteboard_id,  				 broadcast_routine,  				 0)) #endif                 }  		break;0 	    default:			/**  Key with no definition  **/  *                 memset (keyname, ' ', 15);         	smg$keycode_to_name (                    &keystroke,  %                    &keyname_descrip);   6                 keyname[strcspn (keyname, " ")] = EOS;R                 sprintf (errmsg, "Key '%s' currently has no definition", keyname); 		signal_err(errmsg, bell);  	    }   	} /**  switch (keystroke)  **/   '         /**  Reposition the cursor  **/   	highlight_filer_current_file();     }  }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	put_general_cmds(m)  struct menutype *m;  {      char line[81];%     $DESCRIPTOR (line_descrip, line);      char str1[2]; (     $DESCRIPTOR(str1_descrip, str1);         struct menutype *p;      int len;     register long int i, j;   '     check_OK(smg$begin_display_update ( . 	      &cntrl_info_block.commands_display.id))  :     memset (line, ' ', cntrl_info_block.pasteboard_width);=     LENGTH(line_descrip) = cntrl_info_block.pasteboard_width;      check_OK(smg$put_chars (. 	      &cntrl_info_block.commands_display.id,  	      &line_descrip,  	      &GEN_CMDS_ROW,  	      &GEN_CMDS_COLUMN,  
 	      0, 
 	      0, 
 	      0, 
 	      0))          LENGTH(str1_descrip) = 1;         for (p = m; p->itmstr; p++)      {  	len = strlen(p->itmstr); 2 	for (i = 0, j = p->start_col; i < len; i++, j++)  	{ 	    str1[0] = *(p->itmstr+i); 	    if (! isupper(str1[0])) 	    { 		check_OK(smg$put_chars (, 			  &cntrl_info_block.commands_display.id,  			  &str1_descrip,  			  &GEN_CMDS_ROW, 	 			  &j,   			  0,  			  0,  			  0,  			  0)) 	    }	 	    else  	    { 		check_OK(smg$put_chars (, 			  &cntrl_info_block.commands_display.id,  			  &str1_descrip,  			  &GEN_CMDS_ROW, 	 			  &j,   			  0,  			  &SMG$M_UNDERLINE, 			  &SMG$M_BOLD,  			  0)) 	    } 	}     }T  %     check_OK(smg$end_display_update (o. 	      &cntrl_info_block.commands_display.id)) }t     a /* **++ ** **  tbsp ** **-- **/s int	write_time(time_display_id)r" unsigned long int time_display_id; {  #define TIME_STR_LENGTH	    23  %     unsigned long int old_display_id;n     time_t time_val;     struct tm *tp;#     char time_str[TIME_STR_LENGTH];*)     $DESCRIPTOR (time_descrip, time_str);I%     long int start_row, start_column;      long int time_column;      char hour_str[3];l     int tm_hour;       smg$find_cursor_display (c( 	      &cntrl_info_block.pasteboard_id,  	      &old_display_id, 
 	      0, 
 	      0);       smg$return_cursor_pos (c 	      &old_display_id,  	      &start_row, f 	      &start_column);       /*     **	Get time information"     **/h  !     lib$date_time(&time_descrip);"  (     POINTER(time_descrip) = time_str+12;     LENGTH(time_descrip) = 8;e  6     if (cntrl_info_block.user_pref.update_in_second &&! 	strchr("13579", *(time_str+19)))i     {h         *(time_str+14) = ' ';c     }i  +     if ((tm_hour = atoi(time_str+12)) < 12)i     {h 	strcpy(time_str+17, " AM");     }"     else     {c 	strcpy(time_str+17, " PM"); 	if (tm_hour > 12) 	{- 	    sprintf(hour_str, "%02.2d", tm_hour-12);u& 	    memcpy(time_str+12, hour_str, 2); 	}     }u       /*=     **	Write the time information onto the upper right corner      **	of the screen     **/n  !     smg$begin_pasteboard_update ( ( 	      &cntrl_info_block.pasteboard_id);  6     time_column = cntrl_info_block.pasteboard_width-8;     smg$put_chars (e     	&time_display_id, ,     	&time_descrip,      	&TIME_ROW,      	&time_column, i     	0,      	0,      	0,      	0);       smg$set_cursor_abs ( 	      &old_display_id,  	      &start_row, a 	      &start_column);       smg$end_pasteboard_update ( ( 	      &cntrl_info_block.pasteboard_id); }	         . /* **++ ** **  tbs. ** **-- **/  int	clear_time() {,%     unsigned long int old_display_id; %     long int start_row, start_column;a)     $DESCRIPTOR (blank_time, "        ");t     long int time_column;   &     check_OK(smg$find_cursor_display (( 	      &cntrl_info_block.pasteboard_id,  	      &old_display_id, 
 	      0, 
 	      0))  $     check_OK(smg$return_cursor_pos ( 	      &old_display_id,  	      &start_row,   	      &start_column))       /*     **	Clear time display line     **/p  *     check_OK(smg$begin_pasteboard_update (( 	      &cntrl_info_block.pasteboard_id))  6     time_column = cntrl_info_block.pasteboard_width-8;     check_OK(smg$put_chars (. 	      &cntrl_info_block.commands_display.id,  	      &blank_time,  	      &TIME_ROW,  	      &time_column, .
 	      0, 
 	      0, 
 	      0, 
 	      0))  !     check_OK(smg$set_cursor_abs (_ 	      &old_display_id,  	      &start_row, r 	      &start_column))  (     check_OK(smg$end_pasteboard_update (( 	      &cntrl_info_block.pasteboard_id)) }O       /* **++ **  FUNCTIONAL DESCRIPTION:d ** **      tbsh ** **-- **/i& int	put_filer_pfs(pfs_def, display_id) char *pfs_def; unsigned long int display_id;  {      char filer_pfstr[81];l2     $DESCRIPTOR(filer_pfstr_descrip, filer_pfstr);       char str2[3]; $     $DESCRIPTOR(str2_descrip, str2);       long int i, j, f;_  '     check_OK(smg$begin_display_update (  	      &display_id))  !     strcpy(filer_pfstr, pfs_def);_6     LENGTH(filer_pfstr_descrip) = strlen(filer_pfstr);     check_OK(smg$put_chars ( 	      &display_id,  	      &filer_pfstr_descrip, r* 	      &cntrl_info_block.pasteboard_rows,  	      &1, o 	      &SMG$M_ERASE_TO_EOL,  	      &SMG$M_REVERSE,  
 	      0, 
 	      0))       strcpy(str2, "1");     LENGTH(str2_descrip) = 1;g     check_OK(smg$put_chars ( 	      &display_id,  	      &str2_descrip, * 	      &cntrl_info_block.pasteboard_rows,  	      &1, o
 	      0,  	      &SMG$M_BOLD, 
 	      0, 
 	      0))       LENGTH(str2_descrip) = 2; -     for (f = 2, i = 7; f <= 9; i += 8, f++) {e 	sprintf(str2, "%2.2d", f); 	 	j = i+1;, 	check_OK(smg$put_chars (* 		  &display_id, P 		  &str2_descrip,  ' 		  &cntrl_info_block.pasteboard_rows, ( 		  &j,  		  0, + 		  &SMG$M_BOLD, S 		  0,   		  0))        }      strcpy(str2, " 0");o(     LENGTH(str2_descrip) = strlen(str2);     j = i + 1;     check_OK(smg$put_chars ( 	      &display_id,  	      &str2_descrip, * 	      &cntrl_info_block.pasteboard_rows,  	      &j,  
 	      0,  	      &SMG$M_BOLD, 
 	      0, 
 	      0))  !     check_OK(smg$set_cursor_abs (a 	      &display_id, * 	      &cntrl_info_block.pasteboard_rows, + 	      &cntrl_info_block.pasteboard_width))   %     check_OK(smg$end_display_update (p 	      &display_id)) }      G /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/v. int	compute_filer_begin_xy(l, rowp, colp, win) struct fil_dx_tag *l;m long int *rowp,  	 *colp; unsigned short int win;	 {+     struct fil_dx_tag *p;+     int len;  2     for (p = l->forward;  p != l;  p = p->forward)     {m;         if (cntrl_info_block.dir_dx[win].form == long_form) 	         {_ 	    p->beg_y = *rowp; 	    p->beg_x = *colp;             (*rowp)++;	         }.         else	         {I              len = strlen(p->fn);,             if (len <= FILER_COLUMN_WIDTH-2)
             {  		p->beg_y = *rowp;  		p->beg_x = *colp;d 		*colp += FILER_COLUMN_WIDTH;
             }i3             else if (len <= 2*FILER_COLUMN_WIDTH-2)t
             {y3                 if (*colp > 2*FILER_COLUMN_WIDTH+1)n                 {w                     (*rowp)++; 		    *colp = 1;                 }N 		p->beg_y = *rowp;i 		p->beg_x = *colp;   		*colp += 2*FILER_COLUMN_WIDTH;
             }x3             else if (len <= 3*FILER_COLUMN_WIDTH-2)e
             {p1                 if (*colp > FILER_COLUMN_WIDTH+1)_                 {l                     (*rowp)++; 		    *colp = 1;                 }i 		p->beg_y = *rowp;  		p->beg_x = *colp;Y  		*colp += 3*FILER_COLUMN_WIDTH;
             }s             else S
             {S                 if (*colp > 1)                 {_                     (*rowp)++; 		    *colp = 1;                 }O 		p->beg_y = *rowp;_ 		p->beg_x = *colp;R  		*colp += 4*FILER_COLUMN_WIDTH;
             } -             if (*colp > 4*FILER_COLUMN_WIDTH)x
             {R                 (*rowp)++; 		*colp = 1;
             }E	         }Y     }d     return DX__NORMAL; }C     D /* **++ **  FUNCTIONAL DESCRIPTION:i **F **      WRITE_TO_FILER() writes all the files to current FILER display ** **-- **/  int write_to_filer(MARKER) struct fil_dx_tag *MARKER; {C     struct fil_dx_tag *p;e     char str[81]; "     $DESCRIPTOR(str_descrip, str);  ;     for (p = MARKER->forward; p != MARKER; p = p->forward) 	     {R6 	format_filer_entry(p, str, cntrl_info_block.cur_win); 	POINTER(str_descrip) = str;<         if (MARKER == DX_CURRENT_DIRECTORY.non_dir_filelist) 	{	/**  non-direcotry file  **/b' 	    LENGTH(str_descrip) = strlen(str);p 	    check_OK(smg$put_chars (_+ 			&DX_CURRENT_DIRECTORY.filer_display.id, R 			&str_descrip, _ 			&p->beg_y,  			&p->beg_x,  			0,  			0,  			0,  			0)) 	}2 	else if (DX_CURRENT_DIRECTORY.form == short_form)2         {	/**  Directory file with short form  **/' 	    LENGTH(str_descrip) = strlen(str);r 	    check_OK(smg$put_chars (_+ 			&DX_CURRENT_DIRECTORY.filer_display.id, T 			&str_descrip, l 			&p->beg_y,  			&p->beg_x,  			0,  			&SMG$M_BOLD,  			0,  			0)) 	} 	elseW* 	{	/**  Directory file with long form  **/ 	    char *cp;   	    LENGTH(str_descrip) = 1;n 	    check_OK(smg$put_chars (f+ 			&DX_CURRENT_DIRECTORY.filer_display.id, r 			&str_descrip, o 			&p->beg_y,  			&1,   			0,  			0,  			0,  			0))&             if (!strcmp(p->fn, "[-]"))
             {r 		check_OK(smg$put_chars (/ 			    &DX_CURRENT_DIRECTORY.filer_display.id, ? 			    $DESCR ("[-]"), 1 			    &p->beg_y,  			    &2, i
 			    0,  			    &SMG$M_BOLD, 
 			    0, 
 			    0))
             }c             else
             {l(                 if (strlen(p->fn) <= 30)                 { # 		    POINTER(str_descrip) = p->fn;s* 		    LENGTH(str_descrip) = strlen(p->fn);                 }s                 else                 { # 		    POINTER(str_descrip) = str+1; -                     LENGTH(str_descrip) = 30;                  }  		check_OK(smg$put_chars (/ 			    &DX_CURRENT_DIRECTORY.filer_display.id, _ 			    &str_descrip, _ 			    &p->beg_y,  			    &2, _
 			    0,  			    &SMG$M_BOLD, 
 			    0, 
 			    0)) 		cp = str+32; 		POINTER(str_descrip) = cp;# 		LENGTH(str_descrip) = strlen(cp);p 		check_OK(smg$put_chars (/ 			    &DX_CURRENT_DIRECTORY.filer_display.id, _ 			    &str_descrip, _ 			    &p->beg_y,  			    &33, 
 			    0, 
 			    0, 
 			    0, 
 			    0))
             } 	         }    	check_OK(smg$set_cursor_abs (. 		    &DX_CURRENT_DIRECTORY.filer_display.id,  		    &p->beg_y, m 		    &p->beg_x))      }r }e 		       e /* **++ **  FUNCTIONAL DESCRIPTION:  **? **      FORMAT_FILER_ENTRY () format a string for FILER displayt ** **-- **/ ( void	    format_filer_entry(p, str, win) struct fil_dx_tag *p;f
 char *str; unsigned short int win;	 {t.     char spro[5],   /**  PROTECTION CODES  **/ 	 opro[5], t 	 gpro[5], E
 	 wpro[5];!     unsigned short int timbuf[7];      unsigned long day_number;n     char ch;
     char *cp;t     DATE_TIME date_time, 	      resultant_time,
 	      today,s 	      yesterday,  	      delta_time, 	      weekday;L
     int g;     char wday[9];n       str[0] = EOS;  	      switch (p->state) {.  $ 	case ready:    ch = '*';	    break;$ 	case executed: ch = '+';	    break; 	case waiting:$ 	default:       ch = ' ';	    break;     }k  8     if (cntrl_info_block.dir_dx[win].form == short_form))     {	    /**  Display in short form  **/o)         sprintf (str, "%c%s", ch, p->fn);e     }g#     else if (!strcmp(p->fn, "[-]"))&0     {	    /**  Parent directory placeholder  **/ 	strcpy(str, " [-]");y     }      else8     {	    /**  Directory file or non-directory file  **/ 	if (p->fpro == 0Xffff)(# 	{	/**  Insufficient privilege  **/) 	    if (strlen(p->fn) <= 30)  		sprintf(str, c= 			"%c%-30.30s    insufficient privilege for read operation",r 			ch,
 			p->fn);	 	    elsep 		sprintf(str,  > 			"%c%-29.29s~    insufficient privilege for read operation", 			ch,
 			p->fn); 	} 	else if (p->fpro == 0Xfffe) 	{	/**  No such file  **/  	    if (strlen(p->fn) <= 30)K 		sprintf(str, e  			"%c%-30.30s    no such file", 			ch,
 			p->fn);	 	    elsec 		sprintf(str, 	! 			"%c%-29.29s~    no such file",e 			ch,
 			p->fn); 	} 	else  	{	/**  Normal file  **/) 	    /**  Processing file protection  **/ - 	    getpro(p->fpro, spro, opro, gpro, wpro);o  = 	    /**  Processing file creation date or revision date  **/nA             switch (cntrl_info_block.dir_dx[win].cur_filter.date);
             {                   case DX_CREDATE:F                     memcpy (&date_time, &p->cdat, sizeof (DATE_TIME)); 		    break;                  case DX_REVDATE:F                     memcpy (&date_time, &p->rdat, sizeof (DATE_TIME)); 		    break;                  case DX_EXPDATE:F                     memcpy (&date_time, &p->edat, sizeof (DATE_TIME)); 		    break;                  case DX_BAKDATE:F                     memcpy (&date_time, &p->bdat, sizeof (DATE_TIME)); 		    break;                 default:# 		    /**  Should never happen  **/	
 		    return;s
             }:   	    /**  Processing date  **/ 	    check_OK(sys$numtim (
 			  timbuf, d 			  &date_time))k* 	    convert_date_string("TODAY", &today);             if (lib$sub_times (r%                          &date_time,  !                          &today, _9                          &resultant_time) != LIB$_NEGTIM)_4             {	    /**  File created after today  **/ 		if (strlen(p->fn) <= 30) 		    sprintf (str, H 			     "%c%-30.30s Today    %2.2d:%02.2d:%02.2d %5.5d   (%s,%s,%s,%s)", 			     ch,E 			     p->fn, 			     timbuf[3], 			     timbuf[4], 			     timbuf[5], 			     p->filesize,
 			     spro,t
 			     opro,	
 			     gpro,  			     wpro); 		else 		    sprintf (str, I 			     "%c%-29.29s~ Today    %2.2d:%02.2d:%02.2d %5.5d   (%s,%s,%s,%s)",	 			     ch,c 			     p->fn, 			     timbuf[3], 			     timbuf[4], 			     timbuf[5], 			     p->filesize,
 			     spro, 
 			     opro,	
 			     gpro,  			     wpro);
             }r             else
             {	/ 		convert_date_string("YESTERDAY", &yesterday);  		if (lib$sub_times (i 			     &date_time,  			     &yesterday, ( 			     &resultant_time) != LIB$_NEGTIM)* 		{	/**  File created after yesterday  **/ 		    if (strlen(p->fn) <= 30) 			sprintf (str, $E 				 "%c%-30.30s Yesterdy %2.2d:%02.2d:%02.2d %5.5d   (%s,%s,%s,%s)",T 				 ch, 				 p->fn,R 				 timbuf[3],! 				 timbuf[4],  				 timbuf[5],h 				 p->filesize,l
 				 spro,
 				 opro,
 				 gpro, 				 wpro);D
 		    else 			sprintf (str,  F 				 "%c%-29.29s~ Yesterdy %2.2d:%02.2d:%02.2d %5.5d   (%s,%s,%s,%s)", 				 ch, 				 p->fn,C 				 timbuf[3],* 				 timbuf[4],* 				 timbuf[5],  				 p->filesize,u
 				 spro,
 				 opro,
 				 gpro, 				 wpro);  		}  		else2  		{	/**  File created earlier than yesterday  **/%         	    check_OK(lib$sub_times (r 				  &today,  				  &yesterday,  				  &delta_time))s  		    check_OK(lib$day_of_week ($                                  0, .                                  &day_number)) 		    day_number %= 7;8 		    memcpy (&weekday, &yesterday, sizeof (DATE_TIME));8                     for (g = day_number-2; g >= 0;  g--)                     { "         		check_OK(lib$sub_times ( 				   &weekday,   				   &delta_time,  				   &weekday))O 			if (lib$sub_times ( 				     &date_time,   				     &weekday, _) 				     &resultant_time) != LIB$_NEGTIM)  			{
 			    break;e 			}                     }                      switch (g)                     {s                         case 4:b5                             strcpy(wday, "Thursday");,
 			    break;)                         case 3:*5                             strcpy(wday, "Wednesdy");n
 			    break;                          case 2:M5                             strcpy(wday, "Tuesday "); 
 			    break;_                         case 1:b5                             strcpy(wday, "Monday  "); 
 			    break;                          case 0:n5                             strcpy(wday, "Sunday  ");;
 			    break;k                          default:+ 			    sprintf(wday, "%2.2d/%02.2d/%02.2d",_+ 					timbuf[0]-1900, timbuf[1], timbuf[2]); 
 			    break;                      }    		    if (strlen(p->fn) <= 30) 		    { * 			sprintf (str, "%c%-30.30s", ch, p->fn); 		    } 
 		    else 		    {t+ 			sprintf (str, "%c%-29.29s~", ch, p->fn);o 		    }sP                     if (timbuf[0] == 1858 && timbuf[1] == 11 && timbuf[2] == 17)                     {*L                         if (cntrl_info_block.dir_dx[win].cur_filter.date ==  			    DX_EXPDATE) 			{ 			    sprintf (str,- 				     "%s %-17.17s %5.5d   (%s,%s,%s,%s)",R
 				     str,r 				     "None specified", 				     p->filesize,e 				     spro, 				     opro, 				     gpro, 				     wpro);y 			}; 			else if (cntrl_info_block.dir_dx[win].cur_filter.date ==e 				DX_BAKDATE)c 			{ 			    sprintf (str,- 				     "%s %-17.17s %5.5d   (%s,%s,%s,%s)",l
 				     str,w 				     "No backup listed", 				     p->filesize,n 				     spro, 				     opro, 				     gpro, 				     wpro);E 			} 			else  			{ 			    sprintf (str,  ; 				     "%s %s %2.2d:%02.2d:%02.2d %5.5d   (%s,%s,%s,%s)",s
 				     str,1 				     wday, 				     timbuf[3],  				     timbuf[4],e 				     timbuf[5],( 				     p->filesize,; 				     spro, 				     opro, 				     gpro, 				     wpro);  			}                     }                      else                     {k 			sprintf (str, d7 				 "%s %s %2.2d:%02.2d:%02.2d %5.5d   (%s,%s,%s,%s)", 	 				 str, 
 				 wday, 				 timbuf[3],  				 timbuf[4],  				 timbuf[5],_ 				 p->filesize, 
 				 spro,
 				 opro,
 				 gpro, 				 wpro);                      }& 		}M
             }& 	}     }0 }      M /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/h  int	    setddir(dev_dir, errmsg) char *dev_dir;
 char *errmsg;d {i     struct FAB fab;a     struct NAM nam;b#     char expand_name[NAM$C_MAXRSS];m     char dev[MAXFILESPEC+1];#     $DESCRIPTOR (dev_descrip, dev);E     char dir[MAXFILESPEC+1];#     $DESCRIPTOR (dir_descrip, dir);i     unsigned long int status;t       /*<     **	Set default directory even if the directory specified6     **	does not exist.  First change the definition of0     **	SYS$DISK, and then set default directory.     **/m  +     /**  Initialize FAB and NAM blocks  **/        fab = cc$rms_fab;o     nam = cc$rms_nam;i  !     nam.nam$l_esa = &expand_name; !     nam.nam$b_ess = NAM$C_MAXRSS;        fab.fab$l_fna = dev_dir;*     fab.fab$b_fns = strlen(fab.fab$l_fna);     fab.fab$l_nam = &nam;"  #     status = sys$parse(&fab, 0, 0);e     if (!(status & 1))     {s; 	strcpy(errmsg, "directory or file specification invalid");f 	return DX__ERROR;     }f  0     strncpy (dev, nam.nam$l_dev, nam.nam$b_dev);     dev[nam.nam$b_dev] = EOS;r  0     strncpy (dir, nam.nam$l_dir, nam.nam$b_dir);     dir[nam.nam$b_dir] = EOS;p  /     /**  Change the definition of SYS$DISK  **/s&     LENGTH(dev_descrip) = strlen(dev);     status = lib$set_logical ( 		  $DESCR ("SYS$DISK"), 		  &dev_descrip,  		  0, u 		  0, ; 		  0); 8     if (status != SS$_NORMAL && status != SS$_SUPERSEDE)     {g; 	strcpy(errmsg, "directory or file specification invalid");a 	return DX__ERROR;     }&  '     /**  Set new default directory  **/e&     LENGTH(dir_descrip) = strlen(dir);     status = sys$setddir ( 		&dir_descrip,l 		0, 		0);      if (!(status & 1))     {W; 	strcpy(errmsg, "directory or file specification invalid");0 	return DX__ERROR;     }s       return DX__NORMAL; }      & /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbsb ** **-- **/ " int	highlight_filer_current_file() {;     int rows_in_page,* 	current_page;     char str[81];n"     $DESCRIPTOR(str_descrip, str);     char page_str[81];,     $DESCRIPTOR(page_str_descrip, page_str);     char row_str[81];"*     $DESCRIPTOR(row_str_descrip, row_str);     int row_beg_y;  B     if (DX_CURRENT_FILE != DX_CURRENT_DIRECTORY.non_dir_filelist) '     {	    /**  Directory not empty  **/ D 	format_filer_entry(DX_CURRENT_FILE, str, cntrl_info_block.cur_win);   	current_page = ! 	  1+(DX_CURRENT_FILE->beg_y-1) / 2 	    DX_CURRENT_DIRECTORY.filer_display.view_rows;* 	sprintf(page_str, "Pg %d", current_page);- 	LENGTH(page_str_descrip) = strlen(page_str);   4 	sprintf(row_str, "Row %d", DX_CURRENT_FILE->beg_y);+ 	LENGTH(row_str_descrip) = strlen(row_str);d  +         check_OK(smg$begin_display_update (I@                      &DX_CURRENT_DIRECTORY.dir_info_display.id)) 	check_OK(smg$draw_line (_/ 		  &DX_CURRENT_DIRECTORY.dir_info_display.id,  1 		  &DX_CURRENT_DIRECTORY.dir_info_display.rows,   		  &1, 1 		  &DX_CURRENT_DIRECTORY.dir_info_display.rows, o2 		  &DX_CURRENT_DIRECTORY.dir_info_display.width,  		  0, R 		  0))  	check_OK(smg$put_chars ( 1 		    &DX_CURRENT_DIRECTORY.dir_info_display.id, * 		    &page_str_descrip,  3 		    &DX_CURRENT_DIRECTORY.dir_info_display.rows, S
 		    &2, 	 		    0, c 		    &SMG$M_BOLD,  	 		    0, r	 		    0)) ( 	row_beg_y = LENGTH(page_str_descrip)+4; 	check_OK(smg$put_chars (c1 		    &DX_CURRENT_DIRECTORY.dir_info_display.id, d 		    &row_str_descrip, 3 		    &DX_CURRENT_DIRECTORY.dir_info_display.rows, l 		    &row_beg_y, 	 		    0, s 		    &SMG$M_BOLD,  	 		    0, d	 		    0))&)         check_OK(smg$end_display_update (b@                      &DX_CURRENT_DIRECTORY.dir_info_display.id))  H         if (DX_CURRENT_FILE->fn[ strlen(DX_CURRENT_FILE->fn)-1 ] != ']')1 	{	/**  Current file is not a directory file  **/p' 	    LENGTH(str_descrip) = strlen(str);& 	    check_OK(smg$put_chars (n+ 			&DX_CURRENT_DIRECTORY.filer_display.id,   			&str_descrip, $ 			&DX_CURRENT_FILE->beg_y,  			&DX_CURRENT_FILE->beg_x,  			0,  			0,  			&SMG$M_REVERSE, ; 			0)) 	}2 	else if (DX_CURRENT_DIRECTORY.form == short_form)2         {	/**  Directory file with short form  **/' 	    LENGTH(str_descrip) = strlen(str);b 	    check_OK(smg$put_chars (++ 			&DX_CURRENT_DIRECTORY.filer_display.id,   			&str_descrip, r 			&DX_CURRENT_FILE->beg_y,  			&DX_CURRENT_FILE->beg_x,  			0,  			&SMG$M_BOLD,  			&SMG$M_REVERSE, & 			0)) 	} 	else * 	{	/**  Directory file with long form  **/( 	    check_OK(smg$begin_display_update (, 			 &DX_CURRENT_DIRECTORY.filer_display.id)) 	    LENGTH(str_descrip) = 1;_ 	    check_OK(smg$put_chars ( + 			&DX_CURRENT_DIRECTORY.filer_display.id,   			&str_descrip, k 			&DX_CURRENT_FILE->beg_y,  			&1, g 			0,  			0,  			&SMG$M_REVERSE, a 			0))&             if (!strcmp(str+1, "[-]"))
             {  		check_OK(smg$put_chars (/ 			    &DX_CURRENT_DIRECTORY.filer_display.id,   			    $DESCR ("[-]"), o  			    &DX_CURRENT_FILE->beg_y,  			    &2, n
 			    0,  			    &SMG$M_BOLD,  			    &SMG$M_REVERSE,  
 			    0))
             }p             else
             {f
 		int offset;o   		POINTER(str_descrip) = str+1; > 		LENGTH(str_descrip) = min (30, strlen(DX_CURRENT_FILE->fn)); 		check_OK(smg$put_chars (/ 			    &DX_CURRENT_DIRECTORY.filer_display.id, t 			    &str_descrip,    			    &DX_CURRENT_FILE->beg_y,  			    &2,  
 			    0,  			    &SMG$M_BOLD,  			    &SMG$M_REVERSE, F
 			    0))  ! 		offset = 1+LENGTH(str_descrip);l$ 		POINTER(str_descrip) = str+offset;+ 		LENGTH(str_descrip) = strlen(str+offset);  		offset++;N 		check_OK(smg$put_chars (/ 			    &DX_CURRENT_DIRECTORY.filer_display.id,   			    &str_descrip,    			    &DX_CURRENT_FILE->beg_y,  			    &offset, 
 			    0, 
 			    0,  			    &SMG$M_REVERSE,  
 			    0))
             }_& 	    check_OK(smg$end_display_update (, 			 &DX_CURRENT_DIRECTORY.filer_display.id))	         }  	check_OK(smg$set_cursor_abs (, 		  &DX_CURRENT_DIRECTORY.filer_display.id,  		  &DX_CURRENT_FILE->beg_y, x 		  &DX_CURRENT_FILE->beg_x))C     }I };       /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ $ int	unhighlight_filer_current_file() {      char str[81]; "     $DESCRIPTOR(str_descrip, str);  B     if (DX_CURRENT_FILE != DX_CURRENT_DIRECTORY.non_dir_filelist) '     {	    /**  Directory not empty  **/ D 	format_filer_entry(DX_CURRENT_FILE, str, cntrl_info_block.cur_win);# 	LENGTH(str_descrip) = strlen(str); H         if (DX_CURRENT_FILE->fn[ strlen(DX_CURRENT_FILE->fn)-1 ] != ']')1 	{	/**  Current file is not a directory file  **/l' 	    LENGTH(str_descrip) = strlen(str);  	    check_OK(smg$put_chars (M+ 			&DX_CURRENT_DIRECTORY.filer_display.id, t 			&str_descrip, e 			&DX_CURRENT_FILE->beg_y,  			&DX_CURRENT_FILE->beg_x,  			0,  			0,  			0,  			0)) 	}2 	else if (DX_CURRENT_DIRECTORY.form == short_form)2         {	/**  Directory file with short form  **/' 	    LENGTH(str_descrip) = strlen(str);C 	    check_OK(smg$put_chars (s+ 			&DX_CURRENT_DIRECTORY.filer_display.id, N 			&str_descrip, s 			&DX_CURRENT_FILE->beg_y,  			&DX_CURRENT_FILE->beg_x,  			0,  			&SMG$M_BOLD,  			0,  			0)) 	} 	else	* 	{	/**  Directory file with long form  **/( 	    check_OK(smg$begin_display_update (, 			 &DX_CURRENT_DIRECTORY.filer_display.id)) 	    LENGTH(str_descrip) = 1;  	    check_OK(smg$put_chars (=+ 			&DX_CURRENT_DIRECTORY.filer_display.id, _ 			&str_descrip, R 			&DX_CURRENT_FILE->beg_y,  			&1, c 			0,  			0,  			0,  			0))&             if (!strcmp(str+1, "[-]"))
             {e 		check_OK(smg$put_chars (/ 			    &DX_CURRENT_DIRECTORY.filer_display.id, T 			    $DESCR ("[-]"),    			    &DX_CURRENT_FILE->beg_y,  			    &2, C
 			    0,  			    &SMG$M_BOLD, 
 			    0, 
 			    0))
             }	             else
             { 
 		int offset;r   		POINTER(str_descrip) = str+1; > 		LENGTH(str_descrip) = min (30, strlen(DX_CURRENT_FILE->fn)); 		check_OK(smg$put_chars (/ 			    &DX_CURRENT_DIRECTORY.filer_display.id,   			    &str_descrip, O  			    &DX_CURRENT_FILE->beg_y,  			    &2,  
 			    0,  			    &SMG$M_BOLD, 
 			    0, 
 			    0))! 		offset = 1+LENGTH(str_descrip); $ 		POINTER(str_descrip) = str+offset;+ 		LENGTH(str_descrip) = strlen(str+offset);  		offset++;  		check_OK(smg$put_chars (/ 			    &DX_CURRENT_DIRECTORY.filer_display.id, r 			    &str_descrip,    			    &DX_CURRENT_FILE->beg_y,  			    &offset, 
 			    0, 
 			    0, 
 			    0, 
 			    0))
             }s& 	    check_OK(smg$end_display_update (, 			 &DX_CURRENT_DIRECTORY.filer_display.id))	         }O 	check_OK(smg$set_cursor_abs (I 		  &cntrl_info_block.dir_dx[cntrl_info_block.cur_win].filer_display.id, c 		  &DX_CURRENT_FILE->beg_y, ( 		  &DX_CURRENT_FILE->beg_x))f     }s }y       /* **++ **  FUNCTIONAL DESCRIPTION:y **1 **      PUT_FILER_TITLE() outputs the header line	 ** **-- **/  int	put_filer_title(win) unsigned short int win;s { !     char cwd_line[MAXFILESPEC+1];i-     $DESCRIPTOR (cwd_line_descrip, cwd_line);)     char mod[10], dir[10];       /**  Output cwd line  **/P8     if (cntrl_info_block.dir_dx[win].filemode == single)     {E         strcpy(mod, "Single");     }r     else     {,          strcpy(mod, "Multiple");     }*:     if (cntrl_info_block.dir_dx[win].direction == advance)     {T         strcpy(dir, "Forward");p     }E     else     {           strcpy(dir, "Backward");     }n:     if (strlen(cntrl_info_block.dir_dx[win].cur_dir) > 56),     {	    /**  Directory name truncated  **/3 	sprintf(cwd_line, " %-55.55s~ | %-8.8s | %-8.8s ", ' 		cntrl_info_block.dir_dx[win].cur_dir,[ 		dir, mod);     }E     else&     {	    /**  Directory name fit  **/2 	sprintf(cwd_line, " %-56.56s | %-8.8s | %-8.8s ",' 		cntrl_info_block.dir_dx[win].cur_dir,  		dir, mod);     };0     LENGTH(cwd_line_descrip) = strlen(cwd_line);     check_OK(smg$put_chars (: 	      &cntrl_info_block.dir_dx[win].dir_info_display.id,  	      &cwd_line_descrip,  	      &FILER_DIRECT_ROW,  	      &FILER_DIRECT_COLUMN, i 	      &SMG$M_ERASE_LINE,  	      &SMG$M_REVERSE,  
 	      0, 
 	      0)) }      o /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/* int	put_filer_stat(win)  unsigned short int win;f {<'     char total_str[81], select_str[81];      int spaces;i     int start_col;     char str[MAXFILESPEC+1];#     $DESCRIPTOR (str_descrip, str);-       /*     **	Write statistics line     **/i  &     /*  Put FILER statistics line  **/+     sprintf(total_str, "total: %ldf/%ldb",  ) 		cntrl_info_block.dir_dx[win].tot_files,t+ 		cntrl_info_block.dir_dx[win].tot_blocks);,1     sprintf(select_str, "selections: %ldf/%ldb", -) 		cntrl_info_block.dir_dx[win].sel_files,n+ 		cntrl_info_block.dir_dx[win].sel_blocks);      spaces = max (1,; 	FILER_RIGHTMOST-3-(strlen(total_str)+strlen(select_str)));)  #     sprintf(str, " %s", total_str);n*     memset (str+strlen(str), ' ', spaces);*     str[1+strlen(total_str)+spaces] = EOS;     strcat(str, select_str);  &     LENGTH(str_descrip) = strlen(str);     check_OK(smg$put_chars (5 		&cntrl_info_block.dir_dx[win].dir_info_display.id,   		&str_descrip,  		&FILER_STAT_ROW,   		&1,  	        &SMG$M_ERASE_TO_EOL,  		&SMG$M_BOLD,   		0, ; 		0))  }      a /* **++ **  FUNCTIONAL DESCRIPTION:c ** **      to be specifiede ** **-- **/; int	    filter_alarm_working() {e      static int remain_alarm = 2;  3     if (cntrl_info_block.user_pref.display_clock && - 	cntrl_info_block.user_pref.update_in_second)S     {e2 	write_time(cntrl_info_block.commands_display.id);     }*       remain_alarm--;      if (remain_alarm > 0)      {m' 	signal(SIGALRM, filter_alarm_working);d     }i     else     {y 	remain_alarm = 2;) 	signal(SIGALRM, filter_alarm_working$1);&     }m  
     alarm(1);  }        /* **++ **  FUNCTIONAL DESCRIPTION:e ** **      to be specified_ ** **-- **/	' static int	    filter_alarm_working$1()	 {(     static int switch_on = 0;i#     static int remain_timeout = 60;        if (!switch_on)%     {(         switch_on++;          check_OK(smg$put_chars (<                      &cntrl_info_block.commands_display.id, ,                      $DESCR ("Working..."),                       &2,                        &1,                        0,                       0,                       0,                       0))     }      else     {	         switch_on = 0;"         check_OK(smg$erase_chars (<                      &cntrl_info_block.commands_display.id,                       &10,                       &2, o                      &1))Y     }t  1     if (cntrl_info_block.user_pref.display_clock)      { 1 	if (cntrl_info_block.user_pref.update_in_second)G 	{6 	    write_time(cntrl_info_block.commands_display.id); 	} 	elsen 	{ 	    remain_timeout--; 	    if (remain_timeout == 0)2 	    {8 	    	 write_time(cntrl_info_block.commands_display.id); 		 remain_timeout = 60;m 	    } 	}     }u  ,     signal(SIGALRM, filter_alarm_working$1);
     alarm(1);  }	     D /* **++ **  FUNCTIONAL DESCRIPTION:" ** **      to be specified2 ** **-- **/d% int	find_full_path_name(fn, buf, win)n	 char *fn;m
 char *buf; unsigned short int win;u {]
     char *cp;e       if (!strcmp(fn, "[-]")) <     {	    /**  This is the parent directory placeholder  **/ 	strcpy(buf, "[-]");     } %     else if (fn[strlen(fn)-1] != ']') /     {	    /** This is a non-directory file  **/t$         if (strchr(fn, ':') != NULL)	         {              strcpy(buf, fn);	         }          else if (fn[0] == '[')5 	{	/**  Directory name included in the file name  **/s 	    size_t len;   	    len = strcspn (O 		DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list->w_dids->equivalent_name, h 		"[");b             strncpy (buf, O 		DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list->w_dids->equivalent_name, & 		len);, 	    buf[len] = EOS; 	    strcat (buf, fn); 	} 	elseB*         {	/**  Directory not included  **/!             sprintf(buf, "%s%s",  W 		cntrl_info_block.dir_dx[win].cur_filter.name_filespec_list->w_dids->equivalent_name,   		fn);	         }w     }h     else,     {	    /**  This is a directory file  **/" 	/**  Get full directory name  **/         if (strchr (fn, ':')) 9         {	/**  Device name included in the file name  **/              strcpy(buf, fn);	         }	.         else if (*(strchr (fn, '[')+1) != '.')( 	{	/**  More than one sub-directory  **/ 	    size_t len;   	    len = strcspn (O 		DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list->w_dids->equivalent_name,   		"[");k 	    strncpy ( 		buf,  O 		DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list->w_dids->equivalent_name, u 		len);b 	    buf[len] = EOS; 	    strcat(buf, fn);  	} 	else # 	{	/**  Only one sub-directory  **/	_ 	    strcpy (buf, DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list->w_dids->equivalent_name);95 	    buf[ strlen(buf)-1 ] = EOS;	/**  Delete ']'  **/( 	    strcat (buf, fn+1); 	}   	/**  Delete ']'  **/) 	buf[strlen(buf)-1] = EOS;   	cp = strrchr(buf, '.'); r0 	*cp = ']';	/**  Change the last '.' to ']'  **/ 	strcat(buf, ".DIR;1");      }n }(     	 /* **++ **  FUNCTIONAL DESCRIPTION:s ** **      to be specified  ** **-- **/d/ int	convert_date_string(date_string, date_time)  char *date_string; DATE_TIME *date_time;  {}3     $DESCRIPTOR (date_string_descrip, date_string);.     int days_of_month[12] =  	{3 	    31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31% 	};%     struct 	 	{ 	    unsigned short > 		year, month, day, hour, minute, second, hundredth_of_second;
 	} timbuf;       check_OK(sys$numtim (                   &timbuf,                   0))  "     if (timbuf.year % 400 == 0 || 2 	(timbuf.year % 4 == 0 && timbuf.year % 100 != 0))     {  	days_of_month[1] = 29;m     }e  '     if (!strcmp (date_string, "TODAY"))e     {	 	timbuf.hour = timbuf.minute =  4 	    timbuf.second = timbuf.hundredth_of_second = 0;     } 0     else if (!strcmp (date_string, "YESTERDAY"))     {( 	timbuf.hour = timbuf.minute d6 	    = timbuf.second = timbuf.hundredth_of_second = 0;         timbuf.day--;	         if (timbuf.day < 1)_	         {i             timbuf.month--;r!             if (timbuf.month > 0) 
             {&;                 timbuf.day = days_of_month[timbuf.month-1]; 
             }R             else
             {*                 timbuf.year--; 		timbuf.month = 12; 		timbuf.day = 31;
             }t	         }      }u/     else if (!strcmp (date_string, "TOMORROW"))m     {h 	timbuf.hour = timbuf.minute S6 	    = timbuf.second = timbuf.hundredth_of_second = 0;         timbuf.day++;r8         if (timbuf.day > days_of_month[timbuf.month-1] )	         {t             timbuf.day = 1;e 	    timbuf.month++;"             if (timbuf.month > 12)
             { !                 timbuf.month = 1;e 		timbuf.year++;
             } 	         }l     }      else     {*3 	LENGTH(date_string_descrip) = strlen(date_string);          check_OK(sys$bintim (a+                      &date_string_descrip,                         date_time))         check_OK(sys$numtim (f                      &timbuf,                        date_time))     }        check_OK(lib$cvt_vectim (s                  &timbuf,                   date_time)) }r