 /* **++
 **  FACILITY:  ** **      FILERTCUS.C  **
 **  ABSTRACT:  ** **       tbs ** **  AUTHORS: ** **      C. K. Hung  **	Planning Research Corporation **	1150 Gemini Avenue  **	Houston, TX 77058 **	Phone: (713)282-6227  **! **  CREATION DATE:     8-JAN-1991  ** **  MODIFICATION HISTORY:   **	(11Apr91)CKH	Upgrade to DX II **-- **/    /* ** **  INCLUDE FILES  ** **/    #include "global.h"  #include "filercus.h"  #include "filerque.h"  #include "inquire.h" #include "menunavi.h"    /* ** **  FUNCTIONAL PROTOTYPING ** **/   # static int	select_a_display_date$1( 7 		    short int dattype, enum sortbys sortdat, char *);        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/  int	custom_editor()  {      char errmsg[MAXFILESPEC+1];      char current_editor[4];   0     switch (cntrl_info_block.user_pref.editor) {           case DX_EDITOR_EDT: *             strcpy(current_editor, "EDT"); 	    break;          case DX_EDITOR_TPU: *             strcpy(current_editor, "TPU"); 	    break;          default:*             strcpy(current_editor, "LSE"); 	    break;        }   *     strcpy(errmsg, "Invalid input value");     get_userinput_and_execute( 	select_a_editor,  	"Select an Editor",* 	"Choose an editor: [EDT, TPU, or LSE] ",  	current_editor, 	errmsg,
 	"dummy"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ * int	select_a_editor(editor, dummy, errmsg)
 char *editor;  char *dummy;
 char *errmsg;  {      int len;       len = strlen(editor); G     if (!strncmp(editor, "EDT", len))		/**   User likes EDT better  **/   3 	cntrl_info_block.user_pref.editor = DX_EDITOR_EDT;   K     else if (!strncmp(editor, "TPU", len))	/**  Use TPU as the editor   **/   3 	cntrl_info_block.user_pref.editor = DX_EDITOR_TPU;   K     else if (!strncmp(editor, "LSE", len))	/**  Use LSE as the editor   **/   3 	cntrl_info_block.user_pref.editor = DX_EDITOR_LSE;        else     { & 	strcpy(errmsg, "Invalid input data"); 	return DX__ERROR;     }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/  int	custom_display_date()  {      char errmsg[MAXFILESPEC+1]; #     char init_value[MAXFILESPEC+1];   1     switch (DX_CURRENT_DIRECTORY.cur_filter.date)      {          case DX_CREDATE:*             strcpy(init_value, "CREATED"); 	    break;          case DX_REVDATE:+             strcpy(init_value, "MODIFIED");  	    break;          case DX_EXPDATE:*             strcpy(init_value, "EXPIRED"); 	    break;          case DX_BAKDATE:)             strcpy(init_value, "BACKUP");  	    break;          default:             return DX__ERROR;      }   *     strcpy(errmsg, "Invalid input value");     get_userinput_and_execute( 	select_a_display_date,  	"Select a display date type",9 	"Choose one: [CREATED, MODIFIED, EXPIRED, or BACKUP] ",  
 	init_value,   	errmsg,
 	"dummy"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ - int	select_a_display_date(dat, dummy, errmsg) 
 char *dat; char *dummy;
 char *errmsg;  {      int len;       len = strlen(dat);  H     if (!strncmp(dat, "CREATED", len))		/**  Display creation date   **/     { : 	select_a_display_date$1(DX_CREDATE, sortcredate, errmsg);     } M     else if (!strncmp(dat, "MODIFIED", len))	/**  Display revision date   **/      { : 	select_a_display_date$1(DX_REVDATE, sortrevdate, errmsg);     } L     else if (!strncmp(dat, "EXPIRED", len))	/**  Display expiration date **/     { : 	select_a_display_date$1(DX_EXPDATE, sortexpdate, errmsg);     } K     else if (!strncmp(dat, "BACKUP", len))	/**  Display backup date     **/      { : 	select_a_display_date$1(DX_BAKDATE, sortbakdate, errmsg);     } -     else					/**  Invalid input value     **/      {  	return DX__ERROR;     }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ < static int	select_a_display_date$1(dattype, sortdat, errmsg) short int dattype; enum sortbys sortdat; 
 char *errmsg;  {      static unsigned int timlen;        char since[50]; *     $DESCRIPTOR (since_descriptor, since);     char before[50];,     $DESCRIPTOR (before_descriptor, before);     enum sortbys old_sortby;       check_OK(sys$asctim (  		&timlen,   		&since_descriptor,  * 		&DX_CURRENT_DIRECTORY.cur_filter.since,  		0))      since[ timlen ] = EOS;     check_OK(sys$asctim (  		&timlen,   		&before_descriptor, + 		&DX_CURRENT_DIRECTORY.cur_filter.before,   		0))      before[ timlen ] = EOS;   8     if (DX_CURRENT_DIRECTORY.cur_filter.date != dattype)     { 0 	DX_CURRENT_DIRECTORY.cur_filter.date = dattype;* 	old_sortby = DX_CURRENT_DIRECTORY.sortby;2 	if (DX_CURRENT_DIRECTORY.sortby == sortcredate ||2 	    DX_CURRENT_DIRECTORY.sortby == sortrevdate ||2 	    DX_CURRENT_DIRECTORY.sortby == sortexpdate ||0 	    DX_CURRENT_DIRECTORY.sortby == sortbakdate)+ 	{	/**  Current directory sort by date  **/ + 	    DX_CURRENT_DIRECTORY.sortby = sortdat;  	}  ) 	if (strncmp(since, "17-NOV-1858", 11) && ( 	    strncmp(before, "31-DEC-2857", 11))& 	{	/**  SINCE and BOFORE not null  **/* 	    filer_filter$1("", "Update", errmsg); 	}" 	else if (old_sortby != sortdat && 		 old_sortby != sortname && 		 old_sortby != sorttype && 		 old_sortby != sortsize && 		 old_sortby != sortmark)( 	{	/**  Was sort by other date type  **/ 	    filer_sort$1(/ 		DX_CURRENT_DIRECTORY.sortorder == ascending?  ! 		    "ASCENDING" : "DESCENDING", 	 		"Date", 
 		errmsg); 	} 	else  	{	/**  Not sort by date  **/ ( 	    check_OK(smg$begin_display_update (, 			 &DX_CURRENT_DIRECTORY.filer_display.id))  ! 	    check_OK(smg$erase_display ( , 			 &DX_CURRENT_DIRECTORY.filer_display.id,  			 0,   			 0,   			 0,   			 0))   7 	    write_to_filer(DX_CURRENT_DIRECTORY.dir_filelist); ; 	    write_to_filer(DX_CURRENT_DIRECTORY.non_dir_filelist);   5 	    change_filer_viewport(cntrl_info_block.cur_win);   $ 	    highlight_filer_current_file();  & 	    check_OK(smg$end_display_update (, 			 &DX_CURRENT_DIRECTORY.filer_display.id)) 	}     }  }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/  int	custom_delete()  {      char errmsg[MAXFILESPEC+1];   *     strcpy(errmsg, "Invalid input value");     get_userinput_and_execute( 	confirm_delete,   	"File Delete Confirmation",- 	"Confirm on each file DELETION? [YES/NO] ",  ; 	(cntrl_info_block.user_pref.delete_confirm? "YES" : "NO"),  	errmsg,
 	"dummy"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ * int	confirm_delete(confirm, dummy, errmsg) char *confirm; char *dummy;
 char *errmsg;  {      int len;       len = strlen(confirm);O     if (!strncmp(confirm, "YES", len))	    /** Confirm before deletion      **/   / 	cntrl_info_block.user_pref.delete_confirm = 1;   P     else if (!strncmp(confirm, "NO", len))  /** Do not confirm before delete **/  / 	cntrl_info_block.user_pref.delete_confirm = 0;        else     { & 	strcpy(errmsg, "Invalid input data"); 	return DX__ERROR;     }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/  int	custom_purge() {      char errmsg[MAXFILESPEC+1];   *     strcpy(errmsg, "Invalid input value");     get_userinput_and_execute( 	confirm_purge,  	"File Purge Confirmation", * 	"Confirm on each file PURGE? [YES/NO] ", : 	(cntrl_info_block.user_pref.purge_confirm? "YES" : "NO"), 	errmsg,
 	"dummy"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ ) int	confirm_purge(confirm, dummy, errmsg)  char *confirm; char *dummy;
 char *errmsg;  {      int len;       len = strlen(confirm);L     if (!strncmp(confirm, "YES", len))	    /** Confirm before purge	     **/  . 	cntrl_info_block.user_pref.purge_confirm = 1;  P     else if (!strncmp(confirm, "NO", len))  /** Do not confirm before purge  **/  . 	cntrl_info_block.user_pref.purge_confirm = 0;       else     { & 	strcpy(errmsg, "Invalid input data"); 	return DX__ERROR;     }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/  int	custom_type()  {      char errmsg[MAXFILESPEC+1];   *     strcpy(errmsg, "Invalid input value");     get_userinput_and_execute( 	select_type_method,   	"Type by Page",- 	"Display one screen at a time? [YES/NO] ",   9 	(cntrl_info_block.user_pref.type_by_page? "YES" : "NO"),  	errmsg,
 	"dummy"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ . int	select_type_method(confirm, dummy, errmsg) char *confirm; char *dummy;
 char *errmsg;  {      int len;       len = strlen(confirm);O     if (!strncmp(confirm, "YES", len))	    /** Type the file page-by-page   **/   - 	cntrl_info_block.user_pref.type_by_page = 1;   P     else if (!strncmp(confirm, "NO", len))  /** Type the file continuously   **/  - 	cntrl_info_block.user_pref.type_by_page = 0;        else     { & 	strcpy(errmsg, "Invalid input data"); 	return DX__ERROR;     }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/  int	custom_auto_update() {      char errmsg[MAXFILESPEC+1];   7     strcpy(errmsg, "Error setting AUTO UPDATE option");      get_userinput_and_execute( 	auto_update,  	"Automatically Update",8 	"Update after each EDIT, LAUNCH, or EXECUTE? [Y/N] ",  8 	(cntrl_info_block.user_pref.auto_update? "YES" : "NO"), 	errmsg,
 	"dummy"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ ' int	auto_update(confirm, dummy, errmsg)  char *confirm; char *dummy;
 char *errmsg;  {      int len;       len = strlen(confirm);L     if (!strncmp(confirm, "YES", len))	    /** Update after session	     **/  , 	cntrl_info_block.user_pref.auto_update = 1;  H     else if (!strncmp(confirm, "NO", len))   /** Do not update		     **/  , 	cntrl_info_block.user_pref.auto_update = 0;       else     { & 	strcpy(errmsg, "Invalid input data"); 	return DX__ERROR;     }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/  int	custom_display_clock() {      char errmsg[MAXFILESPEC+1];   9     strcpy(errmsg, "Error setting DISPLAY CLOCK option");      get_userinput_and_execute( 	display_clock,  	"Display Clock", + 	"Display clock in this session? [Y/N] ",   : 	(cntrl_info_block.user_pref.display_clock? "YES" : "NO"), 	errmsg,
 	"dummy"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ ) int	display_clock(confirm, dummy, errmsg)  char *confirm; char *dummy;
 char *errmsg;  {      int len;       len = strlen(confirm);L     if (!strncmp(confirm, "YES", len))	    /** Update after session	     **/  . 	cntrl_info_block.user_pref.display_clock = 1;  H     else if (!strncmp(confirm, "NO", len))   /** Do not update		     **/     { . 	cntrl_info_block.user_pref.display_clock = 0; 	clear_time();       }      else     { & 	strcpy(errmsg, "Invalid input data"); 	return DX__ERROR;     }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/  int	custom_update_in_second()  {      char errmsg[MAXFILESPEC+1];   =     strcpy(errmsg, "Error setting FLASH CLOCK COLON option");      get_userinput_and_execute( 	update_in_second,   	"Flash Clock Colon", " 	"Flash clock colon? [ON/OFF] ",  = 	(cntrl_info_block.user_pref.update_in_second? "ON" : "OFF"),  	errmsg,
 	"dummy"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ , int	update_in_second(confirm, dummy, errmsg) char *confirm; char *dummy;
 char *errmsg;  {      int len;       len = strlen(confirm);  &     if (confirm[0] == 'O' && len == 1)     { ? 	strcpy(errmsg, "Ambugious response - supply more characters");  	return DX__ERROR;     } S     else if (!strncmp(confirm, "ON", len))	/** Update the clock every second    **/      { 5         cntrl_info_block.user_pref.display_clock = 1; 1 	cntrl_info_block.user_pref.update_in_second = 1;      } S     else if (!strncmp(confirm, "OFF", len))/** Update the clock every 60 seconds**/      { 5         cntrl_info_block.user_pref.display_clock = 1; 1 	cntrl_info_block.user_pref.update_in_second = 0; 2 	write_time(cntrl_info_block.commands_display.id);     }      else     { & 	strcpy(errmsg, "Invalid input data"); 	return DX__ERROR;     }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **	tbs ** **-- **/  int	custom_save_setting()  {      char errmsg[MAXFILESPEC+1];   3     strcpy(errmsg, "Error save setting to a file");      get_userinput_and_execute( 	save_setting,   	"Save Setting", 	"Save to: ",    	DEFAULT_STARTUP,  	errmsg,
 	"dummy"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ ) int	save_setting(filename, dummy, errmsg)  char *filename;  char *dummy;
 char *errmsg;  {      FILE *f;!     struct fil_dx_tag temp_entry; 
     int i;  ,     if ((f = fopen (filename, "w")) == NULL)     { :         sprintf (errmsg, "Error creating an output file"); 	return DX__ERROR;     }   #     fprintf (f, "DX.short_form: "); 0     if (DX_CURRENT_DIRECTORY.form == short_form)     {          fprintf (f, "YES\n");      }      else     {          fprintf (f, "NO\n");     }        fprintf (f, "DX.editor: "); .     switch (cntrl_info_block.user_pref.editor)     {          case DX_EDITOR_EDT: !             fprintf (f, "EDT\n");  	    break;          case DX_EDITOR_TPU: !             fprintf (f, "TPU\n");  	    break;          case DX_EDITOR_LSE: !             fprintf (f, "LSE\n");  	    break;      } %     fprintf (f, "DX.display_date: "); 1     switch (DX_CURRENT_DIRECTORY.cur_filter.date)      {          case DX_CREDATE:$             fprintf(f, "CREATED\n"); 	    break;          case DX_REVDATE:%             fprintf(f, "MODIFIED\n");  	    break;          case DX_EXPDATE:$             fprintf(f, "EXPIRED\n"); 	    break;          case DX_BAKDATE:#             fprintf(f, "BACKUP\n");  	    break;          default:             return DX__ERROR;      } )         fprintf (f, "DX.type_by_page: "); 0     if (cntrl_info_block.user_pref.type_by_page)     {          fprintf (f, "YES\n");      }      else     {          fprintf (f, "NO\n");     } '     fprintf (f, "DX.delete_confirm: "); 2     if (cntrl_info_block.user_pref.delete_confirm)     {          fprintf (f, "YES\n");      }      else     {          fprintf (f, "NO\n");     } &     fprintf (f, "DX.purge_confirm: ");1     if (cntrl_info_block.user_pref.purge_confirm)      {          fprintf (f, "YES\n");      }      else     {          fprintf (f, "NO\n");     } $     fprintf (f, "DX.auto_update: ");/     if (cntrl_info_block.user_pref.auto_update)      {          fprintf (f, "YES\n");      }      else     {          fprintf (f, "NO\n");     } &     fprintf (f, "DX.display_clock: ");1     if (cntrl_info_block.user_pref.display_clock)      {          fprintf (f, "YES\n");      }      else     {          fprintf (f, "NO\n");     } *     fprintf (f, "DX.flash_clock_colon: ");4     if (cntrl_info_block.user_pref.update_in_second)     {          fprintf (f, "ON\n");     }      else     {          fprintf (f, "OFF\n");      }        fclose (f);        /*(     **	Update the filer list and display     **/   )     strcpy(errmsg, "Screen not updated"); =     if (filestat(filename, &temp_entry, errmsg) == DX__ERROR)      {          return DX__ERROR;      }        temp_entry.state = waiting; ,     temp_entry.beg_y = temp_entry.beg_x = 0;4     temp_entry.forward = temp_entry.backward = NULL;       /*     **  Update cache queue. >     **	In case of running out of memory, output error message ,     **	but update current display(s) anyway.     **/   P     if (update_filer_cache(temp_entry, add_to_filer_cache, errmsg) == DX__ERROR)     { !         signal_err(errmsg, bell);      }   !     /**  Add it to the FILER  **/ P     if (add_to_filer(temp_entry, errmsg, cntrl_info_block.cur_win) == DX__ERROR)     {          return DX__ERROR;      }   "     /**  Update other windows  **/4     for (i = 0;  i < cntrl_info_block.windows;  i++)     {**         if (i != cntrl_info_block.cur_win)	         {BA             if (add_to_filer(temp_entry, errmsg, i) == DX__ERROR)g
             {e"                  return DX__ERROR;
             }t	         }8     }o       return DX__NORMAL; }R     D /* **++ **  FUNCTIONAL DESCRIPTION:I ** **	tbs ** **-- **/K int	custom_restore_setting() {      char errmsg[MAXFILESPEC+1];*  8     strcpy(errmsg, "Error restore setting from a file");     get_userinput_and_execute( 	restore_setting,  	"Restore Setting",* 	"Restore from: ",   	DEFAULT_STARTUP,  	errmsg,
 	"dummy"); }a       /* **++ **  FUNCTIONAL DESCRIPTION:o ** **      tbs  ** **-- **/+0 int	restore_setting(filename, init_flag, errmsg) char *filename;t char *init_flag;
 char *errmsg;[ {F     FILE *f;     char line[256];o     int len;
     int i;  ,     if ((f = fopen (filename, "r")) == NULL)     {T8         sprintf (errmsg, "Error opening an input file"); 	return DX__ERROR;     }D  
     i = 0;     while (!feof (f))t     {,         fgets (line, 255, f);  	len = strlen(line);         if (len == 0)"	         {              break;	         }y 	i++;, 	len--;  	line[len] = EOS;   4         if (!strncmp (line, "DX.short_form: ", 15)) 	         {,-             if (!strncmp (line+15, "YES", 3))c# 	    {	    /**  Use short form  **/ 0 		cntrl_info_block.user_pref.use_short_form = 1;<                 if (DX_CURRENT_DIRECTORY.form != short_form)                 {h- 		    DX_CURRENT_DIRECTORY.form = short_form; $ 		    if (strcmp(init_flag, "init")) 		    {  			filer_short_form(); 		    }	                 }D 	    }* 	    else if (!strncmp (line+15, "NO", 2))% 	    {	    /**  Use long form  **/   n0 		cntrl_info_block.user_pref.use_short_form = 0;- 		if (DX_CURRENT_DIRECTORY.form != long_form)= 		{D, 		    DX_CURRENT_DIRECTORY.form = long_form;$ 		    if (strcmp(init_flag, "init")) 		    {  			filer_long_form();p 		    }r 		}_ 	    }	         } 4         else if (!strncmp (line, "DX.editor: ", 11))	         {_-             if (!strncmp (line+11, "EDT", 3)) 
             { B                 cntrl_info_block.user_pref.editor = DX_EDITOR_EDT;
             } 2             else if (!strncmp (line+11, "TPU", 3))
             {SB                 cntrl_info_block.user_pref.editor = DX_EDITOR_TPU;
             }e2             else if (!strncmp (line+11, "LSE", 3))
             {kB                 cntrl_info_block.user_pref.editor = DX_EDITOR_LSE;
             }e	         } :         else if (!strncmp (line, "DX.display_date: ", 17))	         {e- 	    if (!strncmp (line+17, "CREATED", 7) || c% 		!strncmp(line+17, "MODIFIED", 8) || $ 		!strncmp(line+17, "EXPIRED", 7) ||! 		!strncmp(line+17, "BACKUP", 6))e 	    {' 		if (!strncmp (line+17, "CREATED", 7))_ 		{x8 		    DX_CURRENT_DIRECTORY.cur_filter.date = DX_CREDATE; 		},, 		else if (!strncmp(line+17, "MODIFIED", 8)) 		{K8 		    DX_CURRENT_DIRECTORY.cur_filter.date = DX_REVDATE; 		} + 		else if (!strncmp(line+17, "EXPIRED", 7))  		{ 8 		    DX_CURRENT_DIRECTORY.cur_filter.date = DX_EXPDATE; 		}  		else 		{ 8 		    DX_CURRENT_DIRECTORY.cur_filter.date = DX_BAKDATE; 		}l  .                 if (strcmp(init_flag, "init"))-                 {	/**  Update the screen  **/l) 		    check_OK(smg$begin_display_update (e- 				 &DX_CURRENT_DIRECTORY.filer_display.id))"" 		    check_OK(smg$erase_display (- 				 &DX_CURRENT_DIRECTORY.filer_display.id, 1 				 0,  				 0,  				 0,  				 0))8 		    write_to_filer(DX_CURRENT_DIRECTORY.dir_filelist);< 		    write_to_filer(DX_CURRENT_DIRECTORY.non_dir_filelist);  6 		    change_filer_viewport(cntrl_info_block.cur_win);  % 		    highlight_filer_current_file();p  ' 		    check_OK(smg$end_display_update (a- 				 &DX_CURRENT_DIRECTORY.filer_display.id))  		}l 	    }	         } :         else if (!strncmp (line, "DX.type_by_page: ", 17))	         {D-             if (!strncmp (line+17, "YES", 3))L  . 		cntrl_info_block.user_pref.type_by_page = 1;  * 	    else if (!strncmp (line+17, "NO", 2))  . 		cntrl_info_block.user_pref.type_by_page = 0;	         }h<         else if (!strncmp (line, "DX.delete_confirm: ", 19))	         { -             if (!strncmp (line+19, "YES", 3))   0 		cntrl_info_block.user_pref.delete_confirm = 1;  * 	    else if (!strncmp (line+19, "NO", 2))  0 		cntrl_info_block.user_pref.delete_confirm = 0;	         } ;         else if (!strncmp (line, "DX.purge_confirm: ", 18))c	         { -             if (!strncmp (line+18, "YES", 3))   / 		cntrl_info_block.user_pref.purge_confirm = 1;u  * 	    else if (!strncmp (line+18, "NO", 2))  / 		cntrl_info_block.user_pref.purge_confirm = 0;e	         }a9         else if (!strncmp (line, "DX.auto_update: ", 16))t	         {s-             if (!strncmp (line+16, "YES", 3))U  - 		cntrl_info_block.user_pref.auto_update = 1;_  * 	    else if (!strncmp (line+16, "NO", 2))  - 		cntrl_info_block.user_pref.auto_update = 0; 	         }R;         else if (!strncmp (line, "DX.display_clock: ", 18))r	         {a-             if (!strncmp (line+18, "YES", 3))r  / 		cntrl_info_block.user_pref.display_clock = 1;)  + 	    else if (!strncmp (line+18, "NO", 2))   	    {/ 		cntrl_info_block.user_pref.display_clock = 0;$ 	    }	         }m?         else if (!strncmp (line, "DX.flash_clock_colon: ", 22))r	         {	,             if (!strncmp (line+22, "ON", 2)) 	    {2 		cntrl_info_block.user_pref.update_in_second = 1; 	    }+ 	    else if (!strncmp (line+22, "OFF", 3))T 	    {2 		cntrl_info_block.user_pref.update_in_second = 0; 	    }	         }t     }	       fclose (f);        return DX__NORMAL; }*       /* **++ **  FUNCTIONAL DESCRIPTION:	 ** **	tbs ** **-- **/e int	custom_use_default() {O     char errmsg[MAXFILESPEC+1];U  +     strcpy(errmsg, "Error set to default");	  '     return use_default("", "", errmsg);_ }e     R /* **++ **  FUNCTIONAL DESCRIPTION:i ** **      tbsR ** **-- **/n% int	use_default(nouse, dummy, errmsg)_ char *nouse; char *dummy;
 char *errmsg;  {g,     struct user_pref_tag default_settings = 9     {				/**  Default setting and user preferences    **/i, 	0,			/**  Display with long form;		     **/0 	DX_EDITOR_EDT,		/**  EDT for editor;			     **/0 	DX_CREDATE,		/**  use creation date;			     **// 	1,			/**  pause type after each page;	     **/n6 	0,			/**  no delete confirm for individual file;  **/6 	0,			/**  no purge confirm for individual file;   **/6 	0,			/**  no re-read current directory after	     **/. 				/**    edit, execute, and launch;	     **/$ 	1,			/**  display clock.			     **/2 	0			/**  display clock every 60 seconds.	     **/     };  2     cntrl_info_block.user_pref = default_settings;       return DX__NORMAL; }m  