 /* **++
 **  FACILITY:  ** **      FILERFLT.C **
 **  ABSTRACT:  ** **       tbs ** **  AUTHORS: ** **      C. K. Hung  **	Planning Research Corporation **	1150 Gemini Avenue  **	Houston, TX 77058 **	Phone: (713)282-6227  **! **  CREATION DATE:     2-MAY-1991  ** **  MODIFICATION HISTORY:  **-- **/    /* ** **  INCLUDE FILES  ** **/    #include "global.h"  #include "dx.h"  #include "filer.h" #include "findfile.h"  #include "filerflt.h"  #include "filerkpd.h"  #include "filerque.h"  #include "filersrt.h"  #include "inquire.h" #include signal  #include libdef    /* **! **  INTERNAL FUNCTION PROTOTYPING  ** **/        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/  int	filer_filter_name()  {      char errmsg[MAXFILESPEC+1];   4     strcpy(errmsg, "Error filtering files by name");     get_userinput_and_execute( 	filer_filter$1, 	"Filter By Name(s)",  	"File filter: ",  	"", 	errmsg,	 	"Name");  }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/  int	filer_filter_exclude() {      char errmsg[MAXFILESPEC+1];   7     strcpy(errmsg, "Error filtering files by exclude");      get_userinput_and_execute( 	filer_filter$1, 	"Filter By Exclude(s)", 	"Exclude files: ",  	"", 	errmsg, 	"Exclude"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ # int	filter_exclude(n, exclude_list)  char *n;  struct fil_dx_tag *exclude_list; {      struct fil_dx_tag *p;        /*D     **	Find all the files in this directory that in the exclude list     **/   G     for (p = exclude_list->forward; p != exclude_list;  p = p->forward)      {          if (!strcmp (p->fn, n)) 	         {              return 1; 	         }      }   
     return 0;  }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/  int	filer_filter_since() {      static unsigned int timlen;        char errmsg[MAXFILESPEC+1];      char timbuf[50];,     $DESCRIPTOR (timbuf_descriptor, timbuf);       check_OK(sys$asctim (  		&timlen,   		&timbuf_descriptor, * 		&DX_CURRENT_DIRECTORY.cur_filter.since,  		0))      timbuf[timlen] = EOS; 5     strcpy(errmsg, "Error filtering files by since");      get_userinput_and_execute( 	filer_filter$1, 	"Filter By Since",  	"Show files dated after: ", 	timbuf, 	errmsg,
 	"Since"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	filter_since(d, since) DATE_TIME d; DATE_TIME since; {      DATE_TIME cmp;       return (lib$sub_times( 		&d, 
 		&since,  		&cmp) != LIB$_NEGTIM); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/  int	filer_filter_before()  {      static unsigned int timlen;        char errmsg[MAXFILESPEC+1];      char timbuf[50];,     $DESCRIPTOR (timbuf_descriptor, timbuf);       check_OK(sys$asctim (  		&timlen,   		&timbuf_descriptor, + 		&DX_CURRENT_DIRECTORY.cur_filter.before,   		0))      timbuf[timlen] = EOS; 6     strcpy(errmsg, "Error filtering files by before");     get_userinput_and_execute( 	filer_filter$1, 	"Filter By Before", 	"Show files dated before: ",  	timbuf, 	errmsg, 	"Before");  }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	filter_before(d, before) DATE_TIME d; DATE_TIME before;  {      DATE_TIME cmp;       return (lib$sub_times( 		&d,  		&before,   		&cmp) == LIB$_NEGTIM); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/  int	filer_filter_maximum() {      char errmsg[MAXFILESPEC+1];      char numstr[80];  D     sprintf(numstr, "%-d", DX_CURRENT_DIRECTORY.cur_filter.maximum);7     strcpy(errmsg, "Error filtering files by maximum");      get_userinput_and_execute( 	filer_filter$1, 	"Filter By Maximum",  	"Show files smaller than: ",  	numstr, 	errmsg,
 	"Ximum"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	filter_maximum(s, maximum) unsigned int s;  unsigned int maximum;  {      return (s < maximum);  }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/  int	filer_filter_minimum() {      char errmsg[MAXFILESPEC+1];      char numstr[80];  D     sprintf(numstr, "%-d", DX_CURRENT_DIRECTORY.cur_filter.minimum);7     strcpy(errmsg, "Error filtering files by minimum");      get_userinput_and_execute( 	filer_filter$1, 	"Filter By Minimum",  	"Show files larger than: ", 	numstr, 	errmsg, 	"Minimum"); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	filter_minimum(s, minimum) unsigned int s;  unsigned int minimum;  {      return (s >= minimum); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/ * int	filter_OK(e, exclude_list, cur_filter) struct fil_dx_tag e;  struct fil_dx_tag *exclude_list;! struct cur_filter_tag cur_filter;  {      DATE_TIME date_time;       switch (cur_filter.date)     {          case DX_CREDATE:<             memcpy(&date_time, &e.cdat, sizeof (DATE_TIME)); 	    break;          case DX_REVDATE:<             memcpy(&date_time, &e.rdat, sizeof (DATE_TIME)); 	    break;          case DX_EXPDATE:<             memcpy(&date_time, &e.edat, sizeof (DATE_TIME)); 	    break;          case DX_BAKDATE:<             memcpy(&date_time, &e.bdat, sizeof (DATE_TIME)); 	    break;          default:             break;     }   
     return (	 ( 	 !filter_exclude(e.fn, exclude_list) &&. 	 filter_since(date_time, cur_filter.since) &&0 	 filter_before(date_time, cur_filter.before) &&3 	 filter_maximum(e.filesize, cur_filter.maximum) && 2 	 filter_minimum(e.filesize, cur_filter.minimum)); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/ . int	filer_filter$1(criteria, filterby, errmsg) char *criteria;  char *filterby; 
 char *errmsg;  {      char tok[MAXFILESPEC+1];)     char default_filespec[MAXFILESPEC+1];      size_t len; '     struct filespec_list_tag *l = NULL; 
     char *cp; %     char sav_criteria[MAXFILESPEC+1];       char old_cwd[MAXFILESPEC+1], 	 old_par[MAXFILESPEC+1];      int row, 	col;      char dat_tim_string[256]; 8     $DESCRIPTOR(dat_tim_string_descrip, dat_tim_string);     div_t div_p;     int all_dirs;      int pages;     char pages_str[10]; 
     int n;       /*$     **	Save previous directory info      **/   H     if ((n = search_filer_cache(DX_CURRENT_DIRECTORY.cur_filter)) == -1)     {  	/* , 	**  Current directory info not found in the6 	**  directory cache.  Find the LRU slot in the cache. 	**/   	n = find_LRU_in_filer_cache();      }   1     save_to_filer_cache(n, DX_CURRENT_DIRECTORY);        /*3     **	Do filtering according to criteria specified      **/        switch (filterby[0])     {  	case 'N':	/**  Name  **/ 3 	    strcpy(old_cwd, DX_CURRENT_DIRECTORY.cur_dir); 3 	    strcpy(old_par, DX_CURRENT_DIRECTORY.par_dir); $ 	    strcpy(sav_criteria, criteria);  ' 	    strcpy(default_filespec, "*.*;*"); * 	    l = (struct filespec_list_tag *)NULL;   	    cp = criteria;  	    n = 0;  	    while (*cp) 	    {& 		if ((len = strcspn (cp, ", ")) == 0) 		{  		    len = strlen(cp);  		}  		strncpy(tok, cp, len); 		tok[len] = EOS;    		if (insert_filespec_list(  			&l,   			default_filespec, 			tok,  			errmsg) != DX__NORMAL)  		{ 4 		    strcpy(DX_CURRENT_DIRECTORY.cur_dir, old_cwd);4 		    strcpy(DX_CURRENT_DIRECTORY.par_dir, old_par); 		    free_filespec_list(&l);  		    return DX__ERROR;  		}  		if (n++ == 0)  		{  		    /*9 		    **	Assign new value to DX_CURRENT_DIRECTORY.cur_dir ) 		    **	and DX_CURRENT_DIRECTORY.par_dir 	 		    **/   ( 		    set_cwd_and_par(default_filespec); 		}  		cp += len; 		len = strspn (cp, ", "); 		cp += len; 	    }   	    /* 2 	    **	Assign new value to the current directory  	    **	control block. 	    **/   	    convert_date_string ( 		"31-DEC-2857 00:00:00.00",  + 		&DX_CURRENT_DIRECTORY.cur_filter.before);  	    convert_date_string ( 		"17-NOV-1858 00:00:00.00",  * 		&DX_CURRENT_DIRECTORY.cur_filter.since);: 	    DX_CURRENT_DIRECTORY.cur_filter.maximum = 1073741823;1 	    DX_CURRENT_DIRECTORY.cur_filter.minimum = 0; 7 	    if (strcmp(DX_CURRENT_DIRECTORY.cur_dir, old_cwd)) 	 	    {    0 		setddir(DX_CURRENT_DIRECTORY.cur_dir, errmsg);3 		strcpy(DX_CURRENT_DIRECTORY.search_pattern, "*"); + 		DX_CURRENT_DIRECTORY.direction = advance; ) 		DX_CURRENT_DIRECTORY.filemode = single;  	    } 	      	    /* ( 	    **	Free up memory used by the lists 	    **/  M 	    free_filespec_list(&DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list); P 	    free_filespec_list(&DX_CURRENT_DIRECTORY.cur_filter.exclude_filespec_list);< 	    DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list = l; 	    break; #         case 'E':	/**  Exclude  **/ ' 	    strcpy(default_filespec, "*.*;*"); * 	    l = (struct filespec_list_tag *)NULL;   	    cp = criteria;  	    while (*cp) 	    {& 		if ((len = strcspn (cp, ", ")) == 0) 		{  		    len = strlen(cp);  		}  		strncpy(tok, cp, len); 		tok[len] = EOS;    		if (insert_filespec_list(  			&l,   			default_filespec, 			tok,  			errmsg) != DX__NORMAL)  		{  		    free_filespec_list(&l);  		    return DX__ERROR;  		}  		cp += len; 		len = strspn (cp, ", "); 		cp += len; 	    }P 	    free_filespec_list(&DX_CURRENT_DIRECTORY.cur_filter.exclude_filespec_list);? 	    DX_CURRENT_DIRECTORY.cur_filter.exclude_filespec_list = l;  	    break; !         case 'S':	/**  Since  **/ & 	    strcpy(dat_tim_string, criteria);= 	    LENGTH(dat_tim_string_descrip) = strlen(dat_tim_string); $ 	    if (!(lib$convert_date_string ( 			 &dat_tim_string_descrip,  + 			 &DX_CURRENT_DIRECTORY.cur_filter.since,  			 0, 			 0, 			 0, 			 0) & 1)) 	     { - 		strcpy(errmsg, "Invalid date/time format");  		return DX__ERROR;  	     }  	    break; "         case 'B':	/**  Before  **/& 	    strcpy(dat_tim_string, criteria);= 	    LENGTH(dat_tim_string_descrip) = strlen(dat_tim_string); $ 	    if (!(lib$convert_date_string ( 			 &dat_tim_string_descrip,  , 			 &DX_CURRENT_DIRECTORY.cur_filter.before, 			 0, 			 0, 			 0, 			 0) & 1)) 	     { - 		strcpy(errmsg, "Invalid date/time format");  		return DX__ERROR;  	     }  	    break; #         case 'X':	/**  Maximum  **/ E             DX_CURRENT_DIRECTORY.cur_filter.maximum = atoi(criteria);  	    break; #         case 'M':	/**  Minimum  **/ E             DX_CURRENT_DIRECTORY.cur_filter.minimum = atoi(criteria);  	    break;  	case 'U':	/**  Update  **/  	case 'R':	/**  Restore  **/ 	    break;          default:2             strcpy(errmsg, "Invalid filter item"); 	    return DX__ERROR;     }   '     DX_CURRENT_DIRECTORY.dpro = 0Xffff; $     DX_CURRENT_DIRECTORY.subdir = 0;I     DX_CURRENT_DIRECTORY.tot_files = DX_CURRENT_DIRECTORY.tot_blocks = 0; I     DX_CURRENT_DIRECTORY.sel_files = DX_CURRENT_DIRECTORY.sel_blocks = 0;   %     if (!strcmp(filterby, "Restore"))      { A 	restore_from_filer_cache(atoi(criteria), &DX_CURRENT_DIRECTORY); / 	setddir(DX_CURRENT_DIRECTORY.cur_dir, errmsg);      } *     else if (strcmp(filterby, "Update") &&A 	(n = search_filer_cache(DX_CURRENT_DIRECTORY.cur_filter)) != -1)      { 4 	restore_from_filer_cache(n, &DX_CURRENT_DIRECTORY);/ 	setddir(DX_CURRENT_DIRECTORY.cur_dir, errmsg);      }      else     {  	if (!strcmp(filterby, "Name"))  	{, 	    DX_CURRENT_DIRECTORY.sortby = sortname;0 	    DX_CURRENT_DIRECTORY.sortorder = ascending;7 	    DX_CURRENT_DIRECTORY.cur_filter.date = DX_CREDATE;  	} 	find_direct_file(); 	if (find_exclude_file( * 		&DX_CURRENT_DIRECTORY.exclude_filelist, " 		DX_CURRENT_DIRECTORY.cur_filter, 		DX_CURRENT_DIRECTORY.sortby,/ 		DX_CURRENT_DIRECTORY.sortorder) == DX__ERROR)  	{ 	    strcpy(
 		errmsg, 9 		"Insufficient memory to update the exclude file list");  	    return DX__ERROR; 	} 	find_non_direct_file();     }        /*(     **	Compute the position of each file     **/   /     DX_CURRENT_DIRECTORY.dir_filelist->beg_y =  . 	DX_CURRENT_DIRECTORY.dir_filelist->beg_x = 1;     row = col = 1;     compute_filer_begin_xy (J 	DX_CURRENT_DIRECTORY.dir_filelist, &row, &col, cntrl_info_block.cur_win);3     DX_CURRENT_DIRECTORY.non_dir_filelist->beg_y =  5 	DX_CURRENT_DIRECTORY.dir_filelist->backward->beg_y;  3     DX_CURRENT_DIRECTORY.non_dir_filelist->beg_x =  5 	DX_CURRENT_DIRECTORY.dir_filelist->backward->beg_x;       compute_filer_begin_xy (N 	DX_CURRENT_DIRECTORY.non_dir_filelist, &row, &col, cntrl_info_block.cur_win);       /*,     **	Re-disply the screen with batch mode.0     **	Make sure the pasting order is preserved.     **/   -     DX_CURRENT_DIRECTORY.filer_display.rows = = 	max (DX_CURRENT_DIRECTORY.non_dir_filelist->backward->beg_y, 4 	     DX_CURRENT_DIRECTORY.filer_display.view_rows);        check_OK(smg$erase_display (* 		&DX_CURRENT_DIRECTORY.filer_display.id,  		0,   		0,   		0,   		0))   '     check_OK(smg$begin_display_update ( 1 	     	  &DX_CURRENT_DIRECTORY.filer_display.id))   )     check_OK(smg$change_virtual_display ( * 		&DX_CURRENT_DIRECTORY.filer_display.id, , 		&DX_CURRENT_DIRECTORY.filer_display.rows,  		0,   		0,   		0,   		0))   6     DX_CURRENT_DIRECTORY.filer_display.view_beg_y = 1;6     DX_CURRENT_DIRECTORY.filer_display.view_beg_x = 1;  "     check_OK(smg$change_viewport (* 		&DX_CURRENT_DIRECTORY.filer_display.id, 1 		&DX_CURRENT_DIRECTORY.filer_display.view_beg_y, 1 		&DX_CURRENT_DIRECTORY.filer_display.view_beg_x,  		0, 		0))        /*'     **  Write all the files to screen        **/   6     write_to_filer(DX_CURRENT_DIRECTORY.dir_filelist);:     write_to_filer(DX_CURRENT_DIRECTORY.non_dir_filelist);.     put_filer_title(cntrl_info_block.cur_win);-     put_filer_stat(cntrl_info_block.cur_win);        /*$     **	Write directory and page info     **/ L /***************************************************************************"     if (!strcmp(filterby, "Name"))     { F 	div_p = div (DX_CURRENT_DIRECTORY.non_dir_filelist->backward->beg_y, 7 		       DX_CURRENT_DIRECTORY.filer_display.view_rows); 5 	pages = (div_p.rem == 0? div_p.quot : div_p.quot+1);  	all_dirs = F 	    (strcmp (DX_CURRENT_DIRECTORY.dir_filelist->forward->fn, "[-]")? B 	    DX_CURRENT_DIRECTORY.subdir : DX_CURRENT_DIRECTORY.subdir+1);1 	sprintf(pages_str, "Total of %d %s, %d %s read", ; 	    all_dirs, (all_dirs > 1? "directories" : "directory"), + 	    pages, (pages > 1? "pages" : "page"));   	signal_err(pages_str, silence);     } M ****************************************************************************/        /*D     **	Set current file pointer.  Make sure at least one file exists!     **	in the directory file list      **/        DX_CURRENT_FILE = 0 	(DX_CURRENT_DIRECTORY.dir_filelist->forward != ( 	    DX_CURRENT_DIRECTORY.dir_filelist? . 		DX_CURRENT_DIRECTORY.dir_filelist->forward :2 		DX_CURRENT_DIRECTORY.non_dir_filelist->forward);%     if (!strcmp(sav_criteria, "[-]"))      {  	struct fil_dx_tag *s; 	char *cp1;   1         if ((cp = strrchr(old_cwd, '.')) == NULL)  	{ 	    cp = strchr(old_cwd, '[');  	} 	cp++;>         for (s = DX_CURRENT_DIRECTORY.dir_filelist->forward;  : 		s != DX_CURRENT_DIRECTORY.dir_filelist;  s = s->forward)	         { - 	    if ((cp1 = strrchr(s->fn, '.')) != NULL)  	    { 		cp1++; 		if (!strcmp(cp, cp1))  		{  		    DX_CURRENT_FILE = s;6 		    change_filer_viewport(cntrl_info_block.cur_win); 		    break; 		} 
             } 	         }      }   #     highlight_filer_current_file();   %     check_OK(smg$end_display_update ( 1 	     	  &DX_CURRENT_DIRECTORY.filer_display.id))        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	free_filespec_list(l)  struct filespec_list_tag **l;  {      int allocate_size;  /     if (*l != (struct filespec_list_tag *)NULL)      { ! 	free_filespec_list(&(*l)->next);    	free_w_dids(&(*l)->w_dids);3 	allocate_size = sizeof (struct filespec_list_tag);          check_OK(lib$free_vm (%                      &allocate_size,  	 		     l,                       0))' 	*l = (struct filespec_list_tag *)NULL;      }  }        /* **++ **  FUNCTIONAL DESCRIPTION:A ** **      tbs  ** **-- **/  int	free_w_dids(l) struct w_dids_tag **l; {U     int allocate_size;  (     if (*l != (struct w_dids_tag *)NULL)     {e 	free_w_dids(&((*l)->next));  , 	allocate_size = sizeof (struct w_dids_tag);         check_OK(lib$free_vm (%                      &allocate_size, *	 		     l,N                      0))  	*l = (struct w_dids_tag *)NULL;     }i }u