 /* **++
 **  FACILITY:  ** **      FILERFND.C **
 **  ABSTRACT:  ** **       tbs ** **  AUTHORS: ** **      C. K. Hung  **	Planning Research Corporation **	1150 Gemini Avenue  **	Houston, TX 77058 **	Phone: (713)282-6227  **" **  CREATION DATE:     18-MAY-1991 ** **  MODIFICATION HISTORY:  **-- **/    /* ** **  INCLUDE FILES  ** **/    #include "global.h"  #include "dx.h"  #include "filer.h" #include "filerfnd.h"  #include "filertyp.h"  #include "inquire.h" #include libclidef #include signal      /* **
 **  MACROS ** **/    #define MAXLINES 65535     /* **! **  INTERNAL FUNCTION PROTOTYPING  ** **/   ) static int	filer_find_by_page(struct FAB,  				   unsigned long,  				   unsigned long,  				   unsigned short int *, 				   char *, 				   char *); ) static int	filer_find_no_page(struct FAB,  				   unsigned long,  				   unsigned long,  				   unsigned short int *, 				   char *, 				   char *);        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      tbs  ** **-- **/  int	filer_find() { 2     if (DX_CURRENT_DIRECTORY.filemode == multiple) 	filer_multiple_find(); 	     else   	filer_single_find();  }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/  int	filer_multiple_find()  {      char dummy[] = "";     char errmsg[MAXFILESPEC+1];   -     strcpy(errmsg, "Error searching string"); !     multi_get_userinput_and_exec(  	filer_find$1, 	"Multiple Find",  	"Find what? ",  	"",	 	errmsg);  }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/  int	filer_single_find()  {      char dummy[] = "";     char errmsg[MAXFILESPEC+1];      char fn[MAXFILESPEC+1];       ,     if (!strcmp(DX_CURRENT_FILE->fn, "[-]"))     { G         signal_err("Search a parent directory file not allowed", bell);      }      else     { H 	find_full_path_name(DX_CURRENT_FILE->fn, fn, cntrl_info_block.cur_win);* 	strcpy(errmsg, "Error searching string"); 	get_userinput_and_execute(  	    filer_find$1, 	    "Search String",  	    "Find what? ",  	    "", 	    errmsg,	 	    fn);      }  }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/ ' int	filer_find$1(pattern, from, errmsg)  char *pattern; char *from; 
 char *errmsg;  {      return filer_type$2 (  		from, 	 		errmsg,  		pattern,  + 		(cntrl_info_block.user_pref.type_by_page? >                     filer_find_by_page : filer_find_no_page)); }        /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      to be specified  ** **-- **/ ' static int	filer_find_by_page(from_fab,  				   filer_find1_display_id, 				   filer_find2_display_id, 				   word_terminator_code, 				   errmsg, 				   pattern)  struct FAB from_fab;% unsigned long filer_find1_display_id, %               filer_find2_display_id; ) unsigned short int *word_terminator_code; 
 char *errmsg;  char *pattern; {      char linebuf[BUFSIZ+1]; +     $DESCRIPTOR (linebuf_descrip, linebuf);   !     char rendition_set[BUFSIZ+1]; 7     $DESCRIPTOR (rendition_set_descrip, rendition_set);        struct RAB from_rab;  @     int filer_find1_bottom = cntrl_info_block.pasteboard_rows-2;     unsigned long old_mask;      int lastline, linepos;      char errmsg1[MAXFILESPEC+1];+     $DESCRIPTOR (errmsg1_descrip, errmsg1);      unsigned short int len;      unsigned long retcode;     char *base_address;      char *lines[MAXLINES], 	 *attrs[MAXLINES];      int allocate_size;     int count;       int total_found;!     char upcase_string[BUFSIZ+1]; 7     $DESCRIPTOR (upcase_string_descrip, upcase_string);      char *start, *cp;      int eof_flag = 0;      int file_lines; H     int filer_find2_pasteboard_row = cntrl_info_block.pasteboard_rows-1;       /*     **  Trap broadcast messages      **/   )     check_OK(smg$set_broadcast_trapping ( 1                  &cntrl_info_block.pasteboard_id, #                  broadcast_routine,                   0))          /*!     **	Initialize Source File RAB      **/        from_rab = cc$rms_rab;#     from_rab.rab$l_fab = &from_fab; #     from_rab.rab$b_rac = RAB$C_SEQ; !     from_rab.rab$l_ubf = linebuf;       from_rab.rab$w_usz = BUFSIZ;        if ((retcode = sys$connect ( 			&from_rab,  			0,  			0)) != RMS$_NORMAL)       {  	lib$sys_getmsg (  	    &retcode,   	    &len,   	    &errmsg1_descrip,   	    0,  	    0); 	errmsg1[len] = EOS; 	strcpy(errmsg, errmsg1);  	return DX__ERROR;     }        len = strlen(pattern);       /*>     **	Set the signal back to system default so that it won't 3     **	interfere with smg$read_keystroke() routine. A     **	Reset display attributes to avoid SMG$PUT_LINE_MULTI bugs.      **/   
     alarm(0);      signal(SIGALRM, SIG_DFL);   )     check_OK(smg$change_virtual_display ( " 	     	  &filer_find1_display_id,  	     	  0,  	     	  0, 
 	     	  &0,   	     	  0,  	     	  0))  ,     file_lines = total_found = lastline = 0;       /*8     **	Display the first page and wait for user response     **/        retcode = sys$get (  		  &from_rab,   		  0,   		  0);        count = 1;'     while (count <= filer_find1_bottom)      { , 	if (retcode == RMS$_EOF && total_found > 0) 	{ 	    eof_flag++;' 	    LENGTH(rendition_set_descrip) = 0; " 	    check_OK(smg$put_line_multi ( 			&filer_find1_display_id,  			$DESCR (""),  			&rendition_set_descrip,   			0,  			0,  			0,  			0,  			0)) 	    check_OK(lib$get_vm ( 			    &1,   			    &base_address, 
 			    0)) 	    base_address[0] = EOS; $ 	    lines[lastline] = base_address; 	    check_OK(lib$get_vm ( 			    &1,   			    &base_address, 
 			    0))$ 	    base_address[0] = SMG$M_NORMAL;$ 	    attrs[lastline] = base_address; 	    lastline++;  3 	    sprintf(linebuf, "%s - %d line%s, %d match%s", B 		    from_fab.fab$l_fna, file_lines, (file_lines > 1? "s" : ""), 0 		    total_found, (total_found > 1? "s" : ""));/ 	    LENGTH(linebuf_descrip) = strlen(linebuf); : 	    memset(rendition_set, SMG$M_NORMAL, strlen(linebuf));5 	    LENGTH(rendition_set_descrip) = strlen(linebuf); " 	    check_OK(smg$put_line_multi ( 			&filer_find1_display_id,  			&linebuf_descrip,   			&rendition_set_descrip,   			0,  			0,  			0,  			0,  			0))' 	    allocate_size = strlen(linebuf)+1;  	    check_OK(lib$get_vm ( 			    &allocate_size,   			    &base_address, 
 			    0))4 	    memcpy(base_address, linebuf, allocate_size-1);) 	    base_address[allocate_size-1] = EOS; $ 	    lines[lastline] = base_address; 	    check_OK(lib$get_vm ( 			    &allocate_size,   			    &base_address, 
 			    0))9 	    memset(base_address, SMG$M_NORMAL, allocate_size-1); ) 	    base_address[allocate_size-1] = EOS; $ 	    attrs[lastline] = base_address; 	    lastline++; 	    break;  	}! 	else if (retcode != RMS$_NORMAL)  	{ 	    lib$sys_getmsg (  		&retcode,  		&len,  		&errmsg1_descrip,  		0,   		0);  	    errmsg1[len] = EOS; 	    strcpy(errmsg, errmsg1);  	    goto free_vm; 	} 	  	file_lines++;# 	linebuf[from_rab.rab$w_rsz] = EOS; . 	LENGTH(linebuf_descrip) = from_rab.rab$w_rsz;B 	memset(rendition_set, SMG$M_NORMAL, (size_t) from_rab.rab$w_rsz);4 	LENGTH(rendition_set_descrip) = from_rab.rab$w_rsz;         str$upcase ($             &upcase_string_descrip,              &linebuf_descrip);) 	upcase_string[from_rab.rab$w_rsz] = EOS;   I 	for (start = upcase_string;  cp = strstr(start, pattern);  start = cp+1)  	{ 	    total_found++; H 	    memset(rendition_set+(cp-upcase_string), SMG$M_BOLD, (size_t) len); 	} 	if (start != upcase_string) 	{ 	    if (lastline == 0)  	    {& 		check_OK(smg$paste_virtual_display ( 			  &filer_find1_display_id, & 			  &cntrl_info_block.pasteboard_id,  			  &FILER_TYPE1_PBD_ROW,   			  &FILER_TYPE1_PBD_COLUMN,  			  0))  & 		check_OK(smg$paste_virtual_display ( 			  &filer_find2_display_id, & 			  &cntrl_info_block.pasteboard_id, " 			  &filer_find2_pasteboard_row,  			  &FILER_TYPE2_PBD_COLUMN,  			  0)) 	    } 	    smg$put_line_multi (  		&filer_find1_display_id,   		&linebuf_descrip,  		&rendition_set_descrip,  		0,   		0,   		0,   		0,   		0); 0 	    allocate_size = (int) from_rab.rab$w_rsz+1; 	    check_OK(lib$get_vm ( 			    &allocate_size,   			    &base_address, 
 			    0))7 	    memcpy(base_address, linebuf, from_rab.rab$w_rsz); ) 	    base_address[allocate_size-1] = EOS; $ 	    lines[lastline] = base_address; 	    check_OK(lib$get_vm ( 			    &allocate_size,   			    &base_address, 
 			    0))= 	    memcpy(base_address, rendition_set, from_rab.rab$w_rsz); ) 	    base_address[allocate_size-1] = EOS; $ 	    attrs[lastline] = base_address; 	    lastline++;
 	    count++;  	} 	retcode = sys$get ( 		      &from_rab,   		      0,   		      0);      }        /*1     **	Return to caller immediately if none found      **/        if (total_found == 0)      {      	return DX__NORMAL;      }        smg$put_chars (  	&filer_find2_display_id, 	 	$DESCR ( M     "Press ARROW KEYS for prev or next -or-  keypad 0 and CTRL/Y to cancel"),  	&FILER_TYPE2_BOTTOM,  	&1,   	0,  	&SMG$M_REVERSE,   	0,  	0);     smg$read_keystroke (  	&cntrl_info_block.keyboard_id,  	word_terminator_code,   	0,  	0,  	&filer_find2_display_id,  	0,  	0);     check_OK(smg$erase_line (  		  &filer_find2_display_id,   		  &FILER_TYPE2_BOTTOM,   		  &1))     linepos = 1;       /*)     **	Keep typing until exit by the user      **/   6     while (*word_terminator_code != SMG$K_TRM_CTRLY &&/ 	   *word_terminator_code != SMG$K_TRM_CTRLC && - 	   *word_terminator_code != SMG$K_TRM_KP0 && - 	   *word_terminator_code != SMG$K_TRM_CTRLZ)      {  	switch (*word_terminator_code)  	{ 	    case SMG$K_TRM_UP : 		 if (linepos == 1) 		 { 		     check_OK(smg$ring_bell ( & 			          &filer_find1_display_id,  			          0)) 		 } 		 else  		 {) 		     for (count = filer_find1_bottom;   ( 			  count > 1 && linepos > 1;  count--) 		     {
 			linepos--; % 			strcpy(linebuf, lines[linepos-1]); - 			LENGTH(linebuf_descrip) = strlen(linebuf); < 			memcpy(rendition_set, attrs[linepos-1], strlen(linebuf));3 			LENGTH(rendition_set_descrip) = strlen(linebuf);  			smg$scroll_display_area (  			    &filer_find1_display_id, 
 			    0, 
 			    0, 
 			    0, 
 			    0,  			    &SMG$M_DOWN, 
 			    0); 			smg$put_chars_multi (  			    &filer_find1_display_id,  			    &linebuf_descrip,   			    &1,   			    &1,   			    &SMG$M_ERASE_TO_EOL,  			    &rendition_set_descrip,  
 			    0, 
 			    0); 		     } 		 }	 		 break;  	    case SMG$K_TRM_DOWN:  	    case SMG$K_TRM_CR :	     1 		if (linepos+filer_find1_bottom-1 >= lastline &&  		     retcode == RMS$_EOF)  		{  		    check_OK(smg$ring_bell (! 				    &filer_find1_display_id,   				    0))  		}  		else 		{ ! 		    count = filer_find1_bottom;  		    while (count > 1)  		    { / 			if (linepos+filer_find1_bottom-1 < lastline)  			{ 			    linepos++;  			    strcpy(
 				linebuf,  ) 				lines[linepos+filer_find1_bottom-2]); 1 			    LENGTH(linebuf_descrip) = strlen(linebuf);  			    memcpy( 				rendition_set,( 				attrs[linepos+filer_find1_bottom-2], 				strlen(linebuf)); 7 			    LENGTH(rendition_set_descrip) = strlen(linebuf);   			    smg$scroll_display_area ( 				&filer_find1_display_id,   				0,   				0,   				0,   				0,   				&SMG$M_UP,   				0);  			    smg$put_chars_multi ( 				&filer_find1_display_id,   				&linebuf_descrip,  				&filer_find1_bottom,   				&1,  				&SMG$M_ERASE_TO_EOL,   				&rendition_set_descrip,  				0,   				0);  			    count--;  			}  			else if (retcode == RMS$_EOF) 			{ 			    if (!eof_flag)  			    { 				eof_flag++; & 				LENGTH(rendition_set_descrip) = 0; 				smg$scroll_display_area ( ! 				    &filer_find1_display_id,   				    0,   				    0,   				    0,   				    0,   				    &SMG$M_UP,   				    0);  				smg$put_chars_multi ( ! 				    &filer_find1_display_id,   				    $DESCR (""),   				    &filer_find1_bottom,   				    &1,  				    &SMG$M_ERASE_TO_EOL,    				    &rendition_set_descrip,  				    0,   				    0);  				check_OK(lib$get_vm ( 
 						&1,  						&base_address,  	 						0))  				base_address[0] = EOS;# 				lines[lastline] = base_address;  				check_OK(lib$get_vm ( 
 						&1,  						&base_address,  	 						0)) # 				base_address[0] = SMG$M_NORMAL; # 				attrs[lastline] = base_address;  				linepos++; 				lastline++;   2 				sprintf(linebuf, "%s - %d line%s, %d match%s",A 					from_fab.fab$l_fna, file_lines, (file_lines > 1? "s" : ""),  / 					total_found, (total_found > 1? "s" : "")); . 				LENGTH(linebuf_descrip) = strlen(linebuf);9 				memset(rendition_set, SMG$M_NORMAL, strlen(linebuf)); 4 				LENGTH(rendition_set_descrip) = strlen(linebuf); 				smg$scroll_display_area ( ! 				    &filer_find1_display_id,   				    0,   				    0,   				    0,   				    0,   				    &SMG$M_UP,   				    0);  				smg$put_chars_multi ( ! 				    &filer_find1_display_id,   				    &linebuf_descrip,  				    &filer_find1_bottom,   				    &1,  				    &SMG$M_ERASE_TO_EOL,    				    &rendition_set_descrip,  				    0,   				    0); & 				allocate_size = strlen(linebuf)+1; 				check_OK(lib$get_vm (  						&allocate_size,  						&base_address,  	 						0)) 3 				memcpy(base_address, linebuf, allocate_size-1); ( 				base_address[allocate_size-1] = EOS;# 				lines[lastline] = base_address;  				check_OK(lib$get_vm (  						&allocate_size,  						&base_address,  	 						0)) 8 				memset(base_address, SMG$M_NORMAL, allocate_size-1);( 				base_address[allocate_size-1] = EOS;# 				attrs[lastline] = base_address;  				linepos++; 				lastline++;  			    }
 			    break;  			}# 			else if (retcode != RMS$_NORMAL)  			{ 			     lib$sys_getmsg ( 				   &retcode,   				   &len, 				   &errmsg1_descrip,  
 				   0, 
 				   0); 			     errmsg1[len] = EOS;   			     strcpy(errmsg, errmsg1); 			     goto free_vm;  			} 			else  			{ 			    file_lines++;) 			    linebuf[from_rab.rab$w_rsz] = EOS; 4 			    LENGTH(linebuf_descrip) = from_rab.rab$w_rsz;H 			    memset(rendition_set, SMG$M_NORMAL, (size_t) from_rab.rab$w_rsz);: 			    LENGTH(rendition_set_descrip) = from_rab.rab$w_rsz; 			    str$upcase (  				&upcase_string_descrip,  				&linebuf_descrip);/ 			    upcase_string[from_rab.rab$w_rsz] = EOS;   O 			    for (start = upcase_string;  cp = strstr(start, pattern);  start = cp+1)  			    { 				total_found++;G 				memset(rendition_set+(cp-upcase_string), SMG$M_BOLD, (size_t) len);  			    }" 			    if (start != upcase_string) 			    { 				smg$scroll_display_area ( ! 				    &filer_find1_display_id,   				    0,   				    0,   				    0,   				    0,   				    &SMG$M_UP,   				    0);  				smg$put_chars_multi ( ! 				    &filer_find1_display_id,   				    &linebuf_descrip,  				    &filer_find1_bottom,   				    &1,  				    &SMG$M_ERASE_TO_EOL,    				    &rendition_set_descrip,  				    0,   				    0); / 				allocate_size = (int) from_rab.rab$w_rsz+1;  				check_OK(lib$get_vm (  						&allocate_size,  						&base_address,  	 						0)) 6 				memcpy(base_address, linebuf, from_rab.rab$w_rsz);( 				base_address[allocate_size-1] = EOS;# 				lines[lastline] = base_address;  				check_OK(lib$get_vm (  						&allocate_size,  						&base_address,  	 						0)) < 				memcpy(base_address, rendition_set, from_rab.rab$w_rsz);( 				base_address[allocate_size-1] = EOS;# 				attrs[lastline] = base_address;  				count--; 				lastline++;  				linepos++; 			    }   			    retcode = sys$get ( 					  &from_rab, 
 					  0, 
 					  0); 			} 		    }  		}  		break; 	    case SMG$K_TRM_CTRLW: 		check_OK(smg$repaint_screen ( ( 			    &cntrl_info_block.pasteboard_id)) 		break;
 	    default: 3 		if (*word_terminator_code != SMG$K_TRM_CANCELLED) 6 		{	/**  Returned from broadcast message trapping  **/ 		    check_OK(smg$ring_bell ( 				  &filer_find1_display_id,  	 				  0))  		}  		break;     }      check_OK(smg$put_chars ( 		   &filer_find2_display_id, 
 		   $DESCR ( M     "Press ARROW KEYS for prev or next -or- keypad 0 and CTRL/Y to cancel"),   		   &FILER_TYPE2_BOTTOM, 	 		   &1,   		   0,  		   &SMG$M_REVERSE,   		   0,  		   0))     smg$read_keystroke (! 	 &cntrl_info_block.keyboard_id,   	 word_terminator_code,  	 0, B 	 0,   	 &filer_find2_display_id, U 	 0,   	 0);      check_OK(smg$erase_line (e 		   &filer_find2_display_id,  		   &FILER_TYPE2_BOTTOM, 	 		   &1))e     }2   free_vm:0     for (count = 0;  count < lastline;  count++)     {N( 	allocate_size = strlen(lines[count])+1;     	check_OK(lib$free_vm (u 		     &allocate_size, " 		     &lines[count], 
 		     0))     	check_OK(lib$free_vm (e 		     &allocate_size, r 		     &attrs[count], 
 		     0))     }   ;     return (retcode == RMS$_NORMAL || retcode == RMS$_EOF?   		DX__NORMAL : DX__ERROR); }R     N /* **++ **  FUNCTIONAL DESCRIPTION:y ** **      to be specifieds ** **-- **/	' static int	filer_find_no_page(from_fab,r 				   filer_find1_display_id, 				   filer_find2_display_id, 				   word_terminator_code, 				   errmsg, 				   pattern)  struct FAB from_fab;% unsigned long filer_find1_display_id,c%               filer_find2_display_id;N) unsigned short int *word_terminator_code;-
 char *errmsg;e char *pattern; {f     char linebuf[BUFSIZ+1];d+     $DESCRIPTOR (linebuf_descrip, linebuf);   !     char rendition_set[BUFSIZ+1]; 7     $DESCRIPTOR (rendition_set_descrip, rendition_set);        struct RAB from_rab;        char errmsg1[MAXFILESPEC+1];+     $DESCRIPTOR (errmsg1_descrip, errmsg1);F     unsigned short int len;r     unsigned long retcode;       int total_found;     int lines;!     char upcase_string[BUFSIZ+1]; 7     $DESCRIPTOR (upcase_string_descrip, upcase_string);+     char *start, *cp;PH     int filer_find2_pasteboard_row = cntrl_info_block.pasteboard_rows-1;          /*!     **	Initialize Source File RAB[     **/E       from_rab = cc$rms_rab;#     from_rab.rab$l_fab = &from_fab;E#     from_rab.rab$b_rac = RAB$C_SEQ; !     from_rab.rab$l_ubf = linebuf;r      from_rab.rab$w_usz = BUFSIZ;        if ((retcode = sys$connect ( 			&from_rab,  			0,  			0)) != RMS$_NORMAL) c     {; 	lib$sys_getmsg (E 	    &retcode, r 	    &len, u 	    &errmsg1_descrip,   	    0,  	    0); 	errmsg1[len] = EOS; 	strcpy(errmsg, errmsg1);" 	return DX__ERROR;     }        len = strlen(pattern);       /*>     **	Set the signal back to system default so that it won't 3     **	interfere with smg$read_keystroke() routine.aA     **	Reset display attributes to avoid SMG$PUT_LINE_MULTI bugs.      **/   
     alarm(0);a     signal(SIGALRM, SIG_DFL);s  )     check_OK(smg$change_virtual_display (i" 	     	  &filer_find1_display_id,  	     	  0,  	     	  0, 
 	     	  &0, D 	     	  0,  	     	  0))  (     check_OK(smg$paste_virtual_display (  	      &filer_find1_display_id, ( 	      &cntrl_info_block.pasteboard_id,  	      &FILER_TYPE1_PBD_ROW, e  	      &FILER_TYPE1_PBD_COLUMN, 
 	      0))  (     check_OK(smg$paste_virtual_display (  	      &filer_find2_display_id, ( 	      &cntrl_info_block.pasteboard_id, $ 	      &filer_find2_pasteboard_row,   	      &FILER_TYPE2_PBD_COLUMN, 
 	      0))       total_found = lines = 0;     while ((retcode = sys$get( 			&from_rab,  			0,  			0)) != RMS$_EOF)      {i 	if (retcode != RMS$_NORMAL) ) 	{ 	    lib$sys_getmsg (a 		&retcode,  		&len,  		&errmsg1_descrip,  		0, a 		0);d 	    errmsg1[len] = EOS; 	    strcpy(errmsg, errmsg1);  	    return DX__ERROR; 	}  	 	lines++;;# 	linebuf[from_rab.rab$w_rsz] = EOS;r. 	LENGTH(linebuf_descrip) = from_rab.rab$w_rsz;B 	memset(rendition_set, SMG$M_NORMAL, (size_t) from_rab.rab$w_rsz);) 	rendition_set[from_rab.rab$w_rsz] = EOS;e4 	LENGTH(rendition_set_descrip) = from_rab.rab$w_rsz;         str$upcase ($             &upcase_string_descrip,              &linebuf_descrip);) 	upcase_string[from_rab.rab$w_rsz] = EOS;   I 	for (start = upcase_string;  cp = strstr(start, pattern);  start = cp+1)a 	{ 	    total_found++;*H 	    memset(rendition_set+(cp-upcase_string), SMG$M_BOLD, (size_t) len); 	} 	if (start != upcase_string) 	{ 	    smg$put_line_multi (d 		&filer_find1_display_id, t 		&linebuf_descrip,  		&rendition_set_descrip,  		0, i 		0,   		0, F 		0,   		0);* 	}     }r       /*1     **	Return to caller immediately if none found      **/b       if (total_found == 0)      {b     	return DX__NORMAL;      }r       smg$put_line ( 	&filer_find1_display_id,  	$DESCR (""),  	0,  	0,  	0,  	0,  	0,  	0);  2     sprintf(linebuf, "%s - %d line%s, %d match%s",7 	    from_fab.fab$l_fna, lines, (lines > 1? "s" : ""), ;/ 	    total_found, (total_found > 1? "s" : "")); '     POINTER(linebuf_descrip) = linebuf; .     LENGTH(linebuf_descrip) = strlen(linebuf);     smg$put_line ( 	&filer_find1_display_id,  	&linebuf_descrip, $ 	0,  	0,  	0,  	0,  	0,  	0);       smg$put_chars (  	&filer_find2_display_id, H 	$DESCR ("Press RETURN to continue -or- keypad 0 and CTRL/Y to cancel"), 	&FILER_TYPE2_BOTTOM,  	&1, p 	0,  	&SMG$M_REVERSE, i 	0,  	0);     smg$read_keystroke (  	&cntrl_info_block.keyboard_id,  	word_terminator_code, i 	0,  	0,  	&filer_find2_display_id,  	0,  	0);     smg$erase_line ( 	&filer_find2_display_id,  	&FILER_TYPE2_BOTTOM,  	&1);        return DX__NORMAL; } 