 /* **++
 **  FACILITY:  ** **      FINDFILE.C **
 **  ABSTRACT:  **A **      FINDFILE uses ACP (SYS$QIOW) services to search all files $ **	starting from the root directory. ** **  AUTHORS: ** **      C. K. Hung  **	Planning Research Corporation **	1150 Gemini Avenue  **	Houston, TX 77058 **	Phone: (713)282-6227  ** ** **  CREATION DATE:     7-12-89 ** **  MODIFICATION HISTORY: # **	(17APR91)CKH	: Upgrade for DX II  **-- **/    /* ** **  INCLUDE FILES  ** **/    #include "global.h"  #include "findfile.h"  #include "filerdel.h"  #include "filerflt.h"  #include "filerque.h"  #include "filersrt.h"  #include "inquire.h" #include atrdef  #include fchdef  #include fibdef  #include iodef #include sbkdef  #include strdef        /* **++ **  FUNCTIONAL DESCRIPTION:  **L **      FIND_DIRECT_FILE() searchs all the directory files in the directory.* **	Parent directory file is also included. ** **-- **/  int	find_direct_file() {      /*&     **  VARIABLES USED BY ACP SERVICES     **/        unsigned int iosb[2];      static struct fibdef fib;	)     struct dsc$descriptor_s fib_descrip = H 	{ sizeof (struct fibdef), DSC$K_DTYPE_T, DSC$K_CLASS_S, (char *)&fib };     unsigned short len; !     char filespec[MAXFILESPEC+1]; -     $DESCRIPTOR (filespec_descrip, filespec); A     unsigned long fch;			    /**  File characteristics blocks **/ ;     struct sbkdef asb;			    /**  Statistics Block	     **/ <     DATE_TIME cdat,			    /**  64-bit Creation Date	     **/5 	      rdat,			    /**  64-bit Revision Date	     **/ 7 	      edat,			    /**  64-bit Expiration Date	     **/ 3 	      bdat;			    /**  64-bit Backup Date	     **/ ?     unsigned short int fpro;		    /**  File Protection	     **/      struct  , 	{				    /**  Access Control Block	     **/ 	    unsigned short w_size;  	    unsigned short w_type;  	    char *l_addr; 	} acb[] = {0 	    { ATR$S_UCHAR, ATR$C_UCHAR, (char *)&fch },4 	    { ATR$S_STATBLK, ATR$C_STATBLK, (char *)&asb },5 	    { ATR$S_CREDATE, ATR$C_CREDATE, (char *)&cdat }, 5 	    { ATR$S_REVDATE, ATR$C_REVDATE, (char *)&rdat }, 5 	    { ATR$S_EXPDATE, ATR$C_EXPDATE, (char *)&edat }, 5 	    { ATR$S_BAKDATE, ATR$C_BAKDATE, (char *)&bdat }, / 	    { ATR$S_FPRO, ATR$C_FPRO, (char *)&fpro },  	    { 0, 0, (char *)NULL }  	};        /*     **	    NON-ACP VARABLES      **/        register int i;      int total_dids; !     char equ_name[MAXFILESPEC+1];      int total_devices;!     char dev_name[MAXFILESPEC+1]; !     struct fil_dx_tag temp_entry; !     struct fil_dx_tag *new_entry;      int allocate_size;     char str[128];#     $DESCRIPTOR (str_descrip, str);       struct filespec_list_tag *p;     struct w_dids_tag *q;        /*     **	Create a new list head.*     **	Free up memory for old list first.      **/   6     free_filelist(&DX_CURRENT_DIRECTORY.dir_filelist);-     if ((DX_CURRENT_DIRECTORY.dir_filelist =  4 	    create_MARKER()) == (struct fil_dx_tag *)NULL)      { C 	signal_err("Error creating MARKER for directory file list", bell);  	return  DX__ERROR;      }        /*$     **	Insert parent directory entry     **/   /     if (DX_CURRENT_DIRECTORY.par_dir[0] != EOS)      {  	strcpy (temp_entry.fn, "[-]");  	temp_entry.state = waiting; 	insert_filelist_entry( ( 	    DX_CURRENT_DIRECTORY.dir_filelist,  	    temp_entry,! 	    DX_CURRENT_DIRECTORY.sortby, % 	    DX_CURRENT_DIRECTORY.sortorder);      }        /*C     **	Find out the number of equivalent names of current directory      **/        total_dids = 0;      equ_name[0] = EOS;     total_devices = 0;     dev_name[0] = EOS;R     for (p = DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list;  p;  p = p->next)     { -         for (q = p->w_dids;  q;  q = q->next) 	         {  	    size_t len;  6             if (strcmp (q->equivalent_name, equ_name))
             {                  total_dids++; 6                 strcpy (equ_name, q->equivalent_name);
             } - 	    len = strcspn (q->equivalent_name, "["); <             if (strncmp (q->equivalent_name, dev_name, len))
             {                   total_devices++;<                 strncpy (dev_name, q->equivalent_name, len);
             } 	         }      }        /*5     **	Find all the directory files in this directory      **/        strcpy(str, "*.DIR;1"); &     LENGTH(str_descrip) = strlen(str);  R     for (p = DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list;  p;  p = p->next)     { -         for (q = p->w_dids;  q;  q = q->next) 	         {  	    for (i = 0; i <= 2; i++) 1 		fib.fib$r_did_overlay.fib$w_did[i] = q->did[i];    	    filespec[0] = EOS;    	    for (i = 0;  i <= 2;  i++)  	    {  		temp_entry.did[i] = q->did[i]; 	    }   	    /* ; 	    **  Initialize FIB to indicate to ACP that a directory & 	    **  look-up operation is desired. 	    **/  6 	    fib.fib$r_nmctl_overlay.fib$w_nmctl = FIB$M_WILD; 	    fib.fib$l_wcc = 0;    	    check_OK(sys$qiow (   			0,  			q->chan,  			IO$_ACCESS,  	 			iosb,   			0,  			0,  			&fib_descrip,   			&str_descrip,  	 			&len,   			&filespec_descrip,  			acb,  			0 ))   % 	    while (iosb[0] == SS$_NORMAL ||  > 		   ((iosb[0] == SS$_NOPRIV || iosb[0] == SS$_NOSUCHFILE) &&  		     filespec[0])) 	    { 		size_t len1;   		if (total_dids <= 1) 		{ # 		    strcpy (temp_entry.fn, "[."); % 		    len1 = strcspn (filespec, "."); . 		    strncat (temp_entry.fn, filespec, len1);" 		    strcat (temp_entry.fn, "]"); 		}  		else 		{ +                     if (total_devices <= 1)                      { Q                         strcpy (temp_entry.fn, strchr (q->equivalent_name, '['));                      }                      else                     { . 			strcpy (temp_entry.fn, q->equivalent_name);                     } 3 		    temp_entry.fn[strlen(temp_entry.fn)-1] = '.'; % 		    len1 = strcspn (filespec, "."); . 		    strncat (temp_entry.fn, filespec, len1);" 		    strcat (temp_entry.fn, "]"); 		}     		DX_CURRENT_DIRECTORY.subdir++;   		if (iosb[0] == SS$_NOPRIV)   		{  		    temp_entry.filesize = 0;@ 		    temp_entry.fpro = 0Xffff;	/**  Insufficient privilege  **/ 		    convert_date_string (  			"17-NOV-1858 00:00:00.00",  			&temp_entry.cdat); E 		    memcpy(&temp_entry.rdat, &temp_entry.cdat, sizeof (DATE_TIME)); E 		    memcpy(&temp_entry.edat, &temp_entry.cdat, sizeof (DATE_TIME)); E 		    memcpy(&temp_entry.bdat, &temp_entry.cdat, sizeof (DATE_TIME));  		} & 		else if (iosb[0] == SS$_NOSUCHFILE)  		{  		    temp_entry.filesize = 0;: 		    temp_entry.fpro = 0Xfffe;	/**  No such file	     **/ 		    convert_date_string (  			"17-NOV-1858 00:00:00.00",  			&temp_entry.cdat); E 		    memcpy(&temp_entry.rdat, &temp_entry.cdat, sizeof (DATE_TIME)); E 		    memcpy(&temp_entry.edat, &temp_entry.cdat, sizeof (DATE_TIME)); E 		    memcpy(&temp_entry.bdat, &temp_entry.cdat, sizeof (DATE_TIME));  		}  		else   		{   		    for (i = 0;  i <= 2;  i++) 		    { : 			temp_entry.fid[i] = fib.fib$r_fid_overlay.fib$w_fid[i]; 		    }  		    temp_entry.filesize = 1 			(asb.sbk$w_filesizh << 16)+asb.sbk$w_filesizl; : 		    memcpy(&temp_entry.cdat, &cdat, sizeof (DATE_TIME));: 		    memcpy(&temp_entry.rdat, &rdat, sizeof (DATE_TIME));: 		    memcpy(&temp_entry.edat, &edat, sizeof (DATE_TIME));: 		    memcpy(&temp_entry.bdat, &bdat, sizeof (DATE_TIME)); 		    temp_entry.fpro = fpro;  		}    		temp_entry.state = waiting;    		if (insert_filelist_entry(% 			DX_CURRENT_DIRECTORY.dir_filelist,  			temp_entry, 			DX_CURRENT_DIRECTORY.sortby, 1 			DX_CURRENT_DIRECTORY.sortorder) == DX__NORMAL)  		{ ' 		    DX_CURRENT_DIRECTORY.tot_files++; = 		    DX_CURRENT_DIRECTORY.tot_blocks += temp_entry.filesize;  		}    		check_OK(sys$qiow ( 
 			    0,  			    q->chan,  			    IO$_ACCESS,  
 			    iosb,  
 			    0, 
 			    0,  			    &fib_descrip,   			    &str_descrip,  
 			    &len,   			    &filespec_descrip,  			    acb,  			    0 ))  	    }	         }      }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  **K **      FIND_NON_DIRECT_FILE() searchs all the files except directory files ? **	in the directory that meet user specified file specification  ** **-- **/  int	find_non_direct_file() {      /*&     **  VARIABLES USED BY ACP SERVICES     **/        unsigned int iosb[2];      static struct fibdef fib; )     struct dsc$descriptor_s fib_descrip = H 	{ sizeof (struct fibdef), DSC$K_DTYPE_T, DSC$K_CLASS_S, (char *)&fib };     unsigned short len; !     char filespec[MAXFILESPEC+1]; -     $DESCRIPTOR (filespec_descrip, filespec); A     unsigned long fch;			    /**  File characteristics blocks **/ ;     struct sbkdef asb;			    /**  Statistics Block	     **/ <     DATE_TIME cdat,			    /**  64-bit Creation Date	     **/5 	      rdat,			    /**  64-bit Revision Date	     **/ 7 	      edat,			    /**  64-bit Expiration Date	     **/ 3 	      bdat;			    /**  64-bit Backup Date	     **/ ?     unsigned short int fpro;		    /**  File Protection	     **/      struct  , 	{				    /**  Access Control Block	     **/ 	    unsigned short w_size;  	    unsigned short w_type;  	    char *l_addr; 	} acb[] = {0 	    { ATR$S_UCHAR, ATR$C_UCHAR, (char *)&fch },4 	    { ATR$S_STATBLK, ATR$C_STATBLK, (char *)&asb },5 	    { ATR$S_CREDATE, ATR$C_CREDATE, (char *)&cdat }, 5 	    { ATR$S_REVDATE, ATR$C_REVDATE, (char *)&rdat }, 5 	    { ATR$S_EXPDATE, ATR$C_EXPDATE, (char *)&edat }, 5 	    { ATR$S_BAKDATE, ATR$C_BAKDATE, (char *)&bdat }, / 	    { ATR$S_FPRO, ATR$C_FPRO, (char *)&fpro },  	    { 0, 0, (char *)NULL }  	};        /*     **	    NON-ACP VARABLES      **/        register int i;      int total_dids; !     char equ_name[MAXFILESPEC+1];      int total_devices;!     char dev_name[MAXFILESPEC+1]; !     struct fil_dx_tag temp_entry; !     struct fil_dx_tag *new_entry;      int allocate_size;     char str[128];#     $DESCRIPTOR (str_descrip, str);       struct filespec_list_tag *p;     struct w_dids_tag *q;        /*     **	Create a new list head.+     **	Free up memory for old list first.        **/   :     free_filelist(&DX_CURRENT_DIRECTORY.non_dir_filelist);1     if ((DX_CURRENT_DIRECTORY.non_dir_filelist =  4 	    create_MARKER()) == (struct fil_dx_tag *)NULL)      { G 	signal_err("Error creating MARKER for non-directory file list", bell);  	return  DX__ERROR;      }        total_dids = 0;      equ_name[0] = EOS;     total_devices = 0;     dev_name[0] = EOS;R     for (p = DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list;  p;  p = p->next)     { -         for (q = p->w_dids;  q;  q = q->next) 	         {  	    size_t len;  6             if (strcmp (q->equivalent_name, equ_name))
             {                  total_dids++; 6                 strcpy (equ_name, q->equivalent_name);
             } - 	    len = strcspn (q->equivalent_name, "["); <             if (strncmp (q->equivalent_name, dev_name, len))
             {                   total_devices++;<                 strncpy (dev_name, q->equivalent_name, len);
             } 	         }      }   R     for (p = DX_CURRENT_DIRECTORY.cur_filter.name_filespec_list;  p;  p = p->next)     {  	/* ? 	**	Find all the files in this directory that meet the criteria  	**/   	strcpy(str, p->name);# 	LENGTH(str_descrip) = strlen(str);   -         for (q = p->w_dids;  q;  q = q->next) 	         {  	    for (i = 0; i <= 2; i++) 1 		fib.fib$r_did_overlay.fib$w_did[i] = q->did[i];    	    filespec[0] = EOS;    	    for (i = 0;  i <= 2;  i++)  	    {  		temp_entry.did[i] = q->did[i]; 	    }   	    /* ; 	    **  Initialize FIB to indicate to ACP that a directory & 	    **  look-up operation is desired. 	    **/  6 	    fib.fib$r_nmctl_overlay.fib$w_nmctl = FIB$M_WILD; 	    fib.fib$l_wcc = 0;    	    check_OK(sys$qiow (   			0,  			q->chan,  			IO$_ACCESS,  	 			iosb,   			0,  			0,  			&fib_descrip,   			&str_descrip,  	 			&len,   			&filespec_descrip,  			acb,  			0 ))   % 	    while (iosb[0] == SS$_NORMAL ||  > 		   ((iosb[0] == SS$_NOPRIV || iosb[0] == SS$_NOSUCHFILE) &&  		     filespec[0])) 	    {# 		if (!strstr (filespec, ".DIR;1"))  		{  		    if (total_dids <= 1) 		    { # 			strcpy(temp_entry.fn, filespec);  		    } " 		    else if (total_devices <= 1) 		    { # 			sprintf (temp_entry.fn, "%s%s",  3 			    strchr (q->equivalent_name, '['), filespec);  		    } 
 		    else 		    { # 			sprintf (temp_entry.fn, "%s%s",  % 			    q->equivalent_name, filespec);  		    }   ! 		    if (iosb[0] == SS$_NOPRIV)   		    {  			temp_entry.filesize = 0; = 			temp_entry.fpro = 0Xffff;	/**  Insufficient privilege  **/  			convert_date_string (# 			     "17-NOV-1858 00:00:00.00",   			     &temp_entry.cdat);B 			memcpy(&temp_entry.rdat, &temp_entry.cdat, sizeof (DATE_TIME));B 			memcpy(&temp_entry.edat, &temp_entry.cdat, sizeof (DATE_TIME));B 			memcpy(&temp_entry.bdat, &temp_entry.cdat, sizeof (DATE_TIME)); 		    } * 		    else if (iosb[0] == SS$_NOSUCHFILE)  		    {  			temp_entry.filesize = 0; 7 			temp_entry.fpro = 0Xfffe;	/**  No such file	     **/  			convert_date_string (# 			     "17-NOV-1858 00:00:00.00",   			     &temp_entry.cdat);B 			memcpy(&temp_entry.rdat, &temp_entry.cdat, sizeof (DATE_TIME));B 			memcpy(&temp_entry.edat, &temp_entry.cdat, sizeof (DATE_TIME));B 			memcpy(&temp_entry.bdat, &temp_entry.cdat, sizeof (DATE_TIME)); 		    }  		    else   		    {  			for (i = 0;  i <= 2;  i++)  			{> 			    temp_entry.fid[i] = fib.fib$r_fid_overlay.fib$w_fid[i]; 			} 			temp_entry.filesize =  5 			    (asb.sbk$w_filesizh << 16)+asb.sbk$w_filesizl; 7 			memcpy(&temp_entry.cdat, &cdat, sizeof (DATE_TIME)); 7 			memcpy(&temp_entry.rdat, &rdat, sizeof (DATE_TIME)); 7 			memcpy(&temp_entry.edat, &edat, sizeof (DATE_TIME)); 7 			memcpy(&temp_entry.bdat, &bdat, sizeof (DATE_TIME));  			temp_entry.fpro = fpro; 		    }   ! 		    temp_entry.state = waiting;   .                     if (iosb[0] != SS$_NORMAL)                     { ,                         if (!filter_exclude(: 				temp_entry.fn, DX_CURRENT_DIRECTORY.exclude_filelist))                         { ! 			    if (insert_filelist_entry( . 				    DX_CURRENT_DIRECTORY.non_dir_filelist, 				    temp_entry, $ 				    DX_CURRENT_DIRECTORY.sortby,( 				    DX_CURRENT_DIRECTORY.sortorder)  					== DX__NORMAL)  			    {% 				DX_CURRENT_DIRECTORY.tot_files++; ; 				DX_CURRENT_DIRECTORY.tot_blocks += temp_entry.filesize;  			    }                         }                      } '                     else if (filter_OK(  				temp_entry, + 				DX_CURRENT_DIRECTORY.exclude_filelist,  % 				DX_CURRENT_DIRECTORY.cur_filter))  		    {  			if (insert_filelist_entry( * 				DX_CURRENT_DIRECTORY.non_dir_filelist, 				temp_entry,   				DX_CURRENT_DIRECTORY.sortby,$ 				DX_CURRENT_DIRECTORY.sortorder)  				    == DX__NORMAL)   			{( 			    DX_CURRENT_DIRECTORY.tot_files++;> 			    DX_CURRENT_DIRECTORY.tot_blocks += temp_entry.filesize; 			} 		    }  		}    		check_OK(sys$qiow ( 
 			    0,  			    q->chan,  			    IO$_ACCESS,  
 			    iosb,  
 			    0, 
 			    0,  			    &fib_descrip,   			    &str_descrip,  
 			    &len,   			    &filespec_descrip,  			    acb,  			    0 ))  	    } 	}     }        return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:  **H **      FIND_EXCLUDE_FILE() searchs all the files except directory files1 **	in the directory that meet "EXCLUDE" qualifier  ** **-- **/ C int	find_exclude_file(exclude_listp, cur_filter, sortby, sortorder) " struct fil_dx_tag **exclude_listp;! struct cur_filter_tag cur_filter;  enum sortbys sortby; enum sortorders sortorder; {      /*&     **  VARIABLES USED BY ACP SERVICES     **/        unsigned int iosb[2];      static struct fibdef fib; )     struct dsc$descriptor_s fib_descrip = H 	{ sizeof (struct fibdef), DSC$K_DTYPE_T, DSC$K_CLASS_S, (char *)&fib };     unsigned short len; !     char filespec[MAXFILESPEC+1]; -     $DESCRIPTOR (filespec_descrip, filespec);        /*     **	    NON-ACP VARABLES      **/         struct fil_dx_tag *new_list;     register int i;      int total_dids; !     char equ_name[MAXFILESPEC+1];      int total_devices;!     char dev_name[MAXFILESPEC+1]; !     struct fil_dx_tag temp_entry;      int allocate_size;     char str[128];#     $DESCRIPTOR (str_descrip, str);*      struct filespec_list_tag *p;     struct w_dids_tag *q;A       /*     **	Create a new list head.0     **	Free up memory for old list at the end.       **/o  C     if ((new_list = create_MARKER()) == (struct fil_dx_tag *)NULL) e     {r 	return DX__ERROR;     }e       total_dids = 0;0     equ_name[0] = EOS;     total_devices = 0;     dev_name[0] = EOS;=     for (p = cur_filter.name_filespec_list;  p;  p = p->next)I     {--         for (q = p->w_dids;  q;  q = q->next) 	         {" 	    size_t len;  6             if (strcmp (q->equivalent_name, equ_name))
             {e                 total_dids++;s6                 strcpy (equ_name, q->equivalent_name);
             }u- 	    len = strcspn (q->equivalent_name, "[");i<             if (strncmp (q->equivalent_name, dev_name, len))
             {I                  total_devices++;<                 strncpy (dev_name, q->equivalent_name, len);
             } 	         }*     }	  @     for (p = cur_filter.exclude_filespec_list;  p;  p = p->next)     {  	/* ? 	**	Find all the files in this directory that meet the criteria  	**/   	strcpy(str, p->name);# 	LENGTH(str_descrip) = strlen(str);C  -         for (q = p->w_dids;  q;  q = q->next)n	         {t 	    for (i = 0; i <= 2; i++)L1 		fib.fib$r_did_overlay.fib$w_did[i] = q->did[i];s   	    filespec[0] = EOS;c   	    for (i = 0;  i <= 2;  i++)b 	    {  		temp_entry.did[i] = q->did[i]; 	    }   	    /*k; 	    **  Initialize FIB to indicate to ACP that a directoryt& 	    **  look-up operation is desired. 	    **/  6 	    fib.fib$r_nmctl_overlay.fib$w_nmctl = FIB$M_WILD; 	    fib.fib$l_wcc = 0;b   	    check_OK(sys$qiow (   			0,  			q->chan,n 			IO$_ACCESS, f	 			iosb, * 			0,  			0,  			&fib_descrip, t 			&str_descrip, *	 			&len, o 			&filespec_descrip,  			0,  			0 ))   $ 	    while (iosb[0] == SS$_NORMAL ||> 		   ((iosb[0] == SS$_NOPRIV || iosb[0] == SS$_NOSUCHFILE) &&  		     filespec[0])) 	    {# 		if (!strstr (filespec, ".DIR;1"))s 		{  		    if (total_dids <= 1) 		    {(# 			strcpy(temp_entry.fn, filespec);E 		    }E" 		    else if (total_devices <= 1) 		    {E# 			sprintf (temp_entry.fn, "%s%s",  3 			    strchr (q->equivalent_name, '['), filespec);  		    }R
 		    else 		    {(# 			sprintf (temp_entry.fn, "%s%s", *% 			    q->equivalent_name, filespec);N 		    }B   		    insert_filelist_entry(, 			new_list, temp_entry, sortby, sortorder); 		}F   		check_OK(sys$qiow ( 
 			    0,  			    q->chan,[ 			    IO$_ACCESS,  
 			    iosb, a
 			    0, 
 			    0,  			    &fib_descrip, y 			    &str_descrip, z
 			    &len, r 			    &filespec_descrip, 
 			    0,  			    0 ))u 	    } 	}     }g  !     free_filelist(exclude_listp);      *exclude_listp = new_list;     return DX__NORMAL; }        /* **++ **  FUNCTIONAL DESCRIPTION:l **B **      FIND_MATCH_FILE() matchs the file with all the files that 1 **	meets the filter 'NAME' criteria.  It return 1f0 **	if there's a match; otherwise, 0 is returned. ** **-- **/r( int	find_match_file(candidate_file, win) char *candidate_file;  unsigned short int win;t {r     /*&     **  VARIABLES USED BY ACP SERVICES     **/r       unsigned int iosb[2];r     static struct fibdef fib; )     struct dsc$descriptor_s fib_descrip =tH 	{ sizeof (struct fibdef), DSC$K_DTYPE_T, DSC$K_CLASS_S, (char *)&fib };     unsigned short len;t!     char filespec[MAXFILESPEC+1];t-     $DESCRIPTOR (filespec_descrip, filespec);        /*     **	    NON-ACP VARABLESi     **/        register int i;i     char str[128];#     $DESCRIPTOR (str_descrip, str);      int total_dids;;!     char equ_name[MAXFILESPEC+1];.     int total_devices;!     char dev_name[MAXFILESPEC+1];       struct filespec_list_tag *p;     struct w_dids_tag *q;      char fn[MAXFILESPEC+1];f     struct fil_dx_tag *head;-     struct fil_dx_tag temp_entry, *s, *t, *u;a     int found = 0;     char errmsg[256];e  ?     if ((head = create_MARKER()) == (struct fil_dx_tag *)NULL) v     {a1 	signal_err("Insufficient virtual memory", bell);n 	return  0;,     }        total_dids = 0;      equ_name[0] = EOS;     total_devices = 0;     dev_name[0] = EOS;Z     for (p = cntrl_info_block.dir_dx[win].cur_filter.name_filespec_list;  p;  p = p->next)     {n-         for (q = p->w_dids;  q;  q = q->next)*	         {  	    size_t len;  6             if (strcmp (q->equivalent_name, equ_name))
             {_                 total_dids++;)6                 strcpy (equ_name, q->equivalent_name);
             } - 	    len = strcspn (q->equivalent_name, "[");v<             if (strncmp (q->equivalent_name, dev_name, len))
             {                   total_devices++;<                 strncpy (dev_name, q->equivalent_name, len);
             }d	         }P     }        /*3     **	Search for all files that match the filespec      **/f  Z     for (p = cntrl_info_block.dir_dx[win].cur_filter.name_filespec_list;  p;  p = p->next)     {  	/* ? 	**	Find all the files in this directory that meet the criteria& 	**/   	strcpy(str, p->name);# 	LENGTH(str_descrip) = strlen(str);   -         for (q = p->w_dids;  q;  q = q->next)$	         {  	    for (i = 0; i <= 2; i++)|1 		fib.fib$r_did_overlay.fib$w_did[i] = q->did[i];]   	    filespec[0] = EOS;    	    /*a; 	    **  Initialize FIB to indicate to ACP that a directory & 	    **  look-up operation is desired. 	    **/  6 	    fib.fib$r_nmctl_overlay.fib$w_nmctl = FIB$M_WILD; 	    fib.fib$l_wcc = 0;    	    check_OK(sys$qiow ( ( 			0,  			q->chan,  			IO$_ACCESS,  	 			iosb,   			0,  			0,  			&fib_descrip, y 			&str_descrip, i	 			&len, , 			&filespec_descrip,  			0,  			0 ))   % 	    while (iosb[0] == SS$_NORMAL ||  > 		   ((iosb[0] == SS$_NOPRIV || iosb[0] == SS$_NOSUCHFILE) &&  		     filespec[0])) 	    { 		filespec[len] = EOS;) 		/**  Only full path name is needed  **/)" 		sprintf (temp_entry.fn, "%s%s", ! 			q->equivalent_name, filespec);e   		insert_filelist_entry( 		    head,  		    temp_entry,	* 		    cntrl_info_block.dir_dx[win].sortby,. 		    cntrl_info_block.dir_dx[win].sortorder);   		check_OK(sys$qiow ( 
 			    0,  			    q->chan,_ 			    IO$_ACCESS, 7
 			    iosb, :
 			    0, 
 			    0,  			    &fib_descrip, & 			    &str_descrip, e
 			    &len, o 			    &filespec_descrip, 
 			    0,  			    0 ))p 	    } 	}     }        /*>     **  Delete a file from non-directory file list if it is no7     **	longer belong to the list due to an insertion of ;     **	another file (i.e. remove A.A;13 if A.A;14 was added ;     **	in this directory and the file spec is *.*; for the n     **	latest version.)0     **/   8     for (u = head->forward;  u != head;  u = u->forward)     {y% 	if (!strcmp (candidate_file, u->fn))c 	{G 	    for (s = cntrl_info_block.dir_dx[win].non_dir_filelist->forward;  eF 		s != cntrl_info_block.dir_dx[win].non_dir_filelist;  s = s->forward) 	    {& 		find_full_path_name(s->fn, fn, win);6 		for (t = head->forward;  t != head;  t = t->forward) 		{  		    if (!strcmp (fn, t->fn)) 		    {		 			break;_ 		    }< 		}    . 		if (t == head) 		{ & 		    filer_delete$2(fn, errmsg, win); 		    break; 		}  	    }
 	    found++;, 	    break;f 	}	     }            free_filelist(&head);,       return found;T })       /* **++ **  FUNCTIONAL DESCRIPTION:f **C **      FIND_QUEUE_FILE() matchs the file with all the files in theeB **	cache queue that meets the filter 'NAME' criteria.  It return 10 **	if there's a match; otherwise, 0 is returned. ** **-- **/ , int	find_queue_file(candidate_fid, elementp)$ unsigned short int candidate_fid[3];! struct filer_cache_tag *elementp;D {C     /*&     **  VARIABLES USED BY ACP SERVICES     **/_       unsigned int iosb[2];	     static struct fibdef fib; )     struct dsc$descriptor_s fib_descrip = H 	{ sizeof (struct fibdef), DSC$K_DTYPE_T, DSC$K_CLASS_S, (char *)&fib };     unsigned short len; !     char filespec[MAXFILESPEC+1]; -     $DESCRIPTOR (filespec_descrip, filespec);        /*     **	    NON-ACP VARABLESN     **/*       register int i;I     char str[128];#     $DESCRIPTOR (str_descrip, str);      int total_dids;e!     char equ_name[MAXFILESPEC+1];      int total_devices;!     char dev_name[MAXFILESPEC+1];       struct filespec_list_tag *p;     struct w_dids_tag *q;d     char fn[MAXFILESPEC+1];r     struct fil_dx_tag *head;-     struct fil_dx_tag temp_entry, *s, *t, *u;c     int found = 0;     char errmsg[256];h  ?     if ((head = create_MARKER()) == (struct fil_dx_tag *)NULL) E     { 1 	signal_err("Insufficient virtual memory", bell);  	return  0;      }        total_dids = 0;s     equ_name[0] = EOS;     total_devices = 0;     dev_name[0] = EOS;G     for (p = elementp->cur_filter.name_filespec_list;  p;  p = p->next)      {,-         for (q = p->w_dids;  q;  q = q->next) 	         {  	    size_t len;  6             if (strcmp (q->equivalent_name, equ_name))
             {*                 total_dids++;;6                 strcpy (equ_name, q->equivalent_name);
             }s- 	    len = strcspn (q->equivalent_name, "[");_<             if (strncmp (q->equivalent_name, dev_name, len))
             {{                  total_devices++;<                 strncpy (dev_name, q->equivalent_name, len);
             }C	         }$     }T       /*3     **	Search for all files that match the filespecr     **/}  G     for (p = elementp->cur_filter.name_filespec_list;  p;  p = p->next)K     {T 	/*A? 	**	Find all the files in this directory that meet the criteria& 	**/   	strcpy(str, p->name);# 	LENGTH(str_descrip) = strlen(str);N  -         for (q = p->w_dids;  q;  q = q->next) 	         {a 	    for (i = 0; i <= 2; i++)F1 		fib.fib$r_did_overlay.fib$w_did[i] = q->did[i];n   	    filespec[0] = EOS;t   	    /*_; 	    **  Initialize FIB to indicate to ACP that a directory & 	    **  look-up operation is desired. 	    **/  6 	    fib.fib$r_nmctl_overlay.fib$w_nmctl = FIB$M_WILD; 	    fib.fib$l_wcc = 0;    	    check_OK(sys$qiow ( e 			0,  			q->chan,F 			IO$_ACCESS,  	 			iosb, r 			0,  			0,  			&fib_descrip, s 			&str_descrip, T	 			&len, _ 			&filespec_descrip,  			0,  			0 )).  % 	    while (iosb[0] == SS$_NORMAL || )> 		   ((iosb[0] == SS$_NOPRIV || iosb[0] == SS$_NOSUCHFILE) &&  		     filespec[0])) 	    { 		filespec[len] = EOS; 		if (total_dids <= 1) 		{ & 		    strcpy(temp_entry.fn, filespec); 		}  		else if (total_devices <= 1) 		{0& 		    sprintf (temp_entry.fn, "%s%s", / 			strchr (q->equivalent_name, '['), filespec);x 		}  		else 		{ D 		    sprintf (temp_entry.fn, "%s%s", q->equivalent_name, filespec); 		}    		for (i = 0;  i <= 2;  i++) 		{e= 		    temp_entry.fid[i] = fib.fib$r_fid_overlay.fib$w_fid[i];  		}    		insert_filelist_entry( 		    head,  		    temp_entry,  		    elementp->sortby,e 		    elementp->sortorder);    		check_OK(sys$qiow ( 
 			    0,  			    q->chan,  			    IO$_ACCESS,  
 			    iosb, _
 			    0, 
 			    0,  			    &fib_descrip, q 			    &str_descrip, ;
 			    &len,   			    &filespec_descrip, 
 			    0,  			    0 ))T 	    } 	}     }_       /*>     **  Delete a file from non-directory file list if it is no7     **	longer belong to the list due to an insertion oft;     **	another file (i.e. remove A.A;13 if A.A;14 was added ;     **	in this directory and the file spec is *.*; for the (     **	latest version.)i     **/i  8     for (u = head->forward;  u != head;  u = u->forward)     { % 	if (candidate_fid[0] == u->fid[0] &&{% 	    candidate_fid[1] == u->fid[1] && # 	    candidate_fid[2] == u->fid[2])I 	{3 	    for (s = elementp->non_dir_filelist->forward; o7 		    s != elementp->non_dir_filelist;  s = s->forward)e 	    {6 		for (t = head->forward;  t != head;  t = t->forward) 		{k# 		    if (s->fid[0] == t->fid[0] &&  			s->fid[1] == t->fid[1] && 			s->fid[2] == t->fid[2]) 		    { 	 			break;c 		    }	 		}      		if (t == head)7 		{	/**  This file is no longer belong to the list  **/R 		    elementp->tot_files--;* 		    elementp->tot_blocks -= s->filesize;  		    remove_filelist_entry(&s); 		    break; 		}, 	    }
 	    found++;  	    break;i 	}	     }            free_filelist(&head);f       return found;  }      i /* **++ **  FUNCTIONAL DESCRIPTION:r ** **      tbsf ** **-- **/	# struct fil_dx_tag *	create_MARKER(), {l     struct fil_dx_tag *MARKER;     int allocate_size;          /*)     **	Allocate virtual memory for MARKERe     **/   /     allocate_size = sizeof (struct fil_dx_tag);      check_OK(lib$get_vm (0 		 &allocate_size, o 		 &MARKER,  		 0))       /*     **	Initialize MARKER     **/g  9     MARKER->fid[0] = MARKER->fid[1] = MARKER->fid[2] = 0;.9     MARKER->did[0] = MARKER->did[1] = MARKER->did[2] = 0;f     MARKER->fn[0] = EOS;     MARKER->filesize = 0;r     MARKER->fpro = 0xffff;     MARKER->state = waiting;&     MARKER->beg_y = MARKER->beg_x = 0;0     MARKER->forward = MARKER->backward = MARKER;       return MARKER; }r     i /* **++ **  FUNCTIONAL DESCRIPTION:/ **7 **      ADD_FILELIST_ENTRY() insert a entry to the list  ** **-- **/:. int	add_filelist_entry(before, after, current) struct fil_dx_tag *before; struct fil_dx_tag *after;M struct fil_dx_tag *current;d {        /*6     **  Test if FORWARD and BACKWARD links are correct     **/n  !     if (before->forward != after)  	return DX__ERROR;  "     if (before != after->backward) 	return DX__ERROR;       /*     **  Re-link with new entry     **/        before->forward = current;     current->backward = before;+       after->backward = current;     current->forward = after;D       return DX__NORMAL; }_     d /* **++ **  FUNCTIONAL DESCRIPTION:m **< **      FREE_FILELIST() frees up the memory used by the list ** **-- **/b int	free_filelist(MARKER)  struct fil_dx_tag **MARKER;	 {      struct fil_dx_tag *f, *g;w  .     if (*MARKER != (struct fil_dx_tag *)NULL)      {) 	f = (*MARKER)->forward; 	while (f != *MARKER)  	{ 	    g = f->forward; 	    remove_filelist_entry(&f);R 	    f = g;e 	} 	remove_filelist_entry(MARKER);	% 	*MARKER = (struct fil_dx_tag *)NULL;      }R       return DX__NORMAL; }s     	 /* **++ **  FUNCTIONAL DESCRIPTION:R **= **      REMOVE_FILELIST_ENTRY() removes a entry from the listX ** **-- **/ % int	remove_filelist_entry(file_entry)s struct fil_dx_tag **file_entry;t {o&     struct fil_dx_tag *before, *after;     int allocate_size;  %     before = (*file_entry)->backward; #     after = (*file_entry)->forward;e       before->forward = after;     after->backward = before;R  /     allocate_size = sizeof (struct fil_dx_tag);r       check_OK(lib$free_vm(R 		&allocate_size, 
 		file_entry,	 		0))e       return DX__NORMAL; }O     b /* **++ **  FUNCTIONAL DESCRIPTION:  **C **      INSERT_FILELIST_ENTRY() finds a slot to insert a new entry.;C **	It searchs starting from the list head using the current sorting} **	cirteria and order. ** **-- **/ 2 int	insert_filelist_entry(l, e, sortby, sortorder) struct fil_dx_tag *l;  struct fil_dx_tag e; enum sortbys sortby; enum sortorders sortorder; {&       struct fil_dx_tag *f, *g;      int allocate_size;
     int i;  N     int (*cmpfunc)(struct fil_dx_tag *, struct fil_dx_tag *, enum sortorders);  $     if (e.fn[strlen(e.fn)-1] == ']')     {h         cmpfunc = sort_by_dir;     }      else     {r 	switch (sortby) E 	{: 	    case sortname:    cmpfunc = sort_by_name;      break;: 	    case sorttype:    cmpfunc = sort_by_type;      break;: 	    case sortcredate: cmpfunc = sort_by_credate;   break;: 	    case sortrevdate: cmpfunc = sort_by_revdate;   break;: 	    case sortexpdate: cmpfunc = sort_by_expdate;   break;: 	    case sortbakdate: cmpfunc = sort_by_bakdate;   break;: 	    case sortsize:    cmpfunc = sort_by_size;      break;: 	    case sortmark:    cmpfunc = sort_by_mark;      break; 	}     }h  1     for (g = l->forward; g != l; g = g->forward) e       {,>         if (e.did[0] == g->did[0] && e.did[1] == g->did[1] &&  	    e.did[2] == g->did[2])l	         {e 	    if (!strcmp (g->fn, e.fn))s4 	    {	    /**  A file with the same name found  **/ 		return DX__DONTCARE; 	    }  ! 	    if (sortorder == ascending) e 	    {( 		if ((*cmpfunc)(&e, g, ascending) <= 0) 		    break; 	    } else  	    {) 		if ((*cmpfunc)(&e, g, descending) >= 0)  		    break; 	    }	         }*     }*          /*0     **	Allocate virtual memory for the new entry     **/   /     allocate_size = sizeof (struct fil_dx_tag);=     check_OK(lib$get_vm () 	     &allocate_size, 
 	     &f, 	 	     0))o       for (i = 0;  i <= 2;  i++)     {  	f->fid[i] = e.fid[i]; 	f->did[i] = e.did[i];     }p     f->filesize = e.filesize;t2     memcpy(&f->cdat, &e.cdat, sizeof (DATE_TIME));2     memcpy(&f->rdat, &e.rdat, sizeof (DATE_TIME));2     memcpy(&f->edat, &e.edat, sizeof (DATE_TIME));2     memcpy(&f->bdat, &e.bdat, sizeof (DATE_TIME));     f->fpro = e.fpro;t     strcpy(f->fn, e.fn);     f->state = e.state;u     f->beg_y = e.beg_y;e     f->beg_x = e.beg_x;      f->forward = e.forward;i     f->backward = e.backward;   1     return add_filelist_entry(g->backward, g, f);  } 