K /* ************************************************************************ K *   File: comm.c                                        Part of CircleMUD * K *  Usage: Communication, socket handling, main(), central game loop       * K *                                                                         * K *  All rights reserved.  See license.doc for complete information.        * K *                                                                         * K *  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University * K *  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               * K ************************************************************************ */    #define __COMM_C__   #include "conf.h"  #include "sysdep.h"   9 #ifdef CIRCLE_MACINTOSH		/* Includes for the Macintosh */  # define SIGPIPE 13  # define SIGALRM 14    /* GUSI headers */ # include <sys/ioctl.h>    /* Codewarrior dependant */  # include <SIOUX.h>  # include <console.h>  #endif  / #ifdef CIRCLE_WINDOWS		/* Includes for Win32 */  # ifdef __BORLANDC__ #  include <dir.h> # else /* MSVC */  #  include <direct.h>  # endif  # include <mmsystem.h> #endif /* CIRCLE_WINDOWS */   1 #ifdef CIRCLE_AMIGA		/* Includes for the Amiga */  # include <sys/ioctl.h>   # include <clib/socket_protos.h> #endif /* CIRCLE_AMIGA */   : #ifdef CIRCLE_ACORN		/* Includes for the Acorn (RiscOS) */ # include <socklib.h>  # include <inetlib.h>  # include <sys/ioctl.h>  #endif   /*F  * Note, most includes for all platforms are in sysdep.h.  The list ofD  * files that is included is controlled by conf.h for that platform.  */    #include "structs.h" #include "utils.h" #include "comm.h"  #include "interpreter.h" #include "handler.h" #include "db.h"  #include "house.h" #include "olc.h"   #ifdef HAVE_ARPA_TELNET_H  #include <arpa/telnet.h> #else  #include "telnet.h"  #endif   #ifndef INVALID_SOCKET #define INVALID_SOCKET -1  #endif  
 /* externs */ ) extern struct ban_list_element *ban_list;  extern int num_invalid;  extern char *GREETINGS; & extern const char circlemud_version[]; extern int circle_restrict;  extern int mini_mud; extern int no_rent_check;  extern FILE *player_fl;  extern int DFLT_PORT;  extern char *DFLT_DIR; extern char *DFLT_IP;  extern char *LOGNAME;  extern int MAX_PLAYERS; $ extern struct zone_data *zone_table;4 extern const char *save_info_msg[];   /* In olc.c */ extern int top_of_zone_table; - extern struct room_data *world;	/* In db.c */ & extern int top_of_world;	/* In db.c */6 extern struct time_info_data time_info;		/* In db.c */ extern char help[];    /* local globals */ G struct descriptor_data *descriptor_list = NULL;		/* master desc list */ A struct txt_block *bufpool = 0;	/* pool of large output buffers */ = int buf_largecount = 0;		/* # of large buffers which exist */ 6 int buf_overflows = 0;		/* # of overflows of output */B int buf_switches = 0;		/* # of switches from small to large buf */- int circle_shutdown = 0;	/* clean shutdown */ > int circle_reboot = 0;		/* reboot the game after a shutdown */= int no_specials = 0;		/* Suppress ass. of special routines */ 5 int max_players = 0;		/* max descriptors available */ . int tics = 0;			/* for extern checkpointing */0 int scheck = 0;			/* for syntax checking mode */1 extern int nameserver_is_slow;	/* see config.c */ ) extern int auto_save;		/* see config.c */ , extern int autosave_time;	/* see config.c */: struct timeval null_time;	/* zero-valued time structure */< FILE *logfile = NULL;		/* Where to send the log messages. */   /* functions in this file */$ RETSIGTYPE reread_wizlists(int sig);$ RETSIGTYPE unrestrict_game(int sig); RETSIGTYPE reap(int sig); " RETSIGTYPE checkpointing(int sig); RETSIGTYPE hupsig(int sig); O ssize_t perform_socket_read(socket_t desc, char *read_point,size_t space_left); K ssize_t perform_socket_write(socket_t desc, const char *txt,size_t length); ) void echo_off(struct descriptor_data *d); ( void echo_on(struct descriptor_data *d); void sanity_check(void);> int get_from_q(struct txt_q *queue, char *dest, int *aliased); void init_game(int port);  void signal_setup(void);  void game_loop(int mother_desc); int init_socket(int port); int new_descriptor(int s); int get_max_players(void);. int process_output(struct descriptor_data *t);- int process_input(struct descriptor_data *t); = struct timeval *timediff(struct timeval a, struct timeval b); < struct timeval *timeadd(struct timeval a, struct timeval b);- void flush_queues(struct descriptor_data *d);  void nonblock(socket_t s);F int perform_subst(struct descriptor_data *t, char *orig, char *subst);9 int perform_alias(struct descriptor_data *d, char *orig);  void record_usage(void);1 char *make_prompt(struct descriptor_data *point);   void check_idle_passwords(void); void heartbeat(int pulse);$ struct in_addr *get_bind_addr(void);7 int parse_ip(const char *addr, struct in_addr *inaddr);  int set_sendbuf(socket_t s); #if defined(POSIX). sigfunc *my_signal(int signo, sigfunc * func); #endif   /* extern fcnts */ void reboot_wizlists(void);  void boot_world(void);+ void affect_update(void);	/* In spells.c */  void mobile_activity(void); 6 void string_add(struct descriptor_data *d, char *str); void perform_violence(void);9 void show_string(struct descriptor_data *d, char *input);  int isbanned(char *hostname);   void weather_and_time(int mode);& void redit_save_to_disk(int zone_num);& void oedit_save_to_disk(int zone_num);& void medit_save_to_disk(int zone_num);& void sedit_save_to_disk(int zone_num);& void zedit_save_to_disk(int zone_num); int real_zone(int number);   #ifdef __CXREF__ #undef FD_ZERO
 #undef FD_SET  #undef FD_ISSET 
 #undef FD_CLR  #define FD_ZERO(x) #define FD_SET(x, y) 0 #define FD_ISSET(x, y) 0 #define FD_CLR(x, y) #endif    H /***********************************************************************H *  main game loop and related stuff                                    *H ***********************************************************************/  8 #if defined(CIRCLE_WINDOWS) || defined(CIRCLE_MACINTOSH)  > /* Windows doesn't have gettimeofday, so we'll simulate it. *// /* The Mac doesn't have gettimeofday either. */ < void gettimeofday(struct timeval *t, struct timezone *dummy) {  #if defined(CIRCLE_WINDOWS) "   DWORD millisec = GetTickCount(); #elif defined(CIRCLE_MACINTOSH)    unsigned long int millisec; 7   millisec = (int)((float)TickCount() * 1000.0 / 60.0);  #endif  &   t->tv_sec = (int) (millisec / 1000);(   t->tv_usec = (millisec % 1000) * 1000; }   / #endif	/* CIRCLE_WINDOWS || CIRCLE_MACINTOSH */   , #if defined(CIRCLE_VMS) && defined(__GNUC__)   /*								*/>   /* Fudge to allow the UNIX gettimeofday() to work on VMS.	*/   /* Author: UNKNOWN						*/   /*								*/<   int gettimeofday (struct timeval *tv, struct timezone *tz)   {      timeb_t tmp_time;      ftime(&tmp_time);      if (tv != NULL)      { "       tv->tv_sec  = tmp_time.time;,       tv->tv_usec = tmp_time.millitm * 1000;     }    }    /*								*/9   /* Fudge to allow the UNIX unlink() to work On VMS.		*/    /* Author: UNKNOWN						*/   /*								*/ # include <descrip.h>  # include <string.h> # include <lib$routines.h>   unlink(filename)   char *filename;    { -     static struct dsc$descriptor_s file_desc; .     file_desc.dsc$w_length = strlen(filename);+     file_desc.dsc$b_dtype  = DSC$K_DTYPE_T; +     file_desc.dsc$b_class  = DSC$K_CLASS_S; &     file_desc.dsc$a_pointer= filename;)     return (lib$delete_file(&file_desc));    }  #endif   int main(int argc, char **argv)  {    int port;    int pos = 1;   char *dir;  5   /* Initialize these to check for overruns later. */ J   buf[MAX_STRING_LENGTH - 1] = buf1[MAX_STRING_LENGTH - 1] = MAGIC_NUMBER;J   buf2[MAX_STRING_LENGTH - 1] = arg[MAX_STRING_LENGTH - 1] = MAGIC_NUMBER;   #ifdef CIRCLE_MACINTOSH    /*E    * ccommand() calls the command line/io redirection dialog box from !    * Codewarriors's SIOUX library     */    argc = ccommand(&argv); +   /* Initialize the GUSI library calls.  */    GUSIDefaultSetup();  #endif     port = DFLT_PORT;    dir = DFLT_DIR;      /*L    * It would be nice to make this a command line option but the parser uses)    * the log() function, maybe later. -gg     */ *   if (LOGNAME == NULL || *LOGNAME == '\0'))     logfile = fdopen(STDERR_FILENO, "w");    else,     logfile = freopen(LOGNAME, "w", stderr);     if (logfile == NULL) {/       printf("error opening log file %s: %s\n", 1 		LOGNAME ? LOGNAME : "stderr", strerror(errno));        exit(1);   }      log(circlemud_version);   1   while ((pos < argc) && (*(argv[pos]) == '-')) {      switch (*(argv[pos] + 1)) { 
     case 'd':        if (*(argv[pos] + 2))  	dir = argv[pos] + 2;        else if (++pos < argc) 	dir = argv[pos];        else {8 	log("SYSERR: Directory arg expected after option -d.");	 	exit(1);        }        break;
     case 'm':        mini_mud = 1;        no_rent_check = 1;=       log("Running in minimized mode & with no rent check.");        break;
     case 'c':        scheck = 1; (       log("Syntax check mode enabled.");       break;
     case 'q':        no_rent_check = 1;6       log("Quick boot mode -- rent check supressed.");       break;
     case 'r':        circle_restrict = 1;9       log("Restricting game -- no new players allowed.");        break;
     case 's':        no_specials = 1;9       log("Suppressing assignment of special routines.");        break;     default:N       log("SYSERR: Unknown option -%c in argument string.", *(argv[pos] + 1));       break;     } 
     pos++;   }      if (pos < argc) {      if (!isdigit(*argv[pos])) { R       log("Usage: %s [-c] [-m] [-q] [-r] [-s] [-d pathname] [port #]\n", argv[0]);       exit(1);2     } else if ((port = atoi(argv[pos])) <= 1024) {3       log("SYSERR: Illegal port number %d.", port);        exit(1);     }    }      if (chdir(dir) < 0) { =     perror("SYSERR: Fatal error changing to data directory");      exit(1);   } *   log("Using %s as data directory.", dir);     if (scheck) {      boot_world();      log("Done."); 
   } else {*     log("Running game on port %d.", port);     init_game(port);   }      return 0;  }       1 /* Init sockets, run game, and cleanup sockets */  void init_game(int port) {    int mother_desc;  >   /* We don't want to restart if we crash before we get up. */   touch(KILLSCRIPT_FILE);      circle_srandom(time(0));     log("Finding player limit."); "   max_players = get_max_players();  $   log("Opening mother connection.");"   mother_desc = init_socket(port);     boot_db();   #ifdef CIRCLE_UNIX   log("Signal trapping.");   signal_setup();  #endif  K   /* If we made it this far, we will be able to restart without problem. */    remove(KILLSCRIPT_FILE);     log("Entering game loop.");      game_loop(mother_desc);      log("Closing all sockets.");   while (descriptor_list) "     close_socket(descriptor_list);     CLOSE_SOCKET(mother_desc);   fclose(player_fl);  D   if (circle_reboot != 2 && olc_save_list) { /* Don't save zones. */-     struct olc_save_info *entry, *next_entry;      int rznum;  <     for (entry = olc_save_list; entry; entry = next_entry) {       next_entry = entry->next; /       if (entry->type < 0 || entry->type > 4) { @         sprintf(buf, "OLC: Illegal save type %d!", entry->type);         log(buf); @       } else if ((rznum = real_zone(entry->zone * 100)) == -1) {@         sprintf(buf, "OLC: Illegal save zone %d!", entry->zone);         log(buf); :       } else if (rznum < 0 || rznum > top_of_zone_table) {: 	sprintf(buf, "OLC: Invalid real zone number %d!", rznum);
 	log(buf);       } else {:         sprintf(buf, "OLC: Reboot saving %s for zone %d.",= 		save_info_msg[(int)entry->type], zone_table[rznum].number);          log(buf);          switch (entry->type) {=         case OLC_SAVE_ROOM: redit_save_to_disk(rznum); break; =         case OLC_SAVE_OBJ:  oedit_save_to_disk(rznum); break; =         case OLC_SAVE_MOB:  medit_save_to_disk(rznum); break; =         case OLC_SAVE_ZONE: zedit_save_to_disk(rznum); break; =         case OLC_SAVE_SHOP: sedit_save_to_disk(rznum); break; C         default:      log("Unexpected olc_save_list->type"); break; 	         }        }      }    }      if (circle_reboot) {     log("Rebooting.");;     exit(52);			/* what's so great about HHGTTG, anyhow? */    } %   log("Normal termination of game.");  }        /*G  * init_socket sets up the mother descriptor - creates the socket, sets )  * its options up, binds it, and listens.   */  int init_socket(int port)  { 
   int s, opt;    struct sockaddr_in sa;   #ifdef CIRCLE_WINDOWS    {      WORD wVersionRequested;      WSADATA wsaData;  '     wVersionRequested = MAKEWORD(1, 1);   7     if (WSAStartup(wVersionRequested, &wsaData) != 0) { ,       log("SYSERR: WinSock not available!");       exit(1);     } 2     if ((wsaData.iMaxSockets - 4) < max_players) {,       max_players = wsaData.iMaxSockets - 4;     } .     log("Max players set to %d", max_players);  B     if ((s = socket(PF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET) {H       log("SYSERR: Error opening network connection: Winsock error #%d", 	  WSAGetLastError());       exit(1);     }    }  #else    /*J    * Should the first argument to socket() be AF_INET or PF_INET?  I don'tH    * know, take your pick.  PF_INET seems to be more widely adopted, andI    * Comer (_Internetworking with TCP/IP_) even makes a point to say that K    * people erroneously use AF_INET with socket() when they should be using K    * PF_INET.  However, the man pages of some systems indicate that AF_INET L    * is correct; some such as ConvexOS even say that you can use either one.L    * All implementations I've seen define AF_INET and PF_INET to be the same5    * number anyway, so the point is (hopefully) moot.     */   2   if ((s = socket(PF_INET, SOCK_STREAM, 0)) < 0) {,     perror("SYSERR: Error creating socket");     exit(1);   }  #endif				/* CIRCLE_WINDOWS */  7 #if defined(SO_REUSEADDR) && !defined(CIRCLE_MACINTOSH) 
   opt = 1;O   if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (char *) &opt, sizeof(opt)) < 0){ +     perror("SYSERR: setsockopt REUSEADDR");      exit(1);   }  #endif     set_sendbuf(s);    #if defined(SO_LINGER)   {      struct linger ld;        ld.l_onoff = 0;      ld.l_linger = 0;M     if (setsockopt(s, SOL_SOCKET, SO_LINGER, (char *) &ld, sizeof(ld)) < 0) { *       perror("SYSERR: setsockopt LINGER");       exit(1);     }    }  #endif     /* Clear the structure */ %   memset((char *)&sa, 0, sizeof(sa));      sa.sin_family = AF_INET;   sa.sin_port = htons(port);#   sa.sin_addr = *(get_bind_addr());   9   if (bind(s, (struct sockaddr *) &sa, sizeof(sa)) < 0) {      perror("SYSERR: bind");      CLOSE_SOCKET(s);     exit(1);   }    nonblock(s);   listen(s, 5);    return s;  }      int get_max_players(void)  {  #ifndef CIRCLE_UNIX    return MAX_PLAYERS;  #else      int max_descs = 0;   const char *method;    /*G  * First, we'll try using getrlimit/setrlimit.  This will probably work 7  * on most systems.  HAS_RLIMIT is defined in sysdep.h.   */  #ifdef HAS_RLIMIT    {      struct rlimit limit;  &     /* find the limit of file descs */     method = "rlimit";/     if (getrlimit(RLIMIT_NOFILE, &limit) < 0) { *       perror("SYSERR: calling getrlimit");       exit(1);     }   (     /* set the current to the maximum */$     limit.rlim_cur = limit.rlim_max;/     if (setrlimit(RLIMIT_NOFILE, &limit) < 0) { *       perror("SYSERR: calling setrlimit");       exit(1);     }  #ifdef RLIM_INFINITY(     if (limit.rlim_max == RLIM_INFINITY)3       max_descs = MAX_PLAYERS + NUM_RESERVED_DESCS;      elseH       max_descs = MIN(MAX_PLAYERS + NUM_RESERVED_DESCS, limit.rlim_max); #else F     max_descs = MIN(MAX_PLAYERS + NUM_RESERVED_DESCS, limit.rlim_max); #endif   }   . #elif defined (OPEN_MAX) || defined(FOPEN_MAX) #if !defined(OPEN_MAX) #define OPEN_MAX FOPEN_MAX #endif   method = "OPEN_MAX";C   max_descs = OPEN_MAX;		/* Uh oh.. rlimit didn't work, but we have  				 * OPEN_MAX */ #elif defined (_SC_OPEN_MAX)   /*K    * Okay, you don't have getrlimit() and you don't have OPEN_MAX.  Time to K    * try the POSIX sysconf() function.  (See Stevens' _Advanced Programming*    * in the UNIX Environment_).*    */    method = "POSIX sysconf";    errno = 0;0   if ((max_descs = sysconf(_SC_OPEN_MAX)) < 0) {     if (errno == 0)d3       max_descs = MAX_PLAYERS + NUM_RESERVED_DESCS; 
     else {.       perror("SYSERR: Error calling sysconf");       exit(1);     }e   }  #elsec9   /* if everything has failed, we'll just take a guess */    method = "random guess" /   max_descs = MAX_PLAYERS + NUM_RESERVED_DESCS;( #endif  6   /* now calculate max _players_ based on max descs */?   max_descs = MIN(MAX_PLAYERS, max_descs - NUM_RESERVED_DESCS);      if (max_descs <= 0) {*H     log("SYSERR: Non-positive max player limit!  (Set at %d using %s).", 	    max_descs, method);     exit(1);   }pA   log("Setting player limit to %d using %s.", max_descs, method);    return max_descs;  #endif /* CIRCLE_UNIX */ }S       /*D  * game_loop contains the main loop which drives the entire MUD.  ItF  * cycles once every 0.10 seconds and is responsible for accepting newF  * new connections, polling existing connections for input, dequeueingJ  * output and sending it out to players, and calling "heartbeat" functions  * such as mobile_activity().i  */C void game_loop(int mother_desc)A {a2   fd_set input_set, output_set, exc_set, null_set;O   struct timeval last_time, before_sleep, opt_time, process_time, now, timeout;t   char comm[MAX_INPUT_LENGTH];%   struct descriptor_data *d, *next_d; 1   int pulse = 0, missed_pulses, maxdesc, aliased;   - # if defined(CIRCLE_VMS) && defined(__GNUC__)l     unsigned int zero = 0; # endifc  &   /* initialize various time values */   null_time.tv_sec = 0;"   null_time.tv_usec = 0;   opt_time.tv_usec = OPT_USEC;   opt_time.tv_sec = 0;   FD_ZERO(&null_set);   2   gettimeofday(&last_time, (struct timezone *) 0);  N   /* The Main Loop.  The Big Cheese.  The Top Dog.  The Head Honcho.  The.. */   while (!circle_shutdown) {  0     /* Sleep if we don't have any connections */"     if (descriptor_list == NULL) {.       log("No connections.  Going to sleep.");       FD_ZERO(&input_set);&       FD_SET(mother_desc, &input_set);V       if (select(mother_desc + 1, &input_set, (fd_set *) 0, (fd_set *) 0, NULL) < 0) { 	if (errno == EINTR)' 	  log("Waking up to process signal.");_ 	elsex 	  perror("Select coma");n       } else$ 	log("New connection.  Waking up.");6       gettimeofday(&last_time, (struct timezone *) 0);     }eD     /* Set up the input, output, and exception sets for select(). */     FD_ZERO(&input_set);     FD_ZERO(&output_set);s     FD_ZERO(&exc_set);$     FD_SET(mother_desc, &input_set);       maxdesc = mother_desc;/     for (d = descriptor_list; d; d = d->next) {	 #ifndef CIRCLE_WINDOWS"       if (d->descriptor > maxdesc) 	maxdesc = d->descriptor;s #endif(       FD_SET(d->descriptor, &input_set);)       FD_SET(d->descriptor, &output_set);	&       FD_SET(d->descriptor, &exc_set);     }s       /*G      * At this point, we have completed all input, output and heartbeataH      * activity from the previous iteration, so we have to put ourselvesE      * to sleep until the next 0.1 second tick.  The first step is tonD      * calculate how long we took processing the previous iteration.      */t     J     gettimeofday(&before_sleep, (struct timezone *) 0); /* current time */6     process_time = *timediff(before_sleep, last_time);       /*N      * If we were asleep for more than one pass, count missed pulses and sleep?      * until we're resynchronized with the next upcoming pulse.L      */rF     if (process_time.tv_sec == 0 && process_time.tv_usec < OPT_USEC) {       missed_pulses = 0;     } else {;       missed_pulses = process_time.tv_sec * PASSES_PER_SEC;G7       missed_pulses += process_time.tv_usec / OPT_USEC;        process_time.tv_sec = 0;=       process_time.tv_usec = process_time.tv_usec % OPT_USEC;f     }k  .     /* Calculate the time we should wake up */J     last_time = *timeadd(before_sleep, *timediff(opt_time, process_time));  4     /* Now keep sleeping until that time has come */.     gettimeofday(&now, (struct timezone *) 0);(     timeout = *timediff(last_time, now);       /* Go to sleep */_     do { #ifdef CIRCLE_WINDOWSs<       Sleep(timeout.tv_sec * 1000 + timeout.tv_usec / 1000); #elsed  1 #     if defined(CIRCLE_VMS) && defined(__GNUC__)n>         if (select(zero, &zero, &zero, &zero, &timeout) < 0) {
 #     elseP         if (select(0, (fd_set *) 0, (fd_set *) 0, (fd_set *) 0, &timeout) < 0) { #     endif    	if (errno != EINTR) {" 	  perror("SYSERR: Select sleep"); 	  exit(1);  	}       }u #endif /* CIRCLE_WINDOWS */,0       gettimeofday(&now, (struct timezone *) 0);*       timeout = *timediff(last_time, now);0     } while (timeout.tv_usec || timeout.tv_sec);  G     /* Poll (without blocking) for new input, output, and exceptions */pQ     if (select(maxdesc + 1, &input_set, &output_set, &exc_set, &null_time) < 0) {        perror("Select poll");
       return;s     } <     /* If there are new connections waiting, accept them. */*     if (FD_ISSET(mother_desc, &input_set))"       new_descriptor(mother_desc);  M     /* Kick out the freaky folks in the exception set and marked for close */ .     for (d = descriptor_list; d; d = next_d) {       next_d = d->next;e.       if (FD_ISSET(d->descriptor, &exc_set)) {# 	FD_CLR(d->descriptor, &input_set);c$ 	FD_CLR(d->descriptor, &output_set); 	close_socket(d);r       }_     }(  0     /* Process descriptors with input pending */.     for (d = descriptor_list; d; d = next_d) {       next_d = d->next;o.       if (FD_ISSET(d->descriptor, &input_set)) 	if (process_input(d) < 0) 	  close_socket(d);      }F  :     /* Process commands we just read from process_input */.     for (d = descriptor_list; d; d = next_d) {       next_d = d->next;   D       /* Not combined to retain --(d->wait) behavior. -gg 2/20/98 */       d->wait -= (d->wait > 0);i       if (d->wait > 0)         continue;   1       if (!get_from_q(&d->input, comm, &aliased))*         continue;*         if (d->character) { C 	/* Reset the idle timer & pull char back from void if necessary */e' 	d->character->char_specials.timer = 0; F 	if (STATE(d) == CON_PLAYING && GET_WAS_IN(d->character) != NOWHERE) {( 	  if (d->character->in_room != NOWHERE)" 	    char_from_room(d->character);8 	  char_to_room(d->character, GET_WAS_IN(d->character));& 	  GET_WAS_IN(d->character) = NOWHERE;> 	  act("$n has returned.", TRUE, d->character, 0, 0, TO_ROOM); 	}       }        d->wait = 1;       d->has_prompt = 0;  <       if (d->showstr_count) /* Reading something w/ pager */ 	show_string(d, comm);8       else if (d->str)		/* Writing boards, mail, etc. */ 	string_add(d, comm);l<       else if (STATE(d) != CON_PLAYING) /* In menus, etc. */ 	nanny(d, comm);2       else {			/* else: we're playing normally. */2 	if (aliased)		/* To prevent recursive aliases. */B 	  d->has_prompt = 1;	/* To get newline before next cmd output. */I 	else if (perform_alias(d, comm))    /* Run it through aliasing system */ ) 	  get_from_q(&d->input, comm, &aliased); F 	command_interpreter(d->character, comm); /* Send it to interpreter */       }	     }n  M     /* Send queued output out to the operating system (ultimately to user) */l.     for (d = descriptor_list; d; d = next_d) {       next_d = d->next;_       /*								*/J       /* For some reason, the following FD_ISSET function in the IF     */J       /* statement below is broken under OpenVMS.  Removing the FD_ISSET*/J       /* solves the problem and so far no real problems have developed  */J       /* from its being removed.                                        */       /*								*/1 #     if defined(CIRCLE_VMS) && defined(__GNUC__)A         if (*(d->output)) {A
 #     elseC         if (*(d->output) && FD_ISSET(d->descriptor, &output_set)) {I #     endif]& 	/* Output for this player is ready */ 	if (process_output(d) < 0)a 	  close_socket(d);i 	elsee 	  d->has_prompt = 1;        }w     }'  E     /* Print prompts for other descriptors who had no other output */ /     for (d = descriptor_list; d; d = d->next) {        if (!d->has_prompt) { 4 	write_to_descriptor(d->descriptor, make_prompt(d)); 	d->has_prompt = 1;l       }n     }e  A     /* Kick out folks in the CON_CLOSE or CON_DISCONNECT state */f.     for (d = descriptor_list; d; d = next_d) {       next_d = d->next;O>       if (STATE(d) == CON_CLOSE || STATE(d) == CON_DISCONNECT) 	close_socket(d);N     }        /*J      * Now, we execute as many pulses as necessary--just one if we haven'tE      * missed any pulses, or make up for lost time if we missed a few '      * pulses by sleeping for too long.-      */      missed_pulses++;       if (missed_pulses <= 0) {fc       log("SYSERR: **BAD** MISSED_PULSES NONPOSITIVE (%d), TIME GOING BACKWARDS!!", missed_pulses);        missed_pulses = 1;     }r  L     /* If we missed more than 30 seconds worth of pulses, just do 30 secs */0     if (missed_pulses > (30 * PASSES_PER_SEC)) {X       log("SYSERR: Missed %d seconds worth of pulses.", missed_pulses / PASSES_PER_SEC);*       missed_pulses = 30 * PASSES_PER_SEC;     }o  -     /* Now execute the heartbeat functions */      while (missed_pulses--)o       heartbeat(++pulse);c  (     /* Roll pulse over after 10 hours */-     if (pulse >= (600 * 60 * PASSES_PER_SEC))s       pulse = 0;   #ifdef CIRCLE_UNIX9     /* Update tics for deadlock protection (UNIX only) */      tics++;p #endif   }g }n     void heartbeat(int pulse)  {r&   static int mins_since_crashsave = 0;  '   if (!(pulse % (30 * PASSES_PER_SEC)))r     sanity_check();      if (!(pulse % PULSE_ZONE))     zone_update();  9   if (!(pulse % (15 * PASSES_PER_SEC)))		/* 15 seconds */[     check_idle_passwords();a     if (!(pulse % PULSE_MOBILE))     mobile_activity();      if (!(pulse % PULSE_VIOLENCE))     perform_violence();I  8   if (!(pulse % (SECS_PER_MUD_HOUR * PASSES_PER_SEC))) {     weather_and_time(1);     affect_update();     point_update();i     fflush(player_fl);   } E   if (auto_save && !(pulse % (60 * PASSES_PER_SEC))) {	/* 1 minute */e2     if (++mins_since_crashsave >= autosave_time) {       mins_since_crashsave = 0;p       Crash_save_all();t       House_save_all();e     }    } ;   if (!(pulse % (5 * 60 * PASSES_PER_SEC)))	/* 5 minutes */d     record_usage();  }     E /* ******************************************************************eE *  general utility stuff (for local use)                            * E ****************************************************************** */    /*B  *  new code to calculate time differences, which works on systemsE  *  for which tv_usec is unsigned (and thus comparisons for somethinglG  *  being < 0 fail).  Based on code submitted by ss@sirocco.cup.hp.com.t  */i   /*<  * code to return the time difference between a and b (a-b).4  * always returns a nonnegative value (floors at 0).  *C  * Fixed the 'aggregate return' warning.  Now it's not thread-safe.r  *	-gg 6/18/98  */S< struct timeval *timediff(struct timeval a, struct timeval b) {o   static struct timeval rslt;o     if (a.tv_sec < b.tv_sec)     return &null_time;"   else if (a.tv_sec == b.tv_sec) {     if (a.tv_usec < b.tv_usec)       return &null_time;
     else {       rslt.tv_sec = 0;+       rslt.tv_usec = a.tv_usec - b.tv_usec;        return &rslt;,     }I(   } else {			/* a->tv_sec > b->tv_sec */&     rslt.tv_sec = a.tv_sec - b.tv_sec;      if (a.tv_usec < b.tv_usec) {5       rslt.tv_usec = a.tv_usec + 1000000 - b.tv_usec;!       rslt.tv_sec--;
     } else+       rslt.tv_usec = a.tv_usec - b.tv_usec;_     return &rslt;s   }f }f   /*  * add 2 timevals   *=  * Fixed the 'aggregate return' warning. Not thread-safe now.u  *	-gg 6/18/98  */g; struct timeval *timeadd(struct timeval a, struct timeval b)a {[   static struct timeval rslt;u  $   rslt.tv_sec = a.tv_sec + b.tv_sec;'   rslt.tv_usec = a.tv_usec + b.tv_usec;i  #   while (rslt.tv_usec >= 1000000) {V     rslt.tv_usec -= 1000000;     rslt.tv_sec++;   }e     return &rslt;i }a     void record_usage(void)  { 1   int sockets_connected = 0, sockets_playing = 0;e   struct descriptor_data *d;  -   for (d = descriptor_list; d; d = d->next) {e     sockets_connected++;      if (STATE(d) == CON_PLAYING)       sockets_playing++;   }   =   log("nusage: %-3d sockets connected, %-3d sockets playing",)' 	  sockets_connected, sockets_playing);o  
 #ifdef RUSAGEo   {r     struct rusage ru;.        getrusage(RUSAGE_SELF, &ru);N     log("rusage: user time: %ld sec, system time: %ld sec, max res size: %ld",; 	    ru.ru_utime.tv_sec, ru.ru_stime.tv_sec, ru.ru_maxrss);    }, #endif   }u       /*/  * Turn off echoing (specific to telnet client)D  */s( void echo_off(struct descriptor_data *d) {V   char off_string[] =O   {      (char) IAC,S     (char) WILL,     (char) TELOPT_ECHO, 
     (char) 0,S   };     SEND_TO_Q(off_string, d);  }x     /*.  * Turn on echoing (specific to telnet client)  */r' void echo_on(struct descriptor_data *d)k {    char on_string[] =   {p     (char) IAC,,     (char) WONT,     (char) TELOPT_ECHO,E     (char) TELOPT_NAOFFD,L     (char) TELOPT_NAOCRD,S
     (char) 0,i   };     SEND_TO_Q(on_string, d); }d    , char *make_prompt(struct descriptor_data *d) {    static char prompt[256];  H   /* Note, prompt is truncated at MAX_PROMPT_LENGTH chars (structs.h )*/     if (d->showstr_count)e     sprintf(prompt, S 	    "\r[ Return to continue, (q)uit, (r)efresh, (b)ack, or page number (%d/%d) ]",a( 	    d->showstr_page, d->showstr_count);   else if (d->str)     strcpy(prompt, "] ");_>   else if (STATE(d) == CON_PLAYING && !IS_NPC(d->character)) {     *prompt = '\0';;  $     if (GET_INVIS_LEV(d->character));       sprintf(prompt, "i%d ", GET_INVIS_LEV(d->character));n  .     if (PRF_FLAGGED(d->character, PRF_DISPHP))F       sprintf(prompt + strlen(prompt), "%dH ", GET_HIT(d->character));  0     if (PRF_FLAGGED(d->character, PRF_DISPMANA))G       sprintf(prompt + strlen(prompt), "%dM ", GET_MANA(d->character));W  0     if (PRF_FLAGGED(d->character, PRF_DISPMOVE))G       sprintf(prompt + strlen(prompt), "%dV ", GET_MOVE(d->character));c       strcat(prompt, "> ");)=   } else if (STATE(d) == CON_PLAYING && IS_NPC(d->character)) 4     sprintf(prompt, "%s> ", GET_NAME(d->character));   else     *prompt = '\0';e     return prompt; }f    B void write_to_q(const char *txt, struct txt_q *queue, int aliased) {(   struct txt_block *newt;0  $   CREATE(newt, struct txt_block, 1);,   CREATE(newt->text, char, strlen(txt) + 1);   strcpy(newt->text, txt);   newt->aliased = aliased;     /* queue empty? */   if (!queue->head) {      newt->next = NULL;%     queue->head = queue->tail = newt;)
   } else {     queue->tail->next = newt;,     queue->tail = newt;      newt->next = NULL;   }  }S      = int get_from_q(struct txt_q *queue, char *dest, int *aliased)  {u   struct txt_block *tmp;     /* queue empty? */   if (!queue->head) 
     return 0;E     tmp = queue->head;"   strcpy(dest, queue->head->text);"   *aliased = queue->head->aliased;"   queue->head = queue->head->next;     free(tmp->text);   free(tmp);     return 1;d }       0 /* Empty the queues before closing connection */, void flush_queues(struct descriptor_data *d) {c   int dummy;     if (d->large_outbuf) {$     d->large_outbuf->next = bufpool;     bufpool = d->large_outbuf;   }i.   while (get_from_q(&d->input, buf2, &dummy)); }e  1 /* Add a new string to a player's output queue */_@ void write_to_output(const char *txt, struct descriptor_data *t) {"   int size;n     size = strlen(txt);t  F   /* if we're in the overflow state already, ignore this new output */   if (t->bufptr < 0)     return;   D   /* if we have enough space, just write to buffer and that's it! */   if (t->bufspace >= size) {'     strcpy(t->output + t->bufptr, txt);R     t->bufspace -= size;     t->bufptr += size;     return;    }e   /*F    * If the text is too big to fit into even a large buffer, chuck the/    * new text and switch to the overflow state.e    */P-   if (size + t->bufptr > LARGE_BUFSIZE - 1) {h     t->bufptr = -1;      buf_overflows++;     return;    }    buf_switches++;h  /   /* if the pool has a buffer in it, grab it */t   if (bufpool != NULL) {     t->large_outbuf = bufpool;     bufpool = bufpool->next;(   } else {			/* else create a new one */1     CREATE(t->large_outbuf, struct txt_block, 1);s7     CREATE(t->large_outbuf->text, char, LARGE_BUFSIZE);      buf_largecount++;L   }   D   strcpy(t->large_outbuf->text, t->output);	/* copy to big buffer */B   t->output = t->large_outbuf->text;	/* make big buffer primary */0   strcat(t->output, txt);	/* now add new text */  *   /* set the pointer for the next write */    t->bufptr = strlen(t->output);  6   /* calculate how much space is left in the buffer */.   t->bufspace = LARGE_BUFSIZE - 1 - t->bufptr; }E      E /* ******************************************************************yE *  socket handling                                                  *1E ****************************************************************** */o     /*D  * get_bind_addr: Return a struct in_addr that should be used in our?  * call to bind().  If the user has specified a desired bindingcC  * address, we try to bind to it; otherwise, we bind to INADDR_ANY.nF  * Note that inet_aton() is preferred over inet_addr() so we use it ifB  * we can.  If neither is available, we always bind to INADDR_ANY.  */*   struct in_addr *get_bind_addr()  {d"   static struct in_addr bind_addr;     /* Clear the structure */x4   memset((char *) &bind_addr, 0, sizeof(bind_addr));  1   /* If DLFT_IP is unspecified, use INADDR_ANY */c   if (DFLT_IP == NULL) {)     bind_addr.s_addr = htonl(INADDR_ANY); 
   } else {.     /* If the parsing fails, use INADDR_ANY */)     if (!parse_ip(DFLT_IP, &bind_addr)) {iO       log("SYSERR: DFLT_IP of %s appears to be an invalid IP address",DFLT_IP);m+       bind_addr.s_addr = htonl(INADDR_ANY);p     }t   }c  C   /* Put the address that we've finally decided on into the logs */m,   if (bind_addr.s_addr == htonl(INADDR_ANY))6     log("Binding to all IP interfaces on this host.");   else?     log("Binding only to IP address %s", inet_ntoa(bind_addr));e     return &bind_addr; }    #ifdef HAVE_INET_ATONs   /*J  * inet_aton's interface is the same as parse_ip's: 0 on failure, non-0 if
  * successfulD  */m6 int parse_ip(const char *addr, struct in_addr *inaddr) { !   return inet_aton(addr, inaddr);) }    #elif HAVE_INET_ADDR  D /* inet_addr has a different interface, so we emulate inet_aton's */6 int parse_ip(const char *addr, struct in_addr *inaddr) {n
   long ip;  %   if ((ip = inet_addr(addr)) == -1) {z
     return 0; 
   } else {(     inaddr->s_addr = (unsigned long) ip;
     return 1;    }  }D   #elsep  J /* If you have neither function - sorry, you can't do specific binding. */6 int parse_ip(const char *addr, struct in_addr *inaddr) { N   log("SYSERR: warning: you're trying to set DFLT_IP but your system has no\n"8       "functions to parse IP addresses (how bizarre!)");   return 0;d }e  $ #endif /* INET_ATON and INET_ADDR */      ; /* Sets the kernel's send buffer size for the descriptor */  int set_sendbuf(socket_t s)h {p4 #if defined(SO_SNDBUF) && !defined(CIRCLE_MACINTOSH)   int opt = MAX_SOCK_BUF;e  M   if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *) &opt, sizeof(opt)) < 0) {0(     perror("SYSERR: setsockopt SNDBUF");     return -1;   }n   #if 0 M   if (setsockopt(s, SOL_SOCKET, SO_RCVBUF, (char *) &opt, sizeof(opt)) < 0) {e(     perror("SYSERR: setsockopt RCVBUF");     return -1;   }e #endif   #endif     return 0;i };   int new_descriptor(int s) {s   socket_t desc;   int sockets_connected = 0;   unsigned int i;u8   static int last_desc = 0;	/* last descriptor number */   struct descriptor_data *newd;_   struct sockaddr_in peer;   struct hostent *from;   !   /* accept the new connection */    i = sizeof(peer);cL   if ((desc = accept(s, (struct sockaddr *) &peer, &i)) == INVALID_SOCKET) {     perror("accept");r     return -1;   };   /* keep it from blocking */p   nonblock(desc);       /* set the send buffer size */   if (set_sendbuf(desc) < 0) {     CLOSE_SOCKET(desc);a
     return 0;,   }e  %   /* make sure we have room for it */N7   for (newd = descriptor_list; newd; newd = newd->next)o     sockets_connected++;  )   if (sockets_connected >= max_players) {nc     write_to_descriptor(desc, "Sorry, CircleMUD is full right now... please try again later!\r\n");      CLOSE_SOCKET(desc); 
     return 0;    }f   /* create a new descriptor */C*   CREATE(newd, struct descriptor_data, 1);;   memset((char *) newd, 0, sizeof(struct descriptor_data));f     /* find the sitename */_K   if (nameserver_is_slow || !(from = gethostbyaddr((char *) &peer.sin_addr,(- 				      sizeof(peer.sin_addr), AF_INET))) {        /* resolution failed */*     if (!nameserver_is_slow)       perror("gethostbyaddr");  '     /* find the numeric site address */h/ #   if defined(CIRCLE_VMS) && defined(__GNUC__)*I       strncpy(newd->host, (char *)inet_ntoa(peer.sin_addr), HOST_LENGTH);( #   elseA       strncpy(newd->host, inet_ntoa(peer.sin_addr), HOST_LENGTH); 	 #   endif"'     *(newd->host + HOST_LENGTH) = '\0'; 
   } else {3     strncpy(newd->host, from->h_name, HOST_LENGTH);f'     *(newd->host + HOST_LENGTH) = '\0';    }_  '   /* determine if the site is banned */ (   if (isbanned(newd->host) == BAN_ALL) {     CLOSE_SOCKET(desc); E     sprintf(buf2, "Connection attempt denied from [%s]", newd->host); %     mudlog(buf2, CMP, LVL_GOD, TRUE);t     free(newd);d
     return 0;u   }) #if 0_G   /* Log new connections - probably unnecessary, but you may want it */ 8   sprintf(buf2, "New connection from [%s]", newd->host);$   mudlog(buf2, CMP, LVL_GOD, FALSE); #endif  "   /* initialize descriptor data */   newd->descriptor = desc;!   newd->connected = CON_GET_NAME;o   newd->idle_tics = 0;   newd->wait = 1;m$   newd->output = newd->small_outbuf;%   newd->bufspace = SMALL_BUFSIZE - 1;=   newd->login_time = time(0);e   *newd->output = '\0';i   newd->bufptr = 0;a:   newd->has_prompt = 1;  /* prompt is part of greetings */     /*F    * This isn't exactly optimal but allows us to make a design choice.F    * Do we embed the history in descriptor_data or keep it dynamically5    * allocated and allow a user defined history size?n    */y.   CREATE(newd->history, char *, HISTORY_SIZE);     if (++last_desc == 1000)     last_desc = 1;   newd->desc_num = last_desc;>     /* prepend to list */R   newd->next = descriptor_list;t   descriptor_list = newd;a     SEND_TO_Q(GREETINGS, newd);;     return 0;( }c     /*D  * Send all of the output that we've accumulated for a player out to  * the player's descriptor.-@  * FIXME - This will be rewritten before 3.1, this code is dumb.  */R- int process_output(struct descriptor_data *t)o {;   char i[MAX_SOCK_BUF];	
   int result;d  4   /* we may need this \r\n for later -- see below */   strcpy(i, "\r\n");  %   /* now, append the 'real' output */;   strcpy(i + 2, t->output);r  7   /* if we're in the overflow state, notify the user */i   if (t->bufptr < 0)"     strcat(i, "**OVERFLOW**\r\n");  >   /* add the extra CRLF if the person isn't in compact mode */r   if (STATE(t) == CON_PLAYING && t->character && !IS_NPC(t->character) && !PRF_FLAGGED(t->character, PRF_COMPACT))     strcat(i + 2, "\r\n");     /* add a prompt */4   strncat(i + 2, make_prompt(t), MAX_PROMPT_LENGTH);     /*K    * now, send the output.  If this is an 'interruption', use the prependede8    * CRLF, otherwise send the straight output sans CRLF.    */h-   if (t->has_prompt)		/* && !t->connected) */ 3     result = write_to_descriptor(t->descriptor, i);m   else7     result = write_to_descriptor(t->descriptor, i + 2);e  9   /* handle snooping: prepend "% " and send to snooper */e   if (t->snoop_by) {!     SEND_TO_Q("% ", t->snoop_by);	&     SEND_TO_Q(t->output, t->snoop_by);!     SEND_TO_Q("%%", t->snoop_by);-   }u   /*M    * if we were using a large buffer, put the large buffer on the buffer pool %    * and switch back to the small onel    */    if (t->large_outbuf) {$     t->large_outbuf->next = bufpool;     bufpool = t->large_outbuf;     t->large_outbuf = NULL;t      t->output = t->small_outbuf;   }n;   /* reset total bufspace back to that of a small buffer */e"   t->bufspace = SMALL_BUFSIZE - 1;   t->bufptr = 0;   *(t->output) = '\0';     return result; }r     /*E  * perform_socket_write: takes a descriptor, a pointer to text, and aID  * text length, and tries once to send that text to the OS.  This isB  * where we stuff all the platform-dependent stuff that used to be*  * ugly #ifdef's in write_to_descriptor().  *  * This function must return:e  *E  * -1  If a fatal error was encountered in writing to the descriptor.sH  *  0  If a transient failure was encountered (e.g. socket buffer full).E  * >0  To indicate the number of bytes successfully written, possiblye=  *     fewer than the number the caller requested be written.E  *F  * Right now there are two versions of this function: one for Windows,#  * and one for all other platforms.a  */s   #if defined(CIRCLE_WINDOWS)   K ssize_t perform_socket_write(socket_t desc, const char *txt, size_t length): {s   ssize_t result;h  &   result = send(desc, txt, length, 0);     if (result > 0) {e     /* Write was sucessful */o     return result;   }e     if (result == 0) {#     /* This should never happen! */ E     log("SYSERR: Huh??  write() returned 0???  Please report this!");f     return -1;   }*  -   /* result < 0: An error was encountered. */R     /* Transient error? */*   if (WSAGetLastError() == WSAEWOULDBLOCK)
     return 0;d     /* Must be a fatal error. */   return -1; }    #elset   #if defined(CIRCLE_ACORN)  #define write	socketwriteS #endif  8 /* perform_socket_write for all Non-Windows platforms */K ssize_t perform_socket_write(socket_t desc, const char *txt, size_t length)* {    ssize_t result;w  $   result = write(desc, txt, length);     if (result > 0) {(     /* Write was successful. */N     return result;   }e     if (result == 0) {#     /* This should never happen! */)E     log("SYSERR: Huh??  write() returned 0???  Please report this!");i     return -1;   }l     /*?    * result < 0, so an error was encountered - is it transient?u@    * Unfortunately, different systems use different constants to    * indicate this.=    */    #ifdef EAGAIN		/* POSIX */   if (errno == EAGAIN)
     return 0;( #endif   #ifdef EWOULDBLOCK	/* BSD */   if (errno == EWOULDBLOCK)a
     return 0;  #endif   #ifdef EDEADLK		/* Macintosh */*   if (errno == EDEADLK)e
     return 0;i #endif  1   /* Looks like the error was fatal.  Too bad. */*   return -1; }*   #endif /* CIRCLE_WINDOWS */*        /*C  * write_to_descriptor takes a descriptor, and text to write to thenC  * descriptor.  It keeps calling the system-level write() until all >  * the text has been delivered to the OS, or until an error is  * encountered.m  *  * Returns:*  *  0  If all is well and good,cH  * -1  If an error was encountered, so that the player should be cut off  */ 7 int write_to_descriptor(socket_t desc, const char *txt)t {r   size_t total;g   ssize_t bytes_written;     total = strlen(txt);     while (total > 0) { ;     bytes_written = perform_socket_write(desc, txt, total);e       if (bytes_written < 0) {0       /* Fatal error.  Disconnect the player. */        perror("Write to socket");       return -1;$     } else if (bytes_written == 0) {       /*E        * Temporary failure -- socket buffer full.  For now we'll justtB        * cut off the player, but eventually we'll stuff the unsentF        * text into a buffer and retry the write later.  JE 30 June 98.	        */ F       log("process_output: socket write would block, about to close");       return -1;     } else {       txt += bytes_written;        total -= bytes_written;e     }a   }.     return 0;e }w     /*C  * Same information about perform_socket_write applies here. I likem4  * standards, there are so many of them. -gg 6/30/98  */eO ssize_t perform_socket_read(socket_t desc, char *read_point, size_t space_left)l {v   ssize_t ret;   #if defined(CIRCLE_ACORN)09   ret = recv(desc, read_point, space_left, MSG_DONTWAIT);  #elif defined(CIRCLE_WINDOWS) .   ret = recv(desc, read_point, space_left, 0); #elseu+   ret = read(desc, read_point, space_left);o #endif     /* Read was successful. */   if (ret > 0)     return ret;   1   /* read() returned 0, meaning we got an EOF. */(   if (ret == 0) {t:     log("EOF on socket read (connection broken by peer)");     return -1;   }      /*2    * read returned a value < 0: there was an error    */E  ) #if defined(CIRCLE_WINDOWS)	/* Windows */ *   if (WSAGetLastError() == WSAEWOULDBLOCK)
     return 0;u #else_  ? #ifdef EINTR		/* Interrupted system call - various platforms */    if (errno == EINTR) 
     return 0;l #endif   #ifdef EAGAIN		/* POSIX */   if (errno == EAGAIN)
     return 0;s #endif   #ifdef EWOULDBLOCK	/* BSD */   if (errno == EWOULDBLOCK)P
     return 0;c #endif /* EWOULDBLOCK */   #ifdef EDEADLK		/* Macintosh */*   if (errno == EDEADLK)c
     return 0;n #endif   #endif /* CIRCLE_WINDOWS */r  2   /* We don't know what happened, cut them off. */4   perror("process_input: about to lose connection");   return -1; }A   /*J  * ASSUMPTION: There will be no newlines in the raw input buffer when this?  * function is called.  We must maintain that before returning.   */c, int process_input(struct descriptor_data *t) {t   int buf_length, failed_subst;r   ssize_t bytes_read;s   size_t space_left;7   char *ptr, *read_point, *write_point, *nl_pos = NULL;e!   char tmp[MAX_INPUT_LENGTH + 8];d  <   /* first, find the point where we left off reading data */    buf_length = strlen(t->inbuf);%   read_point = t->inbuf + buf_length;I5   space_left = MAX_RAW_INPUT_LENGTH - buf_length - 1;(     do {     if (space_left <= 0) {F       log("process_input: about to close connection: input overflow");       return -1;     }P  L     bytes_read = perform_socket_read(t->descriptor, read_point, space_left);  5     if (bytes_read < 0)	/* Error, disconnect them. */p       return -1;?     else if (bytes_read == 0)	/* Just blocking, no problems. */G       return 0;   ?     /* at this point, we know we got some data from the read */M  A     *(read_point + bytes_read) = '\0';	/* terminate the string */E  7     /* search for a newline in the data we just read */r2     for (ptr = read_point; *ptr && !nl_pos; ptr++)       if (ISNEWL(*ptr))u 	nl_pos = ptr;       read_point += bytes_read;x     space_left -= bytes_read;a   /*I  * on some systems such as AIX, POSIX-standard nonblocking I/O is broken,RG  * causing the MUD to hang when it encounters input not terminated by aeI  * newline.  This was causing hangs at the Password: prompt, for example. N  * I attempt to compensate by always returning after the _first_ read, insteadK  * of looping forever until a read returns -1.  This simulates non-blocking L  * I/O because the result is we never call read unless we know from select()L  * that data is ready (process_input is only called if select indicates that4  * this descriptor is in the read set).  JE 2/23/95.  */e# #if !defined(POSIX_NONBLOCK_BROKEN)>   } while (nl_pos == NULL);u #else-   } while (0);     if (nl_pos == NULL);
     return 0;d" #endif /* POSIX_NONBLOCK_BROKEN */     /*K    * okay, at this point we have at least one newline in the string; now wemG    * can copy the formatted data to a new array for further processing.     */      read_point = t->inbuf;     while (nl_pos != NULL) {     write_point = tmp;&     space_left = MAX_INPUT_LENGTH - 1;  G     for (ptr = read_point; (space_left > 0) && (ptr < nl_pos); ptr++) { O       if (*ptr == '\b' || *ptr == 127) { /* handle backspacing or delete key */  	if (write_point > tmp) {t! 	  if (*(--write_point) == '$') {e 	    write_point--;h 	    space_left += 2;w	 	  } elsef 	    space_left++; 	}2       } else if (isascii(*ptr) && isprint(*ptr)) {B 	if ((*(write_point++) = *ptr) == '$') {		/* copy one character */7 	  *(write_point++) = '$';	/* if it's a $, double it */f 	  space_left -= 2;b 	} elseu 	  space_left--;       }w     }        *write_point = '\0';  .     if ((space_left <= 0) && (ptr < nl_pos)) {)       char buffer[MAX_INPUT_LENGTH + 64];   F       sprintf(buffer, "Line too long.  Truncated to:\r\n%s\r\n", tmp);9       if (write_to_descriptor(t->descriptor, buffer) < 0)t 	return -1;;     }u     if (t->snoop_by) {#       SEND_TO_Q("% ", t->snoop_by); "       SEND_TO_Q(tmp, t->snoop_by);%       SEND_TO_Q("\r\n", t->snoop_by);_     }>     failed_subst = 0;Z  >     if (*tmp == '!' && !(*(tmp + 1)))	/* Redo last command. */!       strcpy(tmp, t->last_input);e)     else if (*tmp == '!' && *(tmp + 1)) {/"       char *commandln = (tmp + 1);(       int starting_pos = t->history_pos,G 	  cnt = (t->history_pos == 0 ? HISTORY_SIZE - 1 : t->history_pos - 1);u         skip_spaces(&commandln);*       for (; cnt != starting_pos; cnt--) {@ 	if (t->history[cnt] && is_abbrev(commandln, t->history[cnt])) {  	  strcpy(tmp, t->history[cnt]); 	  strcpy(t->last_input, tmp);	 	  break;  	}3         if (cnt == 0)	/* At top, loop to bottom. */* 	  cnt = HISTORY_SIZE;       }*     } else if (*tmp == '^') {*A       if (!(failed_subst = perform_subst(t, t->last_input, tmp)))o 	strcpy(t->last_input, tmp);     } else {!       strcpy(t->last_input, tmp);s%       if (t->history[t->history_pos])i< 	free(t->history[t->history_pos]);	/* Clear the old line. */D       t->history[t->history_pos] = str_dup(tmp);	/* Save the new. */>       if (++t->history_pos >= HISTORY_SIZE)	/* Wrap to top. */ 	t->history_pos = 0;     }a       if (!failed_subst)$       write_to_q(tmp, &t->input, 0);  #     /* find the end of this line */      while (ISNEWL(*nl_pos))d       nl_pos++;*  <     /* see if there's another newline in the input buffer */     read_point = ptr = nl_pos;/     for (nl_pos = NULL; *ptr && !nl_pos; ptr++)r       if (ISNEWL(*ptr))) 	nl_pos = ptr;   }R  M   /* now move the rest of the buffer up to the beginning for the next pass */.   write_point = t->inbuf;p   while (*read_point)P'     *(write_point++) = *(read_point++);    *write_point = '\0';     return 1;_ }r      C /* perform substitution for the '^..^' csh-esque syntax orig is the"@  * orig string, i.e. the one being modified.  subst contains the'  * substition string, i.e. "^telm^tell"   */fE int perform_subst(struct descriptor_data *t, char *orig, char *subst)p { $   char newsub[MAX_INPUT_LENGTH + 5];      char *first, *second, *strpos;     /*H    * first is the position of the beginning of the first string (the one    * to be replacede    */h   first = subst + 1;     /* now find the second '^' */n'   if (!(second = strchr(first, '^'))) {d.     SEND_TO_Q("Invalid substitution.\r\n", t);
     return 1;1   } I   /* terminate "first" at the position of the '^' and make 'second' pointe-    * to the beginning of the second string */n   *(second++) = '\0';,  K   /* now, see if the contents of the first string appear in the original */d(   if (!(strpos = strstr(orig, first))) {.     SEND_TO_Q("Invalid substitution.\r\n", t);
     return 1;n   }s4   /* now, we construct the new string for output. */  J   /* first, everything in the original, up to the string to be replaced */)   strncpy(newsub, orig, (strpos - orig));_!   newsub[(strpos - orig)] = '\0';e  #   /* now, the replacement string */SC   strncat(newsub, second, (MAX_INPUT_LENGTH - strlen(newsub) - 1));S  F   /* now, if there's anything left in the original after the string to     * replaced, copy that too. */7   if (((strpos - orig) + strlen(first)) < strlen(orig))rU     strncat(newsub, strpos + strlen(first), (MAX_INPUT_LENGTH - strlen(newsub) - 1));;  @   /* terminate the string in case of an overflow from strncat */&   newsub[MAX_INPUT_LENGTH - 1] = '\0';   strcpy(subst, newsub);     return 0;t }c      , void close_socket(struct descriptor_data *d) {u   char buf[128];   struct descriptor_data *temp;e  -   REMOVE_FROM_LIST(d, descriptor_list, next);e   CLOSE_SOCKET(d->descriptor);   flush_queues(d);     /* Forget snooping */r   if (d->snooping)!     d->snooping->snoop_by = NULL;t     if (d->snoop_by) {E     SEND_TO_Q("Your victim is no longer among us.\r\n", d->snoop_by);s!     d->snoop_by->snooping = NULL;u   }c     /*. Kill any OLC stuff .*/   switch (d->connected) {      case CON_OEDIT:e     case CON_REDIT:o     case CON_ZEDIT:l     case CON_MEDIT:d     case CON_SEDIT:_"       cleanup_olc(d, CLEANUP_ALL);     default:       break;   }_     if (d->character) {y     /*)      * Plug memory leak, from Eric Green.a      */);     if (PLR_FLAGGED(d->character, PLR_MAILING) && d->str) {t       if (*(d->str))         free(*(d->str));       free(d->str);      }(@     if (STATE(d) == CON_PLAYING || STATE(d) == CON_DISCONNECT) {'       save_char(d->character, NOWHERE);|E       act("$n has lost $s link.", TRUE, d->character, 0, 0, TO_ROOM);eC       sprintf(buf, "Closing link to: %s.", GET_NAME(d->character));nK       mudlog(buf, NRM, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE);         d->character->desc = NULL;     } else {(       sprintf(buf, "Losing player: %s.",C 	      GET_NAME(d->character) ? GET_NAME(d->character) : "<null>"); )       mudlog(buf, CMP, LVL_IMMORT, TRUE);)       free_char(d->character);     }d   } elseE     mudlog("Losing descriptor without char.", CMP, LVL_IMMORT, TRUE);   E   /* JE 2/22/95 -- part of my unending quest to make switch stable */t'   if (d->original && d->original->desc)s     d->original->desc = NULL;{  "   /* Clear the command history. */   if (d->history) {t     int cnt;,     for (cnt = 0; cnt < HISTORY_SIZE; cnt++)       if (d->history[cnt]) 	free(d->history[cnt]);      free(d->history);n   }n     if (d->showstr_head)     free(d->showstr_head);   if (d->showstr_count)c     free(d->showstr_vector);  
   free(d); }f       void check_idle_passwords(void)* {i%   struct descriptor_data *d, *next_d;c  ,   for (d = descriptor_list; d; d = next_d) {     next_d = d->next; =     if (STATE(d) != CON_PASSWORD && STATE(d) != CON_GET_NAME)        continue;S     if (!d->idle_tics) {       d->idle_tics++;e       continue;      } else {       echo_on(d); 4       SEND_TO_Q("\r\nTimed out... goodbye.\r\n", d);       STATE(d) = CON_CLOSE;x     }p   }  }        /*F  * I tried to universally convert Circle over to POSIX compliance, butH  * alas, some systems are still straggling behind and don't have all theI  * appropriate defines.  In particular, NeXT 2.x defines O_NDELAY but notaG  * O_NONBLOCK.  Krusty old NeXT machines!  (Thanks to Michael Jones for &  * this and various other NeXT fixes.)  */p   #if defined(CIRCLE_WINDOWS)    void nonblock(socket_t s)G {n   long val;e  
   val = 1;    ioctlsocket(s, FIONBIO, &val); }t   #elif defined(CIRCLE_AMIGA)    void nonblock(socket_t s)i {r   long val;-  
   val = 1;    IoctlSocket(s, FIONBIO, &val); }m   #elif defined(CIRCLE_ACORN)r   void nonblock(socket_t s)  {h   int val = 1;  !   socket_ioctl(s, FIONBIO, &val);e }t  0 #elif (defined(CIRCLE_VMS) && defined(__GNUC__))   void nonblock(socket_t s)' {l   int val = 1;$   int ret = ioctl(s, FIONBIO, &val);   if (ret == -1)   {t>     perror("SYSERR: Fatal error executing nonblock (comm.c)");     exit(1);   }  }   N #elif defined(CIRCLE_UNIX) || defined(CIRCLE_OS2) || defined(CIRCLE_MACINTOSH)   #ifndef O_NONBLOCK #define O_NONBLOCK O_NDELAY& #endif   void nonblock(socket_t s)A {)   int flags;     flags = fcntl(s, F_GETFL, 0);    flags |= O_NONBLOCK;%   if (fcntl(s, F_SETFL, flags) < 0) {*>     perror("SYSERR: Fatal error executing nonblock (comm.c)");     exit(1);   }* }L  ; #endif  /* CIRCLE_UNIX || CIRCLE_OS2 || CIRCLE_MACINTOSH */(    E /* ******************************************************************tE *  signal-handling functions (formerly signals.c).  UNIX only.      *tE ****************************************************************** */*  5 #if defined(CIRCLE_UNIX) || defined(CIRCLE_MACINTOSH))  # RETSIGTYPE reread_wizlists(int sig)y { I   mudlog("Signal received - rereading wizlists.", CMP, LVL_IMMORT, TRUE);g   reboot_wizlists(); }u    # RETSIGTYPE unrestrict_game(int sig)  {kG   mudlog("Received SIGUSR2 - completely unrestricting game (emergent)",- 	 BRF, LVL_IMMORT, TRUE);o   ban_list = NULL;   circle_restrict = 0;   num_invalid = 0; }    #ifdef CIRCLE_UNIX  9 /* clean up our zombie kids to avoid defunct processes */e RETSIGTYPE reap(int sig) {Z)   while (waitpid(-1, NULL, WNOHANG) > 0);'     my_signal(SIGCHLD, reap);  }*  ! RETSIGTYPE checkpointing(int sig)s {p   if (!tics) {T     log("SYSERR: CHECKPOINT shutdown: tics not updated. (Infinite loop suspected)");     abort();   } else
     tics = 0;n }t   RETSIGTYPE hupsig(int sig) {iH   log("SYSERR: Received SIGHUP, SIGINT, or SIGTERM.  Shutting down...");5   exit(1);			/* perhaps something more elegant shouldh 				 * substituted */I }      /*K  * This is an implementation of signal() using sigaction() for portability.nJ  * (sigaction() is POSIX; signal() is not.)  Taken from Stevens' _AdvancedK  * Programming in the UNIX Environment_.  We are specifying that all systemfM  * calls _not_ be automatically restarted for uniformity, because BSD systems 7  * do not restart select(), even if SA_RESTART is used.i  *J  * Note that NeXT 2.x is not POSIX and does not have sigaction; therefore,F  * I just define it to be the old signal.  If your system doesn't have.  * sigaction either, you can use the same fix.  *H  * SunOS Release 4.0.2 (sun386) needs this too, according to Tim Aldric.  */?  
 #ifndef POSIXd2 #define my_signal(signo, func) signal(signo, func) #else*- sigfunc *my_signal(int signo, sigfunc * func)  {T   struct sigaction act, oact;t     act.sa_handler = func;   sigemptyset(&act.sa_mask);   act.sa_flags = 0;/ #ifdef SA_INTERRUPT +   act.sa_flags |= SA_INTERRUPT;	/* SunOS */  #endif  (   if (sigaction(signo, &act, &oact) < 0)     return SIG_ERR;      return oact.sa_handler;_ }k #endif				/* POSIX */      void signal_setup(void)h {  #ifndef CIRCLE_MACINTOSH   struct itimerval itime;    struct timeval interval;  @   /* user signal 1: reread wizlists.  Used by autowiz system. */&   my_signal(SIGUSR1, reread_wizlists);     /*F    * user signal 2: unrestrict game.  Used for emergencies if you lock/    * yourself out of the MUD somehow.  (Duh...)s    */,&   my_signal(SIGUSR2, unrestrict_game);     /*L    * set up the deadlock-protection so that the MUD aborts itself if it gets8    * caught in an infinite loop for more than 3 minutes.    */E   interval.tv_sec = 180;   interval.tv_usec = 0;K   itime.it_interval = interval;B   itime.it_value = interval;*   setitimer(ITIMER_VIRTUAL, &itime, NULL);&   my_signal(SIGVTALRM, checkpointing);  $   /* just to be on the safe side: */   my_signal(SIGHUP, hupsig);   my_signal(SIGCHLD, reap);O #endif /* CIRCLE_MACINTOSH */_   my_signal(SIGINT, hupsig);   my_signal(SIGTERM, hupsig);d   my_signal(SIGPIPE, SIG_IGN);   my_signal(SIGALRM, SIG_IGN); }*   #endif	/* CIRCLE_UNIX */, #endif	/* CIRCLE_UNIX || CIRCLE_MACINTOSH */  C /* ****************************************************************eC *       Public routines for system-to-player-communication        * C **************************************************************** */t  : void send_to_char(const char *messg, struct char_data *ch) {l   if (ch->desc && messg)     SEND_TO_Q(messg, ch->desc);d },    # void send_to_all(const char *messg)  {{   struct descriptor_data *i;     if (messg == NULL)     return;r  +   for (i = descriptor_list; i; i = i->next)i      if (STATE(i) == CON_PLAYING)       SEND_TO_Q(messg, i); }     ' void send_to_outdoor(const char *messg)  {*   struct descriptor_data *i;     if (!messg || !*messg)     return;x  -   for (i = descriptor_list; i; i = i->next) { 8     if (STATE(i) != CON_PLAYING || i->character == NULL)       continue;a7     if (!AWAKE(i->character) || !OUTSIDE(i->character))x       continue;n     SEND_TO_Q(messg, i);   }n }       . void send_to_room(const char *messg, int room) {t   struct char_data *i;     if (messg == NULL)     return;d  6   for (i = world[room].people; i; i = i->next_in_room)     if (i->desc)        SEND_TO_Q(messg, i->desc); }s       const char *ACTNULL = "<NULL>";   ) #define CHECK_NULL(pointer, expression) \s<   if ((pointer) == NULL) i = ACTNULL; else i = (expression);    4 /* higher-level communication: the act() function */N void perform_act(const char *orig, struct char_data *ch, struct obj_data *obj,- 		const void *vict_obj, struct char_data *to)t {    const char *i = NULL; %   char lbuf[MAX_STRING_LENGTH], *buf;=  
   buf = lbuf;E     for (;;) {     if (*orig == '$') {e       switch (*(++orig)) {       case 'n':a 	i = PERS(ch, to); 	break;        case 'N':*? 	CHECK_NULL(vict_obj, PERS((struct char_data *) vict_obj, to));t 	break;=       case 'm':  	i = HMHR(ch); 	break;        case 'M':I; 	CHECK_NULL(vict_obj, HMHR((struct char_data *) vict_obj));= 	break;        case 's':e 	i = HSHR(ch); 	break;        case 'S':r; 	CHECK_NULL(vict_obj, HSHR((struct char_data *) vict_obj));/ 	break;        case 'e':O 	i = HSSH(ch); 	break;c       case 'E':D; 	CHECK_NULL(vict_obj, HSSH((struct char_data *) vict_obj));E 	break;        case 'o':e  	CHECK_NULL(obj, OBJN(obj, to)); 	break;*       case 'O':a> 	CHECK_NULL(vict_obj, OBJN((struct obj_data *) vict_obj, to)); 	break;e       case 'p':n  	CHECK_NULL(obj, OBJS(obj, to)); 	break;e       case 'P':h> 	CHECK_NULL(vict_obj, OBJS((struct obj_data *) vict_obj, to)); 	break;a       case 'a':g 	CHECK_NULL(obj, SANA(obj)); 	break;r       case 'A':t: 	CHECK_NULL(vict_obj, SANA((struct obj_data *) vict_obj)); 	break;s       case 'T':r) 	CHECK_NULL(vict_obj, (char *) vict_obj);  	break;        case 'F':T0 	CHECK_NULL(vict_obj, fname((char *) vict_obj)); 	break;o       case '$':/	 	i = "$";g 	break;e       default:3 	log("SYSERR: Illegal $-code to act(): %c", *orig);M 	log("SYSERR: %s", orig);e 	break;(       }{       while ((*buf = *(i++)))  	buf++;p
       orig++;b'     } else if (!(*(buf++) = *(orig++)));       break;   }      *(--buf) = '\r';   *(++buf) = '\n';   *(++buf) = '\0';  !   SEND_TO_Q(CAP(lbuf), to->desc);y }_    A #define SENDOK(ch)	((ch)->desc && (to_sleeping || AWAKE(ch)) && \ # 			!PLR_FLAGGED((ch), PLR_WRITING))o  C void act(const char *str, int hide_invisible, struct char_data *ch,t7 	 struct obj_data *obj, const void *vict_obj, int type)r {)   struct char_data *to = NULL;   int to_sleeping;     if (!str || !*str)     return;e     /*4    * Warning: the following TO_SLEEP code is a hack.    * (M    * I wanted to be able to tell act to deliver a message regardless of sleeptJ    * without adding an additional argument.  TO_SLEEP is 128 (a single bitG    * high up).  It's ONLY legal to combine TO_SLEEP with one other TO_xuJ    * command.  It's not legal to combine TO_x's with each other otherwise.H    * TO_SLEEP only works because its value "happens to be" a single bit;A    * do not change it to something else.  In short, it is a hack.t    */.  ;   /* check if TO_SLEEP is there, and remove it if it is. */ (   if ((to_sleeping = (type & TO_SLEEP)))     type &= ~TO_SLEEP;     if (type == TO_CHAR) {     if (ch && SENDOK(ch))t.       perform_act(str, ch, obj, vict_obj, ch);     return;    }d     if (type == TO_VICT) {;     if ((to = (struct char_data *) vict_obj) && SENDOK(to)) .       perform_act(str, ch, obj, vict_obj, to);     return;K   }EL   /* ASSUMPTION: at this point we know type must be TO_NOTVICT or TO_ROOM */  #   if (ch && ch->in_room != NOWHERE)e#     to = world[ch->in_room].people;c*   else if (obj && obj->in_room != NOWHERE)$     to = world[obj->in_room].people;   else {-     log("SYSERR: no valid target to act()!");      return;r   }a  %   for (; to; to = to->next_in_room) {s"     if (!SENDOK(to) || (to == ch))       continue;{1     if (hide_invisible && ch && !CAN_SEE(to, ch))e       continue; *     if (type != TO_ROOM && to == vict_obj)       continue; ,     perform_act(str, ch, obj, vict_obj, to);   }  }    /*H  * This function is called every 30 seconds from heartbeat().  It checksI  * the four global buffers in CircleMUD to ensure that no one has written'H  * past their bounds.  If our check digit is not there (and the positionH  * doesn't have a NUL which may result from snprintf) then we gripe thatI  * someone has overwritten our buffer.  This could cause a false positiveiJ  * if someone uses the buffer as a non-terminated character array but that  * is not likely. -ggr  */,& #define offset	(MAX_STRING_LENGTH - 1) void sanity_check(void)  {E   int ok = TRUE;     /*7    * If any line is false, 'ok' will become false also.\    */-=   ok &= (buf[offset] == MAGIC_NUMBER || buf[offset] == '\0'); ?   ok &= (buf1[offset] == MAGIC_NUMBER || buf1[offset] == '\0'); ?   ok &= (buf2[offset] == MAGIC_NUMBER || buf2[offset] == '\0'); =   ok &= (arg[offset] == MAGIC_NUMBER || arg[offset] == '\0');t     /*M    * This isn't exactly the safest thing to do (referencing known bad memory) M    * but we're doomed to crash eventually, might as well try to get somethingt"    * useful before we go down. -gg    */i
   if (!ok),     log("SYSERR: *** Buffer overflow! ***\n"? 	"buf: %s\nbuf1: %s\nbuf2: %s\narg: %s", buf, buf1, buf2, arg);A #if 0l2   log("Statistics: buf=%d buf1=%d buf2=%d arg=%d",7 	strlen(buf), strlen(buf1), strlen(buf2), strlen(arg));t #endif }s