#
# DESCRIP.MMS
# Written By:  Robert Alan Byer
#              Vice-President
#              A-Com Computing, Inc.
#              ByerRA@aol.com
#              byer@mail.all-net.net
#
# This is a MMS/MMK "makefile" for CircleMUD v3.0 beta patchlevel 14 for
# OpenVMS using the GNU C v2.7.1 compiler with the SOCKETSHR library with
# NetLib support.
#
# This makefile accepts the following macros.
#
#     DEBUG	To compile and link with debug information.
#
#
# Define The C Compiler.
#
CC = GCC
#
# Check To See If We Are To Compile With Debug Information.
#
.IFDEF DEBUG
CC_FLAGS = /NOOPTIMIZE/DEBUG/NOCASE_HACK
LINK_FLAGS = /DEBUG/TRACEBACK
.ELSE
CC_FLAGS = /OPTIMIZE=3/NODEBUG/NOCASE_HACK
LINK_FLAGS = /NODEBUG/NOTRACEBACK
.ENDIF

CIRCLE_OBJS = comm.obj,act_comm.obj,act_informative.obj,act_movement.obj,\
act_item.obj,act_offensive.obj,act_other.obj,act_social.obj,act_wizard.obj,\
ban.obj,boards.obj,castle.obj,class.obj,config.obj,constants.obj,db.obj,\
fight.obj,graph.obj,handler.obj,house.obj,interpreter.obj,limits.obj,\
magic.obj,mail.obj,mobact.obj,modify.obj,objsave.obj,olc.obj,shop.obj,\
spec_assign.obj,spec_procs.obj,spell_parser.obj,spells.obj,utils.obj,\
weather.obj,random.obj,redit.obj,oedit.obj,zedit.obj,medit.obj,sedit.obj

circle : $(CIRCLE_OBJS)
         LINK$(LINK_FLAGS)/EXE=[-.BIN]CIRCLE.EXE $(CIRCLE_OBJS), -
             SYS$DISK:[]VMS_CIRCLEMUD_GCC.OPT/OPT
#
# Dependencies for the object files.
#
act_comm.obj : act_comm.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	       interpreter.h,handler.h db.h screen.h
	       $(CC)$(CC_FLAGS) act_comm.c

act_informative.obj : act_informative.c,conf.h,sysdep.h,structs.h,utils.h,\
		      comm.h,interpreter.h handler.h db.h spells.h,\
		      screen.h,constants.h
		      $(CC)$(CC_FLAGS) act_informative.c

act_item.obj : act_item.c,conf.h,sysdep.h,structs.h,utils.h,\
	       comm.h,interpreter.h,handler.h,db.h,spells.h
	       $(CC)$(CC_FLAGS) act_item.c

act_movement.obj : act_movement.c,conf.h,sysdep.h,structs.h,utils.h,\
		   comm.h,interpreter.h,handler.h,db.h,spells.h,\
		   house.h,constants.h
		   $(CC)$(CC_FLAGS) act_movement.c

act_offensive.obj : act_offensive.c,conf.h,sysdep.h,structs.h,utils.h,\
		    comm.h,interpreter.h,handler.h,db.h,spells.h
		    $(CC)$(CC_FLAGS) act_offensive.c

act_other.obj : act_other.c,conf.h,sysdep.h,structs.h,utils.h,\
		comm.h,interpreter.h,handler.h,db.h,spells.h,\
		screen.h,house.h
		$(CC)$(CC_FLAGS) act_other.c

act_social.obj : act_social.c,conf.h,sysdep.h,structs.h,utils.h,\
		 comm.h,interpreter.h,handler.h,db.h,spells.h
		 $(CC)$(CC_FLAGS) act_social.c

act_wizard.obj : act_wizard.c,conf.h,sysdep.h,structs.h,utils.h,\
		 comm.h,interpreter.h,handler.h,db.h,spells.h,\
		 house.h,screen.h,constants.h
		 $(CC)$(CC_FLAGS) act_wizard.c

ban.obj : ban.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	  interpreter.h,handler.h,db.h
	  $(CC)$(CC_FLAGS) ban.c

boards.obj : boards.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	     db.h,boards.h,interpreter.h,handler.h
	     $(CC)$(CC_FLAGS) boards.c

castle.obj : castle.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	     interpreter.h,handler.h,db.h,spells.h
	     $(CC)$(CC_FLAGS) castle.c

class.obj : class.c,conf.h,sysdep.h,structs.h,db.h,utils.h,\
	    spells.h,interpreter.h
	    $(CC)$(CC_FLAGS) class.c

comm.obj : comm.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	   interpreter.h,handler.h,db.h,house.h
	   $(CC)$(CC_FLAGS) comm.c

config.obj : config.c,conf.h,sysdep.h,structs.h
	     $(CC)$(CC_FLAGS) config.c

constants.obj :	constants.c,conf.h,sysdep.h,structs.h
		$(CC)$(CC_FLAGS) constants.c

db.obj : db.c,conf.h,sysdep.h,structs.h,utils.h,db.h,\
	 comm.h,handler.h,spells.h,mail.h,interpreter.h,\
	 house.h
	 $(CC)$(CC_FLAGS) db.c

fight.obj : fight.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	    handler.h,interpreter.h,db.h,spells.h,screen.h
	    $(CC)$(CC_FLAGS) fight.c

graph.obj : graph.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	    interpreter.h,handler.h,db.h,spells.h
	    $(CC)$(CC_FLAGS) graph.c

handler.obj : handler.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	      db.h,handler.h,interpreter.h,spells.h
	      $(CC)$(CC_FLAGS) handler.c

house.obj : house.c,conf.h,sysdep.h,structs.h,comm.h,handler.h,\
	    db.h,interpreter.h,utils.h,house.h,constants.h
	    $(CC)$(CC_FLAGS) house.c

interpreter.obj : interpreter.c,conf.h,sysdep.h,structs.h,comm.h,\
		  interpreter.h,db.h,utils.h,spells.h,handler.h,mail.h,\
		  screen.h
		  $(CC)$(CC_FLAGS) interpreter.c

limits.obj : limits.c,conf.h,sysdep.h,structs.h,utils.h,spells.h,\
	     comm.h,db.h,handler.h
	     $(CC)$(CC_FLAGS) limits.c

magic.obj : magic.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	    spells.h,handler.h,db.h
	    $(CC)$(CC_FLAGS) magic.c

mail.obj : mail.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	   db.h,interpreter.h,handler.h,mail.h
	   $(CC)$(CC_FLAGS) mail.c

mobact.obj : mobact.c,conf.h,sysdep.h,structs.h,utils.h,db.h,\
	     comm.h,interpreter.h,handler.h spells.h
	     $(CC)$(CC_FLAGS) mobact.c

modify.obj : modify.c,conf.h,sysdep.h,structs.h,utils.h,\
	     interpreter.h,handler.h,db.h,comm.h,spells.h,\
	     mail.h,boards.h
	     $(CC)$(CC_FLAGS) modify.c

objsave.obj : objsave.c,conf.h,sysdep.h,structs.h,comm.h,\
	      handler.h,db.h,interpreter.h,utils.h,spells.h
	      $(CC)$(CC_FLAGS) objsave.c

olc.obj : olc.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	  interpreter.h,handler.h,db.h,olc.h
	  $(CC)$(CC_FLAGS) olc.c

random.obj : random.c
	     $(CC)$(CC_FLAGS) random.c

shop.obj : shop.c,conf.h,sysdep.h,structs.h,comm.h,handler.h,\
	   db.h,interpreter.h,utils.h,shop.h
	   $(CC)$(CC_FLAGS) shop.c

spec_assign.obj : spec_assign.c,conf.h,sysdep.h,structs.h,db.h,\
		  interpreter.h,utils.h
		  $(CC)$(CC_FLAGS) spec_assign.c

spec_procs.obj : spec_procs.c,conf.h,sysdep.h,structs.h,utils.h,\
		 comm.h,interpreter.h,handler.h,db.h,spells.h
		 $(CC)$(CC_FLAGS) spec_procs.c

spell_parser.obj : spell_parser.c,conf.h,sysdep.h,structs.h,utils.h,\
		   interpreter.h,spells.h,handler.h,comm.h,db.h
		   $(CC)$(CC_FLAGS) spell_parser.c

spells.obj : spells.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	     spells.h,handler.h,db.h,constants.h
	     $(CC)$(CC_FLAGS) spells.c

utils.obj : utils.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
	    screen.h,spells.h,handler.h
	    $(CC)$(CC_FLAGS) utils.c

weather.obj : weather.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,\
              interpreter.h,db.h
              $(CC)$(CC_FLAGS) weather.c

redit.obj : redit.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,boards.h,\
            db.h,olc.h
            $(CC)$(CC_FLAGS) redit.c

oedit.obj : oedit.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,boards.h,\
            spells.h,db.h,olc.h,shop.h
            $(CC)$(CC_FLAGS) oedit.c

zedit.obj : zedit.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,db.h,olc.h
            $(CC)$(CC_FLAGS) zedit.c

medit.obj : medit.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,spells.h,\
            spells.h,db.h,olc.h,handler.h
            $(CC)$(CC_FLAGS) medit.c

sedit.obj : sedit.c,conf.h,sysdep.h,structs.h,utils.h,comm.h,db.h,olc.h,\
            shop.h
	    $(CC)$(CC_FLAGS) sedit.c
