K /* ************************************************************************ K *   File: interpreter.c                                 Part of CircleMUD * K *  Usage: parse user commands, search for specials, call ACMD functions   * K *                                                                         * K *  All rights reserved.  See license.doc for complete information.        * K *                                                                         * K *  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University * K *  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               * K ************************************************************************ */    #define __INTERPRETER_C__    #include "conf.h"  #include "sysdep.h"    #include "structs.h" #include "comm.h"  #include "interpreter.h" #include "db.h"  #include "utils.h" #include "spells.h"  #include "handler.h" #include "mail.h"  #include "screen.h"  #include "olc.h"    " extern sh_int r_mortal_start_room;" extern sh_int r_immort_start_room;" extern sh_int r_frozen_start_room; extern const char *class_menu; extern char *motd; extern char *imotd;  extern char *background; extern char *MENU; extern char *WELC_MESSG; extern char *START_MESSG; ( extern struct char_data *character_list;/ extern struct descriptor_data *descriptor_list; 1 extern struct player_index_element *player_table;  extern int top_of_p_table; extern int circle_restrict;  extern int no_specials;  extern int max_bad_pws; $ extern struct index_data *mob_index;$ extern struct index_data *obj_index; extern struct room_data *world;    /* external functions */( void echo_on(struct descriptor_data *d);) void echo_off(struct descriptor_data *d); $ void do_start(struct char_data *ch); int parse_class(char arg);6 int special(struct char_data *ch, int cmd, char *arg); int isbanned(char *hostname);  int Valid_Name(char *newname);7 void oedit_parse(struct descriptor_data *d, char *arg); 7 void redit_parse(struct descriptor_data *d, char *arg); 7 void zedit_parse(struct descriptor_data *d, char *arg); 7 void medit_parse(struct descriptor_data *d, char *arg); 7 void sedit_parse(struct descriptor_data *d, char *arg);    /* local functions */ 2 int perform_dupe_check(struct descriptor_data *d);> struct alias *find_alias(struct alias *alias_list, char *str);! void free_alias(struct alias *a); O void perform_complex_alias(struct txt_q *input_q, char *orig, struct alias *a); 9 int perform_alias(struct descriptor_data *d, char *orig); " int reserved_word(char *argument); int find_name(char *name);' int _parse_name(char *arg, char *name);   ( /* prototypes for all do_x functions. */ ACMD(do_action); ACMD(do_advance);  ACMD(do_alias);  ACMD(do_assist); ACMD(do_at); ACMD(do_backstab);
 ACMD(do_ban);  ACMD(do_bash); ACMD(do_cast); ACMD(do_color);  ACMD(do_commands); ACMD(do_consider); ACMD(do_credits);  ACMD(do_date); ACMD(do_dc); ACMD(do_diagnose); ACMD(do_display);  ACMD(do_drink);  ACMD(do_drop);
 ACMD(do_eat);  ACMD(do_echo); ACMD(do_enter);  ACMD(do_equipment);  ACMD(do_examine);  ACMD(do_exit); ACMD(do_exits);  ACMD(do_flee); ACMD(do_follow); ACMD(do_force);  ACMD(do_gecho);  ACMD(do_gen_comm); ACMD(do_gen_door); ACMD(do_gen_ps); ACMD(do_gen_tog);  ACMD(do_gen_write); 
 ACMD(do_get);  ACMD(do_give); ACMD(do_gold); ACMD(do_goto); ACMD(do_grab); ACMD(do_group);  ACMD(do_gsay); ACMD(do_hcontrol); ACMD(do_help); ACMD(do_hide);
 ACMD(do_hit);  ACMD(do_house);  ACMD(do_info); ACMD(do_insult); ACMD(do_inventory);  ACMD(do_invis);  ACMD(do_kick); ACMD(do_kill); ACMD(do_last); ACMD(do_leave);  ACMD(do_levels); ACMD(do_load); ACMD(do_look);% /* ACMD(do_move); -- interpreter.h */  ACMD(do_not_here); ACMD(do_offer); 
 ACMD(do_olc);  ACMD(do_order);  ACMD(do_page); ACMD(do_poofset);  ACMD(do_pour); ACMD(do_practice); ACMD(do_purge); 
 ACMD(do_put);  ACMD(do_qcomm);  ACMD(do_quit); ACMD(do_reboot); ACMD(do_remove); ACMD(do_rent); ACMD(do_reply);  ACMD(do_report); ACMD(do_rescue); ACMD(do_rest); ACMD(do_restore);  ACMD(do_return); ACMD(do_save);
 ACMD(do_say);  ACMD(do_score);  ACMD(do_send);
 ACMD(do_set);  ACMD(do_show); ACMD(do_shutdown);
 ACMD(do_sit);  ACMD(do_skillset); ACMD(do_sleep);  ACMD(do_sneak);  ACMD(do_snoop);  ACMD(do_spec_comm);  ACMD(do_split);  ACMD(do_stand);  ACMD(do_stat); ACMD(do_steal);  ACMD(do_switch); ACMD(do_syslog); ACMD(do_teleport); ACMD(do_tell); ACMD(do_time); ACMD(do_title);  ACMD(do_toggle); ACMD(do_track);  ACMD(do_trans);  ACMD(do_unban);  ACMD(do_ungroup); 
 ACMD(do_use);  ACMD(do_users);  ACMD(do_visible);  ACMD(do_vnum); ACMD(do_vstat);  ACMD(do_wake); ACMD(do_wear); ACMD(do_weather);  ACMD(do_where); 
 ACMD(do_who);  ACMD(do_wield);  ACMD(do_wimpy);  ACMD(do_wizlock);  ACMD(do_wiznet); ACMD(do_wizutil);  ACMD(do_write);  ACMD(do_zreset);    ' /* This is the Master Command List(tm).   C  * You can put new commands in, take commands out, change the order B  * they appear in, etc.  You can adjust the "priority" of commands@  * simply by changing the order they appear in the command list.D  * (For example, if you want "as" to mean "assist" instead of "ask",@  * just put "assist" above "ask" in the Master Command List(tm).  *G  * In general, utility commands such as "at" should have high priority; I  * infrequently used and dangerously destructive commands should have low   * priority.  */   3 cpp_extern const struct command_info cmd_info[] = { G   { "RESERVED", 0, 0, 0, 0 },	/* this must be first -- for specprocs */   E   /* directions must come before other commands but after RESERVED */ =   { "north"    , POS_STANDING, do_move     , 0, SCMD_NORTH }, <   { "east"     , POS_STANDING, do_move     , 0, SCMD_EAST },=   { "south"    , POS_STANDING, do_move     , 0, SCMD_SOUTH }, <   { "west"     , POS_STANDING, do_move     , 0, SCMD_WEST },:   { "up"       , POS_STANDING, do_move     , 0, SCMD_UP },<   { "down"     , POS_STANDING, do_move     , 0, SCMD_DOWN },     /* now, the main list */=   { "at"       , POS_DEAD    , do_at       , LVL_IMMORT, 0 }, ;   { "advance"  , POS_DEAD    , do_advance  , LVL_IMPL, 0 }, 4   { "alias"    , POS_DEAD    , do_alias    , 0, 0 },4   { "accuse"   , POS_SITTING , do_action   , 0, 0 },4   { "applaud"  , POS_RESTING , do_action   , 0, 0 },4   { "assist"   , POS_FIGHTING, do_assist   , 1, 0 },;   { "ask"      , POS_RESTING , do_spec_comm, 0, SCMD_ASK }, ?   { "auction"  , POS_SLEEPING, do_gen_comm , 0, SCMD_AUCTION }, @   { "autoexit" , POS_DEAD    , do_gen_tog  , 0, SCMD_AUTOEXIT },  4   { "bounce"   , POS_STANDING, do_action   , 0, 0 },4   { "backstab" , POS_STANDING, do_backstab , 1, 0 },<   { "ban"      , POS_DEAD    , do_ban      , LVL_GRGOD, 0 },4   { "balance"  , POS_STANDING, do_not_here , 1, 0 },4   { "bash"     , POS_FIGHTING, do_bash     , 1, 0 },4   { "beg"      , POS_RESTING , do_action   , 0, 0 },4   { "bleed"    , POS_RESTING , do_action   , 0, 0 },4   { "blush"    , POS_RESTING , do_action   , 0, 0 },4   { "bow"      , POS_STANDING, do_action   , 0, 0 },4   { "brb"      , POS_RESTING , do_action   , 0, 0 },=   { "brief"    , POS_DEAD    , do_gen_tog  , 0, SCMD_BRIEF }, 4   { "burp"     , POS_RESTING , do_action   , 0, 0 },4   { "buy"      , POS_STANDING, do_not_here , 0, 0 },;   { "bug"      , POS_DEAD    , do_gen_write, 0, SCMD_BUG },   4   { "cast"     , POS_SITTING , do_cast     , 1, 0 },4   { "cackle"   , POS_RESTING , do_action   , 0, 0 },4   { "check"    , POS_STANDING, do_not_here , 1, 0 },4   { "chuckle"  , POS_RESTING , do_action   , 0, 0 },4   { "clap"     , POS_RESTING , do_action   , 0, 0 },=   { "clear"    , POS_DEAD    , do_gen_ps   , 0, SCMD_CLEAR }, =   { "close"    , POS_SITTING , do_gen_door , 0, SCMD_CLOSE }, =   { "cls"      , POS_DEAD    , do_gen_ps   , 0, SCMD_CLEAR }, 4   { "consider" , POS_RESTING , do_consider , 0, 0 },4   { "color"    , POS_DEAD    , do_color    , 0, 0 },4   { "comfort"  , POS_RESTING , do_action   , 0, 0 },4   { "comb"     , POS_RESTING , do_action   , 0, 0 },@   { "commands" , POS_DEAD    , do_commands , 0, SCMD_COMMANDS },?   { "compact"  , POS_DEAD    , do_gen_tog  , 0, SCMD_COMPACT }, 4   { "cough"    , POS_RESTING , do_action   , 0, 0 },?   { "credits"  , POS_DEAD    , do_gen_ps   , 0, SCMD_CREDITS }, 4   { "cringe"   , POS_RESTING , do_action   , 0, 0 },4   { "cry"      , POS_RESTING , do_action   , 0, 0 },4   { "cuddle"   , POS_RESTING , do_action   , 0, 0 },4   { "curse"    , POS_RESTING , do_action   , 0, 0 },4   { "curtsey"  , POS_STANDING, do_action   , 0, 0 },  4   { "dance"    , POS_STANDING, do_action   , 0, 0 },E   { "date"     , POS_DEAD    , do_date     , LVL_IMMORT, SCMD_DATE }, 4   { "daydream" , POS_SLEEPING, do_action   , 0, 0 },:   { "dc"       , POS_DEAD    , do_dc       , LVL_GOD, 0 },4   { "deposit"  , POS_STANDING, do_not_here , 1, 0 },4   { "diagnose" , POS_RESTING , do_diagnose , 0, 0 },4   { "display"  , POS_DEAD    , do_display  , 0, 0 },>   { "donate"   , POS_RESTING , do_drop     , 0, SCMD_DONATE },=   { "drink"    , POS_RESTING , do_drink    , 0, SCMD_DRINK }, <   { "drop"     , POS_RESTING , do_drop     , 0, SCMD_DROP },4   { "drool"    , POS_RESTING , do_action   , 0, 0 },  ;   { "eat"      , POS_RESTING , do_eat      , 0, SCMD_EAT }, E   { "echo"     , POS_SLEEPING, do_echo     , LVL_IMMORT, SCMD_ECHO }, =   { "emote"    , POS_RESTING , do_echo     , 1, SCMD_EMOTE }, =   { ":"        , POS_RESTING, do_echo      , 1, SCMD_EMOTE }, 4   { "embrace"  , POS_STANDING, do_action   , 0, 0 },4   { "enter"    , POS_STANDING, do_enter    , 0, 0 },4   { "equipment", POS_SLEEPING, do_equipment, 0, 0 },4   { "exits"    , POS_RESTING , do_exits    , 0, 0 },4   { "examine"  , POS_SITTING , do_examine  , 0, 0 },  :   { "force"    , POS_SLEEPING, do_force    , LVL_GOD, 0 },4   { "fart"     , POS_RESTING , do_action   , 0, 0 },<   { "fill"     , POS_STANDING, do_pour     , 0, SCMD_FILL },4   { "flee"     , POS_FIGHTING, do_flee     , 1, 0 },4   { "flip"     , POS_STANDING, do_action   , 0, 0 },4   { "flirt"    , POS_RESTING , do_action   , 0, 0 },4   { "follow"   , POS_RESTING , do_follow   , 0, 0 },4   { "fondle"   , POS_RESTING , do_action   , 0, 0 },G   { "freeze"   , POS_DEAD    , do_wizutil  , LVL_FREEZE, SCMD_FREEZE }, 4   { "french"   , POS_RESTING , do_action   , 0, 0 },4   { "frown"    , POS_RESTING , do_action   , 0, 0 },4   { "fume"     , POS_RESTING , do_action   , 0, 0 },  4   { "get"      , POS_RESTING , do_get      , 0, 0 },4   { "gasp"     , POS_RESTING , do_action   , 0, 0 },:   { "gecho"    , POS_DEAD    , do_gecho    , LVL_GOD, 0 },4   { "give"     , POS_RESTING , do_give     , 0, 0 },4   { "giggle"   , POS_RESTING , do_action   , 0, 0 },4   { "glare"    , POS_RESTING , do_action   , 0, 0 },=   { "goto"     , POS_SLEEPING, do_goto     , LVL_IMMORT, 0 }, 4   { "gold"     , POS_RESTING , do_gold     , 0, 0 },>   { "gossip"   , POS_SLEEPING, do_gen_comm , 0, SCMD_GOSSIP },4   { "group"    , POS_RESTING , do_group    , 1, 0 },4   { "grab"     , POS_RESTING , do_grab     , 0, 0 },=   { "grats"    , POS_SLEEPING, do_gen_comm , 0, SCMD_GRATZ }, 4   { "greet"    , POS_RESTING , do_action   , 0, 0 },4   { "grin"     , POS_RESTING , do_action   , 0, 0 },4   { "groan"    , POS_RESTING , do_action   , 0, 0 },4   { "grope"    , POS_RESTING , do_action   , 0, 0 },4   { "grovel"   , POS_RESTING , do_action   , 0, 0 },4   { "growl"    , POS_RESTING , do_action   , 0, 0 },4   { "gsay"     , POS_SLEEPING, do_gsay     , 0, 0 },4   { "gtell"    , POS_SLEEPING, do_gsay     , 0, 0 },  4   { "help"     , POS_DEAD    , do_help     , 0, 0 },I   { "handbook" , POS_DEAD    , do_gen_ps   , LVL_IMMORT, SCMD_HANDBOOK }, <   { "hcontrol" , POS_DEAD    , do_hcontrol , LVL_GRGOD, 0 },4   { "hiccup"   , POS_RESTING , do_action   , 0, 0 },4   { "hide"     , POS_RESTING , do_hide     , 1, 0 },;   { "hit"      , POS_FIGHTING, do_hit      , 0, SCMD_HIT }, 4   { "hold"     , POS_RESTING , do_grab     , 1, 0 },>   { "holler"   , POS_RESTING , do_gen_comm , 1, SCMD_HOLLER },J   { "holylight", POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_HOLYLIGHT },4   { "hop"      , POS_RESTING , do_action   , 0, 0 },4   { "house"    , POS_RESTING , do_house    , 0, 0 },4   { "hug"      , POS_RESTING , do_action   , 0, 0 },  4   { "inventory", POS_DEAD    , do_inventory, 0, 0 },<   { "idea"     , POS_DEAD    , do_gen_write, 0, SCMD_IDEA },F   { "imotd"    , POS_DEAD    , do_gen_ps   , LVL_IMMORT, SCMD_IMOTD },?   { "immlist"  , POS_DEAD    , do_gen_ps   , 0, SCMD_IMMLIST }, <   { "info"     , POS_SLEEPING, do_gen_ps   , 0, SCMD_INFO },4   { "insult"   , POS_RESTING , do_insult   , 0, 0 },=   { "invis"    , POS_DEAD    , do_invis    , LVL_IMMORT, 0 },   <   { "junk"     , POS_RESTING , do_drop     , 0, SCMD_JUNK },  4   { "kill"     , POS_FIGHTING, do_kill     , 0, 0 },4   { "kick"     , POS_FIGHTING, do_kick     , 1, 0 },4   { "kiss"     , POS_RESTING , do_action   , 0, 0 },  <   { "look"     , POS_RESTING , do_look     , 0, SCMD_LOOK },4   { "laugh"    , POS_RESTING , do_action   , 0, 0 },:   { "last"     , POS_DEAD    , do_last     , LVL_GOD, 0 },4   { "leave"    , POS_STANDING, do_leave    , 0, 0 },4   { "levels"   , POS_DEAD    , do_levels   , 0, 0 },4   { "list"     , POS_STANDING, do_not_here , 0, 0 },4   { "lick"     , POS_RESTING , do_action   , 0, 0 },<   { "lock"     , POS_SITTING , do_gen_door , 0, SCMD_LOCK },:   { "load"     , POS_DEAD    , do_load     , LVL_GOD, 0 },4   { "love"     , POS_RESTING , do_action   , 0, 0 },  4   { "moan"     , POS_RESTING , do_action   , 0, 0 },J   { "medit"    , POS_DEAD    , do_olc      , LVL_BUILDER, SCMD_OLC_MEDIT},<   { "motd"     , POS_DEAD    , do_gen_ps   , 0, SCMD_MOTD },4   { "mail"     , POS_STANDING, do_not_here , 1, 0 },4   { "massage"  , POS_RESTING , do_action   , 0, 0 },E   { "mute"     , POS_DEAD    , do_wizutil  , LVL_GOD, SCMD_SQUELCH }, >   { "murder"   , POS_FIGHTING, do_hit      , 0, SCMD_MURDER },  <   { "news"     , POS_SLEEPING, do_gen_ps   , 0, SCMD_NEWS },4   { "nibble"   , POS_RESTING , do_action   , 0, 0 },4   { "nod"      , POS_RESTING , do_action   , 0, 0 },A   { "noauction", POS_DEAD    , do_gen_tog  , 0, SCMD_NOAUCTION }, @   { "nogossip" , POS_DEAD    , do_gen_tog  , 0, SCMD_NOGOSSIP },?   { "nograts"  , POS_DEAD    , do_gen_tog  , 0, SCMD_NOGRATZ }, I   { "nohassle" , POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_NOHASSLE }, @   { "norepeat" , POS_DEAD    , do_gen_tog  , 0, SCMD_NOREPEAT },<   { "noshout"  , POS_SLEEPING, do_gen_tog  , 1, SCMD_DEAF },@   { "nosummon" , POS_DEAD    , do_gen_tog  , 1, SCMD_NOSUMMON },>   { "notell"   , POS_DEAD    , do_gen_tog  , 1, SCMD_NOTELL },E   { "notitle"  , POS_DEAD    , do_wizutil  , LVL_GOD, SCMD_NOTITLE }, F   { "nowiz"    , POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_NOWIZ },4   { "nudge"    , POS_RESTING , do_action   , 0, 0 },4   { "nuzzle"   , POS_RESTING , do_action   , 0, 0 },  4   { "order"    , POS_RESTING , do_order    , 1, 0 },4   { "offer"    , POS_STANDING, do_not_here , 1, 0 },<   { "open"     , POS_SITTING , do_gen_door , 0, SCMD_OPEN },J   { "olc"      , POS_DEAD    , do_olc      , LVL_GOD, SCMD_OLC_SAVEINFO },J   { "oedit"    , POS_DEAD    , do_olc      , LVL_BUILDER, SCMD_OLC_OEDIT},  4   { "put"      , POS_RESTING , do_put      , 0, 0 },4   { "pat"      , POS_RESTING , do_action   , 0, 0 },:   { "page"     , POS_DEAD    , do_page     , LVL_GOD, 0 },D   { "pardon"   , POS_DEAD    , do_wizutil  , LVL_GOD, SCMD_PARDON },4   { "peer"     , POS_RESTING , do_action   , 0, 0 },<   { "pick"     , POS_STANDING, do_gen_door , 1, SCMD_PICK },4   { "point"    , POS_RESTING , do_action   , 0, 0 },4   { "poke"     , POS_RESTING , do_action   , 0, 0 },@   { "policy"   , POS_DEAD    , do_gen_ps   , 0, SCMD_POLICIES },4   { "ponder"   , POS_RESTING , do_action   , 0, 0 },G   { "poofin"   , POS_DEAD    , do_poofset  , LVL_IMMORT, SCMD_POOFIN }, H   { "poofout"  , POS_DEAD    , do_poofset  , LVL_IMMORT, SCMD_POOFOUT },<   { "pour"     , POS_STANDING, do_pour     , 0, SCMD_POUR },4   { "pout"     , POS_RESTING , do_action   , 0, 0 },4   { "prompt"   , POS_DEAD    , do_display  , 0, 0 },4   { "practice" , POS_RESTING , do_practice , 1, 0 },4   { "pray"     , POS_SITTING , do_action   , 0, 0 },4   { "puke"     , POS_RESTING , do_action   , 0, 0 },4   { "punch"    , POS_RESTING , do_action   , 0, 0 },4   { "purr"     , POS_RESTING , do_action   , 0, 0 },:   { "purge"    , POS_DEAD    , do_purge    , LVL_GOD, 0 },  =   { "quaff"    , POS_RESTING , do_use      , 0, SCMD_QUAFF }, F   { "qecho"    , POS_DEAD    , do_qcomm    , LVL_IMMORT, SCMD_QECHO },=   { "quest"    , POS_DEAD    , do_gen_tog  , 0, SCMD_QUEST }, 4   { "qui"      , POS_DEAD    , do_quit     , 0, 0 },<   { "quit"     , POS_DEAD    , do_quit     , 0, SCMD_QUIT },<   { "qsay"     , POS_RESTING , do_qcomm    , 0, SCMD_QSAY },  4   { "reply"    , POS_SLEEPING, do_reply    , 0, 0 },4   { "rest"     , POS_RESTING , do_rest     , 0, 0 },<   { "read"     , POS_RESTING , do_look     , 0, SCMD_READ },;   { "reload"   , POS_DEAD    , do_reboot   , LVL_IMPL, 0 }, >   { "recite"   , POS_RESTING , do_use      , 0, SCMD_RECITE },4   { "receive"  , POS_STANDING, do_not_here , 1, 0 },4   { "remove"   , POS_RESTING , do_remove   , 0, 0 },4   { "rent"     , POS_STANDING, do_not_here , 1, 0 },4   { "report"   , POS_RESTING , do_report   , 0, 0 },F   { "reroll"   , POS_DEAD    , do_wizutil  , LVL_GRGOD, SCMD_REROLL },4   { "rescue"   , POS_FIGHTING, do_rescue   , 1, 0 },:   { "restore"  , POS_DEAD    , do_restore  , LVL_GOD, 0 },4   { "return"   , POS_DEAD    , do_return   , 0, 0 },J   { "redit"    , POS_DEAD    , do_olc      , LVL_BUILDER, SCMD_OLC_REDIT},4   { "roll"     , POS_RESTING , do_action   , 0, 0 },J   { "roomflags", POS_DEAD    , do_gen_tog  , LVL_IMMORT, SCMD_ROOMFLAGS },4   { "ruffle"   , POS_STANDING, do_action   , 0, 0 },  4   { "say"      , POS_RESTING , do_say      , 0, 0 },4   { "'"        , POS_RESTING , do_say      , 0, 0 },4   { "save"     , POS_SLEEPING, do_save     , 0, 0 },4   { "score"    , POS_DEAD    , do_score    , 0, 0 },4   { "scream"   , POS_RESTING , do_action   , 0, 0 },4   { "sell"     , POS_STANDING, do_not_here , 0, 0 },:   { "send"     , POS_SLEEPING, do_send     , LVL_GOD, 0 },:   { "set"      , POS_DEAD    , do_set      , LVL_GOD, 0 },J   { "sedit"    , POS_DEAD    , do_olc      , LVL_BUILDER, SCMD_OLC_SEDIT},=   { "shout"    , POS_RESTING , do_gen_comm , 0, SCMD_SHOUT }, 4   { "shake"    , POS_RESTING , do_action   , 0, 0 },4   { "shiver"   , POS_RESTING , do_action   , 0, 0 },=   { "show"     , POS_DEAD    , do_show     , LVL_IMMORT, 0 }, 4   { "shrug"    , POS_RESTING , do_action   , 0, 0 },;   { "shutdow"  , POS_DEAD    , do_shutdown , LVL_IMPL, 0 }, G   { "shutdown" , POS_DEAD    , do_shutdown , LVL_IMPL, SCMD_SHUTDOWN }, 4   { "sigh"     , POS_RESTING , do_action   , 0, 0 },4   { "sing"     , POS_RESTING , do_action   , 0, 0 },;   { "sip"      , POS_RESTING , do_drink    , 0, SCMD_SIP }, 4   { "sit"      , POS_RESTING , do_sit      , 0, 0 },<   { "skillset" , POS_SLEEPING, do_skillset , LVL_GRGOD, 0 },4   { "sleep"    , POS_SLEEPING, do_sleep    , 0, 0 },4   { "slap"     , POS_RESTING , do_action   , 0, 0 },E   { "slowns"   , POS_DEAD    , do_gen_tog  , LVL_IMPL, SCMD_SLOWNS }, 4   { "smile"    , POS_RESTING , do_action   , 0, 0 },4   { "smirk"    , POS_RESTING , do_action   , 0, 0 },4   { "snicker"  , POS_RESTING , do_action   , 0, 0 },4   { "snap"     , POS_RESTING , do_action   , 0, 0 },4   { "snarl"    , POS_RESTING , do_action   , 0, 0 },4   { "sneeze"   , POS_RESTING , do_action   , 0, 0 },4   { "sneak"    , POS_STANDING, do_sneak    , 1, 0 },4   { "sniff"    , POS_RESTING , do_action   , 0, 0 },4   { "snore"    , POS_SLEEPING, do_action   , 0, 0 },=   { "snowball" , POS_STANDING, do_action   , LVL_IMMORT, 0 }, :   { "snoop"    , POS_DEAD    , do_snoop    , LVL_GOD, 0 },4   { "snuggle"  , POS_RESTING , do_action   , 0, 0 },?   { "socials"  , POS_DEAD    , do_commands , 0, SCMD_SOCIALS }, 4   { "split"    , POS_SITTING , do_split    , 1, 0 },4   { "spank"    , POS_RESTING , do_action   , 0, 0 },4   { "spit"     , POS_STANDING, do_action   , 0, 0 },4   { "squeeze"  , POS_RESTING , do_action   , 0, 0 },4   { "stand"    , POS_RESTING , do_stand    , 0, 0 },4   { "stare"    , POS_RESTING , do_action   , 0, 0 },=   { "stat"     , POS_DEAD    , do_stat     , LVL_IMMORT, 0 }, 4   { "steal"    , POS_STANDING, do_steal    , 1, 0 },4   { "steam"    , POS_RESTING , do_action   , 0, 0 },4   { "stroke"   , POS_RESTING , do_action   , 0, 0 },4   { "strut"    , POS_STANDING, do_action   , 0, 0 },4   { "sulk"     , POS_RESTING , do_action   , 0, 0 },<   { "switch"   , POS_DEAD    , do_switch   , LVL_GRGOD, 0 },=   { "syslog"   , POS_DEAD    , do_syslog   , LVL_IMMORT, 0 },   4   { "tell"     , POS_DEAD    , do_tell     , 0, 0 },4   { "tackle"   , POS_RESTING , do_action   , 0, 0 },4   { "take"     , POS_RESTING , do_get      , 0, 0 },4   { "tango"    , POS_STANDING, do_action   , 0, 0 },4   { "taunt"    , POS_RESTING , do_action   , 0, 0 },=   { "taste"    , POS_RESTING , do_eat      , 0, SCMD_TASTE }, :   { "teleport" , POS_DEAD    , do_teleport , LVL_GOD, 0 },4   { "thank"    , POS_RESTING , do_action   , 0, 0 },4   { "think"    , POS_RESTING , do_action   , 0, 0 },E   { "thaw"     , POS_DEAD    , do_wizutil  , LVL_FREEZE, SCMD_THAW }, 4   { "title"    , POS_DEAD    , do_title    , 0, 0 },4   { "tickle"   , POS_RESTING , do_action   , 0, 0 },4   { "time"     , POS_DEAD    , do_time     , 0, 0 },4   { "toggle"   , POS_DEAD    , do_toggle   , 0, 0 },4   { "track"    , POS_STANDING, do_track    , 0, 0 },:   { "transfer" , POS_SLEEPING, do_trans    , LVL_GOD, 0 },4   { "twiddle"  , POS_RESTING , do_action   , 0, 0 },<   { "typo"     , POS_DEAD    , do_gen_write, 0, SCMD_TYPO },  >   { "unlock"   , POS_SITTING , do_gen_door , 0, SCMD_UNLOCK },4   { "ungroup"  , POS_DEAD    , do_ungroup  , 0, 0 },<   { "unban"    , POS_DEAD    , do_unban    , LVL_GRGOD, 0 },F   { "unaffect" , POS_DEAD    , do_wizutil  , LVL_GOD, SCMD_UNAFFECT },G   { "uptime"   , POS_DEAD    , do_date     , LVL_IMMORT, SCMD_UPTIME }, ;   { "use"      , POS_SITTING , do_use      , 1, SCMD_USE }, =   { "users"    , POS_DEAD    , do_users    , LVL_IMMORT, 0 },   4   { "value"    , POS_STANDING, do_not_here , 0, 0 },?   { "version"  , POS_DEAD    , do_gen_ps   , 0, SCMD_VERSION }, 4   { "visible"  , POS_RESTING , do_visible  , 1, 0 },=   { "vnum"     , POS_DEAD    , do_vnum     , LVL_IMMORT, 0 }, =   { "vstat"    , POS_DEAD    , do_vstat    , LVL_IMMORT, 0 },   4   { "wake"     , POS_SLEEPING, do_wake     , 0, 0 },4   { "wave"     , POS_RESTING , do_action   , 0, 0 },4   { "wear"     , POS_RESTING , do_wear     , 0, 0 },4   { "weather"  , POS_RESTING , do_weather  , 0, 0 },4   { "who"      , POS_DEAD    , do_who      , 0, 0 },>   { "whoami"   , POS_DEAD    , do_gen_ps   , 0, SCMD_WHOAMI },4   { "where"    , POS_RESTING , do_where    , 1, 0 },?   { "whisper"  , POS_RESTING , do_spec_comm, 0, SCMD_WHISPER }, 4   { "whine"    , POS_RESTING , do_action   , 0, 0 },4   { "whistle"  , POS_RESTING , do_action   , 0, 0 },4   { "wield"    , POS_RESTING , do_wield    , 0, 0 },4   { "wiggle"   , POS_STANDING, do_action   , 0, 0 },4   { "wimpy"    , POS_DEAD    , do_wimpy    , 0, 0 },4   { "wink"     , POS_RESTING , do_action   , 0, 0 },4   { "withdraw" , POS_STANDING, do_not_here , 1, 0 },=   { "wiznet"   , POS_DEAD    , do_wiznet   , LVL_IMMORT, 0 }, =   { ";"        , POS_DEAD    , do_wiznet   , LVL_IMMORT, 0 }, H   { "wizhelp"  , POS_SLEEPING, do_commands , LVL_IMMORT, SCMD_WIZHELP },?   { "wizlist"  , POS_DEAD    , do_gen_ps   , 0, SCMD_WIZLIST }, ;   { "wizlock"  , POS_DEAD    , do_wizlock  , LVL_IMPL, 0 }, 4   { "worship"  , POS_RESTING , do_action   , 0, 0 },4   { "write"    , POS_STANDING, do_write    , 1, 0 },  4   { "yawn"     , POS_RESTING , do_action   , 0, 0 },4   { "yodel"    , POS_RESTING , do_action   , 0, 0 },  J   { "zedit"    , POS_DEAD    , do_olc      , LVL_BUILDER, SCMD_OLC_ZEDIT},<   { "zreset"   , POS_DEAD    , do_zreset   , LVL_GRGOD, 0 },  1   { "\n", 0, 0, 0, 0 } };	/* this must be last */      const char *fill[] = {    "in", 	   "from", 	   "with",    "the",   "on",    "at",    "to",    "\n" };   const char *reserved[] = {    "a",   "an", 	   "self",    "me",    "all",	   "room",    "someone",   "something",   "\n" };   /*K  * This is the actual command interpreter called from game_loop() in comm.c N  * It makes sure you are the proper level and position to execute the command,'  * then calls the appropriate function.   */ > void command_interpreter(struct char_data *ch, char *argument) {    int cmd, length;
   char *line;   &   REMOVE_BIT(AFF_FLAGS(ch), AFF_HIDE);  -   /* just drop to next line for hitting CR */    skip_spaces(&argument);    if (!*argument)      return;      /*E    * special case to handle one-character, non-alphanumeric commands; E    * requested by many people so "'hi" or ";godnet test" is possible. 4    * Patch sent by Eric Green and Stefan Wasilewski.    */    if (!isalpha(*argument)) {     arg[0] = argument[0];      arg[1] = '\0';     line = argument + 1;   } else&     line = any_one_arg(argument, arg);  #   /* otherwise, find the command */ L   for (length = strlen(arg), cmd = 0; *cmd_info[cmd].command != '\n'; cmd++)5     if (!strncmp(cmd_info[cmd].command, arg, length)) 7       if (GET_LEVEL(ch) >= cmd_info[cmd].minimum_level)  	break;   %   if (*cmd_info[cmd].command == '\n') #     send_to_char("Huh?!?\r\n", ch); C   else if (PLR_FLAGGED(ch, PLR_FROZEN) && GET_LEVEL(ch) < LVL_IMPL) O     send_to_char("You try, but the mind-numbing cold prevents you...\r\n", ch); 1   else if (cmd_info[cmd].command_pointer == NULL) M     send_to_char("Sorry, that command hasn't been implemented yet.\r\n", ch); C   else if (IS_NPC(ch) && cmd_info[cmd].minimum_level >= LVL_IMMORT) L     send_to_char("You can't use immortal commands while switched.\r\n", ch);8   else if (GET_POS(ch) < cmd_info[cmd].minimum_position)     switch (GET_POS(ch)) {     case POS_DEAD:=       send_to_char("Lie still; you are DEAD!!! :-(\r\n", ch);        break;     case POS_INCAP:      case POS_MORTALLYW: T       send_to_char("You are in a pretty bad shape, unable to do anything!\r\n", ch);       break;     case POS_STUNNED: Q       send_to_char("All you can do right now is think about the stars!\r\n", ch);        break;     case POS_SLEEPING:7       send_to_char("In your dreams, or what?\r\n", ch);        break;     case POS_RESTING: G       send_to_char("Nah... You feel too relaxed to do that..\r\n", ch);        break;     case POS_SITTING: G       send_to_char("Maybe you should get on your feet first?\r\n", ch);        break;     case POS_FIGHTING:F       send_to_char("No way!  You're fighting for your life!\r\n", ch);       break;4   } else if (no_specials || !special(ch, cmd, line))M     ((*cmd_info[cmd].command_pointer) (ch, line, cmd, cmd_info[cmd].subcmd));  }   K /************************************************************************** L  * Routines to handle aliasing                                             *M   **************************************************************************/     = struct alias *find_alias(struct alias *alias_list, char *str)  {    while (alias_list != NULL) {J     if (*str == *alias_list->alias)	/* hey, every little bit counts :-) */*       if (!strcmp(str, alias_list->alias)) 	return alias_list;   "     alias_list = alias_list->next;   }      return NULL; }       void free_alias(struct alias *a) {    if (a->alias)      free(a->alias);    if (a->replacement)      free(a->replacement); 
   free(a); }     2 /* The interface to the outside world: do_alias */ ACMD(do_alias) { 
   char *repl;    struct alias *a, *temp;      if (IS_NPC(ch))      return;   $   repl = any_one_arg(argument, arg);  N   if (!*arg) {			/* no argument specified -- list currently defined aliases */7     send_to_char("Currently defined aliases:\r\n", ch); &     if ((a = GET_ALIASES(ch)) == NULL)%       send_to_char(" None.\r\n", ch); 
     else {       while (a != NULL) { 8 	sprintf(buf, "%-15s %s\r\n", a->alias, a->replacement); 	send_to_char(buf, ch); 
 	a = a->next;        }      } 3   } else {			/* otherwise, add or remove aliases */ 1     /* is this an alias we've already defined? */ 9     if ((a = find_alias(GET_ALIASES(ch), arg)) != NULL) { 1       REMOVE_FROM_LIST(a, GET_ALIASES(ch), next);        free_alias(a);     } I     /* if no replacement string is specified, assume we want to delete */      if (!*repl) {        if (a == NULL)( 	send_to_char("No such alias.\r\n", ch);
       else( 	send_to_char("Alias deleted.\r\n", ch);?     } else {			/* otherwise, either add or redefine an alias */ #       if (!str_cmp(arg, "alias")) { 2 	send_to_char("You can't alias 'alias'.\r\n", ch); 	return;       } !       CREATE(a, struct alias, 1);        a->alias = str_dup(arg);        delete_doubledollar(repl);%       a->replacement = str_dup(repl); G       if (strchr(repl, ALIAS_SEP_CHAR) || strchr(repl, ALIAS_VAR_CHAR))  	a->type = ALIAS_COMPLEX; 
       else 	a->type = ALIAS_SIMPLE;        a->next = GET_ALIASES(ch);       GET_ALIASES(ch) = a;+       send_to_char("Alias added.\r\n", ch);      }    }  }    /*G  * Valid numeric replacements are only $1 .. $9 (makes parsing a little F  * easier, and it's not that much of a limitation anyway.)  Also validF  * is "$*", which stands for the entire original line after the alias.#  * ";" is used to delimit commands.   */  #define NUM_TOKENS       9  N void perform_complex_alias(struct txt_q *input_q, char *orig, struct alias *a) {    struct txt_q temp_queue;0   char *tokens[NUM_TOKENS], *temp, *write_point;   int num_of_tokens = 0, num;   (   /* First, parse the original string */)   temp = strtok(strcpy(buf2, orig), " "); 6   while (temp != NULL && num_of_tokens < NUM_TOKENS) {#     tokens[num_of_tokens++] = temp;      temp = strtok(NULL, " ");    }      /* initialize */   write_point = buf;+   temp_queue.head = temp_queue.tail = NULL;      /* now parse the alias */ .   for (temp = a->replacement; *temp; temp++) {"     if (*temp == ALIAS_SEP_CHAR) {       *write_point = '\0';'       buf[MAX_INPUT_LENGTH - 1] = '\0'; &       write_to_q(buf, &temp_queue, 1);       write_point = buf;)     } else if (*temp == ALIAS_VAR_CHAR) { 
       temp++; <       if ((num = *temp - '1') < num_of_tokens && num >= 0) {" 	strcpy(write_point, tokens[num]);$ 	write_point += strlen(tokens[num]);,       } else if (*temp == ALIAS_GLOB_CHAR) { 	strcpy(write_point, orig);  	write_point += strlen(orig); S       } else if ((*(write_point++) = *temp) == '$')	/* redouble $ for act safety */  	*(write_point++) = '$';
     } else       *(write_point++) = *temp;    }      *write_point = '\0';#   buf[MAX_INPUT_LENGTH - 1] = '\0'; "   write_to_q(buf, &temp_queue, 1);  @   /* push our temp_queue on to the _front_ of the input queue */   if (input_q->head == NULL)     *input_q = temp_queue;   else {*     temp_queue.tail->next = input_q->head;$     input_q->head = temp_queue.head;   }  }      /*C  * Given a character and a string, perform alias replacement on it.   *  * Return values: K  *   0: String was modified in place; call command_interpreter immediately. H  *   1: String was _not_ modified in place; rather, the expanded aliasesE  *      have been placed at the front of the character's input queue.   */ 8 int perform_alias(struct descriptor_data *d, char *orig) { )   char first_arg[MAX_INPUT_LENGTH], *ptr;    struct alias *a, *tmp;      /* Mobs don't have alaises. */   if (IS_NPC(d->character)) 
     return 0;   @   /* bail out immediately if the guy doesn't have any aliases */0   if ((tmp = GET_ALIASES(d->character)) == NULL)
     return 0;   .   /* find the alias we're supposed to match */%   ptr = any_one_arg(orig, first_arg);      /* bail out if it's null */    if (!*first_arg)
     return 0;   G   /* if the first arg is not an alias, return without doing anything */ /   if ((a = find_alias(tmp, first_arg)) == NULL) 
     return 0;       if (a->type == ALIAS_SIMPLE) {!     strcpy(orig, a->replacement); 
     return 0; 
   } else {-     perform_complex_alias(&d->input, ptr, a); 
     return 1;    }  }       L /***************************************************************************L  * Various other parsing utilities                                         *L  **************************************************************************/   /*D  * searches an array of strings for a target string.  "exact" can beF  * 0 or non-0, depending on whether or not the match must be exact forF  * it to be returned.  Returns -1 if not found; 0..n otherwise.  Array@  * must be terminated with a '\n' so it knows to stop searching.  */ 9 int search_block(char *arg, const char **list, int exact)  {    register int i, l;  6   /* Make into lower case, and get length of string */   for (l = 0; *(arg + l); l++)#     *(arg + l) = LOWER(*(arg + l));      if (exact) {*     for (i = 0; **(list + i) != '\n'; i++)$       if (!strcmp(arg, *(list + i))) 	return (i);
   } else {     if (!l) 7       l = 1;			/* Avoid "" to match the first available  				 * string */*     for (i = 0; **(list + i) != '\n'; i++)(       if (!strncmp(arg, *(list + i), l)) 	return (i);   }      return -1; }      int is_number(const char *str) {    while (*str)     if (!isdigit(*(str++)))        return 0;      return 1;  }    /*8  * Function to skip over the leading spaces of a string.  */  void skip_spaces(char **string)  { 5   for (; **string && isspace(**string); (*string)++);  }      /*F  * Given a string, change all instances of double dollar signs ($$) toF  * single dollar signs ($).  When strings come in, all $'s are changedC  * to $$'s to avoid having users be able to crash the system if the F  * inputted string is eventually sent to act().  If you are using userF  * input to produce screen output AND YOU ARE SURE IT WILL NOT BE SENTI  * THROUGH THE act() FUNCTION (i.e., do_gecho, do_title, but NOT do_say), F  * you can call delete_doubledollar() to make the output look correct.  *   * Modifies the string in-place.  */ ' char *delete_doubledollar(char *string)  {    char *read, *write;   =   /* If the string has no dollar signs, return immediately */ ,   if ((write = strchr(string, '$')) == NULL)     return string;  8   /* Start from the location of the first dollar sign */   read = write;     ?   while (*read)   /* Until we reach the end of the string... */ <     if ((*(write++) = *(read++)) == '$') /* copy one char */       if (*read == '$') , 	read++; /* skip if we saw 2 $'s in a row */     *write = '\0';     return string; }      int fill_word(char *argument)  { 3   return (search_block(argument, fill, TRUE) >= 0);  }     ! int reserved_word(char *argument)  { 7   return (search_block(argument, reserved, TRUE) >= 0);  }      /*G  * copy the first non-fill-word, space-delimited argument of 'argument' C  * to 'first_arg'; return a pointer to the remainder of the string.   */ 3 char *one_argument(char *argument, char *first_arg)  {    char *begin = first_arg;     if (!argument) {9     log("SYSERR: one_argument received a NULL pointer!");      *first_arg = '\0';     return NULL;   }      do {     skip_spaces(&argument);        first_arg = begin;.     while (*argument && !isspace(*argument)) {(       *(first_arg++) = LOWER(*argument);       argument++;      }        *first_arg = '\0';   } while (fill_word(begin));      return argument; }      /*F  * one_word is like one_argument, except that words in quotes ("") are  * considered one word.   */ / char *one_word(char *argument, char *first_arg)  {    char *begin = first_arg;     do {     skip_spaces(&argument);        first_arg = begin;       if (*argument == '\"') {       argument++; .       while (*argument && *argument != '\"') {*         *(first_arg++) = LOWER(*argument);         argument++;        }        argument++;      } else {0       while (*argument && !isspace(*argument)) {*         *(first_arg++) = LOWER(*argument);         argument++;        }      }        *first_arg = '\0';   } while (fill_word(begin));      return argument; }     C /* same as one_argument except that it doesn't ignore fill words */ 2 char *any_one_arg(char *argument, char *first_arg) {    skip_spaces(&argument);   ,   while (*argument && !isspace(*argument)) {&     *(first_arg++) = LOWER(*argument);     argument++;    }      *first_arg = '\0';     return argument; }      /*K  * Same as one_argument except that it takes two args and returns the rest;   * ignores fill words   */ F char *two_arguments(char *argument, char *first_arg, char *second_arg) { O   return one_argument(one_argument(argument, first_arg), second_arg); /* :-) */  }        /*<  * determine if a given string is an abbreviation of another*  * (now works symmetrically -- JE 7/25/94)  *:  * that was dumb.  it shouldn't be symmetrical.  JE 5/1/95  *  0  * returnss 1 if arg1 is an abbreviation of arg2  */ 1 int is_abbrev(const char *arg1, const char *arg2)  { 
   if (!*arg1) 
     return 0;   (   for (; *arg1 && *arg2; arg1++, arg2++)%     if (LOWER(*arg1) != LOWER(*arg2))        return 0;   
   if (!*arg1) 
     return 1;    else
     return 0;  }       M /* return first space-delimited token in arg1; remainder of string in arg2 */ 4 void half_chop(char *string, char *arg1, char *arg2) { 
   char *temp;   #   temp = any_one_arg(string, arg1);    skip_spaces(&temp);    strcpy(arg2, temp);  }       K /* Used in specprocs, mostly.  (Exactly) matches "command" to cmd number */ % int find_command(const char *command)  { 
   int cmd;  6   for (cmd = 0; *cmd_info[cmd].command != '\n'; cmd++)0     if (!strcmp(cmd_info[cmd].command, command))       return cmd;      return -1; }     5 int special(struct char_data *ch, int cmd, char *arg)  {    register struct obj_data *i;   register struct char_data *k;    int j;     /* special in room? */)   if (GET_ROOM_SPEC(ch->in_room) != NULL) G     if (GET_ROOM_SPEC(ch->in_room) (ch, world + ch->in_room, cmd, arg))        return 1;   "   /* special in equipment list? */!   for (j = 0; j < NUM_WEARS; j++) =     if (GET_EQ(ch, j) && GET_OBJ_SPEC(GET_EQ(ch, j)) != NULL) D       if (GET_OBJ_SPEC(GET_EQ(ch, j)) (ch, GET_EQ(ch, j), cmd, arg))
 	return 1;     /* special in inventory? */ 0   for (i = ch->carrying; i; i = i->next_content)      if (GET_OBJ_SPEC(i) != NULL),       if (GET_OBJ_SPEC(i) (ch, i, cmd, arg))
 	return 1;  "   /* special in mobile present? */=   for (k = world[ch->in_room].people; k; k = k->next_in_room)       if (GET_MOB_SPEC(k) != NULL),       if (GET_MOB_SPEC(k) (ch, k, cmd, arg))
 	return 1;  "   /* special in object present? */?   for (i = world[ch->in_room].contents; i; i = i->next_content)       if (GET_OBJ_SPEC(i) != NULL),       if (GET_OBJ_SPEC(i) (ch, i, cmd, arg))
 	return 1;     return 0;  }       L /* *************************************************************************L *  Stuff for controlling the non-playing sockets (get name, pwd etc)       *L ************************************************************************* */    M /* locate entry in p_table with entry->name == name. -1 mrks failed search */  int find_name(char *name)  {    int i;  )   for (i = 0; i <= top_of_p_table; i++) { 1     if (!str_cmp((player_table + i)->name, name))        return i;    }      return -1; }     & int _parse_name(char *arg, char *name) {    int i;     /* skip whitespaces */   for (; isspace(*arg); arg++);   1   for (i = 0; (*name = *arg); arg++, i++, name++)      if (!isalpha(*arg))        return 1;   	   if (!i) 
     return 1;      return 0;  }      #define RECON		1 #define USURP		2 #define UNSWITCH	3   /*K  * XXX: Make immortals 'return' instead of being disconnected when switched J  *      into person returns.  This function seems a bit over-extended too.  */ 1 int perform_dupe_check(struct descriptor_data *d)  { %   struct descriptor_data *k, *next_k; 1   struct char_data *target = NULL, *ch, *next_ch;    int mode = 0;   #   int id = GET_IDNUM(d->character);      /*H    * Now that this descriptor has successfully logged in, disconnect allG    * other descriptors controlling a character with the same ID number.     */   ,   for (k = descriptor_list; k; k = next_k) {     next_k = k->next;        if (k == d)        continue;   O     if (k->original && (GET_IDNUM(k->original) == id)) {    /* switched char */ H       SEND_TO_Q("\r\nMultiple login detected -- disconnecting.\r\n", k);       STATE(k) = CON_CLOSE;        if (!target) { 	target = k->original; 	mode = UNSWITCH;        }        if (k->character)  	k->character->desc = NULL;        k->character = NULL;       k->original = NULL; A     } else if (k->character && (GET_IDNUM(k->character) == id)) { /       if (!target && STATE(k) == CON_PLAYING) { 5 	SEND_TO_Q("\r\nThis body has been usurped!\r\n", k);  	target = k->character;  	mode = USURP;       }         k->character->desc = NULL;       k->character = NULL;       k->original = NULL; H       SEND_TO_Q("\r\nMultiple login detected -- disconnecting.\r\n", k);       STATE(k) = CON_CLOSE;      }    }     /* D   * now, go through the character list, deleting all characters thatI   * are not already marked for deletion from the above step (i.e., in the I   * CON_HANGUP state), and have not already been selected as a target for G   * switching into.  In addition, if we haven't already found a target, B   * choose one if one is available (while still deleting the otherC   * duplicates, though theoretically none should be able to exist).    */  /   for (ch = character_list; ch; ch = next_ch) {      next_ch = ch->next;        if (IS_NPC(ch))        continue;      if (GET_IDNUM(ch) != id)       continue;   G     /* ignore chars with descriptors (already handled by above step) */      if (ch->desc)        continue;   ?     /* don't extract the target char we've found one already */      if (ch == target)        continue;   L     /* we don't already have a target and found a candidate for switching */     if (!target) {       target = ch;       mode = RECON;        continue;      }   K     /* we've found a duplicate - blow him away, dumping his eq in limbo. */      if (ch->in_room != NOWHERE)        char_from_room(ch);      char_to_room(ch, 1);     extract_char(ch);    }   H   /* no target for swicthing into was found - allow login to continue */   if (!target)
     return 0;   9   /* Okay, we've found a target.  Connect d to target. */ 8   free_char(d->character); /* get rid of the old char */   d->character = target;   d->character->desc = d;    d->original = NULL; (   d->character->char_specials.timer = 0;A   REMOVE_BIT(PLR_FLAGS(d->character), PLR_MAILING | PLR_WRITING);    STATE(d) = CON_PLAYING;      switch (mode) { 
   case RECON: &     SEND_TO_Q("Reconnecting.\r\n", d);B     act("$n has reconnected.", TRUE, d->character, 0, 0, TO_ROOM);N     sprintf(buf, "%s [%s] has reconnected.", GET_NAME(d->character), d->host);I     mudlog(buf, NRM, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE); 
     break;
   case USURP: E     SEND_TO_Q("You take over your own body, already in use!\r\n", d); K     act("$n suddenly keels over in pain, surrounded by a white aura...\r\n" 2 	"$n's body has been taken over by a new spirit!",$ 	TRUE, d->character, 0, 0, TO_ROOM);E     sprintf(buf, "%s has re-logged in ... disconnecting old socket.",  	    GET_NAME(d->character)); I     mudlog(buf, NRM, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE); 
     break;   case UNSWITCH:5     SEND_TO_Q("Reconnecting to unswitched char.", d); N     sprintf(buf, "%s [%s] has reconnected.", GET_NAME(d->character), d->host);I     mudlog(buf, NRM, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE); 
     break;   }      return 1;  }       7 /* deal with newcomers and other non-playing sockets */ 0 void nanny(struct descriptor_data *d, char *arg) {    char buf[128];   int player_i, load_result;"   char tmp_name[MAX_INPUT_LENGTH];   struct char_file_u tmp_store;    sh_int load_room;      skip_spaces(&arg);     switch (STATE(d)) {      /*. OLC states .*/   case CON_OEDIT:      oedit_parse(d, arg);
     break;   case CON_REDIT:      redit_parse(d, arg);
     break;   case CON_ZEDIT:      zedit_parse(d, arg);
     break;   case CON_MEDIT:      medit_parse(d, arg);
     break;   case CON_SEDIT:      sedit_parse(d, arg);
     break;   /*. End of OLC states .*/   2   case CON_GET_NAME:		/* wait for input of name */     if (d->character == NULL) { 0       CREATE(d->character, struct char_data, 1);       clear_char(d->character); K       CREATE(d->character->player_specials, struct player_special_data, 1);        d->character->desc = d;      }      if (!*arg)       STATE(d) = CON_CLOSE; 
     else {A       if ((_parse_name(arg, tmp_name)) || strlen(tmp_name) < 2 || A 	  strlen(tmp_name) > MAX_NAME_LENGTH || !Valid_Name(tmp_name) || < 	  fill_word(strcpy(buf, tmp_name)) || reserved_word(buf)) {2 	SEND_TO_Q("Invalid name, please try another.\r\n" 		  "Name: ", d);  	return;       } >       if ((player_i = load_char(tmp_name, &tmp_store)) > -1) {) 	store_to_char(&tmp_store, d->character); ' 	GET_PFILEPOS(d->character) = player_i;   . 	if (PLR_FLAGGED(d->character, PLR_DELETED)) {E 	  /* We get a false positive from the original deleted character. */  	  free_char(d->character);  	  d->character = NULL; ( 	  /* Check for multiple creations... */ 	  if (!Valid_Name(tmp_name)) { A 	    SEND_TO_Q("Invalid name, please try another.\r\nName: ", d);  	    return; 	  }- 	  CREATE(d->character, struct char_data, 1);  	  clear_char(d->character);H 	  CREATE(d->character->player_specials, struct player_special_data, 1); 	  d->character->desc = d;A 	  CREATE(d->character->player.name, char, strlen(tmp_name) + 1); 4 	  strcpy(d->character->player.name, CAP(tmp_name));) 	  GET_PFILEPOS(d->character) = player_i; > 	  sprintf(buf, "Did I get that right, %s (Y/N)? ", tmp_name); 	  SEND_TO_Q(buf, d);  	  STATE(d) = CON_NAME_CNFRM; 	 	} else { * 	  /* undo it just in case they are set */& 	  REMOVE_BIT(PLR_FLAGS(d->character),- 		     PLR_WRITING | PLR_MAILING | PLR_CRYO);    	  SEND_TO_Q("Password: ", d); 	  echo_off(d);  	  d->idle_tics = 0; 	  STATE(d) = CON_PASSWORD;  	}       } else {+ 	/* player unknown -- make new character */   3 	/* Check for multiple creations of a character. */  	if (!Valid_Name(tmp_name)) { ? 	  SEND_TO_Q("Invalid name, please try another.\r\nName: ", d); 
 	  return; 	}? 	CREATE(d->character->player.name, char, strlen(tmp_name) + 1); 2 	strcpy(d->character->player.name, CAP(tmp_name));  < 	sprintf(buf, "Did I get that right, %s (Y/N)? ", tmp_name); 	SEND_TO_Q(buf, d);  	STATE(d) = CON_NAME_CNFRM;        }      } 
     break;;   case CON_NAME_CNFRM:		/* wait for conf. of new name    */      if (UPPER(*arg) == 'Y') { )       if (isbanned(d->host) >= BAN_NEW) { C 	sprintf(buf, "Request for new char %s denied from [%s] (siteban)", # 		GET_NAME(d->character), d->host); ! 	mudlog(buf, NRM, LVL_GOD, TRUE); K 	SEND_TO_Q("Sorry, new characters are not allowed from your site!\r\n", d);  	STATE(d) = CON_CLOSE; 	return;       }        if (circle_restrict) {H 	SEND_TO_Q("Sorry, new players can't be created at the moment.\r\n", d);C 	sprintf(buf, "Request for new char %s denied from [%s] (wizlock)", # 		GET_NAME(d->character), d->host); ! 	mudlog(buf, NRM, LVL_GOD, TRUE);  	STATE(d) = CON_CLOSE; 	return;       } )       SEND_TO_Q("New character.\r\n", d); J       sprintf(buf, "Give me a password for %s: ", GET_NAME(d->character));       SEND_TO_Q(buf, d);       echo_off(d);       STATE(d) = CON_NEWPASSWD; ,     } else if (*arg == 'n' || *arg == 'N') {/       SEND_TO_Q("Okay, what IS it, then? ", d); &       free(d->character->player.name);'       d->character->player.name = NULL;        STATE(d) = CON_GET_NAME;     } else {.       SEND_TO_Q("Please type Yes or No: ", d);     } 
     break;9   case CON_PASSWORD:		/* get pwd for known player      */      /*E      * To really prevent duping correctly, the player's record should G      * be reloaded from disk at this point (after the password has been G      * typed).  However I'm afraid that trying to load a character over J      * an already loaded character is going to cause some problem down theK      * road that I can't see at the moment.  So to compensate, I'm going to L      * (1) add a 15 or 20-second time limit for entering a password, and (2)N      * re-add the code to cut off duplicates when a player quits.  JE 6 Feb 96      */   *     echo_on(d);    /* turn echo back on */       if (!*arg)       STATE(d) = CON_CLOSE; 
     else {d       if (strncmp(CRYPT(arg, GET_PASSWD(d->character)), GET_PASSWD(d->character), MAX_PWD_LENGTH)) {B 	sprintf(buf, "Bad PW: %s [%s]", GET_NAME(d->character), d->host);! 	mudlog(buf, BRF, LVL_GOD, TRUE);  	GET_BAD_PWS(d->character)++; " 	save_char(d->character, NOWHERE);E 	if (++(d->bad_pws) >= max_bad_pws) {	/* 3 strikes and you're out. */ 8 	  SEND_TO_Q("Wrong password... disconnecting.\r\n", d); 	  STATE(d) = CON_CLOSE;	 	} else { 1 	  SEND_TO_Q("Wrong password.\r\nPassword: ", d);  	  echo_off(d);  	} 	return;       }   !       /* Password was correct. */ .       load_result = GET_BAD_PWS(d->character);$       GET_BAD_PWS(d->character) = 0;       d->bad_pws = 0;   ,       if (isbanned(d->host) == BAN_SELECT &&, 	  !PLR_FLAGGED(d->character, PLR_SITEOK)) {U 	SEND_TO_Q("Sorry, this char has not been cleared for login from your site!\r\n", d);  	STATE(d) = CON_CLOSE;9 	sprintf(buf, "Connection attempt for %s denied from %s", # 		GET_NAME(d->character), d->host); ! 	mudlog(buf, NRM, LVL_GOD, TRUE);  	return;       } 6       if (GET_LEVEL(d->character) < circle_restrict) {K 	SEND_TO_Q("The game is temporarily restricted.. try again later.\r\n", d);  	STATE(d) = CON_CLOSE;? 	sprintf(buf, "Request for login denied for %s [%s] (wizlock)", # 		GET_NAME(d->character), d->host); ! 	mudlog(buf, NRM, LVL_GOD, TRUE);  	return;       } L       /* check and make sure no other copies of this player are logged in */        if (perform_dupe_check(d)) 	return;  0       if (GET_LEVEL(d->character) >= LVL_IMMORT) 	SEND_TO_Q(imotd, d); 
       else 	SEND_TO_Q(motd, d);  N       sprintf(buf, "%s [%s] has connected.", GET_NAME(d->character), d->host);K       mudlog(buf, BRF, MAX(LVL_IMMORT, GET_INVIS_LEV(d->character)), TRUE);          if (load_result) {$ 	sprintf(buf, "\r\n\r\n\007\007\007"< 		"%s%d LOGIN FAILURE%s SINCE LAST SUCCESSFUL LOGIN.%s\r\n",* 		CCRED(d->character, C_SPR), load_result,< 		(load_result > 1) ? "S" : "", CCNRM(d->character, C_SPR)); 	SEND_TO_Q(buf, d);  	GET_BAD_PWS(d->character) = 0;        } /       SEND_TO_Q("\r\n\n*** PRESS RETURN: ", d);        STATE(d) = CON_RMOTD;      } 
     break;     case CON_NEWPASSWD:    case CON_CHPWD_GETNEW:C     if (!*arg || strlen(arg) > MAX_PWD_LENGTH || strlen(arg) < 3 || ) 	!str_cmp(arg, GET_NAME(d->character))) { 0       SEND_TO_Q("\r\nIllegal password.\r\n", d);!       SEND_TO_Q("Password: ", d); 
       return;      } Z     strncpy(GET_PASSWD(d->character), CRYPT(arg, GET_NAME(d->character)), MAX_PWD_LENGTH);8     *(GET_PASSWD(d->character) + MAX_PWD_LENGTH) = '\0';  1     SEND_TO_Q("\r\nPlease retype password: ", d); "     if (STATE(d) == CON_NEWPASSWD)       STATE(d) = CON_CNFPASSWD;      else        STATE(d) = CON_CHPWD_VRFY;  
     break;     case CON_CNFPASSWD:    case CON_CHPWD_VRFY:O     if (strncmp(CRYPT(arg, GET_PASSWD(d->character)), GET_PASSWD(d->character),  		MAX_PWD_LENGTH)) {C       SEND_TO_Q("\r\nPasswords don't match... start over.\r\n", d); !       SEND_TO_Q("Password: ", d); $       if (STATE(d) == CON_CNFPASSWD) 	STATE(d) = CON_NEWPASSWD;
       else 	STATE(d) = CON_CHPWD_GETNEW; 
       return;      }      echo_on(d);   $     if (STATE(d) == CON_CNFPASSWD) {/       SEND_TO_Q("What is your sex (M/F)? ", d);        STATE(d) = CON_QSEX;     } else {'       save_char(d->character, NOWHERE);        echo_on(d); $       SEND_TO_Q("\r\nDone.\r\n", d);       SEND_TO_Q(MENU, d);        STATE(d) = CON_MENU;     }   
     break;  5   case CON_QSEX:		/* query sex of new user         */      switch (*arg) { 
     case 'm': 
     case 'M': *       d->character->player.sex = SEX_MALE;       break;
     case 'f': 
     case 'F': ,       d->character->player.sex = SEX_FEMALE;       break;     default:)       SEND_TO_Q("That is not a sex..\r\n"  		"What IS your sex? ", d); 
       return;      }        SEND_TO_Q(class_menu, d);       SEND_TO_Q("\r\nClass: ", d);     STATE(d) = CON_QCLASS;
     break;     case CON_QCLASS:$     load_result = parse_class(*arg);)     if (load_result == CLASS_UNDEFINED) { 9       SEND_TO_Q("\r\nThat's not a class.\r\nClass: ", d); 
       return; 
     } else,       GET_CLASS(d->character) = load_result;  '     if (GET_PFILEPOS(d->character) < 0) H       GET_PFILEPOS(d->character) = create_entry(GET_NAME(d->character));     init_char(d->character);%     save_char(d->character, NOWHERE);      SEND_TO_Q(motd, d); -     SEND_TO_Q("\r\n\n*** PRESS RETURN: ", d);      STATE(d) = CON_RMOTD;   I     sprintf(buf, "%s [%s] new player.", GET_NAME(d->character), d->host); '     mudlog(buf, NRM, LVL_IMMORT, TRUE); 
     break;  6   case CON_RMOTD:		/* read CR after printing motd   */     SEND_TO_Q(MENU, d);      STATE(d) = CON_MENU;
     break;  5   case CON_MENU:		/* get selection from main menu  */      switch (*arg) { 
     case '0': #       SEND_TO_Q("Goodbye.\r\n", d);        STATE(d) = CON_CLOSE;        break;  
     case '1':        reset_char(d->character); 2       if (PLR_FLAGGED(d->character, PLR_INVSTART))7 	GET_INVIS_LEV(d->character) = GET_LEVEL(d->character); 3       if ((load_result = Crash_load(d->character))) ! 	d->character->in_room = NOWHERE; '       save_char(d->character, NOWHERE); -       send_to_char(WELC_MESSG, d->character); *       d->character->next = character_list;$       character_list = d->character;  >       if ((load_room = GET_LOADROOM(d->character)) != NOWHERE)" 	load_room = real_room(load_room);  H       /* If char was saved with NOWHERE, or real_room above failed... */!       if (load_room == NOWHERE) { - 	if (GET_LEVEL(d->character) >= LVL_IMMORT) { # 	  load_room = r_immort_start_room; 	 	} else { # 	  load_room = r_mortal_start_room;  	}       }   0       if (PLR_FLAGGED(d->character, PLR_FROZEN))! 	load_room = r_frozen_start_room;   ,       char_to_room(d->character, load_room);I       act("$n has entered the game.", TRUE, d->character, 0, 0, TO_ROOM);          STATE(d) = CON_PLAYING; %       if (!GET_LEVEL(d->character)) {  	do_start(d->character);) 	send_to_char(START_MESSG, d->character);        } $       look_at_room(d->character, 0);,       if (has_mail(GET_IDNUM(d->character))): 	send_to_char("You have mail waiting.\r\n", d->character);5       if (load_result == 2) {	/* rented items lost */ ; 	send_to_char("\r\n\007You could not afford your rent!\r\n" B 	  "Your possesions have been donated to the Salvation Army!\r\n", 		     d->character);        }        d->has_prompt = 0;       break;  
     case '2': -       if (d->character->player.description) { * 	SEND_TO_Q("Current description:\r\n", d);0 	SEND_TO_Q(d->character->player.description, d); 	/* B 	 * Don't free this now... so that the old description gets loadedC 	 * as the current buffer in the editor.  Do setup the ABORT buffer  	 * here, however. 	 * + 	 * free(d->character->player.description); , 	 * d->character->player.description = NULL; 	 */8 	d->backstr = str_dup(d->character->player.description);       } ]       SEND_TO_Q("Enter the new text you'd like others to see when they look at you.\r\n", d); 1       SEND_TO_Q("(/s saves /h for help)\r\n", d); 1       d->str = &d->character->player.description; !       d->max_str = EXDSCR_LENGTH;        STATE(d) = CON_EXDESC;       break;  
     case '3': $       page_string(d, background, 0);       STATE(d) = CON_RMOTD;        break;  
     case '4': 4       SEND_TO_Q("\r\nEnter your old password: ", d);       echo_off(d);"       STATE(d) = CON_CHPWD_GETOLD;       break;  
     case '5': A       SEND_TO_Q("\r\nEnter your password for verification: ", d);        echo_off(d);       STATE(d) = CON_DELCNF1;        break;       default:8       SEND_TO_Q("\r\nThat's not a menu choice!\r\n", d);       SEND_TO_Q(MENU, d);        break;     }   
     break;     case CON_CHPWD_GETOLD:b     if (strncmp(CRYPT(arg, GET_PASSWD(d->character)), GET_PASSWD(d->character), MAX_PWD_LENGTH)) {       echo_on(d); 2       SEND_TO_Q("\r\nIncorrect password.\r\n", d);       SEND_TO_Q(MENU, d);        STATE(d) = CON_MENU;     } else {1       SEND_TO_Q("\r\nEnter a new password: ", d); "       STATE(d) = CON_CHPWD_GETNEW;     }      return;      case CON_DELCNF1:      echo_on(d); b     if (strncmp(CRYPT(arg, GET_PASSWD(d->character)), GET_PASSWD(d->character), MAX_PWD_LENGTH)) {2       SEND_TO_Q("\r\nIncorrect password.\r\n", d);       SEND_TO_Q(MENU, d);        STATE(d) = CON_MENU;     } else {M       SEND_TO_Q("\r\nYOU ARE ABOUT TO DELETE THIS CHARACTER PERMANENTLY.\r\n" $ 		"ARE YOU ABSOLUTELY SURE?\r\n\r\n") 		"Please type \"yes\" to confirm: ", d);        STATE(d) = CON_DELCNF2;      } 
     break;     case CON_DELCNF2: 5     if (!strcmp(arg, "yes") || !strcmp(arg, "YES")) { 2       if (PLR_FLAGGED(d->character, PLR_FROZEN)) {F 	SEND_TO_Q("You try to kill yourself, but the ice stops you.\r\n", d);0 	SEND_TO_Q("Character not deleted.\r\n\r\n", d); 	STATE(d) = CON_CLOSE; 	return;       } .       if (GET_LEVEL(d->character) < LVL_GRGOD)/ 	SET_BIT(PLR_FLAGS(d->character), PLR_DELETED); '       save_char(d->character, NOWHERE); 0       Crash_delete_file(GET_NAME(d->character));0       sprintf(buf, "Character '%s' deleted!\r\n"/ 	      "Goodbye.\r\n", GET_NAME(d->character));        SEND_TO_Q(buf, d);K       sprintf(buf, "%s (lev %d) has self-deleted.", GET_NAME(d->character),   	      GET_LEVEL(d->character));&       mudlog(buf, NRM, LVL_GOD, TRUE);       STATE(d) = CON_CLOSE; 
       return;      } else {5       SEND_TO_Q("\r\nCharacter not deleted.\r\n", d);        SEND_TO_Q(MENU, d);        STATE(d) = CON_MENU;     } 
     break;   /*	Taken care of in game_loop()    case CON_CLOSE:      close_socket(d);
     break; */  
   default:V     log("SYSERR: Nanny: illegal state of con'ness (%d) for '%s'; closing connection.",@ 	STATE(d), d->character ? GET_NAME(d->character) : "<unknown>");2     STATE(d) = CON_DISCONNECT;	/* Safest to do. */
     break;   }  } 