I /************************************************************************ "  *  OasisOLC - redit.c						v1.5	*'  *  Copyright 1996 Harvey Gilpin.					* "  *  Original author: Levork						*J  ************************************************************************/   #include "conf.h"  #include "sysdep.h"  #include "structs.h" #include "comm.h"  #include "utils.h" #include "db.h"  #include "boards.h"  #include "olc.h"  3 /* List each room saved, was used for debugging. */  #if 0  #define REDIT_LIST	1 #endif  L /*------------------------------------------------------------------------*/   /*  * External data structures.  */  extern int top_of_world; extern struct room_data *world; " extern struct obj_data *obj_proto;# extern struct char_data *mob_proto;  extern const char *room_bits[]; " extern const char *sector_types[]; extern const char *exit_bits[]; $ extern struct zone_data *zone_table;" extern sh_int r_mortal_start_room;" extern sh_int r_immort_start_room;" extern sh_int r_frozen_start_room;  extern sh_int mortal_start_room;  extern sh_int immort_start_room;  extern sh_int frozen_start_room; extern int top_of_zone_table; / extern struct descriptor_data *descriptor_list;   L /*------------------------------------------------------------------------*/   /*  * Function Prototypes  */ : void redit_disp_extradesc_menu(struct descriptor_data *d);5 void redit_disp_exit_menu(struct descriptor_data *d); : void redit_disp_exit_flag_menu(struct descriptor_data *d);5 void redit_disp_flag_menu(struct descriptor_data *d); 7 void redit_disp_sector_menu(struct descriptor_data *d); 0 void redit_disp_menu(struct descriptor_data *d);7 void redit_parse(struct descriptor_data *d, char *arg); 0 void redit_setup_new(struct descriptor_data *d);C void redit_setup_existing(struct descriptor_data *d, int real_num); " void redit_save_to_disk(int zone);6 void redit_save_internally(struct descriptor_data *d);' void free_room(struct room_data *room);   L /*------------------------------------------------------------------------*/  < #define  W_EXIT(room, num) (world[(room)].dir_option[(num)])  L /*------------------------------------------------------------------------*\   Utils and exported functions. L \*------------------------------------------------------------------------*/  / void redit_setup_new(struct descriptor_data *d)  { +   CREATE(OLC_ROOM(d), struct room_data, 1);   4   OLC_ROOM(d)->name = str_dup("An unfinished room");K   OLC_ROOM(d)->description = str_dup("You are in an unfinished room.\r\n");    redit_disp_menu(d);    OLC_VAL(d) = 0;  }   L /*------------------------------------------------------------------------*/  B void redit_setup_existing(struct descriptor_data *d, int real_num) {    struct room_data *room;    int counter;     /**    * Build a copy of the room for editing.    */ $   CREATE(room, struct room_data, 1);     *room = world[real_num];   /*$    * Allocate space for all strings.    */ R   room->name = str_dup(world[real_num].name ? world[real_num].name : "undefined");;   room->description = str_dup(world[real_num].description ? 2 			world[real_num].description : "undefined\r\n");   /*+    * Exits - We allocate only if necessary.     */ 7   for (counter = 0; counter < NUM_OF_DIRS; counter++) { .     if (world[real_num].dir_option[counter]) {G       CREATE(room->dir_option[counter], struct room_direction_data, 1);          /*        * Copy the numbers over. 	        */ H       *room->dir_option[counter] = *world[real_num].dir_option[counter];       /*        * Allocate the strings.	        */ 6       room->dir_option[counter]->general_description == 		(world[real_num].dir_option[counter]->general_description ? C 		str_dup(world[real_num].dir_option[counter]->general_description) 
 		: NULL);*       room->dir_option[counter]->keyword =1 		(world[real_num].dir_option[counter]->keyword ? @ 		str_dup(world[real_num].dir_option[counter]->keyword) : NULL);     }    }      /*&    * Extra descriptions, if necessary.    */ '   if (world[real_num].ex_description) { 1     struct extra_descr_data *this, *temp, *temp2; -     CREATE(temp, struct extra_descr_data, 1);         room->ex_description = temp;J     for (this = world[real_num].ex_description; this; this = this->next) {F       temp->keyword = (this->keyword ? str_dup(this->keyword) : NULL);R       temp->description = (this->description ? str_dup(this->description) : NULL);       if (this->next) { + 	CREATE(temp2, struct extra_descr_data, 1);  	temp->next = temp2; 	temp = temp2;       } else 	temp->next = NULL;      }    }    /*0    * Attach copy of room to player's descriptor.    */    OLC_ROOM(d) = room;    OLC_VAL(d) = 0;    redit_disp_menu(d);  }   L /*------------------------------------------------------------------------*/  + #define ZCMD (zone_table[zone].cmd[cmd_no])   5 void redit_save_internally(struct descriptor_data *d)  { .   int i, j, room_num, found = 0, zone, cmd_no;   struct room_data *new_world;   struct char_data *temp_ch;   struct obj_data *temp_obj;   struct descriptor_data *dsc;  #   room_num = real_room(OLC_NUM(d));    /*>    * Room exists: move contents over then free and replace it.    */    if (room_num > 0) { 5     OLC_ROOM(d)->contents = world[room_num].contents; 1     OLC_ROOM(d)->people = world[room_num].people;       free_room(world + room_num);#     world[room_num] = *OLC_ROOM(d); 4   } else {			/* Room doesn't exist, hafta add it. */:     CREATE(new_world, struct room_data, top_of_world + 2);       /*"      * Count through world tables.      */ )     for (i = 0; i <= top_of_world; i++) {        if (!found) {  	/*  	 * Is this the place?   	 */$ 	if (world[i].number > OLC_NUM(d)) { 	  found = TRUE;! 	  new_world[i] = *(OLC_ROOM(d)); $ 	  new_world[i].number = OLC_NUM(d); 	  new_world[i].func = NULL; 	  room_num = i;   	  /* ' 	   * Copy from world to new_world + 1.  	   */ 	  new_world[i + 1] = world[i];    	  /* ? 	   * People in this room must have their numbers moved up one.  	   */L 	  for (temp_ch = world[i].people; temp_ch; temp_ch = temp_ch->next_in_room)% 	    if (temp_ch->in_room != NOWHERE)   	      temp_ch->in_room = i + 1;   	  /*  	   * Move objects up one room.  	   */R 	  for (temp_obj = world[i].contents; temp_obj; temp_obj = temp_obj->next_content)& 	    if (temp_obj->in_room != NOWHERE)! 	      temp_obj->in_room = i + 1; 1 	} else	/* Not yet placed, copy straight over. */  	  new_world[i] = world[i]; )       } else {		/* Already been found. */  	/* 7 	 * People in this room must have their in_rooms moved.  	 */J 	for (temp_ch = world[i].people; temp_ch; temp_ch = temp_ch->next_in_room)# 	  if (temp_ch->in_room != NOWHERE)  	    temp_ch->in_room = i + 1; 	/*  	 * Move objects too.  	 */P 	for (temp_obj = world[i].contents; temp_obj; temp_obj = temp_obj->next_content) 	  if (temp_obj->in_room != -1)  	    temp_obj->in_room = i + 1;    	new_world[i + 1] = world[i];        }      } @     if (!found) {	/* Still not found, insert at top of table. */$       new_world[i] = *(OLC_ROOM(d));'       new_world[i].number = OLC_NUM(d);        new_world[i].func = NULL;        room_num = i;      }        /*(      * Copy world table over to new one.      */      free(world);     world = new_world;     top_of_world++;        /*      * Update zone table.       */ 5     for (zone = 0; zone <= top_of_zone_table; zone++) 5       for (cmd_no = 0; ZCMD.command != 'S'; cmd_no++)  	switch (ZCMD.command) {
 	case 'M':
 	case 'O': 	  if (ZCMD.arg3 >= room_num)  	    ZCMD.arg3++; 	 	  break; 
 	case 'D':
 	case 'R': 	  if (ZCMD.arg1 >= room_num)  	    ZCMD.arg1++; 
 	case 'G':
 	case 'P':
 	case 'E':
 	case '*':	 	  break; 	 	default: X 	  mudlog("SYSERR: OLC: redit_save_internally: Unknown comand", BRF, LVL_BUILDER, TRUE); 	}       /*<      * Update load rooms, to fix creeping load room problem.      */ (     if (room_num <= r_mortal_start_room)       r_mortal_start_room++;(     if (room_num <= r_immort_start_room)       r_immort_start_room++;(     if (room_num <= r_frozen_start_room)       r_frozen_start_room++;       /*      * Update world exits.      */ *     for (i = 0; i < top_of_world + 1; i++)'       for (j = 0; j < NUM_OF_DIRS; j++)  	if (W_EXIT(i, j))) 	  if (W_EXIT(i, j)->to_room >= room_num)  	    W_EXIT(i, j)->to_room++;      /*%      * Update any rooms being edited.       */ 5     for (dsc = descriptor_list; dsc; dsc = dsc->next) &       if (dsc->connected == CON_REDIT)" 	for (j = 0; j < NUM_OF_DIRS; j++)$ 	  if (OLC_ROOM(dsc)->dir_option[j]); 	    if (OLC_ROOM(dsc)->dir_option[j]->to_room >= room_num) / 	      OLC_ROOM(dsc)->dir_option[j]->to_room++;      } F   olc_add_to_save_list(zone_table[OLC_ZNUM(d)].number, OLC_SAVE_ROOM); }   L /*------------------------------------------------------------------------*/  % void redit_save_to_disk(int zone_num)  { %   int counter, counter2, realcounter;    FILE *fp;    struct room_data *room; #   struct extra_descr_data *ex_desc;   5   if (zone_num < 0 || zone_num > top_of_zone_table) { A     log("SYSERR: redit_save_to_disk: Invalid real zone passed!");      return;    }   E   sprintf(buf, "%s/%d.new", WLD_PREFIX, zone_table[zone_num].number); !   if (!(fp = fopen(buf, "w+"))) { J     mudlog("SYSERR: OLC: Cannot open room file!", BRF, LVL_BUILDER, TRUE);     return;    } 3   for (counter = zone_table[zone_num].number * 100; 8        counter <= zone_table[zone_num].top; counter++) {2     if ((realcounter = real_room(counter)) >= 0) {#       room = (world + realcounter);    #if defined(REDIT_LIST) :       sprintf(buf1, "OLC: Saving room %d.", room->number);       log(buf1); #endif         /*6        * Remove the '\r\n' sequences from description.	        */ D       strcpy(buf1, room->description ? room->description : "Empty");       strip_string(buf1);          /*?        * Forget making a buffer, lets just write the thing now. 	        */ 7       fprintf(fp, "#%d\n%s~\n%s~\n%d %d %d\n", counter, 3 	      room->name ? room->name : "undefined", buf1, % 	      zone_table[room->zone].number, , 	      room->room_flags, room->sector_type);         /*        * Handle exits.	        */ >       for (counter2 = 0; counter2 < NUM_OF_DIRS; counter2++) {" 	if (room->dir_option[counter2]) { 	  int temp_door_flag;   	  /* # 	   * Again, strip out the garbage.  	   */9 	  if (room->dir_option[counter2]->general_description) { C 	    strcpy(buf1, room->dir_option[counter2]->general_description);  	    strip_string(buf1);	 	  } else  	    *buf1 = 0;    	  /*  	   * Figure out door flag.  	   */B 	  if (IS_SET(room->dir_option[counter2]->exit_info, EX_ISDOOR)) {E 	    if (IS_SET(room->dir_option[counter2]->exit_info, EX_PICKPROOF))  	      temp_door_flag = 2;	 	    else  	      temp_door_flag = 1;	 	  } else  	    temp_door_flag = 0;   	  /*  	   * Check for keywords.  	   */+ 	  if (room->dir_option[counter2]->keyword) 7 	    strcpy(buf2, room->dir_option[counter2]->keyword);  	  else  	    *buf2 = '\0';   	  /* # 	   * Ok, now wrote output to file.  	   */A 	  fprintf(fp, "D%d\n%s~\n%s~\n%d %d %d\n", counter2, buf1, buf2, 4 		  temp_door_flag, room->dir_option[counter2]->key,/ 		  room->dir_option[counter2]->to_room != -1 ? < 		  world[room->dir_option[counter2]->to_room].number : -1); 	}       }        /*:        * Home straight, just deal with extra descriptions.	        */ !       if (room->ex_description) { I 	for (ex_desc = room->ex_description; ex_desc; ex_desc = ex_desc->next) { & 	  strcpy(buf1, ex_desc->description); 	  strip_string(buf1);8 	  fprintf(fp, "E\n%s~\n%s~\n", ex_desc->keyword, buf1); 	}       }        fprintf(fp, "S\n");      }    }    /*     * Write final line and close.    */    fprintf(fp, "$~\n");
   fclose(fp); F   sprintf(buf2, "%s/%d.wld", WLD_PREFIX, zone_table[zone_num].number);   /*;    * We're fubar'd if we crash between the two lines below.     */    remove(buf2);    rename(buf, buf2);  H   olc_remove_from_save_list(zone_table[zone_num].number, OLC_SAVE_ROOM); }   L /*------------------------------------------------------------------------*/  & void free_room(struct room_data *room) {    int i;'   struct extra_descr_data *this, *next;      if (room->name)      free(room->name);    if (room->description)     free(room->description);     /*    * Free exits.    */ %   for (i = 0; i < NUM_OF_DIRS; i++) {      if (room->dir_option[i]) {3       if (room->dir_option[i]->general_description) 0 	free(room->dir_option[i]->general_description);'       if (room->dir_option[i]->keyword) $ 	free(room->dir_option[i]->keyword);     }      free(room->dir_option[i]);   }      /*    * Free extra descriptions.     */ 8   for (this = room->ex_description; this; this = next) {     next = this->next;     if (this->keyword)       free(this->keyword);     if (this->description)       free(this->description);     free(this);    }      /* free(room); - ASAP */ }   K /**************************************************************************   Menu functions L  **************************************************************************/   /*  * For extra descriptions.  */ 9 void redit_disp_extradesc_menu(struct descriptor_data *d)  { 4   struct extra_descr_data *extra_desc = OLC_DESC(d);     sprintf(buf, #if defined(CLEAR_SCREEN)  	  "[H[J"  #endif 	  "%s1%s) Keyword: %s%s\r\n" $ 	  "%s2%s) Description:\r\n%s%s\r\n"$ 	  "%s3%s) Goto next description: ",  G 	  grn, nrm, yel, extra_desc->keyword ? extra_desc->keyword : "<NONE>", O 	  grn, nrm, yel, extra_desc->description ? extra_desc->description : "<NONE>",  	  grn, nrm  	  );   @   strcat(buf, !extra_desc->next ? "<NOT SET>\r\n" : "Set.\r\n");-   strcat(buf, "Enter choice (0 to quit) : "); "   send_to_char(buf, d->character);%   OLC_MODE(d) = REDIT_EXTRADESC_MENU;  }    /*
  * For exits.   */ 4 void redit_disp_exit_menu(struct descriptor_data *d) {    /*,    * if exit doesn't exist, alloc/create it     */    if (!OLC_EXIT(d)) 7     CREATE(OLC_EXIT(d), struct room_direction_data, 1);      /*    * Weird door handling!     */ 2   if (IS_SET(OLC_EXIT(d)->exit_info, EX_ISDOOR)) {5     if (IS_SET(OLC_EXIT(d)->exit_info, EX_PICKPROOF))         strcpy(buf2, "Pickproof");     else        strcpy(buf2, "Is a door");   } else     strcpy(buf2, "No door");     get_char_cols(d->character);   sprintf(buf, #if defined(CLEAR_SCREEN)  	  "[H[J"  #endif" 	  "%s1%s) Exit to     : %s%d\r\n"& 	  "%s2%s) Description :-\r\n%s%s\r\n"" 	  "%s3%s) Door name   : %s%s\r\n"" 	  "%s4%s) Key         : %s%d\r\n"" 	  "%s5%s) Door flags  : %s%s\r\n" 	  "%s6%s) Purge exit.\r\n"   	  "Enter choice, 0 to quit : ",  W 	  grn, nrm, cyn, OLC_EXIT(d)->to_room != -1 ? world[OLC_EXIT(d)->to_room].number : -1, a 	  grn, nrm, yel, OLC_EXIT(d)->general_description ? OLC_EXIT(d)->general_description : "<NONE>", I 	  grn, nrm, yel, OLC_EXIT(d)->keyword ? OLC_EXIT(d)->keyword : "<NONE>", # 	  grn, nrm, cyn, OLC_EXIT(d)->key,   	  grn, nrm, cyn, buf2, grn, nrm 	  );   "   send_to_char(buf, d->character);    OLC_MODE(d) = REDIT_EXIT_MENU; }    /*  * For exit flags.  */ 9 void redit_disp_exit_flag_menu(struct descriptor_data *d)  {    get_char_cols(d->character);#   sprintf(buf, "%s0%s) No door\r\n"  	  "%s1%s) Closeable door\r\n" 	  "%s2%s) Pickproof\r\n" 4 	  "Enter choice : ", grn, nrm, grn, nrm, grn, nrm);"   send_to_char(buf, d->character); }    /*  * For room flags.  */ 4 void redit_disp_flag_menu(struct descriptor_data *d) {    int counter, columns = 0;      get_char_cols(d->character); #if defined(CLEAR_SCREEN) '   send_to_char("[H[J", d->character);  #endif:   for (counter = 0; counter < NUM_ROOM_FLAGS; counter++) {?     sprintf(buf, "%s%2d%s) %-20.20s %s", grn, counter + 1, nrm, 6 		room_bits[counter], !(++columns % 2) ? "\r\n" : "");$     send_to_char(buf, d->character);   } 6   sprintbit(OLC_ROOM(d)->room_flags, room_bits, buf1);+   sprintf(buf, "\r\nRoom flags: %s%s%s\r\n" 5 	  "Enter room flags, 0 to quit : ", cyn, buf1, nrm); "   send_to_char(buf, d->character);   OLC_MODE(d) = REDIT_FLAGS; }    /*  * For sector type.   */ 6 void redit_disp_sector_menu(struct descriptor_data *d) {    int counter, columns = 0;    #if defined(CLEAR_SCREEN) '   send_to_char("[H[J", d->character);  #endif<   for (counter = 0; counter < NUM_ROOM_SECTORS; counter++) {;     sprintf(buf, "%s%2d%s) %-20.20s %s", grn, counter, nrm, 9 		sector_types[counter], !(++columns % 2) ? "\r\n" : ""); $     send_to_char(buf, d->character);   } 9   send_to_char("\r\nEnter sector type : ", d->character);    OLC_MODE(d) = REDIT_SECTOR;  }    /*  * The main menu.   */ / void redit_disp_menu(struct descriptor_data *d)  {    struct room_data *room;      get_char_cols(d->character);   room = OLC_ROOM(d);   5   sprintbit((long)room->room_flags, room_bits, buf1); 4   sprinttype(room->sector_type, sector_types, buf2);   sprintf(buf, #if defined(CLEAR_SCREEN)  	  "[H[J"  #endif8 	  "-- Room number : [%s%d%s]  	Room zone: [%s%d%s]\r\n"" 	  "%s1%s) Name        : %s%s\r\n"! 	  "%s2%s) Description :\r\n%s%s" " 	  "%s3%s) Room flags  : %s%s\r\n"" 	  "%s4%s) Sector type : %s%s\r\n"" 	  "%s5%s) Exit north  : %s%d\r\n"" 	  "%s6%s) Exit east   : %s%d\r\n"" 	  "%s7%s) Exit south  : %s%d\r\n"" 	  "%s8%s) Exit west   : %s%d\r\n"" 	  "%s9%s) Exit up     : %s%d\r\n"" 	  "%sA%s) Exit down   : %s%d\r\n"' 	  "%sB%s) Extra descriptions menu\r\n"  	  "%sQ%s) Quit\r\n" 	  "Enter choice : ",    	  cyn, OLC_NUM(d), nrm,, 	  cyn, zone_table[OLC_ZNUM(d)].number, nrm, 	  grn, nrm, yel, room->name, $ 	  grn, nrm, yel, room->description, 	  grn, nrm, cyn, buf1,  	  grn, nrm, cyn, buf2,  	  grn, nrm, cyn, F 	  room->dir_option[NORTH] && room->dir_option[NORTH]->to_room != -1 ?7 	  world[room->dir_option[NORTH]->to_room].number : -1,  	  grn, nrm, cyn, D 	  room->dir_option[EAST] && room->dir_option[EAST]->to_room != -1 ?6 	  world[room->dir_option[EAST]->to_room].number : -1, 	  grn, nrm, cyn, F 	  room->dir_option[SOUTH] && room->dir_option[SOUTH]->to_room != -1 ?7 	  world[room->dir_option[SOUTH]->to_room].number : -1,  	  grn, nrm, cyn, D 	  room->dir_option[WEST] && room->dir_option[WEST]->to_room != -1 ?6 	  world[room->dir_option[WEST]->to_room].number : -1, 	  grn, nrm, cyn, A 	  room->dir_option[UP] && room->dir_option[UP]->to_room != -1 ?  4 	  world[room->dir_option[UP]->to_room].number : -1, 	  grn, nrm, cyn, D 	  room->dir_option[DOWN] && room->dir_option[DOWN]->to_room != -1 ?6 	  world[room->dir_option[DOWN]->to_room].number : -1, 	  grn, nrm, grn, nrm  	  ); "   send_to_char(buf, d->character);      OLC_MODE(d) = REDIT_MAIN_MENU; }   K /**************************************************************************    The main loop L  **************************************************************************/  6 void redit_parse(struct descriptor_data *d, char *arg) { !   extern struct room_data *world; 
   int number;      switch (OLC_MODE(d)) {    case REDIT_CONFIRM_SAVESTRING:     switch (*arg) { 
     case 'y': 
     case 'Y':        redit_save_internally(d); Q       sprintf(buf, "OLC: %s edits room %d.", GET_NAME(d->character), OLC_NUM(d)); L       mudlog(buf, CMP, MAX(LVL_BUILDER, GET_INVIS_LEV(d->character)), TRUE);       /*7        * Do NOT free strings! Just the room structure.  	        */ &       cleanup_olc(d, CLEANUP_STRUCTS);>       send_to_char("Room saved to memory.\r\n", d->character);       break;
     case 'n': 
     case 'N':        /*4        * Free everything up, including strings, etc.	        */ "       cleanup_olc(d, CLEANUP_ALL);       break;     default:d       send_to_char("Invalid choice!\r\nDo you wish to save this room internally? : ", d->character);       break;     }      return;      case REDIT_MAIN_MENU:      switch (*arg) { 
     case 'q': 
     case 'Q': :       if (OLC_VAL(d)) { /* Something has been modified. */L 	send_to_char("Do you wish to save this room internally? : ", d->character);( 	OLC_MODE(d) = REDIT_CONFIRM_SAVESTRING;       } else 	cleanup_olc(d, CLEANUP_ALL); 
       return; 
     case '1': <       send_to_char("Enter room name:-\r\n] ", d->character);       OLC_MODE(d) = REDIT_NAME;        break;
     case '2':        OLC_MODE(d) = REDIT_DESC;  #if defined(CLEAR_SCREEN) #       SEND_TO_Q("\x1B[H\x1B[J", d);  #endifM       SEND_TO_Q("Enter room description: (/s saves /h for help)\r\n\r\n", d);        d->backstr = NULL;%       if (OLC_ROOM(d)->description) { ( 	SEND_TO_Q(OLC_ROOM(d)->description, d);0 	d->backstr = str_dup(OLC_ROOM(d)->description);       } )       d->str = &OLC_ROOM(d)->description; !       d->max_str = MAX_ROOM_DESC;        d->mail_to = 0;        OLC_VAL(d) = 1;        break;
     case '3':        redit_disp_flag_menu(d);       break;
     case '4':         redit_disp_sector_menu(d);       break;
     case '5':        OLC_VAL(d) = NORTH;        redit_disp_exit_menu(d);       break;
     case '6':        OLC_VAL(d) = EAST;       redit_disp_exit_menu(d);       break;
     case '7':        OLC_VAL(d) = SOUTH;        redit_disp_exit_menu(d);       break;
     case '8':        OLC_VAL(d) = WEST;       redit_disp_exit_menu(d);       break;
     case '9':        OLC_VAL(d) = UP;       redit_disp_exit_menu(d);       break;
     case 'a': 
     case 'A':        OLC_VAL(d) = DOWN;       redit_disp_exit_menu(d);       break;
     case 'b': 
     case 'B':        /*0        * If the extra description doesn't exist.	        */ )       if (!OLC_ROOM(d)->ex_description) { A 	CREATE(OLC_ROOM(d)->ex_description, struct extra_descr_data, 1); * 	OLC_ROOM(d)->ex_description->next = NULL;       } 0       OLC_DESC(d) = OLC_ROOM(d)->ex_description;#       redit_disp_extradesc_menu(d);        break;     default:4       send_to_char("Invalid choice!", d->character);       redit_disp_menu(d);        break;     }      return;      case REDIT_NAME:     if (OLC_ROOM(d)->name)       free(OLC_ROOM(d)->name);$     if (strlen(arg) > MAX_ROOM_NAME)$       arg[MAX_ROOM_NAME - 1] = '\0';C     OLC_ROOM(d)->name = str_dup((arg && *arg) ? arg : "undefined"); 
     break;     case REDIT_DESC:     /*'      * We will NEVER get here, we hope.       */ U     mudlog("SYSERR: Reached REDIT_DESC case in parse_redit", BRF, LVL_BUILDER, TRUE); 
     break;     case REDIT_FLAGS:      number = atoi(arg); 4     if ((number < 0) || (number > NUM_ROOM_FLAGS)) {D       send_to_char("That is not a valid choice!\r\n", d->character);       redit_disp_flag_menu(d);     } else if (number == 0)  	break; 
     else {       /*        * Toggle the bit.	        */ =       TOGGLE_BIT(OLC_ROOM(d)->room_flags, 1 << (number - 1));        redit_disp_flag_menu(d);     }      return;      case REDIT_SECTOR:     number = atoi(arg); 3     if (number < 0 || number >= NUM_ROOM_SECTORS) { 4       send_to_char("Invalid choice!", d->character);        redit_disp_sector_menu(d);
       return; 
     } else(       OLC_ROOM(d)->sector_type = number;
     break;     case REDIT_EXIT_MENU:      switch (*arg) { 
     case '0':        break;
     case '1': &       OLC_MODE(d) = REDIT_EXIT_NUMBER;;       send_to_char("Exit to room number : ", d->character); 
       return; 
     case '2': +       OLC_MODE(d) = REDIT_EXIT_DESCRIPTION; M       SEND_TO_Q("Enter exit description: (/s saves /h for help)\r\n\r\n", d);        d->backstr = NULL;-       if (OLC_EXIT(d)->general_description) { 0 	SEND_TO_Q(OLC_EXIT(d)->general_description, d);8 	d->backstr = str_dup(OLC_EXIT(d)->general_description);       } 1       d->str = &OLC_EXIT(d)->general_description; !       d->max_str = MAX_EXIT_DESC;        d->mail_to = 0; 
       return; 
     case '3': '       OLC_MODE(d) = REDIT_EXIT_KEYWORD; 6       send_to_char("Enter keywords : ", d->character);
       return; 
     case '4': #       OLC_MODE(d) = REDIT_EXIT_KEY; 8       send_to_char("Enter key number : ", d->character);
       return; 
     case '5': #       redit_disp_exit_flag_menu(d); )       OLC_MODE(d) = REDIT_EXIT_DOORFLAGS; 
       return; 
     case '6':        /*        * Delete an exit.	        */        if (OLC_EXIT(d)->keyword)  	free(OLC_EXIT(d)->keyword);+       if (OLC_EXIT(d)->general_description) ( 	free(OLC_EXIT(d)->general_description);       if (OLC_EXIT(d)) 	free(OLC_EXIT(d));        OLC_EXIT(d) = NULL;        break;     default:1       send_to_char("Try again : ", d->character); 
       return;      } 
     break;     case REDIT_EXIT_NUMBER: #     if ((number = atoi(arg)) != -1) -       if ((number = real_room(number)) < 0) { F 	send_to_char("That room does not exist, try again : ", d->character); 	return;       } "     OLC_EXIT(d)->to_room = number;     redit_disp_exit_menu(d);     return;      case REDIT_EXIT_DESCRIPTION:     /*+      * We should NEVER get here, hopefully.       */ Z     mudlog("SYSERR: Reached REDIT_EXIT_DESC case in parse_redit", BRF, LVL_BUILDER, TRUE);
     break;     case REDIT_EXIT_KEYWORD:     if (OLC_EXIT(d)->keyword) !       free(OLC_EXIT(d)->keyword); A     OLC_EXIT(d)->keyword = ((arg && *arg) ? str_dup(arg) : NULL);      redit_disp_exit_menu(d);     return;      case REDIT_EXIT_KEY:!     OLC_EXIT(d)->key = atoi(arg);      redit_disp_exit_menu(d);     return;      case REDIT_EXIT_DOORFLAGS:     number = atoi(arg); '     if ((number < 0) || (number > 2)) { C       send_to_char("That's not a valid choice!\r\n", d->character); #       redit_disp_exit_flag_menu(d);      } else {       /*>        * Doors are a bit idiotic, don't you think? :) I agree.	        */ 1       OLC_EXIT(d)->exit_info = (number == 0 ? 0 :  				(number == 1 ? EX_ISDOOR :3 				(number == 2 ? EX_ISDOOR | EX_PICKPROOF : 0)));        /*&        * Jump back to the menu system.	        */        redit_disp_exit_menu(d);     }      return;      case REDIT_EXTRADESC_KEY: A     OLC_DESC(d)->keyword = ((arg && *arg) ? str_dup(arg) : NULL); !     redit_disp_extradesc_menu(d);      return;      case REDIT_EXTRADESC_MENU:#     switch ((number = atoi(arg))) {      case 0:        {  	/* ; 	 * If something got left out, delete the extra description ! 	 * when backing out to the menu.  	 */: 	if (!OLC_DESC(d)->keyword || !OLC_DESC(d)->description) {& 	  struct extra_descr_data **tmp_desc;   	  if (OLC_DESC(d)->keyword)  	    free(OLC_DESC(d)->keyword);  	  if (OLC_DESC(d)->description)$ 	    free(OLC_DESC(d)->description);   	  /*  	   * Clean up pointers. 	   */= 	  for (tmp_desc = &(OLC_ROOM(d)->ex_description); *tmp_desc; ( 	       tmp_desc = &((*tmp_desc)->next))$ 	    if (*tmp_desc == OLC_DESC(d)) { 	      *tmp_desc = NULL;
 	      break;  	    } 	  free(OLC_DESC(d));  	}       }        break;     case 1: (       OLC_MODE(d) = REDIT_EXTRADESC_KEY;K       send_to_char("Enter keywords, separated by spaces : ", d->character); 
       return;      case 2: 0       OLC_MODE(d) = REDIT_EXTRADESC_DESCRIPTION;N       SEND_TO_Q("Enter extra description: (/s saves /h for help)\r\n\r\n", d);       d->backstr = NULL;%       if (OLC_DESC(d)->description) { ( 	SEND_TO_Q(OLC_DESC(d)->description, d);0 	d->backstr = str_dup(OLC_DESC(d)->description);       } )       d->str = &OLC_DESC(d)->description; &       d->max_str = MAX_MESSAGE_LENGTH;       d->mail_to = 0; 
       return;        case 3: ?       if (!OLC_DESC(d)->keyword || !OLC_DESC(d)->description) { c 	send_to_char("You can't edit the next extra desc without completing this one.\r\n", d->character);  	redit_disp_extradesc_menu(d);       } else {$ 	struct extra_descr_data *new_extra;   	if (OLC_DESC(d)->next) # 	  OLC_DESC(d) = OLC_DESC(d)->next;  	else {  	  /* 3 	   * Make new extra description and attach at end.  	   */1 	  CREATE(new_extra, struct extra_descr_data, 1); ! 	  OLC_DESC(d)->next = new_extra;  	  OLC_DESC(d) = new_extra;  	} 	redit_disp_extradesc_menu(d);       } 
       return;      } 
     break;  
   default:     /*       * We should never get here.      */ R     mudlog("SYSERR: Reached default case in parse_redit", BRF, LVL_BUILDER, TRUE);
     break;   }    /*4    * If we get this far, something has been changed.    */    OLC_VAL(d) = 1;    redit_disp_menu(d);  } 