K /* ************************************************************************ K *   File: shop.c                                        Part of CircleMUD * K *  Usage: shopkeepers: loading config files, spec procs.                  * K *                                                                         * K *  All rights reserved.  See license.doc for complete information.        * K *                                                                         * K *  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University * K *  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               * K ************************************************************************ */    /***N  * The entire shop rewrite for Circle 3.0 was done by Jeff Fink.  Thanks Jeff!  ***/    #define __SHOP_C__   #include "conf.h"  #include "sysdep.h"    #include "structs.h" #include "comm.h"  #include "handler.h" #include "db.h"  #include "interpreter.h" #include "utils.h" #include "shop.h"      /* External variables */ /*								*/B /* This following fixes fome "confliction psect" link messages. */B /* Since str_app[], *drinks[], *item_types[] and *extra bits[]  */B /* are defined in "constants.h", let's use that instead.        */ /*								*/, #if defined(CIRCLE_VMS) && defined(__GNUC__) #  include "constants.h" #else (    extern struct str_app_type str_app[];    extern char *drinks[];     extern char *item_types[];     extern char *extra_bits[];  #endif  $ extern struct index_data *mob_index;$ extern struct index_data *obj_index;# extern struct char_data *mob_proto; " extern struct obj_data *obj_proto; extern struct room_data *world; ' extern struct time_info_data time_info;  extern int top_of_world;  , /* Forward/External function declarations */ ACMD(do_tell); ACMD(do_action); ACMD(do_echo);
 ACMD(do_say); > void sort_keeper_objs(struct char_data * keeper, int shop_nr);   /* Local variables */  struct shop_data *shop_index;  int top_shop = 0; 5 int cmd_say, cmd_tell, cmd_emote, cmd_slap, cmd_puke;    /* local functions */ X int read_type_list(FILE * shop_f, struct shop_buy_data * list, int new_format, int max);] int read_list(FILE * shop_f, struct shop_buy_data * list, int new_format, int max, int type); ] void shopping_list(char *arg, struct char_data * ch, struct char_data * keeper, int shop_nr); ^ void shopping_value(char *arg, struct char_data * ch, struct char_data * keeper, int shop_nr);] void shopping_sell(char *arg, struct char_data * ch, struct char_data * keeper, int shop_nr); u struct obj_data *get_selling_obj(struct char_data * ch, char *name, struct char_data * keeper, int shop_nr, int msg); Z struct obj_data *slide_obj(struct obj_data * obj, struct char_data * keeper, int shop_nr);\ void shopping_buy(char *arg, struct char_data * ch, struct char_data * keeper, int shop_nr);u struct obj_data *get_purchase_obj(struct char_data * ch, char *arg, struct char_data * keeper, int shop_nr, int msg); ] struct obj_data *get_hash_obj_vis(struct char_data * ch, char *name, struct obj_data * list); ^ struct obj_data *get_slide_obj_vis(struct char_data * ch, char *name, struct obj_data * list);B void boot_the_shops(FILE * shop_f, char *filename, int rec_count);" void assign_the_shopkeepers(void);1 char *customer_string(int shop_nr, int detailed); + void list_all_shops(struct char_data * ch); H void handle_detailed_list(char *buf, char *buf1, struct char_data * ch);< void list_detailed_shop(struct char_data * ch, int shop_nr);2 void show_shops(struct char_data * ch, char *arg);N int is_ok_char(struct char_data * keeper, struct char_data * ch, int shop_nr);= int is_open(struct char_data * keeper, int shop_nr, int msg); I int is_ok(struct char_data * keeper, struct char_data * ch, int shop_nr); 2 void push(struct stack_data * stack, int pushval);# int top(struct stack_data * stack); # int pop(struct stack_data * stack); K void evaluate_operation(struct stack_data * ops, struct stack_data * vals);  int find_oper_num(char token);; int evaluate_expression(struct obj_data * obj, char *expr); 4 int trade_with(struct obj_data * item, int shop_nr);= int same_obj(struct obj_data * obj1, struct obj_data * obj2); 8 int shop_producing(struct obj_data * item, int shop_nr); int transaction_amt(char *arg); @ char *times_message(struct obj_data * obj, char *name, int num);2 int buy_price(struct obj_data * obj, int shop_nr);J int sell_price(struct char_data * ch, struct obj_data * obj, int shop_nr);J char *list_object(struct obj_data * obj, int cnt, int index, int shop_nr);( int ok_shop_room(int shop_nr, int room); SPECIAL(shop_keeper); K int ok_damage_shopkeeper(struct char_data * ch, struct char_data * victim); K int add_to_list(struct shop_buy_data * list, int type, int *len, int *val); C int end_read_list(struct shop_buy_data * list, int len, int error); > void read_line(FILE * shop_f, const char *string, void *data);     /* config arrays */  const char *operator_str[] = {         "[({",         "])}",
         "|+", 
         "&*",          "^'" } ;   3 /* Constant list for printing out who we sell to */  const char *trade_letters[] = { E         "Good",                 /* First, the alignment based ones */          "Evil",          "Neutral",?         "Magic User",           /* Then the class based ones */          "Cleric",          "Thief",         "Warrior",         "\n" };     const char *shop_bits[] = {          "WILL_FIGHT",          "USES_BANK",         "\n" };  M int is_ok_char(struct char_data * keeper, struct char_data * ch, int shop_nr)  {    char buf[200];     if (!(CAN_SEE(keeper, ch))) { 0     do_say(keeper, MSG_NO_SEE_CHAR, cmd_say, 0);     return (FALSE);    }    if (IS_GOD(ch))      return (TRUE);  /   if ((IS_GOOD(ch) && NOTRADE_GOOD(shop_nr)) || /       (IS_EVIL(ch) && NOTRADE_EVIL(shop_nr)) || 5       (IS_NEUTRAL(ch) && NOTRADE_NEUTRAL(shop_nr))) { ;     sprintf(buf, "%s %s", GET_NAME(ch), MSG_NO_SELL_ALIGN); &     do_tell(keeper, buf, cmd_tell, 0);     return (FALSE);    }    if (IS_NPC(ch))      return (TRUE);  ;   if ((IS_MAGIC_USER(ch) && NOTRADE_MAGIC_USER(shop_nr)) || 3       (IS_CLERIC(ch) && NOTRADE_CLERIC(shop_nr)) || 1       (IS_THIEF(ch) && NOTRADE_THIEF(shop_nr)) || 5       (IS_WARRIOR(ch) && NOTRADE_WARRIOR(shop_nr))) { ;     sprintf(buf, "%s %s", GET_NAME(ch), MSG_NO_SELL_CLASS); &     do_tell(keeper, buf, cmd_tell, 0);     return (FALSE);    }    return (TRUE); }     < int is_open(struct char_data * keeper, int shop_nr, int msg) {    char buf[200];     *buf = 0; ,   if (SHOP_OPEN1(shop_nr) > time_info.hours)"     strcpy(buf, MSG_NOT_OPEN_YET);4   else if (SHOP_CLOSE1(shop_nr) < time_info.hours) {.     if (SHOP_OPEN2(shop_nr) > time_info.hours)&       strcpy(buf, MSG_NOT_REOPEN_YET);4     else if (SHOP_CLOSE2(shop_nr) < time_info.hours)&       strcpy(buf, MSG_CLOSED_FOR_DAY);   }    if (!(*buf))     return (TRUE);
   if (msg)%     do_say(keeper, buf, cmd_tell, 0);    return (FALSE);  }     H int is_ok(struct char_data * keeper, struct char_data * ch, int shop_nr) { %   if (is_open(keeper, shop_nr, TRUE)) -     return (is_ok_char(keeper, ch, shop_nr));    else     return (FALSE);  }     1 void push(struct stack_data * stack, int pushval)  { *   S_DATA(stack, S_LEN(stack)++) = pushval; }     " int top(struct stack_data * stack) {    if (S_LEN(stack) > 0) -     return (S_DATA(stack, S_LEN(stack) - 1));    else     return (NOTHING);  }     " int pop(struct stack_data * stack) {    if (S_LEN(stack) > 0) +     return (S_DATA(stack, --S_LEN(stack)));    else {E     log("Illegal expression %d in shop keyword list.", S_LEN(stack));      return (0);    }  }     J void evaluate_operation(struct stack_data * ops, struct stack_data * vals) {    int oper;   $   if ((oper = pop(ops)) == OPER_NOT)     push(vals, !pop(vals));    else if (oper == OPER_AND)'     push(vals, pop(vals) && pop(vals));    else if (oper == OPER_OR) '     push(vals, pop(vals) || pop(vals));  }      int find_oper_num(char token)  {    int index;  -   for (index = 0; index <= MAX_OPER; index++) +     if (strchr(operator_str[index], token))        return (index);    return (NOTHING);  }     : int evaluate_expression(struct obj_data * obj, char *expr) {    struct stack_data ops, vals;   char *ptr, *end, name[200];    int temp, index;     if (!expr)     return TRUE;     if (!isalpha(*expr))
 	return TRUE;      ops.len = vals.len = 0; 
   ptr = expr;    while (*ptr) {     if (isspace(*ptr))       ptr++;
     else {4       if ((temp = find_oper_num(*ptr)) == NOTHING) { 	end = ptr; C 	while (*ptr && !isspace(*ptr) && (find_oper_num(*ptr) == NOTHING)) 	 	  ptr++;  	strncpy(name, end, ptr - end);  	name[ptr - end] = 0; 5 	for (index = 0; *extra_bits[index] != '\n'; index++) + 	  if (!str_cmp(name, extra_bits[index])) { 9 	    push(&vals, IS_SET(GET_OBJ_EXTRA(obj), 1 << index));  	    break;  	  }  	if (*extra_bits[index] == '\n')( 	  push(&vals, isname(name, obj->name));       } else { 	if (temp != OPER_OPEN_PAREN)  	  while (top(&ops) > temp) % 	    evaluate_operation(&ops, &vals);     	if (temp == OPER_CLOSE_PAREN) {/ 	  if ((temp = pop(&ops)) != OPER_OPEN_PAREN) { < 	    log("Illegal parenthesis in shop keyword expression."); 	    return (FALSE); 	  } 	} else  	  push(&ops, temp); 	ptr++;        }      }    }    while (top(&ops) != NOTHING)$     evaluate_operation(&ops, &vals);   temp = pop(&vals);   if (top(&vals) != NOTHING) {A     log("Extra operands left on shop keyword expression stack.");      return (FALSE);    }    return (temp); }     3 int trade_with(struct obj_data * item, int shop_nr)  {    int counter;     if (GET_OBJ_COST(item) < 1)      return (OBJECT_NOVAL);  %   if (IS_OBJ_STAT(item, ITEM_NOSELL))      return (OBJECT_NOTOK);  I   for (counter = 0; SHOP_BUYTYPE(shop_nr, counter) != NOTHING; counter++) ?     if (SHOP_BUYTYPE(shop_nr, counter) == GET_OBJ_TYPE(item)) { (       if ((GET_OBJ_VAL(item, 2) == 0) &&( 	  ((GET_OBJ_TYPE(item) == ITEM_WAND) ||( 	   (GET_OBJ_TYPE(item) == ITEM_STAFF))) 	return (OBJECT_DEAD);I       else if (evaluate_expression(item, SHOP_BUYWORD(shop_nr, counter)))  	return (OBJECT_OK);     }    return (OBJECT_NOTOK); }     < int same_obj(struct obj_data * obj1, struct obj_data * obj2) {    int index;     if (!obj1 || !obj2)      return (obj1 == obj2);  /   if (GET_OBJ_RNUM(obj1) != GET_OBJ_RNUM(obj2))      return (FALSE);   /   if (GET_OBJ_COST(obj1) != GET_OBJ_COST(obj2))      return (FALSE);   1   if (GET_OBJ_EXTRA(obj1) != GET_OBJ_EXTRA(obj2))      return (FALSE);   2   for (index = 0; index < MAX_OBJ_AFFECT; index++)M     if ((obj1->affected[index].location != obj2->affected[index].location) || D 	(obj1->affected[index].modifier != obj2->affected[index].modifier))       return (FALSE);      return (TRUE); }     7 int shop_producing(struct obj_data * item, int shop_nr)  {    int counter;     if (GET_OBJ_RNUM(item) < 0)      return (FALSE);   I   for (counter = 0; SHOP_PRODUCT(shop_nr, counter) != NOTHING; counter++) C     if (same_obj(item, &obj_proto[SHOP_PRODUCT(shop_nr, counter)]))        return (TRUE);   return (FALSE);  }      int transaction_amt(char *arg) { 
   int num;     one_argument(arg, buf);    if (*buf)      if ((is_number(buf))) {        num = atoi(buf);)       strcpy(arg, arg + strlen(buf) + 1);        return (num);      } 
   return (1);  }     ? char *times_message(struct obj_data * obj, char *name, int num)  {    static char buf[256];    char *ptr;  
   if (obj)(     strcpy(buf, obj->short_description);   else {*     if ((ptr = strchr(name, '.')) == NULL)       ptr = name;      else       ptr++;(     sprintf(buf, "%s %s", AN(ptr), ptr);   }      if (num > 1))     sprintf(END_OF(buf), " (x %d)", num);    return (buf);  }     E struct obj_data *get_slide_obj_vis(struct char_data * ch, char *name, ' 				            struct obj_data * list)  { &   struct obj_data *i, *last_match = 0;   int j, number;!   char tmpname[MAX_INPUT_LENGTH];    char *tmp;     strcpy(tmpname, name);   tmp = tmpname;#   if (!(number = get_number(&tmp)))      return (0);   @   for (i = list, j = 1; i && (j <= number); i = i->next_content)     if (isname(tmp, i->name)) ;       if (CAN_SEE_OBJ(ch, i) && !same_obj(last_match, i)) {  	if (j == number)  	  return (i); 	last_match = i; 	j++;        } 
   return (0);  }     D struct obj_data *get_hash_obj_vis(struct char_data * ch, char *name,& 				           struct obj_data * list) { '   struct obj_data *loop, *last_obj = 0;    int index;     if ((is_number(name + 1)))     index = atoi(name + 1);    else     return (0);   4   for (loop = list; loop; loop = loop->next_content)<     if (CAN_SEE_OBJ(ch, loop) && (loop->obj_flags.cost > 0))&       if (!same_obj(last_obj, loop)) { 	if (--index == 0) 	  return (loop);  	last_obj = loop;        } 
   return (0);  }     C struct obj_data *get_purchase_obj(struct char_data * ch, char *arg, > 		            struct char_data * keeper, int shop_nr, int msg) { 6   char buf[MAX_STRING_LENGTH], name[MAX_INPUT_LENGTH];   struct obj_data *obj;      one_argument(arg, name);   do {     if (*name == '#') 9       obj = get_hash_obj_vis(ch, name, keeper->carrying);      else:       obj = get_slide_obj_vis(ch, name, keeper->carrying);     if (!obj) {        if (msg) {? 	sprintf(buf, shop_index[shop_nr].no_such_item1, GET_NAME(ch)); # 	do_tell(keeper, buf, cmd_tell, 0);        }        return (0);      } !     if (GET_OBJ_COST(obj) <= 0) {        extract_obj(obj);        obj = 0;     }    } while (!obj);    return (obj);  }     1 int buy_price(struct obj_data * obj, int shop_nr)  { ?   return ((int) (GET_OBJ_COST(obj) * SHOP_BUYPROFIT(shop_nr)));  }     3 void shopping_buy(char *arg, struct char_data * ch, 0 		       struct char_data * keeper, int shop_nr) { ,   char tempstr[200], buf[MAX_STRING_LENGTH];)   struct obj_data *obj, *last_obj = NULL; &   int goldamt = 0, buynum, bought = 0;  $   if (!(is_ok(keeper, ch, shop_nr)))     return;   1   if (SHOP_SORT(shop_nr) < IS_CARRYING_N(keeper)) &     sort_keeper_objs(keeper, shop_nr);  ,   if ((buynum = transaction_amt(arg)) < 0) {D     sprintf(buf, "%s A negative amount?  Try selling me something.", 	    GET_NAME(ch)); &     do_tell(keeper, buf, cmd_tell, 0);     return;    }    if (!(*arg) || !(buynum)) { ?     sprintf(buf, "%s What do you want to buy??", GET_NAME(ch)); &     do_tell(keeper, buf, cmd_tell, 0);     return;    } @   if (!(obj = get_purchase_obj(ch, arg, keeper, shop_nr, TRUE)))     return;   @   if ((buy_price(obj, shop_nr) > GET_GOLD(ch)) && !IS_GOD(ch)) {B     sprintf(buf, shop_index[shop_nr].missing_cash2, GET_NAME(ch));&     do_tell(keeper, buf, cmd_tell, 0);  )     switch (SHOP_BROKE_TEMPER(shop_nr)) {      case 0: 3       do_action(keeper, GET_NAME(ch), cmd_puke, 0); 
       return;      case 1: E       do_echo(keeper, "smokes on his joint.", cmd_emote, SCMD_EMOTE); 
       return;      default:
       return;      }    } 2   if ((IS_CARRYING_N(ch) + 1 > CAN_CARRY_N(ch))) {;     sprintf(buf, "%s: You can't carry any more items.\r\n",  	    fname(obj->name));      send_to_char(buf, ch);     return;    } D   if ((IS_CARRYING_W(ch) + GET_OBJ_WEIGHT(obj)) > CAN_CARRY_W(ch)) {=     sprintf(buf, "%s: You can't carry that much weight.\r\n",  	    fname(obj->name));      send_to_char(buf, ch);     return;    } K   while ((obj) && ((GET_GOLD(ch) >= buy_price(obj, shop_nr)) || IS_GOD(ch)) ? 	 && (IS_CARRYING_N(ch) < CAN_CARRY_N(ch)) && (bought < buynum) D 	 && (IS_CARRYING_W(ch) + GET_OBJ_WEIGHT(obj) <= CAN_CARRY_W(ch))) {
     bought++; "     /* Test if producing shop ! */%     if (shop_producing(obj, shop_nr)) 1       obj = read_object(GET_OBJ_RNUM(obj), REAL); 
     else {       obj_from_char(obj);        SHOP_SORT(shop_nr)--;      }      obj_to_char(obj, ch);   '     goldamt += buy_price(obj, shop_nr);      if (!IS_GOD(ch)).       GET_GOLD(ch) -= buy_price(obj, shop_nr);       last_obj = obj; <     obj = get_purchase_obj(ch, arg, keeper, shop_nr, FALSE);!     if (!same_obj(obj, last_obj))        break;   }      if (bought < buynum) {)     if (!obj || !same_obj(last_obj, obj)) K       sprintf(buf, "%s I only have %d to sell you.", GET_NAME(ch), bought); 4     else if (GET_GOLD(ch) < buy_price(obj, shop_nr))G       sprintf(buf, "%s You can only afford %d.", GET_NAME(ch), bought); 2     else if (IS_CARRYING_N(ch) >= CAN_CARRY_N(ch))E       sprintf(buf, "%s You can only hold %d.", GET_NAME(ch), bought); G     else if (IS_CARRYING_W(ch) + GET_OBJ_WEIGHT(obj) > CAN_CARRY_W(ch)) F       sprintf(buf, "%s You can only carry %d.", GET_NAME(ch), bought);     elseI       sprintf(buf, "%s Something screwy only gave you %d.", GET_NAME(ch),  	      bought);C&     do_tell(keeper, buf, cmd_tell, 0);   }J   if (!IS_GOD(ch))      GET_GOLD(keeper) += goldamt;  ;   sprintf(tempstr, times_message(ch->carrying, 0, bought));*'   sprintf(buf, "$n buys %s.", tempstr);*'   act(buf, FALSE, ch, obj, 0, TO_ROOM);t  G   sprintf(buf, shop_index[shop_nr].message_buy, GET_NAME(ch), goldamt); $   do_tell(keeper, buf, cmd_tell, 0);0   sprintf(buf, "You now have %s.\r\n", tempstr);   send_to_char(buf, ch);     if (SHOP_USES_BANK(shop_nr)).     if (GET_GOLD(keeper) > MAX_OUTSIDE_BANK) {B       SHOP_BANK(shop_nr) += (GET_GOLD(keeper) - MAX_OUTSIDE_BANK);*       GET_GOLD(keeper) = MAX_OUTSIDE_BANK;     }  }s    C struct obj_data *get_selling_obj(struct char_data * ch, char *name, > 		            struct char_data * keeper, int shop_nr, int msg) {    char buf[MAX_STRING_LENGTH];   struct obj_data *obj;U
   int result;e  =   if (!(obj = get_obj_in_list_vis(ch, name, ch->carrying))) {      if (msg) {D       sprintf(buf, shop_index[shop_nr].no_such_item2, GET_NAME(ch));(       do_tell(keeper, buf, cmd_tell, 0);     }e     return (0);    }_7   if ((result = trade_with(obj, shop_nr)) == OBJECT_OK)x     return (obj);a     switch (result) {r   case OBJECT_NOVAL:I     sprintf(buf, "%s You've got to be kidding, that thing is worthless!",F 	    GET_NAME(ch));i
     break;   case OBJECT_NOTOK:?     sprintf(buf, shop_index[shop_nr].do_not_buy, GET_NAME(ch));p
     break;   case OBJECT_DEAD:,?     sprintf(buf, "%s %s", GET_NAME(ch), MSG_NO_USED_WANDSTAFF);i
     break;
   default:D     log("SYSERR: Illegal return value of %d from trade_with() (%s)",8 	    result, __FILE__);	/* Someone might rename it... */<     sprintf(buf, "%s An error has occurred.", GET_NAME(ch));
     break;   }r
   if (msg)&     do_tell(keeper, buf, cmd_tell, 0);
   return (0);d }o    I int sell_price(struct char_data * ch, struct obj_data * obj, int shop_nr)p {)@   return ((int) (GET_OBJ_COST(obj) * SHOP_SELLPROFIT(shop_nr))); }_    L struct obj_data *slide_obj(struct obj_data * obj, struct char_data * keeper, 			            int shop_nr)n /*I    This function is a slight hack!  To make sure that duplicate items areeC    only listed once on the "list", this function groups "identical" J    objects together on the shopkeeper's inventory list.  The hack involvesF    knowing how the list is put together, and manipulating the order ofI    the objects on the list.  (But since most of DIKU is not encapsulated,cM    and information hiding is almost never used, it isn't that big a deal) -JFt */ {h   struct obj_data *loop;   int temp;   1   if (SHOP_SORT(shop_nr) < IS_CARRYING_N(keeper))t&     sort_keeper_objs(keeper, shop_nr);  =   /* Extract the object if it is identical to one produced */o%   if (shop_producing(obj, shop_nr)) {o     temp = GET_OBJ_RNUM(obj);;     extract_obj(obj);(     return (&obj_proto[temp]);   }s   SHOP_SORT(shop_nr)++;a   loop = keeper->carrying;   obj_to_char(obj, keeper);f   keeper->carrying = loop;   while (loop) {     if (same_obj(obj, loop)) {-       obj->next_content = loop->next_content;c       loop->next_content = obj;r       return (obj);r     }t     loop = loop->next_content;   }s   keeper->carrying = obj;e   return (obj);  }     = void sort_keeper_objs(struct char_data * keeper, int shop_nr)  { #   struct obj_data *list = 0, *temp;t  6   while (SHOP_SORT(shop_nr) < IS_CARRYING_N(keeper)) {     temp = keeper->carrying;     obj_from_char(temp);     temp->next_content = list;     list = temp;   }*     while (list) {     temp = list;     list = list->next_content;*     if ((shop_producing(temp, shop_nr)) &&@ 	!(get_obj_in_list_num(GET_OBJ_RNUM(temp), keeper->carrying))) {        obj_to_char(temp, keeper);       SHOP_SORT(shop_nr)++;r
     } else.       (void) slide_obj(temp, keeper, shop_nr);   }) }     4 void shopping_sell(char *arg, struct char_data * ch,1 		        struct char_data * keeper, int shop_nr)o {rD   char tempstr[200], buf[MAX_STRING_LENGTH], name[MAX_INPUT_LENGTH];!   struct obj_data *obj, *tag = 0;o%   int sellnum, sold = 0, goldamt = 0;s  $   if (!(is_ok(keeper, ch, shop_nr)))     return;P  -   if ((sellnum = transaction_amt(arg)) < 0) {r@     sprintf(buf, "%s A negative amount?  Try buying something.", 	    GET_NAME(ch));*&     do_tell(keeper, buf, cmd_tell, 0);     return;l   }t   if (!(*arg) || !(sellnum)) {@     sprintf(buf, "%s What do you want to sell??", GET_NAME(ch));&     do_tell(keeper, buf, cmd_tell, 0);     return;*   }t   one_argument(arg, name);@   if (!(obj = get_selling_obj(ch, name, keeper, shop_nr, TRUE)))     return;t  M   if (GET_GOLD(keeper) + SHOP_BANK(shop_nr) < sell_price(ch, obj, shop_nr)) { B     sprintf(buf, shop_index[shop_nr].missing_cash1, GET_NAME(ch));&     do_tell(keeper, buf, cmd_tell, 0);     return;c   }";   while ((obj) && (GET_GOLD(keeper) + SHOP_BANK(shop_nr) >="9 		   sell_price(ch, obj, shop_nr)) && (sold < sellnum)) {      sold++;r  ,     goldamt += sell_price(ch, obj, shop_nr);5     GET_GOLD(keeper) -= sell_price(ch, obj, shop_nr);r 	      obj_from_char(obj);t*     tag = slide_obj(obj, keeper, shop_nr);<     obj = get_selling_obj(ch, name, keeper, shop_nr, FALSE);   }G     if (sold < sellnum) { 
     if (!obj)SH       sprintf(buf, "%s You only have %d of those.", GET_NAME(ch), sold);4     else if (GET_GOLD(keeper) + SHOP_BANK(shop_nr) <# 	     sell_price(ch, obj, shop_nr))E>       sprintf(buf, "%s I can only afford to buy %d of those.", 	      GET_NAME(ch), sold);L     else@       sprintf(buf, "%s Something really screwy made me buy %d.", 	      GET_NAME(ch), sold);e  &     do_tell(keeper, buf, cmd_tell, 0);   }R   GET_GOLD(ch) += goldamt;0   strcpy(tempstr, times_message(0, name, sold));(   sprintf(buf, "$n sells %s.", tempstr);'   act(buf, FALSE, ch, obj, 0, TO_ROOM);N  H   sprintf(buf, shop_index[shop_nr].message_sell, GET_NAME(ch), goldamt);$   do_tell(keeper, buf, cmd_tell, 0);:   sprintf(buf, "The shopkeeper now has %s.\r\n", tempstr);   send_to_char(buf, ch);  ,   if (GET_GOLD(keeper) < MIN_OUTSIDE_BANK) {K     goldamt = MIN(MAX_OUTSIDE_BANK - GET_GOLD(keeper), SHOP_BANK(shop_nr));o"     SHOP_BANK(shop_nr) -= goldamt;      GET_GOLD(keeper) += goldamt;   }  }e    5 void shopping_value(char *arg, struct char_data * ch,r2 		         struct char_data * keeper, int shop_nr) {    char buf[MAX_STRING_LENGTH];   struct obj_data *obj;f   char name[MAX_INPUT_LENGTH];  $   if (!(is_ok(keeper, ch, shop_nr)))     return;s     if (!(*arg)) {G     sprintf(buf, "%s What do you want me to evaluate??", GET_NAME(ch));e&     do_tell(keeper, buf, cmd_tell, 0);     return;o   }e   one_argument(arg, name);@   if (!(obj = get_selling_obj(ch, name, keeper, shop_nr, TRUE)))     return;   H   sprintf(buf, "%s I'll give you %d gold coins for that!", GET_NAME(ch),! 	  sell_price(ch, obj, shop_nr));n$   do_tell(keeper, buf, cmd_tell, 0);  	   return;t })    I char *list_object(struct obj_data * obj, int cnt, int index, int shop_nr)H {)   static char buf[256];t   char buf2[300], buf3[200];  #   if (shop_producing(obj, shop_nr))A!     strcpy(buf2, "Unlimited   ");{   else%     sprintf(buf2, "%5d       ", cnt);d)   sprintf(buf, " %2d)  %s", index, buf2);   +   /* Compile object name and information */a'   strcpy(buf3, obj->short_description); D   if ((GET_OBJ_TYPE(obj) == ITEM_DRINKCON) && (GET_OBJ_VAL(obj, 1)))A     sprintf(END_OF(buf3), " of %s", drinks[GET_OBJ_VAL(obj, 2)]);v     /* FUTURE: */    /* Add glow/hum/etc */  L   if ((GET_OBJ_TYPE(obj) == ITEM_WAND) || (GET_OBJ_TYPE(obj) == ITEM_STAFF))2     if (GET_OBJ_VAL(obj, 2) < GET_OBJ_VAL(obj, 1))(       strcat(buf3, " (partially used)");  @   sprintf(buf2, "%-48s %6d\r\n", buf3, buy_price(obj, shop_nr));   strcat(buf, CAP(buf2));e   return (buf);o }d    4 void shopping_list(char *arg, struct char_data * ch,1 		        struct char_data * keeper, int shop_nr); { 6   char buf[MAX_STRING_LENGTH], name[MAX_INPUT_LENGTH];&   struct obj_data *obj, *last_obj = 0;   int cnt = 0, index = 0;h  $   if (!(is_ok(keeper, ch, shop_nr)))     return;   1   if (SHOP_SORT(shop_nr) < IS_CARRYING_N(keeper))O&     sort_keeper_objs(keeper, shop_nr);     one_argument(arg, name);_   strcpy(buf, " ##   Available   Item                                               Cost\r\n");r_   strcat(buf, "-------------------------------------------------------------------------\r\n");    if (keeper->carrying)E>     for (obj = keeper->carrying; obj; obj = obj->next_content)>       if (CAN_SEE_OBJ(ch, obj) && (obj->obj_flags.cost > 0)) { 	if (!last_obj) {i 	  last_obj = obj; 	  cnt = 1;w$ 	} else if (same_obj(last_obj, obj))	 	  cnt++;( 	else {l 	  index++;t0 	  if (!(*name) || isname(name, last_obj->name))= 	    strcat(buf, list_object(last_obj, cnt, index, shop_nr));o 	  cnt = 1;r 	  last_obj = obj; 	}       } 
   index++;   if (!last_obj) {     if (*name)@       strcpy(buf, "Presently, none of those are for sale.\r\n");     else?       strcpy(buf, "Currently, there is nothing for sale.\r\n");N6   } else if (!(*name) || isname(name, last_obj->name))<     strcat(buf, list_object(last_obj, cnt, index, shop_nr));      page_string(ch->desc, buf, 1); }a    ' int ok_shop_room(int shop_nr, int room)  {f   int index;  @   for (index = 0; SHOP_ROOM(shop_nr, index) != NOWHERE; index++)*     if (SHOP_ROOM(shop_nr, index) == room)       return (TRUE);   return (FALSE);r }o     SPECIAL(shop_keeper) {    char argm[MAX_INPUT_LENGTH];5   struct char_data *keeper = (struct char_data *) me;V   int shop_nr;  2   for (shop_nr = 0; shop_nr < top_shop; shop_nr++)+     if (SHOP_KEEPER(shop_nr) == keeper->nr)O       break;     if (shop_nr >= top_shop)     return (FALSE);R  8   if (SHOP_FUNC(shop_nr))	/* Check secondary function */0     if ((SHOP_FUNC(shop_nr)) (ch, me, cmd, arg))       return (TRUE);     if (keeper == ch) {n     if (cmd)=       SHOP_SORT(shop_nr) = 0;	/* Safety in case "drop all" */B     return (FALSE);B   }M9   if (!ok_shop_room(shop_nr, GET_ROOM_VNUM(IN_ROOM(ch))))!     return (0);j     if (!AWAKE(keeper))      return (FALSE);R     if (CMD_IS("steal")) {7     sprintf(argm, "$N shouts '%s'", MSG_NO_STEAL_HERE);A1     do_action(keeper, GET_NAME(ch), cmd_slap, 0);e-     act(argm, FALSE, ch, 0, keeper, TO_CHAR);|     return (TRUE);   }x     if (CMD_IS("buy")) {0     shopping_buy(argument, ch, keeper, shop_nr);     return (TRUE);   } else if (CMD_IS("sell")) {1     shopping_sell(argument, ch, keeper, shop_nr);      return (TRUE);   } else if (CMD_IS("value")) { 2     shopping_value(argument, ch, keeper, shop_nr);     return (TRUE);   } else if (CMD_IS("list")) {1     shopping_list(argument, ch, keeper, shop_nr);e     return (TRUE);   }A   return (FALSE);  }n    J int ok_damage_shopkeeper(struct char_data * ch, struct char_data * victim) {    char buf[200];   int index;  N   if (IS_MOB(victim) && (mob_index[GET_MOB_RNUM(victim)].func == shop_keeper)).     for (index = 0; index < top_shop; index++)T       if ((GET_MOB_RNUM(victim) == SHOP_KEEPER(index)) && !SHOP_KILL_CHARS(index)) {. 	do_action(victim, GET_NAME(ch), cmd_slap, 0);; 	sprintf(buf, "%s %s", GET_NAME(ch), MSG_CANT_KILL_KEEPER);.# 	do_tell(victim, buf, cmd_tell, 0);  	return (FALSE);       }i   return (TRUE); }p    J int add_to_list(struct shop_buy_data * list, int type, int *len, int *val) {e   if (*val >= 0) {     if (*len < MAX_SHOP_OBJ) {       if (type == LIST_PRODUCE)* 	*val = real_object(*val);       if (*val >= 0) { 	BUY_TYPE(list[*len]) = *val;a 	BUY_WORD(list[(*len)++]) = 0;       } else
 	*val = 0;       return (FALSE); 
     } else       return (TRUE);   };   return (FALSE);g }n    B int end_read_list(struct shop_buy_data * list, int len, int error) {e   if (error)D     log("Raise MAX_SHOP_OBJ constant in shop.h to %d", len + error);   BUY_WORD(list[len]) = 0;"   BUY_TYPE(list[len++]) = NOTHING;   return (len);c }     = void read_line(FILE * shop_f, const char *string, void *data)h {_=   if (!get_line(shop_f, buf) || !sscanf(buf, string, data)) {c;     log("SYSERR: Error in shop #%d\n", SHOP_NUM(top_shop));0     exit(1);   }  }f    I int read_list(FILE * shop_f, struct shop_buy_data * list, int new_format,  	          int max, int type)o {=&   int count, temp, len = 0, error = 0;     if (new_format) {b     do {%       read_line(shop_f, "%d", &temp); 4       error += add_to_list(list, type, &len, &temp);     } while (temp >= 0);   } else+     for (count = 0; count < max; count++) {b%       read_line(shop_f, "%d", &temp);	4       error += add_to_list(list, type, &len, &temp);     } +   return (end_read_list(list, len, error));N }_    > int read_type_list(FILE * shop_f, struct shop_buy_data * list,! 		       int new_format, int max)  { %   int index, num, len = 0, error = 0;r   char *ptr;     if (!new_format)9     return (read_list(shop_f, list, 0, max, LIST_TRADE));    do {.     fgets(buf, MAX_STRING_LENGTH - 1, shop_f);)     if ((ptr = strchr(buf, ';')) != NULL)e       *ptr = 0;      else       *(END_OF(buf) - 1) = 0; G     for (index = 0, num = NOTHING; *item_types[index] != '\n'; index++) I       if (!strn_cmp(item_types[index], buf, strlen(item_types[index]))) {t
 	num = index; . 	strcpy(buf, buf + strlen(item_types[index])); 	break;)       }U     ptr = buf;     if (num == NOTHING) {_       sscanf(buf, "%d", &num);       while (!isdigit(*ptr)) 	ptr++;p       while (isdigit(*ptr))t 	ptr++;0     }M     while (isspace(*ptr))t       ptr++;'     while (isspace(*(END_OF(ptr) - 1)))b       *(END_OF(ptr) - 1) = 0;s7     error += add_to_list(list, LIST_TRADE, &len, &num);R
     if (*ptr)_-       BUY_WORD(list[len - 1]) = str_dup(ptr);e   } while (num >= 0);b+   return (end_read_list(list, len, error));i }(    A void boot_the_shops(FILE * shop_f, char *filename, int rec_count)( {)   char *buf, buf2[150];u"   int temp, count, new_format = 0;.   struct shop_buy_data list[MAX_SHOP_OBJ + 1];   int done = 0;u  7   sprintf(buf2, "beginning of shop file %s", filename);c     while (!done) {u%     buf = fread_string(shop_f, buf2);o&     if (*buf == '#') {		/* New shop */"       sscanf(buf, "#%d\n", &temp);@       sprintf(buf2, "shop #%d in shop file %s", temp, filename);)       free(buf);		/* Plug memory leak! */;       if (!top_shop)1 	CREATE(shop_index, struct shop_data, rec_count);(          SHOP_NUM(top_shop) = temp;I       temp = read_list(shop_f, list, new_format, MAX_PROD, LIST_PRODUCE); 8       CREATE(shop_index[top_shop].producing, int, temp);,       for (count = 0; count < temp; count++)7 	SHOP_PRODUCT(top_shop, count) = BUY_TYPE(list[count]);>  9       read_line(shop_f, "%f", &SHOP_BUYPROFIT(top_shop));n:       read_line(shop_f, "%f", &SHOP_SELLPROFIT(top_shop));  A       temp = read_type_list(shop_f, list, new_format, MAX_TRADE);JD       CREATE(shop_index[top_shop].type, struct shop_buy_data, temp);.       for (count = 0; count < temp; count++) {7 	SHOP_BUYTYPE(top_shop, count) = BUY_TYPE(list[count]); 7 	SHOP_BUYWORD(top_shop, count) = BUY_WORD(list[count]);)       }D  F       shop_index[top_shop].no_such_item1 = fread_string(shop_f, buf2);F       shop_index[top_shop].no_such_item2 = fread_string(shop_f, buf2);C       shop_index[top_shop].do_not_buy = fread_string(shop_f, buf2);iF       shop_index[top_shop].missing_cash1 = fread_string(shop_f, buf2);F       shop_index[top_shop].missing_cash2 = fread_string(shop_f, buf2);D       shop_index[top_shop].message_buy = fread_string(shop_f, buf2);E       shop_index[top_shop].message_sell = fread_string(shop_f, buf2);_<       read_line(shop_f, "%d", &SHOP_BROKE_TEMPER(top_shop));9       read_line(shop_f, "%d", &SHOP_BITVECTOR(top_shop));b6       read_line(shop_f, "%d", &SHOP_KEEPER(top_shop));  A       SHOP_KEEPER(top_shop) = real_mobile(SHOP_KEEPER(top_shop));l:       read_line(shop_f, "%d", &SHOP_TRADE_WITH(top_shop));  ?       temp = read_list(shop_f, list, new_format, 1, LIST_ROOM);Y6       CREATE(shop_index[top_shop].in_room, int, temp);,       for (count = 0; count < temp; count++)4 	SHOP_ROOM(top_shop, count) = BUY_TYPE(list[count]);  5       read_line(shop_f, "%d", &SHOP_OPEN1(top_shop));J6       read_line(shop_f, "%d", &SHOP_CLOSE1(top_shop));5       read_line(shop_f, "%d", &SHOP_OPEN2(top_shop));l6       read_line(shop_f, "%d", &SHOP_CLOSE2(top_shop));         SHOP_BANK(top_shop) = 0;       SHOP_SORT(top_shop) = 0;       SHOP_FUNC(top_shop) = 0;       top_shop++;O     } else {!       if (*buf == '$')		/* EOF */s
 	done = TRUE;rA       else if (strstr(buf, VERSION3_TAG))	/* New format marker */c 	new_format = 1;)       free(buf);		/* Plug memory leak! */n     }p   }m }a    ! void assign_the_shopkeepers(void)t {(   int index;      cmd_say = find_command("say");"   cmd_tell = find_command("tell");$   cmd_emote = find_command("emote");"   cmd_slap = find_command("slap");"   cmd_puke = find_command("puke");.   for (index = 0; index < top_shop; index++) {%     if (SHOP_KEEPER(index) == NOBODY)O       continue; +     if (mob_index[SHOP_KEEPER(index)].func)s<       SHOP_FUNC(index) = mob_index[SHOP_KEEPER(index)].func;5     mob_index[SHOP_KEEPER(index)].func = shop_keeper;X   }N }E    0 char *customer_string(int shop_nr, int detailed) {(   int index, cnt = 1;_   static char buf[256];g     *buf = 0;(C   for (index = 0; *trade_letters[index] != '\n'; index++, cnt *= 2)E,     if (!(SHOP_TRADE_WITH(shop_nr) & cnt)) {       if (detailed) {(
 	if (*buf) 	  strcat(buf, ", ");i# 	strcat(buf, trade_letters[index]);        } else3 	sprintf(END_OF(buf), "%c", *trade_letters[index]);p     } else if (!detailed)o       strcat(buf, "_");s     return (buf);  }T    * void list_all_shops(struct char_data * ch) {    int shop_nr;     strcpy(buf, "\r\n");4   for (shop_nr = 0; shop_nr < top_shop; shop_nr++) {     if (!(shop_nr % 19)) {S       strcat(buf, " ##   Virtual   Where    Keeper    Buy   Sell   Customers\r\n");lS       strcat(buf, "---------------------------------------------------------\r\n");t     } H     sprintf(buf2, "%3d   %6d   %6d    ", shop_nr + 1, SHOP_NUM(shop_nr), 	    SHOP_ROOM(shop_nr, 0));!     if (SHOP_KEEPER(shop_nr) < 0);       strcpy(buf1, "<NONE>");e     elseA       sprintf(buf1, "%6d", mob_index[SHOP_KEEPER(shop_nr)].vnum);e9     sprintf(END_OF(buf2), "%s   %3.2f   %3.2f    ", buf1,;8 	    SHOP_SELLPROFIT(shop_nr), SHOP_BUYPROFIT(shop_nr));2     strcat(buf2, customer_string(shop_nr, FALSE));)     sprintf(END_OF(buf), "%s\r\n", buf2);c   }o      page_string(ch->desc, buf, 1); }     G void handle_detailed_list(char *buf, char *buf1, struct char_data * ch)s {g>   if ((strlen(buf1) + strlen(buf) < 78) || (strlen(buf) < 20))     strcat(buf, buf1);   else {     strcat(buf, "\r\n");     send_to_char(buf, ch);)     sprintf(buf, "            %s", buf1);n   }l }d    ; void list_detailed_shop(struct char_data * ch, int shop_nr)  {    struct obj_data *obj;t   struct char_data *k;   int index, temp;  G   sprintf(buf, "Vnum:       [%5d], Rnum: [%5d]\r\n", SHOP_NUM(shop_nr),s 	  shop_nr + 1);   send_to_char(buf, ch);     strcpy(buf, "Rooms:      ");B   for (index = 0; SHOP_ROOM(shop_nr, index) != NOWHERE; index++) {     if (index)       strcat(buf, ", ");A     if ((temp = real_room(SHOP_ROOM(shop_nr, index))) != NOWHERE)rG       sprintf(buf1, "%s (#%d)", world[temp].name, GET_ROOM_VNUM(temp));      elseB       sprintf(buf1, "<UNKNOWN> (#%d)", SHOP_ROOM(shop_nr, index));(     handle_detailed_list(buf, buf1, ch);   } 
   if (!index)).     send_to_char("Rooms:      None!\r\n", ch);   else {     strcat(buf, "\r\n");     send_to_char(buf, ch);   }p     strcpy(buf, "Shopkeeper: ");"   if (SHOP_KEEPER(shop_nr) >= 0) {>     sprintf(END_OF(buf), "%s (#%d), Special Function: %s\r\n",0 	    GET_NAME(&mob_proto[SHOP_KEEPER(shop_nr)]),B 	mob_index[SHOP_KEEPER(shop_nr)].vnum, YESNO(SHOP_FUNC(shop_nr)));3     if ((k = get_char_num(SHOP_KEEPER(shop_nr)))) {i       send_to_char(buf, ch);D       sprintf(buf, "Coins:      [%9d], Bank: [%9d] (Total: %d)\r\n",E 	 GET_GOLD(k), SHOP_BANK(shop_nr), GET_GOLD(k) + SHOP_BANK(shop_nr));      }P   } else     strcat(buf, "<NONE>\r\n");   send_to_char(buf, ch);  /   strcpy(buf1, customer_string(shop_nr, TRUE));a>   sprintf(buf, "Customers:  %s\r\n", (*buf1) ? buf1 : "None");   send_to_char(buf, ch);     strcpy(buf, "Produces:   ");E   for (index = 0; SHOP_PRODUCT(shop_nr, index) != NOTHING; index++) { 3     obj = &obj_proto[SHOP_PRODUCT(shop_nr, index)];p     if (index)       strcat(buf, ", ");5     sprintf(buf1, "%s (#%d)", obj->short_description,u3 	    obj_index[SHOP_PRODUCT(shop_nr, index)].vnum); (     handle_detailed_list(buf, buf1, ch);   }d
   if (!index) 1     send_to_char("Produces:   Nothing!\r\n", ch);    else {     strcat(buf, "\r\n");     send_to_char(buf, ch);   }t     strcpy(buf, "Buys:       ");E   for (index = 0; SHOP_BUYTYPE(shop_nr, index) != NOTHING; index++) {_     if (index)       strcat(buf, ", ");H     sprintf(buf1, "%s (#%d) ", item_types[SHOP_BUYTYPE(shop_nr, index)],# 	    SHOP_BUYTYPE(shop_nr, index));s%     if (SHOP_BUYWORD(shop_nr, index))AB       sprintf(END_OF(buf1), "[%s]", SHOP_BUYWORD(shop_nr, index));     else       strcat(buf1, "[all]");(     handle_detailed_list(buf, buf1, ch);   },
   if (!index)s1     send_to_char("Buys:       Nothing!\r\n", ch);s   else {     strcat(buf, "\r\n");     send_to_char(buf, ch);   }o  O   sprintf(buf, "Buy at:     [%4.2f], Sell at: [%4.2f], Open: [%d-%d, %d-%d]%s",_L      SHOP_SELLPROFIT(shop_nr), SHOP_BUYPROFIT(shop_nr), SHOP_OPEN1(shop_nr),L    SHOP_CLOSE1(shop_nr), SHOP_OPEN2(shop_nr), SHOP_CLOSE2(shop_nr), "\r\n");     send_to_char(buf, ch);  =   sprintbit((long) SHOP_BITVECTOR(shop_nr), shop_bits, buf1); +   sprintf(buf, "Bits:       %s\r\n", buf1);t   send_to_char(buf, ch); }t    1 void show_shops(struct char_data * ch, char *arg)  {e   int shop_nr;     if (!*arg)     list_all_shops(ch);b   else {     if (!str_cmp(arg, ".")) { 6       for (shop_nr = 0; shop_nr < top_shop; shop_nr++)7 	if (ok_shop_room(shop_nr, GET_ROOM_VNUM(IN_ROOM(ch)))),	 	  break;           if (shop_nr == top_shop) {, 	send_to_char("This isn't a shop!\r\n", ch); 	return;       }o     } else if (is_number(arg))       shop_nr = atoi(arg) - 1;     else       shop_nr = -1;   1     if ((shop_nr < 0) || (shop_nr >= top_shop)) {r3       send_to_char("Illegal shop number.\r\n", ch);)
       return;B     } $     list_detailed_shop(ch, shop_nr);   }L }e