K /* ************************************************************************ K *   File: structs.h                                     Part of CircleMUD * K *  Usage: header file for central structures and contstants               * K *                                                                         * K *  All rights reserved.  See license.doc for complete information.        * K *                                                                         * K *  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University * K *  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               * K ************************************************************************ */    /*H  * Intended use of this macro is to allow external packages to work withH  * a variety of CircleMUD versions without modifications.  For instance,H  * an IS_CORPSE() macro was introduced in pl13.  Any future code add-onsE  * could take into account the CircleMUD version and supply their own E  * definition for the macro if used on an older version of CircleMUD. F  * You are supposed to compare this with the macro CIRCLEMUD_VERSION()$  * in utils.h.  See there for usage.  */ A #define _CIRCLEMUD	0x03000D /* Major/Minor/Patchlevel - MMmmPP */   J /* preamble *************************************************************/  > #define NOWHERE    -1    /* nil reference for room-database	*/9 #define NOTHING	   -1    /* nil reference for objects		*/ 8 #define NOBODY	   -1    /* nil reference for mobiles		*/   #define SPECIAL(name) \ F    int (name)(struct char_data *ch, void *me, int cmd, char *argument)  J /* misc editor defines **************************************************/  " /* format modes for format_text */ #define FORMAT_INDENT		(1 << 0)     J /* room-related defines *************************************************/    F /* The cardinal directions: used as index to room_data.dir_option[] */ #define NORTH          0 #define EAST           1 #define SOUTH          2 #define WEST           3 #define UP             4 #define DOWN           5    . /* Room flags: used in room_data.room_flags */M /* WARNING: In the world files, NEVER set the bits marked "R" ("Reserved") */ * #define ROOM_DARK		(1 << 0)   /* Dark			*/0 #define ROOM_DEATH		(1 << 1)   /* Death trap		*/6 #define ROOM_NOMOB		(1 << 2)   /* MOBs not allowed		*/0 #define ROOM_INDOORS		(1 << 3)   /* Indoors			*/< #define ROOM_PEACEFUL		(1 << 4)   /* Violence not allowed	*/@ #define ROOM_SOUNDPROOF		(1 << 5)   /* Shouts, gossip blocked	*/= #define ROOM_NOTRACK		(1 << 6)   /* Track won't go through	*/ 9 #define ROOM_NOMAGIC		(1 << 7)   /* Magic not allowed		*/ : #define ROOM_TUNNEL		(1 << 8)   /* room for only 1 pers	*/9 #define ROOM_PRIVATE		(1 << 9)   /* Can't teleport in		*/ < #define ROOM_GODROOM		(1 << 10)  /* LVL_GOD+ only allowed	*/8 #define ROOM_HOUSE		(1 << 11)  /* (R) Room is a house	*/@ #define ROOM_HOUSE_CRASH	(1 << 12)  /* (R) House needs saving	*/= #define ROOM_ATRIUM		(1 << 13)  /* (R) The door to a house	*/ ; #define ROOM_OLC		(1 << 14)  /* (R) Modifyable/!compress	*/ A #define ROOM_BFS_MARK		(1 << 15)  /* (R) breath-first srch mrk	*/     7 /* Exit info: used in room_data.dir_option.exit_info */ 3 #define EX_ISDOOR		(1 << 0)   /* Exit is a door		*/ 6 #define EX_CLOSED		(1 << 1)   /* The door is closed	*/6 #define EX_LOCKED		(1 << 2)   /* The door is locked	*/; #define EX_PICKPROOF		(1 << 3)   /* Lock can't be picked	*/     1 /* Sector types: used in room_data.sector_type */ 2 #define SECT_INSIDE          0		   /* Indoors			*/4 #define SECT_CITY            1		   /* In a city			*/4 #define SECT_FIELD           2		   /* In a field		*/5 #define SECT_FOREST          3		   /* In a forest		*/ 6 #define SECT_HILLS           4		   /* In the hills		*/7 #define SECT_MOUNTAIN        5		   /* On a mountain		*/ 9 #define SECT_WATER_SWIM      6		   /* Swimmable water		*/ < #define SECT_WATER_NOSWIM    7		   /* Water - need a boat	*/4 #define SECT_UNDERWATER	     8		   /* Underwater		*/- #define SECT_FLYING	     9		   /* Wheee!			*/     J /* char and mob-related defines *****************************************/     /* PC classes */ #define CLASS_UNDEFINED	  -1 #define CLASS_MAGIC_USER  0  #define CLASS_CLERIC      1  #define CLASS_THIEF       2  #define CLASS_WARRIOR     3   C #define NUM_CLASSES	  4  /* This must be the number of classes!! */   > /* NPC classes (currently unused - feel free to implement!) */ #define CLASS_OTHER       0  #define CLASS_UNDEAD      1  #define CLASS_HUMANOID    2  #define CLASS_ANIMAL      3  #define CLASS_DRAGON      4  #define CLASS_GIANT       5     	 /* Sex */  #define SEX_NEUTRAL   0  #define SEX_MALE      1  #define SEX_FEMALE    2      /* Positions */ % #define POS_DEAD       0	/* dead			*/ / #define POS_MORTALLYW  1	/* mortally wounded	*/ , #define POS_INCAP      2	/* incapacitated	*/' #define POS_STUNNED    3	/* stunned		*/ ( #define POS_SLEEPING   4	/* sleeping		*/' #define POS_RESTING    5	/* resting		*/ ' #define POS_SITTING    6	/* sitting		*/ ( #define POS_FIGHTING   7	/* fighting		*/( #define POS_STANDING   8	/* standing		*/    7 /* Player flags: used by char_data.char_specials.act */ > #define PLR_KILLER	(1 << 0)   /* Player is a player-killer		*/< #define PLR_THIEF	(1 << 1)   /* Player is a player-thief		*/6 #define PLR_FROZEN	(1 << 2)   /* Player is frozen			*/C #define PLR_DONTSET     (1 << 3)   /* Don't EVER set (ISNPC bit)	*/ D #define PLR_WRITING	(1 << 4)   /* Player writing (board/mail/olc)	*/< #define PLR_MAILING	(1 << 5)   /* Player is writing mail		*/A #define PLR_CRASH	(1 << 6)   /* Player needs to be crash-saved	*/ @ #define PLR_SITEOK	(1 << 7)   /* Player has been site-cleared	*/E #define PLR_NOSHOUT	(1 << 8)   /* Player not allowed to shout/goss	*/ D #define PLR_NOTITLE	(1 << 9)   /* Player not allowed to set title	*/D #define PLR_DELETED	(1 << 10)  /* Player deleted - space reusable	*/F #define PLR_LOADROOM	(1 << 11)  /* Player uses nonstandard loadroom	*/E #define PLR_NOWIZLIST	(1 << 12)  /* Player shouldn't be on wizlist	*/ A #define PLR_NODELETE	(1 << 13)  /* Player shouldn't be deleted	*/ G #define PLR_INVSTART	(1 << 14)  /* Player should enter game wizinvis	*/ C #define PLR_CRYO	(1 << 15)  /* Player is cryo-saved (purge prog)	*/     7 /* Mobile flags: used by char_data.char_specials.act */ E #define MOB_SPEC         (1 << 0)  /* Mob has a callable spec-proc	*/ = #define MOB_SENTINEL     (1 << 1)  /* Mob should not move		*/ I #define MOB_SCAVENGER    (1 << 2)  /* Mob picks up stuff on the ground	*/ J #define MOB_ISNPC        (1 << 3)  /* (R) Automatically set on all Mobs	*/< #define MOB_AWARE	 (1 << 4)  /* Mob can't be backstabbed		*/E #define MOB_AGGRESSIVE   (1 << 5)  /* Mob hits players in the room	*/ I #define MOB_STAY_ZONE    (1 << 6)  /* Mob shouldn't wander out of zone	*/ F #define MOB_WIMPY        (1 << 7)  /* Mob flees if severely injured	*/= #define MOB_AGGR_EVIL	 (1 << 8)  /* auto attack evil PC's		*/ = #define MOB_AGGR_GOOD	 (1 << 9)  /* auto attack good PC's		*/ B #define MOB_AGGR_NEUTRAL (1 << 10) /* auto attack neutral PC's		*/B #define MOB_MEMORY	 (1 << 11) /* remember attackers if attacked	*/B #define MOB_HELPER	 (1 << 12) /* attack PCs fighting other NPCs	*/: #define MOB_NOCHARM	 (1 << 13) /* Mob can't be charmed		*/< #define MOB_NOSUMMON	 (1 << 14) /* Mob can't be summoned		*/8 #define MOB_NOSLEEP	 (1 << 15) /* Mob can't be slept		*/D #define MOB_NOBASH	 (1 << 16) /* Mob can't be bashed (e.g. trees)	*/: #define MOB_NOBLIND	 (1 << 17) /* Mob can't be blinded		*/    > /* Preference flags: used by char_data.player_specials.pref */J #define PRF_BRIEF       (1 << 0)  /* Room descs won't normally be shown	*/I #define PRF_COMPACT     (1 << 1)  /* No extra CRLF pair before prompts	*/ 4 #define PRF_DEAF	(1 << 2)  /* Can't hear shouts			*/7 #define PRF_NOTELL	(1 << 3)  /* Can't receive tells		*/ ? #define PRF_DISPHP	(1 << 4)  /* Display hit points in prompt	*/ B #define PRF_DISPMANA	(1 << 5)  /* Display mana points in prompt	*/B #define PRF_DISPMOVE	(1 << 6)  /* Display move points in prompt	*/= #define PRF_AUTOEXIT	(1 << 7)  /* Display exits in a room		*/ < #define PRF_NOHASSLE	(1 << 8)  /* Aggr mobs won't attack		*/- #define PRF_QUEST	(1 << 9)  /* On quest				*/ 8 #define PRF_SUMMONABLE	(1 << 10) /* Can be summoned			*/C #define PRF_NOREPEAT	(1 << 11) /* No repetition of comm commands	*/ 7 #define PRF_HOLYLIGHT	(1 << 12) /* Can see in dark			*/ 5 #define PRF_COLOR_1	(1 << 13) /* Color (low bit)			*/ 6 #define PRF_COLOR_2	(1 << 14) /* Color (high bit)			*/6 #define PRF_NOWIZ	(1 << 15) /* Can't hear wizline			*/= #define PRF_LOG1	(1 << 16) /* On-line System Log (low bit)	*/ > #define PRF_LOG2	(1 << 17) /* On-line System Log (high bit)	*/> #define PRF_NOAUCT	(1 << 18) /* Can't hear auction channel		*/= #define PRF_NOGOSS	(1 << 19) /* Can't hear gossip channel		*/ = #define PRF_NOGRATZ	(1 << 20) /* Can't hear grats channel		*/ A #define PRF_ROOMFLAGS	(1 << 21) /* Can see room flags (ROOM_x)	*/     D /* Affect bits: used in char_data.char_specials.saved.affected_by */M /* WARNING: In the world files, NEVER set the bits marked "R" ("Reserved") */ B #define AFF_BLIND             (1 << 0)	   /* (R) Char is blind		*/B #define AFF_INVISIBLE         (1 << 1)	   /* Char is invisible		*/I #define AFF_DETECT_ALIGN      (1 << 2)	   /* Char is sensitive to align*/ I #define AFF_DETECT_INVIS      (1 << 3)	   /* Char can see invis chars  */ I #define AFF_DETECT_MAGIC      (1 << 4)	   /* Char is sensitive to magic*/ I #define AFF_SENSE_LIFE        (1 << 5)	   /* Char can sense hidden life*/ D #define AFF_WATERWALK	      (1 << 6)	   /* Char can walk on water	*/H #define AFF_SANCTUARY         (1 << 7)	   /* Char protected by sanct.	*/C #define AFF_GROUP             (1 << 8)	   /* (R) Char is grouped	*/ ? #define AFF_CURSE             (1 << 9)	   /* Char is cursed		*/ E #define AFF_INFRAVISION       (1 << 10)	   /* Char can see in dark	*/ E #define AFF_POISON            (1 << 11)	   /* (R) Char is poisoned	*/ J #define AFF_PROTECT_EVIL      (1 << 12)	   /* Char protected from evil  */J #define AFF_PROTECT_GOOD      (1 << 13)	   /* Char protected from good  */J #define AFF_SLEEP             (1 << 14)	   /* (R) Char magically asleep	*/B #define AFF_NOTRACK	      (1 << 15)	   /* Char can't be tracked	*/G #define AFF_UNUSED16	      (1 << 16)	   /* Room for future expansion	*/ G #define AFF_UNUSED17	      (1 << 17)	   /* Room for future expansion	*/ F #define AFF_SNEAK             (1 << 18)	   /* Char can move quietly	*/@ #define AFF_HIDE              (1 << 19)	   /* Char is hidden		*/G #define AFF_UNUSED20	      (1 << 20)	   /* Room for future expansion	*/ A #define AFF_CHARM             (1 << 21)	   /* Char is charmed		*/     ; /* Modes of connectedness: used by descriptor_data.state */ 5 #define CON_PLAYING	 0		/* Playing - Nominal state	*/ * #define CON_CLOSE	 1		/* Disconnecting		*/0 #define CON_GET_NAME	 2		/* By what name ..?		*/9 #define CON_NAME_CNFRM	 3		/* Did I get that right, x?	*/ * #define CON_PASSWORD	 4		/* Password:			*/8 #define CON_NEWPASSWD	 5		/* Give me a password for x	*/7 #define CON_CNFPASSWD	 6		/* Please retype password:	*/ " #define CON_QSEX	 7		/* Sex?				*/% #define CON_QCLASS	 8		/* Class?			*/ 3 #define CON_RMOTD	 9		/* PRESS RETURN after MOTD	*/ 4 #define CON_MENU	 10		/* Your choice: (main menu)	*/6 #define CON_EXDESC	 11		/* Enter a new description:	*/; #define CON_CHPWD_GETOLD 12		/* Changing passwd: get old	*/ ; #define CON_CHPWD_GETNEW 13		/* Changing passwd: get new	*/ 7 #define CON_CHPWD_VRFY   14		/* Verify new password		*/ 4 #define CON_DELCNF1	 15		/* Delete confirmation 1	*/4 #define CON_DELCNF2	 16		/* Delete confirmation 2	*/7 #define CON_DISCONNECT	 17		/* In-game disconnection	*/ 4 #define CON_OEDIT	 18		/*. OLC mode - object edit	*/2 #define CON_REDIT	 19		/*. OLC mode - room edit	*/7 #define CON_ZEDIT	 20		/*. OLC mode - zone info edit	*/ 4 #define CON_MEDIT	 21		/*. OLC mode - mobile edit	*/2 #define CON_SEDIT	 22		/*. OLC mode - shop edit	*/  L /* Character equipment positions: used as index for char_data.equipment[] */@ /* NOTE: Don't confuse these constants with the ITEM_ bitvectorsF    which control the valid places you can wear a piece of equipment */ #define WEAR_LIGHT      0  #define WEAR_FINGER_R   1  #define WEAR_FINGER_L   2  #define WEAR_NECK_1     3  #define WEAR_NECK_2     4  #define WEAR_BODY       5  #define WEAR_HEAD       6  #define WEAR_LEGS       7  #define WEAR_FEET       8  #define WEAR_HANDS      9  #define WEAR_ARMS      10  #define WEAR_SHIELD    11  #define WEAR_ABOUT     12  #define WEAR_WAIST     13  #define WEAR_WRIST_R   14  #define WEAR_WRIST_L   15  #define WEAR_WIELD     16  #define WEAR_HOLD      17   D #define NUM_WEARS      18	/* This must be the # of eq positions!! */    G /* object-related defines ********************************************/     6 /* Item types: used by obj_data.obj_flags.type_flag */7 #define ITEM_LIGHT      1		/* Item is a light source	*/ 2 #define ITEM_SCROLL     2		/* Item is a scroll		*/0 #define ITEM_WAND       3		/* Item is a wand		*/1 #define ITEM_STAFF      4		/* Item is a staff		*/ 2 #define ITEM_WEAPON     5		/* Item is a weapon		*// #define ITEM_FIREWEAPON 6		/* Unimplemented		*/ / #define ITEM_MISSILE    7		/* Unimplemented		*/ = #define ITEM_TREASURE   8		/* Item is a treasure, not gold	*/ / #define ITEM_ARMOR      9		/* Item is armor		*/ 3 #define ITEM_POTION    10 		/* Item is a potion		*/ / #define ITEM_WORN      11		/* Unimplemented		*/ . #define ITEM_OTHER     12		/* Misc object			*/< #define ITEM_TRASH     13		/* Trash - shopkeeps won't buy	*// #define ITEM_TRAP      14		/* Unimplemented		*/ 5 #define ITEM_CONTAINER 15		/* Item is a container		*/ / #define ITEM_NOTE      16		/* Item is note 		*/ : #define ITEM_DRINKCON  17		/* Item is a drink container	*// #define ITEM_KEY       18		/* Item is a key		*/ / #define ITEM_FOOD      19		/* Item is food			*/ 6 #define ITEM_MONEY     20		/* Item is money (gold)		*// #define ITEM_PEN       21		/* Item is a pen		*/ 0 #define ITEM_BOAT      22		/* Item is a boat		*/4 #define ITEM_FOUNTAIN  23		/* Item is a fountain		*/    < /* Take/Wear flags: used by obj_data.obj_flags.wear_flags */: #define ITEM_WEAR_TAKE		(1 << 0)  /* Item can be takes		*/> #define ITEM_WEAR_FINGER	(1 << 1)  /* Can be worn on finger	*/@ #define ITEM_WEAR_NECK		(1 << 2)  /* Can be worn around neck 	*/< #define ITEM_WEAR_BODY		(1 << 3)  /* Can be worn on body 	*/< #define ITEM_WEAR_HEAD		(1 << 4)  /* Can be worn on head 	*/; #define ITEM_WEAR_LEGS		(1 << 5)  /* Can be worn on legs	*/ ; #define ITEM_WEAR_FEET		(1 << 6)  /* Can be worn on feet	*/ = #define ITEM_WEAR_HANDS		(1 << 7)  /* Can be worn on hands	*/ ; #define ITEM_WEAR_ARMS		(1 << 8)  /* Can be worn on arms	*/ @ #define ITEM_WEAR_SHIELD	(1 << 9)  /* Can be used as a shield	*/@ #define ITEM_WEAR_ABOUT		(1 << 10) /* Can be worn about body 	*/B #define ITEM_WEAR_WAIST 	(1 << 11) /* Can be worn around waist 	*/> #define ITEM_WEAR_WRIST		(1 << 12) /* Can be worn on wrist 	*/8 #define ITEM_WEAR_WIELD		(1 << 13) /* Can be wielded		*/4 #define ITEM_WEAR_HOLD		(1 << 14) /* Can be held		*/    @ /* Extra object flags: used by obj_data.obj_flags.extra_flags */: #define ITEM_GLOW          (1 << 0)	/* Item is glowing		*/: #define ITEM_HUM           (1 << 1)	/* Item is humming		*/? #define ITEM_NORENT        (1 << 2)	/* Item cannot be rented	*/ @ #define ITEM_NODONATE      (1 << 3)	/* Item cannot be donated	*/@ #define ITEM_NOINVIS	   (1 << 4)	/* Item cannot be made invis	*/< #define ITEM_INVISIBLE     (1 << 5)	/* Item is invisible		*/: #define ITEM_MAGIC         (1 << 6)	/* Item is magical		*/D #define ITEM_NODROP        (1 << 7)	/* Item is cursed: can't drop	*/: #define ITEM_BLESS         (1 << 8)	/* Item is blessed		*/C #define ITEM_ANTI_GOOD     (1 << 9)	/* Not usable by good people	*/ D #define ITEM_ANTI_EVIL     (1 << 10)	/* Not usable by evil people	*/G #define ITEM_ANTI_NEUTRAL  (1 << 11)	/* Not usable by neutral people	*/ A #define ITEM_ANTI_MAGIC_USER (1 << 12)	/* Not usable by mages		*/ @ #define ITEM_ANTI_CLERIC   (1 << 13)	/* Not usable by clerics	*/@ #define ITEM_ANTI_THIEF	   (1 << 14)	/* Not usable by thieves	*/A #define ITEM_ANTI_WARRIOR  (1 << 15)	/* Not usable by warriors	*/ A #define ITEM_NOSELL	   (1 << 16)	/* Shopkeepers won't touch it	*/     ; /* Modifier constants used with obj affects ('A' fields) */ 3 #define APPLY_NONE              0	/* No effect			*/ : #define APPLY_STR               1	/* Apply to strength		*/; #define APPLY_DEX               2	/* Apply to dexterity		*/ = #define APPLY_INT               3	/* Apply to constitution	*/ 8 #define APPLY_WIS               4	/* Apply to wisdom		*/= #define APPLY_CON               5	/* Apply to constitution	*/ - #define APPLY_CHA		6	/* Apply to charisma		*/ 2 #define APPLY_CLASS             7	/* Reserved			*/2 #define APPLY_LEVEL             8	/* Reserved			*/6 #define APPLY_AGE               9	/* Apply to age			*/8 #define APPLY_CHAR_WEIGHT      10	/* Apply to weight		*/8 #define APPLY_CHAR_HEIGHT      11	/* Apply to height		*/: #define APPLY_MANA             12	/* Apply to max mana		*/? #define APPLY_HIT              13	/* Apply to max hit points	*/ @ #define APPLY_MOVE             14	/* Apply to max move points	*/2 #define APPLY_GOLD             15	/* Reserved			*/2 #define APPLY_EXP              16	/* Reserved			*/= #define APPLY_AC               17	/* Apply to Armor Class		*/ 9 #define APPLY_HITROLL          18	/* Apply to hitroll		*/ = #define APPLY_DAMROLL          19	/* Apply to damage roll		*/ C #define APPLY_SAVING_PARA      20	/* Apply to save throw: paralz	*/ A #define APPLY_SAVING_ROD       21	/* Apply to save throw: rods	*/ C #define APPLY_SAVING_PETRI     22	/* Apply to save throw: petrif	*/ C #define APPLY_SAVING_BREATH    23	/* Apply to save throw: breath	*/ C #define APPLY_SAVING_SPELL     24	/* Apply to save throw: spells	*/       /* Container flags - value[1] */B #define CONT_CLOSEABLE      (1 << 0)	/* Container can be closed	*/A #define CONT_PICKPROOF      (1 << 1)	/* Container is pickproof	*/ ? #define CONT_CLOSED         (1 << 2)	/* Container is closed		*/ ? #define CONT_LOCKED         (1 << 3)	/* Container is locked		*/     J /* Some different kind of liquids for use in values of drink containers */ #define LIQ_WATER      0 #define LIQ_BEER       1 #define LIQ_WINE       2 #define LIQ_ALE        3 #define LIQ_DARKALE    4 #define LIQ_WHISKY     5 #define LIQ_LEMONADE   6 #define LIQ_FIREBRT    7 #define LIQ_LOCALSPC   8 #define LIQ_SLIME      9 #define LIQ_MILK       10  #define LIQ_TEA        11  #define LIQ_COFFE      12  #define LIQ_BLOOD      13  #define LIQ_SALTWATER  14  #define LIQ_CLEARWATER 15     K /* other miscellaneous defines *******************************************/      /* Player conditions */  #define DRUNK        0 #define FULL         1 #define THIRST       2      /* Sun state for weather_data */ #define SUN_DARK	0 #define SUN_RISE	1 #define SUN_LIGHT	2  #define SUN_SET		3    % /* Sky conditions for weather_data */  #define SKY_CLOUDLESS	0  #define SKY_CLOUDY	1 #define SKY_RAINING	2  #define SKY_LIGHTNING	3      /* Rent codes */ #define RENT_UNDEF      0  #define RENT_CRASH      1  #define RENT_RENTED     2  #define RENT_CRYO       3  #define RENT_FORCED     4  #define RENT_TIMEDOUT   5     K /* other #defined constants **********************************************/    /*H  * **DO**NOT** blindly change the number of levels in your MUD merely byM  * changing these numbers and without changing the rest of the code to match. F  * Other changes throughout the code are required.  See coding.doc for  * details.   *E  * LVL_IMPL should always be the HIGHEST possible immortal level, and H  * LVL_IMMORT should always be the LOWEST immortal level.  The number of/  * mortal levels will always be LVL_IMMORT - 1.   */  #define LVL_IMPL	34  #define LVL_GRGOD	33 #define LVL_GOD		32  #define LVL_IMMORT	31   # /* Level of the 'freeze' command */  #define LVL_FREEZE	LVL_GRGOD  C #define NUM_OF_DIRS	6	/* number of directions in a room (nsewud) */ L #define MAGIC_NUMBER	(0x06)	/* Arbitrary number that won't be in a string */  2 #define OPT_USEC	100000	/* 10 passes per second */+ #define PASSES_PER_SEC	(1000000 / OPT_USEC)   #define RL_SEC		* PASSES_PER_SEC  # #define PULSE_ZONE      (10 RL_SEC) # #define PULSE_MOBILE    (10 RL_SEC) " #define PULSE_VIOLENCE  (2 RL_SEC)  / /* Variables for the output buffering system */ M #define MAX_SOCK_BUF            (12 * 1024) /* Size of kernel's sock buf   */ M #define MAX_PROMPT_LENGTH       96          /* Max length of prompt        */ D #define GARBAGE_SPACE		32          /* Space for **OVERFLOW** etc  */D #define SMALL_BUFSIZE		1024        /* Static output buffer size   *// /* Max amount of output that can be buffered */ K #define LARGE_BUFSIZE	   (MAX_SOCK_BUF - GARBAGE_SPACE - MAX_PROMPT_LENGTH)    /*  * --- WARNING ---E  * If you are using a BSD-derived UNIX with MD5 passwords, you _must_ A  * make MAX_PWD_LENGTH larger.  A length of 20 should be good. If C  * you leave it at the default value of 10, then any character with D  * a name longer than about 5 characters will be able to log in withC  * _any_ password.  This has not (yet) been changed to ensure pfile &  * compatibility for those unaffected.  */ 3 #define HISTORY_SIZE		5	/* Keep last 5 commands. */  #define MAX_STRING_LENGTH	8192A #define MAX_INPUT_LENGTH	256	/* Max length per *line* of input */ > #define MAX_RAW_INPUT_LENGTH	512	/* Max size of *raw* input */ #define MAX_MESSAGES		60F #define MAX_NAME_LENGTH		20  /* Used in char_file_u *DO*NOT*CHANGE* */E #define MAX_PWD_LENGTH		10  /* Used in char_file_u *DO*NOT*CHANGE* */ F #define MAX_TITLE_LENGTH	80  /* Used in char_file_u *DO*NOT*CHANGE* */B #define HOST_LENGTH		30  /* Used in char_file_u *DO*NOT*CHANGE* */D #define EXDSCR_LENGTH		240 /* Used in char_file_u *DO*NOT*CHANGE* */A #define MAX_TONGUE		3   /* Used in char_file_u *DO*NOT*CHANGE* */ A #define MAX_SKILLS		200 /* Used in char_file_u *DO*NOT*CHANGE* */ A #define MAX_AFFECT		32  /* Used in char_file_u *DO*NOT*CHANGE* */ E #define MAX_OBJ_AFFECT		6 /* Used in obj_file_elem *DO*NOT*CHANGE* */     G /********************************************************************** G * Structures                                                          * G **********************************************************************/      typedef signed char		sbyte;  typedef unsigned char		ubyte;   typedef signed short int	sh_int;# typedef unsigned short int	ush_int; > #if !defined(__cplusplus)	/* Anyone know a portable method? */ typedef char			bool; #endif   #ifndef CIRCLE_WINDOWS typedef char			byte; #endif  2 typedef sh_int	room_vnum;	/* A room's vnum type */4 typedef sh_int	obj_vnum;	/* An object's vnum type */0 typedef sh_int	mob_vnum;	/* A mob's vnum type */  D typedef sh_int	room_rnum;	/* A room's real (internal) number type */C typedef sh_int	obj_rnum;	/* An object's real (internal) num type */ B typedef sh_int	mob_rnum;	/* A mobile's real (internal) num type */    < /* Extra description: used in objects, mobiles, and rooms */ struct extra_descr_data { H    char	*keyword;                 /* Keyword in look/examine          */H    char	*description;             /* What to see                      */H    struct extra_descr_data *next; /* Next in list                     */ };    H /* object-related structures ******************************************/    $ /* object flags; used in obj_data */ struct obj_flag_data {7    int	value[4];	/* Values of the item (see list)    */ +    byte type_flag;	/* Type of item			    */ 2    int	wear_flags;	/* Where you can wear it	    */5    int	extra_flags;	/* If it hums, glows, etc.	    */ 6    int	weight;		/* Weigt what else                  */4    int	cost;		/* Value when sold (gp.)            */;    int	cost_per_day;	/* Cost to keep pr. real day        */ 5    int	timer;		/* Timer for object                 */ 9    long	bitvector;	/* To set chars bits                */  };    + /* Used in obj_file_elem *DO*NOT*CHANGE* */  struct obj_affected_type {@    byte location;      /* Which ability to change (APPLY_XXX) */@    sbyte modifier;     /* How much it changes by              */ };    H /* ================== Memory Structure for Objects ================== */ struct obj_data { 3    obj_vnum item_number;	/* Where in data-base			*/ <    room_rnum in_room;		/* In what room -1 when conta/carr	*/  H    struct obj_flag_data obj_flags;/* Object information               */D    struct obj_affected_type affected[MAX_OBJ_AFFECT];  /* affects */  H    char	*name;                    /* Title of object :get etc.        */?    char	*description;		  /* When in room                     */ H    char	*short_description;       /* when worn/carry/in cont.         */H    char	*action_description;      /* What to write when used          */H    struct extra_descr_data *ex_description; /* extra descriptions     */H    struct char_data *carried_by;  /* Carried by :NULL in room/conta   */6    struct char_data *worn_by;	  /* Worn by?			      */.    sh_int worn_on;		  /* Worn where?		      */  H    struct obj_data *in_obj;       /* In what object NULL when none    */H    struct obj_data *contains;     /* Contains objects                 */  H    struct obj_data *next_content; /* For 'contains' lists             */H    struct obj_data *next;         /* For the object list              */ };M /* ======================================================================= */     M /* ====================== File Element for Objects ======================= */ B /*                 BEWARE: Changing it will ruin rent files		   */ struct obj_file_elem {    obj_vnum item_number;      int	value[4];    int	extra_flags;     int	weight;
    int	timer;     long	bitvector;5    struct obj_affected_type affected[MAX_OBJ_AFFECT];  };    M /* header block for rent files.  BEWARE: Changing it will ruin rent files  */  struct rent_info {    int	time;    int	rentcode;    int	net_cost_per_diem;     int	gold;    int	account;     int	nitems;    int	spare0;    int	spare1;    int	spare2;    int	spare3;    int	spare4;    int	spare5;    int	spare6;    int	spare7; };M /* ======================================================================= */     L /* room-related structures ************************************************/     struct room_direction_data {:    char	*general_description;       /* When look DIR.			*/  )    char	*keyword;		/* for open/close			*/   (    sh_int exit_info;		/* Exit info				*/5    obj_vnum key;		/* Key's number (-1 for no key)		*/ <    room_rnum to_room;		/* Where direction leads (NOWHERE)	*/ };    J /* ================== Memory Structure for room ======================= */ struct room_data {6    room_vnum number;		/* Rooms number	(vnum)		      */H    sh_int zone;                 /* Room zone (for resetting)          */G    int	sector_type;            /* sector type (move/hide)            */ H    char	*name;                  /* Rooms name 'You are ...'           */H    char	*description;           /* Shown when entered                 */H    struct extra_descr_data *ex_description; /* for examine/look       */H    struct room_direction_data *dir_option[NUM_OF_DIRS]; /* Directions */<    int room_flags;		/* DEATH,DARK ... etc                 */  H    byte light;                  /* Number of lightsources in room     */    SPECIAL(*func);  H    struct obj_data *contents;   /* List of items in room              */H    struct char_data *people;    /* List of NPC / PC in room           */ };L /* ====================================================================== */    L /* char-related structures ************************************************/    % /* memory structure for characters */  struct memory_rec_struct {    long	id; "    struct memory_rec_struct *next; };  , typedef struct memory_rec_struct memory_rec;    E /* This structure is purely intended to be an easy way to transfer */ E /* and return information about time (real or mudwise).            */  struct time_info_data {     int hours, day, month;     sh_int year;  };    > /* These data contain information about a players time data */ struct time_data {K    time_t birth;    /* This represents the characters age                */ K    time_t logon;    /* Time of the last logon (used to calculate played) */ J    int	played;     /* This is the total accumulated time played in secs */ };    9 /* general player-related info, usually PC's and NPC's */  struct char_player_data { A    char	passwd[MAX_PWD_LENGTH+1]; /* character's password      */ @    char	*name;	       /* PC / NPC s name (kill ...  )         */A    char	*short_descr;  /* for NPC 'actions'                    */ 0    char	*long_descr;   /* for 'look'			       */A    char	*description;  /* Extra descriptions                   */ A    char	*title;        /* PC / NPC's title                     */ A    byte sex;           /* PC / NPC's sex                       */ 5    byte chclass;       /* PC / NPC's class		       */ A    byte level;         /* PC / NPC's level                     */ @    int	hometown;      /* PC s Hometown (zone)                 */A    struct time_data time;  /* PC's AGE in days                 */ A    ubyte weight;       /* PC / NPC's weight                    */ A    ubyte height;       /* PC / NPC's height                    */  };    < /* Char's abilities.  Used in char_file_u *DO*NOT*CHANGE* */ struct char_ability_data {
    sbyte str; A    sbyte str_add;      /* 000 - 100 if strength 18             */     sbyte intel; 
    sbyte wis; 
    sbyte dex; 
    sbyte con; 
    sbyte cha;  };    9 /* Char's points.  Used in char_file_u *DO*NOT*CHANGE* */  struct char_point_data {    sh_int mana; 6    sh_int max_mana;     /* Max move for PC/NPC			   */    sh_int hit;E    sh_int max_hit;      /* Max hit for PC/NPC                      */     sh_int move; E    sh_int max_move;     /* Max move for PC/NPC                     */   E    sh_int armor;        /* Internal -100..100, external -10..10 AC */ D    int	gold;           /* Money carried                           */>    int	bank_gold;	/* Gold the char has in a bank account	   */D    int	exp;            /* The experience of the player            */  E    sbyte hitroll;       /* Any bonus or penalty to the hit roll    */ E    sbyte damroll;       /* Any bonus or penalty to the damage roll */  };     /*  G  * char_special_data_saved: specials which both a PC and an NPC have in >  * common, but which must be saved to the playerfile for PC's.  *B  * WARNING:  Do not change this structure.  Doing so will ruin theD  * playerfile.  If you want to add to the playerfile, use the spares  * in player_special_data.  */   struct char_special_data_saved {=    int	alignment;		/* +-1000 for alignments                */ 5    long	idnum;			/* player's idnum; -1 for mobiles	*/ =    long	act;			/* act flag for NPC's; player flag for PC's */   C    long	affected_by;		/* Bitvector for spells/skills affected by */ >    sh_int apply_saving_throw[5]; /* Saving throw (Bonuses)		*/ };    L /* Special playing constants shared by PCs and NPCs which aren't in pfile */ struct char_special_data {0    struct char_data *fighting;	/* Opponent				*/=    struct char_data *hunting;	/* Char hunted by this char		*/   ;    byte position;		/* Standing, fighting, sleeping, etc.	*/   ,    int	carry_weight;		/* Carried weight			*/4    byte carry_items;		/* Number of items carried		*/(    int	timer;			/* Timer for update			*/  I    struct char_special_data_saved saved; /* constants saved in plrfile	*/  };     /*H  *  If you want to add new values to the playerfile, do it here.  DO NOTF  * ADD, DELETE OR MOVE ANY OF THE VARIABLES - doing so will change theJ  * size of the structure and ruin the playerfile.  However, you can changeJ  * the names of the spares to something more meaningful, and then use themE  * in your new code.  They will automatically be transferred from the .  * playerfile into memory when players log in.  */ " struct player_special_data_saved {A    byte skills[MAX_SKILLS+1];	/* array of skills plus skill 0		*/ 4    byte PADDING0;		/* used to be spells_to_learn		*/8    bool talks[MAX_TONGUE];	/* PC s Tongues 0 for NPC		*/;    int	wimp_level;		/* Below this # of hit points, flee!	*/ @    byte freeze_level;		/* Level of god who froze char, if any	*/4    sh_int invis_level;		/* level of invisibility		*/;    room_vnum load_room;		/* Which room to place char in		*/ 1    long	pref;			/* preference flags for PC's.		*/ 7    ubyte bad_pws;		/* number of bad password attemps	*/ <    sbyte conditions[3];         /* Drunk, full, thirsty			*/  G    /* spares below for future expansion.  You can change the names from G       'sparen' to something meaningful, but don't change the order.  */       ubyte spare0;    ubyte spare1;    ubyte spare2;    ubyte spare3;    ubyte spare4;    ubyte spare5;C    int spells_to_learn;		/* How many can you learn yet this level*/     int olc_zone;    int spare8;    int spare9;    int spare10;     int spare11;     int spare12;     int spare13;     int spare14;     int spare15;     int spare16;     long	spare17;    long	spare18;    long	spare19;    long	spare20;    long	spare21; };   /*F  * Specials needed only by PCs, not NPCs.  Space for this structure isF  * not allocated in memory for NPCs, but it is for PCs and the portionI  * of it labelled 'saved' is saved in the playerfile.  This structure can C  * be changed freely; beware, though, that changing the contents of 9  * player_special_data_saved will corrupt the playerfile.   */  struct player_special_data {*    struct player_special_data_saved saved;  <    char	*poofin;		/* Description on arrival of a god.     */=    char	*poofout;		/* Description upon a god's exit.       */ 5    struct alias *aliases;	/* Character's aliases			*/ 2    long last_tell;		/* idnum of last tell from		*/-    void *last_olc_targ;		/* olc control				*/ +    int last_olc_mode;		/* olc control				*/  };    $ /* Specials used by NPCs, not PCs */ struct mob_special_data { I    byte last_direction;     /* The last direction the monster went     */ H    int	attack_type;        /* The Attack Type Bitvector for NPC's     */I    byte default_pos;        /* Default position for NPC                */ E    memory_rec *memory;	    /* List of attackers to remember	       */ D    byte damnodice;          /* The number of damage dice's	       */I    byte damsizedice;        /* The size of the damage dice's           */ >    int wait_state;	    /* Wait state for bashed mobs	       */ };    ? /* An affect structure.  Used in char_file_u *DO*NOT*CHANGE* */  struct affected_type {F    sh_int type;          /* The type of spell that caused this      */F    sh_int duration;      /* For how long its effects will last      */F    sbyte modifier;       /* This is added to apropriate ability     */F    byte location;        /* Tells which ability to change(APPLY_XXX)*/F    long	bitvector;       /* Tells which bits to set (AFF_XXX)       */      struct affected_type *next; };    4 /* Structure used for chars following other chars */ struct follow_type {    struct char_data *follower;    struct follow_type *next; };    N /* ================== Structure for player/non-player ===================== */ struct char_data {+    int pfilepos;			 /* playerfile pos		  */ =    sh_int nr;                            /* Mob's rnum			  */ L    room_rnum in_room;                    /* Location (real room number)	  */?    room_rnum was_in_room;		 /* location for linkdead people  */   L    struct char_player_data player;       /* Normal data                   */L    struct char_ability_data real_abils;	 /* Abilities without modifiers   */K    struct char_ability_data aff_abils;	 /* Abils with spells/stones/etc  */ L    struct char_point_data points;        /* Points                        */B    struct char_special_data char_specials;	/* PC/NPC specials	  */D    struct player_special_data *player_specials; /* PC specials		  */>    struct mob_special_data mob_specials;	/* NPC specials		  */  L    struct affected_type *affected;       /* affected by what spells       */L    struct obj_data *equipment[NUM_WEARS];/* Equipment array               */  L    struct obj_data *carrying;            /* Head of list                  */L    struct descriptor_data *desc;         /* NULL for mobiles              */  L    struct char_data *next_in_room;     /* For room->people - list         */L    struct char_data *next;             /* For either monster or ppl-list  */L    struct char_data *next_fighting;    /* For fighting list               */  L    struct follow_type *followers;        /* List of chars followers       */L    struct char_data *master;             /* Who is char following?        */ };L /* ====================================================================== */    L /* ==================== File Structure for Player ======================= */A /*             BEWARE: Changing it will ruin the playerfile		  */  struct char_file_u {    /* char_player_data */      char	name[MAX_NAME_LENGTH+1];#    char	description[EXDSCR_LENGTH]; "    char	title[MAX_TITLE_LENGTH+1];    byte sex;    byte chclass;    byte level;    sh_int hometown; 7    time_t birth;   /* Time of birth of character     */ 6    int	played;    /* Number of secs played in total */    ubyte weight;    ubyte height;  <    char	pwd[MAX_PWD_LENGTH+1];    /* character's password */  6    struct char_special_data_saved char_specials_saved;:    struct player_special_data_saved player_specials_saved;&    struct char_ability_data abilities;!    struct char_point_data points; -    struct affected_type affected[MAX_AFFECT];   9    time_t last_logon;		/* Time (in secs) of last logon */ 5    char host[HOST_LENGTH+1];	/* host of last logon */  };L /* ====================================================================== */    L /* descriptor-related structures ******************************************/     struct txt_block {    char	*text;    int aliased;     struct txt_block *next; };     struct txt_q {    struct txt_block *head;    struct txt_block *tail; };     struct descriptor_data {9    socket_t	descriptor;	/* file descriptor for socket		*/ .    char	host[HOST_LENGTH+1];	/* hostname				*/;    byte	bad_pws;		/* number of bad pw attemps this login	*/ 7    byte idle_tics;		/* tics idle at password prompt		*/ 1    int	connected;		/* mode of 'connectedness'		*/ -    int	wait;			/* wait for how many loops		*/ 4    int	desc_num;		/* unique num assigned to desc		*/7    time_t login_time;		/* when the person connected		*/ B    char *showstr_head;		/* for keeping track of an internal str	*/9    char **showstr_vector;	/* for paging through texts		*/ =    int  showstr_count;		/* number of pages to page through	*/ A    int  showstr_page;		/* which page are we currently showing?	*/ 1    char	**str;			/* for the modify-str system		*/ %    size_t max_str;	        /*		-			*/ 9    char *backstr;		/* added for handling abort buffers	*/ .    long	mail_to;		/* name for mail system			*/>    int	has_prompt;		/* is the user at a prompt?             */A    char	inbuf[MAX_RAW_INPUT_LENGTH];  /* buffer for raw input		*/ <    char	last_input[MAX_INPUT_LENGTH]; /* the last input			*/C    char small_outbuf[SMALL_BUFSIZE];  /* standard output buffer		*/ 8    char *output;		/* ptr to the current output buffer	*/<    char **history;		/* History of commands, for ! mostly.	*/4    int	history_pos;		/* Circular array position.		*/5    int  bufptr;			/* ptr to end of current output		*/ 7    int	bufspace;		/* space left in the output buffer	*/ K    struct txt_block *large_outbuf; /* ptr to large buffer, if we need it */ 5    struct txt_q input;		/* q of unprocessed input		*/ 6    struct char_data *character;	/* linked to char			*/?    struct char_data *original;	/* original char if switched		*/ D    struct descriptor_data *snooping; /* Who is this char snooping	*/H    struct descriptor_data *snoop_by; /* And who is snooping this char	*/?    struct descriptor_data *next; /* link to next descriptor		*/ C    struct olc_data *olc;	     /*. OLC info - defined in olc.h   .*/  };    J /* other miscellaneous structures ***************************************/     struct msg_type { 1    char	*attacker_msg;  /* message to attacker */ 1    char	*victim_msg;    /* message to victim   */ 1    char	*room_msg;      /* message to room     */  };     struct message_type { 7    struct msg_type die_msg;	/* messages when death			*/ 7    struct msg_type miss_msg;	/* messages when miss			*/ 5    struct msg_type hit_msg;	/* messages when hit			*/ ;    struct msg_type god_msg;	/* messages when hit on god		*/ B    struct message_type *next;	/* to next messages of this kind.	*/ };     struct message_list { %    int	a_type;			/* Attack type				*/ G    int	number_of_attacks;	/* How many attack messages to chose from. */ 6    struct message_type *msg;	/* List of messages.			*/ };     struct dex_skill_type {     sh_int p_pocket;     sh_int p_locks;    sh_int traps;    sh_int sneak;    sh_int hide;  };     struct dex_app_type {     sh_int reaction;     sh_int miss_att;     sh_int defensive; };     struct str_app_type { =    sh_int tohit;    /* To Hit (THAC0) Bonus/Penalty        */ =    sh_int todam;    /* Damage Bonus/Penalty                */ =    sh_int carry_w;  /* Maximum weight that can be carrried */ =    sh_int wield_w;  /* Maximum weight that can be wielded  */  };     struct wis_app_type { B    byte bonus;       /* how many practices player gains per lev */ };     struct int_app_type { C    byte learn;       /* how many % a player learns a spell/skill */  };     struct con_app_type {     sh_int hitp;     sh_int shock; };     struct weather_data { 1    int	pressure;	/* How is the pressure ( Mb ) */ :    int	change;	/* How fast and what way does it change. */!    int	sky;	/* How is the sky. */ (    int	sunlight;	/* And how much sun. */ };     struct title_type {     char	*title_m;     char	*title_f;     int	exp;  };    2 /* element in monster and object index-tables   */ struct index_data { 3    int	vnum;		/* virtual number of this mob/obj		*/ >    int	number;		/* number of existing units of this mob/obj	*/    SPECIAL(*func); };