K /* ************************************************************************ K *   File: utils.h                                       Part of CircleMUD * K *  Usage: header file: utility macros and prototypes of utility funcs     * K *                                                                         * K *  All rights reserved.  See license.doc for complete information.        * K *                                                                         * K *  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University * K *  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               * K ************************************************************************ */     K /* external declarations and prototypes **********************************/   ( extern struct weather_data weather_info; extern FILE *logfile;    #define log			basic_mud_log   ! /* public functions in utils.c */ " char	*str_dup(const char *source);0 int	str_cmp(const char *arg1, const char *arg2);8 int	strn_cmp(const char *arg1, const char *arg2, int n);T void	basic_mud_log(const char *format, ...) __attribute__ ((format (printf, 1, 2))); int	touch(const char *path);< void	mudlog(const char *str, int type, int level, int file);* void	log_death_trap(struct char_data *ch); int	number(int from, int to);  int	dice(int number, int size); ? void	sprintbit(long vektor, const char *names[], char *result); = void	sprinttype(int type, const char *names[], char *result); " int	get_line(FILE *fl, char *buf);< int	get_filename(char *orig_name, char *filename, int mode);1 struct time_info_data *age(struct char_data *ch); + int	num_pc_in_room(struct room_data *room); + void	core_dump_real(const char *, ush_int); \ int	replace_str(char **string, char *pattern, char *replacement, int rep_all, int max_size);U void	format_text(char **ptr_string, int mode, struct descriptor_data *d, int maxlen);   7 #define core_dump()		core_dump_real(__FILE__, __LINE__)   " /* random functions in random.c */0 void circle_srandom(unsigned long initial_seed);" unsigned long circle_random(void);  A /* undefine MAX and MIN so that our functions are used instead */ 
 #ifdef MAX
 #undef MAX #endif  
 #ifdef MIN
 #undef MIN #endif   int MAX(int a, int b); int MIN(int a, int b);   /* in magic.c */D bool	circle_follow(struct char_data *ch, struct char_data * victim);   /* in act.informative.c */2 void	look_at_room(struct char_data *ch, int mode);   /* in act.movmement.c */A int	do_simple_move(struct char_data *ch, int dir, int following); ? int	perform_move(struct char_data *ch, int dir, int following);    /* in limits.c */ % int	mana_limit(struct char_data *ch); $ int	hit_limit(struct char_data *ch);% int	move_limit(struct char_data *ch); $ int	mana_gain(struct char_data *ch);# int	hit_gain(struct char_data *ch); $ int	move_gain(struct char_data *ch);) void	advance_level(struct char_data *ch); 2 void	set_title(struct char_data *ch, char *title);. void	gain_exp(struct char_data *ch, int gain);9 void	gain_exp_regardless(struct char_data *ch, int gain); D void	gain_condition(struct char_data *ch, int condition, int value);( void	check_idling(struct char_data *ch); void	point_update(void);* void	update_pos(struct char_data *victim);    K /* various constants *****************************************************/    /* defines for mudlog() */
 #define OFF	0 
 #define BRF	1 
 #define NRM	2 
 #define CMP	3    /* get_filename() */ #define CRASH_FILE	0 #define ETEXT_FILE	1   /* breadth-first searching */  #define BFS_ERROR		-1  #define BFS_ALREADY_THERE	-2 #define BFS_NO_PATH		-3    /*E  * XXX: These constants should be configurable. See act.informative.c *  *	and utils.c for other places to change.  */  /* mud-life time */  #define SECS_PER_MUD_HOUR	75/ #define SECS_PER_MUD_DAY	(24*SECS_PER_MUD_HOUR) 0 #define SECS_PER_MUD_MONTH	(35*SECS_PER_MUD_DAY)1 #define SECS_PER_MUD_YEAR	(17*SECS_PER_MUD_MONTH)   * /* real-life time (remember Real Life?) */ #define SECS_PER_REAL_MIN	601 #define SECS_PER_REAL_HOUR	(60*SECS_PER_REAL_MIN) 1 #define SECS_PER_REAL_DAY	(24*SECS_PER_REAL_HOUR) 2 #define SECS_PER_REAL_YEAR	(365*SECS_PER_REAL_DAY)    K /* string utils **********************************************************/     % #define YESNO(a) ((a) ? "YES" : "NO") % #define ONOFF(a) ((a) ? "ON" : "OFF")   F #define LOWER(c)   (((c)>='A'  && (c) <= 'Z') ? ((c)+('a'-'A')) : (c))G #define UPPER(c)   (((c)>='a'  && (c) <= 'z') ? ((c)+('A'-'a')) : (c) )   2 #define ISNEWL(ch) ((ch) == '\n' || (ch) == '\r') ' #define IF_STR(st) ((st) ? (st) : "\0") + #define CAP(st)  (*(st) = UPPER(*(st)), st)   ? #define AN(string) (strchr("aeiouAEIOU", *string) ? "an" : "a")     K /* memory utils **********************************************************/     + #define CREATE(result, type, number)  do {\ = 	if (!((result) = (type *) calloc ((number), sizeof(type))))\ 3 		{ perror("malloc failure"); abort(); } } while(0)   * #define RECREATE(result,type,number) do {\J   if (!((result) = (type *) realloc ((result), sizeof(type) * (number))))\4 		{ perror("realloc failure"); abort(); } } while(0)   /*L  * the source previously used the same code in many places to remove an itemI  * from a list: if it's the list head, change the head, else traverse the J  * list looking for the item before the one to be removed.  Now, we have aL  * macro to do this.  To use, just make sure that there is a variable 'temp'I  * declared as the same type as the list to be manipulated.  BTW, this is K  * a great application for C++ templates but, alas, this is not C++.  Maybe   * CircleMUD 4.0 will be...   */ , #define REMOVE_FROM_LIST(item, head, next)	\    if ((item) == (head))		\        head = (item)->next;		\     else {				\       temp = head;			\.       while (temp && (temp->next != (item))) \ 	 temp = temp->next;		\        if (temp)				\%          temp->next = (item)->next;	\ 
    }					\    K /* basic bitvector utils *************************************************/     * #define IS_SET(flag,bit)  ((flag) & (bit))* #define SET_BIT(var,bit)  ((var) |= (bit)). #define REMOVE_BIT(var,bit)  ((var) &= ~(bit))3 #define TOGGLE_BIT(var,bit) ((var) = (var) ^ (bit))    /*L  * Accessing player specific data structures on a mobile is a very bad thingN  * to do.  Consider that changing these variables for a single mob will changeN  * it for every other single mob in the game.  If we didn't specifically checkI  * for it, 'wimpy' would be an extremely bad thing for a mob to do, as an H  * example.  If you really couldn't care less, change this to a '#if 0'.  */  #if 1 7 /* Subtle bug in the '#var', but works well for now. */ ' #define CHECK_PLAYER_SPECIAL(ch, var) \  	(*(((ch)->player_specials == &dummy_mob) ? (log("SYSERR: Mob using '"#var"' at %s:%d.", __FILE__, __LINE__), &(var)) : &(var))) #else + #define CHECK_PLAYER_SPECIAL(ch, var)	(var)  #endif  5 #define MOB_FLAGS(ch) ((ch)->char_specials.saved.act) 5 #define PLR_FLAGS(ch) ((ch)->char_specials.saved.act) U #define PRF_FLAGS(ch) CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.pref)) = #define AFF_FLAGS(ch) ((ch)->char_specials.saved.affected_by) 1 #define ROOM_FLAGS(loc) (world[(loc)].room_flags)   6 #define IS_NPC(ch)  (IS_SET(MOB_FLAGS(ch), MOB_ISNPC))2 #define IS_MOB(ch)  (IS_NPC(ch) && ((ch)->nr >-1))  K #define MOB_FLAGGED(ch, flag) (IS_NPC(ch) && IS_SET(MOB_FLAGS(ch), (flag))) L #define PLR_FLAGGED(ch, flag) (!IS_NPC(ch) && IS_SET(PLR_FLAGS(ch), (flag)))= #define AFF_FLAGGED(ch, flag) (IS_SET(AFF_FLAGS(ch), (flag))) = #define PRF_FLAGGED(ch, flag) (IS_SET(PRF_FLAGS(ch), (flag))) A #define ROOM_FLAGGED(loc, flag) (IS_SET(ROOM_FLAGS(loc), (flag))) D #define EXIT_FLAGGED(exit, flag) (IS_SET((exit)->exit_info, (flag)))I #define OBJVAL_FLAGGED(obj, flag) (IS_SET(GET_OBJ_VAL((obj), 1), (flag))) P #define OBJWEAR_FLAGGED(obj, flag) (IS_SET((obj)->obj_flags.wear_flags, (flag)))C #define OBJ_FLAGGED(obj, flag) (IS_SET(GET_OBJ_EXTRA(obj), (flag)))   - /* IS_AFFECTED for backwards compatibility */ ; #define IS_AFFECTED(ch, skill) (AFF_FLAGGED((ch), (skill)))   K #define PLR_TOG_CHK(ch,flag) ((TOGGLE_BIT(PLR_FLAGS(ch), (flag))) & (flag)) K #define PRF_TOG_CHK(ch,flag) ((TOGGLE_BIT(PRF_FLAGS(ch), (flag))) & (flag))     K /* room utils ************************************************************/     . #define SECT(room)	(world[(room)].sector_type)  0 #define IS_DARK(room)  ( !world[room].light && \<                          (ROOM_FLAGGED(room, ROOM_DARK) || \<                           ( ( SECT(room) != SECT_INSIDE && \<                               SECT(room) != SECT_CITY ) && \B                             (weather_info.sunlight == SUN_SET || \/ 			     weather_info.sunlight == SUN_DARK)) ) )   ( #define IS_LIGHT(room)  (!IS_DARK(room))  d #define GET_ROOM_VNUM(rnum)	((rnum) >= 0 && (rnum) <= top_of_world ? world[(rnum)].number : NOWHERE)E #define GET_ROOM_SPEC(room) ((room) >= 0 ? world[(room)].func : NULL)   K /* char utils ************************************************************/     # #define IN_ROOM(ch)	((ch)->in_room) * #define GET_WAS_IN(ch)	((ch)->was_in_room)' #define GET_AGE(ch)     (age(ch)->year)   ' #define GET_NAME(ch)    (IS_NPC(ch) ? \ 1 			 (ch)->player.short_descr : (ch)->player.name) , #define GET_TITLE(ch)   ((ch)->player.title), #define GET_LEVEL(ch)   ((ch)->player.level), #define GET_PASSWD(ch)	((ch)->player.passwd)( #define GET_PFILEPOS(ch)((ch)->pfilepos)   /*I  * I wonder if this definition of GET_REAL_LEVEL should be the definition   * of GET_LEVEL?  JE  */  #define GET_REAL_LEVEL(ch) \F    (ch->desc && ch->desc->original ? GET_LEVEL(ch->desc->original) : \     GET_LEVEL(ch))  . #define GET_CLASS(ch)   ((ch)->player.chclass), #define GET_HOME(ch)	((ch)->player.hometown), #define GET_HEIGHT(ch)	((ch)->player.height), #define GET_WEIGHT(ch)	((ch)->player.weight)& #define GET_SEX(ch)	((ch)->player.sex)  - #define GET_STR(ch)     ((ch)->aff_abils.str) 1 #define GET_ADD(ch)     ((ch)->aff_abils.str_add) - #define GET_DEX(ch)     ((ch)->aff_abils.dex) / #define GET_INT(ch)     ((ch)->aff_abils.intel) - #define GET_WIS(ch)     ((ch)->aff_abils.wis) - #define GET_CON(ch)     ((ch)->aff_abils.con) - #define GET_CHA(ch)     ((ch)->aff_abils.cha)   ( #define GET_EXP(ch)	  ((ch)->points.exp). #define GET_AC(ch)        ((ch)->points.armor)( #define GET_HIT(ch)	  ((ch)->points.hit)0 #define GET_MAX_HIT(ch)	  ((ch)->points.max_hit)* #define GET_MOVE(ch)	  ((ch)->points.move)1 #define GET_MAX_MOVE(ch)  ((ch)->points.max_move) * #define GET_MANA(ch)	  ((ch)->points.mana)1 #define GET_MAX_MANA(ch)  ((ch)->points.max_mana) * #define GET_GOLD(ch)	  ((ch)->points.gold)2 #define GET_BANK_GOLD(ch) ((ch)->points.bank_gold)0 #define GET_HITROLL(ch)	  ((ch)->points.hitroll)0 #define GET_DAMROLL(ch)   ((ch)->points.damroll)  4 #define GET_POS(ch)	  ((ch)->char_specials.position)9 #define GET_IDNUM(ch)	  ((ch)->char_specials.saved.idnum) < #define IS_CARRYING_W(ch) ((ch)->char_specials.carry_weight); #define IS_CARRYING_N(ch) ((ch)->char_specials.carry_items) 5 #define FIGHTING(ch)	  ((ch)->char_specials.fighting) 3 #define HUNTING(ch)	  ((ch)->char_specials.hunting) K #define GET_SAVE(ch, i)	  ((ch)->char_specials.saved.apply_saving_throw[i]) ? #define GET_ALIGNMENT(ch) ((ch)->char_specials.saved.alignment)   c #define GET_COND(ch, i)		CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.conditions[(i)])) ] #define GET_LOADROOM(ch)	CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.load_room)) d #define GET_PRACTICES(ch)	CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.spells_to_learn))` #define GET_INVIS_LEV(ch)	CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.invis_level))^ #define GET_WIMP_LEV(ch)	CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.wimp_level))b #define GET_FREEZE_LEV(ch)	CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.freeze_level))[ #define GET_BAD_PWS(ch)		CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.bad_pws)) \ #define GET_TALK(ch, i)		CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.talks[i]))O #define POOFIN(ch)		CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->poofin)) Q #define POOFOUT(ch)		CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->poofout)) ` #define GET_LAST_OLC_TARG(ch)	CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->last_olc_targ))` #define GET_LAST_OLC_MODE(ch)	CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->last_olc_mode))U #define GET_ALIASES(ch)		CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->aliases)) X #define GET_LAST_TELL(ch)	CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->last_tell))  ] #define GET_SKILL(ch, i)	CHECK_PLAYER_SPECIAL((ch), ((ch)->player_specials->saved.skills[i])) w #define SET_SKILL(ch, i, pct)	do { CHECK_PLAYER_SPECIAL((ch), (ch)->player_specials->saved.skills[i]) = pct; } while(0)   + #define GET_EQ(ch, i)		((ch)->equipment[i])   G #define GET_MOB_SPEC(ch)	(IS_MOB(ch) ? mob_index[(ch)->nr].func : NULL) % #define GET_MOB_RNUM(mob)	((mob)->nr) * #define GET_MOB_VNUM(mob)	(IS_MOB(mob) ? \, 				 mob_index[GET_MOB_RNUM(mob)].vnum : -1)  8 #define GET_MOB_WAIT(ch)	((ch)->mob_specials.wait_state)< #define GET_DEFAULT_POS(ch)	((ch)->mob_specials.default_pos)/ #define MEMORY(ch)		((ch)->mob_specials.memory)   " #define STRENGTH_APPLY_INDEX(ch) \D         ( ((GET_ADD(ch)==0) || (GET_STR(ch) != 18)) ? GET_STR(ch) :\'           (GET_ADD(ch) <= 50) ? 26 :( \ '           (GET_ADD(ch) <= 75) ? 27 :( \ '           (GET_ADD(ch) <= 90) ? 28 :( \ B           (GET_ADD(ch) <= 99) ? 29 :  30 ) ) )                   \	         )   C #define CAN_CARRY_W(ch) (str_app[STRENGTH_APPLY_INDEX(ch)].carry_w) G #define CAN_CARRY_N(ch) (5 + (GET_DEX(ch) >> 1) + (GET_LEVEL(ch) >> 1)) . #define AWAKE(ch) (GET_POS(ch) > POS_SLEEPING) #define CAN_SEE_IN_DARK(ch) \ X    (AFF_FLAGGED(ch, AFF_INFRAVISION) || (!IS_NPC(ch) && PRF_FLAGGED(ch, PRF_HOLYLIGHT)))  1 #define IS_GOOD(ch)    (GET_ALIGNMENT(ch) >= 350) 2 #define IS_EVIL(ch)    (GET_ALIGNMENT(ch) <= -350)5 #define IS_NEUTRAL(ch) (!IS_GOOD(ch) && !IS_EVIL(ch))     K /* descriptor-based utils ************************************************/     ! #define WAIT_STATE(ch, cycle) { \ . 	if ((ch)->desc) (ch)->desc->wait = (cycle); \3 	else if (IS_NPC(ch)) GET_MOB_WAIT(ch) = (cycle); }   B #define CHECK_WAIT(ch)	(((ch)->desc) ? ((ch)->desc->wait > 1) : 0)! #define STATE(d)	((d)->connected)     K /* object utils **********************************************************/     6 #define GET_OBJ_TYPE(obj)	((obj)->obj_flags.type_flag)1 #define GET_OBJ_COST(obj)	((obj)->obj_flags.cost) 9 #define GET_OBJ_RENT(obj)	((obj)->obj_flags.cost_per_day) 9 #define GET_OBJ_EXTRA(obj)	((obj)->obj_flags.extra_flags) 7 #define GET_OBJ_WEAR(obj)	((obj)->obj_flags.wear_flags) = #define GET_OBJ_VAL(obj, val)	((obj)->obj_flags.value[(val)]) 5 #define GET_OBJ_WEIGHT(obj)	((obj)->obj_flags.weight) 3 #define GET_OBJ_TIMER(obj)	((obj)->obj_flags.timer) . #define GET_OBJ_RNUM(obj)	((obj)->item_number)5 #define GET_OBJ_VNUM(obj)	(GET_OBJ_RNUM(obj) >= 0 ? \ , 				 obj_index[GET_OBJ_RNUM(obj)].vnum : -1)I #define IS_OBJ_STAT(obj,stat)	(IS_SET((obj)->obj_flags.extra_flags,stat)) A #define IS_CORPSE(obj)		(GET_OBJ_TYPE(obj) == ITEM_CONTAINER && \   					GET_OBJ_VAL((obj), 3) == 1)  6 #define GET_OBJ_SPEC(obj) ((obj)->item_number >= 0 ? \- 	(obj_index[(obj)->item_number].func) : NULL)   I #define CAN_WEAR(obj, part) (IS_SET((obj)->obj_flags.wear_flags, (part)))     J /* compound utilities and other macros **********************************/   /*I  * Used to compute CircleMUD version. To see if the code running is newer J  * than 3.0pl13, you would use: #if _CIRCLEMUD > CIRCLEMUD_VERSION(3,0,13)  */ 5 #define CIRCLEMUD_VERSION(major, minor, patchlevel) \ 2 	(((major) << 16) + ((minor) << 8) + (patchlevel))  M #define HSHR(ch) (GET_SEX(ch) ? (GET_SEX(ch)==SEX_MALE ? "his":"her") :"its") M #define HSSH(ch) (GET_SEX(ch) ? (GET_SEX(ch)==SEX_MALE ? "he" :"she") : "it") M #define HMHR(ch) (GET_SEX(ch) ? (GET_SEX(ch)==SEX_MALE ? "him":"her") : "it")   D #define ANA(obj) (strchr("aeiouyAEIOUY", *(obj)->name) ? "An" : "A")E #define SANA(obj) (strchr("aeiouyAEIOUY", *(obj)->name) ? "an" : "a")     + /* Various macros building up to CAN_SEE */   8 #define LIGHT_OK(sub)	(!AFF_FLAGGED(sub, AFF_BLIND) && \E    (IS_LIGHT((sub)->in_room) || AFF_FLAGGED((sub), AFF_INFRAVISION)))    #define INVIS_OK(sub, obj) \O  ((!AFF_FLAGGED((obj),AFF_INVISIBLE) || AFF_FLAGGED(sub,AFF_DETECT_INVIS)) && \ E  (!AFF_FLAGGED((obj), AFF_HIDE) || AFF_FLAGGED(sub, AFF_SENSE_LIFE)))   D #define MORT_CAN_SEE(sub, obj) (LIGHT_OK(sub) && INVIS_OK(sub, obj))   #define IMM_CAN_SEE(sub, obj) \ P    (MORT_CAN_SEE(sub, obj) || (!IS_NPC(sub) && PRF_FLAGGED(sub, PRF_HOLYLIGHT)))  ( #define SELF(sub, obj)  ((sub) == (obj))  & /* Can subject see character "obj"? */. #define CAN_SEE(sub, obj) (SELF(sub, obj) || \H    ((GET_REAL_LEVEL(sub) >= (IS_NPC(obj) ? 0 : GET_INVIS_LEV(obj))) && \    IMM_CAN_SEE(sub, obj)))   /* End of CAN_SEE */      #define INVIS_OK_OBJ(sub, obj) \O   (!IS_OBJ_STAT((obj), ITEM_INVISIBLE) || AFF_FLAGGED((sub), AFF_DETECT_INVIS))   A /* Is anyone carrying this object and if so, are they visible? */ ' #define CAN_SEE_OBJ_CARRIER(sub, obj) \ ;   ((!obj->carried_by || CAN_SEE(sub, obj->carried_by)) &&	\ 1    (!obj->worn_by || CAN_SEE(sub, obj->worn_by)))   $ #define MORT_CAN_SEE_OBJ(sub, obj) \L   (LIGHT_OK(sub) && INVIS_OK_OBJ(sub, obj) && CAN_SEE_OBJ_CARRIER(sub, obj))   #define CAN_SEE_OBJ(sub, obj) \ V    (MORT_CAN_SEE_OBJ(sub, obj) || (!IS_NPC(sub) && PRF_FLAGGED((sub), PRF_HOLYLIGHT)))    #define CAN_CARRY_OBJ(ch,obj)  \I    (((IS_CARRYING_W(ch) + GET_OBJ_WEIGHT(obj)) <= CAN_CARRY_W(ch)) &&   \ 1     ((IS_CARRYING_N(ch) + 1) <= CAN_CARRY_N(ch)))     #define CAN_GET_OBJ(ch, obj)   \E    (CAN_WEAR((obj), ITEM_WEAR_TAKE) && CAN_CARRY_OBJ((ch),(obj)) && \      CAN_SEE_OBJ((ch),(obj)))  G #define PERS(ch, vict)   (CAN_SEE(vict, ch) ? GET_NAME(ch) : "someone")   7 #define OBJS(obj, vict) (CAN_SEE_OBJ((vict), (obj)) ? \ ) 	(obj)->short_description  : "something")   7 #define OBJN(obj, vict) (CAN_SEE_OBJ((vict), (obj)) ? \ " 	fname((obj)->name) : "something")    ? #define EXIT(ch, door)  (world[(ch)->in_room].dir_option[door])   , #define CAN_GO(ch, door) (EXIT(ch,door) && \, 			 (EXIT(ch,door)->to_room != NOWHERE) && \2 			 !IS_SET(EXIT(ch, door)->exit_info, EX_CLOSED))    N #define CLASS_ABBR(ch) (IS_NPC(ch) ? "--" : class_abbrevs[(int)GET_CLASS(ch)])  + #define IS_MAGIC_USER(ch)	(!IS_NPC(ch) && \ ( 				(GET_CLASS(ch) == CLASS_MAGIC_USER))( #define IS_CLERIC(ch)		(!IS_NPC(ch) && \$ 				(GET_CLASS(ch) == CLASS_CLERIC))' #define IS_THIEF(ch)		(!IS_NPC(ch) && \ # 				(GET_CLASS(ch) == CLASS_THIEF)) ) #define IS_WARRIOR(ch)		(!IS_NPC(ch) && \ % 				(GET_CLASS(ch) == CLASS_WARRIOR))   @ #define OUTSIDE(ch) (!ROOM_FLAGGED((ch)->in_room, ROOM_INDOORS))    K /* OS compatibility ******************************************************/     ? /* there could be some strange OS which doesn't have NULL... */  #ifndef NULL #define NULL (void *)0 #endif   #if !defined(FALSE)  #define FALSE 0  #endif   #if !defined(TRUE) #define TRUE  (!FALSE) #endif   /* defines for fseek */  #ifndef SEEK_SET #define SEEK_SET	0 #define SEEK_CUR	1 #define SEEK_END	2 #endif   /*A  * NOCRYPT can be defined by an implementor manually in sysdep.h. 9  * CIRCLE_CRYPT is a variable that the 'configure' script E  * automatically sets when it determines whether or not the system is   * capable of encrypting.   */ . #if defined(NOCRYPT) || !defined(CIRCLE_CRYPT) #define CRYPT(a,b) (a) #else , #define CRYPT(a,b) ((char *) crypt((a),(b))) #endif  