/*
 * functions for writing ID3 tags in LAME
 *
 * text functions stolen from mp3info by Ricardo Cerqueira <rmc@rccn.net>
 * adapted for LAME by Conrad Sanderson <c.sanderson@me.gu.edu.au>
 *
 * 
 */ 
 
#include <stdio.h>
#include <string.h>
#include "id3tag.h"
 
/*
 * If "string" is shorter than "length", pad it with ' ' (spaces)
 */

static void id3_pad(char *string, int length) {
	int l;  l=strlen(string);
	
	while(l<length) { string[l] = ' '; l++; }
	string[l]='\0';
	}


/*
 * initialize temporary fields
 */

void id3_inittag(ID3TAGDATA *tag) {
	strcpy( tag->title, "");
	strcpy( tag->artist, "");
	strcpy( tag->album, "");
	strcpy( tag->year, "");    
	strcpy( tag->comment, "");

	tag->valid = 0;		// not ready for writing
	}

/*
 * build an ID3 tag from temporary fields
 */

void id3_buildtag(ID3TAGDATA *tag) {
	strcpy(tag->tagtext,"TAG");

	id3_pad( tag->title, 30);   strncat( tag->tagtext, tag->title,30);
	id3_pad( tag->artist, 30);  strncat( tag->tagtext, tag->artist,30);
	id3_pad( tag->album, 30);   strncat( tag->tagtext, tag->album,30);
	id3_pad( tag->year, 4);     strncat( tag->tagtext, tag->year,4);
	id3_pad( tag->comment, 30); strncat( tag->tagtext, tag->comment,30);

	strncat( tag->tagtext, "", 1);
	tag->valid = 1;		// ready for writing
	}

/*
 * write ID3 tag 
 */

int id3_writetag(char* filename, ID3TAGDATA *tag) {
	FILE* f;
	if( ! tag->valid ) return -1;

	f=fopen(filename,"rb+");	if(!f) return -1;

	fseek(f,0,SEEK_END); fwrite(tag->tagtext,1,128,f);
	fclose(f); return 0;
	}
