#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 2 "parse.y"
#include <stdio.h>
#include <ctype.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#ifdef VMS
#include "../util/VMSparam.h"
#else
#include <sys/param.h>
#endif /*VMS*/
#include "textBuf.h"
#include "nedit.h"
#include "interpret.h"
#include "parse.h"

/* Macros to add error processing to AddOp and AddSym calls */
#define ADD_OP(op) if (!AddOp(op, &ErrMsg)) return 1
#define ADD_SYM(sym) if (!AddSym(sym, &ErrMsg)) return 1
#define ADD_IMMED(val) if (!AddImmediate(val, &ErrMsg)) return 1
#define ADD_BR_OFF(to) if (!AddBranchOffset(to, &ErrMsg)) return 1
#define SET_BR_OFF(from, to) *((int *)from) = to - from

/* Max. length for a string constant (... there shouldn't be a maximum) */
#define MAX_STRING_CONST_LEN 5000

static int yylex(void);
static int follow(char expect, int yes, int no);
static int follow2(char expect1, int yes1, char expect2, int yes2, int no);
static Symbol *matchesActionRoutine(char **inPtr);

static char *ErrMsg;
static char *InPtr;

#line 36 "parse.y"
typedef union {
    Symbol *sym;
    Inst *inst;
    int nArgs;
} YYSTYPE;
#line 45 "y.tab.c"
#define NUMBER 257
#define STRING 258
#define SYMBOL 259
#define IF 260
#define WHILE 261
#define ELSE 262
#define FOR 263
#define BREAK 264
#define CONTINUE 265
#define RETURN 266
#define ADDEQ 267
#define SUBEQ 268
#define MULEQ 269
#define DIVEQ 270
#define MODEQ 271
#define ANDEQ 272
#define OREQ 273
#define CONCAT 274
#define OR 275
#define AND 276
#define GT 277
#define GE 278
#define LT 279
#define LE 280
#define EQ 281
#define NE 282
#define UNARY_MINUS 283
#define NOT 284
#define INCR 285
#define DECR 286
#define POW 287
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    0,    0,   11,   11,   10,   10,   12,   12,   12,
   12,   12,   12,   12,   12,   12,   13,   13,   13,   13,
   13,   13,   13,   13,   13,   13,   13,   13,   13,    8,
    3,    3,    3,    1,    1,    1,   15,   15,   16,   16,
   16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
   16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
   16,   16,   16,   16,   16,    4,   14,    5,    2,    2,
    6,    7,    9,    9,
};
short yylen[] = {                                         2,
    2,    5,    1,    5,    1,    1,    2,    3,    6,    9,
    6,   10,    3,    3,    4,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    4,    2,    2,    2,    2,    1,
    0,    1,    3,    0,    1,    3,    1,    2,    1,    1,
    1,    4,    3,    3,    3,    3,    3,    3,    3,    2,
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
    2,    2,    2,    2,    2,    1,    1,    1,    0,    1,
    1,    1,    0,    2,
};
short yydefred[] = {                                      0,
    3,    0,    0,    0,    0,   66,   67,    0,    0,    0,
    0,    0,   73,   74,    0,    0,    0,    6,    0,    0,
    0,   27,   29,    0,    0,   73,   73,   39,   40,    0,
    0,    0,    0,    0,   73,    0,    0,    0,   26,   28,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    7,
   73,    0,    0,    0,    0,    0,    0,    0,    0,   63,
   65,    0,    0,    0,   62,   64,    0,    0,   73,    0,
   72,   71,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   32,
   25,    0,   73,    0,   43,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    2,   73,    0,    0,    0,    0,   42,    0,
    0,   33,   73,    0,    5,   11,    0,    0,   68,   73,
    0,    0,    0,   73,   73,   10,    0,    0,   12,
};
short yydgoto[] = {                                       2,
   54,   56,   99,   15,  140,   87,   88,   16,    3,   17,
  134,  135,   19,   20,   55,   38,
};
short yysindex[] = {                                   -250,
    0,    0,  290,    3,  -14,    0,    0,   26,   31,  610,
 -232, -211,    0,    0,   30, -159,  -42,    0,   40,   35,
  256,    0,    0,  256,  256,    0,    0,    0,    0,    6,
  256,  256, -193, -188,    0,  256,  786,  889,    0,    0,
  225,  256,  256,  256,  256,  256,  256,  256,  256,    0,
    0, -255,  256,   -9,  256,   36,  889,   69,   69,    0,
    0,  256, -194, -194,    0,    0,   69,  908,    0,  889,
    0,    0,  256,  256,  256,  256,  256,  256,  256,  256,
  256,  256,  256,  256,  256,  256,  256,  256, -113,   59,
  256,  256,  256,  256,  256,  256,  256,   69,  -22,    0,
    0,  256,    0,    8,    0,   69,  926,  -29,   -3,   -3,
   -3,   -3,   -3,   -3,  -32,  -32, -194, -194, -194, -194,
  889,  889,    0,    0,  256, -255,  256,  327,    0,  327,
   60,    0,    0, -168,    0,    0, -255,  225,    0,    0,
   21,  -70,  327,    0,    0,    0,  327,   69,    0,
};
short yyrindex[] = {                                    423,
    0,    0,    0,  -40,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  120,    0,    0,    0,
    0,    0,    0,   47,   84,    0,    0,    0,    0,   86,
    0,    0,    0,    0,    0,    0,    0,  197,    0,    0,
    0,   84,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -21,   10,    0,   51,    0,  -38,    1,    9,    0,
    0,   47,  122,  161,    0,    0,   17,    0,    0,  681,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   15,   19,   57,   58,   62,   63,  133,   45,    0,    0,
    0,    0,    0,    0,    0,   53,  871,  866,  557,  570,
  749,  781,  820,  834,  493,  525,  346,  385,  421,  457,
  717,  876,    0,    0,   77,    0,   74,    0,    0,    0,
    0,    0,    0,   89,    0,    0,   94,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   61,    0,
};
short yygindex[] = {                                      0,
   75,  -35,    4,    0,    0,    0,    0,    0, 1146,  -41,
 -119,   16,  -50,    0,   37, 1219,
};
#define YYTABLESIZE 1346
short yytable[] = {                                      89,
   13,  100,   70,    4,   85,    1,   90,   85,   14,   83,
  136,  123,   83,   81,   84,   82,   16,   84,   18,   17,
   70,  126,   31,  146,   18,   25,   39,  149,   19,   11,
   12,  101,   50,   85,  102,   26,  125,   31,   83,   81,
   27,   82,   24,   84,    8,   62,   37,   40,  129,   51,
   17,  102,   15,   17,  145,   18,   18,   53,   18,   19,
    4,  144,   19,   21,  126,   65,   20,   21,   17,   42,
   66,   22,   23,   18,   52,  132,  103,   19,   14,   91,
   92,   93,   94,   95,   96,   97,  100,   34,    9,  131,
   34,   35,   86,  139,   35,   41,  142,   20,   21,  124,
   20,   21,   22,   23,   50,   22,   23,   43,   44,   45,
   46,   47,   48,   49,   36,   20,   21,   36,  137,    1,
   22,   23,   41,   41,   69,   13,   41,   41,   41,   41,
   41,   50,   41,   14,   31,   69,  104,   31,  127,    0,
  141,   16,   24,    0,   41,    4,    5,    6,    0,    7,
    8,    9,   10,   18,    0,    0,    0,   50,   50,   50,
    0,   50,   50,   50,   50,   50,   50,    0,   50,    8,
   61,   11,   12,   24,    0,    0,   24,   15,    0,    0,
   50,    0,    0,    0,    0,    4,    0,    0,    4,    5,
    6,   24,    7,    8,    9,   10,    0,   61,   61,    0,
   61,   61,   61,   61,   61,   61,   37,   61,    0,   41,
    0,    0,    0,    9,   11,   12,    4,    5,    6,   61,
    7,    8,    9,   10,    0,    0,   30,   30,   30,   30,
   30,   30,   30,    0,   14,    0,   37,   37,    0,    0,
   37,    0,   11,   12,    0,   50,    0,   75,   76,   77,
   78,   79,   80,    0,   86,   37,    0,   86,    0,   13,
   13,   13,   13,   13,   13,   13,   13,   14,   14,   14,
   14,   14,   14,   14,   14,   16,   16,   16,   16,   16,
   16,   16,   16,   86,   61,   13,   13,   22,   23,    0,
   60,   61,    0,   14,   14,   36,    0,    0,    0,   14,
   31,   16,   16,    8,    8,    8,    8,    8,    8,    8,
    8,   15,   15,   15,   15,   15,   15,   15,   15,    4,
    4,    4,    4,    4,    4,    4,    4,    0,    0,    8,
    8,    0,    0,    0,    0,    0,   14,   15,   15,    0,
    0,    0,   41,   41,   41,    4,    4,    9,    9,    9,
    0,    9,    9,    9,    9,   46,    0,    0,    0,    0,
   41,   41,   41,   41,   41,   41,   41,   41,    0,   41,
    0,    0,   41,    9,    9,    0,    0,    0,   50,   50,
   50,    0,   46,   46,    0,   46,   46,   46,   46,   46,
   46,    0,   46,    0,   47,    0,   50,   50,   50,   50,
   50,   50,   50,   50,   46,   50,   50,   50,    0,    0,
    0,    0,   13,    0,    0,    0,    0,   61,   61,   61,
    0,   47,   47,    0,   47,   47,   47,   47,   47,   47,
   48,   47,   73,    0,    0,   61,   61,   61,   61,   61,
   61,   61,   61,   47,   61,   61,   61,    0,    0,  133,
    0,    0,    0,   37,   37,   37,    0,   48,   48,    0,
   48,   48,   48,   48,   48,   48,   49,   48,    0,   46,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   48,
   37,   37,   37,    4,    5,    6,    0,    7,    8,    9,
   10,    0,    0,   49,   49,    0,   49,   49,   49,   49,
   49,   49,   44,   49,    0,    0,    0,    0,   47,   11,
   12,    0,   28,   29,   30,   49,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   44,    0,   44,   44,   45,   44,   44,   44,    0,   32,
   33,   34,    0,    0,   48,   73,    0,    0,    4,    5,
    6,   44,    7,    8,    9,   10,    0,    0,    0,    0,
    0,    0,   45,    0,   45,   45,   51,   45,   45,   45,
    0,    0,    0,    0,   11,   12,    0,    0,    0,   52,
   49,    0,    0,   45,    0,    4,    5,    6,    0,    7,
    8,    9,   10,    0,   51,    0,   51,   51,    0,    0,
   51,    0,   46,   46,   46,    0,    0,   52,    0,   52,
   52,   11,   12,   52,    0,   51,   44,    0,    0,   35,
   46,   46,   46,   46,   46,   46,   46,   46,   52,   46,
   46,   46,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   47,   47,   47,    0,    0,    0,    0,   45,   36,
    0,    0,    0,    0,   31,    0,    0,    0,    0,   47,
   47,   47,   47,   47,   47,   47,   47,    0,   47,   47,
   47,    0,    0,    0,    0,    0,    0,   48,   48,   48,
   51,   73,   73,   73,    0,   73,   73,   73,   73,    0,
   38,    0,    0,   52,    0,   48,   48,   48,   48,   48,
   48,   48,   48,    0,   48,   48,   48,   73,   73,    0,
    0,    0,    0,   49,   49,   49,    0,    0,    0,    0,
   38,   38,    0,    0,   38,    0,   59,    0,    0,    0,
    0,   49,   49,   49,   49,   49,   49,   49,   49,   38,
   49,   49,   49,    0,    0,    0,    0,    0,    0,   44,
   44,   44,    0,    0,    0,    0,   59,   59,   53,    0,
   59,    0,    0,    0,    0,    0,    0,   44,   44,   44,
   44,   44,   44,   44,   44,   59,   44,   44,   44,    0,
    0,   45,   45,   45,    0,    0,   53,    0,   53,   53,
   54,    0,   53,    0,    0,   69,    0,    0,    0,   45,
   45,   45,   45,   45,   45,   45,   45,   53,   45,   45,
   45,    0,    0,   51,   51,   51,    0,    0,   54,    0,
   54,   54,    0,    0,   54,   36,   52,   52,   52,   55,
   31,   51,   51,   51,   51,   51,   51,   51,   51,   54,
   51,   51,   51,   56,   52,   52,   52,   52,   52,   52,
   52,   52,    0,   52,   52,   52,    0,   55,    0,   55,
   55,    0,    0,   55,    0,    0,   28,   29,   30,    0,
    0,   56,   53,   56,   56,   57,    0,   56,   55,    0,
   58,    0,    0,    0,    0,   60,    0,    0,    0,    0,
    0,    0,   56,   32,   33,   34,    0,    0,    0,    0,
    0,    0,    0,   57,   54,   57,   57,    0,    0,   57,
   58,   58,    0,    0,   58,   60,   60,    0,    0,   60,
    0,    0,    0,    0,   57,   85,   74,    0,    0,   58,
   83,   81,    0,   82,   60,   84,    0,   38,   38,   38,
    0,    0,    0,   55,   85,   74,    0,    0,  105,   83,
   81,    0,   82,    0,   84,    0,    0,   56,    0,    0,
    0,    0,   85,   74,   38,   38,   38,   83,   81,    0,
   82,    0,   84,   59,   59,   59,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   57,
    0,    0,    0,    0,   58,    0,    0,    0,    0,    0,
   59,   59,   59,    0,    0,   53,   53,   53,    0,    0,
    0,    0,   73,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   53,   53,   53,   53,   53,   53,   53,
   53,   73,   53,   53,   53,    0,    0,   54,   54,   54,
    0,    0,   28,   29,   30,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   54,   54,   54,   54,   54,
   54,   54,   54,    0,   54,   54,   54,    0,    0,   32,
   33,   34,    0,    0,    0,    0,   55,   55,   55,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   56,   56,   56,    0,   55,   55,   55,   55,   55,   55,
   55,   55,    0,   55,   55,   55,    0,    0,   56,   56,
   56,   56,   56,   56,   56,   56,    0,   56,   56,   56,
    0,    0,   57,   57,   57,    0,    0,   58,   58,   58,
    0,    0,   60,   60,   60,    0,    0,    0,    0,    0,
   57,   57,    0,    0,    0,   58,   58,    0,    0,   57,
   57,   57,    0,    0,   58,   58,   58,    0,   41,   60,
   60,   60,    0,   71,   72,   75,   76,   77,   78,   79,
   80,   58,   59,    0,    0,   86,    0,    0,    0,    0,
   67,    0,   71,   72,   75,   76,   77,   78,   79,   80,
    0,    0,    0,    0,   86,    0,   98,    0,    0,    0,
    0,    0,   75,   76,   77,   78,   79,   80,    0,    0,
    0,    0,   86,    0,  106,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   57,    0,    0,    0,    0,  128,   63,
   64,    0,    0,    0,   68,   70,    0,    0,    0,    0,
   57,    0,    0,    0,    0,    0,    0,    0,    0,  130,
    0,   70,    0,   70,    0,    0,    0,    0,  138,    0,
    0,    0,    0,    0,    0,  143,    0,    0,    0,  147,
  148,  107,  108,  109,  110,  111,  112,  113,  114,  115,
  116,  117,  118,  119,  120,  121,  122,    0,    0,   70,
   70,   70,   70,   70,   70,   70,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   57,    0,   70,
};
short yycheck[] = {                                      41,
    0,   52,   41,  259,   37,  256,   42,   37,    0,   42,
  130,  125,   42,   43,   47,   45,    0,   47,    3,   10,
   59,   44,   44,  143,   10,   40,  259,  147,   10,  285,
  286,   41,   17,   37,   44,   10,   59,   59,   42,   43,
   10,   45,   40,   47,    0,   40,   10,  259,   41,   10,
   41,   44,    0,   44,  125,   41,   41,   21,   44,   41,
    0,   41,   44,   61,   44,  259,   10,   10,   59,   40,
  259,   10,   10,   59,   40,  126,   41,   59,   10,   43,
   44,   45,   46,   47,   48,   49,  137,   41,    0,  125,
   44,   41,  287,  262,   44,   10,  138,   41,   41,   41,
   44,   44,   41,   41,   89,   44,   44,  267,  268,  269,
  270,  271,  272,  273,   41,   59,   59,   44,   59,    0,
   59,   59,   37,   38,   41,  125,   41,   42,   43,   44,
   45,   10,   47,  125,   41,   59,   62,   44,  102,   -1,
  137,  125,   10,   -1,   59,  259,  260,  261,   -1,  263,
  264,  265,  266,  138,   -1,   -1,   -1,  142,   37,   38,
   -1,   40,   41,   42,   43,   44,   45,   -1,   47,  125,
   10,  285,  286,   41,   -1,   -1,   44,  125,   -1,   -1,
   59,   -1,   -1,   -1,   -1,  125,   -1,   -1,  259,  260,
  261,   59,  263,  264,  265,  266,   -1,   37,   38,   -1,
   40,   41,   42,   43,   44,   45,   10,   47,   -1,  124,
   -1,   -1,   -1,  125,  285,  286,  259,  260,  261,   59,
  263,  264,  265,  266,   -1,   -1,  267,  268,  269,  270,
  271,  272,  273,   -1,   10,   -1,   40,   41,   -1,   -1,
   44,   -1,  285,  286,   -1,  124,   -1,  277,  278,  279,
  280,  281,  282,   -1,  287,   59,   -1,  287,   -1,  259,
  260,  261,  262,  263,  264,  265,  266,  259,  260,  261,
  262,  263,  264,  265,  266,  259,  260,  261,  262,  263,
  264,  265,  266,  287,  124,  285,  286,  285,  286,   -1,
  285,  286,   -1,  285,  286,   40,   -1,   -1,   -1,   10,
   45,  285,  286,  259,  260,  261,  262,  263,  264,  265,
  266,  259,  260,  261,  262,  263,  264,  265,  266,  259,
  260,  261,  262,  263,  264,  265,  266,   -1,   -1,  285,
  286,   -1,   -1,   -1,   -1,   -1,   10,  285,  286,   -1,
   -1,   -1,  257,  258,  259,  285,  286,  259,  260,  261,
   -1,  263,  264,  265,  266,   10,   -1,   -1,   -1,   -1,
  275,  276,  277,  278,  279,  280,  281,  282,   -1,  284,
   -1,   -1,  287,  285,  286,   -1,   -1,   -1,  257,  258,
  259,   -1,   37,   38,   -1,   40,   41,   42,   43,   44,
   45,   -1,   47,   -1,   10,   -1,  275,  276,  277,  278,
  279,  280,  281,  282,   59,  284,  285,  286,   -1,   -1,
   -1,   -1,  123,   -1,   -1,   -1,   -1,  257,  258,  259,
   -1,   37,   38,   -1,   40,   41,   42,   43,   44,   45,
   10,   47,   10,   -1,   -1,  275,  276,  277,  278,  279,
  280,  281,  282,   59,  284,  285,  286,   -1,   -1,  123,
   -1,   -1,   -1,  257,  258,  259,   -1,   37,   38,   -1,
   40,   41,   42,   43,   44,   45,   10,   47,   -1,  124,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,
  284,  285,  286,  259,  260,  261,   -1,  263,  264,  265,
  266,   -1,   -1,   37,   38,   -1,   40,   41,   42,   43,
   44,   45,   10,   47,   -1,   -1,   -1,   -1,  124,  285,
  286,   -1,  257,  258,  259,   59,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   38,   -1,   40,   41,   10,   43,   44,   45,   -1,  284,
  285,  286,   -1,   -1,  124,  123,   -1,   -1,  259,  260,
  261,   59,  263,  264,  265,  266,   -1,   -1,   -1,   -1,
   -1,   -1,   38,   -1,   40,   41,   10,   43,   44,   45,
   -1,   -1,   -1,   -1,  285,  286,   -1,   -1,   -1,   10,
  124,   -1,   -1,   59,   -1,  259,  260,  261,   -1,  263,
  264,  265,  266,   -1,   38,   -1,   40,   41,   -1,   -1,
   44,   -1,  257,  258,  259,   -1,   -1,   38,   -1,   40,
   41,  285,  286,   44,   -1,   59,  124,   -1,   -1,   10,
  275,  276,  277,  278,  279,  280,  281,  282,   59,  284,
  285,  286,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  257,  258,  259,   -1,   -1,   -1,   -1,  124,   40,
   -1,   -1,   -1,   -1,   45,   -1,   -1,   -1,   -1,  275,
  276,  277,  278,  279,  280,  281,  282,   -1,  284,  285,
  286,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,
  124,  259,  260,  261,   -1,  263,  264,  265,  266,   -1,
   10,   -1,   -1,  124,   -1,  275,  276,  277,  278,  279,
  280,  281,  282,   -1,  284,  285,  286,  285,  286,   -1,
   -1,   -1,   -1,  257,  258,  259,   -1,   -1,   -1,   -1,
   40,   41,   -1,   -1,   44,   -1,   10,   -1,   -1,   -1,
   -1,  275,  276,  277,  278,  279,  280,  281,  282,   59,
  284,  285,  286,   -1,   -1,   -1,   -1,   -1,   -1,  257,
  258,  259,   -1,   -1,   -1,   -1,   40,   41,   10,   -1,
   44,   -1,   -1,   -1,   -1,   -1,   -1,  275,  276,  277,
  278,  279,  280,  281,  282,   59,  284,  285,  286,   -1,
   -1,  257,  258,  259,   -1,   -1,   38,   -1,   40,   41,
   10,   -1,   44,   -1,   -1,   10,   -1,   -1,   -1,  275,
  276,  277,  278,  279,  280,  281,  282,   59,  284,  285,
  286,   -1,   -1,  257,  258,  259,   -1,   -1,   38,   -1,
   40,   41,   -1,   -1,   44,   40,  257,  258,  259,   10,
   45,  275,  276,  277,  278,  279,  280,  281,  282,   59,
  284,  285,  286,   10,  275,  276,  277,  278,  279,  280,
  281,  282,   -1,  284,  285,  286,   -1,   38,   -1,   40,
   41,   -1,   -1,   44,   -1,   -1,  257,  258,  259,   -1,
   -1,   38,  124,   40,   41,   10,   -1,   44,   59,   -1,
   10,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,
   -1,   -1,   59,  284,  285,  286,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   38,  124,   40,   41,   -1,   -1,   44,
   40,   41,   -1,   -1,   44,   40,   41,   -1,   -1,   44,
   -1,   -1,   -1,   -1,   59,   37,   38,   -1,   -1,   59,
   42,   43,   -1,   45,   59,   47,   -1,  257,  258,  259,
   -1,   -1,   -1,  124,   37,   38,   -1,   -1,   41,   42,
   43,   -1,   45,   -1,   47,   -1,   -1,  124,   -1,   -1,
   -1,   -1,   37,   38,  284,  285,  286,   42,   43,   -1,
   45,   -1,   47,  257,  258,  259,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,
   -1,   -1,   -1,   -1,  124,   -1,   -1,   -1,   -1,   -1,
  284,  285,  286,   -1,   -1,  257,  258,  259,   -1,   -1,
   -1,   -1,  124,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  275,  276,  277,  278,  279,  280,  281,
  282,  124,  284,  285,  286,   -1,   -1,  257,  258,  259,
   -1,   -1,  257,  258,  259,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  275,  276,  277,  278,  279,
  280,  281,  282,   -1,  284,  285,  286,   -1,   -1,  284,
  285,  286,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  257,  258,  259,   -1,  275,  276,  277,  278,  279,  280,
  281,  282,   -1,  284,  285,  286,   -1,   -1,  275,  276,
  277,  278,  279,  280,  281,  282,   -1,  284,  285,  286,
   -1,   -1,  257,  258,  259,   -1,   -1,  257,  258,  259,
   -1,   -1,  257,  258,  259,   -1,   -1,   -1,   -1,   -1,
  275,  276,   -1,   -1,   -1,  275,  276,   -1,   -1,  284,
  285,  286,   -1,   -1,  284,  285,  286,   -1,   13,  284,
  285,  286,   -1,  275,  276,  277,  278,  279,  280,  281,
  282,   26,   27,   -1,   -1,  287,   -1,   -1,   -1,   -1,
   35,   -1,  275,  276,  277,  278,  279,  280,  281,  282,
   -1,   -1,   -1,   -1,  287,   -1,   51,   -1,   -1,   -1,
   -1,   -1,  277,  278,  279,  280,  281,  282,   -1,   -1,
   -1,   -1,  287,   -1,   69,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   25,   -1,   -1,   -1,   -1,  103,   31,
   32,   -1,   -1,   -1,   36,   37,   -1,   -1,   -1,   -1,
   42,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,
   -1,   53,   -1,   55,   -1,   -1,   -1,   -1,  133,   -1,
   -1,   -1,   -1,   -1,   -1,  140,   -1,   -1,   -1,  144,
  145,   73,   74,   75,   76,   77,   78,   79,   80,   81,
   82,   83,   84,   85,   86,   87,   88,   -1,   -1,   91,
   92,   93,   94,   95,   96,   97,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  125,   -1,  127,
};
#define YYFINAL 2
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 287
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,"'\\n'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'%'","'&'",0,"'('","')'","'*'","'+'","','","'-'",0,"'/'",0,0,0,0,0,
0,0,0,0,0,0,"';'",0,"'='",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'","'|'",
"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,"NUMBER","STRING","SYMBOL","IF","WHILE","ELSE",
"FOR","BREAK","CONTINUE","RETURN","ADDEQ","SUBEQ","MULEQ","DIVEQ","MODEQ",
"ANDEQ","OREQ","CONCAT","OR","AND","GT","GE","LT","LE","EQ","NE","UNARY_MINUS",
"NOT","INCR","DECR","POW",
};
char *yyrule[] = {
"$accept : program",
"program : blank stmts",
"program : blank '{' blank stmts '}'",
"program : error",
"block : '{' blank stmts '}' blank",
"block : stmt",
"stmts : stmt",
"stmts : stmts stmt",
"stmt : simpstmt '\\n' blank",
"stmt : IF '(' cond ')' blank block",
"stmt : IF '(' cond ')' blank block else blank block",
"stmt : while '(' cond ')' blank block",
"stmt : for '(' comastmts ';' cond ';' comastmts ')' blank block",
"stmt : BREAK '\\n' blank",
"stmt : CONTINUE '\\n' blank",
"stmt : RETURN expr '\\n' blank",
"stmt : RETURN '\\n' blank",
"simpstmt : SYMBOL '=' expr",
"simpstmt : evalsym ADDEQ expr",
"simpstmt : evalsym SUBEQ expr",
"simpstmt : evalsym MULEQ expr",
"simpstmt : evalsym DIVEQ expr",
"simpstmt : evalsym MODEQ expr",
"simpstmt : evalsym ANDEQ expr",
"simpstmt : evalsym OREQ expr",
"simpstmt : SYMBOL '(' arglist ')'",
"simpstmt : INCR SYMBOL",
"simpstmt : SYMBOL INCR",
"simpstmt : DECR SYMBOL",
"simpstmt : SYMBOL DECR",
"evalsym : SYMBOL",
"comastmts :",
"comastmts : simpstmt",
"comastmts : comastmts ',' simpstmt",
"arglist :",
"arglist : expr",
"arglist : arglist ',' expr",
"expr : numexpr",
"expr : expr numexpr",
"numexpr : NUMBER",
"numexpr : STRING",
"numexpr : SYMBOL",
"numexpr : SYMBOL '(' arglist ')'",
"numexpr : '(' numexpr ')'",
"numexpr : numexpr '+' numexpr",
"numexpr : numexpr '-' numexpr",
"numexpr : numexpr '*' numexpr",
"numexpr : numexpr '/' numexpr",
"numexpr : numexpr '%' numexpr",
"numexpr : numexpr POW numexpr",
"numexpr : '-' numexpr",
"numexpr : numexpr GT numexpr",
"numexpr : numexpr GE numexpr",
"numexpr : numexpr LT numexpr",
"numexpr : numexpr LE numexpr",
"numexpr : numexpr EQ numexpr",
"numexpr : numexpr NE numexpr",
"numexpr : numexpr '&' numexpr",
"numexpr : numexpr '|' numexpr",
"numexpr : numexpr and numexpr",
"numexpr : numexpr or numexpr",
"numexpr : NOT numexpr",
"numexpr : INCR SYMBOL",
"numexpr : SYMBOL INCR",
"numexpr : DECR SYMBOL",
"numexpr : SYMBOL DECR",
"while : WHILE",
"for : FOR",
"else : ELSE",
"cond :",
"cond : numexpr",
"and : AND",
"or : OR",
"blank :",
"blank : blank '\\n'",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 175 "parse.y"
 /* User Subroutines Section */

/*
** Parse a null terminated string and create a program from it (this is the
** parser entry point).  The program created by this routine can be
** executed using ExecuteProgram.  Returns program on success, or NULL
** on failure.  If the command failed, the error message is returned
** as a pointer to a static string in msg, and the length of the string up
** to where parsing failed in stoppedAt.
*/
Program *ParseMacro(char *expr, char **msg, char **stoppedAt)
{
int yyparse();	/* J.L. Jan-1999	*/

    Program *prog;
    
    BeginCreatingProgram();
    
    /* call yyparse to parse the string and check for success.  If the parse
       failed, return the error message and string index (the grammar aborts
       parsing at the first error) */
    InPtr = expr;
    if (yyparse()) {
    	*msg = ErrMsg;
    	*stoppedAt = InPtr;
    	FreeProgram(FinishCreatingProgram());
    	return NULL;
    }
    
    /* get the newly created program */
    prog = FinishCreatingProgram();
    
    /* parse succeeded */
    *msg = "";
    *stoppedAt = InPtr;
    return prog;
}

static int yylex(void)
{
    int i, len;
    Symbol *s;
    static int stringConstIndex = 0;
    static DataValue value = {0, {0}};
    static char escape[] = "\\\"ntbrfav";
    static char replace[] = "\\\"\n\t\b\r\f\a\v";
    
    /* skip whitespace and backslash-newline combinations which are
       also considered whitespace */
    for (;;) {
    	if (*InPtr == '\\' && *(InPtr + 1) == '\n')
    	    InPtr += 2;
    	else if (*InPtr == ' ' || *InPtr == '\t')
    	    InPtr++;
    	else
    	    break;
    }
    
    /* skip comments */
    if (*InPtr == '#')
    	while (*InPtr != '\n' && *InPtr != '\0') InPtr++;
    
    /* return end of input at the end of the string */
    if (*InPtr == '\0') {
	return 0;
    }
    
    /* process number tokens */
    if (isdigit(*InPtr))  { /* number */
        char name[28];
        sscanf(InPtr, "%d%n", &value.val.n, &len);
        sprintf(name, "const %d", value.val.n);
        InPtr += len;
        value.tag = INT_TAG;
        if ((yylval.sym=LookupSymbol(name)) == NULL)
            yylval.sym = InstallSymbol(name, CONST_SYM, value);
        return NUMBER;
    }
    
    /* process symbol tokens.  "define" is a special case not handled
       by this parser, considered end of input.  Another special case
       is action routine names which are allowed to contain '-' despite
       the ambiguity, handled in matchesActionRoutine. */
    if (isalpha(*InPtr) || *InPtr == '$') {
        if ((s=matchesActionRoutine(&InPtr)) == NULL) {
            char symName[MAX_SYM_LEN+1], *p = symName;
            *p++ = *InPtr++;
            while (isalnum(*InPtr) || *InPtr=='_') {
		if (p >= symName + MAX_SYM_LEN)
		    InPtr++;
		else
		    *p++ = *InPtr++;
	    }
	    *p = '\0';
	    if (!strcmp(symName, "while")) return WHILE;
	    if (!strcmp(symName, "if")) return IF;
	    if (!strcmp(symName, "else")) return ELSE;
	    if (!strcmp(symName, "for")) return FOR;
	    if (!strcmp(symName, "break")) return BREAK;
	    if (!strcmp(symName, "continue")) return CONTINUE;
	    if (!strcmp(symName, "return")) return RETURN;
	    if (!strcmp(symName, "define")) {
	    	InPtr -= 6;
	    	return 0;
	    }
	    if ((s=LookupSymbol(symName)) == NULL) {
        	s = InstallSymbol(symName, symName[0]=='$' ? (isdigit(symName[1]) ?
            		ARG_SYM : GLOBAL_SYM) : LOCAL_SYM, value);
            	s->value.tag = NO_TAG;
            }
	}
	yylval.sym = s;
        return SYMBOL;
    }
    
    /* process quoted strings w/ embedded escape sequences */
    if (*InPtr == '\"') {
        char string[MAX_STRING_CONST_LEN], *p = string;
        char stringName[25];
        InPtr++;
        while (*InPtr != '\0' && *InPtr != '\"' && *InPtr != '\n') {
	    if (p >= string + MAX_STRING_CONST_LEN) {
	    	InPtr++;
	    	continue;
	    }
	    if (*InPtr == '\\') {
		InPtr++;
		if (*InPtr == '\n') {
		    InPtr++;
		    continue;
		}
		for (i=0; escape[i]!='\0'; i++) {
		    if (escape[i] == '\0') {
		    	*p++= *InPtr++;
		    	break;
		    } else if (escape[i] == *InPtr) {
		    	*p++ = replace[i];
		    	InPtr++;
		    	break;
		    }
		}
	    } else
		*p++= *InPtr++;
	}
	*p = '\0';
	InPtr++;
	value.val.str = AllocString(p-string+1);
	strcpy(value.val.str, string);
	value.tag = STRING_TAG;
	sprintf(stringName, "string #%d", stringConstIndex++);
	yylval.sym = InstallSymbol(stringName, CONST_SYM, value);
        return STRING;
    }
    
    /* process remaining two character tokens or return single char as token */
    switch(*InPtr++) {
    case '>':	return follow('=', GE, GT);
    case '<':	return follow('=', LE, LT);
    case '=':	return follow('=', EQ, '=');
    case '!':	return follow('=', NE, NOT);
    case '+':	return follow2('+', INCR, '=', ADDEQ, '+');
    case '-':	return follow2('-', DECR, '=', SUBEQ, '-');
    case '|':	return follow2('|', OR, '=', OREQ, '|');
    case '&':	return follow2('&', AND, '=', ANDEQ, '&');
    case '*':	return follow2('*', POW, '=', MULEQ, '*');
    case '/':   return follow('=', DIVEQ, '/');
    case '%':	return follow('=', MODEQ, '%');
    case '^':	return POW;
    default:	return *(InPtr-1);
    }
}

/*
** look ahead for >=, etc.
*/
static int follow(char expect, int yes, int no)
{
    if (*InPtr++ == expect)
	return yes;
    InPtr--;
    return no;
}
static int follow2(char expect1, int yes1, char expect2, int yes2, int no)
{
    char next = *InPtr++;
    if (next == expect1)
	return yes1;
    if (next == expect2)
    	return yes2;
    InPtr--;
    return no;
}

/*
** Look (way) ahead for hyphenated routine names which begin at inPtr.  A
** hyphenated name is allowed if it is pre-defined in the global symbol
** table.  If a matching name exists, returns the symbol, and update "inPtr".
**
** I know this is horrible language design, but existing nedit action routine
** names contain hyphens.  Handling them here in the lexical analysis process
** is much easier than trying to deal with it in the parser itself.  (sorry)
*/
static Symbol *matchesActionRoutine(char **inPtr)
{
    char *c, *symPtr;
    int hasDash = False;
    char symbolName[MAX_SYM_LEN+1];
    Symbol *s;
    
    symPtr = symbolName;
    for (c = *inPtr; isalnum(*c) || *c=='_' || (*c=='-'&&isalnum(*(c+1))); c++){
    	if (*c == '-')
    	    hasDash = True;
    	*symPtr++ = *c;
    }
    if (!hasDash)
    	return NULL;
    *symPtr = '\0';
    s = LookupSymbol(symbolName);
    if (s != NULL)
    	*inPtr = c;
    return s;
}

/*
** Called by yacc to report errors (just stores for returning when
** parsing is aborted.  The error token action is to immediate abort
** parsing, so this message is immediately reported to the caller
** of ParseExpr)
*/
yyerror(char *s)
{
    ErrMsg = s;
}
#line 787 "y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 61 "parse.y"
{ ADD_OP(OP_RETURN_NO_VAL); return 0; }
break;
case 2:
#line 62 "parse.y"
{ ADD_OP(OP_RETURN_NO_VAL); return 0; }
break;
case 3:
#line 63 "parse.y"
{ return 1; }
break;
case 9:
#line 72 "parse.y"
{ SET_BR_OFF((Inst *)yyvsp[-3].inst, GetPC()); }
break;
case 10:
#line 74 "parse.y"
{ SET_BR_OFF(yyvsp[-6].inst, (yyvsp[-2].inst+1)); SET_BR_OFF(yyvsp[-2].inst, GetPC()); }
break;
case 11:
#line 75 "parse.y"
{ ADD_OP(OP_BRANCH); ADD_BR_OFF(yyvsp[-5].inst);
    	    	SET_BR_OFF(yyvsp[-3].inst, GetPC()); FillLoopAddrs(GetPC(), yyvsp[-5].inst); }
break;
case 12:
#line 78 "parse.y"
{ FillLoopAddrs(GetPC()+2+(yyvsp[-3].inst-(yyvsp[-5].inst+1)), GetPC());
    	    	  SwapCode(yyvsp[-5].inst+1, yyvsp[-3].inst, GetPC());
    	    	  ADD_OP(OP_BRANCH); ADD_BR_OFF(yyvsp[-7].inst); SET_BR_OFF(yyvsp[-5].inst, GetPC()); }
break;
case 13:
#line 82 "parse.y"
{ ADD_OP(OP_BRANCH); ADD_BR_OFF(0); AddBreakAddr(GetPC()-1); }
break;
case 14:
#line 84 "parse.y"
{ ADD_OP(OP_BRANCH); ADD_BR_OFF(0); AddContinueAddr(GetPC()-1); }
break;
case 15:
#line 85 "parse.y"
{ ADD_OP(OP_RETURN); }
break;
case 16:
#line 86 "parse.y"
{ ADD_OP(OP_RETURN_NO_VAL); }
break;
case 17:
#line 88 "parse.y"
{ ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-2].sym); }
break;
case 18:
#line 89 "parse.y"
{ ADD_OP(OP_ADD); ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-2].sym); }
break;
case 19:
#line 90 "parse.y"
{ ADD_OP(OP_SUB); ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-2].sym); }
break;
case 20:
#line 91 "parse.y"
{ ADD_OP(OP_MUL); ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-2].sym); }
break;
case 21:
#line 92 "parse.y"
{ ADD_OP(OP_DIV); ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-2].sym); }
break;
case 22:
#line 93 "parse.y"
{ ADD_OP(OP_MOD); ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-2].sym); }
break;
case 23:
#line 94 "parse.y"
{ ADD_OP(OP_BIT_AND); ADD_OP(OP_ASSIGN);
    	    	ADD_SYM(yyvsp[-2].sym); }
break;
case 24:
#line 96 "parse.y"
{ ADD_OP(OP_BIT_OR); ADD_OP(OP_ASSIGN);
    	    	ADD_SYM(yyvsp[-2].sym); }
break;
case 25:
#line 98 "parse.y"
{ ADD_OP(OP_SUBR_CALL);
	    	ADD_SYM(PromoteToGlobal(yyvsp[-3].sym)); ADD_IMMED((void *)yyvsp[-1].nArgs); }
break;
case 26:
#line 100 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[0].sym); ADD_OP(OP_INCR);
    	    	ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[0].sym); }
break;
case 27:
#line 102 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[-1].sym); ADD_OP(OP_INCR);
		ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-1].sym); }
break;
case 28:
#line 104 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[0].sym); ADD_OP(OP_DECR);
	    	ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[0].sym); }
break;
case 29:
#line 106 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[-1].sym); ADD_OP(OP_DECR);
		ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-1].sym); }
break;
case 30:
#line 109 "parse.y"
{ yyval.sym = yyvsp[0].sym; ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[0].sym); }
break;
case 31:
#line 111 "parse.y"
{ yyval.inst = GetPC(); }
break;
case 32:
#line 112 "parse.y"
{ yyval.inst = GetPC(); }
break;
case 33:
#line 113 "parse.y"
{ yyval.inst = GetPC(); }
break;
case 34:
#line 115 "parse.y"
{ yyval.nArgs = 0;}
break;
case 35:
#line 116 "parse.y"
{ yyval.nArgs = 1; }
break;
case 36:
#line 117 "parse.y"
{ yyval.nArgs = yyvsp[-2].nArgs + 1; }
break;
case 38:
#line 120 "parse.y"
{ ADD_OP(OP_CONCAT); }
break;
case 39:
#line 122 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[0].sym); }
break;
case 40:
#line 123 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[0].sym); }
break;
case 41:
#line 124 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[0].sym); }
break;
case 42:
#line 125 "parse.y"
{ ADD_OP(OP_SUBR_CALL);
	    	ADD_SYM(PromoteToGlobal(yyvsp[-3].sym)); ADD_IMMED((void *)yyvsp[-1].nArgs);
		ADD_OP(OP_FETCH_RET_VAL);}
break;
case 44:
#line 129 "parse.y"
{ ADD_OP(OP_ADD); }
break;
case 45:
#line 130 "parse.y"
{ ADD_OP(OP_SUB); }
break;
case 46:
#line 131 "parse.y"
{ ADD_OP(OP_MUL); }
break;
case 47:
#line 132 "parse.y"
{ ADD_OP(OP_DIV); }
break;
case 48:
#line 133 "parse.y"
{ ADD_OP(OP_MOD); }
break;
case 49:
#line 134 "parse.y"
{ ADD_OP(OP_POWER); }
break;
case 50:
#line 135 "parse.y"
{ ADD_OP(OP_NEGATE); }
break;
case 51:
#line 136 "parse.y"
{ ADD_OP(OP_GT); }
break;
case 52:
#line 137 "parse.y"
{ ADD_OP(OP_GE); }
break;
case 53:
#line 138 "parse.y"
{ ADD_OP(OP_LT); }
break;
case 54:
#line 139 "parse.y"
{ ADD_OP(OP_LE); }
break;
case 55:
#line 140 "parse.y"
{ ADD_OP(OP_EQ); }
break;
case 56:
#line 141 "parse.y"
{ ADD_OP(OP_NE); }
break;
case 57:
#line 142 "parse.y"
{ ADD_OP(OP_BIT_AND); }
break;
case 58:
#line 143 "parse.y"
{ ADD_OP(OP_BIT_OR); }
break;
case 59:
#line 144 "parse.y"
{ ADD_OP(OP_AND); SET_BR_OFF(yyvsp[-1].inst, GetPC()); }
break;
case 60:
#line 145 "parse.y"
{ ADD_OP(OP_OR); SET_BR_OFF(yyvsp[-1].inst, GetPC()); }
break;
case 61:
#line 146 "parse.y"
{ ADD_OP(OP_NOT); }
break;
case 62:
#line 147 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[0].sym); ADD_OP(OP_INCR);
    	    	ADD_OP(OP_DUP); ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[0].sym); }
break;
case 63:
#line 149 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[-1].sym); ADD_OP(OP_DUP);
	    	ADD_OP(OP_INCR); ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-1].sym); }
break;
case 64:
#line 151 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[0].sym); ADD_OP(OP_DECR);
	    	ADD_OP(OP_DUP); ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[0].sym); }
break;
case 65:
#line 153 "parse.y"
{ ADD_OP(OP_PUSH_SYM); ADD_SYM(yyvsp[-1].sym); ADD_OP(OP_DUP);
	    	ADD_OP(OP_DECR); ADD_OP(OP_ASSIGN); ADD_SYM(yyvsp[-1].sym); }
break;
case 66:
#line 156 "parse.y"
{ yyval.inst = GetPC(); StartLoopAddrList(); }
break;
case 67:
#line 158 "parse.y"
{ StartLoopAddrList(); }
break;
case 68:
#line 160 "parse.y"
{ ADD_OP(OP_BRANCH); yyval.inst = GetPC(); ADD_BR_OFF(0); }
break;
case 69:
#line 162 "parse.y"
{ ADD_OP(OP_BRANCH_NEVER); yyval.inst = GetPC(); ADD_BR_OFF(0); }
break;
case 70:
#line 163 "parse.y"
{ ADD_OP(OP_BRANCH_FALSE); yyval.inst = GetPC(); ADD_BR_OFF(0); }
break;
case 71:
#line 165 "parse.y"
{ ADD_OP(OP_DUP); ADD_OP(OP_BRANCH_FALSE); yyval.inst = GetPC();
    	    	ADD_BR_OFF(0); }
break;
case 72:
#line 168 "parse.y"
{ ADD_OP(OP_DUP); ADD_OP(OP_BRANCH_TRUE); yyval.inst = GetPC();
    	    	ADD_BR_OFF(0); }
break;
#line 1205 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
