/*
 *
 *  HEADER FILE FOR : calltree.c
 *
 *  PURPOSE: Defines functions used in calltree.c.
 *
 *  AUTHOR: Doug Hellmann
 *
 *  DATE: 26 August 1995
 *
 *  COMMENTS: 
 *
*/
#ifndef _CALLTREE_H
#define _CALLTREE_H

#include <Xm/Xm.h>

#define SHOW_FUNCTIONS_CALLED (0)
#define SHOW_FUNCTIONS_WHICH_CALL (1)

typedef struct CallTree_struct CallTree;

extern CallTree * CallTree_BuildFromFiles(char*);
extern CallTree * CallTree_ReadFromFile(char*);
extern CallTree * CallTree_BuildFromCommand(char*);
extern void CallTree_Dump(CallTree *, FILE*);

extern Widget CallTree_Display(CallTree * tree, Widget parent, 
		Widget root, int depth, int mode, int show_unknown, 
		int use_search);

extern void CallTree_ExpandVisual(Widget root, int how_far, int use_search);

extern Widget CallTree_DialogCreate(void);
extern void CallTree_InterfaceCreate(Widget);

extern void CallTree_UpdateDisplayFromFileCB(Widget, XtPointer, XtPointer);
extern void CallTree_UpdateDisplayFromCommandCB(Widget, XtPointer, XtPointer);
extern void CallTree_UpdateDisplayCB(Widget, XtPointer, XtPointer);

extern int CallTree_CountLocalChildren(CallTree*, int);
extern void CallTree_UpdateComboBox(CallTree * ct, Boolean notify);
extern void  ChangeExpansionDepthCB(Widget w, XtPointer xtp1, XtPointer xtp2);

extern CallTree * CallTree_FindNode(CallTree*, char*);
extern int CallTree_MarkPath(CallTree * start_node, char * target_name, int mode);
extern void CallTree_ClearPath(CallTree * root_node);

#endif
