#ifndef _CALLTREE_P_H
#define _CALLTREE_P_H
/*
 *
 *  HEADER FILE FOR : calltree.c, xcalltre.c
 *
 *  PURPOSE: Define private data structure used from both files.
 *
 *  AUTHOR: Doug Hellmann
 *
 *  DATE: 6 September 1995
 *
 *  COMMENTS: 
 *
*/
#include "list.h" 
#include "calltree.h"

struct CallTree_struct {

  char * fcn_name;
  
  char * file_name;
  int line_num;
  
  List * calls;      /* linked list of calls made by this fcn */
  List * called_by;  /* functions which call this function */
  CallTree * parent; /* parent of call tree */
  
  List * all_fcns;
  int root_node;
  
  int search_result;	/* did this node match the search? */
  int search_subnode;	/* did a subnode match the search? */
  int search_path;	/* has this node been searched */
};

#endif
