/*
 *
 *  HEADER FILE FOR : client.c
 *
 *  COPYRIGHT: 
 *
 *  PURPOSE: 
 *
 *  AUTHOR: 
 *
 *  DATE: 
 *
 *  COMMENTS: 
 *
*/
#ifndef _CLIENT_H
#define _CLIENT_H

#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <Xm/XmAll.h>
#if XmVersion >= 1002
#include <Xm/RepType.h>
#endif
#ifdef VMS
#include <rmsdef.h>
#include "../util/VMSparam.h"
#include "../util/VMSUtils.h"
#else
#include <sys/param.h>
#endif /*VMS*/
#include "textBuf.h"
#include "nedit.h"
#include "../util/prefFile.h"
#include "preferences.h"
#include "tags.h"
/*
#include "../ccnedit/ccNEdit.h"
*/

#include "DialogF.h"
#include <misc.h>

extern Display *TheDisplay;
extern WindowInfo * WindowList;
extern XtAppContext context;

extern char HeaderText[];
extern char *fallbackResources[];
extern char cmdLineHelp[];
extern PrefDescripRec LocalPrefDescrip[];

extern Widget NeditCreateToplevelDialog(char * widget_name, char * window_name, char * icon_name);
extern void XmListAddItemAlpha(Widget list_w, char * newtext);

extern XrmDatabase CreateLocalPrefDB(char * pref_file_name, char * app_name, 
		XrmOptionDescRec* op_table, int op_table_count,
		int *argcInOut, char **argvInOut);
extern void RestoreLocalPrefs(char * app_name, PrefDescripRec *pref_descrip, int pref_count,
			XrmDatabase prefDB, XrmDatabase appDB);
extern void ClientExitCB(Widget, XtPointer, XtPointer);
extern void RemoteEditFile(char * path, char * filename, int line);

extern char * FileToString(char * filename);

	/* source/shell.c */

	
#define FILTER_BUF_SIZE 256	/* size of buffers for collecting cmd output */
#define MAX_SHELL_CMD_LEN 255	/* max length of a shell command (should be
				   eliminated, but substitutePercent needs) */
#define MAX_OUT_DIALOG_ROWS 30	/* max height of dialog for command output */
#define MAX_OUT_DIALOG_COLS 80	/* max width of dialog for command output */

/* element of a buffer list for collecting output from filter processes */
typedef struct bufElem {
    struct bufElem *next;
    int length;
    char contents[FILTER_BUF_SIZE];
} buffer;


extern void freeBufList(buffer **bufList);
extern void addOutput(buffer **bufList, buffer *buf);

/* flags for issueCommand */
#define ACCUMULATE 1
#define ERROR_DIALOGS 2
#define REPLACE_SELECTION 4

extern char *issueCommandToText(Widget dlogParent, char *command, char *input,
	int flags, Widget textW, int replaceLeft, int replaceRight,
	int *success);
extern char *issueCommandToList(Widget dlogParent, char *command, char *input,
	int flags, Widget listW, int *success);

extern  pid_t forkCommand(Widget parent, char *command, int *stdinFD,
	int *stdoutFD, int *stderrFD);
extern void removeTrailingNewlines(char *string);
extern void createOutputDialog(Widget parent, char *text);
extern void measureText(char *text, int wrapWidth, int *rows, int *cols);
extern void truncateString(char *string, int length);
extern int substitutePercent(char *outStr, char *inStr, char *subsStr,
	int outLen);
extern char *coalesceOutput(buffer **bufList);

	/* tags */


#endif
