.\" pcal.man - documentation for Pcal v4.7
.\"
.TH PCAL 1 "July 27, 1997" "Version 4.7" "USER COMMANDS"
.SH NAME
pcal \- generate PostScript calendars
.SH SYNOPSIS
.na
.in +5n
.ti -5n
.B pcal
[\fB\-e\fP|\fB\-f\fP\ \fIcal\fP\|]
[\fB\-o\fP\ \fIfile\fP\|]
[\fB\-j\fP\ |\ \fB\-J\fP]
[\fB\-l\fP\ |\ \fB\-p\fP]
[\fB\-m\fP\ |\ \fB\-M\fP]
[\fB\-g\fP\ \fIweekday\fR[\fI\-weekday\fR]|all|holiday]
[\fB\-O\fP\ \fIweekday\fR[\fI\-weekday\fR]|all|holiday]
[\fB\-G\fP\ \fIweekday\fR[\fI\-weekday\fR]|all|holiday]
[\fB\-b\fP\ \fIweekday\fR[\fI\-weekday\fR]|all|holiday]
[\fB\-s\fP\ [\fIdate_shade\fP][/\fIfill_shade\fP\|]]
[\fB\-F\fP\ \fIday\fP\|]
[\fB\-A\fP|\fB\-E\fP]
[\fB\-t\fP\ [\fItitle_font\fP][/\fIsize\fP\|]]
[\fB\-d\fP\ [\fIday_font\fP][/\fIsize\fP\|]]
[\fB\-n\fP\ [\fItext_font\fP][/\fIsize\fP\|]]
[\fB\-r\fP\ [\fImapping\fP]
[\fB\-L\fP\ \fIfooter_str\fP\|]
[\fB\-C\fP\ \fIfooter_str\fP\|]
[\fB\-R\fP\ \fIfooter_str\fP\|]
[\fB\-N\fP\ \fInotes_str\fP\|]
[\fB\-D\fP\ \fIsymbol\fP\|]
[\fB\-U\fP\ \fIsymbol\fP\|]
[\fB\-x\fP\ \fIxscale\fP\|]
[\fB\-y\fP\ \fIyscale\fP\|]
[\fB\-X\fP\ \fIxtrans\fP\|]
[\fB\-Y\fP\ \fIytrans\fP\|]
[\fB\-I\fP]
[\fB\-c\fP\ |\ \fB\-H\fP]
[\fB\-z\fP\ \fItime_zone\fP\|]
[\fB\-B\fP]
[\fB\-#\fP\ \fIn\fP\|]
[\fB\-S\fP\ |\ \fB\-k\fP\ |\ \fB\-K\fP]
[\fB\-w\fP]
[\fB\-h\fP\ |\ \fB\-u\fP\ |\ \fB\-v\fP]
[\fB\-a\fP\ \fIlanguage\fP\|]
[\fB\-T\fP\ [B|I|R]]
[month]
[year]
[nmonths]
.SH DESCRIPTION
.I Pcal
generates PostScript to produce landscape or portrait calendars for any 
month and year.  The arguments
.BR month ,
.BR year ,
and
.BR nmonths ,
if provided, should be numeric.  The 
.BR month
value should be in the range 1 \- 12, and the 
.BR year
value should be specified as 1 or 2 digits or as the full 4 digit year.
If no numeric arguments are provided, the calendar for the current month
and year will be generated.
.PP
If one numeric argument is provided, it is interpreted as the
.BR year
value, and calendars for the entire year will be generated.  Otherwise, 
.BR nmonths
months, starting with
.BR month
and
.BR year ,
will be generated.
.PP
For whole-year calendars (i.e. the
.B \-w
option is given), the command line arguments are interpreted somewhat
differently.  By default, all months in the current year are printed, starting
with January.  If the
.B month
argument alone is given, it is expected to be the desired
.B year
to print, and prints all of the months in the given year.  If both
.BR month " and " year
are given, then 12 consecutive months are printed starting at the given
month and year.  If the
.BR month ", " year ", and " nmonths
arguments are all present, printing begins with the given month and year and
.B nmonths
months are printed, rounded up to the nearest multiple of 12.
.PP
.B The Date File
.PP
By default,
.I pcal
simply prints an empty calendar.  Its real power is in its ability to place
``events'' in appropriate days on the calendar, thus allowing the user to
create personalized calendars.  This is achieved through the use of the
``date file''.
.PP
The date file is named
.IR \.calendar " (" pcal.dat
under MS-DOS),
or
.I calendar
for compatibility with older versions.
.I Pcal
will look in several places for such a file.  First, if the environment variable
.BR PCAL_DIR
is defined,
.I pcal
searches the directory indicated by that variable.
Next,
.I pcal 
searches the user's home directory (as specified by the
.BR HOME
environment variable).
If neither
.BR PCAL_DIR
nor
.BR HOME
is defined,
.I pcal
searches the current directory instead.  Finally, the directory where the
.I pcal
executable resides will be checked.  If no date file is found, an empty
calendar is printed; no error is generated.
.PP
If a date file is found, it will be searched for lines with
leading dates matching the requested month and year.
.PP
Any text following the dates found will be printed on the calendar under the
appropriate day of the month
.PP
\fBtroff\fP-style escape sequences \\fB, \\fI,
\\fP, and \\fR may be used to set the font style to Bold, Italic, the previous
font style, or Roman respectively.  For those more familiar with \fBHTML\fP,
<B>, <I>, and </B> or </I> may be used instead to set the font style to Bold,
Italic, or
the previous font style respectively.  The font style is reset to Roman after
each line break.
.PP
Dates in the
.I \.calendar
file may be expressed in any of several formats:
.PP
.ft CW
.nf
	<ordinal> <day_spec> in <month_spec>{*} {<text>}
	{<ordinal>} <day_spec> <prep> <date_spec>{*} {<text>}
	<date_spec>{*} {<text>}
	<holiday>
.fi
.ft
.PP
Where:
.PP
.\".nf
.TP 22
	<month_name>
:= first 3+ characters of name of month, or ``all''
.TP
	<month_spec>
:= <month_name>, or ``year''
.TP
	<day_spec>
:= first 3+ characters of name of weekday, ``day'', ``weekday'', ``workday'',
``holiday'', ``nonweekday'', ``nonworkday'', ``nonholiday'', ``new_moon'',
``first_quarter'', ``full_moon'', or ``last_quarter''
.TP
	<ordinal>
:= any ordinal number (``1st'', ``2nd'', etc.), ``first'' ... ``fifth'',
``last'', ``odd'', ``even'', or ``all''
.TP
	<prep>
:= ``before'', ``preceding'', ``after'', ``following'', ``on_or_before''
(``oob''), ``on_or_after'' (``ooa''), ``nearest'', ``nearest_before``, or
``nearest_after``
.TP
	<holiday>
:= ``Christmas'', ``Thanksgiving'', etc.
.TP
	<sep>
:= one or more non-numeric, non-space, non-`*' characters
.TP
	<month>
:= a numeric month (1-12)
.TP
	<day>
:= day of month (1-31)
.TP
	<year>
:= a numeric year
.PP
If the
.B \-A
option (American date formats, the default) is given:
.PP
.TP 22
	<date_spec>
:= <month_name> <day> | <month><sep><day>{<sep><year>}
.PP
If the
.B \-E
option (European date formats) is given:
.PP
.TP 22
	<date_spec>
:= <day> <month_name> | <day> <month> | <day><sep><month>{<sep><year>}
.PP
.I Pcal
also allows format specifiers in both the text and foot strings (see the
.BR \-L ,
.BR \-C ,
.BR \-R ,
and
.B \-N
options below); each will be replaced by a corresponding string as outlined
in the table below.  Most of these are derived from the ANSI C
.ft CW
strftime()
.ft
function; the 
.B %[louwMD]
and
.B %[o0+\-]
format specifiers are specific to
.IR pcal :
.PP
.nf
	%a	abbreviated weekday
	%A	full weekday
	%b	abbreviated month name
	%B	full month name
	%d	day of month (1-31)
	%j	day of year (1-366)
	%l	days left in year (0-365)
	%m	month (1-12)
	%U	week number (0-53)
	%W	week number (0-53)
	%u	week number (1-54)
	%w	week number (1-54)
	%y	year w/o century (00-99)
	%Y	year w/century
	%%	`%' character

	%o	print number as ordinal
	%0	print number with leading zeroes
	%+	use following month or year
	%\-	use previous month or year
	%{+N}[DWMY]	adjust date by +N days/weeks/months/years
	%{\-N}[DWMY]	adjust date by \-N days/weeks/months/years
.fi
.PP
The
.B %u
specifier considers the week containing 1/1 as week 1 and the following
logical Sunday (the first day of the week as printed; cf. the
.B \-F
option below) as the start of week 2; 
.B %U
considers the first logical Sunday as the first day of week 1.  
.B %w
and 
.B %W
behave like 
.B %u
and 
.B %U
respectively, but use the first logical Monday instead.  Note that
.B %w
has a different meaning to
.ft CW
strftime().
.ft
.PP
The 
.B %o
format specifier prints a number as an ordinal, with the appropriate suffix
(``st'', ``nd'', ``rd'', or ``th'' in English) appended.  For example,
.B %od
prints the day of the month as ``1st'', ``2nd'', ``3rd'', etc.
.PP
Unlike 
.ft CW
strftime(),
.ft
.I pcal
defaults to printing numbers (except
.BR %y )
without leading zeroes.  If leading zeroes are desired, the `0'
prefix may be used.  For example,
.B %0j
prints the first day of year as ``001''.
.PP
The
.B %+
and
.B %\-
format specifiers direct
.I pcal
to substitute the following/previous month/year in the following
.B [bBmyY]
specifier.  For example,
.B %+B
prints the name of the next month.
.PP
The
.B %{[+\-]N}[DWMY] 
format specifiers do not print anything, but instead adjust the working
date by \(+-
.BR N days
.RB ( D ),
weeks
.RB ( W ),
months
.RB ( M ),
or years
.RB ( Y ).
Subsequent format specifiers use the adjusted date instead of the
current date.  For example, 
.B %+1M %B %Y
adjusts the date forward by one month and then prints the resulting
month and year (``January 1992'' in December, 1991);
.B %\-2W %b %d
adjusts the date backward by two weeks and prints the resulting
month and day (``Jul 26'' on August 9).
.PP
Such date adjustments are normally cumulative; for example,
.B %+1Y%\-1D
adjusts the date forward by one year and then backward by one day.  If
.B %D
or
.B %M
is specified alone (or if
.B N
is zero),
.I pcal
restores the original date.  Note that
.B %M
has a different meaning to the
.ft CW
strftime()
.ft
function.
.PP
The ``Notes'' box (see below) uses the first of the current month as the
default date.  All foot strings use the first of the current month in
single-month mode and the first of the starting month in whole-year mode.
.PP
Examples:
.PP
.ft CW
.nf
	last Monday in May*         Memorial Day Holiday
.sp
	all Fridays in Oct          Status Meeting, 11 AM
	first workday in all        %-B progress report due
	all Fri in all              \\fBTime card due,\\fP 3 PM
	all Monday in all           Fiscal week %0W
	-2nd workday in all         Schedule for %+B due %+2D
	2nd full_moon in all        Blue Moon
	Fri on_or_before all 15     Pay Day
	even Fridays in year        Pay Day
	183rd day of year           Mid-year (%l days left)
.sp
	Tue after first Mon in Nov  Election Day (USA)
.sp
	4th Thu in Nov*             Thanksgiving
	Fri after 4th Thu in Nov*   Day after Thanksgiving
	workday nearest 12/25*      Holiday
.sp
	12/25/93*                   Christmas     # American
	25.12.93*                   Christmas     # European
	25. 12.*                    Christmas	  # European
.sp
	Dec 25*                     Christmas     # American
	25 Dec*                     Christmas     # European
	25. Dec*                    Christmas     # European
.fi
.ft
.PP
Any non-numeric character may separate numeric dates.  Holidays may
be flagged by following the date immediately with `*'
as in the examples above; this will cause the
date to be printed in gray.
``Each'' and ``every'' are accepted as synonyms for ``all'', and any word may
be used in place of ``in''.  The abbreviations ``oob'' and ``ooa'' may be used
in place of the keywords ``on_or_before'' and ``on_or_after'', respectively.
``Nearest'' attempts to match the specified date; if that fails, it tries
the day after, then the day before,
then two days after, two days before, and so forth until a match occurs.
.PP
Wildcard day names are also provided.  The keyword ``weekday'' applies to any
days which are normally printed in "logical black" - the predominant day
color - on the calendar.  The keyword
``workday'' is the same, but does not include any holidays.  The keyword
``holiday'' includes only those days flagged as holidays.  The keywords
``nonweekday'', ``nonworkday'', and ``nonholiday'' are also recognized as
negations of the above.  See the
.B CAVEATS
below for important notes on using these keywords.
Moon phases may also appear as wildcards; ``nm'' is accepted as a
synonym for ``new_moon'', ``1q'' and ``fq'' for ``first_quarter'', ``fm'' for
``full_moon'', ``3q'' for ``third_quarter'', and ``lq'' for ``last_quarter''. 
.PP
Ordinal day numbers may be used to specify dates, either relative to the
month or to the year.  Either words or numeric abbreviations may be used for
``first'' through ``fifth''; higher numbers must be given using the
numeric equivalent (e.g. 100th).  Negative ordinal numbers may even be used.
For example, ``\-2nd'' means ``next to last''.
.PP
``Odd'' and ``even'' do not refer to the actual date; instead, ``odd''
means ``alternate, starting with the first'', and ``even'' means ``alternate,
starting with the second''.  Thus, ``odd Fridays in March'' refers to
the first, third, and (if present) fifth Fridays in March - not to
those Fridays falling on odd dates.
.PP
``All'' refers to each individual month; ``year'' refers to the year
as an entity.  Thus ``odd Fridays in all'' refers to the first, third, and fifth
Friday of each month, while ``odd Fridays in year'' refers to
the first Friday of January and every other Friday thereafter.
.PP
``Nearest'', ``nearest_before'', and ``nearest_after'' refer to the
nearest weekday or wildcard day with respect to the specified
date.  ``Nearest_before'' and ``nearest_after'' allow the user to
specify how \fIpcal\fP is to disambiguate between two dates that are
equally near: e.g., ``nonweekday nearest_before [Wed.] 9/25/96'' refers
to Sunday, 9/22 while ``nonweekday nearest_after 9/25/96'' refers to
Saturday, 9/28.  (Note that ``nearest_before'' and ``nearest_after''
are equivalent to ``nearest'' when no such ambiguity exists: e.g.,
``nonweekday nearest_before [Thu.] 9/26/96'' refers to Saturday, 9/28.)
.PP
Text in the date file may use C-like escape sequences (i.e. a `\\' followed by
a character, 1 \- 3 octal digits, or `x' followed by 1 \- 2 hexadecimal digits).
Escaped whitespace (including
.B newline
) and the standard ANSI character escapes (`\\a', `\\b', `\\f', `\\n', `\\r',
`\\t', `\\v') are all replaced by a single blank.
.PP
The HTML special characters `&lt;' `&gt;' `&quot;' `&amp;' `&nbsp;' and
`&#NNN;' (NNN = any three decimal digits) are also supported.  These will
be propagated intact (be sure to escape the `#' in `&#NNN;') if the output
is specified as HTML (see the
.B -\H
flag); otherwise they will be converted to their ASCII equivalents.  This
allows a common date file to be used regardless of whether the desired
output format is HTML, PostScript, or
Un*x
.I "calendar(1)"
(see the
.B -\c
flag) input.
.PP
Lines in the
.I \.calendar
file consisting of 
.B year ####
(where
.B ####
is a numeric year) can be used
to set the year for following entries.  This assumes that the following
entries do not contain a year; any date entries containing year information
will set the remembered year to that year.
.PP
Lines in the
.I \.calendar
file consisting of 
.B year all
(or, alternatively, \fByear *\fP) direct \fIpcal\fP to wildcard
following entries against every applicable year.  This assumes
that the following
entries do not contain a year; any date entries containing year information
(or an explicit \fByear XXXX\fP entry) will set the remembered year
to that year.
.PP
Lines in the
.I \.calendar
file consisting of 
.B opt <options>
can be used to override the defaults for
any command-line options except
.BR \-c ,
.BR \-e ,
.BR \-f ,
.BR \-h ,
.BR \-H ,
.BR \-u ,
.BR \-v ,
.BR \-D ", and"
.BR \-U .
Any options specified in this manner
are, in turn, overridden by those specified explicitly on the command line.
.PP
Lines in the
.I \.calendar
file consisting of
.B note{/<number>} <month>
can be used to place notes regarding the
entire month in one of the unused blocks of the calendar.  The
.B <month>
indicator may be either a number 1 through 12 or an alphabetic month name
as described above;  ``note all'' will place the associated text in the
notes block for each month in the current year.
.B <number>
is an optional positive or negative number specifying the
empty box where the associated text is to be placed.  If positive,
.I pcal
counts forward from the first empty box; if negative,
.I pcal
counts backward from the last empty box.  Thus,
.BR ``note/1''
places the associated text in the first empty box;
.BR "note/-3"
in the third-to-last.  The default is -1 if no <number> is given
(last empty box, immediately preceding the small
calendars on the bottom row; cf.
.BR \-S ,
.BR \-k ,
and
.BR \-K ,
below).
.PP
Comments are supported in the
.I \.calendar
file.  Any characters following a `#' character through the end of the
line are ignored (unless the `#' character is escaped by `\\').
.PP
.I Pcal
supports rudimentary
.IR cpp -like
functionality in the
date file, allowing the following constructs:
.BR "define | undef" ,
.B if{{n}def} ... {elif ...}* {else ...} endif,
and
.BR include .
Note that these are not preceded by `#' as they are in C.
Symbol names defined using these keywords (or via the 
.B -D
option) are case-insensitive.
It is not an error to
.BR undef
an undefined symbol, nor to
.BR define
a previously-defined one.  An
.BR ifdef
alone is always
.BR false "; an"
.BR ifndef
alone is always
.BR true .
.BR if
is accepted as a synonym for
.BR ifdef .
.PP
The name of the file in the 
.BR include
directive may optionally be
surrounded by either "" or <>, both of which are ignored.  If the
name is not an absolute path, it is taken to be relative to the
directory where the file containing the directive is located.
If the string "%y" appears in the file name, it is replaced by the last two
digits of the current year (or the initial year if "year all" is in
effect).
.I Pcal
is smart enough to translate
.B ~/
to the user's home directory.
.PP
.I pcal
normally terminates immediately if the file specified in an
.BR include
directive does not exist.  An alternate form of the directive,
.BR include? ,
directs
.I pcal
to continue silently if the file does not exist or cannot be opened.
.PP
In addition to pre-processing keywords,
.I pcal
also accepts boolean expressions in
.B if{{n}def}
and
.B elif
directives.  These expressions consist of symbol names joined by the boolean
operators
.BR ! ", " & ", " ^ ", and "
.BR | ,
in order of precedence, high to low.  Parentheses may be used to alter the
precedence.  The synonyms
.BR && " and " ||
are accepted for
.BR & " and " | .
A symbol name evaluates to 
.B true
if currently defined,
.B false
if not; thus:
.PP
.ft CW
.nf
	ifdef A | B | C
.fi
.ft
.PP
\&...is
.B true
if any of the symbols A, B, and C is defined, and:
.PP
.ft CW
.nf
	ifdef A & B & C
.fi
.ft
.PP
\&...is
.B true
if they all are.  Note that 
.B ifndef <expr>
is equivalent to 
.B ifdef !( <expr> ).
.PP
.B The Moon File
.PP
If a file of the name
.IR .moon## " (" moon##.dat
under MS-DOS),
where
.B ##
is the last two digits of the calendar year, exists in the same directory
as the date file (or in the directory where 
.I pcal
resides),
.I pcal
uses the information contained within to calculate the phase of the
moon.  If a) no such file exists, b) the
.B \-e
flag (do not use a date file) is specified, or c) the
.B \-z
flag (specify time zone) is specified, then
.I pcal
uses an algorithm to calculate the phase of the moon.
.PP
Entries in the moon file must conform to the following syntax:
.PP
If the
.B \-A
option (American date formats, the default) is given:
.PP
.ft CW
.nf
	<quarter> <month><sep><day> {<hour><sep><min>}
.fi
.ft
.PP
If the
.B \-E
option (European date formats) is given:
.PP
.ft CW
.nf
	<quarter> <day><sep><month> {<hour><sep><min>}
.fi
.ft
.PP
Where:
.PP
.nf
	<quarter>	:= ``nm'', ``fq'' or ``1q'', ``fm'', ``3q'' or ``lq'' (new moon,
				first quarter, full moon, last quarter)
	<hour>		:= number 0-23 (24-hour clock)
	<min>		:= number 0-59
.fi
.PP
This file must contain entries for all quarter moons in the year,
in chronological order; if any errors are encountered,
.I pcal
will revert to using its default algorithm.
.PP
As in the date file, comments start with `#' and run through the
end of the given line.  
.PP
The moon file may optionally contain an \fBopt \-A\fR or \fBopt \-E\fR line
to specify the format of its own date entries independently of the format
used in the date file.  No other flags are legal in the moon file.
.PP
.B Options
.PP
.I Pcal
has many options:
.P
.TP
.B \-e
Prints an empty calendar.  Do not print entries from a
.I \.calendar
file even if one exists.
.TP
.BI \-f " cal"
Directs
.I pcal
to use the file name
.I cal
as the input file in place of the default
.I \.calendar
file.  Note that the search rules are different when
.B \-f
is used.  If
.I cal
is an absolute file name (i.e., starting with a `/'), then
.I pcal
attempts to open only that file.  Otherwise,
.I pcal
looks for
.I cal
in the current directory, then in the directory indicated by the environment
variable
.B PCAL_DIR 
(if defined), and finally in the directory where the
.I pcal
executable resides.  If the given
.I cal
file is not found, an error results.
.TP
.BI \-o " file"
Directs
.I pcal
to write the output to
.I file
instead of to stdout.
.TP
.B \-l
Causes the output to be in landscape mode (default).  This also resets the
x- and y-axis scaling and translation factors to the defaults for
landscape mode.
.TP
.B \-p
Causes the output to be in portrait mode.  This also resets the
x- and y-axis scaling and translation factors to the defaults for portrait
mode.
.TP
.B \-j
Causes the Julian date (day of year) to be printed in each calendar box.
.TP
.B \-J
Causes the Julian date and the number of days remaining in the year to
be printed in each calendar box.
.TP
.B \-m
Causes moon icons to be printed on dates corresponding to
new, half, and full moons (the default is that no moons are printed).
.TP
.B \-M
Causes moon icons to be printed on all dates (the default is
that no moons are printed).
.TP
.BI \-g " day1\fR[\fI\-day2\fR]" " | all | holiday "
Causes all dates falling on weekday
.I day1
(through 
.I day2
if specified) to be printed in gray;
.B \-g all
causes all weekdays (other than holidays) to be printed in gray;
.B \-g holiday
causes all holidays to be printed in gray.  \fIday1\fR and \fIday2\fR
may wrap around weekends; for example,
.B \-g fri\-sun
causes Fridays, Saturdays, and Sundays to be printed in gray.
.TP
.BI \-O " day1\fR[\fI\-day2\fR]" " | all | holiday "
Similar to
.BR \-g ,
but the selected days will be printed as outlined characters.
.TP
.BI \-G " day1\fR[\fI\-day2\fR]" " | all | holiday "
Similar to
.BR \-g ,
but the selected days will be printed as outlined characters filled with gray.
.TP
.BI \-b " day1\fR[\fI\-day2\fR]" " | all | holiday "
Similar to \- you guessed it \-
.BR \-g ,
but the selected days will be printed in black.  Since black is the default
for weekdays, \-b is primarily used to overriding other flags (e.g.,
.B \-g all \-b sat-sun
).
.TP
.BR "    Note:"
The default for the above
options is to print Saturdays, Sundays, and holidays in gray and all
other days in black.  For backward compatibility with earlier
versions of 
.IR pcal ,
.BR \-O
and
.BR \-G
alone change all non-black days to the specified color.
.TP
.BI \-s " [date_shade][/fill_shade]"
Overrides the default values for date and/or fill box shading.  These values
must be in the range 0.0 (black) through 1.0 (white); they may be set
independently of each other.  The default values are 0.8 for dates and 0.9
for empty boxes.
.TP
.BR "    Note:"
For use with color printers, \fBdate_shade\fP and \fBfill_shade\fP may
optionally be specified as a set of \fIred\fP:\fIgreen\fP:\fIblue\fP values;
\fIred\fP, \fIblue\fP, and \fIgreen\fP must in the range 0.0 through 1.0.  At
least one ':' must be present for this option to be recognized; omitted
values are set to 0.0.
.TP
.BI \-F " day"
Selects weekday
.I day
as the first day of the week.  The given day will appear in the left-most
column of the calendar.
.TP
.B \-A
Directs
.I pcal
to use American date conventions
.B mm/dd{/yy}
and
.B month dd
) when parsing the date file (default).
.TP
.B \-E
Directs
.I pcal
to use European date conventions
.B dd/mm{/yy}
and
.B dd month
) when parsing the date file.
.TP
.BI \-X " xtrans"
Specifies the x-axis translation value for positioning the output on the page.
.TP
.BI \-Y " ytrans"
Specifies the y-axis translation value for positioning the output on the page.
.TP
.BI \-x " xscale"
Specifies the x-axis scaling factor for the calendar size.
.TP
.BI \-y " yscale"
Specifies the y-axis scaling factor for the calendar size.
.TP
.BI \-t " \fR[\fItitle_font\fR][\fB/\fIsize\fR]"
Specifies the name of a font to use to print all the calendar heading text: the
month name and year at the top of the calendar, the weekday names, the notes
box heading, and the foot strings.  The user may optionally specify the font size for the
month/year heading (single-month calendar only); for example,
.B "pcal \-t Times-Roman/54"
sets the font to Times-Roman and the month/year point size to 54.  The font
size may also be changed independently:
.B "pcal \-t /54"
changes the point size to 54 without affecting the font name.
.TP
.BI \-d " \fR[\fIdate_font\fR][\fB/\fIsize\fR]"
Similar to the
.B \-t
option, but selects the font and/or size used to print the dates.
.TP
.BI \-n " \fR[\fItext_font\fR][\fB/\fIsize\fR]"
Similar to the
.B \-t
and
.B \-d
options, but selects the font and/or size used to print the text associated
with each day and in the "Notes" blocks.
.TP
.BI \-r " \fR[\fImapping\fR]"
Specifies an 8-bit character set remapping for printing the diacritical
marks common to European languages; \fImapping\fR may be "Roman8" (ROMAN-8
extended character set), "Latin1" (ISO LATIN-1 extended character set), or
"none" (builtin 8-bit mappings only).  It may be
abbreviated to a single character if desired.
.TP
.BI \-D " symbol"
Defines the named symbol prior to reading the date file.
.TP
.BI \-U " symbol"
Un-defines the named symbol prior to reading the date file.
.TP
.BI \-L " string"
Causes the accompanying string to be printed as a left-justified footer.
Format specifiers denoting the month and/or year may appear in the string;
the appropriate values will be substituted upon printing.
.TP
.BI \-C " string"
Similar to
.BR \-L ,
but causes the accompanying string to be printed as a centered footer.  If
the
.B \-H
flag (generate calendar as HTML table) was specified, this string will be
used as the title and heading.
.TP
.BI \-R " string"
Similar to
.BR \-L ,
but causes the accompanying string to be printed as a right-justified footer.
.TP
.BI \-N " string"
Causes the accompanying string to be printed as the heading for the "Notes"
box.  Note, however, that 
.I pcal
makes no attempt to ensure that it fits.
.TP
.B \-B
Causes
.I pcal
to leave unused calendar boxes blank (default is gray).
.TP
.BI \-# " n"
Causes
.I pcal
to print
.I n
copies (maximum: 100) of each output page.
.TP
.BI \-S
Causes
.I pcal
to suppress printing the small calendars.  See the
.B CAVEATS
section for further details.
.TP
.BI \-k
Causes
.I pcal
to print the small calendars in the upper left corner (the default is to print
them at the lower right). 
.TP
.BI \-K
Causes
.I pcal
to print the small calendar for the previous month in the upper left corner
and the next month in the lower right (the default is to print both at
the lower right).
.TP
.BI \-w
Causes
.I pcal
to print a calendar for 12 consecutive months: 3 rows / 4
columns in landscape mode, 4 rows / 3 columns in portrait mode.  See the
.B CAVEATS
section for details on the use of this option with other options.
.IP
Pcal predefines the symbol \fBwhole_year\fP when the \fI-w\fP flag is in
effect.
.TP
.BI \-c
Causes
.I pcal
to generate a date file suitable for use as input to the Un*x
.I "calendar(1)"
utility.  The normal PostScript output is suppressed.
.TP
.BI \-H
Causes
.I pcal
to generate a calendar in HTML table format.  The normal PostScript
output is suppressed.
.IP
The HTML table format does not support moons, Julian dates, alternate date
colors, left or right footstrings (see the
.B \-C
flag), alternate fonts/sizes, transformation and scaling factors,
fill box shading, or Esperanto.
.TP
.BI \-z " time_zone"
Forces
.I pcal
to ignore the moon file and to use its internal algorithm for moon phase
calculations, adjusting the phase by
.I time_zone
hours (where
.I time_zone
is expressed in hours west of UTC).
.TP
.B \-I
Resets all parameters to the program defaults.
.TP
.B \-h
Causes
.I pcal
to write version information, parameter usage message, and full explanation of options
and file formats (to
.IR stdout )
and terminate.
.TP
.B \-u
Causes
.I pcal
to write version information and parameter usage message (to
.IR stdout )
and terminate.
.TP
.B \-v
Causes
.I pcal
to write version information only (to
.IR stdout )
and terminate.
.IP
Pcal predefines the symbol \fBvX_X\fP, where \fBX_X\fP denotes the current
version of Pcal (i.e., v4.7 predefines \fBv4_7\fP).
.TP
.BI \-a " language"
Select the language for the names of months and days.  As of v4.6,
the following languages are supported:
.B de
(German),
.B en
(English)
.B eo
(Esperanto)
.B es
(Spanish),
.B fr
(French),
.B gr
(Greek),
and
.B it
(Italian).
The default is 
.BR en .
.IP
.B "Note:"
In order to display diacritical marks, languages other than English
require that the fonts be remapped (typically via the "Latin1"
remapping).  If no remapping is specified, \fIpcal\fP selects a remapping
appropriate to the selected language; note that the Greek language also
requires an ELOT-928 font (available from ah@doc.ic.ac.uk).  Also see the
.BR \-r " and " \-t
options.
.IP
If Esperanto is selected, Pcal converts [cghjsuCGHJSU][xX^] and
[uU][xX~] to the corresponding accented character; e.g. "jxauxdo",
"j^au~do", or any equivalent form will print as "j-circumflex a
u-breve d o".
.IP
Day and month names in the date file may be expressed in either
the default language specified at compile-time or the language
selected on the command line.
.IP
Pcal predefines the symbol \fBlang_XX\fP, where \fBXX\fP is the two-character
abbreviation for the selected language.
.TP
.BR \-T " [B|I|R]"
Select the default typeface
(Bold, Italic, or Roman) for printing date/note text.  This
flag may be specified multiple times within the date file
(via "opt") to reset the font style on the fly - for example, to
print all holidays in Bold.
.PP
Any option (except
.B \-G
and
.BR \-O ","
for backward-compatibility)
which normally takes an argument may be specified without
the argument in order to reset the value to the program default.  Note that
while the
.B \-D
option alone clears all the defined symbols, the
.B \-U
option alone has no effect.  The
.B \-
(or
.BR "\-\|\-" " as per"
System V) argument may be used to disambiguate command lines such as:
.IP
.B pcal \-t 9 90
.PP
This could be written instead as one of the following:
.IP
.B pcal \-t \- 9 90
.br
.B pcal \-t \-\|\- 9 90
.PP
If the environment variable
.BR PCAL_OPTS
is defined, its contents are parsed as a command line.  Flags set via
.BR PCAL_OPTS
override the program defaults, but are overridden by options set via 
.B opt
lines in the
.I \.calendar
file or explicitly on the command line.
.SH CAVEATS
The ``workday'' and ``holiday'' keywords are aware of only those holidays
which have already been flagged at the point where they appear.  For example,
consider January 1990:
.PP
.ft CW
.nf
.ne 7
			    January 1990
			 S  M Tu  W Th  F  S
			    1  2  3  4  5  6
			 7  8  9 10 11 12 13
			14 15 16 17 18 19 20
			21 22 23 24 25 26 27
			28 29 30 31
.fi
.ft
.PP
If the
.I \.calendar
file looked like this:
.PP
.ft CW
.nf
	workday on_or_before all 15	payday
	3rd Mon in Jan*			MLK day
.fi
.ft
.PP
\&\.\.\. then
.I pcal
would mark the 15th as ``payday'' since at that point in the
.I \.calendar
file it has no way of knowing that January 15th will later be flagged as a
holiday.  If the two lines were reversed, such that the holiday preceded the
``workday'' wildcard, then
.I pcal
would work as intended, marking instead the 12th as ``payday''.  Also, beware
of year boundaries which affect the handling of all of the day wildcard
keywords.  In general, it is best to place monthly wildcards such as the
example above at the end of each year to achieve the desired effect.
.PP
Only the positive ordinals may be used in conjunction with prepositions (e.g.,
"fourth Sunday before 12/25").  (It could be argued that "last Sunday before
12/25" should be accepted as a synonym for "first Sunday before 12/25", but
then what does "last Sunday after 12/25" mean?)
.PP
When the
.B \-w
and
.B \-p
options are used together,
.I pcal
revises the y-scale factor in order to use the entire portrait page; therefore,
the user should avoid using use the
.B \-y
option when using both the
.B \-w
and
.B \-p
options.  Use of the
.B \-w
option in any case effectively disables the
.BR \-m ", " \-M ", " \-j ", and "
.B \-J
options.
.PP
The output of the
.B \-c
option may be used as input to subsequent runs of
.IR pcal .
Note, however, that
.B opt
lines (except for an automatic
.BR "opt \-[A|E]" ),
comments, ``note'' text, and
.BR ifdef 'd-out
source will be lost.
.PP
The
.B \-S
option interacts with
.BR note{/<number>} ;
if used, it should be specified either on the command line or prior to
the first
.B note
line in the date file.
.SH SEE ALSO
cal(1),
calendar(1).
.SH AUTHORS
The original PostScript code to generate the calendars was written by
Patrick Wood (Copyright (c) 1987 by Patrick Wood of Pipeline Associates,
Inc.), and authorized for modification and redistribution.  The calendar
file inclusion code was originally written in "bs(1)" by Bill Vogel of AT&T.
Patrick's original PostScript was modified and enhanced several times by
King Ables, Tim Tessin, Joe Wood, Jeff Mogul, Mark Hanson, and others whose
names have regrettably been lost.  This C version was originally created by
Ken Keirnan of Pacific Bell; additional enhancements by Joseph P. Larson,
Ed Hand, Andrew Rogers, Mark Kantrowitz, Joe Brownlee, Andy Fyfe, Steve
Grandi, and Geoff Kuenning.  The moon routines were originally written by
Jef Poskanzer and Craig Leres, and were incorporated into Pcal by Richard
Dyson.  International language support was added by Angelo Haritsis (except
Esperanto, by Andrew Rogers).
