$! make_vms.com
$! 6-SEP-1997
$! clean make procedure for SSL starting at 0.081 release, for
$! DEC C only, ANSI C mode as much as possible0
$! starting from 
$!  $POSIX00
$!  PSX> make -f makefile.ssl -n > make_vms.com
$!
$!  If P1 is defined then RSAREF is built, otherwise
$!  RSA is built.  For U.S. sites you MUST build RSAREF
$!  unless you have a license for/from RSA!  P1 must be the full
$!  file path to the RSAREF.OLB file
$!
$!  P2, if defined, sets a compiler thread needed on OpenVMS 7.1 (and up)
$!
$ ws := write sys$output
$ if (P1 .eqs. "")
$ then
$   ws "Building RSA version (for sites that are licensed or nonUSA)"
$   isrsaref = " "
$   isrsalib == " "
$ else
$   isrsalib = f$search("''P1'")
$   if(isrsalib .eqs. "")
$   then
$     ws "Sorry, couldn not find the RSAREF.OLB file that you specified"
$     ws "Try again"
$     exit
$   else
$     isrsalib = "," + isrsalib + "/lib"
$   endif
$   ws "Building RSAREF version (for sites in the USA)"
$   isrsaref = ",""""""RSAref=1"""""" "
$ endif
$!
$ if(p2 .eqs. "")
$ then
$    isseven= " "
$ else
$    isseven= ",PTHREAD_USE_D4"
$ endif
$
$!
$ toinc = f$environment("DEFAULT") - "]" + ".include]"
$!
$!
$ makeprog: subroutine
$ ws "Making program ''P1'"
$ mycc'P2' 'P1'
$ link 'P1', 'P3'   [-.crypto]LIBSSLEAY.olb/lib 'ISRSALIB'
$ exit
$ endsubroutine
$!
$!echo "#define DATE	\"`date`\"" >date.h
$!
$ for_osu = f$trnlnm("www_root")
$ if(for_osu .nes. "")
$ then
$   define http_base_code www_root:[base_code]
$!
$!  verify that extra pieces are where they should be
$!
$   haveit1= f$search("[.crypto.bio]bss_mst.c")
$   haveit2= f$search("[.ssl]ssl_task.c")
$   haveit3= f$search("[.ssl]ssl_threaded.c")
$   haveit4= f$search("[.crypto.bio]bss_rtcp.c")
$   if (haveit1 .eqs. "" .or. haveit2 .eqs. "" .or. haveit3 .eqs. "" -
       .or. haveit4 .eqs. "" )
$   then
$     ws "Cannot build for OSU DECthreads, missing:"
$     if(haveit1 .eqs. "")then ws "[.crypto.bio]bss_mst.c"
$     if(haveit2 .eqs. "")then ws "[.ssl]ssl_task.c"
$     if(haveit3 .eqs. "")then ws "[.ssl]ssl_threaded.c"
$     if(haveit4 .eqs. "")then ws "[.crypto.bio]bss_rtcp.c"
$     ws "Build continues..."
$     for_osu = ""
$   endif
$ else
$   ws "WWW_ROOT is not defined, building without OSU pieces"
$   haveit1 = ""
$   haveit2 = ""
$   haveit3 = ""
$   haveit4 = ""
$ endif
$!
$!
$! flat include should be the DEFAULT, as it is ANSI standard, but it
$! isn't
$!
$ mycc  :== cc/standard=ansi89/prefix=all/nolis/include=('toinc') -
  /define=(FLAT_INC 'isrsaref')
$ mycc2  :== cc/standard=ansi89/prefix=all/nolis/include=('toinc') -
  /define=(FLAT_INC,_POSIX_C_SOURCE 'isrsaref')
$ mycc3  :== cc/standard=ansi89/prefix=all/nolis/include=('toinc') -
  /define=(FLAT_INC,VMS 'isrsaref' 'isseven')/warning=disable=dollarid
$!
$ ws "moving files around and setting up for compilation"
$ open/write ofil: [.crypto]date.h
$ time = f$time()
$ write ofil: "#define DATE ""''time'"" "
$ close ofil:
$!
$! when the distribution unpacks there are a bunch of links where files
$! should be.  Also a few misc .h files that should be in include
$!
$ copy [.crypto...]*.h [.include]
$ copy e_os.h [.include]
$ copy [.ssl]ssl*.h [.include]
$ copy [.rsaref]*.h [.include]
$ purge [.include]*.h
$!
$! same link nonsense for test programs
$!
$ copy [.crypto...]*test.c [.test]
$ copy [.SSL...]ssltest.c [.test]
$ purge [.test]*.c
$!
$!
$! for some reason cryptlib.c wants to know about CFLAGS, does it invoke
$! the compiler???
$
$ ws "Compiling in [.crypto]"
$ set def [.crypto]
$ mycc cryptlib.c
$ mycc mem.c
$ mycc cversion.c
$ lib/create/object LIBSSLEAY.olb cryptlib.obj,mem.obj,cversion.obj
$!
$ ws "Compiling in [.crypto.md]"
$ set def [.md]
$ mycc md2_dgst.c
$ mycc md5_dgst.c
$ mycc md2_one.c
$ mycc md5_one.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.sha]"
$ set def [-.sha]
$ mycc sha_dgst.c
$ mycc sha1dgst.c
$ mycc sha_one.c
$ mycc sha1_one.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.mdc2]"
$ set def [-.mdc2]
$ mycc mdc2dgst.c
$ mycc mdc2_one.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.des]"
$ set def [-.des]
$ mycc set_key.c
$ mycc ecb_enc.c
$ mycc ede_enc.c
$ mycc cbc_enc.c
$ mycc cbc3_enc.c
$ mycc ecb3_enc.c
$ mycc cfb64enc.c
$ mycc cfb64ede.c
$ mycc cfb_enc.c
$ mycc ofb64ede.c
$ mycc enc_read.c
$ mycc enc_writ.c
$ mycc ncbc_enc.c
$ mycc ofb64enc.c
$ mycc ofb_enc.c
$ mycc str2key.c
$ mycc pcbc_enc.c
$ mycc qud_cksm.c
$ mycc rand_key.c
$ mycc des_enc.c
$ mycc fcrypt_b.c
$ mycc read2pwd.c
$ mycc fcrypt.c
$ mycc xcbc_enc.c
$ mycc/warning=(disable=dollarid) read_pwd.c
$ mycc rpc_enc.c
$ mycc cbc_cksm.c
$ mycc supp.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.rc4]"
$ set def [-.rc4]
$ mycc rc4_enc.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.rc2]"
$ set def [-.rc2]
$ mycc rc2_ecb.c
$ mycc rc2_skey.c
$ mycc rc2_cbc.c
$ mycc rc2cfb64.c
$ mycc rc2ofb64.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.idea]"
$ set def [-.idea]
$ mycc i_cbc.c
$ mycc i_cfb64.c
$ mycc i_ofb64.c
$ mycc i_ecb.c
$ mycc i_skey.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.bf]"
$ set def [-.bf]
$ mycc bf_skey.c
$ mycc bf_ecb.c
$ mycc bf_enc.c
$ mycc bf_cbc.c
$ mycc bf_cfb64.c
$ mycc bf_ofb64.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.bn]"
$ set def [-.bn]
$ mycc bn_add.c
$ mycc bn_div.c
$ mycc bn_exp.c
$ mycc bn_lib.c
$ mycc bn_mod.c
$ mycc bn_mul.c
$ mycc bn_print.c
$ mycc bn_rand.c
$ mycc bn_shift.c
$ mycc bn_sub.c
$ mycc bn_word.c
$ mycc bn_gcd.c
$ mycc bn_prime.c
$ mycc bn_err.c
$ mycc bn_sqr.c
$ mycc bn_mulw.c
$ mycc bn_recp.c
$ mycc bn_mont.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.rsa]"
$ set def [-.rsa]
$ mycc rsa_enc.c
$ mycc rsa_gen.c
$ mycc rsa_lib.c
$ mycc rsa_sign.c
$ mycc rsa_saos.c
$ mycc rsa_err.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.dsa]"
$ set def [-.dsa]
$ mycc dsa_gen.c
$ mycc dsa_key.c
$ mycc dsa_lib.c
$ mycc dsa_vrf.c
$ mycc dsa_sign.c
$ mycc dsa_err.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.dh]"
$ set def [-.dh]
$ mycc dh_gen.c
$ mycc dh_key.c
$ mycc dh_lib.c
$ mycc dh_check.c
$ mycc dh_err.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.buffer]"
$ set def [-.buffer]
$ mycc buffer.c
$ mycc buf_err.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.bio]"
$ set def [-.bio]
$ mycc bio_lib.c
$ mycc bio_cb.c
$ mycc bio_err.c
$ mycc bss_mem.c
$ mycc bss_null.c
$ mycc bss_fd.c
$ mycc bss_file.c
$ mycc bss_sock.c
$ mycc bss_conn.c
$ mycc bf_null.c
$ mycc bf_buff.c
$ mycc b_print.c
$ mycc b_dump.c
$ mycc b_sock.c
$ mycc bss_acpt.c
$ mycc bf_nbio.c
$! these two are for OSU DECthreads, put them in library anyway
$ if(haveit1 .nes. "")then mycc3 bss_mst.c
$ if(haveit4 .nes. "")then mycc3 bss_rtcp.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.stack]"
$ set def [-.stack]
$ mycc stack.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.lhash]"
$ set def [-.lhash]
$ mycc lhash.c
$ mycc lh_stats.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.rand]"
$ set def [-.rand]
$ mycc md_rand.c
$ mycc randfile.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.err]"
$ set def [-.err]
$ mycc err.c
$ mycc err_all.c
$ mycc err_prn.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.objects]"
$ set def [-.objects]
$ mycc obj_dat.c
$ mycc obj_lib.c
$ mycc obj_err.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.evp]"
$ set def [-.evp]
$ mycc encode.c
$ mycc digest.c
$ mycc evp_enc.c
$ mycc evp_key.c
$ mycc e_ecb_d.c
$ mycc e_cbc_d.c
$ mycc e_cfb_d.c
$ mycc e_ofb_d.c
$ mycc e_ecb_i.c
$ mycc e_cbc_i.c
$ mycc e_cfb_i.c
$ mycc e_ofb_i.c
$ mycc e_ecb_3d.c
$ mycc e_cbc_3d.c
$ mycc e_rc4.c
$ mycc names.c
$ mycc e_cfb_3d.c
$ mycc e_ofb_3d.c
$ mycc e_xcbc_d.c
$ mycc e_ecb_r2.c
$ mycc e_cbc_r2.c
$ mycc e_cfb_r2.c
$ mycc e_ofb_r2.c
$ mycc e_ecb_bf.c
$ mycc e_cbc_bf.c
$ mycc e_cfb_bf.c
$ mycc e_ofb_bf.c
$ mycc m_null.c
$ mycc m_md2.c
$ mycc m_md5.c
$ mycc m_sha.c
$ mycc m_sha1.c
$ mycc m_dss.c
$ mycc m_dss1.c
$ mycc m_mdc2.c
$ mycc p_open.c
$ mycc p_seal.c
$ mycc p_sign.c
$ mycc p_verify.c
$ mycc p_lib.c
$ mycc bio_md.c
$ mycc bio_b64.c
$ mycc bio_enc.c
$ mycc evp_err.c
$ mycc e_null.c
$ mycc c_all.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.pem]"
$ set def [-.pem]
$ mycc ctx_size.c
$!
$! use existing pem.h file???
$!
$! c -I.. -I../../include -O   -o ctx_size ctx_size.o
$! ./ctx_size <pem.org >pem.new
$! if [ -f pem.h ]; then mv -f pem.h pem.old; fi
$! mv -f pem.new pem.h
$!
$ mycc pem_sign.c
$ mycc pem_seal.c
$ mycc pem_info.c
$ mycc pem_lib.c
$ mycc pem_all.c
$ mycc pem_err.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.asn1]"
$ set def [-.asn1]
$ mycc a_object.c
$ mycc a_bitstr.c
$ mycc a_utctm.c
$ mycc a_int.c
$ mycc a_octet.c
$ mycc a_print.c
$ mycc a_type.c
$ mycc a_set.c
$ mycc a_dup.c
$ mycc a_d2i_fp.c
$ mycc a_i2d_fp.c
$ mycc a_sign.c
$ mycc a_digest.c
$ mycc a_verify.c
$ mycc x_algor.c
$ mycc x_val.c
$ mycc x_pubkey.c
$ mycc x_sig.c
$ mycc x_req.c
$ mycc x_attrib.c
$ mycc x_name.c
$ mycc x_cinf.c
$ mycc x_x509.c
$ mycc x_crl.c
$ mycc x_info.c
$ mycc x_spki.c
$ mycc d2i_r_pr.c
$ mycc i2d_r_pr.c
$ mycc d2i_r_pu.c
$ mycc i2d_r_pu.c
$ mycc d2i_s_pr.c
$ mycc i2d_s_pr.c
$ mycc d2i_s_pu.c
$ mycc i2d_s_pu.c
$ mycc d2i_pu.c
$ mycc d2i_pr.c
$ mycc i2d_pu.c
$ mycc i2d_pr.c
$ mycc t_req.c
$ mycc t_x509.c
$ mycc t_pkey.c
$ mycc p7_i_s.c
$ mycc p7_signi.c
$ mycc p7_signd.c
$ mycc p7_recip.c
$ mycc p7_enc_c.c
$ mycc p7_evp.c
$ mycc p7_dgst.c
$ mycc p7_s_e.c
$ mycc p7_enc.c
$ mycc p7_lib.c
$ mycc f_int.c
$ mycc f_string.c
$ mycc i2d_dhp.c
$ mycc i2d_dsap.c
$ mycc d2i_dhp.c
$ mycc d2i_dsap.c
$ mycc n_pkey.c
$ mycc a_hdr.c
$ mycc x_pkey.c
$ mycc a_bool.c
$ mycc x_exten.c
$ mycc asn1_par.c
$ mycc asn1_lib.c
$ mycc asn1_err.c
$ mycc a_meth.c
$ mycc a_bytes.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.x509]"
$ set def [-.x509]
$ mycc x509_def.c
$ mycc x509_d2.c
$ mycc x509_r2x.c
$ mycc x509_cmp.c
$ mycc x509_obj.c
$ mycc x509_req.c
$ mycc x509_vfy.c
$ mycc x509_set.c
$ mycc x509rset.c
$ mycc x509_err.c
$ mycc x509name.c
$ mycc x509_v3.c
$ mycc x509_ext.c
$ mycc x509pack.c
$ mycc x509type.c
$ mycc x509_lu.c
$ mycc x_all.c
$ mycc x509_txt.c
$ mycc by_file.c
$ mycc by_dir.c
$ mycc v3_net.c
$ mycc v3_x509.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.conf]"
$ set def [-.conf]
$ mycc conf.c
$ mycc conf_err.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.txt_db]"
$ set def [-.txt_db]
$ mycc txt_db.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.crypto.pkcs7]"
$ set def [-.pkcs7]
$ mycc pk7_lib.c
$ mycc pkcs7err.c
$ mycc pk7_doit.c
$ lib/object [-]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.ssl]"
$ set def [--.ssl]
$ mycc  s2_meth.c
$ mycc  s2_srvr.c
$ mycc  s2_clnt.c
$ mycc  s2_lib.c
$ mycc  s2_pkt.c
$ mycc  s2_enc.c
$ mycc  s3_meth.c
$ mycc  s3_srvr.c
$ mycc  s3_clnt.c
$ mycc  s3_lib.c
$ mycc  s3_pkt.c
$ mycc  s3_enc.c
$ mycc  s3_both.c
$ mycc  s23_meth.c
$ mycc  s23_srvr.c
$ mycc  s23_clnt.c
$ mycc  s23_lib.c
$ mycc  s23_pkt.c
$ mycc  ssl_lib.c
$ mycc  ssl_err2.c
$ mycc  ssl_cert.c
$ mycc  ssl_sess.c
$ mycc  ssl_ciph.c
$ mycc  ssl_stat.c
$ mycc  ssl_rsa.c
$ mycc  ssl_asn1.c
$ mycc  ssl_txt.c
$ mycc  ssl_algs.c
$ mycc  bio_ssl.c
$ mycc  ssl_err.c
$ lib/object [-.crypto]LIBSSLEAY.olb *.obj
$! these 2 are for OSU, they are not included in library
$ if(haveit3 .nes. "")then mycc3 ssl_threaded.c
$ if(haveit2 .nes. "")
$ then
$ set ver
$    mycc3 ssl_task.c
$    link ssl_task, [-.crypto]LIBSSLEAY.olb/lib 'ISRSALIB'
$ set nover
$ endif
$!
$ ws "Compiling in [.rsaref]"
$ set def [-.rsaref]
$ mycc  rsaref.c
$ mycc  rsar_err.c
$ lib/object [-.crypto]LIBSSLEAY.olb *.obj
$!
$ ws "Compiling in [.apps]"
$ set def [-.apps]
$ mycc apps.c
$ mycc2 s_socket.c
$ mycc s_cb.c
$ call makeprog verify "" "apps,"
$ call makeprog asn1pars "" "apps,"
$ call makeprog req "" "apps,"
$ call makeprog dgst "" "apps,"
$ call makeprog dh "" "apps,"
$ call makeprog enc "" "apps,"
$ call makeprog gendh "" "apps,"
$ call makeprog errstr "" "apps,"
$ call makeprog ca "" "apps,"
$ call makeprog gendsa "" "apps,"
$ call makeprog pkcs7 "" "apps,"
$ call makeprog crl2p7 "" "apps,"
$ call makeprog crl "" "apps,"
$ call makeprog rsa "" "apps,"
$ call makeprog dsa "" "apps,"
$ call makeprog dsaparam "" "apps,"
$ call makeprog x509 "" "apps,"
$ call makeprog genrsa "" "apps,"
$ call makeprog s_server 2 "s_socket,s_cb,apps,"
$ call makeprog s_client 2 "s_socket,s_cb,apps,"
$ call makeprog speed "" "apps,"
$ call makeprog s_time "" "s_cb,apps,"
$ call makeprog version "" "apps,"
$ call makeprog sess_id "" "apps,"
$ call makeprog ciphers "" "apps,"
$!
$ set def [-.test]
$ call makeprog BFTEST
$ call makeprog BNTEST
$ call makeprog DESTEST
$ call makeprog DHTEST
$ call makeprog DSATEST
$ call makeprog EXPTEST
$ call makeprog IDEATEST
$ call makeprog LH_TEST
$ call makeprog MD2TEST
$ call makeprog MD5TEST
$ call makeprog MDC2TEST
$! program present, but "meth.h" isn't
$! call makeprog METHTEST
$ call makeprog RANDTEST
$ call makeprog RC2TEST
$ call makeprog RC4TEST
$ call makeprog SHA1TEST
$ call makeprog SHATEST
$ call makeprog SSLTEST
$ call makeprog TEST
$ set def [-]
$ ws "Build completed"
