/* Constants. */
#define DEF_TEMPO 500000
#define LINE_SIZE 256
#define MIDI_EVENT_SIZE 10
#define NAME_LENGTH 16		/* token size */
#define MAX_CHORD_NOTES 10 /* max number of notes per chord. */
#define MAX_TOK 20		/* max tokens per line */
#define MAX_MES_PER_LINE 20	/* max measures per line */
#define RC_NAME "tabul.rc" /* Name of configuration file */
#define ALT_RC_NAME ".tabul.rc" /* Alternative name of configuration file */
#define HASH_SIZE 1000 /* Size of symbols hash table. */
#define HEAP_SIZE 50000
#define MAX_DEPTH 10 /* Max number of nested repeat ... end. */
#define MAX_UCHAR 255

/* return values */
#define STAT_OK 0
#define STAT_ERROR 1
#define STAT_EOF 2
#define STAT_END_CONFIG 3
#define STAT_TOO_MUCH_TOK -1
#define STAT_TOK_TOO_LONG -2
#define STAT_HASH_FULL -3

/* Function types. */
#define MEASURE_FUNC 1
#define POS_FUNC 2
#define CONTROL_FUNC 3

/* Symbol Types. */
#define TYPE_SIGNATURE 1
#define TYPE_CHORD 2
#define TYPE_DURATION 3
#define TYPE_INSTRUMENT 4
#define TYPE_PERCUSSION 5
#define TYPE_TAB 6

/* Event types */
#define MIDI_EVENT 1
#define META_EVENT 2
#define SYSEX_EVENT 3
#define TEMPO_EVENT 4

struct event {
	unsigned long time; /* MIDI time at which event occurs. */
	unsigned long mutime;  /* Infinitesimal time, for events that occur 
														at the same time. */
	unsigned char type; /* MIDI_EVENT or TEMPO_EVENT. */
	int  length;
	unsigned char op;    /* MIDI operation. */
	unsigned char chan;  /* MIDI channel. */
	union {
		unsigned char midi_codes[MIDI_EVENT_SIZE];
		unsigned long tempo;
		unsigned char *sysex_codes;
		unsigned char *meta_codes;
	}    data;
};

struct chord {
	char *name;
	int  type;		/* Not used for the moment. */
	int  notes[MAX_CHORD_NOTES];
};

struct instrument {
	char *name;
	int  type;
	int  channel;
	int  volume;
	int  pitch;
	int  open_note;		/* for tablature */
};

struct signature {
	char *name;
	int  duration;
	/* There should be also something describing accents... */
};

struct duration {
	char *name;
	int  duration;
};

struct measure {
	struct signature *signature;
	int  tempo;
	int  number;
	int  duration;
	struct chord *chord;	/* the underlying chord, if any */
	                      /* not used, I think */
};

struct mark {
	int offset;
	int repetition;
};

#define MAX(a,b) ( ((a) > (b)) ? (a) : (b))

