#include <stdio.h>
#include <string.h>
#include <ssdef.h>
#include <iodef.h>
#include <descrip.h>

long sys$assign();
long sys$qiow();
long sys$dassgn();

long ptd$create();
long ptd$read();
long ptd$write();
long ptd$delete();

long lib$wait();

#ifdef VAX
#define RWBUFSIZ 1024
#define READBUF 0
#define WRITEBUF 512
#endif
#ifdef __ALPHA
#define RWBUFSIZ 16384
#define READBUF 0
#define WRITEBUF 8192
#endif
short ptdchan;
char ptdbuf[RWBUFSIZ];
int pdtactive;

/*
 *  INT FUNC PTDAST()
 *
 *  get data + write data to stdout + queue new read-request
 *  (executed when read request completes = FT-process writes)
 *  
 */
long ptdast()
{
   int i;
   long stat;
   short stat2,len;
   char buf[512];
   stat2=(*((short *)(ptdbuf+READBUF)));
   len=(*((short *)(ptdbuf+READBUF+sizeof(short))));
   if((stat2&1)==1) {
      memcpy(buf,ptdbuf+READBUF+2*sizeof(short),len);
      for(i=0;i<len;i++) putchar(buf[i]);
      stat=ptd$read(0,ptdchan,&ptdast,0,ptdbuf+READBUF,WRITEBUF);
      pdtactive=1;
   }
   return SS$_NORMAL;
}

/*
 *  PTDOPEN()
 *
 *  assign channel to terminal + creates FT-process + queue first read-request
 *  
 */
void ptdopen()
{
   long stat,inadr[2],trmchar[3];
   short ttchan;
   $DESCRIPTOR(ttdesc,"TT:");
#ifndef STD
   stat=sys$assign(&ttdesc,&ttchan,0,0);
   stat=sys$qiow(0,ttchan,IO$_SENSEMODE,0,0,0,trmchar,3*sizeof(long),0,0,0,0);
   stat=sys$dassgn(ttchan);
#else
   trmchar[0]=5271618;
   trmchar[1]=402690976;
   trmchar[2]=-111144956;
#endif
   inadr[0]=(int)(&ptdbuf[0]);
   inadr[1]=(int)(&ptdbuf[RWBUFSIZ-1]);
   stat=ptd$create(&ptdchan,0,trmchar,3*sizeof(long),0,0,0,inadr);
   stat=ptd$read(0,ptdchan,&ptdast,0,ptdbuf+READBUF,WRITEBUF);
   return;
}

/*
 *  PTDWRITE(CSTRING BY REF)
 *
 *  write to the FT-process + wait and process AST's from read requests
 *
 */
void ptdwrite(char *s)
{
   long stat;
   float f;
   memcpy(ptdbuf+WRITEBUF+2*sizeof(short),s,strlen(s));
   stat=ptd$write(ptdchan,0,0,ptdbuf+WRITEBUF,strlen(s),0,0);
   do {
      f=1.0;
      pdtactive=0;
      lib$wait(&f);
   } while (pdtactive);
   return;
}

/*
 *  PTDCLOSE()
 *
 *  wait and process AST's from read requests + delete FT-process
 *
 */
void ptdclose()
{
   long stat;
   float f;
   do {
      f=1.0;
      pdtactive=0;
      lib$wait(&f);
   } while (pdtactive);
   stat=ptd$delete(ptdchan);
   return;
}

/*
 *  INT FUNC REPL1(CSTRING BY REF,CSTRING BY REF,CSTRING BY REF)
 *
 *  replace code with value
 *
 */
int repl1(char *s,char *s1,char *s2)
{
   char *p,tmp[81];
   p=strstr(s,s1);
   if(p==NULL) return 0;
   strncpy(tmp,s,p-s);
   tmp[p-s]='\0';
   strcat(tmp,s2);
   strcat(tmp,p+strlen(s1));
   strcpy(s,tmp);
   return 1;
}

/*
 *  REPL(CSTRING BY REF,CSTRING BY REF,CSTRING BY REF)
 *
 *  replace codes with values
 *
 */
void repl(char *s,char *s1,char *s2)
{
   while(repl1(s,s1,s2));
   return;
}

/*
 *  SUBST(CSTRING BY REF)
 *
 *  <RET>   -> return
 *  <DEL>   -> delete
 *  <DOWN>  -> arrow down
 *  <LEFT>  -> arrow left
 *  <RIGHT> -> arrow right
 *  <DOWN>  -> arrow down
 *  <CTRLD> -> CTRL/D
 *  <CTRLY> -> CTRL/Y
 *  <CTRLZ> -> CTRL/Z
 *  <CTRL3> -> CTRL/3 = ESC
 *  <CTRL4> -> CTRL/4 = FS
 *
 */
void subst(char *s)
{
   repl(s,"<RET>","\r");
   repl(s,"<DEL>","\x7F");
   repl(s,"<UP>","\x1B[A");
   repl(s,"<DOWN>","\x1B[B");
   repl(s,"<LEFT>","\x1B[D");
   repl(s,"<RIGHT>","\x1B[C");
   repl(s,"<CTRLD>","\x04");
   repl(s,"<CTRLY>","\x19");
   repl(s,"<CTRLZ>","\x1A");
   repl(s,"<CTRL3>","\x1B");
   repl(s,"<CTRL4>","\x1C");
   return;
}

/*
 *  example processing program
 *
 *  p1=input-file
 *  p2=output-file
 *
 */
main(int argc,char *argv[])
{
   char un[13],pw[32],s[81];
   printf("Username: ");
   scanf("%s",un);
   printf("Password: ");
   scanf("%s",pw);
   if(argc>1) freopen(argv[1],"r",stdin);
   if(argc>2) freopen(argv[2],"w",stdout);
   ptdopen();
   ptdwrite("\r");
   sprintf(s,"%s\r",un);
   ptdwrite(s);
   sprintf(s,"%s\r",pw);
   ptdwrite(s);
   while(fgets(s,sizeof(s),stdin)!=NULL) {
      s[strlen(s)-1]='\0';
      subst(s);
      ptdwrite(s);
   }
   ptdwrite("\rLOGOUT\r");
   ptdclose();
}
