/*
  Conversion from OS/2 UGL to Unicode

  Copyright (C) 1997 Robert Muchsel <muchsel@acm.org>
  Copyright (C) 1997,1998 Michal Necasek <mike@mendelu.cz>

  All entries that were previously 0xFFFF were changed to 0x0000 because
  TrueType 'missing glyph' has index 0
*/

#ifndef _FTIFI_H_INCLUDED_
#define _FTIFI_H_INCLUDED_

/* MS defined language IDs */
#define LANGID_ENGLISH_AMERICAN         0x0409
#define LANGID_JAPANESE_JAPAN           0x0411
#define LANGID_WANSUNG_KOREA            0x0412
#define LANGID_JOHAB_KOREA              0x0812
#define LANGID_CHINESE_TAIWAN           0x0404
#define LANGID_CHINESE_CHINA            0x0804
#define LANGID_CHINESE_HONGKONG         0x0c04
#define LANGID_CHINESE_SINGAPORE        0x1004
#define LANGID_GREEK_GREECE             0x0408
/* defined by me! */
#define LANGID_HEBREW_ISRAEL            2
#define LANGID_ARABIC_ARABIC            3

/* Platform-specific Encoding IDs for MS platform */
#define PSEID_SYMBOL          0
#define PSEID_UNICODE         1
#define PSEID_SHIFTJIS        2
#define PSEID_BIG5            3
#define PSEID_PRC             4
#define PSEID_WANSUNG         5
#define PSEID_JOHAB           6
/* defined by me! */
#define PSEID_PM383           100

/* bit masks for determining supported codepages */
#define OS2_CP1_ANSI_OEM_JAPANESE_JIS          (1 << 17)
#define OS2_CP1_ANSI_OEM_CHINESE_SIMPLIFIED    (1 << 18)
#define OS2_CP1_ANSI_OEM_CHINESE_TRADITIONAL   (1 << 19)
#define OS2_CP1_ANSI_OEM_KOREAN_WANSUNG        (1 << 20)
#define OS2_CP1_ANSI_OEM_KOREAN_JOHAB          (1 << 21)

/* defines for character translation */
#define TRANSLATE_UGL         0
#define TRANSLATE_SYMBOL      1
#define TRANSLATE_UNICODE     2
#define TRANSLATE_PRC         4


#define MAX_GLYPH 504
/* I suppose more than 949 is never used  */
/* 504 should be OK for (most) European and American countries */

#ifndef USE_UCONV
static const int UGL2Uni[MAX_GLYPH + 1] = {

  /* PM383 UGL mapping */

  /* 0..9 */
  0x0000, 0x263a, 0x263b, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022, 0x25d8, 0x25cb,
  /* 10..19 */
  0x25d9, 0x2642, 0x2640, 0x266a, 0x266b, 0x263c, 0x25ba, 0x25c4, 0x2195, 0x203c,
  /* 20..29 */
  0xb6, 0xa7, 0x25ac, 0x21a8, 0x2191, 0x2193, 0x2192, 0x2190, 0x221f, 0x2194,
  /* 30..39 */
  0x25b2, 0x25bc, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
  /* 40..49 */
  0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
  /* 50..59 */
  0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
  /* 60..69 */
  0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45,
  /* 70..79 */
  0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
  /* 80..89 */
  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
  /* 90..99 */
  0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x63,
  /* 100..109 */
  0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d,
  /* 110..119 */
  0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
  /* 120..129 */
  0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x2302, 0xc7, 0xfc,
  /* 130..139 */
  0xe9, 0xe2, 0xe4, 0xe0, 0xe5, 0xe7, 0xea, 0xeb, 0xe8, 0xef,
  /* 140..149 */
  0xee, 0xec, 0xc4, 0xc5, 0xc9, 0xe6, 0xc6, 0xf4, 0xf6, 0xf2,
  /* 150..159 */
  0xfb, 0xf9, 0xff, 0xd6, 0xdc, 0xf8, 0xa3, 0xd8, 0xd7, 0x192,
  /* 160..169 */
  0xe1, 0xed, 0xf3, 0xfa, 0xf1, 0xd1, 0xaa, 0xba, 0xbf, 0xae,
  /* 170..179 */
  0xac, 0xbd, 0xbc, 0xa1, 0xab, 0xbb, 0x2591, 0x2592, 0x2593, 0x2502,
  /* 180..189 */
  0x2524, 0xc1, 0xc2, 0xc0, 0xa9, 0x2563, 0x2551, 0x2557, 0x255d, 0xa2,
  /* 190..199 */
  0xa5, 0x2510, 0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0xe3, 0xc3,
  /* 200..209 */
  0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0xa4, 0xf0, 0xd0,
  /* 210..219 */
  0xca, 0xcb, 0xc8, 0x131, 0xcd, 0xce, 0xcf, 0x2518, 0x250c, 0x2588,
  /* 220..229 */
  0x2584, 0xa6, 0xcc, 0x2580, 0xd3, 0xdf, 0xd4, 0xd2, 0xf5, 0xd5,
  /* 230..239 */
  0xb5, 0xfe, 0xde, 0xda, 0xdb, 0xd9, 0xfd, 0xdd, 0xaf, 0xb4,
  /* 240..249 */
  0xad, 0xb1, 0x2017, 0xbe, 0xb6, 0xa7, 0xf7, 0xb8, 0xb0, 0xa8,
  /* 250..259 */
  0xb7, 0xb9, 0xb3, 0xb2, 0x25a0, 0xa0, 0x20a7, 0x2310, 0x2561, 0x2562,
  /* 260..269 */
  0x2556, 0x2555, 0x255c, 0x255b, 0x255e, 0x255f, 0x2567, 0x2568, 0x2564, 0x2565,
  /* 270..279 */
  0x2559, 0x2558, 0x2552, 0x2553, 0x256b, 0x256a, 0x258c, 0x2590, 0x3b1, 0x393,
  /* 280..289 */
  0x3c0, 0x3a3, 0x3c3, 0x3c4, 0x3a6, 0x398, 0x3a9, 0x3b4, 0x221e, 0x3c6,
  /* 290..299 */
  0x3b5, 0x2229, 0x2261, 0x2265, 0x2264, 0x2320, 0x2321, 0x2248, 0x2219, 0x221a,
  /* 300..309 */
  0x207f, 0x2c9, 0x2d8, 0x2d9, 0x2da, 0x2dd, 0x2db, 0x2c7, 0x2018, 0x2019,
  /* 310..318*/
  0x201c, 0x201d, 0x2013, 0x2014, 0x2c6, 0x2dc, 0x201a, 0x201e, 0x2026,

  /* 319..329 */
  0x2020, 0x2021, 0x2c6, 0x2030, 0x160, 0x2039, 0x152, 0x303, 0x2122, 0x161, 0x203a,
  /* 330..339 */
  0x153, 0x178, 0x11f, 0x11e, 0x130, 0x15f, 0x15e, 0x103, 0x102, 0x105,
  /* 340..349 */
  0x104, 0x107, 0x106, 0x10d, 0x10c, 0x10f, 0x10e, 0x111, 0x11b, 0x11a,
  /* 350..359 */
  0x119, 0x118, 0x13a, 0x139, 0x13e, 0x13d, 0x142, 0x141, 0x144, 0x143,
  /* 360..369 */
  0x148, 0x147, 0x151, 0x150, 0x155, 0x154, 0x159, 0x158, 0x15b, 0x15a,
  /* 370..379 */
  0x165, 0x164, 0x163, 0x162, 0x171, 0x170, 0x16f, 0x16e, 0x17a, 0x179,
  /* 380..383 */
  0x17e, 0x17d, 0x17c, 0x17b,

  /* I don't know whether the following are used by PM, but they are in
     the I18N unicode library */
  /* yes they ARE used (for Cyrillic systems)  */

  /* 384..389 */
  0x401, 0x402, 0x403, 0x404, 0x405, 0x406,
  /* 390..399 */
  0x407, 0x408, 0x409, 0x40a, 0x40b, 0x40c, 0x40e, 0x40f, 0x410, 0x411,
  /* 400..409 */
  0x412, 0x413, 0x414, 0x415, 0x416, 0x417, 0x418, 0x419, 0x41a, 0x41b,
  /* 410..419 */
  0x41c, 0x41d, 0x41e, 0x41f, 0x420, 0x421, 0x422, 0x423, 0x424, 0x425,
  /* 420..429 */
  0x426, 0x427, 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
  /* 430..439 */
  0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437, 0x438, 0x439,
  /* 440..449 */
  0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f, 0x440, 0x441, 0x442, 0x443,
  /* 450..459 */
  0x444, 0x445, 0x446, 0x447, 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d,
  /* 460..469 */
  0x44e, 0x44f, 0x2116, 0x451, 0x452, 0x453, 0x454, 0x455, 0x456, 0x457,
  /* 470..479 */
  0x458, 0x459, 0x45a, 0x45b, 0x45c, 0x45e, 0x45f, 0x490, 0x491, 0x156,
  /* 480..489 */
  0x12e, 0x100, 0x112, 0x116, 0x122, 0x136, 0x12a, 0x1eb, 0x145, 0x14c,
  /* 490..499 */
  0x172, 0x16a, 0x157, 0x12f, 0x101, 0x113, 0x117, 0x123, 0x137, 0x12b,
  /* 500..504 */
  0x13c, 0x146, 0x14d, 0x173, 0x16b

#if MAX_GLYPH > 504
  , 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 510..519 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 520..529 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 530..539 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 540..549 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 550..559 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 560..569 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 570..579 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 580..589 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 590..599 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 600..609 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 610..619 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 620..629 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 630..639 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 640..649 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 650..659 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 660..669 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 670..679 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 680..689 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 690..699 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 700..709 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 710..719 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 720..729 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 730..739 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 740..749 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 750..759 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 760..769 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x303f, 0x21b5,
  /* 770..779 */
  0x3002, 0x300c, 0x300d, 0x3001, 0x0000, 0x30f2, 0x30a1, 0x30a3, 0x30a5, 0x30a7,
  /* 780..789 */
  0x30a9, 0x30e3, 0x30e5, 0x30e7, 0x30c3, 0x30fc, 0x30a2, 0x30a4, 0x30a6, 0x30a8,
  /* 790..799 */
  0x30aa, 0x30ab, 0x30ad, 0x30af, 0x30b1, 0x30b3, 0x30b5, 0x30b7, 0x30b9, 0x30bb,
  /* 800..809 */
  0x30bd, 0x30bf, 0x30c1, 0x30c4, 0x30c6, 0x30c8, 0x30ca, 0x30cb, 0x30cc, 0x30cd,
  /* 810..819 */
  0x30ce, 0x30cf, 0x30d2, 0x30d5, 0x30d8, 0x30db, 0x30de, 0x30df, 0x30e0, 0x30e1,
  /* 820..829 */
  0x30e2, 0x30e4, 0x30e6, 0x30e8, 0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ef,
  /* 830..839 */
  0x30f3, 0x309b, 0x309c, 0x3041, 0x3043, 0x3045, 0x3047, 0x3049, 0x3083, 0x3085,
  /* 840..849 */
  0x3049, 0x3063, 0x3042, 0x3044, 0x3046, 0x3048, 0x304a, 0x304b, 0x304d, 0x304f,
  /* 850..859 */
  0x3051, 0x3053, 0x3055, 0x3057, 0x3059, 0x305b, 0x305d, 0x305f, 0x3061, 0x3064,
  /* 860..869 */
  0x3066, 0x3068, 0x306a, 0x306b, 0x306c, 0x306d, 0x306e, 0x306f, 0x3072, 0x3075,
  /* 870..879 */
  0x3078, 0x307b, 0x307e, 0x307f, 0x3080, 0x3081, 0x3082, 0x3084, 0x3086, 0x3088,
  /* 880..889 */
  0x3089, 0x308a, 0x308b, 0x308c, 0x308d, 0x308f, 0x3092, 0x3093, 0x300e, 0x300f,
  /* 890..899 */
  0x30f6, 0x3005, 0x0000, 0x0000, 0x0000, 0x0000, 0x3131, 0x3132, 0x3133, 0x3134,
  /* 900..909 */
  0x3135, 0x3136, 0x3137, 0x3138, 0x3139, 0x313a, 0x313b, 0x313c, 0x313d, 0x313e,
  /* 910..919 */
  0x313f, 0x3140, 0x3141, 0x3142, 0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148,
  /* 920..929 */
  0x3149, 0x314a, 0x314b, 0x314c, 0x314d, 0x314e, 0x314f, 0x3150, 0x3151, 0x3152,
  /* 930..939 */
  0x3153, 0x3154, 0x3155, 0x3156, 0x3157, 0x3158, 0x3159, 0x315a, 0x315b, 0x315c,
  /* 940..949 */
  0x315d, 0x315e, 0x315f, 0x3160, 0x3161, 0x3162, 0x3163, 0x20a9, 0x0000, 0x3164,
  /* 950..959 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 960..969 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 970..979 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 980..989 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 990..999 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 1000..1009 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 1010..1019 */
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  /* 1020..1023 */
  0x0000, 0x0000, 0x0000, 0x0000
#endif /* MAX_GLYHP > 504 */
};


/* on Greek systems, the UGL is a bit different */
/* and changes the entries 319-383 inclusive    */

/* # of Greek glyphs in UGL */
#define GREEK_GLYPHS   65
/* start of Greek glyphs in UGL */
#define GREEK_START    319

static const int SubUGLGreek[GREEK_GLYPHS] = {
   /* 319..328 */
   0x0391, 0x0392, 0x0395, 0x0396, 0x0397, 0x0399, 0x039a, 0x039c, 0x039d, 0x039f,
   /* 329..338 */
   0x03a1, 0x03a4, 0x03a5, 0x03a7, 0x03b7, 0x03bd, 0x03c7, 0x03bf, 0x0384, 0x0308,
   /* 339..348 */
   0x0385, 0x0390, 0x0020, 0x00A6, 0x0386, 0x0388, 0x0389, 0x038a, 0x038c, 0x038e,
   /* 349..358 */
   0x038f, 0x0394, 0x0398, 0x039b, 0x039e, 0x03a0, 0x03a8, 0x03aa, 0x03ab, 0x03ac,
   /* 359..368 */
   0x03ad, 0x03ae, 0x03af, 0x03b0, 0x03b2, 0x03b3, 0x03b6, 0x03b8, 0x03b9, 0x03ba,
   /* 369..378 */
   0x03bb, 0x03bc, 0x03be, 0x03c1, 0x03c2, 0x03c5, 0x03c6, 0x03c8, 0x03c9, 0x03ca,
   /* 379..383 */
   0x03cb, 0x03cc, 0x03cd, 0x03ce, 0x0000
};
#endif  /* USE_UCONV */

#endif /* _FTIFI_H_INCLUDED_ */
