/*
Gnusniff - Network packet sniffer
Copyright (C) 1998 Peter Hawkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _HOSTS_H_
#define _HOSTS_H_

#include "config.h"
#include <pthread.h>
#include <net/if.h>
#include <glib.h>
#include "utils.h"
#include "consts.h"

typedef struct _host_t {
 struct _host_t *next;
 struct sockaddr address;
 char hwaddress[64];
 char hostname[256];
 char swaddress[ADDRESS_STRING_LENGTH];
 GList *packets;
// u_int received, sent;
 int status; // 0 = host not looked up yet, 1 = host looked up but not display, 2 = host displayed
 pthread_t thread;
 pthread_mutex_t mutex; // Mutex on the hostname[] field
} host_t;

struct packet_t;

host_t *addaddrtohost(host_t *node, struct sockaddr *addr);
host_t *gethostforaddr(struct packet_t *pkt, struct sockaddr *addr);
host_t *gethostforhwaddr(struct packet_t *pkt, char *hwaddr, u_int len);
void lookuphost(host_t *host);
#endif
